/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CheckAllUIDReferencesResolve {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/CheckAllUIDReferencesResolve.java,v 1.12 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(CheckAllUIDReferencesResolve.class);
    private SetOfDicomFiles dicomFilesRead = new SetOfDicomFiles();
    private Map<String, SetOfDicomFiles.DicomFile> mapOfSOPInstanceUIDToDicomFile = new HashMap<String, SetOfDicomFiles.DicomFile>();

    public CheckAllUIDReferencesResolve(String[] stringArray) throws FileNotFoundException, IOException, DicomException {
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        for (String object : stringArray) {
            ourMediaImporter.importDicomFiles(object);
        }
        for (SetOfDicomFiles.DicomFile dicomFile : this.dicomFilesRead) {
            AttributeList attributeList = dicomFile.getAttributeList();
            Set<String> set = attributeList.findAllNestedReferencedSOPInstanceUIDs();
            for (String string : set) {
                if (this.mapOfSOPInstanceUIDToDicomFile.get(string) != null) continue;
                slf4jlogger.info("In file {} was a reference to SOP Instance UID {} that is not present in the set of files", dicomFile.getFileName(), string);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                new CheckAllUIDReferencesResolve(stringArray);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.CheckAllUIDReferencesResolve srcdir|DICOMDIR [srcdir|DICOMDIR]*");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                SetOfDicomFiles.DicomFile dicomFile = CheckAllUIDReferencesResolve.this.dicomFilesRead.add(string, true, false);
                AttributeList attributeList = dicomFile.getAttributeList();
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
                if (string2.length() <= 0) {
                    throw new DicomException("No SOP Instance UID in file " + string);
                }
                CheckAllUIDReferencesResolve.this.mapOfSOPInstanceUIDToDicomFile.put(string2, dicomFile);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {} exception ", string, exception);
            }
        }
    }
}

