/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class ConvertPlanarConfiguration {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/ConvertPlanarConfiguration.java,v 1.16 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ConvertPlanarConfiguration.class);

    public ConvertPlanarConfiguration(String string, String string2) throws DicomException, FileNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        AttributeList attributeList = new AttributeList();
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
        attributeList.read(dicomInputStream);
        dicomInputStream.close();
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 0);
        if (n7 != 8) {
            throw new DicomException("Input image does not have 8 bits per sample");
        }
        int n8 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 0);
        if (n8 <= 1) {
            throw new DicomException("Input image does not have more than one sample per pixel");
        }
        int n9 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PlanarConfiguration, -1);
        if (n9 < 0 || n9 > 1) {
            throw new DicomException("Input image has missing or invalid planar configuration");
        }
        boolean bl = n9 == 0;
        int n10 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n11 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n12 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n13 = n12 * n11;
        int n14 = n13 * n8;
        int n15 = n14 * n10;
        byte[] byArray = null;
        Object object = attributeList.getPixelData();
        if (ValueRepresentation.isOtherByteVR(((Attribute)object).getVR())) {
            byArray = ((Attribute)object).getByteValues();
        } else {
            short[] sArray = ((Attribute)object).getShortValues();
            byArray = new byte[n15];
            n6 = n15 / 2;
            n5 = 0;
            n4 = 0;
            while (n5 < n6) {
                n3 = sArray[n5++] & 0xFFFF;
                n2 = n3 & 0xFF;
                byArray[n4++] = (byte)n2;
                n = n3 >> 8 & 0xFF;
                byArray[n4++] = (byte)n;
            }
        }
        object = new byte[n15];
        int n16 = 0;
        for (n6 = 0; n6 < n10; ++n6) {
            for (n5 = 0; n5 < n13; ++n5) {
                for (n4 = 0; n4 < n8; ++n4) {
                    n3 = n16 + n5 * n8 + n4;
                    n2 = n16 + n5 + n13 * n4;
                    n = bl ? n3 : n2;
                    int n17 = bl ? n2 : n3;
                    object[n17] = byArray[n];
                }
            }
            n16 += n14;
        }
        OtherByteAttribute otherByteAttribute = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)otherByteAttribute).setValues((byte[])object);
        attributeList.put(otherByteAttribute);
        UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
        ((Attribute)unsignedShortAttribute).addValue(bl ? 1 : 0);
        attributeList.put(unsignedShortAttribute);
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.ConvertPlanarConfiguration.main()", null, VersionAndConstants.getBuildDate(), "Converted color-by-" + (bl ? "pixel" : "plane") + " to color-by-" + (bl ? "plane" : "pixel"));
        attributeList.removeMetaInformationHeaderAttributes();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                new ConvertPlanarConfiguration(stringArray[0], stringArray[1]);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: ConvertPlanarConfiguration inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

