/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.CodingSchemeIdentification;
import com.pixelmed.dicom.CompositeInstanceContext;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MergeCompositeContextForOneEntitySelectively {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/MergeCompositeContextForOneEntitySelectively.java,v 1.14 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(MergeCompositeContextForOneEntitySelectively.class);
    protected String ourAETitle = "OURAETITLE";
    protected String dstFolderName;
    protected CompositeInstanceContext.Selector selector;
    CompositeInstanceContext mergedContext = null;

    protected boolean isNonZeroLengthDummyValue(String string) {
        return string.equals("DUMMY");
    }

    protected CompositeInstanceContext mergeSelectedContext(CompositeInstanceContext compositeInstanceContext) {
        if (this.mergedContext == null) {
            this.mergedContext = compositeInstanceContext;
        } else {
            AttributeList attributeList = this.mergedContext.getAttributeList();
            for (Attribute attribute : compositeInstanceContext.getAttributeList().values()) {
                AttributeTag attributeTag = attribute.getTag();
                String string = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
                String string2 = attribute.getSingleStringValueOrEmptyString();
                if (string2.equals(string)) continue;
                String string3 = attributeTag + " " + attributeList.getDictionary().getFullNameFromTag(attributeTag);
                slf4jlogger.info("mergeSelectedContext(): for " + string3 + " values differ between existing merged value <" + string + "> and new value <" + string2 + ">");
                if (string2.length() <= 0 || string.length() != 0 && !this.isNonZeroLengthDummyValue(string)) continue;
                slf4jlogger.info("mergeSelectedContext(): for " + string3 + " replacing absent/empty/dummy existing merged value with new value <" + string2 + ">");
                attributeList.put(attribute);
            }
        }
        return this.mergedContext;
    }

    public MergeCompositeContextForOneEntitySelectively(CompositeInstanceContext.Selector selector, String string, String string2, MessageLogger messageLogger) throws IOException, DicomException {
        this.selector = selector;
        this.dstFolderName = string2;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        ourFirstPassMediaImporter.importDicomFiles(string);
        if (this.mergedContext != null) {
            this.mergedContext.removeAllButSelected(selector);
        }
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        ourSecondPassMediaImporter.importDicomFiles(string);
    }

    public MergeCompositeContextForOneEntitySelectively(CompositeInstanceContext.Selector selector, String[] stringArray, String string, MessageLogger messageLogger) throws IOException, DicomException {
        this.selector = selector;
        this.dstFolderName = string;
        OurFirstPassMediaImporter ourFirstPassMediaImporter = new OurFirstPassMediaImporter(messageLogger);
        for (String string2 : stringArray) {
            ourFirstPassMediaImporter.importDicomFiles(string2);
        }
        if (this.mergedContext != null) {
            this.mergedContext.removeAllButSelected(selector);
        }
        OurSecondPassMediaImporter ourSecondPassMediaImporter = new OurSecondPassMediaImporter(messageLogger);
        for (String string3 : stringArray) {
            ourSecondPassMediaImporter.importDicomFiles(string3);
        }
    }

    public static void main(String[] stringArray) {
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            CompositeInstanceContext.Selector selector = new CompositeInstanceContext.Selector(stringArray, arrayList);
            if (stringArray.length == arrayList.size()) {
                selector.patient = true;
            }
            if (arrayList.size() == 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                new MergeCompositeContextForOneEntitySelectively(selector, arrayList.get(0), arrayList.get(1), (MessageLogger)printStreamMessageLogger);
            } else if (arrayList.size() > 2) {
                PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
                int n = arrayList.size() - 1;
                String string = arrayList.get(n);
                arrayList.remove(n);
                String[] stringArray2 = new String[n];
                stringArray2 = arrayList.toArray(stringArray2);
                new MergeCompositeContextForOneEntitySelectively(selector, stringArray2, string, (MessageLogger)printStreamMessageLogger);
            } else {
                System.err.println("Usage: java -cp ./pixelmed.jar com.pixelmed.apps.MergeCompositeContextForOneEntitySelectively [-patient|-study|-equipment|-frameofreference|-series|-instance|srdocumentgeneral]* srcdir|DICOMDIR [srcdir|DICOMDIR]* dstdir");
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurSecondPassMediaImporter
    extends MediaImporter {
        public OurSecondPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                if (MergeCompositeContextForOneEntitySelectively.this.mergedContext == null) {
                    throw new DicomException("Missing group context for SOPInstanceUID on second pass");
                }
                attributeList.putAll(MergeCompositeContextForOneEntitySelectively.this.mergedContext.getAttributeList());
                ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109103", "DCM", "Modifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.apps.MergeCompositeContextForOneEntitySelectively", null, "Vers. " + VersionAndConstants.getBuildDate(), "Merged patient context");
                CodingSchemeIdentification.replaceCodingSchemeIdentificationSequenceWithCodingSchemesUsedInAttributeList(attributeList);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                attributeList.remove(TagFromName.DataSetTrailingPadding);
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", MergeCompositeContextForOneEntitySelectively.this.ourAETitle);
                File file = new File(MergeCompositeContextForOneEntitySelectively.this.dstFolderName, MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList));
                if (file.exists()) {
                    throw new DicomException("\"" + string + "\": new file \"" + file + "\" already exists - not overwriting");
                }
                File file2 = file.getParentFile();
                if (!file2.exists() && !file2.mkdirs()) {
                    throw new DicomException("\"" + string + "\": parent directory creation failed for \"" + file + "\"");
                }
                slf4jlogger.info("Writing with new context file {}", file);
                attributeList.write(file, "1.2.840.10008.1.2.1", true, true);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }

    protected class OurFirstPassMediaImporter
    extends MediaImporter {
        public OurFirstPassMediaImporter(MessageLogger messageLogger) {
            super(messageLogger);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                CompositeInstanceContext compositeInstanceContext = new CompositeInstanceContext(attributeList, false);
                compositeInstanceContext.removeAllButSelected(MergeCompositeContextForOneEntitySelectively.this.selector);
                MergeCompositeContextForOneEntitySelectively.this.mergeSelectedContext(compositeInstanceContext);
            }
            catch (Exception exception) {
                slf4jlogger.error("File {}", string, exception);
            }
        }
    }
}

