/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.PrintStreamMessageLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PseudonymizeAndSequester {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/PseudonymizeAndSequester.java,v 1.17 2025/01/29 10:58:05 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(PseudonymizeAndSequester.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    protected static String ourCalledAETitle = "OURAETITLE";
    protected static int radixForRandomPseudonymousID = 36;
    protected static Date epochForDateModification;
    protected static Date defaultEarliestDateInSet;
    protected Map<String, String> newPatientIDByOriginalPatientID = new HashMap<String, String>();
    protected Map<String, String> newPatientIDByOriginalStudyInstanceUID = new HashMap<String, String>();
    protected Map<String, String> newPatientNameByNewPatientID = new HashMap<String, String>();
    protected Map<String, Date> earliestDateByOrignalPatientID = new HashMap<String, Date>();
    protected Random random;

    protected static String makeOutputFileName(String string, String string2, String string3) throws IOException {
        return new File(string, (string3 == null || string3.length() == 0 ? "NOSOPINSTANCEUID" : string3) + "_Anon.dcm").getCanonicalPath();
    }

    protected void readPseudonymizationControlFile(String string) throws IOException {
        boolean bl = false;
        boolean bl2 = false;
        if (string != null && string.length() > 0) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                Pattern pattern = Pattern.compile("(.*)\t(.*)\t(.*)");
                Matcher matcher = pattern.matcher(string2);
                if (matcher.matches()) {
                    slf4jlogger.trace("readPseudonymizationControlFile(): have match");
                    int n = matcher.groupCount();
                    if (n == 3) {
                        String string3;
                        String string4;
                        String string5;
                        slf4jlogger.trace("readPseudonymizationControlFile(): have correct groupCount");
                        if (matcher.group(1).equals("originalPatientID")) {
                            bl = true;
                            continue;
                        }
                        if (matcher.group(1).equals("originalStudyInstanceUID")) {
                            bl2 = true;
                            continue;
                        }
                        if (bl) {
                            string5 = matcher.group(1);
                            string4 = matcher.group(2);
                            string3 = matcher.group(3);
                            slf4jlogger.debug("readPseudonymizationControlFile(): found values {},{},{}", string5, string4, string3);
                            if (string5.length() > 0 && string4.length() > 0 && string3.length() > 0) {
                                this.newPatientIDByOriginalPatientID.put(string5, string4);
                                this.newPatientNameByNewPatientID.put(string4, string3);
                                continue;
                            }
                            slf4jlogger.warn("readPseudonymizationControlFile(): not adding - empty components in line {}", string2);
                            continue;
                        }
                        if (bl2) {
                            string5 = matcher.group(1);
                            string4 = matcher.group(2);
                            string3 = matcher.group(3);
                            slf4jlogger.debug("readPseudonymizationControlFile(): found values {},{},{}", string5, string4, string3);
                            if (string5.length() > 0 && string4.length() > 0 && string3.length() > 0) {
                                this.newPatientIDByOriginalStudyInstanceUID.put(string5, string4);
                                this.newPatientNameByNewPatientID.put(string4, string3);
                                continue;
                            }
                            slf4jlogger.warn("readPseudonymizationControlFile(): not adding - empty components in line {}", string2);
                            continue;
                        }
                        slf4jlogger.error("readPseudonymizationControlFile(): Unrecognized pattern in control file in line {}", string2);
                        continue;
                    }
                    slf4jlogger.warn("readPseudonymizationControlFile(): bad groupCount in line {}", string2);
                    continue;
                }
                slf4jlogger.warn("readPseudonymizationControlFile(): no pattern match for line {}", string2);
            }
            bufferedReader.close();
        }
    }

    protected String createNewPseudonymousPatientAndAddToMaps(String string, String string2) {
        slf4jlogger.debug("createNewPseudonymousPatientAndAddToMaps for {}", string);
        String string3 = Integer.toString(this.random.nextInt(Integer.MAX_VALUE), radixForRandomPseudonymousID).toUpperCase();
        String string4 = "Nobody^" + string3;
        this.newPatientIDByOriginalPatientID.put(string, string3);
        this.newPatientIDByOriginalStudyInstanceUID.put(string2, string3);
        this.newPatientNameByNewPatientID.put(string3, string4);
        return string3;
    }

    protected void writePseudonymizationResultByOriginalPatientID(PrintWriter printWriter) {
        if (!this.newPatientIDByOriginalPatientID.isEmpty()) {
            printWriter.print("originalPatientID");
            printWriter.print("\t");
            printWriter.print("newPatientID");
            printWriter.print("\t");
            printWriter.println("newPatientName");
            for (String string : this.newPatientIDByOriginalPatientID.keySet()) {
                String string2 = this.newPatientIDByOriginalPatientID.get(string);
                String string3 = this.newPatientNameByNewPatientID.get(string2);
                printWriter.print(string);
                printWriter.print("\t");
                printWriter.print(string2);
                printWriter.print("\t");
                printWriter.println(string3);
            }
        }
    }

    protected void writePseudonymizationResultByOriginalStudyInstanceUID(PrintWriter printWriter) {
        if (!this.newPatientIDByOriginalStudyInstanceUID.isEmpty()) {
            printWriter.print("originalStudyInstanceUID");
            printWriter.print("\t");
            printWriter.print("newPatientID");
            printWriter.print("\t");
            printWriter.println("newPatientName");
            for (String string : this.newPatientIDByOriginalStudyInstanceUID.keySet()) {
                String string2 = this.newPatientIDByOriginalStudyInstanceUID.get(string);
                String string3 = this.newPatientNameByNewPatientID.get(string2);
                printWriter.print(string);
                printWriter.print("\t");
                printWriter.print(string2);
                printWriter.print("\t");
                printWriter.println(string3);
            }
        }
    }

    protected void writeUIDMapResult(PrintWriter printWriter) {
        printWriter.print("originalUIDValue");
        printWriter.print("\t");
        printWriter.println("replacementUIDValue");
        Map<String, String> map = ClinicalTrialsAttributes.getMapOfOriginalToReplacementUIDs();
        for (String string : map.keySet()) {
            String string2 = map.get(string);
            printWriter.print(string);
            printWriter.print("\t");
            printWriter.println(string2);
        }
    }

    protected static boolean containsOverlay(AttributeList attributeList) {
        boolean bl = false;
        for (Attribute attribute : attributeList.values()) {
            if (!attribute.getTag().isOverlayGroup()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static boolean isDirty(AttributeList attributeList) {
        boolean bl = false;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.BurnedInAnnotation);
        if (string.equals("YES")) {
            bl = true;
        } else {
            String string2 = Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.ImageType).toUpperCase();
            if (string2.contains("DERIVED") || string2.contains("SECONDARY") && !string2.equals("ORIGINAL\\SECONDARY\\AXIAL") || string2.contains("SCREEN")) {
                bl = true;
            } else {
                String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
                if (SOPClass.isSecondaryCaptureImageStorage(string3) || SOPClass.isNonImageStorage(string3) || SOPClass.isPrivateImageStorage(string3) || string3.equals("1.2.840.10008.5.1.4.1.1.6.1") || string3.equals("1.2.840.10008.5.1.4.1.1.6") || string3.equals("1.2.840.10008.5.1.4.1.1.12.1") || string3.equals("1.2.840.10008.5.1.4.1.1.12.3") || string3.equals("1.2.840.10008.5.1.4.1.1.12.1.1") || string3.equals("1.2.840.10008.5.1.4.1.1.13.1.1") || string3.equals("1.2.840.10008.5.1.4.1.1.12.2") || string3.equals("1.2.840.10008.5.1.4.1.1.12.2.1")) {
                    bl = true;
                } else {
                    String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality).toUpperCase();
                    if (string4.equals("SR") || string4.equals("PR") || string4.equals("OT") || string4.equals("SC") || string4.equals("US") || string4.equals("XA") || string4.equals("XRF")) {
                        bl = true;
                    } else {
                        String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("DetectorType")).toUpperCase();
                        if (string5.equals("FILM")) {
                            bl = true;
                        } else if (PseudonymizeAndSequester.containsOverlay(attributeList) || attributeList.get(TagFromName.GraphicAnnotationSequence) != null) {
                            bl = true;
                        }
                    }
                }
            }
        }
        return bl;
    }

    public PseudonymizeAndSequester(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, int n2) throws DicomException, FileNotFoundException, IOException {
        PrintStreamMessageLogger printStreamMessageLogger = new PrintStreamMessageLogger(System.err);
        this.random = string9 != null && string9.length() > 0 ? new Random(Long.parseLong(string9)) : new Random();
        OurMediaImporter ourMediaImporter = new OurMediaImporter(printStreamMessageLogger, string, string2, string3, string4, string5, string6, string7, string8, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, n, n2);
        ourMediaImporter.importDicomFiles(string);
        ourMediaImporter.finish();
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            int n;
            int n2;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = true;
            boolean bl5 = true;
            boolean bl6 = true;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = true;
            int n3 = 0;
            int n4 = 0;
            String string = null;
            int n5 = n2 = 8;
            if (stringArray.length >= n2 + 1) {
                n = 0;
                object = new Scanner(stringArray[n2]);
                if (((Scanner)object).hasNextLong()) {
                    ((Scanner)object).nextLong();
                    int n6 = n = !((Scanner)object).hasNext() ? 1 : 0;
                }
                if (n != 0) {
                    string = stringArray[n2];
                    n5 = n2 + 1;
                }
            }
            if (stringArray.length >= n2 + 1) {
                block50: for (n = stringArray.length - 1; n >= n5; --n) {
                    switch (object = stringArray[n].trim().toUpperCase()) {
                        case "KEEPALLPRIVATE": {
                            bl2 = true;
                            continue block50;
                        }
                        case "KEEPSAFEPRIVATE": {
                            bl2 = false;
                            continue block50;
                        }
                        case "ADDCONTRIBUTINGEQUIPMENT": {
                            bl3 = true;
                            continue block50;
                        }
                        case "DONOTADDCONTRIBUTINGEQUIPMENT": {
                            bl3 = false;
                            continue block50;
                        }
                        case "KEEPDESCRIPTORS": {
                            bl4 = true;
                            continue block50;
                        }
                        case "DONOTKEEPDESCRIPTORS": {
                            bl4 = false;
                            continue block50;
                        }
                        case "KEEPSERIESDESCRIPTORS": {
                            bl5 = true;
                            continue block50;
                        }
                        case "DONOTKEEPSERIESDESCRIPTORS": {
                            bl5 = false;
                            continue block50;
                        }
                        case "KEEPPROTOCOLNAME": {
                            bl6 = true;
                            continue block50;
                        }
                        case "DONOTKEEPPROTOCOLNAME": {
                            bl6 = false;
                            continue block50;
                        }
                        case "KEEPPATIENTCHARACTERISTICS": {
                            bl7 = true;
                            continue block50;
                        }
                        case "DONOTKEEPPATIENTCHARACTERISTICS": {
                            bl7 = false;
                            continue block50;
                        }
                        case "KEEPDEVICEIDENTITY": {
                            bl8 = true;
                            continue block50;
                        }
                        case "DONOTKEEPDEVICEIDENTITY": {
                            bl8 = false;
                            continue block50;
                        }
                        case "KEEPINSTITUTIONIDENTITY": {
                            bl9 = true;
                            continue block50;
                        }
                        case "DONOTKEEPINSTITUTIONIDENTITY": {
                            bl9 = false;
                            continue block50;
                        }
                        case "KEEPDATES": {
                            n3 = 0;
                            continue block50;
                        }
                        case "MODIFYDATES": {
                            n3 = 2;
                            continue block50;
                        }
                        case "DONOTKEEPDATES": {
                            n3 = 1;
                            continue block50;
                        }
                        case "KEEPSTRUCTUREDCONTENT": {
                            n4 = 0;
                            continue block50;
                        }
                        case "MODIFYSTRUCTUREDCONTENT": {
                            n4 = 2;
                            continue block50;
                        }
                        case "DONOTKEEPSTRUCTUREDCONTENT": {
                            n4 = 1;
                            continue block50;
                        }
                        default: {
                            slf4jlogger.error("Unrecognized argument {}", object);
                            bl = true;
                        }
                    }
                }
            }
            if (!bl) {
                if (stringArray.length >= n2) {
                    new PseudonymizeAndSequester(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6], stringArray[7], string, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, n3, n4);
                } else {
                    bl = true;
                }
            }
            if (bl) {
                slf4jlogger.error("Usage: PseudonymizeAndSequester inputPath outputFolderClean outputFolderDirty pseudonymizationControlFile pseudonymizationResultByOriginalPatientIDFile pseudonymizationResultByOriginalStudyInstanceUIDFile failedFilesFile uidMapResultFile [seed] [KEEPALLPRIVATE|KEEPSAFEPRIVATE] [ADDCONTRIBUTINGEQUIPMENT|DONOTADDCONTRIBUTINGEQUIPMENT] [KEEPDESCRIPTORS|DONOTKEEPDESCRIPTORS] [KEEPSERIESDESCRIPTORS|DONOTKEEPSERIESDESCRIPTORS] [KEEPPROTOCOLNAME|DONOTKEEPPROTOCOLNAME] [KEEPPATIENTCHARACTERISTICS|DONOTKEEPPATIENTCHARACTERISTICS] [KEEPDEVICEIDENTITY|DONOTKEEPDEVICEIDENTITY] [KEEPINSTITUTIONIDENTITY|DONOTKEEPINSTITUTIONIDENTITY] [KEEPDATES|MODIFYDATES|DONOTKEEPDATES] [KEEPSTRUCTUREDCONTENT|MODIFYSTRUCTUREDCONTENT|DONOTKEEPSTRUCTUREDCONTENT]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    static {
        defaultEarliestDateInSet = epochForDateModification = new GregorianCalendar(2001, 0, 1).getTime();
    }

    protected class OurMediaImporter
    extends MediaImporter {
        String outputFolderCleanName;
        String outputFolderDirtyName;
        PrintWriter pseudonymizationResultByOriginalPatientIDWriter;
        PrintWriter pseudonymizationResultByOriginalStudyInstanceUIDWriter;
        PrintWriter failedFilesWriter;
        PrintWriter uidMapResultWriter;
        boolean keepAllPrivate;
        boolean addContributingEquipmentSequence;
        boolean keepDescriptors;
        boolean keepSeriesDescriptors;
        boolean keepProtocolName;
        boolean keepPatientCharacteristics;
        boolean keepDeviceIdentity;
        boolean keepInstitutionIdentity;
        int handleDates;
        int handleStructuredContent;

        public OurMediaImporter(MessageLogger messageLogger, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, int n, int n2) throws FileNotFoundException, IOException {
            super(messageLogger);
            this.outputFolderCleanName = string2;
            this.outputFolderDirtyName = string3;
            this.pseudonymizationResultByOriginalPatientIDWriter = new PrintWriter(new FileWriter(string5));
            this.pseudonymizationResultByOriginalStudyInstanceUIDWriter = new PrintWriter(new FileWriter(string6));
            this.failedFilesWriter = new PrintWriter(new FileWriter(string7));
            this.uidMapResultWriter = new PrintWriter(new FileWriter(string8));
            this.keepAllPrivate = bl;
            this.addContributingEquipmentSequence = bl2;
            this.keepDescriptors = bl3;
            this.keepSeriesDescriptors = bl4;
            this.keepProtocolName = bl5;
            this.keepPatientCharacteristics = bl6;
            this.keepDeviceIdentity = bl7;
            this.keepInstitutionIdentity = bl8;
            this.handleDates = n;
            this.handleStructuredContent = n2;
            PseudonymizeAndSequester.this.readPseudonymizationControlFile(string4);
        }

        protected void finish() throws IOException {
            slf4jlogger.info("OurMediaImporter.finish()");
            if (this.pseudonymizationResultByOriginalPatientIDWriter != null) {
                PseudonymizeAndSequester.this.writePseudonymizationResultByOriginalPatientID(this.pseudonymizationResultByOriginalPatientIDWriter);
                this.pseudonymizationResultByOriginalPatientIDWriter.close();
                this.pseudonymizationResultByOriginalPatientIDWriter = null;
            }
            if (this.pseudonymizationResultByOriginalStudyInstanceUIDWriter != null) {
                PseudonymizeAndSequester.this.writePseudonymizationResultByOriginalStudyInstanceUID(this.pseudonymizationResultByOriginalStudyInstanceUIDWriter);
                this.pseudonymizationResultByOriginalStudyInstanceUIDWriter.close();
                this.pseudonymizationResultByOriginalStudyInstanceUIDWriter = null;
            }
            if (this.failedFilesWriter != null) {
                this.failedFilesWriter.close();
                this.failedFilesWriter = null;
            }
            if (this.uidMapResultWriter != null) {
                PseudonymizeAndSequester.this.writeUIDMapResult(this.uidMapResultWriter);
                this.uidMapResultWriter.close();
                this.uidMapResultWriter = null;
            }
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string, String string2, String string3) {
            slf4jlogger.info("Processing {} Transfer Syntax {}", string, string2);
            try {
                Object object;
                File file = new File(string);
                DicomInputStream dicomInputStream = new DicomInputStream(file);
                AttributeList attributeList = new AttributeList();
                attributeList.setDecompressPixelData(false);
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                String string4 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TransferSyntaxUID, "1.2.840.10008.1.2.1");
                String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
                if (string5.length() == 0) {
                    throw new DicomException("Cannot pseudonymize file with empty or missing PatientID: " + string);
                }
                String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
                if (string6.length() == 0) {
                    throw new DicomException("Cannot pseudonymize file with empty or missing StudyInstanceUID: " + string);
                }
                Date date = PseudonymizeAndSequester.this.earliestDateByOrignalPatientID.get(string5);
                if (date == null && (date = ClinicalTrialsAttributes.findEarliestDateTime(attributeList)) != null) {
                    PseudonymizeAndSequester.this.earliestDateByOrignalPatientID.put(string5, date);
                }
                if (date == null) {
                    slf4jlogger.warn("Cannot get earliestDateInSet for {}", string);
                    date = defaultEarliestDateInSet;
                }
                String string7 = PseudonymizeAndSequester.isDirty(attributeList) ? this.outputFolderDirtyName : this.outputFolderCleanName;
                attributeList.removeGroupLengthAttributes();
                attributeList.removeMetaInformationHeaderAttributes();
                ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, this.keepDescriptors, this.keepSeriesDescriptors, this.keepProtocolName, this.keepPatientCharacteristics, this.keepDeviceIdentity, this.keepInstitutionIdentity, this.handleDates, epochForDateModification, date, this.handleStructuredContent);
                String string8 = PseudonymizeAndSequester.this.newPatientIDByOriginalPatientID.get(string5);
                if (string8 == null) {
                    string8 = PseudonymizeAndSequester.this.newPatientIDByOriginalStudyInstanceUID.get(string6);
                    if (string8 == null) {
                        string8 = PseudonymizeAndSequester.this.createNewPseudonymousPatientAndAddToMaps(string5, string6);
                    } else {
                        slf4jlogger.debug("Found patient match on original StudyInstanceUID");
                    }
                } else {
                    slf4jlogger.debug("Found patient match on original PatientID");
                }
                Attribute attribute = new LongStringAttribute(TagFromName.PatientID);
                attribute.addValue(string8);
                attributeList.put(attribute);
                attribute = new PersonNameAttribute(TagFromName.PatientName);
                attribute.addValue(PseudonymizeAndSequester.this.newPatientNameByNewPatientID.get(string8));
                attributeList.put(attribute);
                attribute = attributeList.get(TagFromName.DeidentificationMethod);
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence);
                if (this.keepAllPrivate) {
                    attribute.addValue("All private retained");
                    sequenceAttribute.addItem(new CodedSequenceItem("210002", "99PMP", "Retain all private elements").getAttributeList());
                } else {
                    attributeList.removeUnsafePrivateAttributes();
                    attribute.addValue("Unsafe private removed");
                    sequenceAttribute.addItem(new CodedSequenceItem("113111", "DCM", "Retain Safe Private Option").getAttributeList());
                }
                ClinicalTrialsAttributes.remapUIDAttributes(attributeList);
                attribute.addValue("UIDs remapped");
                Object object2 = sequenceAttribute.iterator();
                while (object2.hasNext()) {
                    CodedSequenceItem codedSequenceItem;
                    object = object2.next();
                    if (object == null || (codedSequenceItem = new CodedSequenceItem(((SequenceItem)object).getAttributeList())) == null) continue;
                    String string9 = codedSequenceItem.getCodeValue();
                    String string10 = codedSequenceItem.getCodingSchemeDesignator();
                    if (string9 == null || !string9.equals("113110") || string10 == null || !string10.equals("DCM")) continue;
                    object2.remove();
                }
                sequenceAttribute.addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
                if (this.addContributingEquipmentSequence) {
                    ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, ourCalledAETitle, "PseudonymizeAndSequester.main()", null, VersionAndConstants.getBuildDate(), "Deidentified and Pseudonymized");
                }
                FileMetaInformation.addFileMetaInformation(attributeList, string4, ourCalledAETitle);
                attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                object2 = new File(PseudonymizeAndSequester.makeOutputFileName(string7, string, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID)));
                attributeList.write((File)object2, string4, true, true);
                slf4jlogger.info("Deidentified {} into {}", string, ((File)object2).getCanonicalPath());
                object = new MoveDicomFilesIntoHierarchy().renameFileWithHierarchicalPathFromAttributes((File)object2, attributeList, string7, "DUP", 2);
                slf4jlogger.info("Moved deidentified {} into {}", ((File)object2).getCanonicalPath(), object);
            }
            catch (Exception exception) {
                slf4jlogger.error("Failed to process " + string + " ", exception);
                this.failedFilesWriter.println(string);
            }
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && string2 != null;
        }
    }
}

