/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.MinimalPatientStudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.AnyExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.network.Association;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.GetSOPClassSCU;
import com.pixelmed.network.IdentifierHandler;
import com.pixelmed.network.MoveSOPClassSCU;
import com.pixelmed.network.NetworkConfigurationFromMulticastDNS;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.UnencapsulatedExplicitStorePresentationContextSelectionPolicy;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;

public class SynchronizeFromRemoteSCP {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/SynchronizeFromRemoteSCP.java,v 1.31 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SynchronizeFromRemoteSCP.class);
    private static int sleepTimeBetweenCheckingForNothingExpectedBeforeExiting = 10000;
    private static int sleepTimeAfterRegisteringWithBonjour = 10000;
    private static int inactivityTimeOut = 600000;
    private DatabaseInformationModel databaseInformationModel;
    private File savedInstancesFolder;
    private String remoteHost;
    private int remotePort;
    private String remoteAE;
    private int localPort;
    private String localAE;
    private String[] patientNameQueryPatterns;
    private QueryInformationModel queryInformationModel;
    private ReceivedObjectHandler receivedObjectHandler;
    private IdentifierHandler identifierHandler;
    private boolean useGet;
    private boolean queryAll;
    private boolean retrieveStudy;
    private Set setofInstancesExpected;
    private Set setofClassesExpected;
    private int numberOfSOPInstancesReceived;
    private int numberOfValidSOPInstancesReceived;
    private int numberOfUnrequestedSOPInstancesReceived;
    private long inactivityTime;
    private long totalDurationOfRetrieval;
    private long totalBytesSaved;
    private DecimalFormat commaFormatter = new DecimalFormat("#,###");
    protected static final AttributeList.ReadTerminationStrategy terminateAfterRelationshipGroup = new OurReadTerminationStrategy();
    long bytesSaved;

    private void walkTreeDownToInstanceLevelAndRetrieve(QueryTreeRecord queryTreeRecord, AttributeList attributeList, boolean bl, boolean bl2) throws DicomException, DicomNetworkException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        InformationEntity informationEntity = queryTreeRecord.getInformationEntity();
        Attribute attribute = queryTreeRecord.getUniqueKey();
        AttributeList attributeList2 = null;
        AttributeList attributeList3 = null;
        ArrayList arrayList = null;
        slf4jlogger.trace("Processing node {}", queryTreeRecord);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("walkTreeDownToInstanceLevelAndRetrieve(): getAllAttributesReturnedInIdentifier() =\n{}", queryTreeRecord.getAllAttributesReturnedInIdentifier());
        }
        if (informationEntity != null && attribute != null) {
            attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
            }
            AttributeTag attributeTag = this.queryInformationModel.getUniqueKeyForInformationEntity(informationEntity);
            object4 = attribute.getSingleStringValueOrNull();
            if (object4 == null) {
                slf4jlogger.info("Could not get UID to use for Unique Key");
            } else {
                slf4jlogger.debug("Searching for existing records for {} {}", informationEntity, object4);
                arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(informationEntity, (String)object4);
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Found {} existing records", arrayList.size());
                }
                slf4jlogger.trace("retrieveDone {}", bl);
                object3 = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)object3).addValue((String)object4);
                attributeList2.put((Attribute)object3);
                slf4jlogger.trace("uniqueKeys:\n{}", attributeList2);
                if (!bl && arrayList.size() == 0) {
                    slf4jlogger.debug("No existing records for {} {}", informationEntity, object4);
                    if (slf4jlogger.isInfoEnabled()) {
                        slf4jlogger.info("Performing retrieve for {} ({})", queryTreeRecord, Attribute.getSingleStringValueOrEmptyString(queryTreeRecord.getUniqueKey()));
                    }
                    object3 = new SpecificCharacterSet((String[])null);
                    attributeList3 = new AttributeList();
                    attributeList3.putAll(attributeList2);
                    object2 = this.queryInformationModel.getQueryLevelName(informationEntity);
                    object = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
                    ((Attribute)object).addValue((String)object2);
                    attributeList3.put((Attribute)object);
                    slf4jlogger.debug("Retrieve identifier:\n{}", attributeList3);
                    bl = true;
                } else {
                    slf4jlogger.trace("Not adding anything to retrieveIdentifier");
                }
            }
        }
        slf4jlogger.trace("Process children if any, of node {},", queryTreeRecord);
        int n = queryTreeRecord.getChildCount();
        slf4jlogger.trace("Child node count {}", n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                object3 = (QueryTreeRecord)queryTreeRecord.getChildAt(i);
                if (object3 == null) continue;
                this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)object3, attributeList2, bl, bl2);
            }
        } else if (informationEntity != null && informationEntity.equals(InformationEntity.INSTANCE) && arrayList.size() == 0) {
            object4 = queryTreeRecord.getAllAttributesReturnedInIdentifier();
            slf4jlogger.trace("Adding to set to retrieve: getAllAttributesReturnedInIdentifier() =\n{}", object4);
            object3 = Attribute.getSingleStringValueOrNull((AttributeList)object4, TagFromName.SOPInstanceUID);
            slf4jlogger.trace("Adding to set to retrieve: SOPInstanceUID = {}", object3);
            this.setofInstancesExpected.add(object3);
            if (this.useGet) {
                object2 = Attribute.getSingleStringValueOrNull((AttributeList)object4, TagFromName.SOPClassUID);
                if (object2 == null || ((String)object2).length() == 0) {
                    slf4jlogger.info("Adding to set to retrieve: SOPClassUID is missing or empty in C-FIND response ... trying to guess an appropriate one to use for C-GET");
                    object = (QueryTreeRecord)queryTreeRecord.getParent();
                    QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)((QueryTreeRecord)object).getParent();
                    AttributeList attributeList4 = queryTreeRecord2.getAllAttributesReturnedInIdentifier();
                    Attribute attribute2 = attributeList4.get(TagFromName.SOPClassesInStudy);
                    if (attribute2 != null && attribute2.getVM() > 0) {
                        String[] stringArray;
                        for (String string : stringArray = attribute2.getStringValues()) {
                            slf4jlogger.debug("Adding to set to retrieve: SOPClassUID derived from SOPClassesInStudy = {}", string);
                            this.setofClassesExpected.add(string);
                        }
                    } else {
                        AttributeList attributeList5 = ((QueryTreeRecord)object).getAllAttributesReturnedInIdentifier();
                        String string = Attribute.getSingleStringValueOrEmptyString(attributeList5, TagFromName.Modality);
                        slf4jlogger.debug("Adding to set to retrieve: No SOPClassesInStudy either, trying Modality {}", string);
                        String[] stringArray = SOPClass.getPlausibleStandardSOPClassUIDsForModality(string);
                        if (stringArray.length > 0) {
                            for (String string2 : stringArray) {
                                slf4jlogger.debug("Adding to set to retrieve: SOPClassUID derived from Modality {} = {}", string, string2);
                                this.setofClassesExpected.add(string2);
                            }
                        } else {
                            slf4jlogger.debug("Adding to set to retrieve: all known storage SOP Classes");
                            this.setofClassesExpected = SOPClass.getSetOfStorageSOPClasses();
                        }
                    }
                } else {
                    slf4jlogger.debug("Adding to set to retrieve: SOPClassUID = {}", object2);
                    this.setofClassesExpected.add(object2);
                }
            }
        }
        if (attributeList3 == null) {
            slf4jlogger.debug("Not doing anything because retrieveIdentifier is null");
        } else {
            try {
                this.bytesSaved = 0L;
                long l = System.currentTimeMillis();
                if (this.useGet) {
                    slf4jlogger.info("Retrieving with C-GET");
                    object3 = bl2 ? new GetSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.3", attributeList3, this.identifierHandler, this.savedInstancesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, this.receivedObjectHandler, this.setofClassesExpected, 4, true, true, false) : new GetSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.3", attributeList3, this.identifierHandler, this.savedInstancesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, this.receivedObjectHandler, this.setofClassesExpected, false, true, true);
                    this.setofClassesExpected.clear();
                } else {
                    slf4jlogger.info("Retrieving with C-MOVE");
                    this.bytesSaved = 0L;
                    object3 = null;
                    object2 = this.queryInformationModel.getCMoveAssociation();
                    object3 = object2 != null ? new MoveSOPClassSCU((Association)object2, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", attributeList3) : new MoveSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", attributeList3);
                    int n2 = ((MoveSOPClassSCU)object3).getStatus();
                    if (n2 != 0) {
                        slf4jlogger.info("SynchronizeFromRemoteSCP: unsuccessful move status = 0x{}", Integer.toHexString(n2));
                    }
                }
                if (slf4jlogger.isInfoEnabled()) {
                    long l2 = System.currentTimeMillis() - l;
                    double d = l2 == 0L ? 0.0 : (double)this.bytesSaved / 1000000.0 / ((double)l2 / 1000.0);
                    slf4jlogger.info("Saved {} bytes in {} ms, {} MB/s", this.commaFormatter.format(this.bytesSaved), this.commaFormatter.format(l2), d);
                    this.totalDurationOfRetrieval += l2;
                    this.totalBytesSaved += this.bytesSaved;
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    private void performQueryAndWalkTreeDownToInstanceLevelAndRetrieve(boolean bl) throws DicomException, DicomNetworkException, IOException {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
        AttributeList attributeList = new AttributeList();
        attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
        attributeList.putNewAttribute(TagFromName.SeriesInstanceUID);
        attributeList.putNewAttribute(TagFromName.SOPInstanceUID);
        if (this.useGet) {
            attributeList.putNewAttribute(TagFromName.SOPClassesInStudy);
            attributeList.putNewAttribute(TagFromName.SOPClassUID);
        }
        attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.StudyDate);
        attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.SeriesNumber);
        attributeList.putNewAttribute(TagFromName.SeriesDescription, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.Modality);
        attributeList.putNewAttribute(TagFromName.InstanceNumber);
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{"A*", "B*", "C*", "D*", "E*", "F*", "G*", "H*", "I*", "J*", "K*", "L*", "M*", "N*", "O*", "P*", "Q*", "R*", "S*", "T*", "U*", "V*", "W*", "X*", "Y*", "Z*"};
        String[] stringArray3 = this.patientNameQueryPatterns == null ? (this.queryAll ? stringArray : stringArray2) : this.patientNameQueryPatterns;
        for (int i = 0; i < stringArray3.length; ++i) {
            slf4jlogger.debug("Query {}", stringArray3[i]);
            Object object = new PersonNameAttribute(TagFromName.PatientName, specificCharacterSet);
            ((Attribute)object).addValue(stringArray3[i]);
            attributeList.put((Attribute)object);
            object = this.queryInformationModel.performHierarchicalQuery(attributeList);
            this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)((QueryTreeModel)object).getRoot(), null, false, bl);
        }
    }

    private void performQueryAndStudyRetrieve(boolean bl) throws DicomException, DicomNetworkException, IOException {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
        AttributeList attributeList = new AttributeList();
        attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
        attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.StudyDate);
        attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
        attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
        String[] stringArray = new String[]{""};
        String[] stringArray2 = new String[]{"A*", "B*", "C*", "D*", "E*", "F*", "G*", "H*", "I*", "J*", "K*", "L*", "M*", "N*", "O*", "P*", "Q*", "R*", "S*", "T*", "U*", "V*", "W*", "X*", "Y*", "Z*"};
        String[] stringArray3 = this.patientNameQueryPatterns == null ? (this.queryAll ? stringArray : stringArray2) : this.patientNameQueryPatterns;
        for (int i = 0; i < stringArray3.length; ++i) {
            slf4jlogger.debug("Query {}", stringArray3[i]);
            Object object = new PersonNameAttribute(TagFromName.PatientName, specificCharacterSet);
            ((Attribute)object).addValue(stringArray3[i]);
            attributeList.put((Attribute)object);
            object = this.queryInformationModel.performHierarchicalQuery(attributeList);
            QueryTreeRecord queryTreeRecord = (QueryTreeRecord)((QueryTreeModel)object).getRoot();
            int n = queryTreeRecord.getChildCount();
            slf4jlogger.debug("Child node count {}", n);
            if (n <= 0) continue;
            for (int j = 0; j < n; ++j) {
                QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)queryTreeRecord.getChildAt(j);
                if (queryTreeRecord2 == null) continue;
                slf4jlogger.debug("Have child {}", queryTreeRecord2);
                InformationEntity informationEntity = queryTreeRecord2.getInformationEntity();
                Attribute attribute = queryTreeRecord2.getUniqueKey();
                AttributeTag attributeTag = this.queryInformationModel.getUniqueKeyForInformationEntity(informationEntity);
                String string = attribute.getSingleStringValueOrNull();
                if (string == null) {
                    slf4jlogger.debug("Could not get UID to use");
                    continue;
                }
                slf4jlogger.debug("Searching for existing records for {} {}", informationEntity, string);
                ArrayList arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(informationEntity, string);
                slf4jlogger.debug("Found {} existing records", arrayList.size());
                AttributeList attributeList2 = new AttributeList();
                Object object2 = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)object2).addValue(string);
                attributeList2.put((Attribute)object2);
                if (arrayList.size() == 0) {
                    slf4jlogger.debug("No existing records for {} {}", informationEntity, string);
                    slf4jlogger.info("Performing retrieve for {} ({})", queryTreeRecord2, Attribute.getSingleStringValueOrEmptyString(attribute));
                    object2 = new AttributeList();
                    ((TreeMap)object2).putAll(attributeList2);
                    String string2 = this.queryInformationModel.getQueryLevelName(informationEntity);
                    CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
                    ((Attribute)codeStringAttribute).addValue(string2);
                    ((AttributeList)object2).put(codeStringAttribute);
                    slf4jlogger.debug("Retrieve identifier:\n{}", object2);
                    try {
                        this.bytesSaved = 0L;
                        long l = System.currentTimeMillis();
                        slf4jlogger.info("Retrieving with C-MOVE");
                        MoveSOPClassSCU moveSOPClassSCU = null;
                        Association association = this.queryInformationModel.getCMoveAssociation();
                        moveSOPClassSCU = association != null ? new MoveSOPClassSCU(association, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", (AttributeList)object2) : new MoveSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", (AttributeList)object2);
                        int n2 = moveSOPClassSCU.getStatus();
                        if (n2 != 0 && slf4jlogger.isInfoEnabled()) {
                            slf4jlogger.info("SynchronizeFromRemoteSCP: unsuccessful move status = 0x{}", Integer.toHexString(n2));
                        }
                        if (!slf4jlogger.isInfoEnabled()) continue;
                        long l2 = System.currentTimeMillis() - l;
                        double d = l2 == 0L ? 0.0 : (double)this.bytesSaved / 1000000.0 / ((double)l2 / 1000.0);
                        slf4jlogger.info("Saved {} bytes in {} ms, {} MB/s", this.commaFormatter.format(this.bytesSaved), this.commaFormatter.format(l2), d);
                        this.totalDurationOfRetrieval += l2;
                        this.totalBytesSaved += this.bytesSaved;
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                    continue;
                }
                slf4jlogger.debug("Existing records for {} {} so retrieving nothing (NOT checking all series or instances)", informationEntity, string);
            }
        }
    }

    private void readPatientNameQueryPatternsFile(String string) throws IOException {
        List<String> list = Files.readAllLines(FileSystems.getDefault().getPath(string, new String[0]), StandardCharsets.US_ASCII);
        if (list != null && list.size() > 0) {
            this.patientNameQueryPatterns = list.toArray(new String[list.size()]);
        }
    }

    public SynchronizeFromRemoteSCP(DatabaseInformationModel databaseInformationModel, File file, String string, int n, String string2, int n2, String string3, boolean bl, boolean bl2, String string4, boolean bl3, boolean bl4, boolean bl5) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this.databaseInformationModel = databaseInformationModel;
        this.savedInstancesFolder = file;
        this.remoteHost = string;
        this.remotePort = n;
        this.remoteAE = string2;
        this.localPort = n2;
        this.localAE = string3;
        this.useGet = bl;
        this.queryAll = bl2;
        this.retrieveStudy = bl4;
        this.patientNameQueryPatterns = null;
        if (string4 != null && string4.length() > 0) {
            this.readPatientNameQueryPatternsFile(string4);
        }
        if (!file.exists() || !file.isDirectory()) {
            throw new DicomException("Folder in which to save received instances does not exist or is not a directory - " + file);
        }
        this.receivedObjectHandler = new OurReceivedObjectHandler();
        this.identifierHandler = new IdentifierHandler();
        if (bl) {
            this.setofClassesExpected = new HashSet();
        } else {
            new Thread(new StorageSOPClassSCPDispatcher(n2, string3, file, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, this.receivedObjectHandler, null, null, null, bl3 ? new AnyExplicitStorePresentationContextSelectionPolicy() : new UnencapsulatedExplicitStorePresentationContextSelectionPolicy(), false)).start();
        }
        this.setofInstancesExpected = new HashSet();
        this.numberOfSOPInstancesReceived = 0;
        this.numberOfValidSOPInstancesReceived = 0;
        this.numberOfUnrequestedSOPInstancesReceived = 0;
        this.queryInformationModel = new StudyRootQueryInformationModel(string, n, string2, string3, bl5);
        if (bl4) {
            this.performQueryAndStudyRetrieve(bl3);
        } else {
            this.performQueryAndWalkTreeDownToInstanceLevelAndRetrieve(bl3);
        }
        this.inactivityTime = 0L;
        while (!this.setofInstancesExpected.isEmpty() && this.inactivityTime > (long)inactivityTimeOut) {
            slf4jlogger.info("Sleeping since {} remaining", this.setofInstancesExpected.size());
            Thread.currentThread();
            Thread.sleep(sleepTimeBetweenCheckingForNothingExpectedBeforeExiting);
            this.inactivityTime += (long)sleepTimeBetweenCheckingForNothingExpectedBeforeExiting;
        }
        slf4jlogger.info("Finished with {} instances received, of which {} were valid, and {} were unrequested; requested but never received were {} instances", this.numberOfSOPInstancesReceived, this.numberOfValidSOPInstancesReceived, this.numberOfUnrequestedSOPInstancesReceived, this.setofInstancesExpected.size());
        if (slf4jlogger.isInfoEnabled()) {
            double d = this.totalDurationOfRetrieval == 0L ? 0.0 : (double)this.totalBytesSaved / 1000000.0 / ((double)this.totalDurationOfRetrieval / 1000.0);
            slf4jlogger.info("Total saved {} bytes in {} ms, {} MB/s", this.commaFormatter.format(this.totalBytesSaved), this.commaFormatter.format(this.totalDurationOfRetrieval), d);
        }
    }

    public SynchronizeFromRemoteSCP(DatabaseInformationModel databaseInformationModel, File file, String string, int n, String string2, int n2, String string3, boolean bl, boolean bl2, String string4, int n3, int n4, boolean bl3, boolean bl4, boolean bl5) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this(databaseInformationModel, file, string, n, string2, n2, string3, bl, bl2, string4, bl3, bl4, bl5);
        slf4jlogger.warn("Debug level supplied in constructor ignored");
    }

    public static void main(String[] stringArray) {
        block11: {
            try {
                if (stringArray.length >= 6 && stringArray.length <= 12) {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    String string3 = stringArray[2];
                    int n = Integer.parseInt(stringArray[3]);
                    String string4 = stringArray[4];
                    int n2 = Integer.parseInt(stringArray[5]);
                    String string5 = stringArray[6];
                    boolean bl4 = stringArray.length > 7 ? stringArray[7].trim().toUpperCase(Locale.US).equals("GET") : false;
                    boolean bl5 = true;
                    String string6 = null;
                    if (stringArray.length > 8) {
                        String string7 = stringArray[8].trim();
                        String string8 = string7.toUpperCase(Locale.US);
                        if (string8.equals("ALL")) {
                            bl5 = true;
                        } else if (string8.equals("SELECTIVE")) {
                            bl5 = false;
                        } else {
                            string6 = string7;
                        }
                    }
                    boolean bl6 = stringArray.length > 9 ? stringArray[9].trim().toUpperCase(Locale.US).equals("ANY") : (bl3 = false);
                    boolean bl7 = stringArray.length > 10 ? stringArray[10].trim().toUpperCase(Locale.US).equals("STUDY") : (bl2 = false);
                    boolean bl8 = stringArray.length > 11 ? stringArray[11].trim().toUpperCase(Locale.US).equals("REUSE") : (bl = false);
                    if (bl4 && bl2) {
                        slf4jlogger.info("STUDY level retrieval can only be used with MOVE not GET");
                        System.exit(0);
                    }
                    File file = new File(string2);
                    MinimalPatientStudySeriesInstanceModel minimalPatientStudySeriesInstanceModel = new MinimalPatientStudySeriesInstanceModel(string);
                    try {
                        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS();
                        networkConfigurationFromMulticastDNS.activateDiscovery();
                        networkConfigurationFromMulticastDNS.registerDicomService(string5, n2, "WSD");
                        Thread.currentThread();
                        Thread.sleep(sleepTimeAfterRegisteringWithBonjour);
                    }
                    catch (Exception exception) {
                        slf4jlogger.info("", exception);
                    }
                    new SynchronizeFromRemoteSCP(minimalPatientStudySeriesInstanceModel, file, string3, n, string4, n2, string5, bl4, bl5, string6, bl3, bl2, bl);
                    minimalPatientStudySeriesInstanceModel.close();
                    System.exit(0);
                    break block11;
                }
                slf4jlogger.info("Usage: java -cp ./pixelmed.jar:./lib/additional/hsqldb.jar:./lib/additional/commons-codec-1.3.jar:./lib/additional/jmdns.jar com.pixelmed.apps.SynchronizeFromRemoteSCP databasepath savedfilesfolder remoteHost remotePort remoteAET ourPort ourAET [GET|MOVE [ALL|SELECTIVE|patternfile] [UNCOMPRESSED|ANY [STUDY|INSTANCE [REUSE|NEW]]]]]");
            }
            catch (Exception exception) {
                slf4jlogger.info("", exception);
                System.exit(0);
            }
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            block8: {
                if (string != null) {
                    SynchronizeFromRemoteSCP.this.inactivityTime = 0L;
                    if (slf4jlogger.isInfoEnabled()) {
                        slf4jlogger.info("Received: {} from {} in {}", string, string3, string2);
                        SynchronizeFromRemoteSCP.this.bytesSaved += new File(string).length();
                    }
                    ++SynchronizeFromRemoteSCP.this.numberOfSOPInstancesReceived;
                    try {
                        FileInputStream fileInputStream = new FileInputStream(string);
                        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                        AttributeList attributeList = new AttributeList();
                        attributeList.read(dicomInputStream, terminateAfterRelationshipGroup);
                        dicomInputStream.close();
                        fileInputStream.close();
                        String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                        slf4jlogger.trace("Received: {} with SOPInstanceUID {}", string, string4);
                        if (string4 != null) {
                            String string5 = MoveDicomFilesIntoHierarchy.renameFileWithHierarchicalPathFromAttributes(new File(string), attributeList, SynchronizeFromRemoteSCP.this.savedInstancesFolder.getCanonicalPath(), "Duplicates");
                            if (string5 != null) {
                                string = string5;
                            }
                            if (SynchronizeFromRemoteSCP.this.retrieveStudy) {
                                SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string, "C");
                                break block8;
                            }
                            ++SynchronizeFromRemoteSCP.this.numberOfValidSOPInstancesReceived;
                            if (SynchronizeFromRemoteSCP.this.setofInstancesExpected.contains(string4)) {
                                SynchronizeFromRemoteSCP.this.setofInstancesExpected.remove(string4);
                                SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string, "C");
                                break block8;
                            }
                            ++SynchronizeFromRemoteSCP.this.numberOfUnrequestedSOPInstancesReceived;
                            SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string, "C");
                            throw new DicomException("Unrequested SOPInstanceUID " + string4 + " in received object ... stored it anyway");
                        }
                        throw new DicomException("Missing SOPInstanceUID in received object ... not inserting file " + string + " in database");
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                    }
                }
            }
        }
    }

    protected static class OurReadTerminationStrategy
    implements AttributeList.ReadTerminationStrategy {
        protected OurReadTerminationStrategy() {
        }

        @Override
        public boolean terminate(AttributeList attributeList, AttributeTag attributeTag, long l) {
            return attributeTag.getGroup() > 32;
        }
    }
}

