/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class UIDMapByMatchingPixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/UIDMapByMatchingPixelData.java,v 1.14 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(UIDMapByMatchingPixelData.class);
    private Map<String, List<String>> mapOfStudyInstanceUIDsByPixelDataHash = new TreeMap<String, List<String>>();
    private Map<String, List<String>> mapOfSeriesInstanceUIDsByPixelDataHash = new TreeMap<String, List<String>>();
    private Map<String, List<String>> mapOfSOPInstanceUIDsByPixelDataHash = new TreeMap<String, List<String>>();
    private Map<String, List<String>> mapOfFrameOfReferenceUIDsByPixelDataHash = new TreeMap<String, List<String>>();

    public Collection<List<String>> getDuplicateStudyInstanceUIDs() {
        return this.mapOfStudyInstanceUIDsByPixelDataHash.values();
    }

    public Collection<List<String>> getDuplicateSeriesInstanceUIDs() {
        return this.mapOfSeriesInstanceUIDsByPixelDataHash.values();
    }

    public Collection<List<String>> getDuplicateSOPInstanceUIDs() {
        return this.mapOfSOPInstanceUIDsByPixelDataHash.values();
    }

    public Collection<List<String>> getDuplicateFrameOfReferenceUIDs() {
        return this.mapOfFrameOfReferenceUIDsByPixelDataHash.values();
    }

    private static void addUIDToMapIndexedByHash(Map<String, List<String>> map, AttributeList attributeList, AttributeTag attributeTag, String string) {
        String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, attributeTag);
        if (string2.length() > 0) {
            List<String> list = map.get(string);
            if (list == null) {
                list = new LinkedList<String>();
                map.put(string, list);
            }
            if (!list.contains(string2)) {
                list.add(string2);
            }
        }
    }

    private static String toString(Map<String, List<String>> map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : map.keySet()) {
            String string3 = "";
            List<String> list = map.get(string2);
            for (String string4 : list) {
                stringBuffer.append(string3);
                stringBuffer.append(string4);
                string3 = "\t";
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UIDMapByMatchingPixelData.toString(this.mapOfStudyInstanceUIDsByPixelDataHash, "STUDY"));
        stringBuffer.append(UIDMapByMatchingPixelData.toString(this.mapOfSeriesInstanceUIDsByPixelDataHash, "SERIES"));
        stringBuffer.append(UIDMapByMatchingPixelData.toString(this.mapOfSOPInstanceUIDsByPixelDataHash, "INSTANCE"));
        stringBuffer.append(UIDMapByMatchingPixelData.toString(this.mapOfFrameOfReferenceUIDsByPixelDataHash, "FOR"));
        return stringBuffer.toString();
    }

    private static void cullUIDsThatAreNotDuplicatedInMultipleImages(Map<String, List<String>> map) {
        Iterator<List<String>> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            List<String> list = iterator.next();
            if (list.size() >= 2) continue;
            iterator.remove();
        }
    }

    private void cullUIDsThatAreNotDuplicatedInMultipleImages() {
        UIDMapByMatchingPixelData.cullUIDsThatAreNotDuplicatedInMultipleImages(this.mapOfStudyInstanceUIDsByPixelDataHash);
        UIDMapByMatchingPixelData.cullUIDsThatAreNotDuplicatedInMultipleImages(this.mapOfSeriesInstanceUIDsByPixelDataHash);
        UIDMapByMatchingPixelData.cullUIDsThatAreNotDuplicatedInMultipleImages(this.mapOfSOPInstanceUIDsByPixelDataHash);
        UIDMapByMatchingPixelData.cullUIDsThatAreNotDuplicatedInMultipleImages(this.mapOfFrameOfReferenceUIDsByPixelDataHash);
    }

    public UIDMapByMatchingPixelData(String[] stringArray) throws IOException, DicomException {
        OurMediaImporter ourMediaImporter = new OurMediaImporter();
        for (String string : stringArray) {
            ourMediaImporter.importDicomFiles(string);
        }
        this.cullUIDsThatAreNotDuplicatedInMultipleImages();
    }

    public static void main(String[] stringArray) {
        try {
            System.err.println(new UIDMapByMatchingPixelData(stringArray));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
            System.exit(0);
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        public OurMediaImporter() {
            super(null);
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                DicomInputStream dicomInputStream = new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                dicomInputStream.close();
                Attribute attribute = attributeList.getPixelData();
                if (attribute != null && attribute.getVL() > 0L) {
                    Object object;
                    byte[] byArray = null;
                    if (attribute instanceof OtherByteAttribute) {
                        byArray = attribute.getByteValues();
                    } else if (attribute instanceof OtherWordAttribute) {
                        object = attribute.getShortValues();
                        byArray = new byte[((short[])object).length * 2];
                        int n = 0;
                        for (int i = 0; i < ((short[])object).length; ++i) {
                            byArray[n++] = (byte)(object[i] >>> 8 & 0xFF);
                            byArray[n++] = (byte)(object[i] & 0xFF);
                        }
                    }
                    if (byArray != null) {
                        object = FileUtilities.md5(new ByteArrayInputStream(byArray));
                        UIDMapByMatchingPixelData.addUIDToMapIndexedByHash(UIDMapByMatchingPixelData.this.mapOfStudyInstanceUIDsByPixelDataHash, attributeList, TagFromName.StudyInstanceUID, (String)object);
                        UIDMapByMatchingPixelData.addUIDToMapIndexedByHash(UIDMapByMatchingPixelData.this.mapOfSeriesInstanceUIDsByPixelDataHash, attributeList, TagFromName.SeriesInstanceUID, (String)object);
                        UIDMapByMatchingPixelData.addUIDToMapIndexedByHash(UIDMapByMatchingPixelData.this.mapOfSOPInstanceUIDsByPixelDataHash, attributeList, TagFromName.SOPInstanceUID, (String)object);
                        UIDMapByMatchingPixelData.addUIDToMapIndexedByHash(UIDMapByMatchingPixelData.this.mapOfFrameOfReferenceUIDsByPixelDataHash, attributeList, TagFromName.FrameOfReferenceUID, (String)object);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error: File " + string + " exception " + exception);
            }
        }
    }
}

