/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class Immunostaining {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/Immunostaining.java,v 1.21 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(Immunostaining.class);
    private static Map<String, CodedSequenceItem> codedTargets = new HashMap<String, CodedSequenceItem>();
    private static Map<String, CodedSequenceItem> usingSubstance = new HashMap<String, CodedSequenceItem>();
    private static Map<String, CodedSequenceItem> codedFluorophores = new HashMap<String, CodedSequenceItem>();
    SortedMap<String, ImmunostainingChannel> channelsByChannelID = null;
    SortedMap<String, AttributeList> opticalPathAttributesByChannelID = null;
    SortedMap<String, SequenceAttribute> specimenPreparationStepContentItemSequenceByChannelID = null;

    public static CodedSequenceItem getCodeForChannelInMap(Map<String, CodedSequenceItem> map, String string) {
        String string2 = string.toUpperCase().trim();
        CodedSequenceItem codedSequenceItem = map.get(string2);
        if (codedSequenceItem == null) {
            if (string2.contains("(")) {
                string2 = string2.replaceAll("[(][0-9]+[)]", "").trim();
                codedSequenceItem = map.get(string2);
            } else if (string2.startsWith("DAPI")) {
                string2 = string2.replaceAll("[0-9]+$", "").trim();
                codedSequenceItem = map.get(string2);
            } else if (string2.startsWith("ANTI")) {
                string2 = string2.replaceFirst("ANTI[- ]*", "").trim();
                codedSequenceItem = map.get(string2);
            } else if (string2.startsWith("CONTROL")) {
                string2 = "CONTROL";
                codedSequenceItem = map.get(string2);
            }
        }
        return codedSequenceItem;
    }

    public static CodedSequenceItem getCodedTarget(String string) {
        return Immunostaining.getCodeForChannelInMap(codedTargets, string);
    }

    public static CodedSequenceItem getCodedUsingSubstance(String string) {
        return Immunostaining.getCodeForChannelInMap(usingSubstance, string);
    }

    public static CodedSequenceItem getCodedFluorophore(String string) {
        return Immunostaining.getCodeForChannelInMap(codedFluorophores, string);
    }

    public SortedMap<String, AttributeList> getMapOfOpticalPathAttributesByChannelID() throws DicomException {
        if (this.opticalPathAttributesByChannelID == null && this.channelsByChannelID != null) {
            this.opticalPathAttributesByChannelID = new TreeMap<String, AttributeList>();
            for (ImmunostainingChannel immunostainingChannel : this.channelsByChannelID.values()) {
                Attribute attribute;
                AttributeList attributeList = new AttributeList();
                this.opticalPathAttributesByChannelID.put(immunostainingChannel.channelID, attributeList);
                if (immunostainingChannel.excitationWavelength != null && immunostainingChannel.excitationWavelength.length() > 0) {
                    try {
                        attribute = new FloatSingleAttribute(DicomDictionary.StandardDictionary.getTagFromName("IlluminationWaveLength"));
                        attribute.addValue(immunostainingChannel.excitationWavelength);
                        attributeList.put(attribute);
                    }
                    catch (NumberFormatException numberFormatException) {
                        slf4jlogger.error("getMapOfOpticalPathAttributesByChannelID(): excitationWavelength {} not valid numeric float format", immunostainingChannel.excitationWavelength);
                    }
                }
                if (immunostainingChannel.emissionWavelength == null || immunostainingChannel.emissionWavelength.length() <= 0) continue;
                try {
                    attribute = new UnsignedShortAttribute(DicomDictionary.StandardDictionary.getTagFromName("LightPathFilterPassThroughWavelength"));
                    attribute.addValue(immunostainingChannel.emissionWavelength);
                    attributeList.put(attribute);
                }
                catch (NumberFormatException numberFormatException) {
                    slf4jlogger.error("getMapOfOpticalPathAttributesByChannelID(): excitationWavelength {} not valid numeric format", immunostainingChannel.emissionWavelength);
                }
            }
        }
        return this.opticalPathAttributesByChannelID;
    }

    public SortedMap<String, SequenceAttribute> getMapOfSpecimenPreparationStepContentItemSequenceByChannelID() throws DicomException {
        if (this.specimenPreparationStepContentItemSequenceByChannelID == null && this.channelsByChannelID != null) {
            this.specimenPreparationStepContentItemSequenceByChannelID = new TreeMap<String, SequenceAttribute>();
            for (ImmunostainingChannel immunostainingChannel : this.channelsByChannelID.values()) {
                this.specimenPreparationStepContentItemSequenceByChannelID.put(immunostainingChannel.channelID, immunostainingChannel.getSpecimenPreparationStepContentItemSequence());
            }
        }
        return this.specimenPreparationStepContentItemSequenceByChannelID;
    }

    private String getColumnValueIfPresent(String string, Map<String, Integer> map, String[] stringArray) {
        String string2 = null;
        Integer n = map.get(string);
        if (n != null) {
            int n2 = n;
            if (n2 < stringArray.length) {
                string2 = stringArray[n2];
            } else {
                slf4jlogger.trace("getColumnValueIfPresent(): columnIndex {} for columnName {} is not present in row", n2, string);
            }
        } else {
            slf4jlogger.debug("getColumnValueIfPresent(): unrecognized columnName {}", string);
        }
        return string2;
    }

    private void readFile(File file) throws FileNotFoundException, IOException, DicomException {
        HashMap<String, Integer> hashMap = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray;
            if (hashMap == null) {
                stringArray = null;
                if (string.contains("\t")) {
                    slf4jlogger.debug("readFile(): have tab separated values");
                    stringArray = string.split("\t");
                } else if (string.contains(",")) {
                    slf4jlogger.debug("readFile(): have comma separated values");
                    stringArray = string.split(",");
                }
                if (stringArray != null) {
                    hashMap = new HashMap<String, Integer>();
                    int n = 0;
                    for (String string2 : stringArray) {
                        hashMap.put(string2.toUpperCase().replaceAll(" ", "").replaceAll("-", "").replaceAll("NUMBER", "#").trim(), new Integer(n));
                        ++n;
                    }
                    continue;
                }
                throw new DicomException("Unrecognized form of header row in input file");
            }
            stringArray = null;
            if (string.contains("\t")) {
                stringArray = string.split("\t");
            } else if (string.contains(",")) {
                stringArray = string.split(",");
            }
            if (stringArray != null) {
                String string2;
                String string3 = this.getColumnValueIfPresent("CHANNELID", hashMap, stringArray);
                if (string3 == null || string3.length() == 0) {
                    throw new DicomException("Missing Channel ID");
                }
                string3 = string3.replace("Channel:0:", "");
                String string4 = this.getColumnValueIfPresent("CHANNELNAME", hashMap, stringArray);
                String string5 = this.getColumnValueIfPresent("CYCLE#", hashMap, stringArray);
                String string6 = this.getColumnValueIfPresent("SUBCYCLE#", hashMap, stringArray);
                string2 = this.getColumnValueIfPresent("TARGETNAME", hashMap, stringArray);
                String string7 = this.getColumnValueIfPresent("ANTIBODYNAME", hashMap, stringArray);
                String string8 = this.getColumnValueIfPresent("ANTIBODYROLE", hashMap, stringArray);
                String string9 = this.getColumnValueIfPresent("RRIDIDENTIFIER", hashMap, stringArray);
                String string10 = this.getColumnValueIfPresent("FLUOROPHORE", hashMap, stringArray);
                String string11 = this.getColumnValueIfPresent("CLONE", hashMap, stringArray);
                String string12 = this.getColumnValueIfPresent("LOT", hashMap, stringArray);
                String string13 = this.getColumnValueIfPresent("VENDOR", hashMap, stringArray);
                String string14 = this.getColumnValueIfPresent("CATALOG#", hashMap, stringArray);
                String string15 = this.getColumnValueIfPresent("EXCITATIONWAVELENGTH", hashMap, stringArray);
                String string16 = this.getColumnValueIfPresent("EMISSIONWAVELENGTH", hashMap, stringArray);
                String string17 = this.getColumnValueIfPresent("DILUTION", hashMap, stringArray);
                String string18 = this.getColumnValueIfPresent("CONCENTRATION", hashMap, stringArray);
                ImmunostainingChannel immunostainingChannel = new ImmunostainingChannel(string3, string4, string5, string6, string2, string7, string8, string9, string10, string11, string12, string13, string14, string15, string16, string17, string18);
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("readFile(): have channel {}", immunostainingChannel.toString());
                }
                this.channelsByChannelID.put(string3, immunostainingChannel);
                continue;
            }
            throw new DicomException("Unrecognized form of data row in input file " + file);
        }
        bufferedReader.close();
    }

    public Immunostaining(File file) throws FileNotFoundException, IOException, DicomException {
        this.channelsByChannelID = new TreeMap<String, ImmunostainingChannel>();
        this.readFile(file);
    }

    public Immunostaining(SortedMap<String, String> sortedMap) {
        if (sortedMap != null) {
            this.channelsByChannelID = new TreeMap<String, ImmunostainingChannel>();
            for (String string : sortedMap.keySet()) {
                String string2 = (String)sortedMap.get(string);
                if (string2 == null || string2.length() <= 0) continue;
                ImmunostainingChannel immunostainingChannel = new ImmunostainingChannel(string, string2);
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("Have channel {}", immunostainingChannel.toString());
                }
                this.channelsByChannelID.put(string, immunostainingChannel);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            new Immunostaining(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    static {
        try {
            codedTargets.put("NUCLEI", new CodedSequenceItem("84640000", "SCT", "Nucleus"));
            codedTargets.put("DNA", new CodedSequenceItem("24851008", "SCT", "DNA"));
            codedTargets.put("DAPI", new CodedSequenceItem("24851008", "SCT", "DNA"));
            usingSubstance.put("DAPI", new CodedSequenceItem("C122989", "NCIt", "DAPI"));
            codedTargets.put("HOECHST", new CodedSequenceItem("24851008", "SCT", "DNA"));
            usingSubstance.put("HOECHST", new CodedSequenceItem("C122989", "NCIt", "DAPI"));
            codedTargets.put("HEMATOXYLIN", new CodedSequenceItem("84640000", "SCT", "Nucleus"));
            usingSubstance.put("HEMATOXYLIN", new CodedSequenceItem("12710003", "SCT", "Hematoxylin"));
            codedTargets.put("DSDNA", new CodedSequenceItem("13925004", "SCT", "DNA, Double-Stranded"));
            usingSubstance.put("DSDNA", new CodedSequenceItem("C114565", "NCIt", "Anti-ds DNA Antibody"));
            codedTargets.put("CD3", new CodedSequenceItem("44706009", "SCT", "CD3"));
            codedTargets.put("CD3-001", new CodedSequenceItem("44706009", "SCT", "CD3"));
            usingSubstance.put("CD3", new CodedSequenceItem("C112883", "NCIt", "Anti-CD3 Monoclonal Antibody"));
            usingSubstance.put("CD3-001", new CodedSequenceItem("C112883", "NCIt", "Anti-CD3 Monoclonal Antibody"));
            codedTargets.put("CD4", new CodedSequenceItem("24655002", "SCT", "CD4"));
            codedTargets.put("CD4R", new CodedSequenceItem("24655002", "SCT", "CD4"));
            usingSubstance.put("CD4", new CodedSequenceItem("C112884", "NCIt", "Anti-CD4 Monoclonal Antibody"));
            usingSubstance.put("CD4R", new CodedSequenceItem("C112884", "NCIt", "Anti-CD4 Monoclonal Antibody"));
            codedTargets.put("CD8", new CodedSequenceItem("54237000", "SCT", "CD8"));
            codedTargets.put("CD8--02", new CodedSequenceItem("54237000", "SCT", "CD8"));
            codedTargets.put("CD8R", new CodedSequenceItem("54237000", "SCT", "CD8"));
            usingSubstance.put("CD8", new CodedSequenceItem("C112888", "NCIt", "Anti-CD8 Monoclonal Antibody"));
            usingSubstance.put("CD8--02", new CodedSequenceItem("C112888", "NCIt", "Anti-CD8 Monoclonal Antibody"));
            usingSubstance.put("CD8R", new CodedSequenceItem("C112888", "NCIt", "Anti-CD8 Monoclonal Antibody"));
            codedTargets.put("CD8A", new CodedSequenceItem("C104109", "NCIt", "CD8a"));
            codedTargets.put("CD11B", new CodedSequenceItem("27130004", "SCT", "CD11b"));
            codedTargets.put("CD11C", new CodedSequenceItem("46959001", "SCT", "CD11c"));
            codedTargets.put("CD20", new CodedSequenceItem("82753007", "SCT", "CD20"));
            codedTargets.put("CD20P", new CodedSequenceItem("82753007", "SCT", "CD20"));
            usingSubstance.put("CD20", new CodedSequenceItem("C118798", "NCIt", "Anti-CD20 Antibody"));
            usingSubstance.put("CD20P", new CodedSequenceItem("C118798", "NCIt", "Anti-CD20 Antibody"));
            codedTargets.put("CD31", new CodedSequenceItem("4167003", "SCT", "CD31"));
            codedTargets.put("CD44", new CodedSequenceItem("C17772", "NCIt", "CD44"));
            codedTargets.put("CD45", new CodedSequenceItem("19677004", "SCT", "CD45"));
            usingSubstance.put("CD45", new CodedSequenceItem("C70798", "NCIt", "Anti-CD45 Monoclonal Antibody"));
            codedTargets.put("CD45RA", new CodedSequenceItem("5404007", "SCT", "CD45RA"));
            usingSubstance.put("CD45RA", new CodedSequenceItem("C158687", "NCIt", "Anti-CD45RA Monoclonal Antibody"));
            codedTargets.put("CD45RO", new CodedSequenceItem("86076000", "SCT", "CD45RO"));
            usingSubstance.put("CD45RO", new CodedSequenceItem("C153104", "NCIt", "CD45RO Antibody"));
            codedTargets.put("CD56", new CodedSequenceItem("42891003", "SCT", "CD56"));
            codedTargets.put("CD66B", new CodedSequenceItem("8164002", "SCT", "CD66B"));
            codedTargets.put("CD68", new CodedSequenceItem("31001006", "SCT", "CD68"));
            codedTargets.put("CD74", new CodedSequenceItem("62998003", "SCT", "CD74"));
            codedTargets.put("CD163", new CodedSequenceItem("C104064", "NCIt", "CD163"));
            codedTargets.put("CD169", new CodedSequenceItem("C0142251", "UMLS", "CD169"));
            codedTargets.put("CDX2", new CodedSequenceItem("C25899", "NCIt", "CDX2"));
            codedTargets.put("CDX-2", new CodedSequenceItem("C25899", "NCIt", "CDX2"));
            codedTargets.put("CSF1R", new CodedSequenceItem("C17392", "NCIt", "CSF1R"));
            codedTargets.put("CSF1-R", new CodedSequenceItem("C17392", "NCIt", "CSF1R"));
            codedTargets.put("CSF-1-R", new CodedSequenceItem("C17392", "NCIt", "CSF1R"));
            codedTargets.put("CD208", new CodedSequenceItem("C0142251", "UMLS", "CD208"));
            codedTargets.put("DCLAMP", new CodedSequenceItem("C0142251", "UMLS", "CD208"));
            codedTargets.put("DC-LAMP", new CodedSequenceItem("C0142251", "UMLS", "CD208"));
            codedTargets.put("TSC403", new CodedSequenceItem("C0142251", "UMLS", "CD208"));
            codedTargets.put("CD209", new CodedSequenceItem("C18489", "NCIt", "CD209"));
            codedTargets.put("CDSIGN", new CodedSequenceItem("C18489", "NCIt", "CD209"));
            codedTargets.put("DCSIGN", new CodedSequenceItem("C18489", "NCIt", "CD209"));
            codedTargets.put("DC-SIGN", new CodedSequenceItem("C18489", "NCIt", "CD209"));
            codedTargets.put("CD223", new CodedSequenceItem("C104623", "NCIt", "LAG-3"));
            codedTargets.put("LAG3", new CodedSequenceItem("C104623", "NCIt", "LAG-3"));
            codedTargets.put("LAG-3", new CodedSequenceItem("C104623", "NCIt", "LAG-3"));
            codedTargets.put("PDL2", new CodedSequenceItem("C45438", "NCIt", "PD-L2"));
            codedTargets.put("PD-L2", new CodedSequenceItem("C45438", "NCIt", "PD-L2"));
            codedTargets.put("CD273", new CodedSequenceItem("C45438", "NCIt", "PD-L2"));
            codedTargets.put("PDL1", new CodedSequenceItem("C96024", "NCIt", "PDL1"));
            codedTargets.put("PD-L1", new CodedSequenceItem("C96024", "NCIt", "PDL1"));
            codedTargets.put("CD274", new CodedSequenceItem("C96024", "NCIt", "PDL1"));
            codedTargets.put("CD278", new CodedSequenceItem("C94803", "NCIt", "Inducible T-Cell Costimulator"));
            codedTargets.put("ICOS", new CodedSequenceItem("C94803", "NCIt", "Inducible T-Cell Costimulator"));
            codedTargets.put("PD1", new CodedSequenceItem("C94697", "NCIt", "PD1"));
            codedTargets.put("PD-1", new CodedSequenceItem("C94697", "NCIt", "PD1"));
            codedTargets.put("CD279", new CodedSequenceItem("C94697", "NCIt", "PD1"));
            codedTargets.put("CD340", new CodedSequenceItem("C17319", "NCIt", "ERBB2"));
            codedTargets.put("ERBB2", new CodedSequenceItem("C17319", "NCIt", "ERBB2"));
            codedTargets.put("HER2", new CodedSequenceItem("C17319", "NCIt", "ERBB2"));
            codedTargets.put("HER-2", new CodedSequenceItem("C17319", "NCIt", "ERBB2"));
            codedTargets.put("NEU", new CodedSequenceItem("C17319", "NCIt", "ERBB2"));
            usingSubstance.put("CD340", new CodedSequenceItem("C129670", "NCIt", "ERBB2 Antibody"));
            usingSubstance.put("ERBB2", new CodedSequenceItem("C129670", "NCIt", "ERBB2 Antibody"));
            usingSubstance.put("HER2", new CodedSequenceItem("C129670", "NCIt", "ERBB2 Antibody"));
            usingSubstance.put("HER-2", new CodedSequenceItem("C129670", "NCIt", "ERBB2 Antibody"));
            usingSubstance.put("NEU", new CodedSequenceItem("C129670", "NCIt", "ERBB2 Antibody"));
            codedTargets.put("CCR2", new CodedSequenceItem("C101577", "NCIt", "CCR2"));
            codedTargets.put("EOMES", new CodedSequenceItem("C102928", "NCIt", "EOMES"));
            codedTargets.put("FOXP3", new CodedSequenceItem("C104394", "NCIt", "FOXP3"));
            codedTargets.put("GATA3", new CodedSequenceItem("C75494", "NCIt", "GATA3"));
            codedTargets.put("GRZB", new CodedSequenceItem("130636000", "SCT", " Granzyme B"));
            codedTargets.put("GRANZYME B", new CodedSequenceItem("130636000", "SCT", " Granzyme B"));
            codedTargets.put("IDO", new CodedSequenceItem("C79782", "NCIt", "IDO"));
            codedTargets.put("KI67", new CodedSequenceItem("C0208804", "UMLS", "KI67"));
            codedTargets.put("ANTIGEN KI67", new CodedSequenceItem("C0208804", "UMLS", "KI67"));
            codedTargets.put("KI67-001", new CodedSequenceItem("C0208804", "UMLS", "KI67"));
            usingSubstance.put("KI67", new CodedSequenceItem("C118803", "NCIt", "Anti-KI-67 Antibody"));
            usingSubstance.put("ANTIGEN KI67", new CodedSequenceItem("C118803", "NCIt", "Anti-KI-67 Antibody"));
            usingSubstance.put("KI67-001", new CodedSequenceItem("C118803", "NCIt", "Anti-KI-67 Antibody"));
            codedTargets.put("NKP46", new CodedSequenceItem("C129059", "NCIt", "NKP46"));
            codedTargets.put("RORGT", new CodedSequenceItem("C106314", "NCIt", "RORGT"));
            codedTargets.put("RORGAMMAT", new CodedSequenceItem("C106314", "NCIt", "RORGT"));
            codedTargets.put("TBET", new CodedSequenceItem("C104249", "NCIt", "TBET"));
            codedTargets.put("PCNA", new CodedSequenceItem("C17323", "NCIt", "PCNA"));
            codedTargets.put("HLAI", new CodedSequenceItem("C20706", "NCIt", "HLA Class I"));
            codedTargets.put("HLA I", new CodedSequenceItem("C20706", "NCIt", "HLA Class I"));
            codedTargets.put("HLAI-001", new CodedSequenceItem("C20706", "NCIt", "HLA Class I"));
            codedTargets.put("HLAII", new CodedSequenceItem("C20705", "NCIt", "HLA Class II"));
            codedTargets.put("HLA II", new CodedSequenceItem("C20705", "NCIt", "HLA Class II"));
            codedTargets.put("MHCII", new CodedSequenceItem("C20705", "NCIt", "HLA Class II"));
            codedTargets.put("HLADR", new CodedSequenceItem("C16692", "NCIt", "HLA-DR"));
            codedTargets.put("HLA-DR", new CodedSequenceItem("C16692", "NCIt", "HLA-DR"));
            codedTargets.put("HLA DRB1", new CodedSequenceItem("C52341", "NCIt", "HLA DRB1"));
            codedTargets.put("CYTOKERATIN", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("PANCYTOKERATIN", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("PAN-CYTOKERATIN", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("PANKERATIN", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("PAN KERATIN", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("PANCK", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            codedTargets.put("VIMENTIN", new CodedSequenceItem("75925000", "SCT", "Vimentin"));
            codedTargets.put("VIM", new CodedSequenceItem("75925000", "SCT", "Vimentin"));
            usingSubstance.put("VIMENTIN", new CodedSequenceItem("C118804", "NCIt", "Anti-Vimentin Antibody"));
            usingSubstance.put("VIM", new CodedSequenceItem("C118804", "NCIt", "Anti-Vimentin Antibody"));
            codedTargets.put("EGFR", new CodedSequenceItem("86960007", "SCT", "Epidermal growth factor-urogastrone receptor"));
            usingSubstance.put("EGFR", new CodedSequenceItem("C122777", "NCIt", "EGFR Antibody"));
            codedTargets.put("BCL2", new CodedSequenceItem("LP37239-8", "LN", "BCL2 Antigen"));
            usingSubstance.put("BCL2", new CodedSequenceItem("C118801", "NCIt", "Anti-BCL2 Antibody"));
            codedTargets.put("CAV1", new CodedSequenceItem("C17971", "NCIt", "Caveolin-1"));
            codedTargets.put("GRNZB", new CodedSequenceItem("130636000", "SCT", "Granzyme B"));
            codedTargets.put("COLLAGEN", new CodedSequenceItem("61472002", "SCT", "Collagen"));
            codedTargets.put("T1 COLLAGEN", new CodedSequenceItem("58520002", "SCT", "Collagen type I"));
            codedTargets.put("DESMIN", new CodedSequenceItem("83475004", "SCT", "Desmin"));
            codedTargets.put("ECADHERIN", new CodedSequenceItem("61792", "FMA", "E-Cadherin"));
            codedTargets.put("E-CADHERIN", new CodedSequenceItem("61792", "FMA", "E-Cadherin"));
            codedTargets.put("ECAD", new CodedSequenceItem("61792", "FMA", "E-Cadherin"));
            codedTargets.put("LAMIN-A/B/C", new CodedSequenceItem("C17307", "NCIt", "Lamin"));
            codedTargets.put("NA/K ATPASE", new CodedSequenceItem("23736002", "SCT", "Na/K-transporting ATPase"));
            codedTargets.put("AORTIC SMOOTH MUSCLE ACTIN", new CodedSequenceItem("C103972", "NCIt", "Actin, Aortic Smooth Muscle"));
            codedTargets.put("ASMA", new CodedSequenceItem("LP35599-7", "LN", "Smooth Muscle Actin"));
            codedTargets.put("SMA", new CodedSequenceItem("LP35599-7", "LN", "Smooth Muscle Actin"));
            usingSubstance.put("AORTIC SMOOTH MUSCLE ACTIN", new CodedSequenceItem("21122009", "SCT", "Smooth muscle antibody"));
            usingSubstance.put("ASMA", new CodedSequenceItem("21122009", "SCT", "Smooth muscle antibody"));
            usingSubstance.put("SMA", new CodedSequenceItem("21122009", "SCT", "Smooth muscle antibody"));
            codedTargets.put("TRYPTASE", new CodedSequenceItem("130616001", "SCT", "Tryptase"));
            codedTargets.put("GLUT1", new CodedSequenceItem("D051272", "MSH", "Glucose Transporter Type 1"));
            codedTargets.put("GH2AX", new CodedSequenceItem("C468783", "MSH", "gamma-H2AX protein"));
            codedTargets.put("PHH3", new CodedSequenceItem("C16685", "NCIt", "Histone H3"));
            codedTargets.put("HISTONE H3", new CodedSequenceItem("C16685", "NCIt", "Histone H3"));
            codedTargets.put("H3K4", new CodedSequenceItem("C107427", "NCIt", "Histone H3 Lysine 4"));
            codedTargets.put("H3K27", new CodedSequenceItem("C116018", "NCIt", "Histone H3 Lysine 28"));
            codedTargets.put("PS6RP", new CodedSequenceItem("LP173628-1", "LN", "Phospho-S6 ribosomal protein"));
            codedTargets.put("CSIF", new CodedSequenceItem("C20512", "NCIt", "Interleukin-10"));
            codedTargets.put("CSIF-10", new CodedSequenceItem("C20512", "NCIt", "Interleukin-10"));
            codedTargets.put("IL10", new CodedSequenceItem("C20512", "NCIt", "Interleukin-10"));
            codedTargets.put("TGIF", new CodedSequenceItem("C20512", "NCIt", "Interleukin-10"));
            codedTargets.put("LAMB1", new CodedSequenceItem("C478221", "MSH", "LAMB1 protein"));
            codedTargets.put("PDPN", new CodedSequenceItem("C117468", "MSH", "PDPN protein"));
            codedTargets.put("RAD51", new CodedSequenceItem("C495153", "MSH", "RAD51 protein"));
            codedTargets.put("PRB", new CodedSequenceItem("D016160", "MSH", "Retinoblastoma Protein"));
            codedTargets.put("COXIV", new CodedSequenceItem("D003576", "MSH", "Cytochrome c Oxidase Subunit IV"));
            codedTargets.put("AR", new CodedSequenceItem("C17063", "NCIt", "Androgen Receptor"));
            codedTargets.put("ER", new CodedSequenceItem("C17069", "NCIt", "Estrogen Receptor"));
            usingSubstance.put("ER", new CodedSequenceItem("C118805", "NCIt", "Anti-Estrogen Receptor Antibody"));
            codedTargets.put("PGR", new CodedSequenceItem("C17075", "NCIt", "Progesterone Receptor"));
            codedTargets.put("COLI", new CodedSequenceItem("58520002", "SCT", "Collagen type I"));
            codedTargets.put("COLII", new CodedSequenceItem("61944000", "SCT", "Collagen type II"));
            codedTargets.put("COLIII", new CodedSequenceItem("57090003", "SCT", "Collagen type III"));
            codedTargets.put("COLIV", new CodedSequenceItem("89048009", "SCT", "Collagen type IV"));
            codedTargets.put("CK5", new CodedSequenceItem("D053555", "MSH", "Cytokeratin 5"));
            codedTargets.put("CK5P", new CodedSequenceItem("D053555", "MSH", "Cytokeratin 5"));
            codedTargets.put("CK7", new CodedSequenceItem("D053552", "MSH", "Cytokeratin 7"));
            codedTargets.put("CK8", new CodedSequenceItem("D053533", "MSH", "Cytokeratin 8"));
            codedTargets.put("CK14", new CodedSequenceItem("D053547", "MSH", "Cytokeratin 14"));
            codedTargets.put("CK17", new CodedSequenceItem("D053537", "MSH", "Cytokeratin 17"));
            codedTargets.put("CK19", new CodedSequenceItem("709132000", "SCT", "Cytokeratin 19"));
            codedTargets.put("CK20", new CodedSequenceItem("259615002", "SCT", "Cytokeratin 20"));
            codedTargets.put("CONTROL", new CodedSequenceItem("C156442", "NCIt", "Control analyte"));
            usingSubstance.put("AB_2857973", new CodedSequenceItem("AB_2857973", "RRID", "Recombinant Anti-CD31 antibody [EPR3094] (Alexa Fluor 647)"));
            codedTargets.put("AB_2857973", new CodedSequenceItem("4167003", "SCT", "CD31"));
            usingSubstance.put("AB_10626776", new CodedSequenceItem("AB_10626776", "RRID", "Hoechst 33342"));
            codedTargets.put("AB_10626776", new CodedSequenceItem("24851008", "SCT", "DNA"));
            usingSubstance.put("AB_2535794", new CodedSequenceItem("AB_2535794", "RRID", "Donkey anti-Rat IgG (H+L) Secondary AB, Alexa Fluor 488"));
            codedTargets.put("AB_2535794", new CodedSequenceItem("146671000146103", "SCT", "Rat protein"));
            usingSubstance.put("AB_11217482", new CodedSequenceItem("AB_11217482", "RRID", "Pan Cytokeratin Monoclonal AB (AE1/AE3), eFluor 570, eBioscience"));
            codedTargets.put("AB_11217482", new CodedSequenceItem("259987000", "SCT", "Cytokeratin"));
            usingSubstance.put("AB_2574361", new CodedSequenceItem("AB_2574361", "RRID", "Alpha-Smooth Muscle Actin MC AB (1A4), eFluor 660, eBioscience"));
            codedTargets.put("AB_2574361", new CodedSequenceItem("LP35599-7", "LN", "Smooth Muscle Actin"));
            usingSubstance.put("AB_2889191", new CodedSequenceItem("AB_2889191", "RRID", "Recombinant Alexa Fluor 488 Anti-CD4 antibody [EPR6855]"));
            codedTargets.put("AB_2889191", new CodedSequenceItem("24655002", "SCT", "CD4"));
            usingSubstance.put("AB_2562057", new CodedSequenceItem("AB_2562057", "RRID", "PE anti-human CD45"));
            codedTargets.put("AB_2562057", new CodedSequenceItem("19677004", "SCT", "CD45"));
            usingSubstance.put("AB_2728811", new CodedSequenceItem("AB_2728811", "RRID", "Anti-PD1 antibody"));
            codedTargets.put("AB_2728811", new CodedSequenceItem("C94697", "NCIt", "PD1"));
            usingSubstance.put("AB_10734358", new CodedSequenceItem("AB_10734358", "RRID", "CD20 Monoclonal Antibody (L26), Alexa Fluor 488, eBioscience"));
            codedTargets.put("AB_10734358", new CodedSequenceItem("82753007", "SCT", "CD20"));
            usingSubstance.put("AB_2799935", new CodedSequenceItem("AB_2799935", "RRID", "CD68 (D4B9C) XP Rabbit mAb (PE Conjugate)"));
            codedTargets.put("AB_2799935", new CodedSequenceItem("31001006", "SCT", "CD68"));
            usingSubstance.put("AB_2574149", new CodedSequenceItem("AB_2574149", "RRID", "CD8a Monoclonal Antibody (AMC908), eFluor 660, eBioscience"));
            codedTargets.put("AB_2574149", new CodedSequenceItem("C104109", "NCIt", "CD8a"));
            usingSubstance.put("AB_162543", new CodedSequenceItem("AB_162543", "RRID", "Donkey anti-Rabbit IgG (H+L) Secondary AB, Alexa Fluor 555"));
            codedTargets.put("AB_162543", new CodedSequenceItem("146321000146106", "SCT", "Rabbit protein"));
            usingSubstance.put("AB_2889155", new CodedSequenceItem("AB_2889155", "RRID", "Recomb Alexa Fluor 488 Anti-CD163 AB [EPR14643-36] - C-term"));
            codedTargets.put("AB_2889155", new CodedSequenceItem("C104064", "NCIt", "CD163"));
            usingSubstance.put("AB_2573608", new CodedSequenceItem("AB_2573608", "RRID", "FOXP3 Monoclonal Antibody (236A/E7), eFluor 570, eBioscience"));
            codedTargets.put("AB_2573608", new CodedSequenceItem("C104394", "NCIt", "FOXP3"));
            usingSubstance.put("AB_2728832", new CodedSequenceItem("AB_2728832", "RRID", "PD-L1 (E1L3N) XP (Alexa Fluor 647 Conjugate)"));
            codedTargets.put("AB_2728832", new CodedSequenceItem("C96024", "NCIt", "PDL1"));
            usingSubstance.put("AB_10691457", new CodedSequenceItem("AB_10691457", "RRID", "E-Cadherin (24E10) Rabbit mAb (Alexa Fluor 488 Conjugate)"));
            codedTargets.put("AB_10691457", new CodedSequenceItem("61792", "FMA", "E-Cadherin"));
            usingSubstance.put("AB_10859896", new CodedSequenceItem("AB_10859896", "RRID", "Vimentin (D21H3) XP Rabbit mAb (Alexa Fluor 555 Conjugate)"));
            codedTargets.put("AB_10859896", new CodedSequenceItem("75925000", "SCT", "Vimentin"));
            usingSubstance.put("AB_2889213", new CodedSequenceItem("AB_2889213", "RRID", "Recombinant Alexa Fluor 647 Anti-CDX2 antibody [EPR2764Y]"));
            codedTargets.put("AB_2889213", new CodedSequenceItem("C25899", "NCIt", "CDX2"));
            usingSubstance.put("AB_2728786", new CodedSequenceItem("AB_2728786", "RRID", "Anti-Lamin B1"));
            codedTargets.put("AB_2728786", new CodedSequenceItem("C17307", "NCIt", "Lamin"));
            usingSubstance.put("AB_162542", new CodedSequenceItem("AB_162542", "RRID", "Donkey Anti-Mouse IgG (H+L) Polyclonal AB, Alexa Fluor 647"));
            codedTargets.put("AB_162542", new CodedSequenceItem("146681000146101", "SCT", "Mouse protein"));
            usingSubstance.put("AB_2890164", new CodedSequenceItem("AB_2890164", "RRID", "Recomb Alexa Fluor 555 Anti-Desmin AB [Y66] - Cytoskel Mrkr"));
            codedTargets.put("AB_2890164", new CodedSequenceItem("83475004", "SCT", "Desmin"));
            usingSubstance.put("AB_11178664", new CodedSequenceItem("AB_11178664", "RRID", "PCNA (PC10) Mouse mAb (Alexa Fluor 488 Conjugate)"));
            codedTargets.put("AB_11178664", new CodedSequenceItem("C17323", "NCIt", "PCNA"));
            usingSubstance.put("AB_11220088", new CodedSequenceItem("AB_11220088", "RRID", "Ki-67 Monoclonal Antibody (20Raj1), eFluor 570, eBioscience"));
            codedTargets.put("AB_11220088", new CodedSequenceItem("C0208804", "UMLS", "KI67"));
            usingSubstance.put("AB_2687824", new CodedSequenceItem("AB_2687824", "RRID", "Ki-67 (D3B5) Rabbit Antibody (Alexa Fluor 488 Conjugate)"));
            codedTargets.put("AB_2687824", new CodedSequenceItem("C0208804", "UMLS", "KI67"));
            usingSubstance.put("AB_10854267", new CodedSequenceItem("AB_10854267", "RRID", "Collagen IV MC AB (1042), Alexa Fluor 647, eBioscience"));
            codedTargets.put("AB_10854267", new CodedSequenceItem("89048009", "SCT", "Collagen type IV"));
            codedFluorophores.put("ALEXA FLUOR 488", new CodedSequenceItem("102384756", "PUBCHEM_CID", "Alexa Fluor 488"));
            codedFluorophores.put("ALEXA FLUOR 555", new CodedSequenceItem("9832481", "PUBCHEM_CID", "Alexa Fluor 555"));
            codedFluorophores.put("ALEXA FLUOR 647", new CodedSequenceItem("102227060", "PUBCHEM_CID", "Alexa Fluor 647"));
            codedFluorophores.put("PE", new CodedSequenceItem("34101007", "SCT", "Phycoerythrin"));
            codedFluorophores.put("HOECHST 33342", new CodedSequenceItem("1464", "PUBCHEM_CID", "Bisbenzimide"));
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
    }

    public class ImmunostainingChannel {
        String channelID;
        String channelName;
        String cycleNumber;
        String subCycleNumber;
        String targetName;
        String antibodyName;
        String antibodyRole;
        String rrid;
        String fluorophore;
        String clone;
        String lot;
        String vendor;
        String catalogNumber;
        String excitationWavelength;
        String emissionWavelength;
        String dilution;
        String concentration;

        public ImmunostainingChannel(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12, String string13, String string14, String string15, String string16, String string17) {
            this.channelID = string;
            this.channelName = string2;
            this.cycleNumber = string3;
            this.subCycleNumber = string4;
            this.targetName = string5;
            this.antibodyName = string6;
            this.antibodyRole = string7;
            this.rrid = string8;
            this.fluorophore = string9;
            this.clone = string10;
            this.lot = string11;
            this.vendor = string12;
            this.catalogNumber = string13;
            this.excitationWavelength = string14;
            this.emissionWavelength = string15;
            this.dilution = string16;
            this.concentration = string17;
        }

        public ImmunostainingChannel(String string, String string2) {
            this.channelID = string;
            this.channelName = string2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("channelID = " + this.channelID);
            stringBuffer.append(", channelName = " + this.channelName);
            stringBuffer.append(", cycleNumber = " + this.cycleNumber);
            stringBuffer.append(", subCycleNumber = " + this.subCycleNumber);
            stringBuffer.append(", targetName = " + this.targetName);
            stringBuffer.append(", antibodyName = " + this.antibodyName);
            stringBuffer.append(", antibodyRole = " + this.antibodyRole);
            stringBuffer.append(", rrid = " + this.rrid);
            stringBuffer.append(", fluorophore = " + this.fluorophore);
            stringBuffer.append(", clone = " + this.clone);
            stringBuffer.append(", lot = " + this.lot);
            stringBuffer.append(", vendor = " + this.vendor);
            stringBuffer.append(", catalogNumber = " + this.catalogNumber);
            stringBuffer.append(", excitationWavelength = " + this.excitationWavelength);
            stringBuffer.append(", emissionWavelength = " + this.emissionWavelength);
            stringBuffer.append(", dilution = " + this.dilution);
            stringBuffer.append(", concentration = " + this.concentration);
            return stringBuffer.toString();
        }

        SequenceAttribute getSpecimenPreparationStepContentItemSequence() throws DicomException {
            Attribute attribute;
            SequenceAttribute sequenceAttribute = new SequenceAttribute(DicomDictionary.StandardDictionary.getTagFromName("SpecimenPreparationStepContentItemSequence"));
            Object object = new AttributeList();
            Object object2 = new CodeStringAttribute(TagFromName.ValueType);
            ((Attribute)object2).addValue("CODE");
            ((AttributeList)object).put((Attribute)object2);
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "111701", "DCM", "Processing type");
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptCodeSequence, "127790008", "SCT", "Staining");
            sequenceAttribute.addItem((AttributeList)object);
            object = new AttributeList();
            object2 = new CodeStringAttribute(TagFromName.ValueType);
            ((Attribute)object2).addValue("TEXT");
            ((AttributeList)object).put((Attribute)object2);
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C44170", "NCIt", "Channel");
            object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
            ((Attribute)object2).addValue(this.channelID);
            ((AttributeList)object).put((Attribute)object2);
            sequenceAttribute.addItem((AttributeList)object);
            if (this.cycleNumber != null && this.cycleNumber.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C25472", "NCIt", "Cycle");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.cycleNumber);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing cycleNumber for channelID {}", this.channelID);
            }
            if (this.subCycleNumber != null && this.subCycleNumber.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "313001", "99PMP", "Subcycle");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.subCycleNumber);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing subCycleNumber for channelID {}", this.channelID);
            }
            object = null;
            if (this.rrid != null && this.rrid.length() > 0) {
                if (this.rrid.toUpperCase().startsWith("AB_")) {
                    object = Immunostaining.getCodedTarget(this.rrid);
                    if (object != null) {
                        slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have Target code {} for RRID {}", object, this.rrid);
                    } else {
                        slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find Target code for RRID {}", this.rrid);
                    }
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): ignoring RRID that is not antibody {}", this.rrid);
                }
            }
            if (object == null && this.targetName != null && this.targetName.length() > 0) {
                object = Immunostaining.getCodedTarget(this.targetName);
                if (object != null) {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have Target code {} for targetName {}", object, this.targetName);
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find Target code for targetName {}", this.targetName);
                }
            }
            if (object == null && this.channelName != null && this.channelName.length() > 0) {
                object = Immunostaining.getCodedTarget(this.channelName);
                if (object != null) {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have Target code {} for channelName {}", object, this.channelName);
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find Target code for channelName {}", this.channelName);
                }
            }
            if (object != null) {
                object2 = new AttributeList();
                slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): using Target code {}", object);
                attribute = new CodeStringAttribute(TagFromName.ValueType);
                attribute.addValue("CODE");
                ((AttributeList)object2).put(attribute);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, TagFromName.ConceptNameCodeSequence, "246094008", "SCT", "Component investigated");
                CodedSequenceItem.putSingleCodedSequenceAttribute((AttributeList)object2, TagFromName.ConceptCodeSequence, (CodedSequenceItem)object);
                sequenceAttribute.addItem((AttributeList)object2);
            } else {
                slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find Target code for RRID {}, targetName {} or channelName {}", this.rrid, this.targetName, this.channelName);
            }
            object = null;
            if (this.targetName != null && this.targetName.length() > 0) {
                object = this.targetName;
            }
            if (object == null && this.channelName != null && this.channelName.length() > 0) {
                object = this.channelName;
            }
            if (object != null && ((String)object).length() > 0) {
                object2 = new AttributeList();
                attribute = new CodeStringAttribute(TagFromName.ValueType);
                attribute.addValue("TEXT");
                ((AttributeList)object2).put(attribute);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, TagFromName.ConceptNameCodeSequence, "246094008", "SCT", "Component investigated");
                attribute = new UnlimitedTextAttribute(TagFromName.TextValue);
                attribute.addValue((String)object);
                ((AttributeList)object2).put(attribute);
                sequenceAttribute.addItem((AttributeList)object2);
            }
            object = new AttributeList();
            object2 = new CodeStringAttribute(TagFromName.ValueType);
            ((Attribute)object2).addValue("CODE");
            ((AttributeList)object).put((Attribute)object2);
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C2480", "NCIt", "Tracer");
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptCodeSequence, "C0598447", "UMLS", "Fluorophore");
            sequenceAttribute.addItem((AttributeList)object);
            if (this.fluorophore != null && this.fluorophore.length() > 0) {
                object = Immunostaining.getCodedFluorophore(this.fluorophore);
                if (object != null) {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have fluorophoreCode code {} for {}", object, this.fluorophore);
                    object2 = new AttributeList();
                    attribute = new CodeStringAttribute(TagFromName.ValueType);
                    attribute.addValue("CODE");
                    ((AttributeList)object2).put(attribute);
                    CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, TagFromName.ConceptNameCodeSequence, "C0598447", "UMLS", "Using Fluorophore");
                    CodedSequenceItem.putSingleCodedSequenceAttribute((AttributeList)object2, TagFromName.ConceptCodeSequence, (CodedSequenceItem)object);
                    sequenceAttribute.addItem((AttributeList)object2);
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find fluorophoreCode code for fluorophore {}", this.fluorophore);
                }
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C0598447", "UMLS", "Using Fluorophore");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.fluorophore);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            }
            object = null;
            if (this.rrid != null && this.rrid.length() > 0) {
                if (this.rrid.toUpperCase().startsWith("AB_")) {
                    object = Immunostaining.getCodedUsingSubstance(this.rrid);
                    if (object != null) {
                        slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have UsingSubstance code {} for RRID {}", object, this.rrid);
                    } else {
                        slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find UsingSubstance code for RRID {}", this.rrid);
                    }
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): ignoring RRID that is not antibody {}", this.rrid);
                }
            }
            if (object == null && this.antibodyName != null && this.antibodyName.length() > 0) {
                object = Immunostaining.getCodedUsingSubstance(this.antibodyName);
                if (object != null) {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have UsingSubstance code {} for antibodyName {}", object, this.antibodyName);
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find UsingSubstance code for antibody {}", this.antibodyName);
                }
            }
            if (object == null && this.channelName != null && this.channelName.length() > 0) {
                object = Immunostaining.getCodedUsingSubstance(this.channelName);
                if (object != null) {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have UsingSubstance code {} for channelName {}", object, this.channelName);
                } else {
                    slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): cannot find UsingSubstance code for channelName {}", this.channelName);
                }
            }
            if (object != null) {
                slf4jlogger.debug("getSpecimenPreparationStepContentItemSequence(): have UsingSubstance code {} ", object);
                object2 = new AttributeList();
                attribute = new CodeStringAttribute(TagFromName.ValueType);
                attribute.addValue("CODE");
                ((AttributeList)object2).put(attribute);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object2, TagFromName.ConceptNameCodeSequence, "424361007", "SCT", "Using substance");
                CodedSequenceItem.putSingleCodedSequenceAttribute((AttributeList)object2, TagFromName.ConceptCodeSequence, (CodedSequenceItem)object);
                sequenceAttribute.addItem((AttributeList)object2);
            }
            if (this.antibodyName != null && this.antibodyName.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "424361007", "SCT", "Using substance");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.antibodyName);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            }
            object = new AttributeList();
            object2 = new CodeStringAttribute(TagFromName.ValueType);
            ((Attribute)object2).addValue("CODE");
            ((AttributeList)object).put((Attribute)object2);
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "703857004", "SCT", "Staining Technique");
            CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptCodeSequence, "406858009", "SCT", "Fluorescent staining");
            sequenceAttribute.addItem((AttributeList)object);
            if (this.clone != null && this.clone.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C37925", "NCIt", "Clone");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.clone);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing clone for channelID {}", this.channelID);
            }
            if (this.vendor != null && this.vendor.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C0947322", "UMLS", "Manufacturer Name");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.vendor);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing vendor for channelID {}", this.channelID);
            }
            if (this.catalogNumber != null && this.catalogNumber.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "111529", "DCM", "Brand Name");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.catalogNumber);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing catalogNumber for channelID {}", this.channelID);
            }
            if (this.dilution != null && this.dilution.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C4281604", "UMLS", "Dilution");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.dilution);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing dilution for channelID {}", this.channelID);
            }
            if (this.lot != null && this.lot.length() > 0) {
                object = new AttributeList();
                object2 = new CodeStringAttribute(TagFromName.ValueType);
                ((Attribute)object2).addValue("TEXT");
                ((AttributeList)object).put((Attribute)object2);
                CodedSequenceItem.putSingleCodedSequenceItem((AttributeList)object, TagFromName.ConceptNameCodeSequence, "C70848", "NCIt", "Lot Identifier");
                object2 = new UnlimitedTextAttribute(TagFromName.TextValue);
                ((Attribute)object2).addValue(this.lot);
                ((AttributeList)object).put((Attribute)object2);
                sequenceAttribute.addItem((AttributeList)object);
            } else {
                slf4jlogger.info("getSpecimenPreparationStepContentItemSequence(): missing lot for channelID {}", this.channelID);
            }
            return sequenceAttribute;
        }
    }
}

