/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.GeometryOfVolumeFromAttributeList;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.dicom.VersionAndConstants;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.ColorUtilities;
import com.pixelmed.utils.StringUtilities;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.rmi.dgc.VMID;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class IndexedLabelMapToSegmentation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/IndexedLabelMapToSegmentation.java,v 1.43 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(IndexedLabelMapToSegmentation.class);
    protected boolean suppressFramesForBackgroundSegment = true;
    protected static final Set<String> spatialAndRelationalConcepts = new HashSet<String>();
    protected static final Set<String> tissueConcepts = new HashSet<String>();
    protected LabelInformation backgroundLabel;
    protected Integer backgroundIndex;

    protected SortedMap<Integer, LabelInformation> readLabelMapFile(String string) throws IOException, NumberFormatException {
        TreeMap<Integer, LabelInformation> treeMap = new TreeMap<Integer, LabelInformation>();
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(string));
        String string2 = null;
        while ((string2 = lineNumberReader.readLine()) != null) {
            String[] stringArray = string2.split(",");
            if (stringArray.length < 7 || stringArray[0].equals("Original Description")) continue;
            Integer n = new Integer(stringArray[3].trim());
            treeMap.put(n, new LabelInformation(stringArray[1].trim(), stringArray[2].trim(), n, stringArray[4].trim(), stringArray[5].trim(), stringArray[6].trim(), stringArray.length > 7 ? stringArray[7].trim() : "", stringArray.length > 12 ? stringArray[12].trim() : "", stringArray.length > 11 ? stringArray[9].trim() : "", stringArray.length > 11 ? stringArray[10].trim() : "", stringArray.length > 11 ? stringArray[11].trim() : ""));
        }
        lineNumberReader.close();
        return treeMap;
    }

    protected void addAppropriateSegmentedPropertyCategoryCodeSequence(AttributeList attributeList, LabelInformation labelInformation) throws DicomException {
        CodedSequenceItem codedSequenceItem = null;
        codedSequenceItem = spatialAndRelationalConcepts.contains(labelInformation.conceptUniqueIdentifier) ? new CodedSequenceItem("309825002", "SCT", "Spatial and Relational Concept") : (tissueConcepts.contains(labelInformation.conceptUniqueIdentifier) ? new CodedSequenceItem("85756007", "SCT", "Tissue") : new CodedSequenceItem("91723000", "SCT", "Anatomical Structure"));
        CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList, TagFromName.SegmentedPropertyCategoryCodeSequence, codedSequenceItem);
    }

    protected void addSegmentSequenceItem(int n, SequenceAttribute sequenceAttribute, int n2, LabelInformation labelInformation) throws DicomException {
        Object object;
        AttributeList attributeList = new AttributeList();
        sequenceAttribute.addItem(attributeList);
        Object object2 = new UnsignedShortAttribute(TagFromName.SegmentNumber);
        ((Attribute)object2).addValue(n);
        attributeList.put((Attribute)object2);
        object2 = labelInformation == null ? n2 + ": Topography unknown" : StringUtilities.getStringNoLongerThanTruncatedIfNecessary(n2 + ": " + labelInformation.codeMeaning, 64);
        Attribute attribute = new LongStringAttribute(TagFromName.SegmentLabel);
        ((Attribute)attribute).addValue((String)object2);
        attributeList.put(attribute);
        attribute = new CodeStringAttribute(TagFromName.SegmentAlgorithmType);
        ((Attribute)attribute).addValue("MANUAL");
        attributeList.put(attribute);
        attribute = null;
        if (labelInformation != null && labelInformation.hasCode()) {
            this.addAppropriateSegmentedPropertyCategoryCodeSequence(attributeList, labelInformation);
            attribute = CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList, TagFromName.SegmentedPropertyTypeCodeSequence, labelInformation.getCodedSequenceItem());
        } else {
            CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList, TagFromName.SegmentedPropertyCategoryCodeSequence, new CodedSequenceItem("309825002", "SCT", "Spatial and Relational Concept"));
            attribute = CodedSequenceItem.putSingleCodedSequenceAttribute(attributeList, TagFromName.SegmentedPropertyTypeCodeSequence, new CodedSequenceItem("87100004", "SCT", "Topography unknown"));
        }
        if (labelInformation != null && attribute != null) {
            object = ((SequenceAttribute)attribute).getItem(0).getAttributeList();
            if (labelInformation.side.equals("R")) {
                ((AttributeList)object).put(CodedSequenceItem.newCodedSequenceAttribute(TagFromName.SegmentedPropertyTypeModifierCodeSequence, new CodedSequenceItem("24028007", "SCT", "Right")));
            } else if (labelInformation.side.equals("L")) {
                ((AttributeList)object).put(CodedSequenceItem.newCodedSequenceAttribute(TagFromName.SegmentedPropertyTypeModifierCodeSequence, new CodedSequenceItem("7771000", "SCT", "Left")));
            }
        }
        if (labelInformation != null && labelInformation.hasColor()) {
            object = labelInformation.getRecommendedDisplayCIELabValue();
            attributeList.put((Attribute)object);
        }
    }

    protected void addSegmentSequenceItem(int n, SequenceAttribute sequenceAttribute, LabelInformation labelInformation) throws DicomException {
        this.addSegmentSequenceItem(n, sequenceAttribute, labelInformation.indexValue, labelInformation);
    }

    protected Map<Integer, Integer> addSegmentSequence(AttributeList attributeList, Set<Integer> set, Map<Integer, LabelInformation> map, Set<Integer> set2) throws DicomException {
        slf4jlogger.info("backgroundIndex = {}", this.backgroundIndex);
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.SegmentSequence);
        attributeList.put(sequenceAttribute);
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        int n = 0;
        for (Integer n2 : map.keySet()) {
            slf4jlogger.info("index = {}", n2);
            if (!set.contains(n2)) continue;
            slf4jlogger.info("Used index = {}", n2);
            if (this.suppressFramesForBackgroundSegment && n2.equals(this.backgroundIndex)) {
                slf4jlogger.info("Suppressing segment addition for used background index {}", n2);
                continue;
            }
            LabelInformation labelInformation = map.get(n2);
            slf4jlogger.info("Used index label = {}", labelInformation);
            if (n2.equals(this.backgroundIndex) && !labelInformation.hasCode() && this.backgroundLabel.codeMeaning.toLowerCase().equals(labelInformation.codeMeaning.toLowerCase())) {
                slf4jlogger.info("Replacing supplied background with standard background label because no code available");
                labelInformation = this.backgroundLabel;
            }
            this.addSegmentSequenceItem(++n, sequenceAttribute, labelInformation);
            hashMap.put(n2, new Integer(n));
        }
        for (Integer n2 : set2) {
            if (n2.equals(this.backgroundIndex)) {
                if (this.suppressFramesForBackgroundSegment) {
                    slf4jlogger.info("Suppressing segment addition for background index {} amongst unrecognized labels", n2);
                    continue;
                }
                slf4jlogger.info("Adding standard background label");
                this.addSegmentSequenceItem(++n, sequenceAttribute, this.backgroundLabel);
                hashMap.put(n2, new Integer(n));
                continue;
            }
            this.addSegmentSequenceItem(++n, sequenceAttribute, n2, null);
            hashMap.put(n2, new Integer(n));
        }
        return hashMap;
    }

    public static void setBit(byte[] byArray, int n, int n2, int n3, int n4, int n5) {
        long l = n4 * n5;
        long l2 = l * (long)n + (long)(n5 * n2) + (long)n3;
        int n6 = (int)(l2 / 8L);
        int n7 = (int)(l2 % 8L);
        int n8 = 1 << n7;
        byArray[n6] = (byte)(byArray[n6] | n8);
    }

    public IndexedLabelMapToSegmentation(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws IOException, NumberFormatException, DicomException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object6;
        HashSet<Integer> hashSet;
        AttributeList attributeList;
        spatialAndRelationalConcepts.add("C1706907");
        tissueConcepts.add("C1123023");
        this.backgroundLabel = new LabelInformation("Background", "U", 0, "C1706907", "", "", "", "125040", "0", "0", "0");
        this.backgroundIndex = new Integer(this.backgroundLabel.indexValue);
        SortedMap<Integer, LabelInformation> sortedMap = this.readLabelMapFile(string2);
        UIDGenerator uIDGenerator = new UIDGenerator();
        String string10 = "";
        String string11 = "";
        String string12 = "";
        String string13 = "";
        String string14 = "";
        String string15 = "";
        String string16 = "";
        if (string4 != null && string4.length() > 0) {
            attributeList = new AttributeList();
            attributeList.read(string4);
            string10 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            string11 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            string12 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            string13 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            string14 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID);
            string15 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate);
            string16 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
        }
        attributeList = new AttributeList();
        attributeList.read(string);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.SamplesPerPixel, 1);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, 1);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsAllocated, 1);
        short[] sArray = null;
        byte[] byArray = null;
        if (n2 == 1) {
            if (n4 == 8) {
                byArray = attributeList.getPixelData().getByteValues();
            } else if (n4 == 16) {
                sArray = attributeList.getPixelData().getShortValues();
            }
        }
        if (byArray == null && sArray == null) {
            throw new DicomException("Only single channel input images 8 or 16 bit BitsAllocated supported - got SamplesPerPixel=" + n2 + " BitsStored=" + n3 + " BitsAllocated=" + n4);
        }
        int n5 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        int n6 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n8 = n6 * n7;
        HashMap<Double, Integer> hashMap = new HashMap<Double, Integer>();
        GeometryOfVolumeFromAttributeList geometryOfVolumeFromAttributeList = new GeometryOfVolumeFromAttributeList(attributeList);
        if (geometryOfVolumeFromAttributeList != null && geometryOfVolumeFromAttributeList.hasFrameInformation()) {
            hashSet = (HashSet<Integer>)geometryOfVolumeFromAttributeList.getDistanceAlongNormalFromOrigin();
            Arrays.sort((double[])hashSet);
            int n9 = 0;
            Object object7 = Double.NaN;
            for (HashSet hashSet2 : hashSet) {
                if (hashSet2 == object7) continue;
                hashMap.put(new Double((double)hashSet2), new Integer(++n9));
                object7 = hashSet2;
            }
        }
        hashSet = new TreeSet();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        HashMap<Integer, HashSet<Integer>> hashMap2 = new HashMap<Integer, HashSet<Integer>>();
        for (int n14 = 0; n14 < n5; ++n14) {
            Serializable serializable = new HashSet<Integer>();
            hashMap2.put(new Integer(n14), (HashSet<Integer>)serializable);
            int n10 = n8 * n14;
            for (int j = 0; j < n6; ++j) {
                int n11 = n10 + n7 * j;
                for (int i = 0; i < n7; ++i) {
                    int n9 = n11 + i;
                    int n12 = sArray == null ? byArray[n9] & 0xFF : sArray[n9] & 0xFFFF;
                    object6 = new Integer(n12);
                    serializable.add((Integer)object6);
                    object5 = (LabelInformation)sortedMap.get(object6);
                    if (object5 == null) {
                        if (hashSet.contains(object6)) continue;
                        hashSet.add((Integer)object6);
                        slf4jlogger.warn("No label information for pixel index value {}", n12);
                        continue;
                    }
                    if (hashSet3.contains(object6)) continue;
                    hashSet3.add((Integer)object6);
                    if (((LabelInformation)object5).hasCode()) continue;
                    slf4jlogger.warn("Label information without code for pixel index value {}", n12);
                }
            }
        }
        for (Serializable serializable : sortedMap.keySet()) {
            if (hashSet3.contains(serializable)) continue;
            slf4jlogger.warn("Label index value {} is not used", serializable);
        }
        int n13 = 0;
        for (int i = 0; i < n5; ++i) {
            Set set = (Set)hashMap2.get(new Integer(i));
            if (set.size() == 1 && set.contains(this.backgroundIndex)) {
                slf4jlogger.info("Frame {}: only background - ignoring", i);
                continue;
            }
            for (Integer n15 : set) {
                if (this.suppressFramesForBackgroundSegment && n15.equals(this.backgroundIndex)) {
                    slf4jlogger.info("Frame {}: suppressing background destination frame for index {}", i, n15);
                    continue;
                }
                slf4jlogger.info("Frame {}: {}", i, n15);
                ++n13;
            }
        }
        slf4jlogger.info("dstNumberOfFrames = {}", n13);
        Map<Integer, Integer> map = this.addSegmentSequence(attributeList, hashSet3, sortedMap, hashSet);
        String string17 = uIDGenerator.getAnotherNewUID();
        SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.DimensionOrganizationSequence);
        attributeList.put(sequenceAttribute);
        AttributeList attributeList2 = new AttributeList();
        sequenceAttribute.addItem(attributeList2);
        Attribute attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string17);
        attributeList2.put(attribute);
        sequenceAttribute = new SequenceAttribute(TagFromName.DimensionIndexSequence);
        attributeList.put(sequenceAttribute);
        AttributeList l2 = new AttributeList();
        sequenceAttribute.addItem(l2);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.ReferencedSegmentNumber);
        l2.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.SegmentIdentificationSequence);
        l2.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string17);
        l2.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("SegmentNumber");
        l2.put(attribute);
        AttributeList attributeList3 = new AttributeList();
        sequenceAttribute.addItem(attributeList3);
        attribute = new AttributeTagAttribute(TagFromName.DimensionIndexPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.ImagePositionPatient);
        attributeList3.put(attribute);
        attribute = new AttributeTagAttribute(TagFromName.FunctionalGroupPointer);
        ((AttributeTagAttribute)attribute).addValue(TagFromName.PlanePositionSequence);
        attributeList3.put(attribute);
        attribute = new UniqueIdentifierAttribute(TagFromName.DimensionOrganizationUID);
        attribute.addValue(string17);
        attributeList3.put(attribute);
        attribute = new LongStringAttribute(TagFromName.DimensionDescriptionLabel);
        attribute.addValue("ImagePosition(Patient)");
        attributeList3.put(attribute);
        long l = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0) * Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        long l3 = (long)n13 * l;
        long l4 = l3 / 8L;
        if (l3 % 8L > 0L) {
            ++l4;
        }
        if (l4 % 2L > 0L) {
            ++l4;
        }
        if (l4 > Integer.MAX_VALUE) {
            throw new DicomException("Requested PixelData byte array too large " + l4);
        }
        object6 = new byte[(int)l4];
        object5 = new OtherByteAttribute(TagFromName.PixelData);
        ((Attribute)object5).setValues((byte[])object6);
        attributeList.put((Attribute)object5);
        object5 = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
        SequenceAttribute sequenceAttribute3 = new SequenceAttribute(TagFromName.PerFrameFunctionalGroupsSequence);
        attributeList.put(sequenceAttribute3);
        for (n = 0; n < n13; ++n) {
            sequenceAttribute3.addItem(new AttributeList());
        }
        n = n6;
        int n14 = n7;
        int n15 = 0;
        for (int i = 0; i < n5; ++i) {
            object4 = (Set)hashMap2.get(new Integer(i));
            if (object4.size() == 1 && object4.contains(this.backgroundIndex)) continue;
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (Integer)object3.next();
                if (this.suppressFramesForBackgroundSegment && ((Integer)object2).equals(this.backgroundIndex)) {
                    slf4jlogger.info("Frame {}: suppressing background destination frame for index {}", i, object2);
                    continue;
                }
                int uniqueIdentifierAttribute = (Integer)object2;
                object = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute3, n15);
                Object shortStringAttribute = new SequenceAttribute(TagFromName.SegmentIdentificationSequence);
                ((AttributeList)object).put((Attribute)shortStringAttribute);
                Object object7 = new AttributeList();
                ((SequenceAttribute)shortStringAttribute).addItem((AttributeList)object7);
                Attribute attribute2 = new UnsignedShortAttribute(TagFromName.ReferencedSegmentNumber);
                attribute2.addValue(map.get(object2));
                ((AttributeList)object7).put(attribute2);
                shortStringAttribute = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence((SequenceAttribute)object5, i);
                if (shortStringAttribute != null) {
                    object7 = ((AttributeList)shortStringAttribute).get(TagFromName.PlanePositionSequence);
                    ((AttributeList)object).put((Attribute)object7);
                }
                shortStringAttribute = new SequenceAttribute(TagFromName.FrameContentSequence);
                ((AttributeList)object).put((Attribute)shortStringAttribute);
                object7 = new AttributeList();
                ((SequenceAttribute)shortStringAttribute).addItem((AttributeList)object7);
                attribute2 = new UnsignedLongAttribute(TagFromName.DimensionIndexValues);
                GeometryOfSlice geometryOfSlice = geometryOfVolumeFromAttributeList.getGeometryOfSlice(i);
                if (geometryOfSlice != null) {
                    double d = geometryOfSlice.getDistanceAlongNormalFromOrigin();
                    attribute2.addValue(map.get(object2));
                    attribute2.addValue((Integer)hashMap.get(new Double(d)));
                    ((AttributeList)object7).put(attribute2);
                }
                int attributeList4 = n8 * i;
                for (int j = 0; j < n6; ++j) {
                    int n16 = attributeList4 + n7 * j;
                    for (int k = 0; k < n7; ++k) {
                        int n17;
                        int n18 = n16 + k;
                        int n19 = n17 = sArray == null ? byArray[n18] & 0xFF : sArray[n18] & 0xFFFF;
                        if (n17 != uniqueIdentifierAttribute) continue;
                        IndexedLabelMapToSegmentation.setBit((byte[])object6, n15, j, k, n, n14);
                    }
                }
                ++n15;
            }
        }
        assert (n15 == n13);
        Object object8 = SequenceAttribute.getAttributeListFromSelectedItemWithinSequence(sequenceAttribute2, 0);
        if (object8 != null) {
            object4 = ((TreeMap)object8).values().iterator();
            while (object4.hasNext()) {
                object3 = (Attribute)object4.next();
                object2 = ((Attribute)object3).getTag();
                if (((AttributeTag)object2).equals(TagFromName.PixelMeasuresSequence) || ((AttributeTag)object2).equals(TagFromName.PlaneOrientationSequence)) continue;
                object4.remove();
            }
        } else {
            object4 = new SequenceAttribute(TagFromName.SharedFunctionalGroupsSequence);
            attributeList.put((Attribute)object4);
            object8 = new AttributeList();
            ((SequenceAttribute)object4).addItem((AttributeList)object8);
        }
        if (string10 != null && string10.length() > 0) {
            object4 = new SequenceAttribute(TagFromName.DerivationImageSequence);
            ((AttributeList)object8).put((Attribute)object4);
            object3 = new AttributeList();
            ((SequenceAttribute)object4).addItem((AttributeList)object3);
            object2 = new SequenceAttribute(TagFromName.DerivationCodeSequence);
            ((AttributeList)object3).put((Attribute)object2);
            AttributeList string18 = new AttributeList();
            ((SequenceAttribute)object2).addItem(string18);
            string18.putAll(new CodedSequenceItem("113076", "DCM", "Segmentation").getAttributeList());
            object2 = new SequenceAttribute(TagFromName.SourceImageSequence);
            ((AttributeList)object3).put((Attribute)object2);
            string18 = new AttributeList();
            ((SequenceAttribute)object2).addItem(string18);
            object = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
            ((Attribute)object).addValue(string10);
            string18.put((Attribute)object);
            object = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
            ((Attribute)object).addValue(string11);
            string18.put((Attribute)object);
            object = new SequenceAttribute(TagFromName.PurposeOfReferenceCodeSequence);
            string18.put((Attribute)object);
            AttributeList attributeList4 = new AttributeList();
            ((SequenceAttribute)object).addItem(attributeList4);
            attributeList4.putAll(new CodedSequenceItem("121322", "DCM", "Source image for image processing operation").getAttributeList());
        }
        if (string10 != null && string10.length() > 0) {
            object8 = new SequenceAttribute(TagFromName.ReferencedSeriesSequence);
            attributeList.put((Attribute)object8);
            object4 = new AttributeList();
            ((SequenceAttribute)object8).addItem((AttributeList)object4);
            object3 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
            ((Attribute)object3).addValue(string13);
            ((AttributeList)object4).put((Attribute)object3);
            object3 = new SequenceAttribute(TagFromName.ReferencedInstanceSequence);
            ((AttributeList)object4).put((Attribute)object3);
            object2 = new AttributeList();
            ((SequenceAttribute)object3).addItem((AttributeList)object2);
            UniqueIdentifierAttribute uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPClassUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string10);
            ((AttributeList)object2).put(uniqueIdentifierAttribute);
            uniqueIdentifierAttribute = new UniqueIdentifierAttribute(TagFromName.ReferencedSOPInstanceUID);
            ((Attribute)uniqueIdentifierAttribute).addValue(string11);
            ((AttributeList)object2).put(uniqueIdentifierAttribute);
        }
        object8 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
        ((Attribute)object8).addValue(n13);
        attributeList.put((Attribute)object8);
        object8 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
        ((Attribute)object8).addValue(1);
        attributeList.put((Attribute)object8);
        object8 = new UnsignedShortAttribute(TagFromName.BitsStored);
        ((Attribute)object8).addValue(1);
        attributeList.put((Attribute)object8);
        object8 = new UnsignedShortAttribute(TagFromName.HighBit);
        ((Attribute)object8).addValue(0);
        attributeList.put((Attribute)object8);
        object8 = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
        ((Attribute)object8).addValue(0);
        attributeList.put((Attribute)object8);
        object8 = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)object8).addValue("1.2.840.10008.5.1.4.1.1.66.4");
        attributeList.put((Attribute)object8);
        object8 = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)object8).addValue("SEG");
        attributeList.put((Attribute)object8);
        object8 = new CodeStringAttribute(TagFromName.ImageType);
        ((Attribute)object8).addValue("DERIVED");
        ((Attribute)object8).addValue("PRIMARY");
        attributeList.put((Attribute)object8);
        attributeList.remove(TagFromName.RescaleIntercept);
        attributeList.remove(TagFromName.RescaleSlope);
        attributeList.remove(TagFromName.RescaleType);
        attributeList.remove(TagFromName.ConversionType);
        attributeList.remove(TagFromName.FrameIncrementPointer);
        attributeList.remove(TagFromName.VOILUTFunction);
        object8 = new CodeStringAttribute(TagFromName.SegmentationType);
        ((Attribute)object8).addValue("BINARY");
        attributeList.put((Attribute)object8);
        object8 = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)object8).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object8);
        object8 = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)object8).addValue(uIDGenerator.getAnotherNewUID());
        attributeList.put((Attribute)object8);
        if (string12.length() > 0) {
            object8 = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
            ((Attribute)object8).addValue(string12);
            attributeList.put((Attribute)object8);
        }
        if (string14.length() > 0) {
            object8 = new UniqueIdentifierAttribute(TagFromName.FrameOfReferenceUID);
            ((Attribute)object8).addValue(string14);
            attributeList.put((Attribute)object8);
        }
        if (string15.length() > 0) {
            object8 = new DateAttribute(TagFromName.StudyDate);
            ((Attribute)object8).addValue(string15);
            attributeList.put((Attribute)object8);
        }
        if (string16.length() > 0) {
            object8 = new TimeAttribute(TagFromName.StudyTime);
            ((Attribute)object8).addValue(string16);
            attributeList.put((Attribute)object8);
        }
        object8 = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)object8).addValue(string5);
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.Manufacturer);
        ((Attribute)object8).addValue("PixelMed");
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.ManufacturerModelName);
        ((Attribute)object8).addValue(this.getClass().getName());
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.DeviceSerialNumber);
        ((Attribute)object8).addValue(new VMID().toString());
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.SoftwareVersions);
        ((Attribute)object8).addValue(VersionAndConstants.getBuildDate());
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.SeriesDescription);
        ((Attribute)object8).addValue(string6);
        attributeList.put((Attribute)object8);
        object8 = new CodeStringAttribute(TagFromName.ContentLabel);
        ((Attribute)object8).addValue(string7.toUpperCase());
        attributeList.put((Attribute)object8);
        object8 = new LongStringAttribute(TagFromName.ContentDescription);
        ((Attribute)object8).addValue(string8);
        attributeList.put((Attribute)object8);
        object8 = new PersonNameAttribute(TagFromName.ContentCreatorName);
        ((Attribute)object8).addValue(string9);
        attributeList.put((Attribute)object8);
        object8 = new CodeStringAttribute(TagFromName.LossyImageCompression);
        ((Attribute)object8).addValue("00");
        attributeList.put((Attribute)object8);
        object8 = new Date();
        object4 = new SimpleDateFormat("yyyyMMdd").format((Date)object8);
        object3 = new SimpleDateFormat("HHmmss.SSS").format((Date)object8);
        object2 = new DateAttribute(TagFromName.SeriesDate);
        ((Attribute)object2).addValue((String)object4);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.SeriesTime);
        ((Attribute)object2).addValue((String)object3);
        attributeList.put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.ContentDate);
        ((Attribute)object2).addValue((String)object4);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.ContentTime);
        ((Attribute)object2).addValue((String)object3);
        attributeList.put((Attribute)object2);
        object2 = new DateAttribute(TagFromName.InstanceCreationDate);
        ((Attribute)object2).addValue((String)object4);
        attributeList.put((Attribute)object2);
        object2 = new TimeAttribute(TagFromName.InstanceCreationTime);
        ((Attribute)object2).addValue((String)object3);
        attributeList.put((Attribute)object2);
        object2 = TimeZone.getDefault();
        String string18 = DateTimeAttribute.getTimeZone((TimeZone)object2, (Date)object8);
        object = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TimezoneOffsetFromUTC);
        if (((String)object).length() > 0) {
            if (!string18.equals(object)) {
                slf4jlogger.info("IndexedLabelMapToSegmentation(): Warning - TimezoneOffsetFromUTC from images " + (String)object + " is different from current timezone " + string18 + " - removing and not adding current");
                attributeList.remove(TagFromName.TimezoneOffsetFromUTC);
            }
        } else {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(TagFromName.TimezoneOffsetFromUTC);
            ((Attribute)shortStringAttribute).addValue(string18);
            attributeList.put(shortStringAttribute);
        }
        object8 = new UniqueIdentifierAttribute(TagFromName.InstanceCreatorUID);
        ((Attribute)object8).addValue("1.3.6.1.4.1.5962.99.3");
        attributeList.put((Attribute)object8);
        attributeList.removePrivateAttributes();
        attributeList.removeGroupLengthAttributes();
        attributeList.removeMetaInformationHeaderAttributes();
        attributeList.remove(TagFromName.DataSetTrailingPadding);
        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string3, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length >= 3) {
                new IndexedLabelMapToSegmentation(stringArray[0], stringArray[1], stringArray[2], stringArray.length >= 4 ? stringArray[3] : "", stringArray.length >= 5 ? stringArray[4] : "5634", stringArray.length >= 6 ? stringArray[5] : "Converted from Indexed Label Map", stringArray.length >= 7 ? stringArray[6] : "SEGMENTATION", stringArray.length >= 8 ? stringArray[7] : "Converted from Indexed Label Map", stringArray.length >= 9 ? stringArray[8] : "PixelMed^Tester");
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: IndexedLabelMapToSegmentation inputFile labelFile outputFile [referenceImageFile [seriesNumber [seriesDescription [contentLabel [contentDescription [contentCreator]]]]]]");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    protected class LabelInformation {
        String codeMeaning;
        String side;
        int indexValue;
        String conceptUniqueIdentifier;
        String conceptIdentifier;
        String snomedCodeValue;
        String fmaCodeValue;
        String dcmCodeValue;
        String red;
        String green;
        String blue;

        public LabelInformation(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            this.codeMeaning = string;
            this.side = string2;
            this.indexValue = n;
            this.conceptUniqueIdentifier = string3;
            this.conceptIdentifier = string4;
            this.snomedCodeValue = string5;
            this.fmaCodeValue = string6;
            this.dcmCodeValue = string7;
            this.red = string8;
            this.green = string9;
            this.blue = string10;
            System.err.println("LabelInformation: Adding " + this);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[" + this.indexValue + "]");
            stringBuffer.append(" UMLS CUI = " + this.conceptUniqueIdentifier);
            stringBuffer.append(" (" + this.conceptIdentifier + ",SCT,\"" + this.codeMeaning + "\")");
            stringBuffer.append(" (" + this.snomedCodeValue + ",SRT,\"" + this.codeMeaning + "\")");
            stringBuffer.append(" (" + this.fmaCodeValue + ",FMA,\"" + this.codeMeaning + "\")");
            stringBuffer.append(" (" + this.dcmCodeValue + ",DCM,\"" + this.codeMeaning + "\")");
            stringBuffer.append(" rgb = (" + this.red + "," + this.green + "," + this.blue + ")");
            return stringBuffer.toString();
        }

        public boolean hasCode() {
            return this.snomedCodeValue.length() > 0 || this.fmaCodeValue.length() > 0 || this.dcmCodeValue.length() > 0 || this.conceptUniqueIdentifier.length() > 0;
        }

        public CodedSequenceItem getCodedSequenceItem() throws DicomException {
            String string = "";
            String string2 = "";
            if (this.conceptIdentifier.length() > 0) {
                string = "SCT";
                string2 = this.conceptIdentifier;
            } else if (this.snomedCodeValue.length() > 0) {
                string = "SRT";
                string2 = this.snomedCodeValue;
            } else if (this.fmaCodeValue.length() > 0) {
                string = "FMA";
                string2 = this.fmaCodeValue;
            } else if (this.dcmCodeValue.length() > 0) {
                string = "DCM";
                string2 = this.dcmCodeValue;
            } else if (this.conceptUniqueIdentifier.length() > 0) {
                string = "UMLS";
                string2 = this.conceptUniqueIdentifier;
            }
            return new CodedSequenceItem(string2, string, StringUtilities.getStringNoLongerThanTruncatedIfNecessary(this.codeMeaning, 64));
        }

        public boolean hasColor() {
            return this.red.length() > 0 && this.green.length() > 0 && this.blue.length() > 0;
        }

        public Attribute getRecommendedDisplayCIELabValue() throws DicomException {
            UnsignedShortAttribute unsignedShortAttribute = null;
            if (this.hasColor()) {
                int[] nArray = new int[]{Integer.parseInt(this.red), Integer.parseInt(this.green), Integer.parseInt(this.blue)};
                int[] nArray2 = ColorUtilities.getIntegerScaledCIELabPCSFromSRGB(nArray);
                unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.RecommendedDisplayCIELabValue);
                ((Attribute)unsignedShortAttribute).addValue(nArray2[0]);
                ((Attribute)unsignedShortAttribute).addValue(nArray2[1]);
                ((Attribute)unsignedShortAttribute).addValue(nArray2[2]);
            }
            return unsignedShortAttribute;
        }
    }
}

