/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import com.pixelmed.convert.TIFFFile;
import com.pixelmed.convert.TIFFTags;
import com.pixelmed.convert.TIFFTypes;
import com.pixelmed.convert.TIFFValues;
import java.io.EOFException;
import java.io.IOException;

public class TIFFImageFileDirectoryEntry {
    protected int tagIdentifier;
    protected int tagType;
    protected long numberOfValues;
    protected TIFFValues values;
    private static final byte[] buffer32 = new byte[4];
    private static final byte[] buffer64 = new byte[8];

    public int getTagIdentifier() {
        return this.tagIdentifier;
    }

    public int getTagType() {
        return this.tagType;
    }

    public long getNumberOfValues() {
        return this.numberOfValues;
    }

    public TIFFValues getValues() {
        return this.values;
    }

    public TIFFImageFileDirectoryEntry(int n, int n2, long l, TIFFValues tIFFValues) {
        this.tagIdentifier = n;
        this.tagType = n2;
        this.numberOfValues = l;
        this.values = tIFFValues;
    }

    public static TIFFImageFileDirectoryEntry readBigIFDEntry(TIFFFile tIFFFile) throws EOFException, IOException, TIFFException {
        int n = tIFFFile.getUnsigned16();
        int n2 = tIFFFile.getUnsigned16();
        long l = tIFFFile.getUnsigned64();
        int n3 = TIFFTypes.getNumberOfBytesPerValue(n2);
        long l2 = l * (long)n3;
        TIFFValues tIFFValues = null;
        if (l2 <= 8L) {
            tIFFFile.read(buffer64);
            tIFFValues = TIFFValues.extractValues(n2, buffer64, tIFFFile.getByteOrder(), (int)l);
        } else {
            long l3 = tIFFFile.getUnsigned64();
            long l4 = tIFFFile.getFilePointer();
            byte[] byArray = new byte[(int)l2];
            tIFFFile.seek(l3);
            tIFFFile.read(byArray);
            tIFFFile.seek(l4);
            tIFFValues = TIFFValues.extractValues(n2, byArray, tIFFFile.getByteOrder(), (int)l);
        }
        return new TIFFImageFileDirectoryEntry(n, n2, l, tIFFValues);
    }

    public static TIFFImageFileDirectoryEntry readClassicIFDEntry(TIFFFile tIFFFile) throws EOFException, IOException, TIFFException {
        int n = tIFFFile.getUnsigned16();
        int n2 = tIFFFile.getUnsigned16();
        long l = tIFFFile.getUnsigned32();
        int n3 = TIFFTypes.getNumberOfBytesPerValue(n2);
        long l2 = l * (long)n3;
        TIFFValues tIFFValues = null;
        if (l2 <= 4L) {
            tIFFFile.read(buffer32);
            tIFFValues = TIFFValues.extractValues(n2, buffer32, tIFFFile.getByteOrder(), (int)l);
        } else {
            long l3 = tIFFFile.getUnsigned32();
            long l4 = tIFFFile.getFilePointer();
            byte[] byArray = new byte[(int)l2];
            tIFFFile.seek(l3);
            tIFFFile.read(byArray);
            tIFFFile.seek(l4);
            tIFFValues = TIFFValues.extractValues(n2, byArray, tIFFFile.getByteOrder(), (int)l);
        }
        return new TIFFImageFileDirectoryEntry(n, n2, l, tIFFValues);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TIFFTags.getDescription(this.tagIdentifier));
        stringBuffer.append(" (");
        stringBuffer.append(this.tagIdentifier);
        stringBuffer.append(") ");
        stringBuffer.append(TIFFTypes.getDescription(this.tagType));
        stringBuffer.append(" (");
        stringBuffer.append(this.tagType);
        stringBuffer.append(") ");
        stringBuffer.append(this.numberOfValues);
        stringBuffer.append("<");
        stringBuffer.append(this.values);
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }
}

