/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.convert.TIFFException;
import com.pixelmed.convert.TIFFFile;
import com.pixelmed.convert.TIFFImageFileDirectories;
import com.pixelmed.convert.TIFFImageFileDirectory;
import com.pixelmed.dicom.CompressedFrameDecoder;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.display.BufferedImageUtilities;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import javax.xml.bind.DatatypeConverter;

public class TIFFPixelMessageDigest {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/TIFFPixelMessageDigest.java,v 1.7 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TIFFPixelMessageDigest.class);
    private static byte[] AdobeAPP14_RGB = new byte[]{-1, -18, 0, 12, 65, 100, 111, 98, 101, 0, 0, 0, 0, 0};

    private static byte[] stripSOIEOIMarkers(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        if (n >= 4 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216 && (byArray[n - 2] & 0xFF) == 255 && (byArray[n - 1] & 0xFF) == 217) {
            if (n > 4) {
                int n2 = n - 4;
                byArray2 = new byte[n2];
                System.arraycopy(byArray, 2, byArray2, 0, n2);
            }
        } else {
            slf4jlogger.error("stripSOIEOIMarkers(): Unable to remove SOI and EOI markers");
            byArray2 = byArray;
        }
        return byArray2;
    }

    private static byte[] insertJPEGTablesIntoAbbreviatedBitStream(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = null;
        int n = byArray.length;
        if (n > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            int n2 = byArray2.length;
            int n3 = n + n2;
            byArray3 = new byte[n3];
            System.arraycopy(byArray, 0, byArray3, 0, 2);
            System.arraycopy(byArray2, 0, byArray3, 2, n2);
            System.arraycopy(byArray, 2, byArray3, 2 + n2, n - 2);
        } else {
            slf4jlogger.error("insertJPEGTablesIntoAbbreviatedBitStream(): Unable to insert JPEG Tables");
            byArray3 = byArray;
        }
        return byArray3;
    }

    private static byte[] insertAdobeAPP14WithRGBTransformIntoBitStream(byte[] byArray) {
        byte[] byArray2 = null;
        int n = byArray.length;
        if (n > 2 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 216) {
            int n2 = AdobeAPP14_RGB.length;
            int n3 = n + n2;
            byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, 2);
            System.arraycopy(AdobeAPP14_RGB, 0, byArray2, 2, n2);
            System.arraycopy(byArray, 2, byArray2, 2 + n2, n - 2);
        } else {
            slf4jlogger.error("insertAdobeAPP14WithRGBTransformIntoBitStream(): Unable to insert APP14");
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] computePixelMessageDigestFromTiles(TIFFFile tIFFFile, int n, long[] lArray, long[] lArray2, long l, long l2, long l3, long l4, long l5, byte[] byArray) throws IOException, TIFFException, NoSuchAlgorithmException, DicomException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        if (l4 == 0L || l4 == 1L) {
            if (l3 != 8L) throw new TIFFException("Unsupported bitsPerSample = " + l3 + " for compression");
            for (int i = 0; i < n; ++i) {
                long l6 = lArray[i];
                long l7 = lArray2[i];
                byte[] byArray2 = new byte[(int)l7];
                tIFFFile.seek(l6);
                tIFFFile.read(byArray2);
                messageDigest.update(byArray2);
            }
            return messageDigest.digest();
        } else {
            if (l4 != 7L && l4 != 33005L) throw new TIFFException("Unsupported compression = " + l4);
            if (l3 != 8L) throw new TIFFException("Unsupported bitsPerSample = " + l3 + " for compression");
            String string = l4 == 7L ? "1.2.840.10008.1.2.4.50" : "1.2.840.10008.1.2.4.91";
            CompressedFrameDecoder compressedFrameDecoder = new CompressedFrameDecoder(string, 1, (int)l, (int)l2, 3, ColorSpace.getInstance(1000), l5 == 6L);
            for (int i = 0; i < n; ++i) {
                long l8 = lArray[i];
                long l9 = lArray2[i];
                if (l9 > Integer.MAX_VALUE) {
                    throw new TIFFException("For frame " + i + ", compressed pixelByteCount to be read " + l9 + " exceeds maximum Java array size " + Integer.MAX_VALUE + " and fragmentation not yet supported");
                }
                byte[] byArray3 = new byte[(int)l9];
                tIFFFile.seek(l8);
                tIFFFile.read(byArray3);
                if (byArray != null) {
                    byArray3 = TIFFPixelMessageDigest.insertJPEGTablesIntoAbbreviatedBitStream(byArray3, byArray);
                }
                if (l4 == 7L && l5 == 2L) {
                    slf4jlogger.trace("JPEG RGB so adding APP14");
                    byArray3 = TIFFPixelMessageDigest.insertAdobeAPP14WithRGBTransformIntoBitStream(byArray3);
                }
                BufferedImage bufferedImage = compressedFrameDecoder.getDecompressedFrameAsBufferedImage(byArray3);
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug(BufferedImageUtilities.describeImage(bufferedImage));
                }
                byte[] byArray4 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                messageDigest.update(byArray4);
            }
        }
        return messageDigest.digest();
    }

    public TIFFPixelMessageDigest(String string) throws IOException, TIFFException, NumberFormatException {
        TIFFImageFileDirectories tIFFImageFileDirectories = new TIFFImageFileDirectories();
        tIFFImageFileDirectories.read(string);
        int n = 0;
        ArrayList<TIFFImageFileDirectory> arrayList = tIFFImageFileDirectories.getListOfImageFileDirectories();
        for (TIFFImageFileDirectory tIFFImageFileDirectory : arrayList) {
            slf4jlogger.info("Directory={}", n);
            long l = tIFFImageFileDirectory.getSingleNumericValue(256, 0, 0L);
            slf4jlogger.debug("imageWidth={}", l);
            long l2 = tIFFImageFileDirectory.getSingleNumericValue(257, 0, 0L);
            slf4jlogger.debug("imageLength={}", l2);
            long l3 = tIFFImageFileDirectory.getSingleNumericValue(258, 0, 0L);
            slf4jlogger.debug("bitsPerSample={}", l3);
            long l4 = tIFFImageFileDirectory.getSingleNumericValue(259, 0, 0L);
            slf4jlogger.debug("compression={}", l4);
            long l5 = tIFFImageFileDirectory.getSingleNumericValue(262, 0, 0L);
            slf4jlogger.debug("photometric={}", l5);
            long l6 = tIFFImageFileDirectory.getSingleNumericValue(277, 0, 0L);
            slf4jlogger.debug("samplesPerPixel={}", l6);
            byte[] byArray = null;
            if (l4 == 7L && (byArray = tIFFImageFileDirectory.getByteValues(347)) != null) {
                slf4jlogger.debug("jpegTables present");
                byArray = TIFFPixelMessageDigest.stripSOIEOIMarkers(byArray);
            }
            long l7 = tIFFImageFileDirectory.getSingleNumericValue(322, 0, 0L);
            slf4jlogger.debug("tileWidth={}", l7);
            long l8 = tIFFImageFileDirectory.getSingleNumericValue(323, 0, 0L);
            slf4jlogger.debug("tileLength={}", l8);
            byte[] byArray2 = null;
            try {
                int n2;
                long[] lArray = tIFFImageFileDirectory.getNumericValues(324);
                long[] lArray2 = tIFFImageFileDirectory.getNumericValues(325);
                if (lArray != null) {
                    n2 = lArray.length;
                    if (lArray2.length != n2) {
                        throw new TIFFException("Number of tiles uncertain: tileOffsets length = " + lArray.length + " different from tileByteCounts length " + lArray2.length);
                    }
                } else {
                    throw new TIFFException("Unsupported encoding");
                }
                slf4jlogger.debug("numberOfTiles={}", n2);
                byArray2 = this.computePixelMessageDigestFromTiles(tIFFImageFileDirectories.getFile(), n2, lArray, lArray2, l7, l8, l3, l4, l5, byArray);
            }
            catch (Exception exception) {
                slf4jlogger.error("Failed to compute Message Digest: ", exception);
            }
            if (byArray2 != null) {
                slf4jlogger.info("Digest={}", DatatypeConverter.printHexBinary(byArray2).toLowerCase());
            } else {
                slf4jlogger.error("Failed to compute Message Digest");
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 1) {
                String string = stringArray[0];
                new TIFFPixelMessageDigest(string);
            } else {
                System.err.println("Error: Incorrect number of arguments or bad arguments");
                System.err.println("Usage: TIFFPixelMessageDigest inputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

