/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.convert;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.OtherByteAttributeOnDisk;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UnencapsulateData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/convert/UnencapsulateData.java,v 1.3 2019/05/10 16:41:30 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(UnencapsulateData.class);
    private static final int BUFSIZE = 32768;

    public UnencapsulateData(String string, String string2) throws FileNotFoundException, IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        Attribute attribute = attributeList.get(TagFromName.EncapsulatedDocument);
        if (attribute == null) {
            throw new DicomException("Missing EncapsulatedDocument Attribute");
        }
        long l = Attribute.getSingleLongValueOrDefault(attributeList, TagFromName.EncapsulatedDocumentLength, 0L);
        if (l == 0L) {
            l = attribute.getVL();
        }
        slf4jlogger.debug("UnencapsulateData(): encapsulatedDocumentLength = {}", l);
        FileOutputStream fileOutputStream = new FileOutputStream(string2);
        if (l > 0L) {
            if (attribute instanceof OtherByteAttributeOnDisk) {
                slf4jlogger.debug("UnencapsulateData(): OtherByteAttributeOnDisk");
                long l2 = ((OtherByteAttributeOnDisk)attribute).getByteOffset();
                File file = ((OtherByteAttributeOnDisk)attribute).getFile();
                int n = l < 32768L ? (int)l : 32768;
                byte[] byArray = new byte[n];
                try {
                    int n2;
                    BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(file), false);
                    binaryInputStream.skipInsistently(l2);
                    for (long i = l; i > 0L; i -= (long)n2) {
                        n2 = i > 32768L ? 32768 : (int)i;
                        binaryInputStream.readInsistently(byArray, 0, n2);
                        ((OutputStream)fileOutputStream).write(byArray, 0, n2);
                    }
                    binaryInputStream.close();
                }
                catch (IOException iOException) {
                    slf4jlogger.error("", iOException);
                    throw new DicomException("Failed to read value (length " + l + " dec) in read of EncapsulatedDocument from disk");
                }
            } else {
                slf4jlogger.debug("UnencapsulateData(): OtherByteAttribute in memory");
                byte[] byArray = attribute.getByteValues();
                ((OutputStream)fileOutputStream).write(byArray, 0, (int)l);
            }
        }
        ((OutputStream)fileOutputStream).close();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 2) {
                String string = stringArray[0];
                String string2 = stringArray[1];
                new UnencapsulateData(string, string2);
            } else {
                System.err.println("Error: Incorrect number of arguments");
                System.err.println("Usage: UnencapsulateData inputFile outputFile");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

