/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.query.QueryResponseGeneratorFactory;
import com.pixelmed.query.RetrieveResponseGeneratorFactory;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.hsqldb.Server;

public abstract class DatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseInformationModel.java,v 1.87 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DatabaseInformationModel.class);
    public static final String FILE_COPIED = "C";
    public static final String FILE_REFERENCED = "R";
    protected static final String defaultDatabaseRootName = "Local database";
    protected static final String localPrimaryKeyColumnName = "LOCALPRIMARYKEY";
    protected static final String localParentReferenceColumnName = "LOCALPARENTREFERENCE";
    protected static final String localRecordInsertionTimeColumnName = "RECORDINSERTIONTIME";
    protected static final String localFileName = "LOCALFILENAME";
    protected static final String localFileReferenceTypeColumnName = "LOCALFILEREFERENCETYPE";
    protected static final String personNameCanonicalColumnNamePrefix = "PM_";
    protected static final String personNameCanonicalColumnNameSuffix = "_CANONICAL";
    protected static final String personNamePhoneticCanonicalColumnNamePrefix = "PM_";
    protected static final String personNamePhoneticCanonicalColumnNameSuffix = "_PHONETICCANONICAL";
    protected static final String userColumnName1 = "PM_USER1";
    protected static final String userColumnName2 = "PM_USER2";
    protected static final String userColumnName3 = "PM_USER3";
    protected static final String userColumnName4 = "PM_USER4";
    protected InformationEntity rootInformationEntity;
    protected HashMap listsOfAttributesByInformationEntity;
    protected HashMap additionalIndexMapOfColumnsToTables;
    protected Connection databaseConnection;
    protected Server externalServerInstance;
    protected DicomDictionary dictionary;
    protected String databaseRootName;
    private Map descriptiveNameMap;
    private HashSet localColumnExcludeList;
    private HashMap mapOfInformationEntitiesToColumnNames;

    DicomDictionary getDicomDictionary() {
        return this.dictionary;
    }

    String getDatabaseRootName() {
        return this.databaseRootName;
    }

    HashSet getLocalColumnExcludeList() {
        return this.localColumnExcludeList;
    }

    void makeLocalColumnExcludeList() {
        this.localColumnExcludeList = new HashSet();
        this.localColumnExcludeList.add(localPrimaryKeyColumnName);
        this.localColumnExcludeList.add(localParentReferenceColumnName);
        this.localColumnExcludeList.add(localRecordInsertionTimeColumnName);
        this.localColumnExcludeList.add(localFileName);
        this.localColumnExcludeList.add(localFileReferenceTypeColumnName);
    }

    public DatabaseInformationModel(String string, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        this.doCommonConstructorStuff(string, null, informationEntity, dicomDictionary, defaultDatabaseRootName);
    }

    public DatabaseInformationModel(String string, InformationEntity informationEntity, DicomDictionary dicomDictionary, String string2) throws DicomException {
        this.doCommonConstructorStuff(string, null, informationEntity, dicomDictionary, string2);
    }

    public DatabaseInformationModel(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary) throws DicomException {
        this.doCommonConstructorStuff(string, string2, informationEntity, dicomDictionary, defaultDatabaseRootName);
    }

    public DatabaseInformationModel(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary, String string3) throws DicomException {
        this.doCommonConstructorStuff(string, string2, informationEntity, dicomDictionary, string3);
    }

    protected void doCommonConstructorStuff(String string, String string2, InformationEntity informationEntity, DicomDictionary dicomDictionary, String string3) throws DicomException {
        Object object;
        slf4jlogger.debug("DatabaseInformationModel.doCommonConstructorStuff(): databaseFileName = {}", string);
        this.databaseRootName = string3;
        this.rootInformationEntity = informationEntity;
        this.dictionary = dicomDictionary;
        if (this.dictionary == null) {
            slf4jlogger.debug("DatabaseInformationModel.doCommonConstructorStuff(): no dictionary supplied so using default");
            this.dictionary = DicomDictionary.StandardDictionary;
        } else {
            slf4jlogger.debug("DatabaseInformationModel.doCommonConstructorStuff(): dictionary class = {}", dicomDictionary.getClass());
        }
        this.listsOfAttributesByInformationEntity = new HashMap(6);
        this.additionalIndexMapOfColumnsToTables = new HashMap();
        this.makeLocalColumnExcludeList();
        try {
            Class.forName("org.hsqldb.jdbcDriver").newInstance();
            object = new Properties();
            ((Properties)object).put("user", "sa");
            ((Properties)object).put("password", "");
            ((Properties)object).put("hsqldb.cache_file_scale", "8");
            ((Properties)object).put("sql.enforce_size", "FALSE");
            ((Properties)object).put("sql.enforce_strict_size", "FALSE");
            this.databaseConnection = DriverManager.getConnection("jdbc:hsqldb:" + string, (Properties)object);
            slf4jlogger.debug("DatabaseInformationModel(): first call to primeListsOfAttributesByInformationEntityFromExistingMetaData() to see if tables exist");
            this.primeListsOfAttributesByInformationEntityFromExistingMetaData();
            if (this.listsOfAttributesByInformationEntity.size() == 0) {
                slf4jlogger.debug("DatabaseInformationModel(): our tables do not exist, create them");
                this.createTables();
                slf4jlogger.debug("DatabaseInformationModel(): second call to primeListsOfAttributesByInformationEntityFromExistingMetaData() now that we have added our tables");
                this.primeListsOfAttributesByInformationEntityFromExistingMetaData();
            }
            this.createDescriptiveNameMap();
        }
        catch (Exception exception) {
            throw new DicomException("Cannot connect to database: " + exception);
        }
        if (string2 != null && string2.trim().length() > 0) {
            slf4jlogger.debug("DatabaseInformationModel.doCommonConstructorStuff(): attempting to start external database server named = {}", string2);
            try {
                object = "database.0=" + string + ";dbname.0=" + string2;
                this.externalServerInstance = new Server();
                this.externalServerInstance.setLogWriter(null);
                this.externalServerInstance.setErrWriter(null);
                this.externalServerInstance.putPropertiesFromString((String)object);
                this.externalServerInstance.start();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot create additional server instance of database for external access: " + exception);
            }
        } else {
            this.externalServerInstance = null;
        }
    }

    public void close() {
        if (this.externalServerInstance != null) {
            slf4jlogger.debug("DatabaseInformationModel.close(): externalServerInstance shutdown start");
            this.externalServerInstance.shutdown();
            slf4jlogger.debug("DatabaseInformationModel.close(): externalServerInstance shutdown finished");
            this.externalServerInstance = null;
        }
        if (this.databaseConnection != null) {
            slf4jlogger.debug("DatabaseInformationModel.close(): shutdown compact start");
            try {
                Statement statement = this.databaseConnection.createStatement();
                statement.execute("SHUTDOWN COMPACT;");
                statement.close();
            }
            catch (SQLException sQLException) {
                slf4jlogger.error("Ignoring exception during database shutdown compact: ", sQLException.toString());
            }
            slf4jlogger.debug("DatabaseInformationModel.close(): shutdown compact finished");
            try {
                this.databaseConnection.close();
            }
            catch (SQLException sQLException) {
                slf4jlogger.error("Ignoring exception during database close: ", sQLException.toString());
            }
            this.databaseConnection = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    Statement createStatement() throws SQLException {
        return this.databaseConnection.createStatement();
    }

    InformationEntity getRootInformationEntity() {
        return this.rootInformationEntity;
    }

    protected abstract boolean isInformationEntityInModel(InformationEntity var1);

    protected boolean isInformationEntityInModel(String string) {
        InformationEntity informationEntity = InformationEntity.fromString(string);
        return informationEntity == null ? false : this.isInformationEntityInModel(informationEntity);
    }

    Map getDescriptiveNameMap() {
        return this.descriptiveNameMap;
    }

    private void createDescriptiveNameMap() throws DicomException {
        this.descriptiveNameMap = new HashMap();
        Iterator iterator = this.dictionary.getTagIterator();
        while (iterator.hasNext()) {
            AttributeTag attributeTag = (AttributeTag)iterator.next();
            String string = this.dictionary.getNameFromTag(attributeTag);
            String string2 = DatabaseInformationModel.getDatabaseColumnNameFromDicomName(string);
            if (string == null || string2 == null) continue;
            this.descriptiveNameMap.put(string2, string);
        }
    }

    public String getDatabaseColumnNameFromDicomTag(AttributeTag attributeTag) {
        String string = null;
        if (this.dictionary != null) {
            string = DatabaseInformationModel.getDatabaseColumnNameFromDicomName(this.dictionary.getNameFromTag(attributeTag));
        }
        return string;
    }

    public static String getDatabaseColumnNameFromDicomName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = string.toUpperCase(Locale.US);
        }
        return string2;
    }

    public String getDicomNameFromDatabaseColumnName(String string) {
        String string2 = null;
        if (string != null) {
            string2 = (String)this.descriptiveNameMap.get(string);
        }
        return string2;
    }

    public AttributeTag getAttributeTagFromDatabaseColumnName(String string) {
        AttributeTag attributeTag = null;
        String string2 = this.getDicomNameFromDatabaseColumnName(string);
        if (string2 != null) {
            attributeTag = this.dictionary.getTagFromName(string2);
        }
        return attributeTag;
    }

    private void createTables() throws DicomException {
        InformationEntity informationEntity = this.rootInformationEntity;
        while (informationEntity != null) {
            this.createTable(informationEntity, informationEntity != this.rootInformationEntity);
            informationEntity = this.getChildTypeForParent(informationEntity);
        }
        this.createAdditionalIndexes();
    }

    private void createTable(InformationEntity informationEntity, boolean bl) throws DicomException {
        Statement statement;
        StringBuffer stringBuffer;
        String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
        if (string == null) {
            throw new DicomException("Internal error: Cannot get name for table from " + informationEntity);
        }
        try {
            stringBuffer = new StringBuffer();
            stringBuffer.append("CREATE CACHED TABLE ");
            stringBuffer.append(string);
            stringBuffer.append(" (");
            this.extendCreateStatementStringWithMandatoryColumns(stringBuffer, bl, informationEntity);
            this.extendCreateStatementStringWithAttributesInDicomDictionary(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithAnyExtraAttributes(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithDerivedAttributes(stringBuffer, informationEntity);
            this.extendCreateStatementStringWithUserColumns(stringBuffer, informationEntity);
            stringBuffer.append(")");
            statement = this.databaseConnection.createStatement();
            statement.execute(stringBuffer.toString());
            statement.close();
        }
        catch (Exception exception) {
            throw new DicomException("Cannot create table " + string + " in database: " + exception);
        }
        if (bl) {
            try {
                stringBuffer = new StringBuffer();
                stringBuffer.append("CREATE INDEX ");
                stringBuffer.append(string);
                stringBuffer.append("_PREFIDX ON ");
                stringBuffer.append(string);
                stringBuffer.append(" (");
                stringBuffer.append(localParentReferenceColumnName);
                stringBuffer.append(")");
                statement = this.databaseConnection.createStatement();
                statement.execute(stringBuffer.toString());
                statement.close();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot create index of parents for " + string + " in database: " + exception);
            }
        }
    }

    protected void createAdditionalIndexes() throws DicomException {
        slf4jlogger.debug("DatabaseInformationModel.createAdditionalIndexes():");
        if (this.additionalIndexMapOfColumnsToTables != null) {
            for (String string : this.additionalIndexMapOfColumnsToTables.keySet()) {
                String string2 = (String)this.additionalIndexMapOfColumnsToTables.get(string);
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("CREATE INDEX ");
                    stringBuffer.append(string2);
                    stringBuffer.append("_");
                    stringBuffer.append(string);
                    stringBuffer.append("_IDX ON ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" (");
                    stringBuffer.append(string);
                    stringBuffer.append(")");
                    Statement statement = this.databaseConnection.createStatement();
                    statement.execute(stringBuffer.toString());
                    statement.close();
                }
                catch (Exception exception) {
                    throw new DicomException("Cannot create index of " + string + " for " + string2 + " in database: " + exception);
                }
            }
        }
    }

    private void extendCreateStatementStringWithMandatoryColumns(StringBuffer stringBuffer, boolean bl, InformationEntity informationEntity) {
        slf4jlogger.debug("extendCreateStatementStringWithMandatoryColumns(): for ie {}", informationEntity.toString());
        stringBuffer.append(localPrimaryKeyColumnName);
        stringBuffer.append(" VARCHAR");
        stringBuffer.append(" PRIMARY KEY");
        if (bl) {
            stringBuffer.append(", ");
            stringBuffer.append(localParentReferenceColumnName);
            stringBuffer.append(" VARCHAR");
        }
        stringBuffer.append(",");
        stringBuffer.append(localRecordInsertionTimeColumnName);
        stringBuffer.append(" BIGINT");
        if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(",");
            stringBuffer.append(localFileName);
            stringBuffer.append(" VARCHAR");
            stringBuffer.append(",");
            stringBuffer.append(localFileReferenceTypeColumnName);
            stringBuffer.append(" CHAR(1)");
        }
    }

    private void extendCreateStatementStringWithAttributesInDicomDictionary(StringBuffer stringBuffer, InformationEntity informationEntity) {
        slf4jlogger.debug("extendCreateStatementStringWithAttributesInDicomDictionary(): for ie {}", informationEntity.toString());
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("extendCreateStatementStringWithAttributesInDicomDictionary(): for dictionary is {}", this.dictionary.getClass());
        }
        Iterator iterator = this.dictionary.getTagIterator();
        while (iterator.hasNext()) {
            AttributeTag attributeTag = (AttributeTag)iterator.next();
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("extendCreateStatementStringWithAttributesInDicomDictionary(): tag = ", attributeTag.toString());
            }
            if (informationEntity != this.dictionary.getInformationEntityFromTag(attributeTag)) continue;
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            byte[] byArray = this.dictionary.getValueRepresentationFromTag(attributeTag);
            String string3 = DatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(byArray);
            if (string2 == null || string3 == null) continue;
            slf4jlogger.debug("extendCreateStatementStringWithAttributesInDicomDictionary(): {} = {} {} {}", string2, string, string3, this.isAttributeUsedInTable(string, string2));
            stringBuffer.append(", ");
            stringBuffer.append(string2);
            stringBuffer.append(" ");
            stringBuffer.append(string3);
            if (!ValueRepresentation.isPersonNameVR(byArray)) continue;
            this.extendCreateStatementStringWithPersonNameSearchColumns(stringBuffer, string2, string);
        }
    }

    private void extendCreateStatementStringWithPersonNameSearchColumns(StringBuffer stringBuffer, String string, String string2) {
        slf4jlogger.debug("extendCreateStatementStringWithPersonNameSearchColumns(): columnName = {} tableName = {}", string, string2);
        String string3 = "PM_" + string + personNameCanonicalColumnNameSuffix;
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
        this.additionalIndexMapOfColumnsToTables.put(string3, string2);
        string3 = "PM_" + string + personNamePhoneticCanonicalColumnNameSuffix;
        stringBuffer.append(", ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
        this.additionalIndexMapOfColumnsToTables.put(string3, string2);
    }

    protected void extendCreateStatementStringWithAnyExtraAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
    }

    protected void extendCreateStatementStringWithDerivedAttributes(StringBuffer stringBuffer, InformationEntity informationEntity) {
    }

    protected void extendCreateStatementStringWithUserColumns(StringBuffer stringBuffer, InformationEntity informationEntity) {
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName1);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName2);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName3);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
        stringBuffer.append(", ");
        stringBuffer.append(userColumnName4);
        stringBuffer.append(" ");
        stringBuffer.append("VARCHAR");
    }

    private void extendTablesAsNecessary(AttributeList attributeList) throws DicomException {
        DicomDictionary dicomDictionary = attributeList.getDictionary();
        for (Attribute attribute : attributeList.values()) {
            AttributeTag attributeTag = attribute.getTag();
            InformationEntity informationEntity = dicomDictionary.getInformationEntityFromTag(attributeTag);
            if (informationEntity == null) continue;
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            String string2 = this.getDatabaseColumnNameFromDicomTag(attributeTag);
            String string3 = DatabaseInformationModel.getSQLTypeFromDicomValueRepresentation(attribute.getVR());
            if (string2 == null || string3 == null || this.isAttributeUsedInTable(string, string2)) continue;
            slf4jlogger.debug("{} {} = {} {} ", attribute.toString(), string2, string, string3, this.isAttributeUsedInTable(string, string2));
            try {
                Statement statement = this.databaseConnection.createStatement();
                statement.execute("ALTER TABLE " + string + " ADD COLUMN " + string2 + " " + string3);
                statement.close();
            }
            catch (Exception exception) {
                throw new DicomException("Cannot add column " + string2 + " to table " + string + " in database: " + exception);
            }
        }
    }

    public void deleteSelectedRecord(InformationEntity informationEntity, String string) throws DicomException {
        this.deleteRecord(informationEntity, string);
    }

    public void deleteRecord(InformationEntity informationEntity, String string) throws DicomException {
        slf4jlogger.debug("DatabaseInformationModel.deleteRecord(): ie = {}", informationEntity);
        slf4jlogger.debug("DatabaseInformationModel.deleteRecord(): localPrimaryKeyValue = {}", string);
        if (informationEntity != null && string != null && string.length() > 0) {
            try {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                slf4jlogger.debug("DatabaseInformationModel.deleteRecord(): tableName = {}", string2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DELETE FROM ");
                stringBuffer.append(string2);
                stringBuffer.append(" WHERE ");
                stringBuffer.append(localPrimaryKeyColumnName);
                stringBuffer.append(" = '");
                stringBuffer.append(string);
                stringBuffer.append("'");
                Statement statement = this.databaseConnection.createStatement();
                String string3 = stringBuffer.toString();
                slf4jlogger.debug("DatabaseInformationModel.deleteRecord(): Statement to execute = {}", string3);
                statement.execute(string3);
                statement.close();
            }
            catch (Exception exception) {
                slf4jlogger.error("Rethrowing database exception during deleteRecord as DicomException", exception);
                throw new DicomException("Cannot perform deletion: " + exception);
            }
        }
    }

    public void insertObject(AttributeList attributeList, String string) throws DicomException {
        this.insertObject(attributeList, string, "");
    }

    public void insertObject(AttributeList attributeList, String string, String string2) throws DicomException {
        slf4jlogger.debug("DatabaseInformationModel.insertObject(): fileName = " + string);
        try {
            InformationEntity informationEntity = this.rootInformationEntity;
            String string3 = null;
            while (informationEntity != null) {
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ");
                stringBuffer.append(localPrimaryKeyColumnName);
                stringBuffer.append(" FROM ");
                stringBuffer.append(string4);
                stringBuffer.append(" WHERE ");
                if (informationEntity != this.rootInformationEntity) {
                    stringBuffer.append(string4);
                    stringBuffer.append(".");
                    stringBuffer.append(localParentReferenceColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string3);
                    stringBuffer.append("'");
                }
                this.extendStatementStringWithMatchingAttributesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                Statement statement = this.databaseConnection.createStatement();
                String string5 = stringBuffer.toString();
                slf4jlogger.debug("DatabaseInformationModel.insertObject(): Statement to execute = {}", string5);
                ResultSet resultSet = statement.executeQuery(string5);
                String string6 = null;
                int n = 0;
                while (resultSet.next()) {
                    string6 = resultSet.getString(localPrimaryKeyColumnName).trim();
                    ++n;
                }
                slf4jlogger.debug("DatabaseInformationModel.insertObject(): ie = {} count = {} entityPrimaryKey = ", informationEntity, n, string6);
                if (n != 1 || string6 == null) {
                    slf4jlogger.debug("DatabaseInformationModel.insertObject(): Inserting new row in {}", string4);
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("INSERT INTO ");
                    stringBuffer.append(string4);
                    stringBuffer.append(" (");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    if (informationEntity != this.rootInformationEntity) {
                        stringBuffer.append(",");
                        stringBuffer.append(localParentReferenceColumnName);
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(localRecordInsertionTimeColumnName);
                    this.extendInsertStatementStringWithAttributeNamesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    this.extendInsertStatementStringWithDerivedAttributeNamesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    this.extendInsertStatementStringWithPersonNameSearchColumnsForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    stringBuffer.append(") VALUES ('");
                    string6 = this.createPrimaryKeyForSelectedInformationEntity(informationEntity);
                    stringBuffer.append(string6);
                    stringBuffer.append("'");
                    if (informationEntity != this.rootInformationEntity) {
                        stringBuffer.append(",'");
                        slf4jlogger.debug("DatabaseInformationModel.insertObject(): localParentReference = <{}>", string3);
                        slf4jlogger.debug("DatabaseInformationModel.insertObject(): localParentReference.length() = {}", string3.length());
                        stringBuffer.append(string3);
                        stringBuffer.append("'");
                    }
                    stringBuffer.append(",");
                    stringBuffer.append(Long.toString(System.currentTimeMillis()));
                    this.extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity, string, string2);
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("DatabaseInformationModel.insertObject(): After extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity = {}", stringBuffer.toString());
                    }
                    this.extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("DatabaseInformationModel.insertObject(): After extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity = {}", stringBuffer.toString());
                    }
                    this.extendInsertStatementStringWithPersonNameSearchValuesForSelectedInformationEntity(stringBuffer, attributeList, informationEntity);
                    stringBuffer.append(")");
                    string5 = stringBuffer.toString();
                    slf4jlogger.debug("DatabaseInformationModel.insertObject(): Statement to execute = {}", string5);
                    statement.execute(string5);
                }
                statement.close();
                slf4jlogger.debug("DatabaseInformationModel.insertObject(): Done {} entityPrimaryKey = {} localParentReference = {}", string4, string6, string3);
                string3 = string6;
                informationEntity = this.getChildTypeForParent(informationEntity, attributeList);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during insertObject as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
    }

    private void extendStatementStringWithListOfAllTables(StringBuffer stringBuffer) {
        InformationEntity informationEntity = this.rootInformationEntity;
        while (informationEntity != null) {
            if (informationEntity != this.rootInformationEntity) {
                stringBuffer.append(",");
            }
            String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
            stringBuffer.append(string);
            informationEntity = this.getChildTypeForParent(informationEntity);
        }
    }

    protected abstract void extendInsertStatementStringWithPersonNameSearchColumnsForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithPersonNameSearchValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendStatementStringWithMatchingAttributesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithAttributeNamesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3, String var4) throws DicomException;

    protected abstract void extendInsertStatementStringWithAttributeValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3, String var4, String var5) throws DicomException;

    protected abstract void extendInsertStatementStringWithDerivedAttributeNamesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract void extendInsertStatementStringWithDerivedAttributeValuesForSelectedInformationEntity(StringBuffer var1, AttributeList var2, InformationEntity var3) throws DicomException;

    protected abstract String createPrimaryKeyForSelectedInformationEntity(InformationEntity var1);

    private void primeListsOfAttributesByInformationEntityFromExistingMetaData() throws SQLException {
        DatabaseMetaData databaseMetaData = this.databaseConnection.getMetaData();
        ResultSet resultSet = databaseMetaData.getColumns(null, null, null, null);
        while (resultSet.next()) {
            String string = resultSet.getString(3);
            String string2 = resultSet.getString(4);
            slf4jlogger.debug("DatabaseInformationModel.primeListsOfAttributesByInformationEntityFromExistingMetaData(): tableName = {} columnName = {}", string, string2);
            if (string == null || string2 == null || !this.isInformationEntityInModel(string)) continue;
            slf4jlogger.debug("DatabaseInformationModel.primeListsOfAttributesByInformationEntityFromExistingMetaData(): non-null and tableName is in the model");
            LinkedList<String> linkedList = (LinkedList<String>)this.listsOfAttributesByInformationEntity.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                this.listsOfAttributesByInformationEntity.put(string, linkedList);
            }
            slf4jlogger.debug("DatabaseInformationModel.primeListsOfAttributesByInformationEntityFromExistingMetaData(): adding to table {} {}", string, string2);
            linkedList.add(string2);
        }
        resultSet.close();
    }

    boolean isAttributeUsedInTable(InformationEntity informationEntity, String string) {
        return informationEntity == null ? false : this.isAttributeUsedInTable(DatabaseInformationModel.getTableNameForInformationEntity(informationEntity), string);
    }

    boolean isAttributeUsedInTable(String string, String string2) {
        LinkedList linkedList;
        if (this.listsOfAttributesByInformationEntity != null && (linkedList = (LinkedList)this.listsOfAttributesByInformationEntity.get(string.toUpperCase(Locale.US))) != null) {
            if (linkedList.contains(string2.toUpperCase(Locale.US))) {
                slf4jlogger.debug("isAttributeUsedInTable(String,String): {} contains {}", string, string2);
                return true;
            }
            slf4jlogger.debug("isAttributeUsedInTable(String,String): {} does not contain {}", string, string2);
        }
        return false;
    }

    public void updateSelectedRecord(InformationEntity informationEntity, String string, String string2, String string3) throws DicomException {
        slf4jlogger.debug("DatabaseInformationModel.updateSelectedRecord(): {} {} {} {}", informationEntity, string, string2, string3);
        try {
            if (informationEntity != null) {
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("UPDATE ");
                stringBuffer.append(string4);
                if (string2 != null) {
                    stringBuffer.append(" SET ");
                    stringBuffer.append(string2);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string3);
                    stringBuffer.append("'");
                }
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                statement.execute(stringBuffer.toString());
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during updateSelectedRecord as DicomException", exception);
            throw new DicomException("Cannot perform update: " + exception);
        }
    }

    public Map findAllAttributeValuesForSelectedRecord(InformationEntity informationEntity, String string) throws DicomException {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        try {
            if (informationEntity != null) {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string2);
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                if (resultSet.next()) {
                    for (int i = 1; i <= n; ++i) {
                        String string3 = resultSetMetaData.getColumnName(i);
                        String string4 = resultSet.getString(i);
                        slf4jlogger.debug("findAllAttributeValuesForSelectedRecord: [{}] key = {} value = {}", i, string3, string4);
                        treeMap.put(string3, string4);
                    }
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return treeMap;
    }

    public String findSelectedAttributeValuesForSelectedRecord(InformationEntity informationEntity, String string, String string2) throws DicomException {
        String string3 = "";
        try {
            if (informationEntity != null) {
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT ");
                stringBuffer.append(string2);
                stringBuffer.append(" FROM ");
                stringBuffer.append(string4);
                if (string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localPrimaryKeyColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                if (resultSet.next() && n == 1 && resultSetMetaData.getColumnName(1).equals(string2.toUpperCase())) {
                    string3 = resultSet.getString(1);
                    slf4jlogger.debug("findSelectedAttributeValuesForSelectedRecord: key = {} value = {}", string2, string3);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return string3;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntity(InformationEntity informationEntity) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null) {
                String string = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string);
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string2 = resultSetMetaData.getColumnName(i);
                        String string3 = resultSet.getString(i);
                        slf4jlogger.debug("findAllAttributeValuesForAllRecordsForThisInformationEntity: [{}] key = {} value = {}", i, string2, string3);
                        treeMap.put(string2, string3);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity informationEntity, String string) throws DicomException {
        return this.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(informationEntity, this.getUIDColumnNameForInformationEntity(informationEntity), string);
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity informationEntity, String string, String string2) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null && string != null && string2 != null) {
                String string3 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string3);
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string);
                stringBuffer.append(" = ");
                stringBuffer.append("'");
                stringBuffer.append(string2);
                stringBuffer.append("'");
                stringBuffer.append(";");
                String string4 = stringBuffer.toString();
                slf4jlogger.debug("findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(): statement to execute = {}", string4);
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(string4);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string5 = resultSetMetaData.getColumnName(i);
                        String string6 = resultSet.getString(i);
                        slf4jlogger.debug("findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(): [" + i + "] key = {}", string5 + " value = {}", string6);
                        treeMap.put(string5, string6);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    private final String[] getArrayOfColumnNamesForSpecifiedInformationEntity(InformationEntity informationEntity, ResultSet resultSet) throws SQLException {
        String[] stringArray;
        if (this.mapOfInformationEntitiesToColumnNames == null) {
            this.mapOfInformationEntitiesToColumnNames = new HashMap();
        }
        if ((stringArray = (String[])this.mapOfInformationEntitiesToColumnNames.get(informationEntity)) == null) {
            slf4jlogger.debug("getArrayOfColumnNamesForSpecifiedInformationEntity() " + informationEntity.toString() + " caching metadata");
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i <= n; ++i) {
                String string = resultSetMetaData.getColumnName(i);
                arrayList.add(string);
            }
            stringArray = new String[n];
            stringArray = arrayList.toArray(stringArray);
            this.mapOfInformationEntitiesToColumnNames.put(informationEntity, stringArray);
        }
        return stringArray;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent(InformationEntity informationEntity, String string) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null) {
                String string2 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string2);
                if (informationEntity != this.rootInformationEntity && string != null) {
                    stringBuffer.append(" WHERE ");
                    stringBuffer.append(localParentReferenceColumnName);
                    stringBuffer.append(" = '");
                    stringBuffer.append(string);
                    stringBuffer.append("'");
                }
                stringBuffer.append(";");
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                String[] stringArray = this.getArrayOfColumnNamesForSpecifiedInformationEntity(informationEntity, resultSet);
                int n = stringArray.length;
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string3 = stringArray[i - 1];
                        String string4 = resultSet.getString(i);
                        slf4jlogger.debug("findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedParent: [{}] key = {} value = {}", i, string3, string4);
                        treeMap.put(string3, string4);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    public ArrayList findAllAttributeValuesForAllRecordsForThisInformationEntityWithMatchingParent(InformationEntity informationEntity, InformationEntity informationEntity2, String string, String string2) throws DicomException {
        ArrayList arrayList = new ArrayList();
        try {
            if (informationEntity != null && informationEntity2 != null) {
                String string3 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity);
                String string4 = DatabaseInformationModel.getTableNameForInformationEntity(informationEntity2);
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("SELECT * FROM ");
                stringBuffer.append(string3);
                stringBuffer.append(",");
                stringBuffer.append(string4);
                stringBuffer.append(" WHERE ");
                stringBuffer.append(string3);
                stringBuffer.append(".");
                stringBuffer.append(localParentReferenceColumnName);
                stringBuffer.append(" = ");
                stringBuffer.append(string4);
                stringBuffer.append(".");
                stringBuffer.append(localPrimaryKeyColumnName);
                stringBuffer.append(" AND ");
                stringBuffer.append(string4);
                stringBuffer.append(".");
                stringBuffer.append(string);
                stringBuffer.append(" = '");
                stringBuffer.append(string2);
                stringBuffer.append("'");
                stringBuffer.append(";");
                String string5 = stringBuffer.toString();
                slf4jlogger.debug("findSelectedAttributeValueForAllRecordsForThisInformationEntityWithMatchingParent: {}", string5);
                Statement statement = this.databaseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(string5);
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    TreeMap<String, String> treeMap = new TreeMap<String, String>();
                    for (int i = 1; i <= n; ++i) {
                        String string6 = resultSetMetaData.getColumnName(i);
                        String string7 = resultSet.getString(i);
                        slf4jlogger.debug("findSelectedAttributeValueForAllRecordsForThisInformationEntityWithMatchingParent: [{}] key = {} value = {}", i, string6, string7);
                        treeMap.put(string6, string7);
                    }
                    arrayList.add(treeMap);
                }
                statement.close();
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Rethrowing database exception during selection as DicomException", exception);
            throw new DicomException("Cannot perform selection: " + exception);
        }
        return arrayList;
    }

    public static String getTableNameForInformationEntity(InformationEntity informationEntity) {
        return informationEntity.toString().toUpperCase(Locale.US);
    }

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1);

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1, boolean var2);

    public abstract InformationEntity getChildTypeForParent(InformationEntity var1, AttributeList var2);

    public abstract String getNametoDescribeThisInstanceOfInformationEntity(InformationEntity var1, Map var2);

    public abstract String getDescriptiveColumnName(InformationEntity var1);

    public abstract String getOtherDescriptiveColumnName(InformationEntity var1);

    public abstract String getOtherOtherDescriptiveColumnName(InformationEntity var1);

    public abstract String getUIDColumnNameForInformationEntity(InformationEntity var1);

    public String getLocalPrimaryKeyColumnName(InformationEntity informationEntity) {
        return localPrimaryKeyColumnName;
    }

    public String getLocalFileNameColumnName(InformationEntity informationEntity) {
        return localFileName;
    }

    public String localFileNameColumnName(InformationEntity informationEntity) {
        return this.getLocalFileNameColumnName(informationEntity);
    }

    public String getLocalFileReferenceTypeColumnName(InformationEntity informationEntity) {
        return localFileReferenceTypeColumnName;
    }

    public String getLocalParentReferenceColumnName(InformationEntity informationEntity) {
        return localParentReferenceColumnName;
    }

    public String getLocalRecordInsertionTimeColumnName(InformationEntity informationEntity) {
        return localRecordInsertionTimeColumnName;
    }

    public static String getSQLTypeFromDicomValueRepresentation(byte[] byArray) {
        Object object = ValueRepresentation.isApplicationEntityVR(byArray) ? "VARCHAR" : (ValueRepresentation.isAgeStringVR(byArray) ? "VARCHAR" : (ValueRepresentation.isCodeStringVR(byArray) ? "VARCHAR" : (ValueRepresentation.isDateVR(byArray) ? "VARCHAR" : (ValueRepresentation.isDateTimeVR(byArray) ? "VARCHAR" : (ValueRepresentation.isDecimalStringVR(byArray) ? "VARCHAR" : (ValueRepresentation.isFloatDoubleVR(byArray) ? "REAL" : (ValueRepresentation.isFloatSingleVR(byArray) ? "REAL" : (ValueRepresentation.isIntegerStringVR(byArray) ? "INTEGER" : (ValueRepresentation.isLongStringVR(byArray) ? "VARCHAR" : (ValueRepresentation.isLongTextVR(byArray) ? "VARCHAR" : (ValueRepresentation.isOtherByteVR(byArray) ? null : (ValueRepresentation.isOtherWordVR(byArray) ? null : (ValueRepresentation.isOtherUnspecifiedVR(byArray) ? null : (ValueRepresentation.isPersonNameVR(byArray) ? "VARCHAR" : (ValueRepresentation.isSequenceVR(byArray) ? null : (ValueRepresentation.isShortStringVR(byArray) ? "VARCHAR" : (ValueRepresentation.isSignedLongVR(byArray) ? "INTEGER" : (ValueRepresentation.isSignedShortVR(byArray) ? "INTEGER" : (ValueRepresentation.isShortTextVR(byArray) ? "VARCHAR" : (ValueRepresentation.isTimeVR(byArray) ? "VARCHAR" : (ValueRepresentation.isUniqueIdentifierVR(byArray) ? "VARCHAR" : (ValueRepresentation.isUnsignedLongVR(byArray) ? "INTEGER" : (ValueRepresentation.isUnknownVR(byArray) ? null : (ValueRepresentation.isUnsignedShortVR(byArray) ? "INTEGER" : (ValueRepresentation.isUnlimitedTextVR(byArray) ? "VARCHAR" : null)))))))))))))))))))))))));
        return object;
    }

    protected static void appendExactOrIsNullMatch(StringBuffer stringBuffer, String string) {
        if (string == null || string.length() == 0 || string.equals("NULL")) {
            stringBuffer.append(" IS NULL");
        } else {
            stringBuffer.append(" =");
            stringBuffer.append(string);
        }
    }

    public QueryResponseGeneratorFactory getQueryResponseGeneratorFactory() {
        slf4jlogger.debug("DatabaseInformationModel.getQueryResponseGeneratorFactory():");
        return null;
    }

    public QueryResponseGeneratorFactory getQueryResponseGeneratorFactory(int n) {
        slf4jlogger.warn("getQueryResponseGeneratorFactory(): Debug level supplied as argument ignored");
        return this.getQueryResponseGeneratorFactory();
    }

    public RetrieveResponseGeneratorFactory getRetrieveResponseGeneratorFactory() {
        slf4jlogger.debug("DatabaseInformationModel.getRetrieveResponseGeneratorFactory():");
        return null;
    }

    public RetrieveResponseGeneratorFactory getRetrieveResponseGeneratorFactory(int n) {
        slf4jlogger.warn("getRetrieveResponseGeneratorFactory(): Debug level supplied as argument ignored");
        return this.getRetrieveResponseGeneratorFactory();
    }

    public InformationEntity getInformationEntityFromTag(AttributeTag attributeTag) {
        return this.dictionary.getInformationEntityFromTag(attributeTag);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.listsOfAttributesByInformationEntity);
        stringBuffer.append("\n");
        try {
            DatabaseMetaData databaseMetaData = this.databaseConnection.getMetaData();
            ResultSet resultSet = databaseMetaData.getColumns(null, null, null, null);
            while (resultSet.next()) {
                stringBuffer.append("catalog = ");
                stringBuffer.append(resultSet.getString(1));
                stringBuffer.append("; ");
                stringBuffer.append("schema  = ");
                stringBuffer.append(resultSet.getString(2));
                stringBuffer.append("; ");
                stringBuffer.append("table   = ");
                stringBuffer.append(resultSet.getString(3));
                stringBuffer.append("; ");
                stringBuffer.append("column  = ");
                stringBuffer.append(resultSet.getString(4));
                stringBuffer.append("; ");
                stringBuffer.append("type    = ");
                stringBuffer.append(resultSet.getString(6));
                stringBuffer.append("; ");
                stringBuffer.append("size    = ");
                stringBuffer.append(resultSet.getInt(7));
                stringBuffer.append("; ");
                stringBuffer.append("\n");
            }
            resultSet.close();
        }
        catch (Exception exception) {
            stringBuffer.append(exception);
        }
        return stringBuffer.toString();
    }
}

