/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DicomDatabaseInformationModel;
import com.pixelmed.database.DicomDictionaryForMinimalPatientStudySeriesInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.TagFromName;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JFrame;

public class MinimalPatientStudySeriesInstanceModel
extends DicomDatabaseInformationModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/MinimalPatientStudySeriesInstanceModel.java,v 1.15 2025/01/29 10:58:06 dclunie Exp $";

    public MinimalPatientStudySeriesInstanceModel(String string) throws DicomException {
        super(string, InformationEntity.PATIENT, new DicomDictionaryForMinimalPatientStudySeriesInstanceModel());
    }

    public MinimalPatientStudySeriesInstanceModel(String string, String string2) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, new DicomDictionaryForMinimalPatientStudySeriesInstanceModel());
    }

    public MinimalPatientStudySeriesInstanceModel(String string, String string2, String string3) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, new DicomDictionaryForMinimalPatientStudySeriesInstanceModel(), string3);
    }

    public MinimalPatientStudySeriesInstanceModel(String string, DicomDictionary dicomDictionary) throws DicomException {
        super(string, InformationEntity.PATIENT, dicomDictionary);
    }

    public MinimalPatientStudySeriesInstanceModel(String string, String string2, DicomDictionary dicomDictionary) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, dicomDictionary);
    }

    public MinimalPatientStudySeriesInstanceModel(String string, String string2, DicomDictionary dicomDictionary, String string3) throws DicomException {
        super(string, string2, InformationEntity.PATIENT, dicomDictionary, string3);
    }

    @Override
    protected boolean isInformationEntityInModel(InformationEntity informationEntity) {
        return informationEntity == InformationEntity.PATIENT || informationEntity == InformationEntity.STUDY || informationEntity == InformationEntity.SERIES || informationEntity == InformationEntity.INSTANCE;
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, boolean bl) {
        if (informationEntity == InformationEntity.PATIENT) {
            return InformationEntity.STUDY;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return InformationEntity.SERIES;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return InformationEntity.INSTANCE;
        }
        return null;
    }

    private InformationEntity getChildTypeForParent(InformationEntity informationEntity, String string) {
        return this.getChildTypeForParent(informationEntity, string != null);
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity) {
        return this.getChildTypeForParent(informationEntity, true);
    }

    @Override
    public InformationEntity getChildTypeForParent(InformationEntity informationEntity, AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ConcatenationUID);
        return this.getChildTypeForParent(informationEntity, string);
    }

    @Override
    public String getDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return "PATIENTNAME";
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYDATE";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIESNUMBER";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "INSTANCENUMBER";
        }
        return null;
    }

    @Override
    public String getOtherDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return null;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYID";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return null;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return null;
        }
        return null;
    }

    @Override
    public String getOtherOtherDescriptiveColumnName(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return "PATIENTID";
        }
        if (informationEntity == InformationEntity.STUDY) {
            return null;
        }
        if (informationEntity == InformationEntity.PROCEDURESTEP) {
            return null;
        }
        if (informationEntity == InformationEntity.SERIES) {
            return null;
        }
        if (informationEntity == InformationEntity.CONCATENATION) {
            return null;
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return null;
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    @Override
    public String getUIDColumnNameForInformationEntity(InformationEntity informationEntity) {
        if (informationEntity == InformationEntity.PATIENT) {
            return null;
        }
        if (informationEntity == InformationEntity.STUDY) {
            return "STUDYINSTANCEUID";
        }
        if (informationEntity == InformationEntity.SERIES) {
            return "SERIESINSTANCEUID";
        }
        if (informationEntity == InformationEntity.INSTANCE) {
            return "SOPINSTANCEUID";
        }
        if (informationEntity == InformationEntity.FRAME) {
            return null;
        }
        return null;
    }

    @Override
    protected void extendStatementStringWithMatchingAttributesForSelectedInformationEntity(StringBuffer stringBuffer, AttributeList attributeList, InformationEntity informationEntity) throws DicomException {
        if (informationEntity == InformationEntity.PATIENT) {
            stringBuffer.append("PATIENT.PATIENTID");
            MinimalPatientStudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, MinimalPatientStudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.PatientID)));
            stringBuffer.append(" AND ");
            stringBuffer.append("PATIENT.PATIENTNAME");
            String string = MinimalPatientStudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.PatientName));
            if (string != null && string.contains("^")) {
                string = string.replaceFirst("\\^+'", "'");
            }
            MinimalPatientStudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, string);
        } else if (informationEntity == InformationEntity.STUDY) {
            stringBuffer.append(" AND ");
            stringBuffer.append("STUDY.STUDYINSTANCEUID");
            MinimalPatientStudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, MinimalPatientStudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.StudyInstanceUID)));
        } else if (informationEntity == InformationEntity.SERIES) {
            stringBuffer.append(" AND ");
            stringBuffer.append("SERIES.SERIESINSTANCEUID");
            MinimalPatientStudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, MinimalPatientStudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SeriesInstanceUID)));
        } else if (informationEntity == InformationEntity.INSTANCE) {
            stringBuffer.append(" AND ");
            stringBuffer.append("INSTANCE.SOPINSTANCEUID");
            MinimalPatientStudySeriesInstanceModel.appendExactOrIsNullMatch(stringBuffer, MinimalPatientStudySeriesInstanceModel.getQuotedEscapedSingleStringValueOrNull(attributeList.get(TagFromName.SOPInstanceUID)));
        }
    }

    @Override
    protected void createAdditionalIndexes() throws DicomException {
        Statement statement;
        super.createAdditionalIndexes();
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX STUDY_UID_IDX ON STUDY (StudyInstanceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of StudyInstanceUID: " + exception);
            bl = false;
        }
        try {
            statement = this.databaseConnection.createStatement();
            statement.execute("CREATE INDEX INSTANCE_UID_IDX ON INSTANCE (SOPInstanceUID)");
            statement.close();
        }
        catch (Exception exception) {
            stringBuffer.append("Cannot create index of SOPInstanceUID: " + exception);
            bl = false;
        }
        if (!bl) {
            throw new DicomException(stringBuffer.toString());
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            Map map;
            int n;
            Cloneable cloneable;
            Object object;
            MinimalPatientStudySeriesInstanceModel minimalPatientStudySeriesInstanceModel = new MinimalPatientStudySeriesInstanceModel("test");
            HashSet<String> hashSet = new HashSet<String>();
            HashSet<String> hashSet2 = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                System.err.print("reading " + (String)object);
                DicomInputStream object2 = new DicomInputStream(new BufferedInputStream(new FileInputStream((String)object)));
                cloneable = new AttributeList();
                ((AttributeList)cloneable).read(object2, TagFromName.PixelData);
                hashSet.add(Attribute.getSingleStringValueOrEmptyString((AttributeList)cloneable, TagFromName.SOPInstanceUID));
                object2.close();
                System.err.print("inserting");
                minimalPatientStudySeriesInstanceModel.insertObject((AttributeList)cloneable, (String)object, "R");
            }
            Object object3 = minimalPatientStudySeriesInstanceModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
            for (String string2 : hashSet) {
                System.err.print("Searching database for uid " + string2);
                cloneable = minimalPatientStudySeriesInstanceModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(InformationEntity.INSTANCE, string2);
                if (cloneable == null) continue;
                for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
                    map = (Map)((ArrayList)cloneable).get(n);
                    string = (String)map.get(object3);
                    System.err.print("Got record # " + n + " " + (String)object3 + " = " + string);
                    hashSet2.add(string);
                }
            }
            object3 = minimalPatientStudySeriesInstanceModel.getLocalFileNameColumnName(InformationEntity.INSTANCE);
            for (String string3 : hashSet2) {
                System.err.print("Searching database for localFileName " + string3);
                cloneable = minimalPatientStudySeriesInstanceModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedKeyValue(InformationEntity.INSTANCE, (String)object3, string3);
                if (cloneable == null) continue;
                for (n = 0; n < ((ArrayList)cloneable).size(); ++n) {
                    map = (Map)((ArrayList)cloneable).get(n);
                    string = (String)map.get(object3);
                    System.err.print("Got record # " + n + " " + (String)object3 + " = " + string + " is expected = " + string.equals(string3));
                    hashSet2.add(string);
                }
            }
            object3 = new JFrame();
            ((Window)object3).setSize(400, 800);
            ((Window)object3).addWindowListener(new WindowAdapter((JFrame)object3, minimalPatientStudySeriesInstanceModel){
                final /* synthetic */ JFrame val$frame;
                final /* synthetic */ DatabaseInformationModel val$d;
                {
                    this.val$frame = jFrame;
                    this.val$d = databaseInformationModel;
                }

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    this.val$frame.dispose();
                    this.val$d.close();
                    System.exit(0);
                }
            });
            System.err.print("building tree");
            object = new DatabaseTreeBrowser((DatabaseInformationModel)minimalPatientStudySeriesInstanceModel, (JFrame)object3);
            System.err.print("display tree");
            ((Window)object3).setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

