/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class AgeStringAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AgeStringAttribute.java,v 1.25 2025/01/29 10:58:06 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 4;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 4;
    }

    public AgeStringAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public AgeStringAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public AgeStringAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.AS;
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 68 || n == 87 || n == 77 || n == 89);
    }

    @Override
    public boolean areValuesWellFormed() throws DicomException {
        boolean bl = true;
        if (this.originalValues != null && this.originalValues.length > 0) {
            for (int i = 0; i < this.originalValues.length; ++i) {
                String string = this.originalValues[i];
                if (string == null || string.length() <= 0) continue;
                if (string.length() != 4) {
                    bl = false;
                    break;
                }
                if (!(string.endsWith("D") || string.endsWith("W") || string.endsWith("M") || string.endsWith("Y"))) {
                    bl = false;
                    break;
                }
                String string2 = string.substring(0, 3);
                for (int j = 0; j < string2.length(); ++j) {
                    int n = string.codePointAt(j);
                    if (Character.isDigit(n)) continue;
                    bl = false;
                    break;
                }
                if (!bl) break;
            }
        }
        return bl;
    }

    @Override
    public boolean repairValues() throws DicomException {
        if (!this.isValid()) {
            this.flushCachedCopies();
            this.originalByteValues = null;
            if (this.originalValues != null && this.originalValues.length > 0) {
                for (int i = 0; i < this.originalValues.length; ++i) {
                    String string = this.originalValues[i];
                    if (string == null || string.length() <= 0) continue;
                    this.originalValues[i] = string.trim();
                }
            }
        }
        return this.isValid();
    }
}

