/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;

public class AsynchronousOutputStream
extends FilterOutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AsynchronousOutputStream.java,v 1.15 2025/01/29 10:58:06 dclunie Exp $";
    private BlockingQueue<ByteArrayObject> q = new LinkedBlockingQueue<ByteArrayObject>();
    private Consumer c;
    private CountDownLatch doneSignal = new CountDownLatch(1);

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.q.put(new ByteArrayObject(byArray, 0, byArray.length));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    @Override
    public void write(int n) throws IOException {
        try {
            this.q.put(new ByteArrayObject(n));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        try {
            this.q.put(new ByteArrayObject(byArray));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public AsynchronousOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.c = new Consumer(this.q, this.doneSignal, outputStream);
        new Thread(this.c).start();
    }

    @Override
    public void flush() throws IOException {
        try {
            this.q.put(new ByteArrayObject(true, false));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.q.put(new ByteArrayObject(false, true));
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        try {
            this.doneSignal.await();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
        if (this.c.isBad()) {
            IOException iOException = this.c.getException();
            if (iOException != null) {
                throw iOException;
            }
            throw new IOException("Bad for unknown reason");
        }
    }

    private class Consumer
    implements Runnable {
        private final BlockingQueue<ByteArrayObject> q;
        private final OutputStream out;
        private final CountDownLatch doneSignal;
        private boolean bad;
        private IOException exception;

        Consumer(BlockingQueue<ByteArrayObject> blockingQueue, CountDownLatch countDownLatch, OutputStream outputStream) {
            this.q = blockingQueue;
            this.out = outputStream;
            this.doneSignal = countDownLatch;
            this.bad = false;
        }

        @Override
        public void run() {
            try {
                while (this.doneSignal.getCount() > 0L) {
                    this.consume(this.q.take());
                }
            }
            catch (InterruptedException interruptedException) {
                this.bad = true;
                this.exception = new IOException(interruptedException);
            }
        }

        void consume(ByteArrayObject byteArrayObject) {
            byte[] byArray = byteArrayObject.getBytes();
            int n = byteArrayObject.getOffset();
            int n2 = byteArrayObject.getLength();
            if (byArray != null && n2 > 0) {
                try {
                    this.out.write(byArray, n, n2);
                }
                catch (IOException iOException) {
                    this.bad = true;
                    this.exception = iOException;
                    this.doneSignal.countDown();
                }
            }
            if (byteArrayObject.isRequestToFlush()) {
                try {
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.bad = true;
                    this.exception = iOException;
                    this.doneSignal.countDown();
                }
            }
            if (byteArrayObject.isRequestToClose()) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.bad = true;
                    this.exception = iOException;
                }
                this.doneSignal.countDown();
            }
        }

        synchronized boolean isBad() {
            return this.bad;
        }

        synchronized IOException getException() {
            return this.exception;
        }
    }

    private class ByteArrayObject {
        byte[] b;
        int off;
        int len;
        boolean requestToFlush;
        boolean requestToClose;

        ByteArrayObject(byte[] byArray) {
            this.b = byArray;
            this.off = 0;
            this.len = byArray.length;
            this.requestToFlush = false;
            this.requestToClose = false;
        }

        ByteArrayObject(byte[] byArray, int n, int n2) {
            this.b = byArray;
            this.off = n;
            this.len = n2;
            this.requestToFlush = false;
            this.requestToClose = false;
        }

        ByteArrayObject(int n) {
            this.b = new byte[1];
            this.b[0] = (byte)n;
            this.off = 0;
            this.len = 1;
            this.requestToFlush = false;
            this.requestToClose = false;
        }

        ByteArrayObject(boolean bl, boolean bl2) {
            this.b = null;
            this.requestToFlush = bl;
            this.requestToClose = bl2;
        }

        byte[] getBytes() {
            return this.b;
        }

        int getOffset() {
            return this.off;
        }

        int getLength() {
            return this.len;
        }

        boolean isRequestToFlush() {
            return this.requestToFlush;
        }

        boolean isRequestToClose() {
            return this.requestToClose;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("array ");
            if (this.b != null) {
                stringBuffer.append("not ");
            }
            stringBuffer.append("null");
            stringBuffer.append("; off=");
            stringBuffer.append(Integer.toString(this.off));
            stringBuffer.append("; len=");
            stringBuffer.append(Integer.toString(this.len));
            stringBuffer.append("; flush=");
            stringBuffer.append(this.requestToFlush ? "T" : "F");
            stringBuffer.append("; close=");
            stringBuffer.append(this.requestToClose ? "T" : "F");
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

