/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class AttributeTreeRecord
implements Comparable,
TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTreeRecord.java,v 1.22 2025/01/29 10:58:06 dclunie Exp $";
    AttributeTreeRecord parent;
    Collection children;
    TreeNode[] array;
    Attribute attribute;
    int itemCount;
    DicomDictionary dictionary;
    boolean sortByName;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.attribute != null) {
            String string;
            AttributeTag attributeTag = this.attribute.getTag();
            stringBuffer.append(attributeTag.toString());
            if (this.dictionary != null && (string = this.dictionary.getNameFromTag(attributeTag)) != null) {
                stringBuffer.append(" ");
                stringBuffer.append(string);
            }
            if ((string = this.attribute.getDelimitedStringValuesOrEmptyString()) != null && string.length() > 0) {
                stringBuffer.append(" = ");
                stringBuffer.append(string);
            }
        } else if (this.itemCount > 0) {
            stringBuffer.append("Item ");
            stringBuffer.append(Integer.toString(this.itemCount));
        }
        return stringBuffer.toString();
    }

    public int compareTo(Object object) {
        AttributeTreeRecord attributeTreeRecord = (AttributeTreeRecord)object;
        Attribute attribute = attributeTreeRecord.getAttribute();
        int n = attributeTreeRecord.getItemCount();
        if (this.attribute != null && attribute != null) {
            AttributeTag attributeTag = this.attribute.getTag();
            AttributeTag attributeTag2 = attribute.getTag();
            if (this.sortByName && this.dictionary != null) {
                String string = this.dictionary.getNameFromTag(attributeTag);
                String string2 = this.dictionary.getNameFromTag(attributeTag2);
                if (string != null && string2 != null) {
                    return string.compareTo(string2);
                }
                if (string != null && string2 == null) {
                    return -1;
                }
                if (string == null && string2 != null) {
                    return 1;
                }
                return attributeTag.compareTo(attributeTag2);
            }
            return attributeTag.compareTo(attributeTag2);
        }
        return this.itemCount - n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int n) {
        int n2 = this.children.size();
        if (this.array == null) {
            this.array = this.children.toArray(new TreeNode[n2]);
        }
        return n < n2 ? this.array[n] : null;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        int n = this.children.size();
        if (this.array == null) {
            this.array = this.children.toArray(new TreeNode[n]);
        }
        for (int i = 0; i < n; ++i) {
            if (!this.getChildAt(i).equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        return this.children == null ? null : new Vector(this.children).elements();
    }

    public AttributeTreeRecord(AttributeTreeRecord attributeTreeRecord, Attribute attribute, DicomDictionary dicomDictionary) {
        this.dictionary = dicomDictionary == null ? new DicomDictionary() : dicomDictionary;
        this.parent = attributeTreeRecord;
        this.attribute = attribute;
        this.sortByName = true;
    }

    public AttributeTreeRecord(AttributeTreeRecord attributeTreeRecord, int n) {
        this.dictionary = null;
        this.parent = attributeTreeRecord;
        this.attribute = null;
        this.itemCount = n;
        this.sortByName = true;
    }

    public void addChild(AttributeTreeRecord attributeTreeRecord) {
        if (this.children == null) {
            this.children = new TreeSet();
        }
        this.children.add(attributeTreeRecord);
        this.array = null;
    }

    public void removeChild(AttributeTreeRecord attributeTreeRecord) {
        this.children.remove(attributeTreeRecord);
        this.array = null;
    }

    public void removeAllChildren() {
        this.children = null;
        this.array = null;
    }

    public void addSibling(AttributeTreeRecord attributeTreeRecord) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(attributeTreeRecord);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public void setSortByName(boolean bl) {
        this.sortByName = bl;
    }
}

