/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.PersonIdentification;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.ShortTextAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnlimitedTextAttribute;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.DateUtilities;
import java.text.ParseException;
import java.util.AbstractMap;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TimeZone;

public abstract class ClinicalTrialsAttributes {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ClinicalTrialsAttributes.java,v 1.145 2025/02/12 18:15:47 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ClinicalTrialsAttributes.class);
    public static final String defaultValueForMissingNonZeroLengthStrings = "NONE";
    public static final String defaultValueForMissingPossiblyZeroLengthStrings = "";
    public static final String replacementForDeviceSerialNumber = "SN000000";
    public static final String replacementForDetectorID = "DET00000";
    public static final String replacementForVerifyingObserverName = "Observer^Deidentified";
    public static final String replacementForVerifyingOrganization = "NoOrganization";
    public static final String replacementForContainerIdentifier = "CNTR00000";
    public static final String replacementForSpecimenIdentifier = "SPC00000";
    public static final String replacementForDescriptionOrLabel = "REMOVED";
    public static final String replacementForTextInStructuredContent = "REMOVED";
    public static final String replacementForPersonNameInStructuredContent = "Nobody^Noone";
    public static final String replacementForDateTimeInStructuredContent = "19600101000000";
    public static final String replacementForDateInStructuredContent = "19600101";
    public static final String replacementForTimeInStructuredContent = "000000";
    public static final String replacementForContentCreatorName = "Nobody^Noone";
    public static final String replacementForAgeString = "000Y";
    public static final String replacementForAET = "REMOVED";
    protected static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;
    protected static Map mapOfOriginalToReplacementUIDs = null;
    protected static UIDGenerator uidGenerator = null;

    private ClinicalTrialsAttributes() {
    }

    protected static void addType1LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null || string.length() == 0) {
            string = defaultValueForMissingNonZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType2LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string == null) {
            string = defaultValueForMissingPossiblyZeroLengthStrings;
        }
        LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
        ((Attribute)longStringAttribute).addValue(string);
        attributeList.put(attributeTag, longStringAttribute);
    }

    protected static void addType3ShortTextAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortTextAttribute shortTextAttribute = new ShortTextAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortTextAttribute).addValue(string);
            attributeList.put(attributeTag, shortTextAttribute);
        }
    }

    protected static void addType3ShortStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            ShortStringAttribute shortStringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)shortStringAttribute).addValue(string);
            attributeList.put(attributeTag, shortStringAttribute);
        }
    }

    protected static void addType3LongStringAttribute(AttributeList attributeList, AttributeTag attributeTag, String string, SpecificCharacterSet specificCharacterSet) throws DicomException {
        if (string != null) {
            LongStringAttribute longStringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
            ((Attribute)longStringAttribute).addValue(string);
            attributeList.put(attributeTag, longStringAttribute);
        }
    }

    protected static void addType3DateTimeAttribute(AttributeList attributeList, AttributeTag attributeTag, String string) throws DicomException {
        if (string != null) {
            DateTimeAttribute dateTimeAttribute = new DateTimeAttribute(attributeTag);
            ((Attribute)dateTimeAttribute).addValue(string);
            attributeList.put(attributeTag, dateTimeAttribute);
        }
    }

    public static void addAgeDerivedFromBirthDateAndStudyRelatedDate(AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("PatientBirthDate"));
        if (string.length() > 0) {
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("StudyDate"));
            if (string2.length() == 0) {
                string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("SeriesDate"));
            }
            if (string2.length() == 0) {
                string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("AcquisitionDate"));
            }
            if (string2.length() == 0) {
                string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("ContentDate"));
            }
            if (string2.length() > 0) {
                try {
                    String string3 = DateUtilities.getAgeBetweenAsDICOMAgeString(string, string2);
                    if (string3 != null && string3.length() > 0) {
                        AgeStringAttribute ageStringAttribute = new AgeStringAttribute(dictionary.getTagFromName("PatientAge"));
                        ((Attribute)ageStringAttribute).addValue(string3);
                        attributeList.put(ageStringAttribute);
                    }
                }
                catch (Exception exception) {
                    slf4jlogger.error("While deriving age", exception);
                }
            }
        }
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), string, string2, string3, string4, string5, string6, string7, string8, "Deidentified");
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, codedSequenceItem, string, string2, string3, string4, string5, string6, string7, string8, string9, DateTimeAttribute.getFormattedStringDefaultTimeZone(new Date()), null, null);
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, codedSequenceItem, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, null, null);
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String[] stringArray, PersonIdentification[] personIdentificationArray) throws DicomException {
        ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, bl, codedSequenceItem, string, string2, string3, null, string4, string5, string6, string7, string8, string9, string10, stringArray, personIdentificationArray);
    }

    public static void addContributingEquipmentSequence(AttributeList attributeList, boolean bl, CodedSequenceItem codedSequenceItem, String string, String string2, String string3, CodedSequenceItem codedSequenceItem2, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String[] stringArray, PersonIdentification[] personIdentificationArray) throws DicomException {
        int n;
        Attribute attribute;
        Attribute attribute2 = attributeList.get(dictionary.getTagFromName("SpecificCharacterSet"));
        SpecificCharacterSet specificCharacterSet = attribute2 == null ? null : new SpecificCharacterSet(attribute2.getStringValues());
        AttributeList attributeList2 = new AttributeList();
        if (codedSequenceItem != null) {
            attribute = new SequenceAttribute(dictionary.getTagFromName("PurposeOfReferenceCodeSequence"));
            ((SequenceAttribute)attribute).addItem(codedSequenceItem.getAttributeList());
            attributeList2.put(attribute);
        }
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("Manufacturer"), string, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("InstitutionName"), string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("InstitutionalDepartmentName"), string3, specificCharacterSet);
        if (codedSequenceItem2 != null) {
            attribute = new SequenceAttribute(dictionary.getTagFromName("InstitutionalDepartmentTypeCodeSequence"));
            ((SequenceAttribute)attribute).addItem(codedSequenceItem2.getAttributeList());
            attributeList2.put(attribute);
        }
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, dictionary.getTagFromName("InstitutionAddress"), string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortStringAttribute(attributeList2, dictionary.getTagFromName("StationName"), string5, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("ManufacturerModelName"), string6, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("DeviceSerialNumber"), string7, specificCharacterSet);
        ClinicalTrialsAttributes.addType3LongStringAttribute(attributeList2, dictionary.getTagFromName("SoftwareVersions"), string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList2, dictionary.getTagFromName("ContributionDescription"), string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType3DateTimeAttribute(attributeList2, dictionary.getTagFromName("ContributionDateTime"), string10);
        if (stringArray != null && stringArray.length > 0) {
            attribute = new PersonNameAttribute(dictionary.getTagFromName("OperatorsName"));
            for (n = 0; n < stringArray.length; ++n) {
                attribute.addValue(stringArray[n]);
            }
            attributeList2.put(attribute);
        }
        if (personIdentificationArray != null && personIdentificationArray.length > 0) {
            attribute = new SequenceAttribute(dictionary.getTagFromName("OperatorIdentificationSequence"));
            for (n = 0; n < personIdentificationArray.length; ++n) {
                PersonIdentification personIdentification = personIdentificationArray[n];
                if (personIdentification == null) continue;
                ((SequenceAttribute)attribute).addItem(new SequenceItem(personIdentification.getAttributeList()));
            }
            attributeList2.put(attribute);
        }
        attribute = null;
        if (bl) {
            attribute = (SequenceAttribute)attributeList.get(dictionary.getTagFromName("ContributingEquipmentSequence"));
        }
        if (attribute == null) {
            attribute = new SequenceAttribute(dictionary.getTagFromName("ContributingEquipmentSequence"));
        }
        ((SequenceAttribute)attribute).addItem(attributeList2);
        attributeList.remove(dictionary.getTagFromName("ContributingEquipmentSequence"));
        attributeList.put(attribute);
    }

    public static void removeClinicalTrialsAttributes(AttributeList attributeList) {
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSponsorName"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialProtocolID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialProtocolName"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSiteID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSiteName"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSubjectID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSubjectReadingID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialTimePointID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialTimePointDescription"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialCoordinatingCenterName"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSeriesDescription"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialSeriesID"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialProtocolEthicsCommitteeName"));
        attributeList.remove(dictionary.getTagFromName("ClinicalTrialProtocolEthicsCommitteeApprovalNumber"));
    }

    public static void addClinicalTrialsAttributes(AttributeList attributeList, boolean bl, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) throws DicomException {
        Attribute attribute = attributeList.get(dictionary.getTagFromName("SpecificCharacterSet"));
        SpecificCharacterSet specificCharacterSet = attribute == null ? null : new SpecificCharacterSet(attribute.getStringValues());
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialSponsorName"), string, specificCharacterSet);
        ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialProtocolID"), string2, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialProtocolName"), string3, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialSiteID"), string4, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialSiteName"), string5, specificCharacterSet);
        if (string6 != null || string7 == null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialSubjectID"), string6, specificCharacterSet);
        }
        if (string7 != null) {
            ClinicalTrialsAttributes.addType1LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialSubjectReadingID"), string7, specificCharacterSet);
        }
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialTimePointID"), string8, specificCharacterSet);
        ClinicalTrialsAttributes.addType3ShortTextAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialTimePointDescription"), string9, specificCharacterSet);
        ClinicalTrialsAttributes.addType2LongStringAttribute(attributeList, dictionary.getTagFromName("ClinicalTrialCoordinatingCenterName"), string10, specificCharacterSet);
        if (bl) {
            String string11 = string6;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            StringAttributeAffectedBySpecificCharacterSet stringAttributeAffectedBySpecificCharacterSet = new PersonNameAttribute(dictionary.getTagFromName("PatientName"), specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(dictionary.getTagFromName("PatientName"), stringAttributeAffectedBySpecificCharacterSet);
            stringAttributeAffectedBySpecificCharacterSet = new LongStringAttribute(dictionary.getTagFromName("PatientID"), specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(dictionary.getTagFromName("PatientID"), stringAttributeAffectedBySpecificCharacterSet);
            string11 = string8;
            if (string11 == null) {
                string11 = defaultValueForMissingNonZeroLengthStrings;
            }
            stringAttributeAffectedBySpecificCharacterSet = new ShortStringAttribute(dictionary.getTagFromName("StudyID"), specificCharacterSet);
            ((Attribute)stringAttributeAffectedBySpecificCharacterSet).addValue(string11);
            attributeList.put(dictionary.getTagFromName("StudyID"), stringAttributeAffectedBySpecificCharacterSet);
        }
    }

    public static boolean isSafePrivateAttribute(AttributeTag attributeTag, AttributeList attributeList) {
        boolean bl = false;
        if (attributeTag.isPrivateCreator()) {
            bl = true;
        } else {
            String string = attributeList.getPrivateCreatorString(attributeTag);
            bl = ClinicalTrialsAttributes.isSafePrivateAttribute(string, attributeTag);
        }
        return bl;
    }

    public static boolean isSafePrivateAttribute(String string, AttributeTag attributeTag) {
        boolean bl = false;
        if (attributeTag.isPrivateCreator()) {
            bl = true;
        } else {
            int n = attributeTag.getGroup();
            int n2 = attributeTag.getElement();
            int n3 = n2 & 0xFF;
            if (n == 28755 && string.equals("Philips PET Private Group")) {
                if (n3 == 0) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                }
            } else if (n == 8197 && (string.equals("Philips MR Imaging DD 001") || string.equals("PHILIPS MR IMAGING DD 001"))) {
                if (n3 == 13) {
                    bl = true;
                } else if (n3 == 14) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 023")) {
                if (n3 == 69) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 033")) {
                if (n3 == 0) {
                    bl = true;
                } else if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 13) {
                    bl = true;
                } else if (n3 == 15) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 20) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 034")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 10) {
                    bl = true;
                } else if (n3 == 11) {
                    bl = true;
                } else if (n3 == 12) {
                    bl = true;
                } else if (n3 == 13) {
                    bl = true;
                } else if (n3 == 14) {
                    bl = true;
                } else if (n3 == 15) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                } else if (n3 == 19) {
                    bl = true;
                } else if (n3 == 20) {
                    bl = true;
                } else if (n3 == 23) {
                    bl = true;
                } else if (n3 == 24) {
                    bl = true;
                } else if (n3 == 27) {
                    bl = true;
                } else if (n3 == 28) {
                    bl = true;
                } else if (n3 == 29) {
                    bl = true;
                } else if (n3 == 30) {
                    bl = true;
                } else if (n3 == 31) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                } else if (n3 == 34) {
                    bl = true;
                } else if (n3 == 35) {
                    bl = true;
                } else if (n3 == 36) {
                    bl = true;
                } else if (n3 == 37) {
                    bl = true;
                } else if (n3 == 38) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 40) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 035")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 10) {
                    bl = true;
                } else if (n3 == 12) {
                    bl = true;
                } else if (n3 == 13) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 036")) {
                if (n3 == 21) {
                    bl = true;
                } else if (n3 == 22) {
                    bl = true;
                } else if (n3 == 23) {
                    bl = true;
                } else if (n3 == 24) {
                    bl = true;
                } else if (n3 == 25) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 038")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 039")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 10) {
                    bl = true;
                } else if (n3 == 11) {
                    bl = true;
                } else if (n3 == 12) {
                    bl = true;
                } else if (n3 == 13) {
                    bl = true;
                } else if (n3 == 21) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 040")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 042")) {
                if (n3 == 21) {
                    bl = true;
                } else if (n3 == 22) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                } else if (n3 == 49) {
                    bl = true;
                } else if (n3 == 64) {
                    bl = true;
                } else if (n3 == 80) {
                    bl = true;
                } else if (n3 == 81) {
                    bl = true;
                } else if (n3 == 82) {
                    bl = true;
                } else if (n3 == 83) {
                    bl = true;
                } else if (n3 == 84) {
                    bl = true;
                } else if (n3 == 85) {
                    bl = true;
                } else if (n3 == 86) {
                    bl = true;
                } else if (n3 == 87) {
                    bl = true;
                } else if (n3 == 88) {
                    bl = true;
                } else if (n3 == 89) {
                    bl = true;
                } else if (n3 == 90) {
                    bl = true;
                } else if (n3 == 91) {
                    bl = true;
                } else if (n3 == 92) {
                    bl = true;
                } else if (n3 == 93) {
                    bl = true;
                } else if (n3 == 94) {
                    bl = true;
                } else if (n3 == 95) {
                    bl = true;
                } else if (n3 == 96) {
                    bl = true;
                } else if (n3 == 112) {
                    bl = true;
                } else if (n3 == 113) {
                    bl = true;
                } else if (n3 == 114) {
                    bl = true;
                } else if (n3 == 115) {
                    bl = true;
                } else if (n3 == 116) {
                    bl = true;
                } else if (n3 == 117) {
                    bl = true;
                } else if (n3 == 118) {
                    bl = true;
                } else if (n3 == 119) {
                    bl = true;
                } else if (n3 == 120) {
                    bl = true;
                } else if (n3 == 140) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 045")) {
                if (n3 == 241) {
                    bl = true;
                } else if (n3 == 243) {
                    bl = true;
                } else if (n3 == 244) {
                    bl = true;
                } else if (n3 == 245) {
                    bl = true;
                } else if (n3 == 246) {
                    bl = true;
                } else if (n3 == 248) {
                    bl = true;
                } else if (n3 == 250) {
                    bl = true;
                } else if (n3 == 251) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 046")) {
                if (n3 == 23) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 048")) {
                if (n3 == 1) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 065")) {
                if (n3 == 7) {
                    bl = true;
                }
            } else if (n == 8205 && string.equals("Philips US Imaging DD 066")) {
                if (n3 == 0) {
                    bl = true;
                } else if (n3 == 1) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                }
            } else if (n == 225 && string.equals("ELSCINT1")) {
                if (n3 == 33) {
                    bl = true;
                } else if (n3 == 80) {
                    bl = true;
                }
            } else if (n == 481 && string.equals("ELSCINT1")) {
                if (n3 == 38) {
                    bl = true;
                }
            } else if (n == 497 && string.equals("ELSCINT1")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 38) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                }
            } else if (n == 25 && string.equals("GEMS_ACQU_01")) {
                if (n3 == 35) {
                    bl = true;
                } else if (n3 == 36) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 158) {
                    bl = true;
                }
            } else if (n == 37 && string.equals("GEMS_SERS_01")) {
                if (n3 == 7) {
                    bl = true;
                }
            } else if (n == 67 && string.equals("GEMS_PARM_01")) {
                if (n3 == 39) {
                    bl = true;
                } else if (n3 == 111) {
                    bl = true;
                }
            } else if (n == 69 && string.equals("GEMS_HELIOS_01")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                }
            } else if (n == 69 && string.equals("GEMS_SENO_02")) {
                if (n3 == 6) {
                    bl = true;
                } else if (n3 == 27) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 41) {
                    bl = true;
                } else if (n3 == 42) {
                    bl = true;
                } else if (n3 == 43) {
                    bl = true;
                } else if (n3 == 73) {
                    bl = true;
                } else if (n3 == 88) {
                    bl = true;
                } else if (n3 == 89) {
                    bl = true;
                } else if (n3 == 96) {
                    bl = true;
                } else if (n3 == 97) {
                    bl = true;
                } else if (n3 == 98) {
                    bl = true;
                } else if (n3 == 99) {
                    bl = true;
                } else if (n3 == 100) {
                    bl = true;
                } else if (n3 == 113) {
                    bl = true;
                } else if (n3 == 114) {
                    bl = true;
                } else if (n3 == 144) {
                    bl = true;
                } else if (n3 == 160) {
                    bl = true;
                } else if (n3 == 161) {
                    bl = true;
                } else if (n3 == 162) {
                    bl = true;
                } else if (n3 == 164) {
                    bl = true;
                } else if (n3 == 167) {
                    bl = true;
                } else if (n3 == 168) {
                    bl = true;
                } else if (n3 == 171) {
                    bl = true;
                } else if (n3 == 172) {
                    bl = true;
                } else if (n3 == 173) {
                    bl = true;
                }
            } else if (n == 115 && string.equals("GEMS_IDI_01")) {
                if (n3 == 32) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                } else if (n3 == 49) {
                    bl = true;
                } else if (n3 == 50) {
                    bl = true;
                } else if (n3 == 64) {
                    bl = true;
                } else if (n3 == 80) {
                    bl = true;
                }
            } else if (n == 2307 && string.equals("GEIIS PACS")) {
                if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                }
            } else if ((n == 32257 || n == 32513) && string.equals("HOLOGIC, Inc.")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                }
            } else if (n == 25 && string.equals("LORAD Selenia")) {
                if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 22) {
                    bl = true;
                } else if (n3 == 38) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 40) {
                    bl = true;
                } else if (n3 == 41) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                } else if (n3 == 49) {
                    bl = true;
                } else if (n3 == 50) {
                    bl = true;
                } else if (n3 == 51) {
                    bl = true;
                } else if (n3 == 52) {
                    bl = true;
                } else if (n3 == 53) {
                    bl = true;
                } else if (n3 == 55) {
                    bl = true;
                } else if (n3 == 64) {
                    bl = true;
                } else if (n3 == 65) {
                    bl = true;
                } else if (n3 == 80) {
                    bl = true;
                } else if (n3 == 81) {
                    bl = true;
                } else if (n3 == 82) {
                    bl = true;
                } else if (n3 == 83) {
                    bl = true;
                } else if (n3 == 96) {
                    bl = true;
                } else if (n3 == 112) {
                    bl = true;
                } else if (n3 == 113) {
                    bl = true;
                } else if (n3 == 128) {
                    bl = true;
                } else if (n3 == 144) {
                    bl = true;
                }
            } else if (n == 25 && string.equals("HOLOGIC, Inc.")) {
                if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 22) {
                    bl = true;
                } else if (n3 == 37) {
                    bl = true;
                } else if (n3 == 38) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 40) {
                    bl = true;
                } else if (n3 == 41) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                } else if (n3 == 49) {
                    bl = true;
                } else if (n3 == 50) {
                    bl = true;
                } else if (n3 == 51) {
                    bl = true;
                } else if (n3 == 52) {
                    bl = true;
                } else if (n3 == 53) {
                    bl = true;
                } else if (n3 == 55) {
                    bl = true;
                } else if (n3 == 64) {
                    bl = true;
                } else if (n3 == 65) {
                    bl = true;
                } else if (n3 == 66) {
                    bl = true;
                } else if (n3 == 67) {
                    bl = true;
                } else if (n3 == 68) {
                    bl = true;
                } else if (n3 == 69) {
                    bl = true;
                } else if (n3 == 70) {
                    bl = true;
                } else if (n3 == 80) {
                    bl = true;
                } else if (n3 == 81) {
                    bl = true;
                } else if (n3 == 82) {
                    bl = true;
                } else if (n3 == 83) {
                    bl = true;
                } else if (n3 == 96) {
                    bl = true;
                } else if (n3 == 97) {
                    bl = true;
                } else if (n3 == 98) {
                    bl = true;
                } else if (n3 == 112) {
                    bl = true;
                } else if (n3 == 113) {
                    bl = true;
                } else if (n3 == 128) {
                    bl = true;
                } else if (n3 == 133) {
                    bl = true;
                } else if (n3 == 135) {
                    bl = true;
                } else if (n3 == 137) {
                    bl = true;
                } else if (n3 == 138) {
                    bl = true;
                } else if (n3 == 144) {
                    bl = true;
                } else if (n3 == 151) {
                    bl = true;
                } else if (n3 == 152) {
                    bl = true;
                }
            } else if (n == 153 && string.equals("NQHeader")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                }
            } else if (n == 409 && string.equals("NQLeft")) {
                if (n3 >= 1 && n3 <= 58) {
                    bl = true;
                }
            } else if (n == 665 && string.equals("NQRight")) {
                if (n3 >= 1 && n3 <= 58) {
                    bl = true;
                }
            } else if (n == 281 && string.equals("SIEMENS Ultrasound SC2000")) {
                if (n3 == 0) {
                    bl = true;
                } else if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                } else if (n3 == 19) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                }
            } else if (n == 297 && string.equals("SIEMENS Ultrasound SC2000")) {
                if (n3 == 0) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                } else if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                } else if (n3 == 34) {
                    bl = true;
                } else if (n3 == 41) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                }
            } else if (n == 313 && string.equals("SIEMENS Ultrasound SC2000")) {
                if (n3 == 1) {
                    bl = true;
                }
            } else if (n == 329 && string.equals("SIEMENS Ultrasound SC2000")) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 2) {
                    bl = true;
                } else if (n3 == 3) {
                    bl = true;
                }
            } else if (n == 32721 && (string.equals("SIEMENS Ultrasound SC2000") || string.equals("SIEMENS SYNGO ULTRA-SOUND TOYON DATA STREAMING"))) {
                if (n3 == 1) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                }
            } else if (n == 4393 && string.equals("Eigen Artemis")) {
                if (n3 == 4) {
                    bl = true;
                } else if (n3 == 5) {
                    bl = true;
                } else if (n3 == 6) {
                    bl = true;
                } else if (n3 == 7) {
                    bl = true;
                } else if (n3 == 8) {
                    bl = true;
                } else if (n3 == 9) {
                    bl = true;
                } else if (n3 == 16) {
                    bl = true;
                } else if (n3 == 17) {
                    bl = true;
                } else if (n3 == 18) {
                    bl = true;
                } else if (n3 == 19) {
                    bl = true;
                } else if (n3 == 21) {
                    bl = true;
                } else if (n3 == 22) {
                    bl = true;
                } else if (n3 == 23) {
                    bl = true;
                } else if (n3 == 24) {
                    bl = true;
                } else if (n3 == 25) {
                    bl = true;
                } else if (n3 == 32) {
                    bl = true;
                } else if (n3 == 33) {
                    bl = true;
                } else if (n3 == 35) {
                    bl = true;
                } else if (n3 == 36) {
                    bl = true;
                } else if (n3 == 37) {
                    bl = true;
                } else if (n3 == 38) {
                    bl = true;
                } else if (n3 == 39) {
                    bl = true;
                } else if (n3 == 41) {
                    bl = true;
                } else if (n3 == 48) {
                    bl = true;
                } else if (n3 == 49) {
                    bl = true;
                } else if (n3 == 50) {
                    bl = true;
                } else if (n3 == 51) {
                    bl = true;
                } else if (n3 == 54) {
                    bl = true;
                } else if (n3 == 55) {
                    bl = true;
                } else if (n3 == 56) {
                    bl = true;
                } else if (n3 == 57) {
                    bl = true;
                } else if (n3 == 64) {
                    bl = true;
                } else if (n3 == 65) {
                    bl = true;
                } else if (n3 == 112) {
                    bl = true;
                } else if (n3 == 113) {
                    bl = true;
                } else if (n3 == 114) {
                    bl = true;
                } else if (n3 == 115) {
                    bl = true;
                } else if (n3 == 116) {
                    bl = true;
                } else if (n3 == 117) {
                    bl = true;
                } else if (n3 == 118) {
                    bl = true;
                } else if (n3 == 120) {
                    bl = true;
                } else if (n3 == 121) {
                    bl = true;
                } else if (n3 == 128) {
                    bl = true;
                } else if (n3 == 129) {
                    bl = true;
                } else if (n3 == 130) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isSafePrivateSequenceAttribute(String string, AttributeTag attributeTag) {
        boolean bl = false;
        if (!attributeTag.isPrivateCreator()) {
            int n = attributeTag.getGroup();
            int n2 = attributeTag.getElement();
            int n3 = n2 & 0xFF;
            if (n == 25 && string.equals("HOLOGIC, Inc.") && n3 == 138) {
                bl = true;
            }
        }
        return bl;
    }

    public static void flushMapOfUIDs() {
        mapOfOriginalToReplacementUIDs = null;
    }

    public static Map<String, String> getMapOfOriginalToReplacementUIDs() {
        return mapOfOriginalToReplacementUIDs;
    }

    public static void remapUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 2);
    }

    public static void removeUIDAttributes(AttributeList attributeList) throws DicomException {
        ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, 1);
    }

    protected static void removeOrRemapUIDAttributes(AttributeList attributeList, int n) throws DicomException {
        Object object;
        Object object2;
        Object object3;
        LinkedList<Object> linkedList = null;
        for (Object object4 : attributeList.values()) {
            Object object5;
            if (object4 instanceof SequenceAttribute) {
                object5 = (SequenceAttribute)object4;
                object3 = ((SequenceAttribute)object5).iterator();
                if (object3 == null) continue;
                while (object3.hasNext()) {
                    object2 = (SequenceItem)object3.next();
                    if (object2 == null || (object = ((SequenceItem)object2).getAttributeList()) == null) continue;
                    ClinicalTrialsAttributes.removeOrRemapUIDAttributes((AttributeList)object, n);
                }
                continue;
            }
            if (n == 0 || !(object4 instanceof UniqueIdentifierAttribute) || !UniqueIdentifierAttribute.isTransient((AttributeTag)(object3 = ((Attribute)(object5 = (UniqueIdentifierAttribute)object4)).getTag()), attributeList)) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<Object>();
            }
            linkedList.add(object3);
        }
        if (linkedList != null) {
            for (Object object5 : linkedList) {
                if (n == 1) {
                    attributeList.remove((AttributeTag)object5);
                    continue;
                }
                if (n != 2) continue;
                object3 = Attribute.getSingleStringValueOrNull(attributeList, (AttributeTag)object5);
                if (object3 != null) {
                    object2 = null;
                    if (mapOfOriginalToReplacementUIDs == null) {
                        mapOfOriginalToReplacementUIDs = new HashMap();
                    }
                    if ((object2 = (String)mapOfOriginalToReplacementUIDs.get(object3)) == null) {
                        if (uidGenerator == null) {
                            uidGenerator = new UIDGenerator();
                        }
                        object2 = uidGenerator.getAnotherNewUID();
                        mapOfOriginalToReplacementUIDs.put(object3, object2);
                    }
                    assert (object2 != null);
                    attributeList.remove((AttributeTag)object5);
                    object = new UniqueIdentifierAttribute((AttributeTag)object5);
                    ((Attribute)object).addValue((String)object2);
                    attributeList.put((AttributeTag)object5, (Attribute)object);
                    continue;
                }
                attributeList.remove((AttributeTag)object5);
            }
        }
    }

    public static AttributeTag getTagOfTimeAttributeCorrespondingToDateAttribute(AttributeTag attributeTag) {
        String string;
        String string2;
        AttributeTag attributeTag2 = null;
        if (attributeTag != null && !attributeTag.equals(dictionary.getTagFromName("Date")) && (string2 = dictionary.getNameFromTag(attributeTag)) != null && !(string = string2.replace("Date", "Time")).equals(string2)) {
            attributeTag2 = dictionary.getTagFromName(string);
        }
        return attributeTag2;
    }

    protected static boolean isValidCandidateForEarliestDateTime(Date date) {
        return date != null && date.getTime() >= 0L;
    }

    protected static Date findEarliestDateTime(AttributeList attributeList, Date object, String string) {
        for (Attribute attribute : attributeList.values()) {
            Object object2;
            Object object3;
            Iterator<SequenceItem> iterator;
            Object object4;
            if (attribute instanceof SequenceAttribute) {
                object4 = (SequenceAttribute)attribute;
                iterator = ((SequenceAttribute)object4).iterator();
                if (iterator == null) continue;
                while (iterator.hasNext()) {
                    Date date;
                    object3 = (SequenceItem)iterator.next();
                    if (object3 == null || (object2 = ((SequenceItem)object3).getAttributeList()) == null || !ClinicalTrialsAttributes.isValidCandidateForEarliestDateTime(date = ClinicalTrialsAttributes.findEarliestDateTime((AttributeList)object2, (Date)object, string)) || object != null && !date.before((Date)object)) continue;
                    object = date;
                }
                continue;
            }
            object4 = null;
            iterator = attribute.getTag();
            if (attribute instanceof DateTimeAttribute && !((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("HangingProtocolCreationDateTime")) && !((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("EffectiveDateTime")) && !((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("InformationIssueDateTime"))) {
                object4 = ((DateTimeAttribute)attribute).getSingleStringValueOrEmptyString();
            } else if (!(!(attribute instanceof DateAttribute) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("PatientBirthDate")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("LastMenstrualDate")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("DateOfLastCalibration")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("DateOfLastDetectorCalibration")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("DateOfInstallation")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("DateOfManufacture")))) {
                object4 = ((DateAttribute)attribute).getSingleStringValueOrEmptyString();
                if (((String)object4).length() == 8) {
                    object3 = ClinicalTrialsAttributes.getTagOfTimeAttributeCorrespondingToDateAttribute((AttributeTag)((Object)iterator));
                    if (object3 != null && ((String)(object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, (AttributeTag)object3))).length() > 0) {
                        object4 = (String)object4 + (String)object2;
                    }
                } else {
                    object4 = null;
                }
            } else if (attribute instanceof TimeAttribute && attribute.getVL() > 0L && (((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("RadiopharmaceuticalStartTime")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("RadiopharmaceuticalStopTime")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("InterventionDrugStartTime")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("InterventionDrugStopTime")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("ContrastBolusStartTime")) || ((AttributeTag)((Object)iterator)).equals(dictionary.getTagFromName("ContrastBolusStopTime"))) && string != null && string.length() == 8) {
                object4 = string + attribute.getSingleStringValueOrEmptyString();
            }
            if (object4 == null || ((String)object4).length() < 8) continue;
            try {
                object3 = DateTimeAttribute.getDateFromFormattedString((String)object4);
                if (!ClinicalTrialsAttributes.isValidCandidateForEarliestDateTime((Date)object3) || object != null && !((Date)object3).before((Date)object)) continue;
                object = object3;
            }
            catch (ParseException parseException) {
            }
        }
        return object;
    }

    public static Date findEarliestDateTime(AttributeList attributeList) {
        String string = ClinicalTrialsAttributes.getDateToUseForUnaccompaniedTimes(attributeList);
        return ClinicalTrialsAttributes.findEarliestDateTime(attributeList, null, string);
    }

    public static Date getDateOffsetByEarliestMovedToEpoch(Date date, Date date2, Date date3) {
        long l = date.getTime();
        long l2 = date2.getTime();
        long l3 = date3.getTime();
        long l4 = l - l3 + l2;
        Date date4 = new Date(l4);
        return date4;
    }

    public static String getDateToUseForUnaccompaniedTimes(AttributeList attributeList) {
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("AcquisitionDate"));
        if (string.length() == 0) {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("ContentDate"));
        }
        if (string.length() == 0) {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("SeriesDate"));
        }
        if (string.length() == 0) {
            string = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("StudyDate"));
        }
        return string;
    }

    protected static void removeOrRemapDateAndTimeAttributes(AttributeList attributeList, int n, Date date, Date date2, String string) throws DicomException {
        AttributeList attributeList2 = new AttributeList();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object : attributeList.values()) {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7;
            if (object instanceof SequenceAttribute) {
                object7 = (SequenceAttribute)object;
                object6 = ((SequenceAttribute)object7).iterator();
                if (object6 == null) continue;
                while (object6.hasNext()) {
                    object5 = object6.next();
                    if (object5 == null || (object4 = ((SequenceItem)object5).getAttributeList()) == null) continue;
                    ClinicalTrialsAttributes.removeOrRemapDateAndTimeAttributes((AttributeList)object4, n, date, date2, string);
                }
                continue;
            }
            if (n == 1) {
                object7 = ((Attribute)object).getTag();
                if (object instanceof DateAttribute || object instanceof TimeAttribute || object instanceof DateTimeAttribute) {
                    if (((AttributeTag)object7).equals(dictionary.getTagFromName("StudyDate")) || ((AttributeTag)object7).equals(dictionary.getTagFromName("ContentDate"))) {
                        object6 = new DateAttribute((AttributeTag)object7);
                        attributeList2.put((Attribute)object6);
                        continue;
                    }
                    if (((AttributeTag)object7).equals(dictionary.getTagFromName("StudyTime")) || ((AttributeTag)object7).equals(dictionary.getTagFromName("ContentTime"))) {
                        object6 = new TimeAttribute((AttributeTag)object7);
                        attributeList2.put((Attribute)object6);
                        continue;
                    }
                    if (((AttributeTag)object7).equals(dictionary.getTagFromName("PatientBirthDate")) || ((AttributeTag)object7).equals(dictionary.getTagFromName("PatientBirthTime"))) continue;
                    linkedList.add(object7);
                    continue;
                }
                if (!((AttributeTag)object7).equals(dictionary.getTagFromName("TimezoneOffsetFromUTC"))) continue;
                linkedList.add(object7);
                continue;
            }
            if (n != 2) continue;
            object7 = ((Attribute)object).getTag();
            if (object instanceof DateTimeAttribute) {
                object6 = ((Attribute)object).getSingleStringValueOrEmptyString();
                if (((String)object6).length() <= 0) continue;
                try {
                    object5 = DateTimeAttribute.getDateFromFormattedString((String)object6);
                    if (object5 != null) {
                        object4 = ClinicalTrialsAttributes.getDateOffsetByEarliestMovedToEpoch((Date)object5, date, date2);
                        object3 = DateTimeAttribute.getFormattedString((Date)object4, TimeZone.getTimeZone("GMT"));
                        object2 = new DateTimeAttribute((AttributeTag)object7);
                        ((Attribute)object2).addValue((String)object3);
                        attributeList2.put((Attribute)object2);
                        continue;
                    }
                    object4 = new DateTimeAttribute((AttributeTag)object7);
                    attributeList2.put((Attribute)object4);
                }
                catch (ParseException parseException) {
                    object4 = new DateTimeAttribute((AttributeTag)object7);
                    attributeList2.put((Attribute)object4);
                }
                continue;
            }
            if (object instanceof DateAttribute && !((AttributeTag)object7).equals(dictionary.getTagFromName("PatientBirthDate"))) {
                object6 = ClinicalTrialsAttributes.getTagOfTimeAttributeCorrespondingToDateAttribute(((DateAttribute)object).getTag());
                object5 = ((Attribute)object).getSingleStringValueOrEmptyString();
                if (((String)object5).length() == 8) {
                    object4 = defaultValueForMissingPossiblyZeroLengthStrings;
                    if (object6 != null) {
                        object4 = Attribute.getSingleStringValueOrDefault(attributeList, (AttributeTag)object6, defaultValueForMissingPossiblyZeroLengthStrings);
                    }
                    if (((String)object4).length() > 0) {
                        object5 = (String)object5 + (String)object4;
                    }
                    try {
                        object3 = DateTimeAttribute.getDateFromFormattedString((String)object5);
                        if (object3 == null) continue;
                        object2 = ClinicalTrialsAttributes.getDateOffsetByEarliestMovedToEpoch((Date)object3, date, date2);
                        String string2 = DateTimeAttribute.getFormattedString((Date)object2, TimeZone.getTimeZone("GMT"), false);
                        StringAttribute stringAttribute = new DateAttribute((AttributeTag)object7);
                        ((Attribute)stringAttribute).addValue(string2.substring(0, 8));
                        attributeList2.put(stringAttribute);
                        if (object6 == null) continue;
                        stringAttribute = new TimeAttribute((AttributeTag)object6);
                        ((Attribute)stringAttribute).addValue(string2.substring(8));
                        attributeList2.put(stringAttribute);
                    }
                    catch (ParseException parseException) {
                        object2 = new DateAttribute((AttributeTag)object7);
                        attributeList2.put((Attribute)object2);
                        if (object6 == null) continue;
                        object2 = new TimeAttribute((AttributeTag)object6);
                        attributeList2.put((Attribute)object2);
                    }
                    continue;
                }
                object4 = new DateAttribute((AttributeTag)object7);
                attributeList2.put((Attribute)object4);
                if (object6 == null) continue;
                object4 = new TimeAttribute((AttributeTag)object6);
                attributeList2.put((Attribute)object4);
                continue;
            }
            if (!(object instanceof TimeAttribute) || ((Attribute)object).getVL() <= 0L || !((AttributeTag)object7).equals(dictionary.getTagFromName("RadiopharmaceuticalStartTime")) && !((AttributeTag)object7).equals(dictionary.getTagFromName("RadiopharmaceuticalStopTime")) && !((AttributeTag)object7).equals(dictionary.getTagFromName("InterventionDrugStartTime")) && !((AttributeTag)object7).equals(dictionary.getTagFromName("InterventionDrugStopTime")) && !((AttributeTag)object7).equals(dictionary.getTagFromName("ContrastBolusStartTime")) && !((AttributeTag)object7).equals(dictionary.getTagFromName("ContrastBolusStopTime")) || string.length() != 8) continue;
            object6 = string + ((Attribute)object).getSingleStringValueOrEmptyString();
            try {
                object5 = DateTimeAttribute.getDateFromFormattedString((String)object6);
                if (object5 == null) continue;
                object4 = ClinicalTrialsAttributes.getDateOffsetByEarliestMovedToEpoch((Date)object5, date, date2);
                object3 = DateTimeAttribute.getFormattedString((Date)object4, TimeZone.getTimeZone("GMT"), false);
                object2 = new TimeAttribute((AttributeTag)object7);
                ((Attribute)object2).addValue(((String)object3).substring(8));
                attributeList2.put((Attribute)object2);
            }
            catch (ParseException parseException) {
            }
        }
        for (Object object7 : linkedList) {
            attributeList.remove((AttributeTag)object7);
        }
        attributeList.putAll(attributeList2);
    }

    protected static void removeStructuredContent(AttributeList attributeList) {
        attributeList.remove(dictionary.getTagFromName("ConceptNameCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("ObservationUID"));
        attributeList.remove(dictionary.getTagFromName("ObservationDateTime"));
        attributeList.remove(dictionary.getTagFromName("ReferencedContentItemIdentifier"));
        attributeList.remove(dictionary.getTagFromName("RelationshipType"));
        attributeList.remove(dictionary.getTagFromName("ContentSequence"));
        attributeList.remove(dictionary.getTagFromName("ValueType"));
        attributeList.remove(dictionary.getTagFromName("TextValue"));
        attributeList.remove(dictionary.getTagFromName("DateTime"));
        attributeList.remove(dictionary.getTagFromName("Date"));
        attributeList.remove(dictionary.getTagFromName("Time"));
        attributeList.remove(dictionary.getTagFromName("PersonName"));
        attributeList.remove(dictionary.getTagFromName("UID"));
        attributeList.remove(dictionary.getTagFromName("MeasuredValueSequence"));
        attributeList.remove(dictionary.getTagFromName("NumericValueQualifierCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("ConceptCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferencedSOPSequence"));
        attributeList.remove(dictionary.getTagFromName("GraphicData"));
        attributeList.remove(dictionary.getTagFromName("GraphicType"));
        attributeList.remove(dictionary.getTagFromName("PixelOriginInterpretation"));
        attributeList.remove(dictionary.getTagFromName("FiducialUID"));
        attributeList.remove(dictionary.getTagFromName("ReferencedFrameOfReferenceUID"));
        attributeList.remove(dictionary.getTagFromName("TemporalRangeType"));
        attributeList.remove(dictionary.getTagFromName("ReferencedSamplePositions"));
        attributeList.remove(dictionary.getTagFromName("ReferencedTimeOffsets"));
        attributeList.remove(dictionary.getTagFromName("ReferencedDateTime"));
        attributeList.remove(dictionary.getTagFromName("ContinuityOfContent"));
        attributeList.remove(dictionary.getTagFromName("ContentTemplateSequence"));
    }

    protected static void removeOrCleanStructuredContent(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, int n3) throws DicomException {
        Object object;
        Object object2;
        Iterator<SequenceItem> iterator;
        Object object3;
        Object object4;
        AttributeList attributeList2 = new AttributeList();
        for (Attribute attribute : attributeList.values()) {
            if (!(attribute instanceof SequenceAttribute)) continue;
            object4 = new LinkedList();
            object3 = (SequenceAttribute)attribute;
            iterator = ((SequenceAttribute)object3).iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    object2 = (SequenceItem)iterator.next();
                    if (object2 == null || (object = ((SequenceItem)object2).getAttributeList()) == null || ((AbstractMap)object).isEmpty()) continue;
                    ClinicalTrialsAttributes.removeOrCleanStructuredContent((AttributeList)object, n, bl, bl2, bl3, bl4, bl5, bl6, n2, n3);
                    if (!((AbstractMap)object).isEmpty()) continue;
                    object4.add(object2);
                }
            }
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (SequenceItem)object2.next();
                ((SequenceAttribute)object3).remove((SequenceItem)object);
            }
        }
        boolean bl7 = false;
        object4 = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, dictionary.getTagFromName("ConceptNameCodeSequence"));
        if (object4 != null) {
            if (n == 1) {
                bl7 = true;
            } else if (n == 2) {
                object3 = ((CodedSequenceItem)object4).getCodeValue();
                iterator = ((CodedSequenceItem)object4).getCodingSchemeDesignator();
                object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("ValueType"));
                if (((String)object3).equals("121022") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113795") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("126201") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("125203") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("126202") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("C67447") && ((String)((Object)iterator)).equals("NCIt") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("440252007") && ((String)((Object)iterator)).equals("SCT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("15") && ((String)((Object)iterator)).equals("NCDR [2.0b]") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112050") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("DF-0070B") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("DF-0068E") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121080") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121080") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("WAVEFORM")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113723") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("113720") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113724") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("76") && ((String)((Object)iterator)).equals("NCDR [2.0b]") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121120") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("R-42B89") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("R-42B89") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121106") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("DD-60002") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112347") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121077") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111018") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        object = new DateAttribute(dictionary.getTagFromName("Date"));
                        ((Attribute)object).addValue(replacementForDateInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("111019") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TIME")) {
                    if (n3 == 1) {
                        object = new TimeAttribute(dictionary.getTagFromName("Time"));
                        ((Attribute)object).addValue(replacementForTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("122073") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("11955-2") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121431") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121432") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111527") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122165") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122105") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111536") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111702") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121125") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111535") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121433") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111526") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("112363") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("112357") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112373") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112372") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111021") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121145") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113877") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121013") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121017") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121016") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121012") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113880") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121193") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121197") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121196") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121198") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (!bl5 && n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122163") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121342") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122083") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("122082") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122081") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("F-00033") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("11778-8") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113810") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121122") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5 && !bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128429") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121088") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    bl7 = true;
                } else if (((String)object3).equals("11951-1") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121021") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("121071") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("G-C0E3") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("112227") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("127857") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        object = new DateAttribute(dictionary.getTagFromName("Date"));
                        ((Attribute)object).addValue(replacementForDateInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("127858") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TIME")) {
                    if (n3 == 1) {
                        object = new TimeAttribute(dictionary.getTagFromName("Time"));
                        ((Attribute)object).addValue(replacementForTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("11329-0") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113832") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl5) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("125010") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("128775") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("112229") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("125201") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121200") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121138") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122712") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("112366") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111033") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("18785-6") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121154") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("113850") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("113605") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113769") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("110190") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("111706") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("111724") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113012") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("18118-0") && ((String)((Object)iterator)).equals("LN") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112371") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112352") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("112351") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("111516") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121036") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    bl7 = true;
                } else if (((String)object3).equals("113873") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111040") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111705") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("112361") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112354") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113815") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121110") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128425") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128425") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128425") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128426") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("109054") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122128") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121126") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121114") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121152") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    bl7 = true;
                } else if (((String)object3).equals("113871") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113872") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113870") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("128774") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("121009") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121008") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121173") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121020") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113516") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("122075") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121124") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("122146") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("52") && ((String)((Object)iterator)).equals("NCDR [2.0b]") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121065") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("53") && ((String)((Object)iterator)).equals("NCDR [2.0b]") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("122177") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121019") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121018") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("122701") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111703") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("126071") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128230") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121002") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128436") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128403") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("128414") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128414") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113514") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113503") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113511") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("113512") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("123003") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("123004") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113513") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("126100") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113907") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113552") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121075") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111054") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        object = new DateAttribute(dictionary.getTagFromName("Date"));
                        ((Attribute)object).addValue(replacementForDateInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121191") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121214") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112364") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121121") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("111469") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("111058") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("112002") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113985") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121434") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl6) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121435") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    bl7 = true;
                } else if (((String)object3).equals("121435") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("F-02455") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121233") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121112") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121112") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("WAVEFORM")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121232") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128447") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112353") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128444") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111700") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("121041") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("121039") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128416") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("G-D321") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("113809") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("110119") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    bl7 = true;
                } else if (((String)object3).equals("122173") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("G-D320") && ((String)((Object)iterator)).equals("SRT") && ((String)object2).equals("DATETIME")) {
                    if (n3 == 1) {
                        object = new DateTimeAttribute(dictionary.getTagFromName("DateTime"));
                        ((Attribute)object).addValue(replacementForDateTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("109056") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111060") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    if (n3 == 1) {
                        object = new DateAttribute(dictionary.getTagFromName("Date"));
                        ((Attribute)object).addValue(replacementForDateInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("110180") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("111061") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TIME")) {
                    if (n3 == 1) {
                        object = new TimeAttribute(dictionary.getTagFromName("Time"));
                        ((Attribute)object).addValue(replacementForTimeInStructuredContent);
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("121033") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("NUM")) {
                    if (!bl4) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121031") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("DATE")) {
                    bl7 = true;
                } else if (((String)object3).equals("121030") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                    ((Attribute)object).addValue("REMOVED");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121029") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("PNAME")) {
                    object = new PersonNameAttribute(dictionary.getTagFromName("PersonName"));
                    ((Attribute)object).addValue("Nobody^Noone");
                    attributeList2.put((Attribute)object);
                } else if (((String)object3).equals("121032") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("CODE")) {
                    if (!bl4) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("126070") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121028") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121111") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112359") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("C2348792") && ((String)((Object)iterator)).equals("UMLS") && ((String)object2).equals("TEXT")) {
                    if (!bl) {
                        object = new UnlimitedTextAttribute(dictionary.getTagFromName("TextValue"));
                        ((Attribute)object).addValue("REMOVED");
                        attributeList2.put((Attribute)object);
                    }
                } else if (((String)object3).equals("112040") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("112356") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("121143") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("WAVEFORM")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128470") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128470") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("IMAGE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("128470") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("UIDREF")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object3).equals("113701") && ((String)((Object)iterator)).equals("DCM") && ((String)object2).equals("COMPOSITE")) {
                    if (n2 == 1) {
                        bl7 = true;
                    }
                } else if (((String)object2).equals("PNAME")) {
                    bl7 = true;
                } else if (((String)object2).equals("TEXT")) {
                    bl7 = true;
                }
            }
        }
        if (bl7) {
            ClinicalTrialsAttributes.removeStructuredContent(attributeList);
        }
        attributeList.putAll(attributeList2);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, boolean bl, boolean bl2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, bl, bl2, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, bl ? 0 : 1, bl2, bl3);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, false, bl2, false, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, bl2, bl3, bl4, bl5, 0, null, null);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, Date date, Date date2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, bl2, false, bl3, bl4, bl5, n2, date, date2);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, Date date, Date date2) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, bl2, false, bl4, bl5, bl6, n2, date, date2, 0, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, Date date, Date date2, int n3) throws DicomException {
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, n, bl, bl2, bl3, bl4, bl5, bl6, n2, date, date2, n3, false);
    }

    public static void removeOrNullIdentifyingAttributes(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, Date date, Date date2, int n3, boolean bl7) throws DicomException {
        Object object;
        ClinicalTrialsAttributes.removeOrNullIdentifyingAttributesRecursively(attributeList, n, bl, bl2, bl3, bl4, bl5, bl6, bl7);
        if (n != 0) {
            ClinicalTrialsAttributes.removeOrRemapUIDAttributes(attributeList, n);
        }
        if (n2 != 0) {
            object = ClinicalTrialsAttributes.getDateToUseForUnaccompaniedTimes(attributeList);
            if (date2 == null) {
                date2 = ClinicalTrialsAttributes.findEarliestDateTime(attributeList, null, (String)object);
            }
            ClinicalTrialsAttributes.removeOrRemapDateAndTimeAttributes(attributeList, n2, date, date2, (String)object);
        }
        if (n3 != 0) {
            ClinicalTrialsAttributes.removeOrCleanStructuredContent(attributeList, n3, bl, bl2, bl3, bl4, bl5, bl6, n, n2);
        }
        object = dictionary.getTagFromName("PatientIdentityRemoved");
        attributeList.remove((AttributeTag)object);
        Attribute attribute = new CodeStringAttribute((AttributeTag)object);
        attribute.addValue("YES");
        attributeList.put((AttributeTag)object, attribute);
        object = dictionary.getTagFromName("DeidentificationMethod");
        attribute = attributeList.get((AttributeTag)object);
        if (attribute == null) {
            attribute = new LongStringAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, attribute);
        }
        attribute.addValue("Deidentified");
        attribute.addValue("Descriptors " + (bl ? "retained" : "removed" + (bl2 ? " except series" : defaultValueForMissingPossiblyZeroLengthStrings) + (bl3 ? " except protocol" : defaultValueForMissingPossiblyZeroLengthStrings)));
        attribute.addValue("Patient Characteristics " + (bl4 ? (bl7 ? "retained with ages >89 set to 90" : "retained") : "removed"));
        attribute.addValue("Device identity " + (bl5 ? "retained" : "removed"));
        attribute.addValue("Institution identity " + (bl6 ? "retained" : "removed"));
        if (n != 0) {
            attribute.addValue("UIDs " + (n == 2 ? "remapped" : "removed"));
        }
        attribute.addValue("Dates " + (n2 == 0 ? "retained" : (n2 == 2 ? "modified" : "removed")));
        attribute.addValue("Structured content " + (n3 == 0 ? "retained" : (n3 == 2 ? "modified" : "removed")));
        object = dictionary.getTagFromName("DeidentificationMethodCodeSequence");
        attribute = (SequenceAttribute)attributeList.get((AttributeTag)object);
        if (attribute == null) {
            attribute = new SequenceAttribute((AttributeTag)object);
            attributeList.put((AttributeTag)object, attribute);
        }
        ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113100", "DCM", "Basic Application Confidentiality Profile").getAttributeList());
        if (bl) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210005", "99PMP", "Retain all descriptors unchanged").getAttributeList());
        } else if (bl2 && bl3) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210008", "99PMP", "Remove all descriptors except Series Description & Protocol Name").getAttributeList());
        } else if (bl3) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210009", "99PMP", "Remove all descriptors except Protocol Name").getAttributeList());
        } else if (bl2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210003", "99PMP", "Remove all descriptors except Series Description").getAttributeList());
        } else {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210004", "99PMP", "Remove all descriptors").getAttributeList());
        }
        if (bl4) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113108", "DCM", "Retain Patient Characteristics Option").getAttributeList());
            if (bl7) {
                ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210012", "99PMP", "Patient ages > 89 years set to 90").getAttributeList());
            }
        }
        if (bl5) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113109", "DCM", "Retain Device Identity Option").getAttributeList());
        }
        if (bl6) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113112", "DCM", "Retain Institution Identity Option").getAttributeList());
        }
        if (n == 0) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113110", "DCM", "Retain UIDs Option").getAttributeList());
        } else if (n == 2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
        } else if (n == 1) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210007", "99PMP", "Remove UIDs").getAttributeList());
        }
        if (n2 == 0) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113106", "DCM", "Retain Longitudinal Temporal Information Full Dates Option").getAttributeList());
        } else if (n2 == 2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113107", "DCM", "Retain Longitudinal Temporal Information Modified Dates Option").getAttributeList());
        }
        if (n3 == 0) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210011", "99PMP", "Retain all structured content unchanged").getAttributeList());
        } else if (n3 == 2) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("113104", "DCM", "Clean Structured Content Option").getAttributeList());
        } else if (n3 == 1) {
            ((SequenceAttribute)attribute).addItem(new CodedSequenceItem("210010", "99PMP", "Remove all structured content").getAttributeList());
        }
    }

    protected static void removeOrNullIdentifyingAttributesRecursively(AttributeList attributeList, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7) throws DicomException {
        Attribute attribute;
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("StudyDescription"));
            if (!bl2) {
                attributeList.remove(dictionary.getTagFromName("SeriesDescription"));
                attributeList.remove(dictionary.getTagFromName("ClinicalTrialSeriesDescription"));
            }
            if (!bl3) {
                attributeList.remove(dictionary.getTagFromName("ProtocolName"));
            }
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("AccessionNumber"));
        if (!bl6) {
            attributeList.remove(dictionary.getTagFromName("InstitutionCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("InstitutionName"));
            attributeList.remove(dictionary.getTagFromName("InstitutionAddress"));
            attributeList.remove(dictionary.getTagFromName("InstitutionalDepartmentName"));
            attributeList.remove(dictionary.getTagFromName("InstitutionalDepartmentTypeCodeSequence"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("SourceOfPreviousValues"));
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("ReferringPhysicianName"));
        attributeList.remove(dictionary.getTagFromName("ReferringPhysicianAddress"));
        attributeList.remove(dictionary.getTagFromName("ReferringPhysicianTelephoneNumbers"));
        attributeList.remove(dictionary.getTagFromName("PhysiciansOfRecord"));
        attributeList.remove(dictionary.getTagFromName("PerformingPhysicianName"));
        attributeList.remove(dictionary.getTagFromName("ConsultingPhysicianName"));
        attributeList.remove(dictionary.getTagFromName("ConsultingPhysicianIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("NameOfPhysiciansReadingStudy"));
        attributeList.remove(dictionary.getTagFromName("RequestingPhysician"));
        attributeList.remove(dictionary.getTagFromName("ReviewerName"));
        if (bl4 && Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("PatientAge")).length() == 0) {
            ClinicalTrialsAttributes.addAgeDerivedFromBirthDateAndStudyRelatedDate(attributeList);
        }
        attributeList.remove(dictionary.getTagFromName("OperatorsName"));
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("AdmittingDiagnosesDescription"));
            attributeList.remove(dictionary.getTagFromName("AdmittingDiagnosesCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("PrincipalDiagnosisCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("PrimaryDiagnosisCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("SecondaryDiagnosesCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("HistologicalDiagnosesCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("DerivationDescription"));
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PatientName"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PatientID"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PatientBirthDate"));
        attributeList.remove(dictionary.getTagFromName("PatientBirthTime"));
        attributeList.remove(dictionary.getTagFromName("ReferencedPatientPhotoSequence"));
        attributeList.remove(dictionary.getTagFromName("OtherPatientIDs"));
        attributeList.remove(dictionary.getTagFromName("OtherPatientIDsSequence"));
        attributeList.remove(dictionary.getTagFromName("OtherPatientNames"));
        if (bl4) {
            Object object;
            if (bl7 && ((String)(object = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("PatientAge")).trim().toUpperCase())).length() > 0 && ((String)object).endsWith("Y")) {
                try {
                    int n2 = Integer.parseInt(((String)object).substring(0, ((String)object).length() - 1));
                    if (n2 > 89) {
                        attribute = new AgeStringAttribute(dictionary.getTagFromName("PatientAge"));
                        attribute.addValue("090Y");
                        attributeList.put(attribute);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PatientSex"));
            attributeList.remove(dictionary.getTagFromName("PatientAge"));
            attributeList.remove(dictionary.getTagFromName("PatientSize"));
            attributeList.remove(dictionary.getTagFromName("PatientWeight"));
            attributeList.remove(dictionary.getTagFromName("EthnicGroup"));
            attributeList.remove(dictionary.getTagFromName("EthnicGroupCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("PregnancyStatus"));
            attributeList.remove(dictionary.getTagFromName("SmokingStatus"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PatientSexNeutered"));
            attributeList.remove(dictionary.getTagFromName("SpecialNeeds"));
        }
        attributeList.remove(dictionary.getTagFromName("MedicalRecordLocator"));
        attributeList.remove(dictionary.getTagFromName("Occupation"));
        attributeList.remove(dictionary.getTagFromName("AdditionalPatientHistory"));
        attributeList.remove(dictionary.getTagFromName("PatientComments"));
        if (!bl5) {
            attributeList.remove(dictionary.getTagFromName("StationName"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("DeviceSerialNumber"), replacementForDeviceSerialNumber);
            attributeList.remove(dictionary.getTagFromName("DeviceUID"));
            attributeList.remove(dictionary.getTagFromName("PlateID"));
            attributeList.remove(dictionary.getTagFromName("GantryID"));
            attributeList.remove(dictionary.getTagFromName("CassetteID"));
            attributeList.remove(dictionary.getTagFromName("GeneratorID"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("DetectorID"), replacementForDetectorID);
            attributeList.remove(dictionary.getTagFromName("PerformedStationAETitle"));
            attributeList.remove(dictionary.getTagFromName("PerformedStationGeographicLocationCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("PerformedStationName"));
            attributeList.remove(dictionary.getTagFromName("PerformedStationNameCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("ScheduledProcedureStepLocation"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStationAETitle"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStationGeographicLocationCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStationName"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStationNameCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStudyLocation"));
            attributeList.remove(dictionary.getTagFromName("ScheduledStudyLocationAETitle"));
            attributeList.remove(dictionary.getTagFromName("SourceManufacturer"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("SourceSerialNumber"));
            attributeList.remove(dictionary.getTagFromName("TreatmentMachineName"));
            attributeList.remove(dictionary.getTagFromName("UDISequence"));
            attributeList.remove(dictionary.getTagFromName("UniqueDeviceIdentifier"));
            attributeList.remove(dictionary.getTagFromName("DeviceDescription"));
            attributeList.remove(dictionary.getTagFromName("LensMake"));
            attributeList.remove(dictionary.getTagFromName("LensModel"));
            attributeList.remove(dictionary.getTagFromName("LensSerialNumber"));
            attributeList.remove(dictionary.getTagFromName("LensSpecification"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("XRayDetectorID"), replacementForDetectorID);
            attributeList.remove(dictionary.getTagFromName("XRayDetectorLabel"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("XRaySourceID"), replacementForDetectorID);
            attributeList.remove(dictionary.getTagFromName("TransducerIdentificationSequence"));
            attributeList.remove(dictionary.getTagFromName("DateOfLastCalibration"));
            attributeList.remove(dictionary.getTagFromName("DateOfLastDetectorCalibration"));
            attributeList.remove(dictionary.getTagFromName("TimeOfLastCalibration"));
            attributeList.remove(dictionary.getTagFromName("TimeOfLastDetectorCalibration"));
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("StudyID"));
        attributeList.remove(dictionary.getTagFromName("RequestAttributesSequence"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfAccessionNumberSequence"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfPatientID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfPatientIDQualifiersSequence"));
        attributeList.remove(dictionary.getTagFromName("StudyIDIssuer"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfAdmissionID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfAdmissionIDSequence"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfServiceEpisodeID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfServiceEpisodeIDSequence"));
        attributeList.remove(dictionary.getTagFromName("ResultsIDIssuer"));
        attributeList.remove(dictionary.getTagFromName("InterpretationIDIssuer"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialProtocolID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialSeriesID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialSiteID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialSubjectID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialSubjectReadingID"));
        attributeList.remove(dictionary.getTagFromName("IssuerOfClinicalTrialTimePointID"));
        attributeList.remove(dictionary.getTagFromName("OtherClinicalTrialProtocolIDsSequence"));
        attributeList.remove(dictionary.getTagFromName("StudyStatusID"));
        attributeList.remove(dictionary.getTagFromName("StudyPriorityID"));
        attributeList.remove(dictionary.getTagFromName("CurrentPatientLocation"));
        attributeList.remove(dictionary.getTagFromName("PatientInstitutionResidence"));
        attributeList.remove(dictionary.getTagFromName("PatientTransportArrangements"));
        attributeList.remove(dictionary.getTagFromName("PatientAddress"));
        attributeList.remove(dictionary.getTagFromName("MilitaryRank"));
        attributeList.remove(dictionary.getTagFromName("BranchOfService"));
        attributeList.remove(dictionary.getTagFromName("PatientBirthName"));
        attributeList.remove(dictionary.getTagFromName("PatientMotherBirthName"));
        attributeList.remove(dictionary.getTagFromName("ConfidentialityConstraintOnPatientDataDescription"));
        attributeList.remove(dictionary.getTagFromName("PatientInsurancePlanCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("PatientPrimaryLanguageCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("PatientPrimaryLanguageModifierCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("CountryOfResidence"));
        attributeList.remove(dictionary.getTagFromName("RegionOfResidence"));
        attributeList.remove(dictionary.getTagFromName("PatientTelephoneNumbers"));
        attributeList.remove(dictionary.getTagFromName("PatientReligiousPreference"));
        attributeList.remove(dictionary.getTagFromName("MedicalAlerts"));
        attributeList.remove(dictionary.getTagFromName("Allergies"));
        attributeList.remove(dictionary.getTagFromName("LastMenstrualDate"));
        attributeList.remove(dictionary.getTagFromName("SpecialNeeds"));
        attributeList.remove(dictionary.getTagFromName("PatientState"));
        attributeList.remove(dictionary.getTagFromName("AdmissionID"));
        attributeList.remove(dictionary.getTagFromName("AdmittingDate"));
        attributeList.remove(dictionary.getTagFromName("AdmittingTime"));
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("ImageComments"));
            attributeList.remove(dictionary.getTagFromName("FrameComments"));
        }
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("ContentCreatorName"), "Nobody^Noone");
        attributeList.remove(dictionary.getTagFromName("ContentCreatorIdentificationCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferencedPatientSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferringPhysicianIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("PhysiciansOfRecordIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("PhysiciansReadingStudyIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferencedStudySequence"));
        attributeList.remove(dictionary.getTagFromName("PerformingPhysicianIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("OperatorIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("ScheduledProcedureStepID"));
        attributeList.remove(dictionary.getTagFromName("PerformedProcedureStepID"));
        attributeList.remove(dictionary.getTagFromName("DataSetTrailingPadding"));
        attributeList.remove(dictionary.getTagFromName("DigitalSignaturesSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferencedDigitalSignatureSequence"));
        attributeList.remove(dictionary.getTagFromName("ReferencedSOPInstanceMACSequence"));
        attributeList.remove(dictionary.getTagFromName("MAC"));
        attributeList.remove(dictionary.getTagFromName("ModifiedAttributesSequence"));
        attributeList.remove(dictionary.getTagFromName("OriginalAttributesSequence"));
        attributeList.remove(dictionary.getTagFromName("ActualHumanPerformersSequence"));
        attributeList.remove(dictionary.getTagFromName("AddressTrial"));
        attributeList.remove(dictionary.getTagFromName("Arbitrary"));
        attributeList.remove(dictionary.getTagFromName("AuthorObserverSequence"));
        attributeList.remove(dictionary.getTagFromName("ContributionDescription"));
        attributeList.remove(dictionary.getTagFromName("CurrentObserverTrial"));
        attributeList.remove(dictionary.getTagFromName("CustodialOrganizationSequence"));
        attributeList.remove(dictionary.getTagFromName("DistributionAddress"));
        attributeList.remove(dictionary.getTagFromName("DistributionName"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("FillerOrderNumberImagingServiceRequest"));
        attributeList.remove(dictionary.getTagFromName("HumanPerformerName"));
        attributeList.remove(dictionary.getTagFromName("HumanPerformerOrganization"));
        attributeList.remove(dictionary.getTagFromName("IconImageSequence"));
        attributeList.remove(dictionary.getTagFromName("IdentifyingComments"));
        attributeList.remove(dictionary.getTagFromName("InsurancePlanIdentification"));
        attributeList.remove(dictionary.getTagFromName("IntendedRecipientsOfResultsIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("InterpretationApproverSequence"));
        attributeList.remove(dictionary.getTagFromName("InterpretationAuthor"));
        attributeList.remove(dictionary.getTagFromName("InterpretationRecorder"));
        attributeList.remove(dictionary.getTagFromName("InterpretationTranscriber"));
        attributeList.remove(dictionary.getTagFromName("InstanceOriginStatus"));
        attributeList.remove(dictionary.getTagFromName("ModifyingDeviceID"));
        attributeList.remove(dictionary.getTagFromName("ModifyingDeviceManufacturer"));
        attributeList.remove(dictionary.getTagFromName("NamesOfIntendedRecipientsOfResults"));
        attributeList.remove(dictionary.getTagFromName("OrderCallbackPhoneNumber"));
        attributeList.remove(dictionary.getTagFromName("OrderCallbackTelecomInformation"));
        attributeList.remove(dictionary.getTagFromName("OrderEnteredBy"));
        attributeList.remove(dictionary.getTagFromName("OrderEntererLocation"));
        attributeList.remove(dictionary.getTagFromName("ParticipantSequence"));
        attributeList.remove(dictionary.getTagFromName("PatientTelecomInformation"));
        attributeList.remove(dictionary.getTagFromName("PerformedLocation"));
        attributeList.remove(dictionary.getTagFromName("PersonAddress"));
        attributeList.remove(dictionary.getTagFromName("PersonIdentificationCodeSequence"));
        attributeList.remove(dictionary.getTagFromName("PersonName"));
        attributeList.remove(dictionary.getTagFromName("PersonTelecomInformation"));
        attributeList.remove(dictionary.getTagFromName("PersonTelephoneNumbers"));
        attributeList.remove(dictionary.getTagFromName("PhysicianApprovingInterpretation"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PlacerOrderNumberImagingServiceRequest"));
        attributeList.remove(dictionary.getTagFromName("PreMedication"));
        attributeList.remove(dictionary.getTagFromName("ReferencedPatientAliasSequence"));
        attributeList.remove(dictionary.getTagFromName("RequestedProcedureLocation"));
        attributeList.remove(dictionary.getTagFromName("RequestedProcedureID"));
        attributeList.remove(dictionary.getTagFromName("RequestingService"));
        attributeList.remove(dictionary.getTagFromName("ResponsibleOrganization"));
        attributeList.remove(dictionary.getTagFromName("ResponsiblePerson"));
        attributeList.remove(dictionary.getTagFromName("ResultsDistributionListSequence"));
        attributeList.remove(dictionary.getTagFromName("ScheduledHumanPerformersSequence"));
        attributeList.remove(dictionary.getTagFromName("ScheduledPatientInstitutionResidence"));
        attributeList.remove(dictionary.getTagFromName("ScheduledPerformingPhysicianIdentificationSequence"));
        attributeList.remove(dictionary.getTagFromName("ScheduledPerformingPhysicianName"));
        attributeList.remove(dictionary.getTagFromName("ServiceEpisodeID"));
        attributeList.remove(dictionary.getTagFromName("TelephoneNumberTrial"));
        attributeList.remove(dictionary.getTagFromName("TextComments"));
        attributeList.remove(dictionary.getTagFromName("TextString"));
        attributeList.remove(dictionary.getTagFromName("TopicAuthor"));
        attributeList.remove(dictionary.getTagFromName("TopicKeywords"));
        attributeList.remove(dictionary.getTagFromName("TopicSubject"));
        attributeList.remove(dictionary.getTagFromName("TopicTitle"));
        attributeList.remove(dictionary.getTagFromName("VerbalSourceTrial"));
        attributeList.remove(dictionary.getTagFromName("VerbalSourceIdentifierCodeSequenceTrial"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("VerifyingObserverIdentificationCodeSequence"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("VerifyingObserverName"), replacementForVerifyingObserverName);
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("VerifyingObserverSequence"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("VerifyingOrganization"), replacementForVerifyingOrganization);
        attributeList.remove(dictionary.getTagFromName("CameraOwnerName"));
        attributeList.remove(dictionary.getTagFromName("GPSAltitude"));
        attributeList.remove(dictionary.getTagFromName("GPSAltitudeRef"));
        attributeList.remove(dictionary.getTagFromName("GPSAreaInformation"));
        attributeList.remove(dictionary.getTagFromName("GPSDestBearing"));
        attributeList.remove(dictionary.getTagFromName("GPSDestBearingRef"));
        attributeList.remove(dictionary.getTagFromName("GPSDestDistance"));
        attributeList.remove(dictionary.getTagFromName("GPSDestDistanceRef"));
        attributeList.remove(dictionary.getTagFromName("GPSDestLatitude"));
        attributeList.remove(dictionary.getTagFromName("GPSDestLatitudeRef"));
        attributeList.remove(dictionary.getTagFromName("GPSDestLongitude"));
        attributeList.remove(dictionary.getTagFromName("GPSDestLongitudeRef"));
        attributeList.remove(dictionary.getTagFromName("GPSDifferential"));
        attributeList.remove(dictionary.getTagFromName("GPSDOP"));
        attributeList.remove(dictionary.getTagFromName("GPSImgDirection"));
        attributeList.remove(dictionary.getTagFromName("GPSImgDirectionRef"));
        attributeList.remove(dictionary.getTagFromName("GPSLatitude"));
        attributeList.remove(dictionary.getTagFromName("GPSLatitudeRef"));
        attributeList.remove(dictionary.getTagFromName("GPSLongitude"));
        attributeList.remove(dictionary.getTagFromName("GPSLongitudeRef"));
        attributeList.remove(dictionary.getTagFromName("GPSMapDatum"));
        attributeList.remove(dictionary.getTagFromName("GPSMeasureMode"));
        attributeList.remove(dictionary.getTagFromName("GPSProcessingMethod"));
        attributeList.remove(dictionary.getTagFromName("GPSSatellites"));
        attributeList.remove(dictionary.getTagFromName("GPSSpeed"));
        attributeList.remove(dictionary.getTagFromName("GPSSpeedRef"));
        attributeList.remove(dictionary.getTagFromName("GPSStatus"));
        attributeList.remove(dictionary.getTagFromName("GPSTimeStamp"));
        attributeList.remove(dictionary.getTagFromName("GPSTrack"));
        attributeList.remove(dictionary.getTagFromName("GPSTrackRef"));
        attributeList.remove(dictionary.getTagFromName("GPSVersionID"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("BarcodeValue"));
        attributeList.remove(dictionary.getTagFromName("ContainerComponentID"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("ContainerIdentifier"), replacementForContainerIdentifier);
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("IssuerOfTheContainerIdentifierSequence"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("IssuerOfTheSpecimenIdentifierSequence"));
        attributeList.remove(dictionary.getTagFromName("SlideIdentifier"));
        attributeList.remove(dictionary.getTagFromName("SpecimenAccessionNumber"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("SpecimenPreparationSequence"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SpecimenIdentifier"), replacementForSpecimenIdentifier);
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("ContainerDescription"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("LabelText"));
            attributeList.remove(dictionary.getTagFromName("SpecimenDetailedDescription"));
            attributeList.remove(dictionary.getTagFromName("SpecimenShortDescription"));
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("RTAccessoryDeviceSlotID"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("RTAccessoryHolderSlotID"));
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("EquipmentFrameOfReferenceDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RadiationDoseIdentificationLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RadiationDoseInVivoMeasurementLabel"), "REMOVED");
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("RadiationGenerationModeDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RadiationGenerationModeLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RTToleranceSetLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("TreatmentPositionGroupLabel"), "REMOVED");
        }
        attributeList.remove(dictionary.getTagFromName("PrescriptionNotesSequence"));
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("ROIInterpreter"));
        attributeList.remove(dictionary.getTagFromName("NonconformingModifiedAttributesSequence"));
        attributeList.remove(dictionary.getTagFromName("NonconformingDataElementValue"));
        attributeList.remove(dictionary.getTagFromName("InterpretationID"));
        attributeList.remove(dictionary.getTagFromName("ResultsID"));
        if (!bl5) {
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("DeviceAlternateIdentifier"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("DeviceLabel"), "REMOVED");
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("ManufacturerDeviceIdentifier"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("ModifyingSystem"), "REMOVED");
        }
        if (!bl) {
            attributeList.remove(dictionary.getTagFromName("LongDeviceDescription"));
            attributeList.remove(dictionary.getTagFromName("ConceptualVolumeCombinationDescription"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("ConceptualVolumeDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("UserContentLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("UserContentLongLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("EntityLabel"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("EntityName"));
            attributeList.remove(dictionary.getTagFromName("EntityDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("EntityLongLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RTPrescriptionLabel"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("RTTreatmentApproachLabel"), "REMOVED");
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("RTPhysicianIntentNarrative"));
            attributeList.remove(dictionary.getTagFromName("ReasonForSuperseding"));
            attributeList.remove(dictionary.getTagFromName("PriorTreatmentDoseDescription"));
            attributeList.remove(dictionary.getTagFromName("TreatmentSites"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("TreatmentSite"), "REMOVED");
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("TreatmentTechniqueNotes"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("PrescriptionNotes"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("FractionationNotes"));
            attributeList.remove(dictionary.getTagFromName("PerformedProcedureStepDescription"));
            attributeList.remove(dictionary.getTagFromName("CommentsOnThePerformedProcedureStep"));
            attributeList.remove(dictionary.getTagFromName("AcquisitionComments"));
            attributeList.remove(dictionary.getTagFromName("ReasonForStudy"));
            attributeList.remove(dictionary.getTagFromName("RequestedProcedureDescription"));
            attributeList.remove(dictionary.getTagFromName("StudyComments"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("AcquisitionDeviceProcessingDescription"));
            attributeList.remove(dictionary.getTagFromName("DischargeDiagnosisDescription"));
            attributeList.remove(dictionary.getTagFromName("ImagePresentationComments"));
            attributeList.remove(dictionary.getTagFromName("ImagingServiceRequestComments"));
            attributeList.remove(dictionary.getTagFromName("Impressions"));
            attributeList.remove(dictionary.getTagFromName("InterpretationDiagnosisDescription"));
            attributeList.remove(dictionary.getTagFromName("InterpretationText"));
            attributeList.remove(dictionary.getTagFromName("OverlayComments"));
            attributeList.remove(dictionary.getTagFromName("ReasonForTheImagingServiceRequest"));
            attributeList.remove(dictionary.getTagFromName("ContrastBolusAgent"));
            attributeList.remove(dictionary.getTagFromName("RequestedContrastAgent"));
            attributeList.remove(dictionary.getTagFromName("RequestedProcedureComments"));
            attributeList.remove(dictionary.getTagFromName("ResultsComments"));
            attributeList.remove(dictionary.getTagFromName("ScheduledProcedureStepDescription"));
            attributeList.remove(dictionary.getTagFromName("ServiceEpisodeDescription"));
            attributeList.remove(dictionary.getTagFromName("VisitComments"));
            attributeList.remove(dictionary.getTagFromName("ModifiedImageDescription"));
            attributeList.remove(dictionary.getTagFromName("AcquisitionProtocolDescription"));
            attributeList.remove(dictionary.getTagFromName("ReasonForOmissionDescription"));
            attributeList.remove(dictionary.getTagFromName("BeamDescription"));
            attributeList.remove(dictionary.getTagFromName("BolusDescription"));
            attributeList.remove(dictionary.getTagFromName("CompensatorDescription"));
            attributeList.remove(dictionary.getTagFromName("DoseReferenceDescription"));
            attributeList.remove(dictionary.getTagFromName("FixationDeviceDescription"));
            attributeList.remove(dictionary.getTagFromName("FractionGroupDescription"));
            attributeList.remove(dictionary.getTagFromName("PrescriptionDescription"));
            attributeList.remove(dictionary.getTagFromName("RespiratoryMotionCompensationTechniqueDescription"));
            attributeList.remove(dictionary.getTagFromName("RTPlanLabel"));
            attributeList.remove(dictionary.getTagFromName("RTPlanName"));
            attributeList.remove(dictionary.getTagFromName("RTPlanDescription"));
            attributeList.remove(dictionary.getTagFromName("ShieldingDeviceDescription"));
            attributeList.remove(dictionary.getTagFromName("SetupTechniqueDescription"));
            attributeList.remove(dictionary.getTagFromName("DeviceSettingDescription"));
            attributeList.remove(dictionary.getTagFromName("MakerNote"));
            attributeList.remove(dictionary.getTagFromName("ReasonForTheRequestedProcedure"));
            attributeList.remove(dictionary.getTagFromName("ReasonForRequestedProcedureCodeSequence"));
            attributeList.remove(dictionary.getTagFromName("ReasonForVisit"));
            attributeList.remove(dictionary.getTagFromName("ReasonForVisitCodeSequence"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("FlowIdentifierSequence"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("FlowIdentifier"));
            attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("SourceIdentifier"));
            attributeList.remove(dictionary.getTagFromName("DecompositionDescription"));
            attributeList.remove(dictionary.getTagFromName("MultienergyAcquisitionDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("StructureSetLabel"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("StructureSetName"));
            attributeList.remove(dictionary.getTagFromName("StructureSetDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("ROIName"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("ROIDescription"));
            attributeList.remove(dictionary.getTagFromName("ROIGenerationDescription"));
            attributeList.remove(dictionary.getTagFromName("ROIObservationLabel"));
            attributeList.remove(dictionary.getTagFromName("ROIObservationDescription"));
            attributeList.remove(dictionary.getTagFromName("InterlockDescription"));
            attributeList.remove(dictionary.getTagFromName("InterlockOriginDescription"));
            attributeList.remove(dictionary.getTagFromName("TreatmentToleranceViolationDescription"));
            attributeList.remove(dictionary.getTagFromName("CommentsOnRadiationDose"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("AcquisitionFieldOfViewLabel"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("RequestedSeriesDescription"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("ReasonForTheAttributeModification"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("AnnotationGroupLabel"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("AnnotationGroupDescription"));
            attributeList.remove(dictionary.getTagFromName("PatientTreatmentPreparationProcedureParameterDescription"));
            attributeList.remove(dictionary.getTagFromName("PatientTreatmentPreparationMethodDescription"));
            attributeList.remove(dictionary.getTagFromName("PatientSetupPhotoDescription"));
            attributeList.remove(dictionary.getTagFromName("DisplacementReferenceLabel"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorASValue"), replacementForAgeString);
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorLOValue"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorLTValue"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("SelectorOBValue"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorPNValue"), "Nobody^Noone");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorSHValue"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorSTValue"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("SelectorUNValue"));
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorURValue"), "REMOVED");
            attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorUTValue"), "REMOVED");
            attributeList.remove(dictionary.getTagFromName("CertifiedTimestamp"));
            attributeList.remove(dictionary.getTagFromName("ContextGroupLocalVersion"));
            attributeList.remove(dictionary.getTagFromName("ContextGroupVersion"));
            attributeList.remove(dictionary.getTagFromName("PyramidDescription"));
            attributeList.remove(dictionary.getTagFromName("PyramidLabel"));
            attributeList.remove(dictionary.getTagFromName("WaveformFilterDescription"));
            attributeList.remove(dictionary.getTagFromName("FilterLookupTableDescription"));
            attributeList.remove(dictionary.getTagFromName("PositionAcquisitionTemplateName"));
            attributeList.remove(dictionary.getTagFromName("PositionAcquisitionTemplateDescription"));
            attributeList.remove(dictionary.getTagFromName("MontageChannelLabel"));
            attributeList.remove(dictionary.getTagFromName("MontageName"));
        }
        if (n == 1) {
            attributeList.remove(dictionary.getTagFromName("ReferencedImageSequence"));
            attributeList.remove(dictionary.getTagFromName("SourceImageSequence"));
            attributeList.remove(dictionary.getTagFromName("ReferencedPerformedProcedureStepSequence"));
        }
        attributeList.replaceWithZeroLengthIfPresent(dictionary.getTagFromName("FrameOriginTimestamp"));
        attributeList.remove(dictionary.getTagFromName("CertificateOfSigner"));
        attributeList.remove(dictionary.getTagFromName("EncapsulatedDocument"));
        attributeList.remove(dictionary.getTagFromName("RetrieveAETitle"));
        attributeList.remove(dictionary.getTagFromName("StationAETitle"));
        attributeList.remove(dictionary.getTagFromName("NetworkID"));
        attributeList.remove(dictionary.getTagFromName("ScheduledStudyLocationAETitle"));
        attributeList.remove(dictionary.getTagFromName("ScheduledStationAETitle"));
        attributeList.remove(dictionary.getTagFromName("PerformedStationAETitle"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("SelectorAEValue"), "REMOVED");
        attributeList.remove(dictionary.getTagFromName("ReceivingAE"));
        attributeList.remove(dictionary.getTagFromName("RequestingAE"));
        attributeList.remove(dictionary.getTagFromName("Originator"));
        attributeList.replaceWithValueIfPresent(dictionary.getTagFromName("DestinationAE"), "REMOVED");
        if (!bl5) {
            attributeList.remove(dictionary.getTagFromName("DateOfInstallation"));
            attributeList.remove(dictionary.getTagFromName("DateOfManufacture"));
        }
        attributeList.remove(dictionary.getTagFromName("ROICreatorSequence"));
        attributeList.remove(dictionary.getTagFromName("ROIInterpreterSequence"));
        for (Object e : attributeList.values()) {
            Iterator<SequenceItem> iterator;
            if (!(e instanceof SequenceAttribute) || (attribute = (SequenceAttribute)e).getTag().equals(dictionary.getTagFromName("ContentSequence")) || (iterator = ((SequenceAttribute)attribute).iterator()) == null) continue;
            while (iterator.hasNext()) {
                AttributeList attributeList2;
                SequenceItem sequenceItem = iterator.next();
                if (sequenceItem == null || (attributeList2 = sequenceItem.getAttributeList()) == null) continue;
                ClinicalTrialsAttributes.removeOrNullIdentifyingAttributesRecursively(attributeList2, n, bl, bl2, bl3, bl4, bl5, bl6, bl7);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.err.println("do it buffered, looking for metaheader, no uid specified");
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0]);
            System.err.println("As read ...");
            System.err.print(attributeList.toString());
            attributeList.removeUnsafePrivateAttributes();
            System.err.println("After remove unsafe private ...");
            System.err.print(attributeList.toString());
            attributeList.removePrivateAttributes();
            System.err.println("After remove private ...");
            System.err.print(attributeList.toString());
            attributeList.removeGroupLengthAttributes();
            System.err.println("After remove group lengths ...");
            System.err.print(attributeList.toString());
            attributeList.removeMetaInformationHeaderAttributes();
            System.err.println("After remove meta information header ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, true);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and device identity and institution identity and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, true, false);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and device identity and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, true, true, true, false, false);
            System.err.println("After deidentify, keeping descriptions and patient characteristics and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, true, true, false, false);
            System.err.println("After deidentify, keeping patient characteristics and series description and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, true, false, false);
            System.err.println("After deidentify, keeping patient characteristics and UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, false, false, false, false, false);
            System.err.println("After deidentify, keeping only UIDs ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false);
            System.err.println("After deidentify, remapping UIDs ...");
            System.err.print(attributeList.toString());
            Date date = null;
            String[] stringArray2 = new GregorianCalendar(2000, 0, 1);
            stringArray2.setTimeZone(TimeZone.getTimeZone("GMT"));
            date = stringArray2.getTime();
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 2, false, false, false, false, false, 2, date, null);
            System.err.println("After deidentify, modifying dates and times ...");
            System.err.print(attributeList.toString());
            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 1, false, false, false, false, false, 1, null, null);
            System.err.println("After deidentify, removing everything ...");
            System.err.print(attributeList.toString());
            stringArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("StudyID"));
            CodedSequenceItem[] codedSequenceItemArray = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("SeriesNumber"));
            CodedSequenceItem[] codedSequenceItemArray2 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("InstanceNumber"));
            String[] stringArray3 = new UIDGenerator();
            PersonIdentification[] personIdentificationArray = new UniqueIdentifierAttribute(dictionary.getTagFromName("SOPInstanceUID"));
            personIdentificationArray.addValue(stringArray3.getNewSOPInstanceUID((String)stringArray2, (String)codedSequenceItemArray, (String)codedSequenceItemArray2));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(dictionary.getTagFromName("SeriesInstanceUID"));
            personIdentificationArray.addValue(stringArray3.getNewSeriesInstanceUID((String)stringArray2, (String)codedSequenceItemArray));
            attributeList.put((Attribute)personIdentificationArray);
            personIdentificationArray = new UniqueIdentifierAttribute(dictionary.getTagFromName("StudyInstanceUID"));
            personIdentificationArray.addValue(stringArray3.getNewStudyInstanceUID((String)stringArray2));
            attributeList.put((Attribute)personIdentificationArray);
            ClinicalTrialsAttributes.addClinicalTrialsAttributes(attributeList, true, "ourSponsorName", "ourProtocolID", "ourProtocolName", "ourSiteID", "ourSiteName", "ourSubjectID", "ourSubjectReadingID", "ourTimePointID", "ourTimePointDescription", "ourCoordinatingCenterName");
            System.err.println("After addClinicalTrialsAttributes ...");
            System.err.print(attributeList.toString());
            stringArray2 = new String[]{"smithj", "doej"};
            codedSequenceItemArray = new CodedSequenceItem[]{new CodedSequenceItem("634872364", "99MYH", "Smith^John")};
            codedSequenceItemArray2 = new CodedSequenceItem[]{new CodedSequenceItem("346234622", "99MYH", "Doe^Jane")};
            stringArray3 = new String[]{"555-1212"};
            personIdentificationArray = new PersonIdentification[]{new PersonIdentification(codedSequenceItemArray, "John address", stringArray3, null, "My hospital address", new CodedSequenceItem("47327864", "99MYH", "My Hospital")), new PersonIdentification(codedSequenceItemArray2, "Jane address", stringArray3, "My hospital", "My hospital address", null)};
            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", "PixelMed", "Software Development", "Bangor, PA", null, "com.pixelmed.dicom.ClinicalTrialsAttributes.main()", null, "Vers. 20080429", "Deidentified", DateTimeAttribute.getFormattedStringDefaultTimeZone(new Date()), stringArray2, personIdentificationArray);
            System.err.println("After addContributingEquipmentSequence ...");
            System.err.print(attributeList.toString());
            attributeList.remove(dictionary.getTagFromName("DataSetTrailingPadding"));
            attributeList.correctDecompressedImagePixelModule();
            FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
            attributeList.write(stringArray[1], "1.2.840.10008.1.2.1", true, true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public class HandleStructuredContent {
        public static final int keep = 0;
        public static final int remove = 1;
        public static final int modify = 2;
    }

    public class HandleDates {
        public static final int keep = 0;
        public static final int remove = 1;
        public static final int modify = 2;
    }

    public class HandleUIDs {
        public static final int keep = 0;
        public static final int remove = 1;
        public static final int remap = 2;
    }
}

