/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public abstract class ContentItem
implements TreeNode {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ContentItem.java,v 1.37 2025/01/29 10:58:06 dclunie Exp $";
    protected String relationshipType;
    protected String observationDateTime;
    protected String observationUID;
    ContentItem parent;
    List children;
    AttributeList list;

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (TreeNode)this.children.get(n);
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        int n = this.children.size();
        for (int i = 0; i < n; ++i) {
            if (!this.children.get(i).equals(treeNode)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public Enumeration children() {
        return this.children == null ? null : new Vector(this.children).elements();
    }

    private void extractContentItemCommonAttributes() {
        this.relationshipType = Attribute.getSingleStringValueOrNull(this.list, TagFromName.RelationshipType);
        this.observationDateTime = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ObservationDateTime);
        this.observationUID = Attribute.getSingleStringValueOrNull(this.list, TagFromName.ObservationUID);
    }

    protected ContentItem(ContentItem contentItem, AttributeList attributeList) {
        this.parent = contentItem;
        if (contentItem != null) {
            contentItem.addChild(this);
        }
        this.list = attributeList;
        this.extractContentItemCommonAttributes();
    }

    protected ContentItem(ContentItem contentItem, String string, String string2, String string3) throws DicomException {
        StringAttribute stringAttribute;
        this.parent = contentItem;
        if (contentItem != null) {
            contentItem.addChild(this);
        }
        this.list = new AttributeList();
        this.relationshipType = string;
        if (string != null && string.length() > 0) {
            stringAttribute = new CodeStringAttribute(TagFromName.RelationshipType);
            ((Attribute)stringAttribute).addValue(string);
            this.list.put(stringAttribute);
        }
        this.observationDateTime = string2;
        if (string2 != null && string2.length() > 0) {
            stringAttribute = new DateTimeAttribute(TagFromName.ObservationDateTime);
            ((Attribute)stringAttribute).addValue(string2);
            this.list.put(stringAttribute);
        }
        this.observationUID = string3;
        if (string3 != null && string3.length() > 0) {
            stringAttribute = new UniqueIdentifierAttribute(TagFromName.ObservationUID);
            ((Attribute)stringAttribute).addValue(string3);
            this.list.put(stringAttribute);
        }
    }

    protected ContentItem(ContentItem contentItem, String string) throws DicomException {
        this(contentItem, string, null, null);
    }

    public void addChild(ContentItem contentItem) {
        if (this.children == null) {
            this.children = new LinkedList();
        }
        this.children.add(contentItem);
    }

    public void addSibling(ContentItem contentItem) throws DicomException {
        if (this.parent == null) {
            throw new DicomException("Internal error - root node with sibling");
        }
        this.parent.addChild(contentItem);
    }

    public ContentItem getParentAsContentItem() {
        return this.parent;
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public String getValueType() {
        return null;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public String getObservationUID() {
        return this.observationUID;
    }

    public String getObservationDateTime() {
        return this.observationDateTime;
    }

    public String getReferencedSOPClassUID() {
        return null;
    }

    public String getReferencedSOPInstanceUID() {
        return null;
    }

    public String getGraphicType() {
        return null;
    }

    public float[] getGraphicData() {
        return null;
    }

    public String getConceptNameAndValue() {
        return null;
    }

    public abstract String getConceptValue();

    public CodedSequenceItem getConceptName() {
        return null;
    }

    public String getConceptNameCodeMeaning() {
        return null;
    }

    public String getConceptNameCodeValue() {
        return null;
    }

    public String getConceptNameCodingSchemeDesignator() {
        return null;
    }

    public String getReferencedContentItemIdentifier() {
        return null;
    }

    public int[] getReferencedContentItemIdentifierArray() {
        return null;
    }

    public static String walkTreeBuldingString(ContentItem contentItem, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(contentItem.toString());
        stringBuffer.append("\n");
        int n = contentItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(ContentItem.walkTreeBuldingString((ContentItem)contentItem.getChildAt(i), string + "." + Integer.toString(i + 1)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return ContentItem.walkTreeBuldingString(this, "1");
    }

    public String getPositionInTreeToUseAsReferencedContentItemIdentifier() {
        String string = "1";
        if (this.parent != null) {
            int n = this.parent.getIndex(this) + 1;
            string = this.parent.getPositionInTreeToUseAsReferencedContentItemIdentifier() + "." + n;
        }
        return string;
    }

    public ContentItem getNamedChild(String string, String string2) {
        ContentItem contentItem = null;
        if (string != null && string2 != null) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)this.getChildAt(i);
                if (contentItem2 == null) continue;
                String string3 = contentItem2.getConceptNameCodingSchemeDesignator();
                String string4 = contentItem2.getConceptNameCodeValue();
                if (string3 == null || !string3.equals(string) || string4 == null || !string4.equals(string2)) continue;
                contentItem = contentItem2;
                break;
            }
        }
        return contentItem;
    }

    public ContentItem getNamedChild(CodedSequenceItem codedSequenceItem) {
        String string = codedSequenceItem.getCodingSchemeDesignator();
        String string2 = codedSequenceItem.getCodeValue();
        ContentItem contentItem = null;
        if (string != null && string2 != null) {
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)this.getChildAt(i);
                if (contentItem2 == null) continue;
                String string3 = contentItem2.getConceptNameCodingSchemeDesignator();
                String string4 = contentItem2.getConceptNameCodeValue();
                if (string3 == null || !string3.equals(string) || string4 == null || !string4.equals(string2)) continue;
                contentItem = contentItem2;
                break;
            }
        }
        return contentItem;
    }

    public String getSingleStringValueOrNull() {
        String string = null;
        if (this instanceof ContentItemFactory.StringContentItem) {
            string = ((ContentItemFactory.StringContentItem)this).getConceptValue();
        } else if (this instanceof ContentItemFactory.CodeContentItem) {
            string = ((ContentItemFactory.CodeContentItem)this).getConceptValue();
        } else if (this instanceof ContentItemFactory.NumericContentItem) {
            string = ((ContentItemFactory.NumericContentItem)this).getNumericValue();
        }
        return string;
    }

    public String getSingleStringValueOrNullOfNamedChild(String string, String string2) {
        String string3 = null;
        ContentItem contentItem = this.getNamedChild(string, string2);
        if (contentItem != null) {
            string3 = contentItem.getSingleStringValueOrNull();
        }
        return string3;
    }

    public static String getSingleStringValueOrNullOfNamedChild(ContentItem contentItem, String string, String string2) {
        String string3 = null;
        if (contentItem != null) {
            string3 = contentItem.getSingleStringValueOrNullOfNamedChild(string, string2);
        }
        return string3;
    }

    public abstract boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(String var1, String var2);

    public static boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(ContentItem contentItem, String string, String string2) {
        boolean bl = false;
        if (contentItem != null) {
            bl = contentItem.contentItemNameMatchesCodeValueAndCodingSchemeDesignator(string, string2);
        }
        return bl;
    }
}

