/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UnsignedLongAttribute;

public class ContentItemWithReference
extends ContentItem {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ContentItemWithReference.java,v 1.12 2025/01/29 10:58:06 dclunie Exp $";
    protected String referencedContentItemIdentifier;

    private void extractContentItemWithReferenceCommonAttributes() {
        this.referencedContentItemIdentifier = Attribute.getDelimitedStringValuesOrEmptyString(this.list, TagFromName.ReferencedContentItemIdentifier).replace('\\', '.');
    }

    protected ContentItemWithReference(ContentItem contentItem, AttributeList attributeList) {
        super(contentItem, attributeList);
        this.extractContentItemWithReferenceCommonAttributes();
    }

    public ContentItemWithReference(ContentItem contentItem, String string, String string2) throws DicomException {
        super(contentItem, string);
        this.referencedContentItemIdentifier = string2;
        if (string2 != null && string2.length() > 0) {
            int[] nArray;
            UnsignedLongAttribute unsignedLongAttribute = new UnsignedLongAttribute(TagFromName.ReferencedContentItemIdentifier);
            this.list.put(unsignedLongAttribute);
            for (int n : nArray = this.getReferencedContentItemIdentifierArray()) {
                ((Attribute)unsignedLongAttribute).addValue(n);
            }
        }
    }

    @Override
    public String getConceptValue() {
        return "";
    }

    @Override
    public String getReferencedContentItemIdentifier() {
        return this.referencedContentItemIdentifier == null ? "" : this.referencedContentItemIdentifier;
    }

    @Override
    public int[] getReferencedContentItemIdentifierArray() {
        String[] stringArray;
        int[] nArray = null;
        if (this.referencedContentItemIdentifier != null && this.referencedContentItemIdentifier.length() > 0 && (stringArray = this.referencedContentItemIdentifier.split("[.]")) != null && stringArray.length > 0) {
            nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                nArray[i] = Integer.parseInt(stringArray[i]);
            }
        }
        return nArray;
    }

    @Override
    public String toString() {
        return (this.referencedContentItemIdentifier == null || this.referencedContentItemIdentifier.length() == 0 ? "" : "R-") + (this.relationshipType == null ? "" : this.relationshipType) + ": " + (this.referencedContentItemIdentifier == null || this.referencedContentItemIdentifier.length() == 0 ? "" : this.referencedContentItemIdentifier);
    }

    @Override
    public boolean contentItemNameMatchesCodeValueAndCodingSchemeDesignator(String string, String string2) {
        return false;
    }
}

