/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfSliceFromAttributeList;
import com.pixelmed.dicom.HierarchicalImageReference;
import com.pixelmed.dicom.HierarchicalSOPInstanceReference;
import com.pixelmed.dicom.ImageLibrary;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.geometry.GeometryOfSlice;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Tuple3d;

public class CrossSectionalImageLibrary
extends ImageLibrary {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CrossSectionalImageLibrary.java,v 1.17 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageLibrary.class);

    @Override
    public ImageLibrary.ImageLibraryEntry makeImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
        return new CrossSectionalImageLibraryEntry(imageContentItem, map);
    }

    @Override
    public ImageLibrary.ImageLibraryEntry makeImageLibraryEntry(AttributeList attributeList) throws DicomException {
        return new CrossSectionalImageLibraryEntry(attributeList);
    }

    public String getSOPClassUID(String string) {
        String string2 = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && crossSectionalImageLibraryEntry.hierarchicalImageReference != null) {
            string2 = crossSectionalImageLibraryEntry.hierarchicalImageReference.sopClassUID;
        }
        return string2;
    }

    public String getFrameOfReferenceUID(String string) {
        String string2 = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null) {
            string2 = crossSectionalImageLibraryEntry.frameOfReferenceUID;
        }
        return string2;
    }

    public double[] getVoxelSpacingArray(String string) {
        GeometryOfSlice geometryOfSlice;
        double[] dArray = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && (geometryOfSlice = crossSectionalImageLibraryEntry.geometry) != null) {
            dArray = geometryOfSlice.getVoxelSpacingArray();
        }
        return dArray;
    }

    public double[] getTLHCArray(String string) {
        GeometryOfSlice geometryOfSlice;
        double[] dArray = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && (geometryOfSlice = crossSectionalImageLibraryEntry.geometry) != null) {
            dArray = geometryOfSlice.getTLHCArray();
        }
        return dArray;
    }

    public double[] getRowArray(String string) {
        GeometryOfSlice geometryOfSlice;
        double[] dArray = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && (geometryOfSlice = crossSectionalImageLibraryEntry.geometry) != null) {
            dArray = geometryOfSlice.getRowArray();
        }
        return dArray;
    }

    public double[] getColumnArray(String string) {
        GeometryOfSlice geometryOfSlice;
        double[] dArray = null;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && (geometryOfSlice = crossSectionalImageLibraryEntry.geometry) != null) {
            dArray = geometryOfSlice.getColumnArray();
        }
        return dArray;
    }

    public double getSliceThickness(String string) {
        GeometryOfSlice geometryOfSlice;
        double d = 0.0;
        CrossSectionalImageLibraryEntry crossSectionalImageLibraryEntry = (CrossSectionalImageLibraryEntry)this.entriesIndexedBySOPInstanceUID.get(string);
        if (crossSectionalImageLibraryEntry != null && (geometryOfSlice = crossSectionalImageLibraryEntry.geometry) != null) {
            d = geometryOfSlice.getSliceThickness();
        }
        return d;
    }

    public static final double parseDoubleElseZero(String string) {
        double d = 0.0;
        if (string != null && string.length() > 0) {
            try {
                d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public CrossSectionalImageLibrary() {
    }

    public CrossSectionalImageLibrary(AttributeList attributeList) throws DicomException {
        StructuredReport structuredReport = new StructuredReport(attributeList);
        ContentItem contentItem = CrossSectionalImageLibrary.findImageLibraryContainer((ContentItem)structuredReport.getRoot());
        if (contentItem == null) {
            throw new DicomException("No Image Library CONTAINER content item in SR");
        }
        this.constructImageLibrary(contentItem, attributeList);
    }

    public CrossSectionalImageLibrary(ContentItem contentItem, AttributeList attributeList) {
        this.constructImageLibrary(contentItem, attributeList);
    }

    public static CrossSectionalImageLibrary read(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        return new CrossSectionalImageLibrary(attributeList);
    }

    public CrossSectionalImageLibrary(Set<File> set) throws IOException, DicomException {
        super(set);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            HashSet<File> hashSet = new HashSet<File>();
            for (int i = 1; i < stringArray.length; ++i) {
                ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(stringArray[i]));
                hashSet.addAll(arrayList);
            }
            CrossSectionalImageLibrary crossSectionalImageLibrary = new CrossSectionalImageLibrary(hashSet);
            crossSectionalImageLibrary.write(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static class CrossSectionalImageLibraryEntry
    extends ImageLibrary.ImageLibraryEntry {
        protected String frameOfReferenceUID;
        protected GeometryOfSlice geometry;

        public CrossSectionalImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
            String string = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111026");
            String string2 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111066");
            String string3 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "112225");
            String string4 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "112227");
            String string5 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110901");
            String string6 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110902");
            String string7 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110903");
            String string8 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110904");
            String string9 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110905");
            String string10 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110906");
            String string11 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110907");
            String string12 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110908");
            String string13 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110909");
            String string14 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110910");
            String string15 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "110911");
            if (string5 == null) {
                string5 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250001");
            }
            if (string6 == null) {
                string6 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250002");
            }
            if (string7 == null) {
                string7 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250003");
            }
            if (string8 == null) {
                string8 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250004");
            }
            if (string9 == null) {
                string9 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250005");
            }
            if (string10 == null) {
                string10 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250006");
            }
            if (string11 == null) {
                string11 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250007");
            }
            if (string12 == null) {
                string12 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250008");
            }
            if (string13 == null) {
                string13 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250009");
            }
            if (string14 == null) {
                string14 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250010");
            }
            if (string15 == null) {
                string15 = imageContentItem.getSingleStringValueOrNullOfNamedChild("99PMP", "250011");
            }
            double[] dArray = new double[]{CrossSectionalImageLibrary.parseDoubleElseZero(string5), CrossSectionalImageLibrary.parseDoubleElseZero(string6), CrossSectionalImageLibrary.parseDoubleElseZero(string7)};
            double[] dArray2 = new double[]{CrossSectionalImageLibrary.parseDoubleElseZero(string8), CrossSectionalImageLibrary.parseDoubleElseZero(string9), CrossSectionalImageLibrary.parseDoubleElseZero(string10)};
            double[] dArray3 = new double[]{CrossSectionalImageLibrary.parseDoubleElseZero(string11), CrossSectionalImageLibrary.parseDoubleElseZero(string12), CrossSectionalImageLibrary.parseDoubleElseZero(string13)};
            double[] dArray4 = new double[]{CrossSectionalImageLibrary.parseDoubleElseZero(string2), CrossSectionalImageLibrary.parseDoubleElseZero(string), 0.0};
            double[] dArray5 = new double[]{CrossSectionalImageLibrary.parseDoubleElseZero(string14), CrossSectionalImageLibrary.parseDoubleElseZero(string15), 1.0};
            GeometryOfSlice geometryOfSlice = new GeometryOfSlice(dArray2, dArray3, dArray, dArray4, CrossSectionalImageLibrary.parseDoubleElseZero(string3), dArray5);
            String string16 = imageContentItem.getReferencedSOPInstanceUID();
            String string17 = imageContentItem.getReferencedSOPClassUID();
            HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = map.get(string16);
            HierarchicalImageReference hierarchicalImageReference = null;
            hierarchicalImageReference = hierarchicalSOPInstanceReference == null ? new HierarchicalImageReference(null, null, string16, string17) : new HierarchicalImageReference(hierarchicalSOPInstanceReference);
            this.constructCrossSectionalImageLibraryEntry(hierarchicalImageReference, string4, geometryOfSlice);
        }

        public CrossSectionalImageLibraryEntry(AttributeList attributeList) throws DicomException {
            String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID);
            GeometryOfSliceFromAttributeList geometryOfSliceFromAttributeList = new GeometryOfSliceFromAttributeList(attributeList);
            if (string5.length() > 0 && string.length() > 0 && string2.length() > 0 && string3.length() > 0 && string4.length() > 0) {
                HierarchicalImageReference hierarchicalImageReference = new HierarchicalImageReference(string, string2, string3, string4);
                this.constructCrossSectionalImageLibraryEntry(hierarchicalImageReference, string5, geometryOfSliceFromAttributeList);
            }
        }

        public CrossSectionalImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference, String string, GeometryOfSlice geometryOfSlice) {
            this.constructCrossSectionalImageLibraryEntry(hierarchicalImageReference, string, geometryOfSlice);
        }

        protected void constructCrossSectionalImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference, String string, GeometryOfSlice geometryOfSlice) {
            super.constructImageLibraryEntry(hierarchicalImageReference);
            this.frameOfReferenceUID = string;
            this.geometry = geometryOfSlice;
        }

        @Override
        public ContentItem getImageContentItem(ContentItemFactory contentItemFactory, ContentItem contentItem) throws DicomException {
            double[] dArray;
            ContentItemFactory contentItemFactory2 = contentItemFactory;
            contentItemFactory2.getClass();
            ContentItemFactory.ImageContentItem imageContentItem = contentItemFactory2.new ContentItemFactory.ImageContentItem(contentItem, "CONTAINS", null, this.hierarchicalImageReference.getSOPClassUID(), this.hierarchicalImageReference.getSOPInstanceUID(), 0, 0, null, null, null, null);
            if (this.geometry != null) {
                dArray = this.geometry.getVoxelSpacingArray();
                if (dArray != null && dArray.length == 3) {
                    ContentItemFactory contentItemFactory3 = contentItemFactory;
                    contentItemFactory3.getClass();
                    contentItemFactory3.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111026", "DCM", "Horizontal Pixel Spacing"), dArray[1], new CodedSequenceItem("mm", "UCUM", "millimeter"));
                    ContentItemFactory contentItemFactory4 = contentItemFactory;
                    contentItemFactory4.getClass();
                    contentItemFactory4.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111066", "DCM", "Vertical Pixel Spacing"), dArray[0], new CodedSequenceItem("mm", "UCUM", "millimeter"));
                }
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                contentItemFactory5.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("112225", "DCM", "Slice Thickness"), this.geometry.getSliceThickness(), new CodedSequenceItem("mm", "UCUM", "millimeter"));
            }
            if (this.frameOfReferenceUID != null && this.frameOfReferenceUID.trim().length() > 0) {
                ContentItemFactory contentItemFactory6 = contentItemFactory;
                contentItemFactory6.getClass();
                contentItemFactory6.new ContentItemFactory.UIDContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("112227", "DCM", "Frame of Reference UID"), this.frameOfReferenceUID);
            }
            if (this.geometry != null) {
                Tuple3d tuple3d;
                double[] dArray2;
                double[] dArray3;
                dArray = this.geometry.getTLHCArray();
                if (dArray != null && dArray.length == 3) {
                    ContentItemFactory contentItemFactory7 = contentItemFactory;
                    contentItemFactory7.getClass();
                    contentItemFactory7.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110901", "DCM", "Image Position (Patient) X"), dArray[0], new CodedSequenceItem("mm", "UCUM", "millimeter"));
                    ContentItemFactory contentItemFactory8 = contentItemFactory;
                    contentItemFactory8.getClass();
                    contentItemFactory8.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110902", "DCM", "Image Position (Patient) Y"), dArray[1], new CodedSequenceItem("mm", "UCUM", "millimeter"));
                    ContentItemFactory contentItemFactory9 = contentItemFactory;
                    contentItemFactory9.getClass();
                    contentItemFactory9.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110903", "DCM", "Image Position (Patient) Z"), dArray[2], new CodedSequenceItem("mm", "UCUM", "millimeter"));
                }
                if ((dArray3 = this.geometry.getRowArray()) != null && dArray3.length == 3) {
                    ContentItemFactory contentItemFactory10 = contentItemFactory;
                    contentItemFactory10.getClass();
                    contentItemFactory10.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110904", "DCM", "Image Orientation (Patient) Row X"), dArray3[0], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                    ContentItemFactory contentItemFactory11 = contentItemFactory;
                    contentItemFactory11.getClass();
                    contentItemFactory11.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110905", "DCM", "Image Orientation (Patient) Row Y"), dArray3[1], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                    ContentItemFactory contentItemFactory12 = contentItemFactory;
                    contentItemFactory12.getClass();
                    contentItemFactory12.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110906", "DCM", "Image Orientation (Patient) Row Z"), dArray3[2], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                }
                if ((dArray2 = this.geometry.getColumnArray()) != null && dArray2.length == 3) {
                    ContentItemFactory contentItemFactory13 = contentItemFactory;
                    contentItemFactory13.getClass();
                    contentItemFactory13.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110907", "DCM", "Image Orientation (Patient) Column X"), dArray2[0], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                    ContentItemFactory contentItemFactory14 = contentItemFactory;
                    contentItemFactory14.getClass();
                    contentItemFactory14.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110908", "DCM", "Image Orientation (Patient) Column Y"), dArray2[1], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                    ContentItemFactory contentItemFactory15 = contentItemFactory;
                    contentItemFactory15.getClass();
                    contentItemFactory15.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110909", "DCM", "Image Orientation (Patient) Column Z"), dArray2[2], new CodedSequenceItem("{-1:1}", "UCUM", "{-1:1}"));
                }
                if ((tuple3d = this.geometry.getDimensions()) != null) {
                    double[] dArray4 = new double[3];
                    tuple3d.get(dArray4);
                    ContentItemFactory contentItemFactory16 = contentItemFactory;
                    contentItemFactory16.getClass();
                    contentItemFactory16.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110910", "DCM", "Pixel Data Rows"), (int)dArray4[0], new CodedSequenceItem("{pixels}", "UCUM", "pixels"));
                    ContentItemFactory contentItemFactory17 = contentItemFactory;
                    contentItemFactory17.getClass();
                    contentItemFactory17.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("110911", "DCM", "Pixel Data Columns"), (int)dArray4[1], new CodedSequenceItem("{pixels}", "UCUM", "pixels"));
                }
            }
            return imageContentItem;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Entry:\n");
            stringBuffer.append(this.hierarchicalImageReference);
            stringBuffer.append("\n");
            stringBuffer.append("Frame of Reference UID = ");
            stringBuffer.append(this.frameOfReferenceUID);
            stringBuffer.append("\n");
            stringBuffer.append(this.geometry);
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }
    }
}

