/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionaryBase;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DicomDictionary
extends DicomDictionaryBase {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomDictionary.java,v 1.168 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomDictionary.class);
    protected String xmlDicomDictionaryResourceName = "/com/pixelmed/dicom/elmdict.xml";
    protected String xmlDicomDictionaryIEResourceName = "/com/pixelmed/dicom/elmdictie.xml";
    public static final DicomDictionary StandardDictionary = new DicomDictionary();

    private Document readXMLDicomDictionary() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = DicomDictionary.class.getResourceAsStream(this.xmlDicomDictionaryResourceName);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    private Document readXMLDicomDictionaryInformationEntity() throws IOException, ParserConfigurationException, SAXException {
        InputStream inputStream = DicomDictionary.class.getResourceAsStream(this.xmlDicomDictionaryIEResourceName);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    public DicomDictionary() {
        Object object;
        Object object2;
        Object object3;
        String string;
        String string2;
        Node node;
        Element element;
        Document document;
        boolean bl = !this.tagList.isEmpty();
        try {
            document = this.readXMLDicomDictionary();
            element = document.getDocumentElement();
            if (!element.getNodeName().equals("DataDictionary")) {
                throw new DicomException("Missing DataDictionary root element in " + this.xmlDicomDictionaryResourceName);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!node.getNodeName().equals("DataElement")) continue;
                string2 = null;
                string = null;
                object3 = null;
                object2 = null;
                object = null;
                String string3 = null;
                String string4 = null;
                for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (node2.getNodeName().equals("Group")) {
                        string2 = node2.getTextContent().trim();
                        continue;
                    }
                    if (node2.getNodeName().equals("Element")) {
                        string = node2.getTextContent().trim();
                        continue;
                    }
                    if (node2.getNodeName().equals("VR")) {
                        object3 = node2.getTextContent().trim();
                        continue;
                    }
                    if (node2.getNodeName().equals("VMMin")) {
                        object2 = node2.getTextContent().trim();
                        continue;
                    }
                    if (node2.getNodeName().equals("VMMax")) {
                        object = node2.getTextContent().trim();
                        continue;
                    }
                    if (node2.getNodeName().equals("Keyword")) {
                        string3 = node2.getTextContent().trim();
                        continue;
                    }
                    if (!node2.getNodeName().equals("Name")) continue;
                    string4 = node2.getTextContent().trim();
                }
                int n = Integer.parseInt(string2.substring(2).replace('x', '0'), 16);
                int n2 = Integer.parseInt(string.substring(2).replace('x', '0'), 16);
                AttributeTag attributeTag = new AttributeTag(n, n2);
                if (bl && !this.tagList.contains(attributeTag)) continue;
                if (!bl) {
                    this.tagList.add(attributeTag);
                }
                this.valueRepresentationsByTag.put(attributeTag, ValueRepresentation.getValueRepresentationFromString((String)object3));
                this.tagByName.put(string3, attributeTag);
                this.nameByTag.put(attributeTag, string3);
                this.fullNameByTag.put(attributeTag, string4);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Unable to construct DicomDictionary ", exception);
        }
        try {
            document = this.readXMLDicomDictionaryInformationEntity();
            element = document.getDocumentElement();
            if (!element.getNodeName().equals("DataDictionaryIE")) {
                throw new DicomException("Missing DataDictionaryIE root element in " + this.xmlDicomDictionaryIEResourceName);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!node.getNodeName().equals("DataElementIE")) continue;
                string2 = null;
                string = null;
                for (object3 = node.getFirstChild(); object3 != null; object3 = object3.getNextSibling()) {
                    if (object3.getNodeName().equals("Name")) {
                        string2 = object3.getTextContent().trim();
                        continue;
                    }
                    if (!object3.getNodeName().equals("IE")) continue;
                    string = object3.getTextContent().trim();
                }
                object2 = (AttributeTag)this.tagByName.get(string2);
                if (object2 == null) {
                    if (bl) {
                        slf4jlogger.debug("Unrecognized keyword DataDictionaryIE.DataElementIE.Name {} - ignoring", string2);
                        continue;
                    }
                    slf4jlogger.error("Unrecognized keyword DataDictionaryIE.DataElementIE.Name {} - ignoring", string2);
                    continue;
                }
                object = InformationEntity.fromString(string);
                if (object == null) {
                    if (bl) {
                        slf4jlogger.debug("Unrecognized keyword DataDictionaryIE.DataElementIE.IE {} for keyword {} - ignoring", string, string2);
                        continue;
                    }
                    slf4jlogger.error("Unrecognized keyword DataDictionaryIE.DataElementIE.IE {} for keyword {} - ignoring", string, string2);
                    continue;
                }
                this.informationEntityByTag.put(object2, object);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Unable to construct DicomDictionary InformationEntity ", exception);
        }
    }

    @Override
    protected void createTagList() {
        slf4jlogger.debug("createTagList():");
        this.tagList = new TreeSet();
    }

    @Override
    protected void createValueRepresentationsByTag() {
        this.valueRepresentationsByTag = new HashMap(100);
    }

    @Override
    protected void createInformationEntityByTag() {
        this.informationEntityByTag = new HashMap(100);
    }

    @Override
    protected void createTagByName() {
        this.tagByName = new HashMap(100);
    }

    @Override
    protected void createNameByTag() {
        this.nameByTag = new HashMap(100);
    }

    @Override
    protected void createFullNameByTag() {
        this.fullNameByTag = new HashMap(100);
    }
}

