/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ApplicationEntityAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedLongAttribute;
import com.pixelmed.utils.HexDump;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class FileMetaInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FileMetaInformation.java,v 1.23 2025/01/29 10:58:06 dclunie Exp $";
    private static final AttributeTag groupLengthTag = new AttributeTag(2, 0);
    private AttributeList list = new AttributeList();

    public FileMetaInformation(String string, String string2, String string3, String string4) throws DicomException {
        FileMetaInformation.addFileMetaInformation(this.list, string, string2, string3, string4);
    }

    public static void addFileMetaInformation(AttributeList attributeList, String string, String string2, String string3, String string4) throws DicomException {
        int n = 0;
        int n2 = 8;
        int n3 = 12;
        AttributeTag attributeTag = TagFromName.FileMetaInformationVersion;
        Attribute attribute = new OtherByteAttribute(attributeTag);
        byte[] byArray = new byte[]{0, 1};
        attribute.setValues(byArray);
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n3;
        if (string == null || string.trim().length() == 0) {
            throw new DicomException("Cannot add FileMetaInformation without MediaStorageSOPClassUID value");
        }
        attributeTag = TagFromName.MediaStorageSOPClassUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attribute.addValue(string);
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n2;
        if (string2 == null || string2.trim().length() == 0) {
            throw new DicomException("Cannot add FileMetaInformation without MediaStorageSOPInstanceUID value");
        }
        attributeTag = TagFromName.MediaStorageSOPInstanceUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attribute.addValue(string2);
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n2;
        if (string3 == null || string3.trim().length() == 0) {
            throw new DicomException("Cannot add FileMetaInformation without TransferSyntaxUID value");
        }
        attributeTag = TagFromName.TransferSyntaxUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attribute.addValue(string3);
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n2;
        attributeTag = TagFromName.ImplementationClassUID;
        attribute = new UniqueIdentifierAttribute(attributeTag);
        attribute.addValue("1.3.6.1.4.1.5962.99.2");
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n2;
        attributeTag = TagFromName.ImplementationVersionName;
        attribute = new ShortStringAttribute(attributeTag, null);
        attribute.addValue("PIXELMEDJAVA001");
        attributeList.put(attributeTag, attribute);
        n = (int)((long)n + attribute.getPaddedVL());
        n += n2;
        if (string4 != null && string4.length() > 0) {
            attributeTag = TagFromName.SourceApplicationEntityTitle;
            attribute = new ApplicationEntityAttribute(attributeTag);
            attribute.addValue(string4);
            attributeList.put(attributeTag, attribute);
            n = (int)((long)n + attribute.getPaddedVL());
            n += n2;
        }
        attributeTag = groupLengthTag;
        attribute = new UnsignedLongAttribute(attributeTag);
        attribute.addValue(n);
        attributeList.put(attributeTag, attribute);
    }

    public static void addFileMetaInformation(AttributeList attributeList, String string, String string2) throws DicomException {
        String string3 = null;
        Attribute attribute = attributeList.get(TagFromName.SOPClassUID);
        if (attribute != null) {
            string3 = attribute.getSingleStringValueOrNull();
        }
        String string4 = null;
        Attribute attribute2 = attributeList.get(TagFromName.SOPInstanceUID);
        if (attribute2 != null) {
            string4 = attribute2.getSingleStringValueOrNull();
        }
        if (string3 == null && string4 == null && attributeList.get(TagFromName.DirectoryRecordSequence) != null) {
            string3 = "1.2.840.10008.1.3.10";
            string4 = new UIDGenerator().getNewUID();
        }
        if (string3 == null) {
            throw new DicomException("Could not add File Meta Information - missing or empty SOPClassUID and not a DICOMDIR");
        }
        if (string4 == null) {
            throw new DicomException("Could not add File Meta Information - missing or empty SOPInstanceUID and not a DICOMDIR");
        }
        FileMetaInformation.addFileMetaInformation(attributeList, string3, string4, string, string2);
    }

    public AttributeList getAttributeList() {
        return this.list;
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new FileMetaInformation("1.2.3.44", "1.2", "1.2.840.10008.1.2", "MYAE").getAttributeList();
            System.err.println("As constructed:");
            System.err.print(attributeList);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            attributeList.write(new DicomOutputStream(byteArrayOutputStream, "1.2.840.10008.1.2.1", null));
            byte[] byArray = byteArrayOutputStream.toByteArray();
            System.err.print(HexDump.dump(byArray));
            AttributeList attributeList2 = new AttributeList();
            attributeList2.read(new DicomInputStream(new ByteArrayInputStream(byArray), "1.2.840.10008.1.2.1", true));
            System.err.println("As read:");
            System.err.print(attributeList2);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

