/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DecimalStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FloatDoubleAttribute;
import com.pixelmed.dicom.FloatSingleAttribute;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FrameSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FrameSet.java,v 1.34 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(FrameSet.class);
    private AttributeList distinguishingAttributes;
    private Map<String, AttributeList> perFrameAttributesIndexedBySOPInstanceUID;
    private Set<AttributeTag> perFrameAttributesPresentInAnyFrame;
    private AttributeList sharedAttributes;
    private Map<AttributeTag, Integer> sharedAttributesFrameCount;
    private Set<AttributeTag> alreadyRemovedFromSharedAttributesBecausePreviouslyFoundToBeUnequal;
    private List<String> sopInstanceUIDsSortedByFrameOrder;
    private int numberOfFrames;
    private boolean partitioned;
    private static Set<AttributeTag> distinguishingAttributeTags = new HashSet<AttributeTag>();
    private static Set<AttributeTag> excludeFromGeneralPerFrameProcessingTags = new HashSet<AttributeTag>();
    private static NumberFormat scientificFormatter = new DecimalFormat("0.###E0");

    private String getDelimitedStringValuesAllowingForFloatingPointJitter(Attribute attribute) {
        String string = "";
        if (attribute != null && attribute.getVM() != 0) {
            if (attribute instanceof DecimalStringAttribute || attribute instanceof FloatSingleAttribute || attribute instanceof FloatDoubleAttribute) {
                StringBuffer stringBuffer = new StringBuffer();
                String string2 = "";
                try {
                    double[] dArray;
                    for (double d : dArray = attribute.getDoubleValues()) {
                        stringBuffer.append(string2);
                        stringBuffer.append(scientificFormatter.format(d));
                        string2 = "\\";
                    }
                }
                catch (DicomException dicomException) {
                    // empty catch block
                }
                string = stringBuffer.toString();
            } else {
                string = attribute.getDelimitedStringValuesOrEmptyString();
            }
        }
        return string;
    }

    private String getDelimitedStringValuesAllowingForFloatingPointJitter(AttributeList attributeList, AttributeTag attributeTag) {
        return this.getDelimitedStringValuesAllowingForFloatingPointJitter(attributeList.get(attributeTag));
    }

    private boolean equalsAllowingForFloatingPointJitter(AttributeList attributeList, AttributeList attributeList2) {
        if (attributeList.size() == attributeList2.size()) {
            for (Attribute attribute : attributeList.values()) {
                String string;
                Attribute attribute2 = attributeList2.get(attribute.getTag());
                String string2 = this.getDelimitedStringValuesAllowingForFloatingPointJitter(attribute).trim();
                if (string2.equals(string = this.getDelimitedStringValuesAllowingForFloatingPointJitter(attribute2).trim())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private AttributeList extractDistinguishingAttributes(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList();
        for (AttributeTag attributeTag : distinguishingAttributeTags) {
            Attribute attribute = attributeList.get(attributeTag);
            if (attribute == null) {
                try {
                    attribute = AttributeFactory.newAttribute(attributeTag);
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("Internal Error: Could not create Distinguishing Attribute for tag {} - ignoring it", attributeTag, dicomException);
                }
            }
            if (attribute == null) continue;
            attributeList2.put(attribute);
        }
        return attributeList2;
    }

    private AttributeList extractPerFrameAttributes(AttributeList attributeList) {
        Object object2;
        AttributeList attributeList2 = new AttributeList();
        for (Object object2 : attributeList.keySet()) {
            if (((AttributeTag)object2).isPrivate() || ((AttributeTag)object2).isRepeatingGroup() || ((AttributeTag)object2).isFileMetaInformationGroup() || ((AttributeTag)object2).isGroupLength() || excludeFromGeneralPerFrameProcessingTags.contains(object2)) continue;
            Attribute attribute = attributeList.get((AttributeTag)object2);
            attributeList2.put(attribute);
            if (((AttributeTag)object2).equals(TagFromName.SOPInstanceUID)) continue;
            this.addToSharedAttributesIfEqualValuesAndNotPreviouslyFoundToBeUnequal(attribute);
        }
        Object object3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDateTime);
        if (((String)object3).length() == 0 && ((String)(object2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionDate))).length() > 0) {
            object3 = (String)object2 + Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.AcquisitionTime);
        }
        try {
            object2 = new DateTimeAttribute(TagFromName.AcquisitionDateTime);
            ((Attribute)object2).addValue((String)object3);
            attributeList2.put((Attribute)object2);
            this.addToSharedAttributesIfEqualValuesAndNotPreviouslyFoundToBeUnequal((Attribute)object2);
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("Could not create AcquisitionDateTime - not added", dicomException);
        }
        return attributeList2;
    }

    private void addToSharedAttributesIfEqualValuesAndNotPreviouslyFoundToBeUnequal(Attribute attribute) {
        AttributeTag attributeTag = attribute.getTag();
        Attribute attribute2 = this.sharedAttributes.get(attributeTag);
        if (attribute2 == null) {
            if (!this.alreadyRemovedFromSharedAttributesBecausePreviouslyFoundToBeUnequal.contains(attributeTag)) {
                this.sharedAttributes.put(attribute);
                this.sharedAttributesFrameCount.put(attributeTag, new Integer(1));
            }
        } else {
            String string;
            String string2 = this.getDelimitedStringValuesAllowingForFloatingPointJitter(attribute2);
            if (string2.equals(string = this.getDelimitedStringValuesAllowingForFloatingPointJitter(attribute))) {
                this.sharedAttributesFrameCount.put(attributeTag, new Integer(this.sharedAttributesFrameCount.get(attributeTag) + 1));
            } else {
                this.sharedAttributes.remove(attributeTag);
                this.alreadyRemovedFromSharedAttributesBecausePreviouslyFoundToBeUnequal.add(attributeTag);
            }
        }
    }

    private void removeSharedAttributesThatAreNotInEveryFrame() {
        Iterator iterator = this.sharedAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            AttributeTag attributeTag = (AttributeTag)entry.getKey();
            int n = this.sharedAttributesFrameCount.get(attributeTag);
            if (n >= this.numberOfFrames) continue;
            iterator.remove();
        }
    }

    private void removeSharedAttributesFromPerFrameAttributes() {
        for (AttributeTag attributeTag : this.sharedAttributes.keySet()) {
            for (AttributeList attributeList : this.perFrameAttributesIndexedBySOPInstanceUID.values()) {
                attributeList.remove(attributeTag);
            }
        }
    }

    private void extractPerFrameAttributesPresentInAnyFrame() {
        this.perFrameAttributesPresentInAnyFrame = new TreeSet<AttributeTag>();
        for (AttributeList attributeList : this.perFrameAttributesIndexedBySOPInstanceUID.values()) {
            this.perFrameAttributesPresentInAnyFrame.addAll(FrameSet.getAttributeTagsInAttributeListWithValues(attributeList));
        }
    }

    private void extractFrameSortOrderFromPerFrameAttributes() {
        TreeSet<FrameSortKey> treeSet = new TreeSet<FrameSortKey>();
        for (AttributeList object : this.perFrameAttributesIndexedBySOPInstanceUID.values()) {
            treeSet.add(new FrameSortKey(object));
        }
        this.sopInstanceUIDsSortedByFrameOrder = new ArrayList<String>(treeSet.size());
        for (FrameSortKey frameSortKey : treeSet) {
            this.sopInstanceUIDsSortedByFrameOrder.add(frameSortKey.sopInstanceUID);
        }
    }

    private void partitionPerFrameIntoSharedAttributes() {
        if (!this.partitioned) {
            this.removeSharedAttributesThatAreNotInEveryFrame();
            this.removeSharedAttributesFromPerFrameAttributes();
            this.extractPerFrameAttributesPresentInAnyFrame();
            this.extractFrameSortOrderFromPerFrameAttributes();
            this.partitioned = true;
        }
    }

    boolean eligible(AttributeList attributeList) {
        AttributeList attributeList2 = this.extractDistinguishingAttributes(attributeList);
        boolean bl = this.equalsAllowingForFloatingPointJitter(this.distinguishingAttributes, attributeList2);
        return bl;
    }

    void insert(AttributeList attributeList) throws DicomException {
        ++this.numberOfFrames;
        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
        if (string.length() <= 0) {
            throw new DicomException("Missing SOP Instance UID");
        }
        AttributeList attributeList2 = this.extractPerFrameAttributes(attributeList);
        this.perFrameAttributesIndexedBySOPInstanceUID.put(string, attributeList2);
        this.partitioned = false;
    }

    FrameSet(AttributeList attributeList) throws DicomException {
        distinguishingAttributeTags.add(TagFromName.PatientID);
        distinguishingAttributeTags.add(TagFromName.PatientName);
        distinguishingAttributeTags.add(TagFromName.StudyInstanceUID);
        distinguishingAttributeTags.add(TagFromName.FrameOfReferenceUID);
        distinguishingAttributeTags.add(TagFromName.Manufacturer);
        distinguishingAttributeTags.add(TagFromName.InstitutionName);
        distinguishingAttributeTags.add(TagFromName.InstitutionAddress);
        distinguishingAttributeTags.add(TagFromName.StationName);
        distinguishingAttributeTags.add(TagFromName.InstitutionalDepartmentName);
        distinguishingAttributeTags.add(TagFromName.ManufacturerModelName);
        distinguishingAttributeTags.add(TagFromName.DeviceSerialNumber);
        distinguishingAttributeTags.add(TagFromName.SoftwareVersions);
        distinguishingAttributeTags.add(TagFromName.GantryID);
        distinguishingAttributeTags.add(TagFromName.PixelPaddingValue);
        distinguishingAttributeTags.add(TagFromName.Modality);
        distinguishingAttributeTags.add(TagFromName.ImageType);
        distinguishingAttributeTags.add(TagFromName.BurnedInAnnotation);
        distinguishingAttributeTags.add(TagFromName.SOPClassUID);
        distinguishingAttributeTags.add(TagFromName.Rows);
        distinguishingAttributeTags.add(TagFromName.Columns);
        distinguishingAttributeTags.add(TagFromName.BitsStored);
        distinguishingAttributeTags.add(TagFromName.BitsAllocated);
        distinguishingAttributeTags.add(TagFromName.HighBit);
        distinguishingAttributeTags.add(TagFromName.PixelRepresentation);
        distinguishingAttributeTags.add(TagFromName.PhotometricInterpretation);
        distinguishingAttributeTags.add(TagFromName.PlanarConfiguration);
        distinguishingAttributeTags.add(TagFromName.SamplesPerPixel);
        distinguishingAttributeTags.add(TagFromName.ProtocolName);
        distinguishingAttributeTags.add(TagFromName.ConvolutionKernel);
        distinguishingAttributeTags.add(TagFromName.ImageOrientationPatient);
        distinguishingAttributeTags.add(TagFromName.PixelSpacing);
        distinguishingAttributeTags.add(TagFromName.SliceThickness);
        distinguishingAttributeTags.add(TagFromName.AcquisitionContextSequence);
        excludeFromGeneralPerFrameProcessingTags.addAll(distinguishingAttributeTags);
        excludeFromGeneralPerFrameProcessingTags.add(TagFromName.AcquisitionDateTime);
        excludeFromGeneralPerFrameProcessingTags.add(TagFromName.AcquisitionDate);
        excludeFromGeneralPerFrameProcessingTags.add(TagFromName.AcquisitionTime);
        this.distinguishingAttributes = this.extractDistinguishingAttributes(attributeList);
        this.perFrameAttributesIndexedBySOPInstanceUID = new TreeMap<String, AttributeList>();
        this.perFrameAttributesPresentInAnyFrame = null;
        this.sharedAttributes = new AttributeList();
        this.sharedAttributesFrameCount = new HashMap<AttributeTag, Integer>();
        this.alreadyRemovedFromSharedAttributesBecausePreviouslyFoundToBeUnequal = new HashSet<AttributeTag>();
        this.sopInstanceUIDsSortedByFrameOrder = null;
        this.numberOfFrames = 0;
        this.insert(attributeList);
    }

    public List<String> getSOPInstanceUIDsSortedByFrameOrder() {
        this.partitionPerFrameIntoSharedAttributes();
        return this.sopInstanceUIDsSortedByFrameOrder;
    }

    public static Set<AttributeTag> getAttributeTagsInAttributeListWithValues(AttributeList attributeList) {
        TreeSet<AttributeTag> treeSet = new TreeSet<AttributeTag>();
        for (Attribute attribute : attributeList.values()) {
            if (attribute.getVM() <= 0 && (!(attribute instanceof SequenceAttribute) || ((SequenceAttribute)attribute).getNumberOfItems() <= 0)) continue;
            treeSet.add(attribute.getTag());
        }
        return treeSet;
    }

    public Set<AttributeTag> getDistinguishingAttributeTags() {
        this.partitionPerFrameIntoSharedAttributes();
        return FrameSet.getAttributeTagsInAttributeListWithValues(this.distinguishingAttributes);
    }

    public Set<AttributeTag> getSharedAttributeTags() {
        this.partitionPerFrameIntoSharedAttributes();
        return FrameSet.getAttributeTagsInAttributeListWithValues(this.sharedAttributes);
    }

    public Set<AttributeTag> getPerFrameAttributeTags() {
        this.partitionPerFrameIntoSharedAttributes();
        return this.perFrameAttributesPresentInAnyFrame;
    }

    public int size() {
        this.partitionPerFrameIntoSharedAttributes();
        return this.sopInstanceUIDsSortedByFrameOrder == null ? 0 : this.sopInstanceUIDsSortedByFrameOrder.size();
    }

    public String toString() {
        this.partitionPerFrameIntoSharedAttributes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\tNumber of frames: ");
        stringBuffer.append(this.numberOfFrames);
        stringBuffer.append("\n");
        if (this.distinguishingAttributes != null) {
            stringBuffer.append("\tDistinguishing:\n");
            for (AttributeTag iterator : this.distinguishingAttributes.keySet()) {
                stringBuffer.append("\t\t");
                stringBuffer.append(this.distinguishingAttributes.get(iterator).toString(AttributeList.getDictionary()));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\tShared:\n");
        if (this.sharedAttributes != null) {
            for (AttributeTag attributeTag : this.sharedAttributes.keySet()) {
                stringBuffer.append("\t\t\t");
                stringBuffer.append(this.sharedAttributes.get(attributeTag).toString(AttributeList.getDictionary()));
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("\tPer-Frame:\n");
        if (this.perFrameAttributesPresentInAnyFrame != null) {
            for (AttributeTag attributeTag : this.perFrameAttributesPresentInAnyFrame) {
                stringBuffer.append("\t\t");
                stringBuffer.append(attributeTag);
                stringBuffer.append(" ");
                stringBuffer.append(AttributeList.getDictionary().getNameFromTag(attributeTag));
                stringBuffer.append("\n");
            }
        }
        if (this.perFrameAttributesIndexedBySOPInstanceUID != null) {
            int n = 0;
            for (String string : this.sopInstanceUIDsSortedByFrameOrder) {
                if (string == null) continue;
                AttributeList attributeList = this.perFrameAttributesIndexedBySOPInstanceUID.get(string);
                stringBuffer.append("\tFrame [");
                stringBuffer.append(Integer.toString(n));
                stringBuffer.append("]:\n");
                if (attributeList != null) {
                    for (AttributeTag attributeTag : attributeList.keySet()) {
                        stringBuffer.append("\t\t\t");
                        stringBuffer.append(attributeList.get(attributeTag).toString(AttributeList.getDictionary()));
                        stringBuffer.append("\n");
                    }
                }
                ++n;
            }
        }
        if (this.sopInstanceUIDsSortedByFrameOrder != null) {
            stringBuffer.append("\tFrame order:\n");
            int n = 0;
            for (String string : this.sopInstanceUIDsSortedByFrameOrder) {
                stringBuffer.append("\t\tFrame [");
                stringBuffer.append(Integer.toString(n));
                stringBuffer.append("]: ");
                stringBuffer.append(string);
                stringBuffer.append("\n");
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    private class FrameSortKey
    implements Comparable {
        String sopInstanceUID;
        int seriesNumber;
        int instanceNumber;

        public int compareTo(Object object) {
            String string = ((FrameSortKey)object).sopInstanceUID;
            int n = ((FrameSortKey)object).instanceNumber;
            int n2 = ((FrameSortKey)object).seriesNumber;
            return this.seriesNumber == n2 ? (this.instanceNumber == n ? (this.sopInstanceUID.equals(string) ? 0 : (this.sopInstanceUID.hashCode() < string.hashCode() ? -1 : 1)) : (this.instanceNumber < n ? -1 : 1)) : (this.seriesNumber < n2 ? -1 : 1);
        }

        public boolean equals(Object object) {
            return this.sopInstanceUID.equals(((FrameSortKey)object).sopInstanceUID);
        }

        public int hashCode() {
            return this.sopInstanceUID.hashCode();
        }

        FrameSortKey(AttributeList attributeList) {
            this.sopInstanceUID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            this.seriesNumber = -1;
            String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber);
            if (string.length() > 0) {
                try {
                    this.seriesNumber = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    slf4jlogger.error("Could not parse SeriesNumber as integer {}", string, numberFormatException);
                }
            }
            this.instanceNumber = -1;
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber);
            if (string2.length() > 0) {
                try {
                    this.instanceNumber = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    slf4jlogger.error("Could not parse InstanceNumber as integer {}", string2, numberFormatException);
                }
            }
        }
    }
}

