/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClassDescriptions;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.xml.bind.DatatypeConverter;

public class JSONRepresentationOfDicomObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/JSONRepresentationOfDicomObjectFactory.java,v 1.27 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(JSONRepresentationOfDicomObjectFactory.class);
    protected static String reservedKeywordForPersonNameAlphabeticPropertyInJsonRepresentation = "Alphabetic";
    protected static String reservedKeywordForPersonNameIdeographicPropertyInJsonRepresentation = "Ideographic";
    protected static String reservedKeywordForPersonNamePhoneticPropertyInJsonRepresentation = "Phonetic";
    private JsonBuilderFactory factory = Json.createBuilderFactory(null);

    protected static String substituteKeywordForUIDIfPossible(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            string2 = SOPClassDescriptions.getKeywordFromUID(string);
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    protected static String substituteKeywordForUIDIfPossibleAndRequested(String string, boolean bl) {
        String string2 = null;
        if (bl) {
            string2 = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossible(string);
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    protected static String substituteKeywordForUIDIfPossibleAndAppropriateForVRAndRequested(String string, byte[] byArray, boolean bl) {
        String string2 = null;
        if (ValueRepresentation.isUniqueIdentifierVR(byArray)) {
            string2 = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndRequested(string, bl);
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    protected static String substituteUIDForKeywordIfPossible(String string) {
        String string2 = null;
        if (string != null && string.length() > 0) {
            string2 = SOPClassDescriptions.getUIDFromKeyword(string);
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    protected static String substituteUIDForKeywordIfPossibleAndAppropriateForVR(String string, byte[] byArray) {
        String string2 = null;
        if (ValueRepresentation.isUniqueIdentifierVR(byArray)) {
            string2 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible(string);
        }
        return string2 != null && string2.length() > 0 ? string2 : string;
    }

    private String makeElementNameFromHexadecimalGroupElementValues(AttributeTag attributeTag) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Integer.toHexString(attributeTag.getGroup());
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        String string2 = Integer.toHexString(attributeTag.getElement());
        for (int i = string2.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    protected static final AttributeTag getAttributeTagFromHexadecimalGroupElementValues(String string) {
        slf4jlogger.trace("getAttributeTagFromHexadecimalGroupElementValues(): string = {}", string);
        AttributeTag attributeTag = null;
        if (string != null && string.length() == 8) {
            try {
                int n = Integer.parseInt(string.substring(0, 4), 16);
                slf4jlogger.trace("getAttributeTagFromHexadecimalGroupElementValues(): group = {}", n);
                int n2 = Integer.parseInt(string.substring(4, 8), 16);
                slf4jlogger.trace("getAttributeTagFromHexadecimalGroupElementValues(): element = {}", n2);
                attributeTag = new AttributeTag(n, n2);
            }
            catch (NumberFormatException numberFormatException) {
                slf4jlogger.trace("getAttributeTagFromHexadecimalGroupElementValues(): ", numberFormatException);
            }
        }
        return attributeTag;
    }

    public static String getJsonPersonNameFromPropertiesInJsonObject(JsonObject jsonObject, String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        String string4 = "";
        String string5 = "";
        String string6 = "";
        try {
            string4 = jsonObject.getString(string);
        }
        catch (NullPointerException nullPointerException) {
            string4 = "";
        }
        try {
            string5 = jsonObject.getString(string2);
        }
        catch (NullPointerException nullPointerException) {
            string5 = "";
        }
        try {
            string6 = jsonObject.getString(string3);
        }
        catch (NullPointerException nullPointerException) {
            string6 = "";
        }
        if (string4.length() > 0 || string5.length() > 0 || string6.length() > 0) {
            stringBuffer.append(string4);
            if (string5.length() > 0 || string6.length() > 0) {
                stringBuffer.append("=");
                stringBuffer.append(string5);
            }
            if (string6.length() > 0) {
                stringBuffer.append("=");
                stringBuffer.append(string6);
            }
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addAttributesFromJsonObjectToList(AttributeList attributeList, JsonObject jsonObject, boolean bl, boolean bl2) throws DicomException {
        DicomDictionary dicomDictionary = attributeList.getDictionary();
        if (jsonObject == null) return;
        for (String string : jsonObject.keySet()) {
            slf4jlogger.debug("JSON elementName = {}", string);
            String string2 = null;
            JsonObject jsonObject2 = null;
            JsonValue jsonValue = (JsonValue)jsonObject.get((Object)string);
            if (jsonValue != null) {
                if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
                    jsonObject2 = (JsonObject)jsonValue;
                } else if (jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                    string2 = ((JsonString)jsonValue).getString();
                    slf4jlogger.debug("JsonValue.ValueType.STRING jsonSingleValue = {}", string2);
                } else if (jsonValue.getValueType() == JsonValue.ValueType.NUMBER) {
                    string2 = ((JsonNumber)jsonValue).toString();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (string2.endsWith(".0")) {
                        string2 = string2.substring(0, string2.length() - 2);
                    }
                    slf4jlogger.debug("JsonValue.ValueType.NUMBER jsonSingleValue = {}", string2);
                }
            }
            Object var10_12 = null;
            String string3 = null;
            AttributeTag attributeTag = JSONRepresentationOfDicomObjectFactory.getAttributeTagFromHexadecimalGroupElementValues(string);
            slf4jlogger.debug("Tag from parsing JSON elementName = {}", attributeTag);
            if (attributeTag == null) {
                attributeTag = dicomDictionary.getTagFromName(string);
                slf4jlogger.debug("Tag from looking up JSON elementName in dictionary = {}", attributeTag);
            }
            if (attributeTag != null) {
                byte[] byArray = dicomDictionary.getValueRepresentationFromTag(attributeTag);
                string3 = ValueRepresentation.getAsString(byArray);
            }
            boolean bl3 = true;
            if (bl2 && attributeTag != null && (attributeTag.equals(TagFromName.ContentSequence) || attributeTag.equals(TagFromName.ValueType) || attributeTag.equals(TagFromName.ConceptNameCodeSequence) || attributeTag.equals(TagFromName.ContinuityOfContent) || attributeTag.equals(TagFromName.ContentTemplateSequence) || attributeTag.equals(TagFromName.MappingResource) || attributeTag.equals(TagFromName.TemplateIdentifier))) {
                slf4jlogger.debug("Ignoring SR-related tag");
                bl3 = false;
            }
            if (!bl3) continue;
            if (attributeTag != null) {
                JsonValue jsonValue2;
                int n;
                Attribute attribute;
                void var10_10;
                void var10_14;
                String string4 = jsonObject2 == null ? "" : jsonObject2.getString("vr", "");
                byte[] byArray = string4.getBytes();
                if (var10_14 == null) {
                    byte[] byArray2 = byArray;
                } else if (!string3.equals(string4)) {
                    if (ValueRepresentation.isUnspecifiedShortVR((byte[])var10_14)) {
                        if (ValueRepresentation.isUnsignedShortVR(byArray) || ValueRepresentation.isSignedShortVR(byArray)) {
                            byte[] byArray3 = byArray;
                        }
                    } else if (ValueRepresentation.isOtherUnspecifiedVR((byte[])var10_14)) {
                        if (ValueRepresentation.isOtherByteOrWordVR(byArray)) {
                            byte[] byArray4 = byArray;
                        }
                    } else if (string4.length() > 0) {
                        throw new DicomException("Dictionary VR <" + string3 + "> does not match VR in attribute <" + string4 + "> of element " + string);
                    }
                }
                if (var10_10 == null || ((void)var10_10).length != 2) throw new DicomException("Cannot determine VR for " + attributeTag + " " + string);
                int n2 = attributeTag.getGroup();
                int n3 = attributeTag.getElement();
                if (n2 % 2 == 0 && n3 == 0 || n2 == 8 && n3 == 1 || n2 == 65532 && n3 == 65532) continue;
                JsonArray jsonArray = null;
                String string5 = null;
                if (jsonObject2 != null) {
                    try {
                        jsonArray = jsonObject2.getJsonArray("Value");
                    }
                    catch (ClassCastException classCastException) {
                        throw new DicomException("Expected array values for tag " + string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        string5 = jsonObject2.getString("InlineBinary");
                    }
                    catch (ClassCastException classCastException) {
                        throw new DicomException("Expected string Base64 value for tag " + string);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                if (ValueRepresentation.isSequenceVR((byte[])var10_10)) {
                    attribute = new SequenceAttribute(attributeTag);
                    if (jsonArray != null && jsonArray.size() > 0) {
                        for (n = 0; n < jsonArray.size(); ++n) {
                            jsonValue2 = null;
                            try {
                                jsonValue2 = jsonArray.getJsonObject(n);
                            }
                            catch (ClassCastException classCastException) {
                                throw new DicomException("Expected object for sequence attribute " + string);
                            }
                            if (jsonValue2 == null) continue;
                            AttributeList attributeList2 = new AttributeList();
                            this.addAttributesFromJsonObjectToList(attributeList2, (JsonObject)jsonValue2, bl, bl2);
                            ((SequenceAttribute)attribute).addItem(attributeList2);
                        }
                    }
                    attributeList.put(attributeTag, attribute);
                    continue;
                }
                attribute = AttributeFactory.newAttribute(attributeTag, (byte[])var10_10);
                if (string2 != null) {
                    String string6 = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(string2);
                    string6 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossibleAndAppropriateForVR(string6, (byte[])var10_10);
                    attribute.addValue(string6);
                } else if (jsonArray != null && jsonArray.size() > 0) {
                    for (n = 0; n < jsonArray.size(); ++n) {
                        String string7;
                        jsonValue2 = (JsonValue)jsonArray.get(n);
                        JsonValue.ValueType valueType = jsonValue2.getValueType();
                        if (valueType == JsonValue.ValueType.STRING) {
                            string7 = ((JsonString)jsonValue2).getString();
                            slf4jlogger.debug("addAttributesFromJsonObjectToList(): String Value stringValue = {}", string7);
                            if (string7 == null) {
                                string7 = "";
                            }
                            string7 = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl(string7);
                            string7 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossibleAndAppropriateForVR(string7, (byte[])var10_10);
                            attribute.addValue(string7);
                            continue;
                        }
                        if (valueType == JsonValue.ValueType.NUMBER) {
                            string7 = ((JsonNumber)jsonValue2).toString();
                            slf4jlogger.debug("addAttributesFromJsonObjectToList(): Number Value stringValue = {}", string7);
                            if (string7 == null) {
                                string7 = "";
                            }
                            if (string7.endsWith(".0")) {
                                string7 = string7.substring(0, string7.length() - 2);
                            }
                            attribute.addValue(string7);
                            continue;
                        }
                        if (valueType == JsonValue.ValueType.OBJECT && ValueRepresentation.isPersonNameVR((byte[])var10_10)) {
                            string7 = (JsonObject)jsonValue2;
                            String string8 = JSONRepresentationOfDicomObjectFactory.getJsonPersonNameFromPropertiesInJsonObject((JsonObject)string7, reservedKeywordForPersonNameAlphabeticPropertyInJsonRepresentation, reservedKeywordForPersonNameIdeographicPropertyInJsonRepresentation, reservedKeywordForPersonNamePhoneticPropertyInJsonRepresentation);
                            attribute.addValue(string8);
                            continue;
                        }
                        if (valueType != JsonValue.ValueType.NULL) throw new DicomException("Unrecognized type of value for attribute " + string);
                        attribute.addValue("");
                    }
                } else if (string5 != null && string5.length() > 0) {
                    if (!ValueRepresentation.isBase64EncodedInJSON((byte[])var10_10)) throw new DicomException("Expected single string Base64 InLineBinary for attribute " + string);
                    slf4jlogger.debug("addAttributesFromJsonObjectToList(): Base64 String VR");
                    byte[] byArray5 = DatatypeConverter.parseBase64Binary((String)string5);
                    slf4jlogger.debug("addAttributesFromJsonObjectToList(): Base64 decodes as array of length {}", byArray5.length);
                    attribute.setValues(byArray5, false);
                } else {
                    slf4jlogger.debug("addAttributesFromJsonObjectToList(): Have no values");
                }
                if (slf4jlogger.isDebugEnabled()) {
                    slf4jlogger.debug("addAttributesFromJsonObjectToList(): Attribute is {}", attribute.toString());
                }
                attributeList.put(attributeTag, attribute);
                continue;
            }
            if (bl) continue;
            throw new DicomException("Cannot determine tag for " + string);
        }
    }

    public static void addPersonNameAsComponentsToJsonObject(JsonObjectBuilder jsonObjectBuilder, String string, String string2, String string3, String string4) {
        String string5;
        Vector<String> vector = PersonNameAttribute.getNameComponentGroups(string);
        int n = vector.size();
        if (n >= 1 && (string5 = vector.get(0)) != null && string5.length() > 0) {
            jsonObjectBuilder.add(string2, string5);
        }
        if (n >= 2 && (string5 = vector.get(1)) != null && string5.length() > 0) {
            jsonObjectBuilder.add(string3, string5);
        }
        if (n >= 3 && (string5 = vector.get(2)) != null && string5.length() > 0) {
            jsonObjectBuilder.add(string4, string5);
        }
    }

    void addAttributesFromListToJsonObject(AttributeList attributeList, JsonObjectBuilder jsonObjectBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DicomException {
        this.addAttributesFromListToJsonObject(attributeList, jsonObjectBuilder, bl, bl2, bl3, true, false, false, bl4, false, false);
    }

    void addAttributesFromListToJsonObject(AttributeList attributeList, JsonObjectBuilder jsonObjectBuilder, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) throws DicomException {
        for (Attribute attribute : attributeList.values()) {
            JsonObjectBuilder jsonObjectBuilder2;
            Object object;
            byte[] byArray = attribute.getVR();
            AttributeTag attributeTag = attribute.getTag();
            slf4jlogger.debug("addAttributesFromListToJsonObject(): Adding {}", attributeTag);
            boolean bl10 = true;
            String string = null;
            BigDecimal bigDecimal = null;
            BigInteger bigInteger = null;
            double d = 0.0;
            boolean bl11 = false;
            JsonArrayBuilder jsonArrayBuilder = null;
            String string2 = null;
            if (bl7 && (attributeTag.equals(TagFromName.ContentSequence) || attributeTag.equals(TagFromName.ValueType) || attributeTag.equals(TagFromName.ConceptNameCodeSequence) || attributeTag.equals(TagFromName.ContinuityOfContent) || attributeTag.equals(TagFromName.ContentTemplateSequence) || attributeTag.equals(TagFromName.MappingResource) || attributeTag.equals(TagFromName.TemplateIdentifier))) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): Ignoring SR-related tag");
                bl10 = false;
            } else if (attribute instanceof SequenceAttribute) {
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attribute;
                if (sequenceAttribute.getNumberOfItems() > 0) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                    Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
                    while (iterator.hasNext()) {
                        SequenceItem sequenceItem = iterator.next();
                        object = sequenceItem.getAttributeList();
                        jsonObjectBuilder2 = this.factory.createObjectBuilder();
                        this.addAttributesFromListToJsonObject((AttributeList)object, jsonObjectBuilder2, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
                        jsonArrayBuilder.add(jsonObjectBuilder2);
                    }
                }
            } else if (ValueRepresentation.isPersonNameVR(byArray)) {
                String[] stringArray = null;
                try {
                    stringArray = attribute.getStringValues();
                }
                catch (DicomException dicomException) {
                    slf4jlogger.debug("addAttributesFromListToJsonObject(): Ignoring exception", dicomException);
                }
                if (stringArray != null && stringArray.length > 0) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                    for (int i = 0; i < stringArray.length; ++i) {
                        String string3 = stringArray[i];
                        if (string3 != null && string3.length() > 0) {
                            object = this.factory.createObjectBuilder();
                            JSONRepresentationOfDicomObjectFactory.addPersonNameAsComponentsToJsonObject((JsonObjectBuilder)object, string3, reservedKeywordForPersonNameAlphabeticPropertyInJsonRepresentation, reservedKeywordForPersonNameIdeographicPropertyInJsonRepresentation, reservedKeywordForPersonNamePhoneticPropertyInJsonRepresentation);
                            jsonArrayBuilder.add((JsonObjectBuilder)object);
                            continue;
                        }
                        jsonArrayBuilder.addNull();
                    }
                }
            } else if (ValueRepresentation.isDecimalNumberInJSON(byArray)) {
                int n = attribute.getVM();
                if (n > 0) {
                    if (n == 1 && bl5 && !bl4 && !attributeTag.isPrivate()) {
                        slf4jlogger.debug("addAttributesFromListToJsonObject(): have one decimal value to add without value array");
                        if (ValueRepresentation.isDecimalStringVR(byArray)) {
                            String[] stringArray = attribute.getStringValues();
                            if (bl9) {
                                bigDecimal = new BigDecimal(stringArray[0]);
                            } else {
                                string = stringArray[0];
                            }
                        } else {
                            double[] dArray = null;
                            dArray = attribute.getDoubleValues();
                            d = dArray[0];
                            bl11 = true;
                        }
                    } else {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                        if (ValueRepresentation.isDecimalStringVR(byArray)) {
                            String[] stringArray = attribute.getStringValues();
                            for (int i = 0; i < n; ++i) {
                                if (bl9) {
                                    jsonArrayBuilder.add(new BigDecimal(stringArray[i]));
                                    continue;
                                }
                                jsonArrayBuilder.add(stringArray[i]);
                            }
                        } else {
                            double[] dArray = null;
                            dArray = attribute.getDoubleValues();
                            for (int i = 0; i < n; ++i) {
                                jsonArrayBuilder.add(dArray[i]);
                            }
                        }
                    }
                }
            } else if (ValueRepresentation.isIntegerNumberInJSON(byArray)) {
                int n = attribute.getVM();
                if (n > 0) {
                    if (n == 1 && bl5 && !bl4 && !attributeTag.isPrivate()) {
                        slf4jlogger.debug("addAttributesFromListToJsonObject(): have one integer value to add without value array");
                        if (ValueRepresentation.isIntegerStringVR(byArray)) {
                            String[] stringArray = attribute.getStringValues();
                            if (bl9) {
                                bigInteger = new BigInteger(stringArray[0]);
                            } else {
                                string = stringArray[0];
                            }
                        } else {
                            long[] lArray = null;
                            lArray = attribute.getLongValues();
                            d = lArray[0];
                            bl11 = true;
                        }
                    } else {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                        if (ValueRepresentation.isIntegerStringVR(byArray)) {
                            String[] stringArray = attribute.getStringValues();
                            for (int i = 0; i < n; ++i) {
                                if (bl9) {
                                    jsonArrayBuilder.add(new BigInteger(stringArray[i]));
                                    continue;
                                }
                                jsonArrayBuilder.add(stringArray[i]);
                            }
                        } else {
                            long[] lArray = null;
                            lArray = attribute.getLongValues();
                            for (int i = 0; i < n; ++i) {
                                jsonArrayBuilder.add(lArray[i]);
                            }
                        }
                    }
                }
            } else if (ValueRepresentation.isBase64EncodedInJSON(byArray)) {
                byte[] byArray2 = attribute.getByteValues(false);
                if (byArray2 != null && byArray2.length > 0) {
                    string2 = DatatypeConverter.printBase64Binary((byte[])byArray2);
                }
            } else {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): assuming String values");
                String[] stringArray = null;
                try {
                    stringArray = attribute.getStringValues();
                }
                catch (DicomException dicomException) {
                    slf4jlogger.debug("addAttributesFromListToJsonObject(): Ignoring exception", dicomException);
                }
                if (stringArray != null) {
                    slf4jlogger.debug("addAttributesFromListToJsonObject(): values.length = {}", stringArray.length);
                    if (stringArray.length > 0) {
                        if (stringArray.length == 1 && bl5 && !bl4 && !attributeTag.isPrivate()) {
                            slf4jlogger.debug("addAttributesFromListToJsonObject(): have one String value to add without value array {}", stringArray[0]);
                            string = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndAppropriateForVRAndRequested(stringArray[0], byArray, bl8);
                        } else {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                            for (int i = 0; i < stringArray.length; ++i) {
                                String string4 = stringArray[i];
                                if (string4 != null && string4.length() > 0) {
                                    jsonArrayBuilder.add(JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndAppropriateForVRAndRequested(string4, byArray, bl8));
                                    continue;
                                }
                                jsonArrayBuilder.addNull();
                            }
                        }
                    } else {
                        slf4jlogger.debug("addAttributesFromListToJsonObject(): have zero length values array");
                    }
                } else {
                    slf4jlogger.debug("addAttributesFromListToJsonObject(): have null values array");
                }
            }
            if (!bl10) continue;
            String string5 = bl || bl3 ? DicomDictionary.StandardDictionary.getNameFromTag(attributeTag) : null;
            boolean bl12 = string5 != null && string5.length() > 0;
            String string6 = !bl12 || bl2 ? this.makeElementNameFromHexadecimalGroupElementValues(attributeTag) : null;
            object = bl && bl12 ? string5 : string6;
            jsonObjectBuilder2 = this.factory.createObjectBuilder();
            if (bl4 || attributeTag.isPrivate()) {
                jsonObjectBuilder2.add("vr", ValueRepresentation.getAsString(byArray));
            }
            boolean bl13 = false;
            if (bl3 && bl12) {
                jsonObjectBuilder2.add("keyword", string5);
                bl13 = true;
            }
            if (bl2) {
                jsonObjectBuilder2.add("tag", string6);
                bl13 = true;
            }
            if (jsonArrayBuilder != null) {
                jsonObjectBuilder2.add("Value", jsonArrayBuilder);
                bl13 = true;
            } else if (string2 != null) {
                jsonObjectBuilder2.add("InlineBinary", string2);
                bl13 = true;
            }
            if (string != null) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding jsonSingleStringValue {}", object, string);
                jsonObjectBuilder.add((String)object, string);
                continue;
            }
            if (bl11) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding jsonSingleNumericValue {}", object, d);
                jsonObjectBuilder.add((String)object, d);
                continue;
            }
            if (bigDecimal != null) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding jsonSingleBigDecimalValue {}", object, bigDecimal);
                jsonObjectBuilder.add((String)object, bigDecimal);
                continue;
            }
            if (bigInteger != null) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding jsonSingleBigIntegerValue {}", object, bigInteger);
                jsonObjectBuilder.add((String)object, bigInteger);
                continue;
            }
            if (bl13 || !bl6) {
                slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding jsonAttributeVRAndValue {}", object, jsonObjectBuilder2);
                jsonObjectBuilder.add((String)object, jsonObjectBuilder2);
                continue;
            }
            slf4jlogger.debug("addAttributesFromListToJsonObject(): {} adding null {}", object);
            jsonObjectBuilder.addNull((String)object);
        }
    }

    public JsonArray getDocument(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws DicomException {
        return this.getDocument(attributeList, bl, bl2, bl3, true, false, false, bl4, false, false);
    }

    public JsonArray getDocument(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) throws DicomException {
        JsonObjectBuilder jsonObjectBuilder = this.factory.createObjectBuilder();
        this.addAttributesFromListToJsonObject(attributeList, jsonObjectBuilder, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
        return this.factory.createArrayBuilder().add(jsonObjectBuilder).build();
    }

    public JsonArray getDocument(AttributeList attributeList) throws DicomException {
        return this.getDocument(attributeList, false, false, false, false);
    }

    public JsonArray getDocument(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, DicomException {
        return this.getDocument(file, bl, bl2, bl3, true, false, false, bl4, false, false);
    }

    public JsonArray getDocument(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(file);
        return this.getDocument(attributeList, bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    public JsonArray getDocument(File file) throws IOException, DicomException {
        return this.getDocument(file, false, false, false, false);
    }

    public JsonArray getDocument(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws IOException, DicomException {
        return this.getDocument(string, bl, bl2, bl3, true, false, false, bl4, false, false);
    }

    public JsonArray getDocument(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) throws IOException, DicomException {
        return this.getDocument(new File(string), bl, bl2, bl3, bl4, bl5, bl5, bl7, bl8, bl9);
    }

    public JsonArray getDocument(String string) throws IOException, DicomException {
        return this.getDocument(string, false, false, false, false);
    }

    public AttributeList getAttributeList(JsonObject jsonObject, boolean bl, boolean bl2) throws DicomException {
        AttributeList attributeList = new AttributeList();
        this.addAttributesFromJsonObjectToList(attributeList, jsonObject, bl, bl2);
        return attributeList;
    }

    public AttributeList getAttributeList(JsonArray jsonArray, boolean bl, boolean bl2) throws DicomException {
        Object var4_4 = null;
        JsonObject jsonObject = null;
        try {
            jsonObject = jsonArray.getJsonObject(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DicomException("Could not parse JSON document - exactly one object in top level array expected " + indexOutOfBoundsException);
        }
        catch (ClassCastException classCastException) {
            throw new DicomException("Could not parse JSON document - expected object in top level array " + classCastException);
        }
        return this.getAttributeList(jsonObject, bl, bl2);
    }

    public AttributeList getAttributeList(JsonArray jsonArray) throws DicomException {
        return this.getAttributeList(jsonArray, false, false);
    }

    public AttributeList getAttributeList(JsonObject jsonObject) throws DicomException {
        return this.getAttributeList(jsonObject, false, false);
    }

    public AttributeList getAttributeList(InputStream inputStream) throws IOException, DicomException {
        JsonReader jsonReader = Json.createReader((InputStream)inputStream);
        JsonStructure jsonStructure = jsonReader.read();
        jsonReader.close();
        if (jsonStructure instanceof JsonArray) {
            return this.getAttributeList((JsonArray)jsonStructure);
        }
        if (jsonStructure instanceof JsonObject) {
            return this.getAttributeList((JsonObject)jsonStructure);
        }
        throw new DicomException("Could not parse JSON document - expected object or array at top level");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributeList(File file) throws IOException, DicomException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        return attributeList;
    }

    public AttributeList getAttributeList(String string) throws IOException, DicomException {
        return this.getAttributeList(new File(string));
    }

    public static void write(OutputStream outputStream, JsonArray jsonArray) throws IOException {
        JsonWriter jsonWriter = Json.createWriterFactory(null).createWriter(outputStream);
        jsonWriter.writeArray(jsonArray);
        jsonWriter.close();
    }

    public static void write(File file, JsonArray jsonArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JSONRepresentationOfDicomObjectFactory.write(fileOutputStream, jsonArray);
        ((OutputStream)fileOutputStream).close();
    }

    public static void write(String string, JsonArray jsonArray) throws IOException {
        JSONRepresentationOfDicomObjectFactory.write(new File(string), jsonArray);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws DicomException {
        try {
            JsonArray jsonArray = new JSONRepresentationOfDicomObjectFactory().getDocument(attributeList);
            JSONRepresentationOfDicomObjectFactory.write(outputStream, jsonArray);
        }
        catch (Exception exception) {
            throw new DicomException("Could not create JSON document - could not transform to JSON " + exception);
        }
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, File file) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JSONRepresentationOfDicomObjectFactory.createDocumentAndWriteIt(attributeList, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, String string) throws IOException, DicomException {
        JSONRepresentationOfDicomObjectFactory.createDocumentAndWriteIt(attributeList, new File(string));
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            boolean bl = true;
            String string = null;
            String string2 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = true;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            boolean bl9 = false;
            boolean bl10 = false;
            int n = 1;
            int n2 = 3;
            int n3 = stringArray.length;
            boolean bl11 = false;
            if (n3 < n) {
                bl11 = true;
            }
            boolean bl12 = true;
            block42: while (bl12 && n3 > n) {
                object = stringArray[n3 - 1].trim().toUpperCase();
                switch (object) {
                    case "USEKEYWORD": {
                        bl2 = true;
                        --n3;
                        continue block42;
                    }
                    case "USETAG": {
                        bl2 = false;
                        --n3;
                        continue block42;
                    }
                    case "ADDTAG": {
                        bl3 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTADDTAG": {
                        bl3 = false;
                        --n3;
                        continue block42;
                    }
                    case "ADDKEYWORD": {
                        bl4 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTADDKEYWORD": {
                        bl4 = false;
                        --n3;
                        continue block42;
                    }
                    case "ADDVR": {
                        bl5 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTADDVR": {
                        bl5 = false;
                        --n3;
                        continue block42;
                    }
                    case "COLLAPSEVALUEARRAYS": {
                        bl6 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTCOLLAPSEVALUEARRAYS": {
                        bl6 = false;
                        --n3;
                        continue block42;
                    }
                    case "COLLAPSEEMPTYTONULL": {
                        bl7 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTCOLLAPSEEMPTYTONULL": {
                        bl7 = false;
                        --n3;
                        continue block42;
                    }
                    case "IGNORESR": {
                        bl8 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTIGNORESR": {
                        bl8 = false;
                        --n3;
                        continue block42;
                    }
                    case "USEUIDKEYWORDS": {
                        bl9 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTUSEUIDKEYWORDS": {
                        bl9 = false;
                        --n3;
                        continue block42;
                    }
                    case "USENUMBERFORISDS": {
                        bl10 = true;
                        --n3;
                        continue block42;
                    }
                    case "DONOTUSENUMBERFORISDS": {
                        bl10 = false;
                        --n3;
                        continue block42;
                    }
                }
                if (n3 > n2) {
                    slf4jlogger.error("Unrecognized argument {}", object);
                    bl11 = true;
                }
                bl12 = false;
            }
            if (!bl11) {
                if (n3 == 1) {
                    bl = true;
                    string = stringArray[0];
                } else if (n3 == 2) {
                    if (stringArray[0].toLowerCase(Locale.US).equals("tojson")) {
                        string = stringArray[1];
                        bl = true;
                    } else if (stringArray[0].toLowerCase(Locale.US).equals("todicom") || stringArray[0].toLowerCase(Locale.US).equals("todcm")) {
                        string = stringArray[1];
                        bl11 = false;
                        bl = false;
                    } else {
                        string = stringArray[0];
                        string2 = stringArray[1];
                        bl = true;
                    }
                } else if (n3 == 3) {
                    if (stringArray[0].toLowerCase(Locale.US).equals("tojson")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        bl = true;
                    } else if (stringArray[0].toLowerCase(Locale.US).equals("todicom") || stringArray[0].toLowerCase(Locale.US).equals("todcm")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        bl = false;
                    } else {
                        bl11 = true;
                    }
                } else {
                    bl11 = true;
                }
            }
            if (!bl && (bl2 || bl3 || bl4 || !bl5 || bl6)) {
                System.err.println("Unexpected options specified for conversion to DICOM that are only applicable to conversion to JSON");
                bl11 = true;
            }
            if (bl11) {
                System.err.println("usage: JSONRepresentationOfDicomObjectFactory [toJSON|toDICOM] inputpath [outputpath] [USEKEYWORD|USETAG] [ADDTAG|DONOTADDTAG] [ADDKEYWORD|DONOTADDKEYWORD] [ADDVR|DONOTADDVR] [COLLAPSEVALUEARRAYS|DONOTCOLLAPSEVALUEARRAYS] [COLLAPSEEMPTYTONULL|DONOTCOLLAPSEEMPTYTONULL] [IGNORESR|DONOTIGNORESR] [USEUIDKEYWORDS|DONOTUSEUIDKEYWORDS] [USENUMBERFORISDS|DONOTUSENUMBERFORISDS]");
                System.err.println("usage: JSONRepresentationOfDicomObjectFactory toDICOM inputpath [outputpath]");
                System.exit(1);
            } else if (bl) {
                object = new JSONRepresentationOfDicomObjectFactory().getDocument(string, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9, bl10);
                if (string2 == null) {
                    JSONRepresentationOfDicomObjectFactory.write(System.out, (JsonArray)object);
                } else {
                    JSONRepresentationOfDicomObjectFactory.write(string2, (JsonArray)object);
                }
            } else {
                object = new JSONRepresentationOfDicomObjectFactory().getAttributeList(string);
                String string3 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.SourceApplicationEntityTitle);
                ((AttributeList)object).insertSuitableSpecificCharacterSetForAllStringValues();
                ((AttributeList)object).removeMetaInformationHeaderAttributes();
                FileMetaInformation.addFileMetaInformation((AttributeList)object, "1.2.840.10008.1.2.1", string3);
                if (string2 == null) {
                    ((AttributeList)object).write(System.out, "1.2.840.10008.1.2.1", true, true);
                } else {
                    ((AttributeList)object).write(string2, "1.2.840.10008.1.2.1", true, true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

