/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.ContentItemWithReference;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.JSONRepresentationOfDicomObjectFactory;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;

public class JSONRepresentationOfStructuredReportObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/JSONRepresentationOfStructuredReportObjectFactory.java,v 1.34 2025/01/29 10:58:06 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(JSONRepresentationOfStructuredReportObjectFactory.class);
    protected static boolean elideSeparateContinuityOfContent = true;
    protected static boolean collapseAttributeValueArrays = true;
    protected static boolean collapseEmptyToNull = true;
    protected static boolean collapseContentTreeArrays = true;
    protected static boolean substituteUIDKeywords = true;
    protected static boolean useNumberForNumericContentItemValue = false;
    protected static String symbolSignifyingReservedKeyword = "_";
    protected static String businessNameToUseForAnonymousContentItems = symbolSignifyingReservedKeyword + "unnamed";
    protected static String reservedKeywordForCodeValueInBusinessNamesFile = symbolSignifyingReservedKeyword + "cv";
    protected static String reservedKeywordForCodingSchemeDesignatorInBusinessNamesFile = symbolSignifyingReservedKeyword + "csd";
    protected static String reservedKeywordForCodeMeaningInBusinessNamesFile = symbolSignifyingReservedKeyword + "cm";
    protected static String reservedKeywordForValueTypeInBusinessNamesFile = symbolSignifyingReservedKeyword + "vt";
    protected static String reservedKeywordForRelationshipTypeInBusinessNamesFile = symbolSignifyingReservedKeyword + "rel";
    protected static String reservedKeywordForCodingSchemeVersionInBusinessNamesFile = symbolSignifyingReservedKeyword + "csv";
    protected static String reservedKeywordForLongCodeValueInBusinessNamesFile = symbolSignifyingReservedKeyword + "lcv";
    protected static String reservedKeywordForURNCodeValueInBusinessNamesFile = symbolSignifyingReservedKeyword + "urncv";
    protected static String reservedKeywordForContextIdentifierInBusinessNamesFile = symbolSignifyingReservedKeyword + "cid";
    protected static String reservedKeywordForContextUIDInBusinessNamesFile = symbolSignifyingReservedKeyword + "cuid";
    protected static String reservedKeywordForMappingResourceInBusinessNamesFile = symbolSignifyingReservedKeyword + "cmr";
    protected static String reservedKeywordForMappingResourceUIDInBusinessNamesFile = symbolSignifyingReservedKeyword + "cmruid";
    protected static String reservedKeywordForMappingResourceNameInBusinessNamesFile = symbolSignifyingReservedKeyword + "cmrname";
    protected static String reservedKeywordForContextGroupVersionInBusinessNamesFile = symbolSignifyingReservedKeyword + "cvers";
    protected static String reservedKeywordForContextGroupExtensionFlagInBusinessNamesFile = symbolSignifyingReservedKeyword + "cext";
    protected static String reservedKeywordForContextGroupLocalVersionInBusinessNamesFile = symbolSignifyingReservedKeyword + "clocvers";
    protected static String reservedKeywordForContextGroupExtensionCreatorUIDInBusinessNamesFile = symbolSignifyingReservedKeyword + "cextcruid";
    protected static String reservedKeywordForObservationDateTimeAttributeInSRFile = symbolSignifyingReservedKeyword + "obsdt";
    protected static String reservedKeywordForObservationUIDAttributeInSRFile = symbolSignifyingReservedKeyword + "obsuid";
    protected static String reservedKeywordForContinuityOfContentAttributeInSRFile = symbolSignifyingReservedKeyword + "cont";
    protected static String reservedKeywordForTemplateMappingResourceAttributeInSRFile = symbolSignifyingReservedKeyword + "tmr";
    protected static String reservedKeywordForTemplateIdentifierAttributeInSRFile = symbolSignifyingReservedKeyword + "tid";
    protected static String reservedKeywordForSimplifiedLabelAttributeInSRFile = symbolSignifyingReservedKeyword + "label";
    protected static String reservedKeywordForSimplifiedReferenceToLabelAttributeInSRFile = symbolSignifyingReservedKeyword + "ref";
    protected static String reservedKeywordForReferencedSOPClassUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "class";
    protected static String reservedKeywordForReferencedSOPInstanceUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "instance";
    protected static String reservedKeywordForReferencedFrameNumberAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "frame";
    protected static String reservedKeywordForReferencedSegmentNumberAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "segment";
    protected static String reservedKeywordForPresentationStateSOPClassUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "prclass";
    protected static String reservedKeywordForPresentationStateSOPInstanceUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "prinstance";
    protected static String reservedKeywordForRealWorldValueMappingSOPClassUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "rwvmclass";
    protected static String reservedKeywordForRealWorldValueMappingSOPInstanceUIDAttributeInCompositeContentItem = symbolSignifyingReservedKeyword + "rwvminstance";
    protected static String reservedKeywordForGraphicTypeAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "gtype";
    protected static String reservedKeywordFor2DCoordinatesAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "coord2d";
    protected static String reservedKeywordFor3DCoordinatesAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "coord3d";
    protected static String reservedKeywordForPixelOriginInterpretationAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "origin";
    protected static String reservedKeywordForFiducialUIDAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "fiducial";
    protected static String reservedKeywordForReferencedFrameOfReferenceUIDAttributeInCoordinatesContentItem = symbolSignifyingReservedKeyword + "for";
    protected static String reservedKeywordForMeasurementUnitsAttributeInNumericContentItem = symbolSignifyingReservedKeyword + "units";
    protected static String reservedKeywordForFloatingPointValueAttributeInNumericContentItem = symbolSignifyingReservedKeyword + "float";
    protected static String reservedKeywordForRationalNumeratorAttributeInNumericContentItem = symbolSignifyingReservedKeyword + "numerator";
    protected static String reservedKeywordForRationalDenominatorAttributeInNumericContentItem = symbolSignifyingReservedKeyword + "denominator";
    protected static String reservedKeywordForNumericValueQualifierAttributeInNumericContentItem = symbolSignifyingReservedKeyword + "numqual";
    protected static String reservedKeywordForAlphabeticPropertyInPersonNameContentItem = symbolSignifyingReservedKeyword + "alphabetic";
    protected static String reservedKeywordForIdeographicPropertyInPersonNameContentItem = symbolSignifyingReservedKeyword + "ideographic";
    protected static String reservedKeywordForPhoneticPropertyInPersonNameContentItem = symbolSignifyingReservedKeyword + "phonetic";
    protected static String simplifiedLabelPrefix = "label";
    private JsonBuilderFactory factory;
    protected Map<String, CodedSequenceItem> businessNames = new HashMap<String, CodedSequenceItem>();
    protected Map<String, SortedSet<String>> valueTypesByBusinessName = new HashMap<String, SortedSet<String>>();
    protected Map<String, SortedSet<String>> relationshipTypesByBusinessName = new HashMap<String, SortedSet<String>>();
    protected Map<ContentItem, String> contentItemIdentifiersByContentItem = new HashMap<ContentItem, String>();
    protected Map<String, String> simplifiedLabelByReferencedContentItemIdentifiers = new HashMap<String, String>();
    protected int simplifiedLabelCounter = 0;
    protected ContentItemFactory contentItemFactory;
    protected Map<String, String> referencedContentItemIdentifiersBySimplifiedLabel = new HashMap<String, String>();

    protected boolean isCommonAnnotationAttribute(String string) {
        return string != null && string.length() > 0 && (string.equals(reservedKeywordForSimplifiedLabelAttributeInSRFile) || string.equals(reservedKeywordForSimplifiedReferenceToLabelAttributeInSRFile) || string.equals(reservedKeywordForObservationDateTimeAttributeInSRFile) || string.equals(reservedKeywordForObservationUIDAttributeInSRFile));
    }

    public static String makeBusinessNameFromCodeMeaning(String string, boolean bl) {
        String string2 = businessNameToUseForAnonymousContentItems;
        if (string != null && string.length() > 0) {
            string2 = string.replaceAll("[^A-Za-z0-9]", " ");
            if (bl) {
                string2 = StringUtilities.toUpperCamelCase(string2);
            }
            string2 = string2.replaceAll(" ", "");
        }
        return string2;
    }

    public static String makeBusinessNameFromCodeMeaning(CodedSequenceItem codedSequenceItem) {
        return codedSequenceItem == null ? businessNameToUseForAnonymousContentItems : JSONRepresentationOfStructuredReportObjectFactory.makeBusinessNameFromCodeMeaning(codedSequenceItem.getCodeMeaning(), !"UCUM".equals(codedSequenceItem.getCodingSchemeDesignator()));
    }

    public CodedSequenceItem getCodedSequenceItemForBusinessName(String string, String string2, boolean bl) {
        CodedSequenceItem codedSequenceItem = null;
        if (string == null) {
            slf4jlogger.error("getCodedSequenceItemForBusinessNameUsedAsConceptName(): {}: Null string for business name used as concept name", string2);
        } else if (string.length() == 0) {
            slf4jlogger.warn("getCodedSequenceItemForBusinessNameUsedAsConceptName(): {}: Empty string for business name used as concept name - should be using reserved word instead ", string2);
        } else if (string.equals(businessNameToUseForAnonymousContentItems)) {
            if (bl) {
                slf4jlogger.debug("getCodedSequenceItemForBusinessNameUsedAsConceptName(): {}: Encountered reserved anonymous business name keyword used as concept name {} ", string2, string);
            } else {
                slf4jlogger.error("getCodedSequenceItemForBusinessNameUsedAsValue(): {}: Cannot use reserved anonymous business name keyword as concept value {} ", string2, string);
            }
        } else {
            codedSequenceItem = this.businessNames.get(string);
            if (codedSequenceItem == null) {
                slf4jlogger.error("getCodedSequenceItemForBusinessNameUsedAsConceptName(): {}: Could not find a code for business name used as concept name {} ", string2, string);
            } else {
                slf4jlogger.debug("getCodedSequenceItemForBusinessNameUsedAsConceptName(): {}: Code for business name used as concept name {} is {}", string2, string, codedSequenceItem.toString());
            }
        }
        return codedSequenceItem;
    }

    public CodedSequenceItem getCodedSequenceItemForBusinessNameUsedAsConceptName(String string, String string2) {
        return this.getCodedSequenceItemForBusinessName(string, string2, true);
    }

    public CodedSequenceItem getCodedSequenceItemForBusinessNameUsedAsValue(String string, String string2) {
        return this.getCodedSequenceItemForBusinessName(string, string2, false);
    }

    public CodedSequenceItem getCodedSequenceItemForBusinessNameUsedAsUnits(String string, String string2) {
        return this.getCodedSequenceItemForBusinessName(string, string2, false);
    }

    public JsonArray getBusinessNamesDocument() {
        slf4jlogger.debug("getBusinessNamesDocument():");
        JsonArrayBuilder jsonArrayBuilder = this.factory.createArrayBuilder();
        for (String string : this.businessNames.keySet()) {
            JsonArrayBuilder jsonArrayBuilder2;
            CodedSequenceItem codedSequenceItem = this.businessNames.get(string);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("getBusinessNamesDocument(): Creating JSON business name {} for {}", string, codedSequenceItem);
            }
            JsonObjectBuilder jsonObjectBuilder = this.factory.createObjectBuilder();
            jsonObjectBuilder.add(reservedKeywordForCodeValueInBusinessNamesFile, codedSequenceItem.getCodeValue());
            jsonObjectBuilder.add(reservedKeywordForCodingSchemeDesignatorInBusinessNamesFile, codedSequenceItem.getCodingSchemeDesignator());
            jsonObjectBuilder.add(reservedKeywordForCodeMeaningInBusinessNamesFile, codedSequenceItem.getCodeMeaning());
            JsonObjectBuilder jsonObjectBuilder2 = codedSequenceItem.getCodingSchemeVersion();
            if (jsonObjectBuilder2.length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForCodingSchemeVersionInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("LongCodeValue"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForLongCodeValueInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("URNCodeValue"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForURNCodeValueInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextIdentifier"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextIdentifierInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextUID"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextUIDInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("MappingResource"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForMappingResourceInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("MappingResourceUID"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForMappingResourceUIDInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("MappingResourceName"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForMappingResourceNameInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupVersion"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextGroupVersionInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionFlag"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextGroupExtensionFlagInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupLocalVersion"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextGroupLocalVersionInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = Attribute.getSingleStringValueOrEmptyString(codedSequenceItem.getAttributeList(), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionCreatorUID"))).length() > 0) {
                jsonObjectBuilder.add(reservedKeywordForContextGroupExtensionCreatorUIDInBusinessNamesFile, (String)jsonObjectBuilder2);
            }
            if ((jsonObjectBuilder2 = this.valueTypesByBusinessName.get(string)) != null && jsonObjectBuilder2.size() > 0) {
                jsonArrayBuilder2 = this.factory.createArrayBuilder();
                for (String string2 : jsonObjectBuilder2) {
                    if (string2 == null || string2.length() <= 0) continue;
                    jsonArrayBuilder2.add(string2);
                }
                jsonObjectBuilder.add(reservedKeywordForValueTypeInBusinessNamesFile, jsonArrayBuilder2);
            }
            if ((jsonObjectBuilder2 = this.relationshipTypesByBusinessName.get(string)) != null && jsonObjectBuilder2.size() > 0) {
                jsonArrayBuilder2 = this.factory.createArrayBuilder();
                for (String string2 : jsonObjectBuilder2) {
                    if (string2 == null || string2.length() <= 0) continue;
                    jsonArrayBuilder2.add(string2);
                }
                jsonObjectBuilder.add(reservedKeywordForRelationshipTypeInBusinessNamesFile, jsonArrayBuilder2);
            }
            jsonObjectBuilder2 = this.factory.createObjectBuilder();
            jsonObjectBuilder2.add(string, jsonObjectBuilder);
            jsonArrayBuilder.add(jsonObjectBuilder2);
        }
        return jsonArrayBuilder.build();
    }

    protected void addCodedSequenceItemPropertyFromBusinessName(JsonObject jsonObject, AttributeList attributeList, AttributeTag attributeTag, String string) {
        String string2;
        JsonString jsonString = (JsonString)jsonObject.get((Object)string);
        if (jsonString != null && (string2 = jsonString.getString()) != null && string2.length() > 0) {
            try {
                Attribute attribute = AttributeFactory.newAttribute(attributeTag);
                attribute.addValue(string2);
                attributeList.put(attribute);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("addCodedSequenceItemPropertyFromBusinessName(): Failed to construct CodedSequenceItem AttributeList Attribute for {} from {} with value {}: {}", attributeTag, string, string2, dicomException);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadBusinessNamesDocument(JsonArray jsonArray) throws DicomException {
        for (int i = 0; i < jsonArray.size(); ++i) {
            try {
                JsonObject jsonObject = jsonArray.getJsonObject(i);
                if (jsonObject == null) throw new DicomException("Missing business name entry # " + i);
                String string = (String)jsonObject.keySet().iterator().next();
                if (string == null || string.length() <= 0) throw new DicomException("Missing or bad business name " + string + " in entry # " + i);
                try {
                    JsonObject jsonObject2 = (JsonObject)jsonObject.get((Object)string);
                    try {
                        JsonString jsonString = (JsonString)jsonObject2.get((Object)reservedKeywordForCodeValueInBusinessNamesFile);
                        if (jsonString == null) throw new DicomException("Unrecognized business name pattern entry for business name " + string);
                        String string2 = jsonString.getString();
                        String string3 = null;
                        String string4 = null;
                        Object object = (JsonString)jsonObject2.get((Object)reservedKeywordForCodingSchemeDesignatorInBusinessNamesFile);
                        if (object == null) {
                            throw new DicomException("Missing " + reservedKeywordForCodingSchemeDesignatorInBusinessNamesFile + " for code " + string2 + " for business name " + string);
                        }
                        string3 = object.getString();
                        object = (JsonString)jsonObject2.get((Object)reservedKeywordForCodeMeaningInBusinessNamesFile);
                        if (object == null) {
                            throw new DicomException("Missing " + reservedKeywordForCodeMeaningInBusinessNamesFile + " for code " + string2 + " for business name " + string);
                        }
                        string4 = object.getString();
                        if (string2 == null || string2.length() <= 0 || string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) throw new DicomException("Incomplete code value, coding scheme designator or code meaning for code " + string2 + " for business name " + string);
                        object = new CodedSequenceItem(string2, string3, string4);
                        SortedSet<Object> sortedSet = ((CodedSequenceItem)object).getAttributeList();
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), TagFromName.CodingSchemeVersion, reservedKeywordForCodingSchemeVersionInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("LongCodeValue"), reservedKeywordForLongCodeValueInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("URNCodeValue"), reservedKeywordForURNCodeValueInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextIdentifier"), reservedKeywordForContextIdentifierInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextUID"), reservedKeywordForContextUIDInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("MappingResource"), reservedKeywordForMappingResourceInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("MappingResourceUID"), reservedKeywordForMappingResourceUIDInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("MappingResourceName"), reservedKeywordForMappingResourceNameInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupVersion"), reservedKeywordForContextGroupVersionInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionFlag"), reservedKeywordForContextGroupExtensionFlagInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupLocalVersion"), reservedKeywordForContextGroupLocalVersionInBusinessNamesFile);
                        this.addCodedSequenceItemPropertyFromBusinessName(jsonObject2, (AttributeList)((Object)sortedSet), DicomDictionary.StandardDictionary.getTagFromName("ContextGroupExtensionCreatorUID"), reservedKeywordForContextGroupExtensionCreatorUIDInBusinessNamesFile);
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("loadBusinessNamesDocument(): Loading JSON business name {} for {}", string, object);
                        }
                        this.businessNames.put(string, (CodedSequenceItem)object);
                        try {
                            string2 = (JsonArray)jsonObject2.get((Object)reservedKeywordForValueTypeInBusinessNamesFile);
                            if (string2 != null) {
                                for (int j = 0; j < string2.size(); ++j) {
                                    string4 = (JsonValue)string2.get(j);
                                    try {
                                        object = ((JsonString)string4).getString();
                                        if (object == null || ((String)object).length() <= 0) throw new DicomException("Empty or missing value type for business name " + string);
                                        sortedSet = this.valueTypesByBusinessName.get(string);
                                        if (sortedSet == null) {
                                            sortedSet = new TreeSet<Object>();
                                            this.valueTypesByBusinessName.put(string, sortedSet);
                                        }
                                        sortedSet.add(object);
                                        continue;
                                    }
                                    catch (ClassCastException classCastException) {
                                        throw new DicomException("String value type required in array for business name " + string);
                                    }
                                }
                            }
                        }
                        catch (ClassCastException classCastException) {
                            throw new DicomException("Array of value types required for business name " + string);
                        }
                        try {
                            string2 = (JsonArray)jsonObject2.get((Object)reservedKeywordForRelationshipTypeInBusinessNamesFile);
                            if (string2 == null) continue;
                            for (int j = 0; j < string2.size(); ++j) {
                                string4 = (JsonValue)string2.get(j);
                                try {
                                    object = ((JsonString)string4).getString();
                                    if (object == null || ((String)object).length() <= 0) throw new DicomException("Empty or missing relationship type for business name " + string);
                                    sortedSet = this.relationshipTypesByBusinessName.get(string);
                                    if (sortedSet == null) {
                                        sortedSet = new TreeSet();
                                        this.relationshipTypesByBusinessName.put(string, sortedSet);
                                    }
                                    sortedSet.add(object);
                                    continue;
                                }
                                catch (ClassCastException classCastException) {
                                    throw new DicomException("String relationship type required in array for business name " + string);
                                }
                            }
                            continue;
                        }
                        catch (ClassCastException classCastException) {
                            throw new DicomException("Array of relationship types required for business name " + string);
                        }
                    }
                    catch (ClassCastException classCastException) {
                        throw new DicomException("Expected strings for values of business name entry # " + i);
                    }
                }
                catch (ClassCastException classCastException) {
                    throw new DicomException("Expected object as value of business name " + string + " entry # " + i);
                }
            }
            catch (ClassCastException classCastException) {
                throw new DicomException("Expected object for business name entry # " + i);
            }
        }
    }

    public void loadBusinessNamesDocument(InputStream inputStream) throws IOException, DicomException {
        JsonReader jsonReader = Json.createReader((InputStream)inputStream);
        JsonArray jsonArray = jsonReader.readArray();
        jsonReader.close();
        this.loadBusinessNamesDocument(jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadBusinessNamesDocument(File file) throws IOException, DicomException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try {
            this.loadBusinessNamesDocument(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
    }

    public void loadBusinessNamesDocument(String string) throws IOException, DicomException {
        this.loadBusinessNamesDocument(new File(string));
    }

    protected void walkTreeBuildingSimplifiedLabelsForReferencedContentItemIdentifiers(ContentItem contentItem, String string) {
        if (contentItem != null) {
            String string2;
            this.contentItemIdentifiersByContentItem.put(contentItem, string);
            String string3 = contentItem.getReferencedContentItemIdentifier();
            if (string3 != null && string3.length() > 0 && (string2 = this.simplifiedLabelByReferencedContentItemIdentifiers.get(string3)) == null) {
                string2 = simplifiedLabelPrefix + Integer.toString(++this.simplifiedLabelCounter);
                this.simplifiedLabelByReferencedContentItemIdentifiers.put(string3, string2);
                slf4jlogger.debug("walkTreeBuildingSimplifiedLabelsForReferencedContentItemIdentifierswalkTreeBuildingSimplifiedLabelsForReferencedContentItemIdentifiers(): reference to {} is assigned simplified label {}", string3, string2);
            }
            int n = contentItem.getChildCount();
            for (int i = 0; i < n; ++i) {
                this.walkTreeBuildingSimplifiedLabelsForReferencedContentItemIdentifiers((ContentItem)contentItem.getChildAt(i), string + "." + Integer.toString(i + 1));
            }
        }
    }

    private void addContentItemAndChildrenToJsonObject(ContentItem contentItem, JsonObjectBuilder jsonObjectBuilder) throws DicomException {
        if (contentItem != null) {
            String string;
            Object object;
            int n = contentItem.getChildCount();
            JsonArrayBuilder jsonArrayBuilder = null;
            Object object2 = null;
            String string2 = contentItem.getValueType();
            String string3 = contentItem.getRelationshipType();
            CodedSequenceItem codedSequenceItem = contentItem.getConceptName();
            String string4 = JSONRepresentationOfStructuredReportObjectFactory.makeBusinessNameFromCodeMeaning(codedSequenceItem);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): businessName is {} for conceptName {}", string4, codedSequenceItem);
            }
            if (codedSequenceItem != null && string4 != null && string4.length() > 0) {
                this.businessNames.put(string4, codedSequenceItem);
            }
            if (string2 != null && string2.length() > 0) {
                object = this.valueTypesByBusinessName.get(string4);
                if (object == null) {
                    object = new TreeSet<String>();
                    this.valueTypesByBusinessName.put(string4, (SortedSet<String>)object);
                }
                object.add((String)string2);
            }
            if (string3 != null && string3.length() > 0) {
                object = this.relationshipTypesByBusinessName.get(string4);
                if (object == null) {
                    object = new TreeSet<String>();
                    this.relationshipTypesByBusinessName.put(string4, (SortedSet<String>)object);
                }
                object.add((String)string3);
            }
            object = null;
            String string5 = this.contentItemIdentifiersByContentItem.get(contentItem);
            slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): contentItemIdentifier {} for businessName {}", string5, string4);
            Object object3 = this.simplifiedLabelByReferencedContentItemIdentifiers.get(string5);
            slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): contentItemIdentifier {} has simplifiedLabel {}", string5, object3);
            if (object3 != null) {
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                object.add(reservedKeywordForSimplifiedLabelAttributeInSRFile, (String)object3);
            }
            object3 = contentItem.getObservationDateTime();
            Object object4 = contentItem.getObservationUID();
            if (object3 != null && ((String)object3).length() > 0 || object4 != null && ((String)object4).length() > 0) {
                slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): adding generic contentItemAttributesObject to {}", string5);
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                if (object3 != null && ((String)object3).length() > 0) {
                    object.add(reservedKeywordForObservationDateTimeAttributeInSRFile, (String)object3);
                }
                if (object4 != null && ((String)object4).length() > 0) {
                    object.add(reservedKeywordForObservationUIDAttributeInSRFile, (String)object4);
                }
            }
            if (contentItem instanceof ContentItemFactory.ContainerContentItem) {
                object3 = ((ContentItemFactory.ContainerContentItem)contentItem).getContinuityOfContent();
                object4 = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateMappingResource();
                string = ((ContentItemFactory.ContainerContentItem)contentItem).getTemplateIdentifier();
                if (object3 != null && ((String)object3).length() > 0 && !elideSeparateContinuityOfContent || !((String)object3).equals("SEPARATE") || object4 != null && ((String)object4).length() > 0 || string != null && string.length() > 0) {
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): adding Container contentItemAttributesObject to {}", string5);
                    if (object == null) {
                        object = this.factory.createObjectBuilder();
                    }
                    if (object3 != null && ((String)object3).length() > 0 && !elideSeparateContinuityOfContent || !((String)object3).equals("SEPARATE")) {
                        object.add(reservedKeywordForContinuityOfContentAttributeInSRFile, (String)object3);
                    }
                    if (object4 != null && ((String)object4).length() > 0) {
                        object.add(reservedKeywordForTemplateMappingResourceAttributeInSRFile, (String)object4);
                    }
                    if (string != null && string.length() > 0) {
                        object.add(reservedKeywordForTemplateIdentifierAttributeInSRFile, string);
                    }
                }
                if (object != null) {
                    if (jsonArrayBuilder == null) {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                    }
                    jsonArrayBuilder.add(object);
                }
            } else if (contentItem instanceof ContentItemFactory.CodeContentItem) {
                if (object != null) {
                    if (jsonArrayBuilder == null) {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                    }
                    jsonArrayBuilder.add(object);
                }
                if ((object3 = ((ContentItemFactory.CodeContentItem)contentItem).getConceptCode()) != null && (object4 = JSONRepresentationOfStructuredReportObjectFactory.makeBusinessNameFromCodeMeaning((CodedSequenceItem)object3)) != null && ((String)object4).length() > 0) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): businessNameForConceptCode is {} for conceptCode {}", object4, object3);
                    }
                    this.businessNames.put((String)object4, (CodedSequenceItem)object3);
                    if (collapseContentTreeArrays && n == 0 && object == null) {
                        object2 = object4;
                    } else {
                        if (jsonArrayBuilder == null) {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                        }
                        jsonArrayBuilder.add((String)object4);
                    }
                }
            } else if (contentItem instanceof ContentItemFactory.NumericContentItem) {
                String string6;
                Object object5;
                object3 = (ContentItemFactory.NumericContentItem)contentItem;
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                object4 = ((ContentItemFactory.NumericContentItem)contentItem).getUnits();
                String string7 = null;
                if (object4 != null && (string7 = JSONRepresentationOfStructuredReportObjectFactory.makeBusinessNameFromCodeMeaning((CodedSequenceItem)object4)) != null && string7.length() > 0) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): businessNameForUnitsCode is {} for conceptCode {}", string7, object4);
                    }
                    this.businessNames.put(string7, (CodedSequenceItem)object4);
                    object.add(reservedKeywordForMeasurementUnitsAttributeInNumericContentItem, string7);
                }
                if (((ContentItemFactory.NumericContentItem)object3).hasFloatingPointValue()) {
                    double d = ((ContentItemFactory.NumericContentItem)object3).getFloatingPointValue();
                    object.add(reservedKeywordForFloatingPointValueAttributeInNumericContentItem, d);
                }
                if (((ContentItemFactory.NumericContentItem)object3).hasRationalValue()) {
                    int n2 = ((ContentItemFactory.NumericContentItem)object3).getRationalNumeratorValue();
                    object.add(reservedKeywordForRationalNumeratorAttributeInNumericContentItem, n2);
                    long l = ((ContentItemFactory.NumericContentItem)object3).getRationalDenominatorValue();
                    object.add(reservedKeywordForRationalDenominatorAttributeInNumericContentItem, l);
                }
                if ((object5 = ((ContentItemFactory.NumericContentItem)object3).getQualifier()) != null && (string6 = JSONRepresentationOfStructuredReportObjectFactory.makeBusinessNameFromCodeMeaning((CodedSequenceItem)object5)) != null && string6.length() > 0) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): businessNameForQualifierCode is {} for conceptCode {}", string6, object5);
                    }
                    this.businessNames.put(string6, (CodedSequenceItem)object5);
                    object.add(reservedKeywordForNumericValueQualifierAttributeInNumericContentItem, string6);
                }
                if (jsonArrayBuilder == null) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                }
                jsonArrayBuilder.add(object);
                if (useNumberForNumericContentItemValue) {
                    if (((ContentItemFactory.NumericContentItem)object3).hasFloatingPointValue()) {
                        double d = ((ContentItemFactory.NumericContentItem)object3).getFloatingPointValue();
                        slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): useNumberForNumericContentItemValue: adding getFloatingPointValue() numeric value {} for businessName {}", d, string4);
                        if (jsonArrayBuilder == null) {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                        }
                        jsonArrayBuilder.add(d);
                    } else {
                        object5 = ((ContentItemFactory.NumericContentItem)object3).getNumericValue();
                        if (object5 != null && ((String)object5).length() > 0) {
                            try {
                                double d = Double.parseDouble((String)object5);
                                slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): useNumberForNumericContentItemValue: adding Double.parseDouble() numeric value {} from decimal string {} for businessName {}", d, object5, string4);
                                if (jsonArrayBuilder == null) {
                                    jsonArrayBuilder = this.factory.createArrayBuilder();
                                }
                                jsonArrayBuilder.add(d);
                            }
                            catch (NumberFormatException numberFormatException) {
                                slf4jlogger.error("addContentItemAndChildrenToJsonObject(): numeric value {} is not valid decimal string for businessName {}", object5, string4);
                            }
                        }
                    }
                } else {
                    object5 = ((ContentItemFactory.NumericContentItem)object3).getNumericValue();
                    if (object5 != null && ((String)object5).length() > 0) {
                        if (jsonArrayBuilder == null) {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                        }
                        jsonArrayBuilder.add((String)object5);
                    }
                }
            } else if (contentItem instanceof ContentItemFactory.PersonNameContentItem) {
                object3 = (ContentItemFactory.PersonNameContentItem)contentItem;
                object4 = ((ContentItemFactory.PersonNameContentItem)object3).getConceptValue();
                if (object4 != null && ((String)object4).length() > 0) {
                    if (object == null) {
                        object = this.factory.createObjectBuilder();
                    }
                    JSONRepresentationOfDicomObjectFactory.addPersonNameAsComponentsToJsonObject(object, (String)object4, reservedKeywordForAlphabeticPropertyInPersonNameContentItem, reservedKeywordForIdeographicPropertyInPersonNameContentItem, reservedKeywordForPhoneticPropertyInPersonNameContentItem);
                }
                if (object != null) {
                    if (jsonArrayBuilder == null) {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                    }
                    jsonArrayBuilder.add(object);
                }
            } else if (contentItem instanceof ContentItemFactory.StringContentItem) {
                if (object != null) {
                    if (jsonArrayBuilder == null) {
                        jsonArrayBuilder = this.factory.createArrayBuilder();
                    }
                    jsonArrayBuilder.add(object);
                }
                if ((object3 = ((ContentItemFactory.StringContentItem)contentItem).getConceptValue().trim()) != null && ((String)object3).length() > 0) {
                    if (collapseContentTreeArrays && n == 0 && object == null) {
                        object2 = object3;
                    } else {
                        if (jsonArrayBuilder == null) {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                        }
                        jsonArrayBuilder.add((String)object3);
                    }
                }
            } else if (contentItem instanceof ContentItemFactory.SpatialCoordinatesContentItem) {
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                if ((object3 = ((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicType()) != null && (object4 = (Object)((ContentItemFactory.SpatialCoordinatesContentItem)contentItem).getGraphicData()) != null) {
                    JsonArrayBuilder jsonArrayBuilder2 = this.factory.createArrayBuilder();
                    for (int i = 0; i < ((Object)object4).length; ++i) {
                        jsonArrayBuilder2.add((double)object4[i]);
                    }
                    object.add(reservedKeywordForGraphicTypeAttributeInCoordinatesContentItem, (String)object3);
                    object.add(reservedKeywordFor2DCoordinatesAttributeInCoordinatesContentItem, jsonArrayBuilder2);
                }
                if (jsonArrayBuilder == null) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                }
                jsonArrayBuilder.add(object);
            } else if (contentItem instanceof ContentItemFactory.SpatialCoordinates3DContentItem) {
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                if ((object3 = ((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getGraphicType()) != null && (object4 = (Object)((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getGraphicData()) != null) {
                    JsonArrayBuilder jsonArrayBuilder3 = this.factory.createArrayBuilder();
                    for (int i = 0; i < ((Object)object4).length; ++i) {
                        jsonArrayBuilder3.add((double)object4[i]);
                    }
                    String string8 = ((ContentItemFactory.SpatialCoordinates3DContentItem)contentItem).getReferencedFrameOfReferenceUID();
                    object.add(reservedKeywordForGraphicTypeAttributeInCoordinatesContentItem, (String)object3);
                    object.add(reservedKeywordFor3DCoordinatesAttributeInCoordinatesContentItem, jsonArrayBuilder3);
                    object.add(reservedKeywordForReferencedFrameOfReferenceUIDAttributeInCoordinatesContentItem, string8);
                }
                if (jsonArrayBuilder == null) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                }
                jsonArrayBuilder.add(object);
            } else if (contentItem instanceof ContentItemFactory.CompositeContentItem) {
                if (object == null) {
                    object = this.factory.createObjectBuilder();
                }
                object3 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPClassUID();
                object3 = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndRequested((String)object3, substituteUIDKeywords);
                object4 = ((ContentItemFactory.CompositeContentItem)contentItem).getReferencedSOPInstanceUID();
                if (object3 != null && ((String)object3).length() > 0) {
                    object.add(reservedKeywordForReferencedSOPClassUIDAttributeInCompositeContentItem, (String)object3);
                } else {
                    slf4jlogger.error("addContentItemAndChildrenToJsonObject(): composite family content item missing or empty ReferencedSOPClassUID");
                }
                if (object4 != null && ((String)object4).length() > 0) {
                    object.add(reservedKeywordForReferencedSOPInstanceUIDAttributeInCompositeContentItem, (String)object4);
                } else {
                    slf4jlogger.error("addContentItemAndChildrenToJsonObject(): composite family content item missing or empty ReferencedSOPClassUID");
                }
                if (contentItem instanceof ContentItemFactory.ImageContentItem) {
                    ContentItemFactory.ImageContentItem imageContentItem = (ContentItemFactory.ImageContentItem)contentItem;
                    int n3 = imageContentItem.getReferencedFrameNumber();
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item referencedFrameNumber {}", n3);
                    if (n3 != 0) {
                        object.add(reservedKeywordForReferencedFrameNumberAttributeInCompositeContentItem, n3);
                    }
                    int n4 = imageContentItem.getReferencedSegmentNumber();
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item referencedSegmentNumber {}", n4);
                    if (n4 != 0) {
                        object.add(reservedKeywordForReferencedSegmentNumberAttributeInCompositeContentItem, n4);
                    }
                    String string9 = imageContentItem.getPresentationStateSOPClassUID();
                    string9 = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndRequested(string9, substituteUIDKeywords);
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item presentationStateSOPClassUID {}", string9);
                    if (string9 != null && string9.length() > 0) {
                        object.add(reservedKeywordForPresentationStateSOPClassUIDAttributeInCompositeContentItem, string9);
                    }
                    String string10 = imageContentItem.getPresentationStateSOPInstanceUID();
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item presentationStateSOPInstanceUID {}", string10);
                    if (string10 != null && string10.length() > 0) {
                        object.add(reservedKeywordForPresentationStateSOPInstanceUIDAttributeInCompositeContentItem, string10);
                    }
                    String string11 = imageContentItem.getRealWorldValueMappingSOPClassUID();
                    string11 = JSONRepresentationOfDicomObjectFactory.substituteKeywordForUIDIfPossibleAndRequested(string11, substituteUIDKeywords);
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item realWorldValueMappingSOPClassUID {}", string11);
                    if (string11 != null && string11.length() > 0) {
                        object.add(reservedKeywordForRealWorldValueMappingSOPClassUIDAttributeInCompositeContentItem, string11);
                    }
                    String string12 = imageContentItem.getRealWorldValueMappingSOPInstanceUID();
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): IMAGE content item realWorldValueMappingSOPInstanceUID {}", string12);
                    if (string12 != null && string12.length() > 0) {
                        object.add(reservedKeywordForRealWorldValueMappingSOPInstanceUIDAttributeInCompositeContentItem, string12);
                    }
                }
                if (jsonArrayBuilder == null) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                }
                jsonArrayBuilder.add(object);
            } else {
                object3 = contentItem.getReferencedContentItemIdentifier();
                if (object3 != null && ((String)object3).length() > 0) {
                    object4 = this.simplifiedLabelByReferencedContentItemIdentifiers.get(object3);
                    if (object4 != null && ((String)object4).length() > 0) {
                        if (object == null) {
                            object = this.factory.createObjectBuilder();
                        }
                        object.add(reservedKeywordForSimplifiedReferenceToLabelAttributeInSRFile, (String)object4);
                    }
                    if (object != null) {
                        if (jsonArrayBuilder == null) {
                            jsonArrayBuilder = this.factory.createArrayBuilder();
                        }
                        jsonArrayBuilder.add(object);
                    }
                } else {
                    slf4jlogger.debug("addContentItemAndChildrenToJsonObject(): Content item {} value type {} conversion to JSON not yet supported", string5, string2);
                }
            }
            if (n > 0) {
                object3 = this.factory.createArrayBuilder();
                for (int i = 0; i < n; ++i) {
                    string = this.factory.createObjectBuilder();
                    this.addContentItemAndChildrenToJsonObject((ContentItem)contentItem.getChildAt(i), (JsonObjectBuilder)string);
                    object3.add((JsonObjectBuilder)string);
                }
                if (jsonArrayBuilder == null) {
                    jsonArrayBuilder = this.factory.createArrayBuilder();
                }
                jsonArrayBuilder.add((JsonArrayBuilder)object3);
            }
            if (jsonArrayBuilder != null) {
                jsonObjectBuilder.add(string4, jsonArrayBuilder);
            } else if (object2 != null) {
                jsonObjectBuilder.add(string4, object2);
            }
        }
    }

    public JSONRepresentationOfStructuredReportObjectFactory() {
        this.factory = Json.createBuilderFactory(null);
    }

    public JsonArray getDocument(AttributeList attributeList) throws DicomException {
        return this.getDocument(null, attributeList);
    }

    public JsonArray getDocument(StructuredReport structuredReport) throws DicomException {
        return this.getDocument(structuredReport, null);
    }

    public JsonArray getDocument(StructuredReport structuredReport, AttributeList attributeList) throws DicomException {
        JsonObjectBuilder jsonObjectBuilder = this.factory.createObjectBuilder();
        if (structuredReport == null) {
            try {
                structuredReport = new StructuredReport(attributeList);
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
            }
        }
        if (attributeList != null) {
            AttributeList attributeList2 = (AttributeList)attributeList.clone();
            attributeList2.removeGroupLengthAttributes();
            attributeList2.removeMetaInformationHeaderAttributes();
            new JSONRepresentationOfDicomObjectFactory().addAttributesFromListToJsonObject(attributeList2, jsonObjectBuilder, true, false, false, false, collapseAttributeValueArrays, collapseEmptyToNull, true, substituteUIDKeywords, false);
        }
        if (structuredReport != null) {
            this.walkTreeBuildingSimplifiedLabelsForReferencedContentItemIdentifiers((ContentItem)structuredReport.getRoot(), "1");
            this.addContentItemAndChildrenToJsonObject((ContentItem)structuredReport.getRoot(), jsonObjectBuilder);
        }
        return this.factory.createArrayBuilder().add(jsonObjectBuilder).build();
    }

    public JsonArray getDocument(File file) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.setDecompressPixelData(false);
        attributeList.read(file);
        return this.getDocument(null, attributeList);
    }

    public JsonArray getDocument(String string) throws IOException, DicomException {
        return this.getDocument(new File(string));
    }

    protected String getStringFromSelectedContentItemValue(JsonArray jsonArray, int n, String string, String string2, CodedSequenceItem codedSequenceItem) {
        String string3 = null;
        JsonValue jsonValue = (JsonValue)jsonArray.get(n);
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            string3 = ((JsonString)jsonValue).getString();
            if (string3 == null || string3.length() == 0) {
                slf4jlogger.error("Missing {} in {} content item for concept {} ", string, string2, codedSequenceItem);
            }
        } else {
            slf4jlogger.error("Missing {} string in {} content item for concept {} ", string, string2, codedSequenceItem);
        }
        return string3;
    }

    protected String getSingleStringValueOrNullFromJsonStringOrNumberContentItemValue(JsonValue jsonValue, String string, CodedSequenceItem codedSequenceItem) {
        String string2 = null;
        if (jsonValue == null) {
            slf4jlogger.error("Missing value string in {} content item for concept {} ", string, codedSequenceItem);
        } else {
            JsonValue.ValueType valueType = jsonValue.getValueType();
            if (valueType == JsonValue.ValueType.STRING) {
                string2 = ((JsonString)jsonValue).getString();
                if (string2 == null || string2.length() == 0) {
                    slf4jlogger.error("Missing or empty string value in {} content item for concept {} ", string, codedSequenceItem);
                }
            } else if (valueType == JsonValue.ValueType.NUMBER) {
                string2 = Double.toString(((JsonNumber)jsonValue).doubleValue());
                if (string2.endsWith(".0")) {
                    string2 = string2.substring(0, string2.length() - 2);
                }
            } else {
                slf4jlogger.error("Invalid JsonValue.ValueType {} string in {} content item for concept {} ", string, codedSequenceItem);
            }
        }
        return string2;
    }

    protected String getSingleStringValueOrNullFromJsonContentItemValue(JsonValue jsonValue, String string, CodedSequenceItem codedSequenceItem) {
        String string2 = null;
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
            string2 = ((JsonString)jsonValue).getString();
            if (string2 == null || string2.length() == 0) {
                slf4jlogger.error("Missing or empty string value in {} content item for concept {} ", string, codedSequenceItem);
            }
        } else {
            slf4jlogger.error("Missing or invalid type of value string in {} content item for concept {} ", string, codedSequenceItem);
        }
        return string2;
    }

    protected boolean haveChildrenForSingleStringOrCodeJsonContentItemValue(JsonValue jsonValue, JsonObject jsonObject) {
        return jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.ARRAY && ((JsonArray)jsonValue).size() > (jsonObject == null ? 1 : 2);
    }

    protected String determineUnknownValueType(String string, JsonValue jsonValue) {
        slf4jlogger.debug("determineUnknownValueType(): parentValueType {} childObjectValue {}", string, jsonValue);
        int n = -1;
        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
            JsonArray jsonArray = (JsonArray)jsonValue;
            JsonObject jsonObject = this.getContentItemAttributesObject(jsonArray);
            if (jsonObject != null) {
                if (jsonArray.size() > 1) {
                    n = 1;
                    slf4jlogger.debug("determineUnknownValueType(): have attribute object preceding value and children array");
                }
            } else {
                n = 0;
                slf4jlogger.debug("determineUnknownValueType(): no attribute object preceding value and children array");
            }
            slf4jlogger.debug("determineUnknownValueType(): firstEntryIndex {}", n);
            if (jsonObject != null) {
                slf4jlogger.debug("determineUnknownValueType(): have attribute object so checking for IMAGE, WAVEFORM, COMPOSITE");
                JsonValue jsonValue2 = (JsonValue)jsonObject.get((Object)reservedKeywordForReferencedSOPClassUIDAttributeInCompositeContentItem);
                if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                    String string2 = ((JsonString)jsonValue2).getString();
                    slf4jlogger.debug("determineUnknownValueType(): referencedSOPClassUID is {}", string2);
                    if (string2 != null && string2.length() > 0) {
                        string2 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible(string2);
                        slf4jlogger.debug("determineUnknownValueType(): referencedSOPClassUID after key word replacement with UID is {}", string2);
                        if (SOPClass.isImageStorage(string2)) {
                            slf4jlogger.debug("determineUnknownValueType(): referencedSOPClassUID is recognized as IMAGE");
                            return "IMAGE";
                        }
                        if (SOPClass.isWaveform(string2)) {
                            slf4jlogger.debug("determineUnknownValueType(): referencedSOPClassUID is recognized as WAVEFORM");
                            return "WAVEFORM";
                        }
                        if (SOPClass.isStorage(string2)) {
                            slf4jlogger.debug("determineUnknownValueType(): referencedSOPClassUID is recognized as storage but not image or waveform, so assume COMPOSITE");
                            return "COMPOSITE";
                        }
                    }
                }
                if ((jsonValue2 = (JsonValue)jsonObject.get((Object)reservedKeywordFor2DCoordinatesAttributeInCoordinatesContentItem)) != null) {
                    return "SCOORD";
                }
                jsonValue2 = (JsonValue)jsonObject.get((Object)reservedKeywordFor3DCoordinatesAttributeInCoordinatesContentItem);
                if (jsonValue2 != null) {
                    return "SCOORD3D";
                }
            }
        }
        return null;
    }

    protected static String selectTheOtherOfTwoStringsInSet(String string, String string2, Set<String> set, String string3) {
        slf4jlogger.debug("{}(): {}: is not {} so looking for the other choice", string, string2, string3);
        for (String string4 : set) {
            slf4jlogger.debug("{}(): {}: checking choice of {}", string, string2, string4);
            if (string4.equals(string3)) continue;
            slf4jlogger.debug("{}(): {}: selected other choice than {} is {}", string, string2, string3, string4);
            return string4;
        }
        return null;
    }

    protected String selectFromAlternativeValueTypesForBusinessName(String string, String string2, String string3, Set<String> set, JsonValue jsonValue) {
        String string4 = null;
        if (set != null && set.size() > 0) {
            if (set.size() == 1) {
                string4 = set.iterator().next();
            } else {
                slf4jlogger.debug("selectFromAlternativeValueTypesForBusinessName(): {}: Ambiguous choice of value types for {} - attempting to disambiguate", string, string2);
                if (set.size() == 2) {
                    slf4jlogger.debug("selectFromAlternativeValueTypesForBusinessName(): {}: Have two choices", string);
                    if (set.contains("CONTAINER")) {
                        string4 = jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING ? JSONRepresentationOfStructuredReportObjectFactory.selectTheOtherOfTwoStringsInSet("selectFromAlternativeValueTypesForBusinessName", string, set, "CONTAINER") : "CONTAINER";
                    } else if (set.contains("CODE") && (set.contains("TEXT") || set.contains("DATE") || set.contains("TIME") || set.contains("DATETIME") || set.contains("UIDREF"))) {
                        slf4jlogger.debug("selectFromAlternativeValueTypesForBusinessName(): {}: is CODE or something TEXT-like", string);
                        if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                            String string5 = ((JsonString)jsonValue).getString();
                            slf4jlogger.debug("selectFromAlternativeValueTypesForBusinessName(): {}: have child stringValue of {}", string, string5);
                            string4 = this.businessNames.keySet().contains(string5) ? "CODE" : JSONRepresentationOfStructuredReportObjectFactory.selectTheOtherOfTwoStringsInSet("selectFromAlternativeValueTypesForBusinessName", string, set, "CODE");
                        }
                    }
                }
            }
        }
        return string4;
    }

    protected String selectFromAlternativeRelationshipTypesForBusinessName(String string, String string2, String string3, String string4, Set<String> set) {
        String string5 = null;
        if (set != null && set.size() > 0) {
            if (set.size() == 1) {
                string5 = set.iterator().next();
            } else {
                slf4jlogger.debug("selectFromAlternativeRelationshipTypesForBusinessName(): {}: Ambiguous choice of relationship types for {} - attempting to disambiguate", string, string2);
                if (set.size() == 2) {
                    slf4jlogger.debug("selectFromAlternativeRelationshipTypesForBusinessName(): {}: Have two choices", string);
                    if (set.contains("CONTAINS") && !set.contains("HAS CONCEPT MOD") && !set.contains("HAS ACQ CONTEXT") && !set.contains("HAS OBS CONTEXT")) {
                        slf4jlogger.debug("selectFromAlternativeRelationshipTypesForBusinessName(): {}: Have choice of CONTAINS and one other than AS CONCEPT MOD, HAS ACQ CONTEXT or HAS OBS CONTEXT", string);
                        if (string3.equals("CONTAINER")) {
                            slf4jlogger.debug("selectFromAlternativeRelationshipTypesForBusinessName(): {}: parent is CONTAINER so use CONTAINS", string);
                            string5 = "CONTAINS";
                        } else {
                            string5 = JSONRepresentationOfStructuredReportObjectFactory.selectTheOtherOfTwoStringsInSet("selectFromAlternativeRelationshipTypesForBusinessName", string, set, "CONTAINS");
                        }
                    }
                }
            }
        }
        return string5;
    }

    protected String determineUnknownRelationshipType(String string, String string2, JsonValue jsonValue) {
        slf4jlogger.debug("determineUnknownRelationshipType(): parentValueType {} childValueType {}", string, string2);
        if ((string.equals("TEXT") || string.equals("CODE") || string.equals("NUM")) && "SCOORD".equals(string2)) {
            return "INFERRED FROM";
        }
        if (string.equals("SCOORD") && (string2 == null || string2.equals("IMAGE"))) {
            return "SELECTED FROM";
        }
        if (string.equals("CONTAINER")) {
            return "CONTAINS";
        }
        return null;
    }

    protected JsonObject getContentItemAttributesObject(JsonArray jsonArray) {
        JsonValue jsonValue;
        JsonObject jsonObject = null;
        if (jsonArray.size() > 0 && (jsonValue = (JsonValue)jsonArray.get(0)) != null && jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            jsonObject = (JsonObject)jsonValue;
            slf4jlogger.debug("getContentItemAttributesObject(): content item has attributes");
        }
        return jsonObject;
    }

    protected ContentItem getContentItemAndChildrenFromJSONObjectValue(String string, CodedSequenceItem codedSequenceItem, String string2, String string3, JsonValue jsonValue, String string4) throws DicomException {
        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}:  businessName = {}", string4, string);
        if (slf4jlogger.isDebugEnabled()) {
            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: concept = {}", string4, codedSequenceItem);
        }
        ContentItem contentItem = null;
        if (jsonValue != null) {
            Object object;
            Object object2;
            String string52;
            Object object3;
            Object object42;
            Object object5;
            Object object6;
            String string6;
            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: valueType = {}", string4, string2);
            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: relationshipType = {}", string4, string3);
            String string7 = null;
            String string8 = null;
            JsonArray jsonArray = null;
            JsonObject jsonObject = null;
            int n = -1;
            JsonValue jsonValue2 = null;
            JsonArray jsonArray2 = null;
            JsonArray jsonArray3 = null;
            if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.ARRAY && (jsonArray3 = (JsonArray)jsonValue).size() > 0) {
                jsonObject = this.getContentItemAttributesObject(jsonArray3);
                if (jsonObject != null) {
                    if (jsonArray3.size() > 1) {
                        n = 1;
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have attribute object preceding value and children array", string4);
                    }
                } else {
                    n = 0;
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: no attribute object preceding value and children array", string4);
                }
                if (n >= 0) {
                    jsonValue2 = (JsonValue)jsonArray3.get(n);
                }
                if ((string6 = (JsonValue)jsonArray3.get(jsonArray3.size() - 1)) != null && string6.getValueType() == JsonValue.ValueType.ARRAY) {
                    jsonArray2 = (JsonArray)string6;
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have potential children in last array entry", string4);
                }
            }
            string6 = null;
            if (jsonObject != null) {
                object6 = (JsonValue)jsonObject.get((Object)reservedKeywordForSimplifiedLabelAttributeInSRFile);
                if (object6 != null && object6.getValueType() == JsonValue.ValueType.STRING) {
                    object5 = ((JsonString)object6).getString();
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have labelString {}", string4, object5);
                    this.referencedContentItemIdentifiersBySimplifiedLabel.put((String)object5, string4);
                }
                if ((object6 = (JsonValue)jsonObject.get((Object)reservedKeywordForSimplifiedReferenceToLabelAttributeInSRFile)) != null && object6.getValueType() == JsonValue.ValueType.STRING) {
                    string6 = ((JsonString)object6).getString();
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have referencedLabelString {}", string4, string6);
                }
                if ((object6 = (JsonValue)jsonObject.get((Object)reservedKeywordForObservationUIDAttributeInSRFile)) != null && object6.getValueType() == JsonValue.ValueType.STRING) {
                    string8 = ((JsonString)object6).getString();
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have observationUID {}", string4, string8);
                }
                if ((object6 = (JsonValue)jsonObject.get((Object)reservedKeywordForObservationDateTimeAttributeInSRFile)) != null && object6.getValueType() == JsonValue.ValueType.STRING) {
                    string7 = ((JsonString)object6).getString();
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: have observationDateTime {}", string4, string7);
                }
            }
            if (string2 != null) {
                if (string2.equals("CONTAINER")) {
                    object6 = "SEPARATE";
                    object5 = null;
                    String string9 = null;
                    if (jsonObject != null) {
                        for (Object object42 : jsonObject.keySet()) {
                            object3 = (JsonValue)jsonObject.get(object42);
                            if (object3 != null && object3.getValueType() == JsonValue.ValueType.STRING) {
                                String string10 = ((JsonString)object3).getString();
                                if (((String)object42).equals(reservedKeywordForContinuityOfContentAttributeInSRFile)) {
                                    object6 = string10;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: continuity = {}", string4, object6);
                                    continue;
                                }
                                if (((String)object42).equals(reservedKeywordForTemplateIdentifierAttributeInSRFile)) {
                                    object5 = string10;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: template = {}", string4, object5);
                                    continue;
                                }
                                if (((String)object42).equals(reservedKeywordForTemplateMappingResourceAttributeInSRFile)) {
                                    string9 = string10;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: templatemappingresource = {}", string4, string9);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute((String)object42)) continue;
                                slf4jlogger.warn("{}: Unrecognized CONTAINER attribute {} for concept {}", string4, object42, codedSequenceItem);
                                continue;
                            }
                            slf4jlogger.error("{}: Incorrect JSON type for value of attribute {} for concept {}", string4, object42, codedSequenceItem);
                        }
                    }
                    if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.ARRAY) {
                        jsonArray = (JsonArray)jsonValue2;
                        if (slf4jlogger.isDebugEnabled()) {
                            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: CONTAINER with children but no attributes concept = {}", string4, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: Malformed non-empty array for CONTAINER content item for concept {}", string4, codedSequenceItem);
                    }
                    contentItem = this.contentItemFactory.makeContainerContentItem(null, string3, codedSequenceItem, ((String)object6).equals("SEPARATE"), string9, (String)object5, string7, string8);
                } else if (string2.equals("CODE")) {
                    object6 = null;
                    object5 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object5 = ((JsonString)jsonValue).getString();
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object5 = ((JsonString)jsonValue2).getString();
                    }
                    if (object5 != null) {
                        object6 = this.getCodedSequenceItemForBusinessNameUsedAsValue((String)object5, string4);
                        if (object6 == null) {
                            slf4jlogger.error("{}: Unrecognized business name {} for value in CODE content item for concept {}", string4, object5, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: Missing business name string in CODE content item for concept {}", string4, codedSequenceItem);
                    }
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeCodeContentItem(null, string3, codedSequenceItem, (CodedSequenceItem)object6, string7, string8);
                } else if (string2.equals("NUM")) {
                    object6 = null;
                    object5 = null;
                    Double d = null;
                    Integer n2 = null;
                    object42 = null;
                    object3 = null;
                    if (jsonObject != null) {
                        for (String string11 : jsonObject.keySet()) {
                            JsonValue jsonValue3 = (JsonValue)jsonObject.get((Object)string11);
                            if (jsonValue3 == null) continue;
                            if (jsonValue3.getValueType() == JsonValue.ValueType.STRING) {
                                string52 = ((JsonString)jsonValue3).getString();
                                if (string11.equals(reservedKeywordForMeasurementUnitsAttributeInNumericContentItem)) {
                                    object2 = string52;
                                    if (slf4jlogger.isDebugEnabled()) {
                                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: unitsBusinessName = {}", string4, object2);
                                    }
                                    object5 = this.getCodedSequenceItemForBusinessNameUsedAsUnits((String)object2, string4);
                                    continue;
                                }
                                if (string11.equals(reservedKeywordForNumericValueQualifierAttributeInNumericContentItem)) {
                                    object2 = string52;
                                    if (slf4jlogger.isDebugEnabled()) {
                                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: businessNameForQualifierCode = {}", string4, object2);
                                    }
                                    object3 = this.getCodedSequenceItemForBusinessNameUsedAsUnits((String)object2, string4);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute(string11)) continue;
                                slf4jlogger.warn("{}: Unrecognized NUM attribute {} for concept {}", string4, string11, codedSequenceItem);
                                continue;
                            }
                            if (jsonValue3.getValueType() != JsonValue.ValueType.NUMBER) continue;
                            double d2 = ((JsonNumber)jsonValue3).doubleValue();
                            if (string11.equals(reservedKeywordForFloatingPointValueAttributeInNumericContentItem)) {
                                d = new Double(d2);
                                continue;
                            }
                            if (string11.equals(reservedKeywordForRationalNumeratorAttributeInNumericContentItem)) {
                                n2 = new Integer((int)d2);
                                continue;
                            }
                            if (string11.equals(reservedKeywordForRationalDenominatorAttributeInNumericContentItem)) {
                                object42 = new Long((long)d2);
                                continue;
                            }
                            if (this.isCommonAnnotationAttribute(string11)) continue;
                            slf4jlogger.warn("{}: Unrecognized NUM attribute {} for concept {}", string4, string11, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: No units in NUM content item for concept {} ", string4, codedSequenceItem);
                    }
                    if (object5 == null) {
                        slf4jlogger.error("{}: Missing or empty or unrecognized units in NUM content item for concept {}", string4, codedSequenceItem);
                    }
                    JsonValue jsonValue4 = null;
                    if (jsonValue != null && (jsonValue.getValueType() == JsonValue.ValueType.STRING || jsonValue.getValueType() == JsonValue.ValueType.NUMBER)) {
                        jsonValue4 = jsonValue;
                    } else if (jsonValue2 != null && (jsonValue2.getValueType() == JsonValue.ValueType.STRING || jsonValue2.getValueType() == JsonValue.ValueType.NUMBER)) {
                        jsonValue4 = jsonValue2;
                    }
                    object6 = this.getSingleStringValueOrNullFromJsonStringOrNumberContentItemValue(jsonValue4, string2, codedSequenceItem);
                    if (object6 == null) {
                        slf4jlogger.error("{}: No value in NUM content item for concept {}", string4, codedSequenceItem);
                    }
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeNumericContentItem(null, string3, codedSequenceItem, (String)object6, d, n2, (Long)object42, (CodedSequenceItem)object5, (CodedSequenceItem)object3, string7, string8);
                } else if (string2.equals("DATETIME")) {
                    object6 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue2;
                    }
                    object5 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object6, string2, codedSequenceItem);
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeDateTimeContentItem(null, string3, codedSequenceItem, (String)object5, string7, string8);
                } else if (string2.equals("DATE")) {
                    object6 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue2;
                    }
                    object5 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object6, string2, codedSequenceItem);
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeDateContentItem(null, string3, codedSequenceItem, (String)object5, string7, string8);
                } else if (string2.equals("TIME")) {
                    object6 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue2;
                    }
                    object5 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object6, string2, codedSequenceItem);
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeTimeContentItem(null, string3, codedSequenceItem, (String)object5, string7, string8);
                } else if (string2.equals("PNAME")) {
                    object6 = null;
                    object5 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object5 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object5 = jsonValue2;
                    }
                    if (object5 != null) {
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: PNAME encoded as single string not attributes", string4);
                        object6 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object5, string2, codedSequenceItem);
                        if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                            jsonArray = jsonArray2;
                        }
                    } else if (jsonObject != null) {
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: PNAME extracting components from contentItemAttributesObject", string4);
                        object6 = JSONRepresentationOfDicomObjectFactory.getJsonPersonNameFromPropertiesInJsonObject(jsonObject, reservedKeywordForAlphabeticPropertyInPersonNameContentItem, reservedKeywordForIdeographicPropertyInPersonNameContentItem, reservedKeywordForPhoneticPropertyInPersonNameContentItem);
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: PNAME is {}", string4, object6);
                        if (jsonArray2 != null && jsonArray2.getValueType() == JsonValue.ValueType.ARRAY) {
                            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: PNAME have children", string4);
                            jsonArray = jsonArray2;
                        } else {
                            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: PNAME has no children", string4);
                        }
                    }
                    contentItem = this.contentItemFactory.makePersonNameContentItem(null, string3, codedSequenceItem, (String)object6, string7, string8);
                } else if (string2.equals("UIDREF")) {
                    object6 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue2;
                    }
                    object5 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object6, string2, codedSequenceItem);
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeUIDContentItem(null, string3, codedSequenceItem, (String)object5, string7, string8);
                } else if (string2.equals("TEXT")) {
                    object6 = null;
                    if (jsonValue != null && jsonValue.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue;
                    } else if (jsonValue2 != null && jsonValue2.getValueType() == JsonValue.ValueType.STRING) {
                        object6 = jsonValue2;
                    }
                    object5 = this.getSingleStringValueOrNullFromJsonContentItemValue((JsonValue)object6, string2, codedSequenceItem);
                    if (this.haveChildrenForSingleStringOrCodeJsonContentItemValue(jsonValue, jsonObject)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeTextContentItem(null, string3, codedSequenceItem, (String)object5, string7, string8);
                } else if (string2.equals("SCOORD")) {
                    object6 = null;
                    object5 = null;
                    if (jsonObject != null) {
                        for (String string12 : jsonObject.keySet()) {
                            object42 = (JsonValue)jsonObject.get((Object)string12);
                            if (object42 == null) continue;
                            if (object42.getValueType() == JsonValue.ValueType.STRING) {
                                object3 = ((JsonString)object42).getString();
                                if (string12.equals(reservedKeywordForGraphicTypeAttributeInCoordinatesContentItem)) {
                                    object6 = object3;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: graphicType = {}", string4, object6);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute(string12)) continue;
                                slf4jlogger.warn("{}: Unrecognized SCOORD attribute {} for concept {}", string4, string12, codedSequenceItem);
                                continue;
                            }
                            if (object42.getValueType() != JsonValue.ValueType.ARRAY) continue;
                            object3 = (JsonArray)object42;
                            if (string12.equals(reservedKeywordFor2DCoordinatesAttributeInCoordinatesContentItem)) {
                                int n3 = object3.size();
                                if (n3 <= 0) continue;
                                object5 = new float[n3];
                                for (int i = 0; i < n3; ++i) {
                                    JsonValue jsonValue5 = (JsonValue)object3.get(i);
                                    if (jsonValue5 != null && jsonValue5.getValueType() == JsonValue.ValueType.NUMBER) {
                                        object5[i] = (float)((JsonNumber)jsonValue5).doubleValue();
                                        continue;
                                    }
                                    slf4jlogger.error("{}: Missing graphicData array value type {} in SCOORD content item for concept {} ", string4, jsonValue5.getValueType(), codedSequenceItem);
                                }
                                continue;
                            }
                            if (this.isCommonAnnotationAttribute(string12)) continue;
                            slf4jlogger.warn("{}: Unrecognized SCOORD attribute {} for concept {}", string4, string12, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: No graphic type and coordinates in SCOORD content item for concept {} ", string4, codedSequenceItem);
                    }
                    if (object6 == null || ((String)object6).length() == 0) {
                        slf4jlogger.error("{}: Missing or empty graphicType in SCOORD content item for concept {}", string4, codedSequenceItem);
                    }
                    if (object5 == null) {
                        slf4jlogger.error("{}: Missing graphicData array in SCOORD content item for concept {}", string4, codedSequenceItem);
                    }
                    if (jsonArray3.size() > (jsonObject == null ? 0 : 1)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeSpatialCoordinatesContentItem(null, string3, codedSequenceItem, (String)object6, (float[])object5, string7, string8);
                } else if (string2.equals("SCOORD3D")) {
                    object6 = null;
                    object5 = null;
                    String string13 = null;
                    if (jsonObject != null) {
                        for (Object object42 : jsonObject.keySet()) {
                            String string14;
                            object3 = (JsonValue)jsonObject.get(object42);
                            if (object3 == null) continue;
                            if (object3.getValueType() == JsonValue.ValueType.STRING) {
                                string14 = ((JsonString)object3).getString();
                                if (((String)object42).equals(reservedKeywordForGraphicTypeAttributeInCoordinatesContentItem)) {
                                    object6 = string14;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: graphicType = {}", string4, object6);
                                    continue;
                                }
                                if (((String)object42).equals(reservedKeywordForReferencedFrameOfReferenceUIDAttributeInCoordinatesContentItem)) {
                                    string13 = string14;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedFrameOfReferenceUID = {}", string4, string13);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute((String)object42)) continue;
                                slf4jlogger.warn("{}: Unrecognized SCOORD3D attribute {} for concept {}", string4, object42, codedSequenceItem);
                                continue;
                            }
                            if (object3.getValueType() != JsonValue.ValueType.ARRAY) continue;
                            string14 = (JsonArray)object3;
                            if (((String)object42).equals(reservedKeywordFor3DCoordinatesAttributeInCoordinatesContentItem)) {
                                int n4 = string14.size();
                                if (n4 <= 0) continue;
                                object5 = new float[n4];
                                for (int i = 0; i < n4; ++i) {
                                    string52 = (JsonValue)string14.get(i);
                                    if (string52 != null && string52.getValueType() == JsonValue.ValueType.NUMBER) {
                                        object5[i] = (float)((JsonNumber)string52).doubleValue();
                                        continue;
                                    }
                                    slf4jlogger.error("{}: Missing graphicData array value type {} in SCOORD content item for concept {} ", string4, string52.getValueType(), codedSequenceItem);
                                }
                                continue;
                            }
                            if (this.isCommonAnnotationAttribute((String)object42)) continue;
                            slf4jlogger.warn("{}: Unrecognized SCOORD3D attribute {} for concept {}", string4, object42, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: No graphic type and coordinates in SCOORD content item for concept {} ", string4, codedSequenceItem);
                    }
                    if (object6 == null || ((String)object6).length() == 0) {
                        slf4jlogger.error("{}: Missing or empty graphicType in SCOORD content item for concept {}", string4, codedSequenceItem);
                    }
                    if (object5 == null) {
                        slf4jlogger.error("{}: Missing graphicData array in SCOORD content item for concept {}", string4, codedSequenceItem);
                    }
                    if (string13 == null || string13.length() == 0) {
                        slf4jlogger.error("{}: Missing or empty referencedFrameOfReferenceUID in SCOORD content item for concept {}", string4, codedSequenceItem);
                    }
                    if (jsonArray3.size() > (jsonObject == null ? 0 : 1)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeSpatialCoordinates3DContentItem(null, string3, codedSequenceItem, (String)object6, (float[])object5, string13, string7, string8);
                } else if (string2.equals("IMAGE")) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: populating IMAGE content item", string4);
                    }
                    object6 = null;
                    object5 = null;
                    int n5 = 0;
                    int n6 = 0;
                    object42 = null;
                    object3 = null;
                    String string15 = null;
                    String string16 = null;
                    if (jsonObject != null) {
                        for (String string52 : jsonObject.keySet()) {
                            object2 = (JsonValue)jsonObject.get((Object)string52);
                            if (object2 != null && object2.getValueType() == JsonValue.ValueType.STRING) {
                                object = ((JsonString)object2).getString();
                                if (string52.equals(reservedKeywordForReferencedSOPClassUIDAttributeInCompositeContentItem)) {
                                    object6 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPClassUID = {}", string4, object6);
                                    object6 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible((String)object6);
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPClassUID after replacement of keyword with UID = {}", string4, object6);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForReferencedSOPInstanceUIDAttributeInCompositeContentItem)) {
                                    object5 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPInstanceUID = {}", string4, object5);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForPresentationStateSOPClassUIDAttributeInCompositeContentItem)) {
                                    object42 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: presentationStateSOPClassUID = {}", string4, object42);
                                    object42 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible((String)object42);
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: presentationStateSOPClassUID after replacement of keyword with UID = {}", string4, object42);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForPresentationStateSOPInstanceUIDAttributeInCompositeContentItem)) {
                                    object3 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: presentationStateSOPInstanceUID = {}", string4, object3);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForRealWorldValueMappingSOPClassUIDAttributeInCompositeContentItem)) {
                                    string15 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: realWorldValueMappingSOPClassUID = {}", string4, string15);
                                    string15 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible(string15);
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: realWorldValueMappingSOPClassUID after replacement of keyword with UID = {}", string4, string15);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForRealWorldValueMappingSOPInstanceUIDAttributeInCompositeContentItem)) {
                                    string16 = object;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: realWorldValueMappingSOPInstanceUID = {}", string4, string16);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute(string52)) continue;
                                slf4jlogger.warn("{}: Unrecognized IMAGE String attribute {} for concept {}", string4, string52, codedSequenceItem);
                                continue;
                            }
                            if (object2 != null && object2.getValueType() == JsonValue.ValueType.NUMBER) {
                                int n7 = ((JsonNumber)object2).intValue();
                                if (string52.equals(reservedKeywordForReferencedFrameNumberAttributeInCompositeContentItem)) {
                                    n5 = n7;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedFrameNumber = {}", string4, n5);
                                    continue;
                                }
                                if (string52.equals(reservedKeywordForReferencedSegmentNumberAttributeInCompositeContentItem)) {
                                    n6 = n7;
                                    if (!slf4jlogger.isDebugEnabled()) continue;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSegmentNumber = {}", string4, n6);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute(string52)) continue;
                                slf4jlogger.warn("{}: Unrecognized IMAGE Number attribute {} for concept {}", string4, string52, codedSequenceItem);
                                continue;
                            }
                            slf4jlogger.error("{}: Incorrect JSON type for value of attribute {} for concept {}", string4, string52, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: No SOP Class and SOP Instance in IMAGE content item for concept {} ", string4, codedSequenceItem);
                    }
                    if (jsonArray3.size() > (jsonObject == null ? 0 : 1)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeImageContentItem(null, string3, codedSequenceItem, (String)object6, (String)object5, n5, n6, (String)object42, (String)object3, string15, string16, string7, string8);
                } else if (string2.equals("COMPOSITE")) {
                    if (slf4jlogger.isDebugEnabled()) {
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: populating COMPOSITE content item", string4);
                    }
                    object6 = null;
                    object5 = null;
                    if (jsonObject != null) {
                        for (String string17 : jsonObject.keySet()) {
                            object42 = (JsonValue)jsonObject.get((Object)string17);
                            if (object42 != null && object42.getValueType() == JsonValue.ValueType.STRING) {
                                object3 = ((JsonString)object42).getString();
                                if (string17.equals(reservedKeywordForReferencedSOPClassUIDAttributeInCompositeContentItem)) {
                                    object6 = object3;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPClassUID = {}", string4, object6);
                                    object6 = JSONRepresentationOfDicomObjectFactory.substituteUIDForKeywordIfPossible((String)object6);
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPClassUID after replacement of keyword with UID = {}", string4, object6);
                                    continue;
                                }
                                if (string17.equals(reservedKeywordForReferencedSOPInstanceUIDAttributeInCompositeContentItem)) {
                                    object5 = object3;
                                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedSOPInstanceUID = {}", string4, object5);
                                    continue;
                                }
                                if (this.isCommonAnnotationAttribute(string17)) continue;
                                slf4jlogger.warn("{}: Unrecognized COMPOSITE String attribute {} for concept {}", string4, string17, codedSequenceItem);
                                continue;
                            }
                            slf4jlogger.error("{}: Incorrect JSON type for value of attribute {} for concept {}", string4, string17, codedSequenceItem);
                        }
                    } else {
                        slf4jlogger.error("{}: No SOP Class and SOP Instance in COMPOSITE content item for concept {} ", string4, codedSequenceItem);
                    }
                    if (jsonArray3.size() > (jsonObject == null ? 0 : 1)) {
                        jsonArray = jsonArray2;
                    }
                    contentItem = this.contentItemFactory.makeCompositeContentItem(null, string3, codedSequenceItem, (String)object6, (String)object5, string7, string8);
                } else {
                    slf4jlogger.error("{}: Unrecognized value type {} for concept {}", string4, string2, codedSequenceItem);
                }
            } else {
                slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: No value type so checking for by-reference", string4);
                slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedLabelString = {}", string4, string6);
                if (string6 != null) {
                    object6 = this.referencedContentItemIdentifiersBySimplifiedLabel.get(string6);
                    if (object6 != null) {
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: referencedLabelString {} maps to referencedContentItemIdentifier", string4, string6, object6);
                        contentItem = new ContentItemWithReference(null, string3, (String)object6);
                    } else {
                        slf4jlogger.error("{}: Unable to resolve simplified label {}", string4, string6);
                    }
                }
            }
            if (jsonArray != null && jsonArray.size() > 0) {
                int n8 = jsonArray.size();
                for (int i = 0; i < n8; ++i) {
                    slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: Processing child # {}", string4, i);
                    String string18 = string4 + "." + Integer.toString(i + 1);
                    JsonValue jsonValue6 = (JsonValue)jsonArray.get(i);
                    if (jsonValue6 == null || jsonValue6.getValueType() != JsonValue.ValueType.OBJECT) continue;
                    object42 = (JsonObject)jsonValue6;
                    object3 = object42.keySet();
                    if (object3.size() == 1) {
                        String string19 = (String)object3.iterator().next();
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: JSON child businessName = {}", string18, string19);
                        if (string19 != null) {
                            CodedSequenceItem codedSequenceItem2 = this.getCodedSequenceItemForBusinessNameUsedAsConceptName(string19, string18);
                            JsonValue jsonValue7 = (JsonValue)object42.get((Object)string19);
                            string52 = null;
                            object2 = this.valueTypesByBusinessName.get(string19);
                            string52 = this.selectFromAlternativeValueTypesForBusinessName(string18, string19, string2, (Set<String>)object2, jsonValue7);
                            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: childValueType from lookup {} for {}", string18, string52, string19);
                            if (string52 == null) {
                                string52 = this.determineUnknownValueType(string2, jsonValue7);
                                slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: unknown childValueType determined to be {} for {}", string18, string52, string19);
                            }
                            if (string52 == null) {
                                slf4jlogger.debug("{}: Could not determine value type for child {} of {} {} - OK if this is a reference", string18, string19, string2, string);
                            }
                            object2 = null;
                            object = this.relationshipTypesByBusinessName.get(string19);
                            object2 = this.selectFromAlternativeRelationshipTypesForBusinessName(string18, string19, string2, string52, (Set<String>)object);
                            slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: childRelationshipType from lookup {} for business name {}", string18, object2, string19);
                            if (object2 == null) {
                                object2 = this.determineUnknownRelationshipType(string2, string52, jsonValue7);
                                slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: unknown childRelationshipType determined to be {} for {}", string18, object2, string19);
                            }
                            if (object2 == null) {
                                slf4jlogger.error("{}: Could not determine relationship type for child {}", string18, string19);
                            }
                            if ((object = this.getContentItemAndChildrenFromJSONObjectValue(string19, codedSequenceItem2, string52, (String)object2, jsonValue7, string18)) == null) continue;
                            contentItem.addChild((ContentItem)object);
                            continue;
                        }
                        slf4jlogger.debug("getContentItemAndChildrenFromJSONObjectValue(): {}: Ignoring anonymous business name for now", string18);
                        continue;
                    }
                    slf4jlogger.error("{}: Expected only one entry for child object # {} in array of children", string18, i);
                }
            }
        }
        return contentItem;
    }

    public StructuredReport getStructuredReport(JsonObject jsonObject) throws DicomException {
        DicomDictionary dicomDictionary = DicomDictionary.StandardDictionary;
        StructuredReport structuredReport = null;
        try {
            JsonValue jsonValue;
            Object object3;
            String string;
            CodedSequenceItem codedSequenceItem;
            Object object2;
            if (jsonObject != null) {
                slf4jlogger.debug("Looking for SR container entry in top level object amongst all the DICOM keywords");
                object2 = null;
                codedSequenceItem = null;
                string = "1";
                for (Object object3 : jsonObject.keySet()) {
                    slf4jlogger.debug("JSON businessName = {}", object3);
                    if (object3 != null) {
                        if (dicomDictionary.getTagFromName((String)object3) == null && JSONRepresentationOfDicomObjectFactory.getAttributeTagFromHexadecimalGroupElementValues((String)object3) == null) {
                            CodedSequenceItem codedSequenceItem2 = this.getCodedSequenceItemForBusinessNameUsedAsConceptName((String)object3, string);
                            if (slf4jlogger.isDebugEnabled()) {
                                slf4jlogger.debug("getStructuredReport(): businessName {} is {}", object3, codedSequenceItem2);
                            }
                            if (codedSequenceItem2 != null) {
                                if (codedSequenceItem == null) {
                                    object2 = object3;
                                    codedSequenceItem = codedSequenceItem2;
                                    continue;
                                }
                                throw new DicomException("Could not parse JSON document - more than one potential root content item business name");
                            }
                            throw new DicomException("Could not parse JSON document - unrecognized business name " + (String)object3 + " that is neither a DICOM data element keyword nor in the supplied business name dictionary");
                        }
                        slf4jlogger.debug("getStructuredReport(): Ignoring businessName {} that is a DICOM keyword", object3);
                        continue;
                    }
                    throw new DicomException("Could not parse JSON document - missing business name");
                }
                jsonValue = (JsonValue)jsonObject.get(object2);
                if (jsonValue == null) {
                    throw new DicomException("Could not parse JSON document - missing top level object value");
                }
            } else {
                throw new DicomException("Could not parse JSON document - missing top level object");
            }
            this.contentItemFactory = new ContentItemFactory();
            object3 = this.getContentItemAndChildrenFromJSONObjectValue((String)object2, codedSequenceItem, "CONTAINER", null, jsonValue, string);
            structuredReport = new StructuredReport((ContentItem)object3);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DicomException("Could not parse JSON document - exactly one object in top level array expected " + indexOutOfBoundsException);
        }
        catch (ClassCastException classCastException) {
            throw new DicomException("Could not parse JSON document - expected object in top level array " + classCastException);
        }
        return structuredReport;
    }

    public StructuredReport getStructuredReport(JsonArray jsonArray) throws DicomException {
        StructuredReport structuredReport = null;
        try {
            JsonObject jsonObject = jsonArray.getJsonObject(0);
            structuredReport = this.getStructuredReport(jsonObject);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DicomException("Could not parse JSON document - exactly one object in top level array expected " + indexOutOfBoundsException);
        }
        catch (ClassCastException classCastException) {
            throw new DicomException("Could not parse JSON document - expected object in top level array " + classCastException);
        }
        return structuredReport;
    }

    public AttributeList getAttributeList(JsonObject jsonObject) throws DicomException {
        AttributeList attributeList = null;
        attributeList = new JSONRepresentationOfDicomObjectFactory().getAttributeList(jsonObject, true, true);
        StructuredReport structuredReport = this.getStructuredReport(jsonObject);
        AttributeList attributeList2 = structuredReport.getAttributeList();
        if (attributeList2 != null) {
            attributeList.putAll(attributeList2);
        }
        return attributeList;
    }

    public AttributeList getAttributeList(JsonArray jsonArray) throws DicomException {
        AttributeList attributeList = null;
        try {
            JsonObject jsonObject = jsonArray.getJsonObject(0);
            attributeList = this.getAttributeList(jsonObject);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DicomException("Could not parse JSON document - exactly one object in top level array expected " + indexOutOfBoundsException);
        }
        catch (ClassCastException classCastException) {
            throw new DicomException("Could not parse JSON document - expected object in top level array " + classCastException);
        }
        return attributeList;
    }

    public AttributeList getAttributeList(InputStream inputStream) throws IOException, DicomException {
        JsonReader jsonReader = Json.createReader((InputStream)inputStream);
        JsonArray jsonArray = jsonReader.readArray();
        jsonReader.close();
        return this.getAttributeList(jsonArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributeList(File file) throws IOException, DicomException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        return attributeList;
    }

    public AttributeList getAttributeList(String string) throws IOException, DicomException {
        return this.getAttributeList(new File(string));
    }

    public static void write(OutputStream outputStream, JsonArray jsonArray) throws IOException {
        JsonWriter jsonWriter = Json.createWriterFactory(null).createWriter(outputStream);
        jsonWriter.writeArray(jsonArray);
        jsonWriter.close();
    }

    public static void write(File file, JsonArray jsonArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JSONRepresentationOfStructuredReportObjectFactory.write(fileOutputStream, jsonArray);
        ((OutputStream)fileOutputStream).close();
    }

    public static void write(String string, JsonArray jsonArray) throws IOException {
        JSONRepresentationOfStructuredReportObjectFactory.write(new File(string), jsonArray);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        JSONRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(null, attributeList, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, OutputStream outputStream) throws IOException, DicomException {
        JSONRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, null, outputStream);
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, OutputStream outputStream) throws DicomException {
        try {
            JsonArray jsonArray = new JSONRepresentationOfStructuredReportObjectFactory().getDocument(structuredReport, attributeList);
            JSONRepresentationOfStructuredReportObjectFactory.write(outputStream, jsonArray);
        }
        catch (Exception exception) {
            throw new DicomException("Could not create JSON document - could not transform to JSON " + exception);
        }
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, File file) throws IOException, DicomException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        JSONRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, attributeList, fileOutputStream);
        ((OutputStream)fileOutputStream).close();
    }

    public static void createDocumentAndWriteIt(StructuredReport structuredReport, AttributeList attributeList, String string) throws IOException, DicomException {
        JSONRepresentationOfStructuredReportObjectFactory.createDocumentAndWriteIt(structuredReport, attributeList, new File(string));
    }

    public static void main(String[] stringArray) {
        try {
            Object object;
            Object object2;
            boolean bl = true;
            String string = null;
            String string2 = null;
            String string3 = null;
            int n = 2;
            int n2 = 4;
            int n3 = stringArray.length;
            boolean bl2 = false;
            if (n3 < n) {
                bl2 = true;
            }
            boolean bl3 = true;
            while (bl3 && n3 > n) {
                switch (object2 = stringArray[n3 - 1].trim().toUpperCase()) {
                    default: 
                }
                if (n3 > n2) {
                    slf4jlogger.error("Unrecognized argument {}", object2);
                    bl2 = true;
                }
                bl3 = false;
            }
            if (!bl2) {
                if (n3 == 2) {
                    bl = true;
                    string = stringArray[0];
                    string2 = stringArray[1];
                } else if (n3 == 3) {
                    if (stringArray[0].toLowerCase(Locale.US).equals("tojson")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        bl = true;
                    } else if (stringArray[0].toLowerCase(Locale.US).equals("todicom") || stringArray[0].toLowerCase(Locale.US).equals("todcm")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        bl2 = false;
                        bl = false;
                    } else {
                        string = stringArray[0];
                        string2 = stringArray[1];
                        string3 = stringArray[2];
                        bl = true;
                    }
                } else if (n3 == 4) {
                    if (stringArray[0].toLowerCase(Locale.US).equals("tojson")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        string3 = stringArray[3];
                        bl = true;
                    } else if (stringArray[0].toLowerCase(Locale.US).equals("todicom") || stringArray[0].toLowerCase(Locale.US).equals("todcm")) {
                        string = stringArray[1];
                        string2 = stringArray[2];
                        string3 = stringArray[3];
                        bl = false;
                    } else {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
            }
            if (bl2) {
                System.err.println("usage: JSONRepresentationOfStructuredReportObjectFactory [toJSON] inputpath businessnamespath [outputpath]");
                System.exit(1);
            } else if (bl) {
                object2 = new JSONRepresentationOfStructuredReportObjectFactory();
                object = ((JSONRepresentationOfStructuredReportObjectFactory)object2).getDocument(string);
                if (string3 == null) {
                    JSONRepresentationOfStructuredReportObjectFactory.write(System.out, (JsonArray)object);
                } else {
                    JSONRepresentationOfStructuredReportObjectFactory.write(string3, (JsonArray)object);
                }
                if (string2 != null) {
                    object = ((JSONRepresentationOfStructuredReportObjectFactory)object2).getBusinessNamesDocument();
                    JSONRepresentationOfStructuredReportObjectFactory.write(string2, (JsonArray)object);
                }
            } else {
                object2 = new JSONRepresentationOfStructuredReportObjectFactory();
                ((JSONRepresentationOfStructuredReportObjectFactory)object2).loadBusinessNamesDocument(string2);
                object = ((JSONRepresentationOfStructuredReportObjectFactory)object2).getAttributeList(string);
                String string4 = Attribute.getSingleStringValueOrEmptyString((AttributeList)object, TagFromName.SourceApplicationEntityTitle);
                ((AttributeList)object).insertSuitableSpecificCharacterSetForAllStringValues();
                ((AttributeList)object).removeMetaInformationHeaderAttributes();
                FileMetaInformation.addFileMetaInformation((AttributeList)object, "1.2.840.10008.1.2.1", string4);
                if (string3 == null) {
                    ((AttributeList)object).write(System.out, "1.2.840.10008.1.2.1", true, true);
                } else {
                    ((AttributeList)object).write(string3, "1.2.840.10008.1.2.1", true, true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

