/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.FileReaper;
import java.io.File;
import java.io.IOException;

public abstract class OtherAttributeOnDisk
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherAttributeOnDisk.java,v 1.15 2025/01/29 10:58:07 dclunie Exp $";
    protected long byteOffset;
    protected File file;
    protected boolean deleteFilesWhenNoLongerNeeded;

    public OtherAttributeOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
        this.byteOffset = 0L;
        this.file = null;
        this.deleteFilesWhenNoLongerNeeded = false;
    }

    public OtherAttributeOnDisk(AttributeTag attributeTag, File file, boolean bl) throws IOException, DicomException {
        super(attributeTag);
        this.file = file;
        if (file == null) {
            throw new DicomException("Cannot have an OtherAttributeOnDisk without a file available in the DicomInputStream");
        }
        this.deleteFilesWhenNoLongerNeeded = bl;
    }

    public OtherAttributeOnDisk(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    public OtherAttributeOnDisk(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, Long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        this.valueLength = l;
        this.byteOffset = l2;
        this.file = dicomInputStream.getFile();
        if (this.file == null) {
            throw new DicomException("Cannot have an OtherAttributeOnDisk without a file available in the DicomInputStream");
        }
        this.deleteFilesWhenNoLongerNeeded = false;
        if (l > 0L) {
            try {
                dicomInputStream.skipInsistently(l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to skip value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setFile(File file, long l) throws IOException {
        this.file = file;
        this.byteOffset = l;
        this.valueLength = file.length() - l;
    }

    @Override
    public void removeValues() {
        this.file = null;
        this.byteOffset = 0L;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public void deleteFilesWhenNoLongerNeeded() {
        this.deleteFilesWhenNoLongerNeeded = true;
    }

    protected void finalize() throws Throwable {
        if (this.deleteFilesWhenNoLongerNeeded) {
            if (this.file != null && !this.file.delete()) {
                FileReaper.addFileToDelete(this.file.getCanonicalPath());
            }
            this.file = null;
        }
        super.finalize();
    }
}

