/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.CopyStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.zip.GZIPInputStream;

public class OtherByteAttributeMultipleCompressedFilesOnDisk
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeMultipleCompressedFilesOnDisk.java,v 1.14 2025/01/29 10:58:07 dclunie Exp $";
    protected File[] files;

    public OtherByteAttributeMultipleCompressedFilesOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public OtherByteAttributeMultipleCompressedFilesOnDisk(AttributeTag attributeTag, long l, File[] fileArray) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(fileArray, l);
    }

    public OtherByteAttributeMultipleCompressedFilesOnDisk(AttributeTag attributeTag, long l, String[] stringArray) throws IOException, DicomException {
        super(attributeTag);
        File[] fileArray = new File[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            fileArray[i] = new File(stringArray[i]);
        }
        this.doCommonConstructorStuff(fileArray, l);
    }

    private void doCommonConstructorStuff(File[] fileArray, long l) throws IOException {
        this.files = fileArray;
        this.valueLength = l;
    }

    @Override
    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            for (int i = 0; i < this.files.length; ++i) {
                Object[] objectArray;
                Class[] classArray;
                Class<?> clazz;
                File file = this.files[i];
                InputStream inputStream = null;
                String string = file.getName().toUpperCase();
                if (string.endsWith(".GZ")) {
                    inputStream = new GZIPInputStream(new FileInputStream(file));
                } else if (string.endsWith(".Z")) {
                    try {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.compress.compressors.z.ZCompressorInputStream");
                        classArray = new Class[]{InputStream.class};
                        objectArray = new Object[]{new FileInputStream(file)};
                        inputStream = (InputStream)clazz.getConstructor(classArray).newInstance(objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DicomException("Not a correctly encoded Unix compress (.Z) bitstream - " + invocationTargetException);
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate Unix compress (.Z) codec - " + exception);
                    }
                } else if (string.endsWith(".BZ2")) {
                    try {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass("org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream");
                        classArray = new Class[]{InputStream.class};
                        objectArray = new Object[]{new FileInputStream(file)};
                        inputStream = (InputStream)clazz.getConstructor(classArray).newInstance(objectArray);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw new DicomException("Not a correctly encoded bzip2 bitstream - " + invocationTargetException);
                    }
                    catch (Exception exception) {
                        throw new DicomException("Could not instantiate bzip2 codec - " + exception);
                    }
                } else {
                    throw new DicomException("No decompressor found for file with extension " + string);
                }
                CopyStream.copy(inputStream, dicomOutputStream);
                ((InputStream)inputStream).close();
            }
            long l = this.getPaddedVL() - this.valueLength;
            while (l-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    @Override
    public void removeValues() {
        this.files = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

