/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.OtherAttributeOnDisk;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherWordAttributeOnDisk
extends OtherAttributeOnDisk {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherWordAttributeOnDisk.java,v 1.23 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(OtherWordAttributeOnDisk.class);
    protected boolean bigEndian;

    public OtherWordAttributeOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
        this.bigEndian = false;
    }

    public OtherWordAttributeOnDisk(AttributeTag attributeTag, boolean bl) {
        super(attributeTag);
        this.bigEndian = bl;
    }

    public OtherWordAttributeOnDisk(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream, l2);
        this.bigEndian = dicomInputStream.isBigEndian();
    }

    public OtherWordAttributeOnDisk(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, Long l2) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream, l2);
        this.bigEndian = dicomInputStream.isBigEndian();
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            CopyStream.skipInsistently(bufferedInputStream, this.byteOffset);
            if (this.bigEndian == dicomOutputStream.isBigEndian()) {
                CopyStream.copy(bufferedInputStream, dicomOutputStream, this.valueLength);
            } else {
                CopyStream.copyByteSwapped(bufferedInputStream, dicomOutputStream, this.valueLength);
            }
            bufferedInputStream.close();
        }
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public short[] getShortValues() throws DicomException {
        short[] sArray = null;
        if (this.valueLength > 0L) {
            int n = (int)(this.valueLength / 2L);
            sArray = new short[n];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), this.bigEndian);
                binaryInputStream.skipInsistently(this.byteOffset);
                binaryInputStream.readUnsigned16(sArray, 0, n);
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return sArray;
    }

    public short[][] getShortValuesPerFrame(int n) throws DicomException {
        Object object = null;
        if (this.valueLength > 0L) {
            long l = this.valueLength / (long)n;
            int n2 = (int)(l / 2L);
            object = new short[n][];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), false);
                binaryInputStream.skipInsistently(this.byteOffset);
                for (int i = 0; i < n; ++i) {
                    short[] sArray = new short[n2];
                    object[i] = sArray;
                    binaryInputStream.readUnsigned16(sArray, 0, n2);
                }
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
                throw new DicomException("Failed to read value (length " + this.valueLength + " dec) in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
        return object;
    }

    public short[] getShortValuesForSelectedFrame(int n, int n2) throws DicomException {
        short[] sArray = null;
        long l = this.valueLength / (long)n2;
        long l2 = l * (long)n;
        if (l2 + l <= this.valueLength) {
            int n3 = (int)(l / 2L);
            sArray = new short[n3];
            try {
                BinaryInputStream binaryInputStream = new BinaryInputStream(new FileInputStream(this.file), this.bigEndian);
                binaryInputStream.skipInsistently(this.byteOffset + l2);
                binaryInputStream.readUnsigned16(sArray, 0, n3);
                binaryInputStream.close();
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to read frame " + n + " of " + n2 + " frames, size " + l + " dec and offset " + l2 + " dec bytes in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        } else {
            throw new DicomException("Requested frame " + n + " of " + n2 + " frames, size " + l + " dec and offset " + l2 + " dec bytes to read value exceeds length " + this.valueLength + " dec in delayed read of " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
        }
        return sArray;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.OW;
    }
}

