/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.TagFromName;

public class PrivatePixelData {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/PrivatePixelData.java,v 1.14 2025/01/29 10:58:07 dclunie Exp $";
    public static final String pixelmedPrivateCreatorForFloatOrDoublePixelData = "PixelMed Publishing";
    public static final int pixelmedPrivatePixelDataGroup = 32737;
    public static final AttributeTag pixelmedPrivateFloatPixelData = new AttributeTag(32737, 4097);
    public static final AttributeTag pixelmedPrivateDoublePixelData = new AttributeTag(32737, 4098);

    public static Attribute getPixelData(AttributeList attributeList) {
        Attribute attribute = attributeList.get(TagFromName.PixelData);
        if (attribute == null) {
            attribute = attributeList.get(TagFromName.FloatPixelData);
        }
        if (attribute == null) {
            attribute = attributeList.get(TagFromName.DoubleFloatPixelData);
        }
        if (attribute == null) {
            attribute = attributeList.get(pixelmedPrivateFloatPixelData, pixelmedPrivateCreatorForFloatOrDoublePixelData);
        }
        if (attribute == null) {
            attribute = attributeList.get(pixelmedPrivateDoublePixelData, pixelmedPrivateCreatorForFloatOrDoublePixelData);
        }
        return attribute;
    }

    public static void replacePixelData(AttributeList attributeList, Attribute attribute) throws DicomException {
        attributeList.remove(TagFromName.PixelData);
        attributeList.remove(TagFromName.FloatPixelData);
        attributeList.remove(TagFromName.DoubleFloatPixelData);
        attributeList.removeGroup(32737);
        attributeList.put(attribute);
        AttributeTag attributeTag = attribute.getTag();
        if (attributeTag.isPrivate()) {
            LongStringAttribute longStringAttribute = new LongStringAttribute(new AttributeTag(attributeTag.getGroup(), attributeTag.getElement() >>> 8));
            ((Attribute)longStringAttribute).addValue(pixelmedPrivateCreatorForFloatOrDoublePixelData);
            attributeList.put(longStringAttribute);
        }
    }
}

