/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.anatproc.CodedConcept;
import com.pixelmed.anatproc.DisplayableAnatomicConcept;
import com.pixelmed.anatproc.ProjectionXRayAnatomy;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.HierarchicalImageReference;
import com.pixelmed.dicom.HierarchicalSOPInstanceReference;
import com.pixelmed.dicom.ImageLibrary;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectionXRayImageLibrary
extends ImageLibrary {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ProjectionXRayImageLibrary.java,v 1.15 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ImageLibrary.class);
    private static final DicomDictionary dictionary = DicomDictionary.StandardDictionary;

    @Override
    public ImageLibrary.ImageLibraryEntry makeImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
        return new ProjectionXRayImageLibraryEntry(imageContentItem, map);
    }

    @Override
    public ImageLibrary.ImageLibraryEntry makeImageLibraryEntry(AttributeList attributeList) throws DicomException {
        return new ProjectionXRayImageLibraryEntry(attributeList);
    }

    public ProjectionXRayImageLibrary() {
    }

    public ProjectionXRayImageLibrary(AttributeList attributeList) throws DicomException {
        StructuredReport structuredReport = new StructuredReport(attributeList);
        ContentItem contentItem = ProjectionXRayImageLibrary.findImageLibraryContainer((ContentItem)structuredReport.getRoot());
        if (contentItem == null) {
            throw new DicomException("No Image Library CONTAINER content item in SR");
        }
        this.constructImageLibrary(contentItem, attributeList);
    }

    public ProjectionXRayImageLibrary(ContentItem contentItem, AttributeList attributeList) {
        this.constructImageLibrary(contentItem, attributeList);
    }

    public static ProjectionXRayImageLibrary read(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string);
        return new ProjectionXRayImageLibrary(attributeList);
    }

    public ProjectionXRayImageLibrary(Set<File> set) throws IOException, DicomException {
        super(set);
    }

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            HashSet<File> hashSet = new HashSet<File>();
            for (int i = 1; i < stringArray.length; ++i) {
                ArrayList<File> arrayList = FileUtilities.listFilesRecursively(new File(stringArray[i]));
                hashSet.addAll(arrayList);
            }
            ProjectionXRayImageLibrary projectionXRayImageLibrary = new ProjectionXRayImageLibrary(hashSet);
            projectionXRayImageLibrary.write(string);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static class ProjectionXRayImageLibraryEntry
    extends ImageLibrary.ImageLibraryEntry {
        protected CodedSequenceItem anatomicalStructure;
        protected CodedSequenceItem imageLaterality;
        protected CodedSequenceItem imageView;
        protected CodedSequenceItem imageViewModifier;
        protected String patientOrientationRow;
        protected String patientOrientationColumn;
        protected String studyDate;
        protected String studyTime;
        protected String contentDate;
        protected String contentTime;
        protected String horizontalPixelSpacingInMM;
        protected String verticalPixelSpacingInMM;
        protected String positionerPrimaryAngleInDegrees;
        protected String positionerSecondaryAngleInDegrees;

        public CodedSequenceItem getImageLaterality() {
            return this.imageLaterality;
        }

        public void setImageLaterality(CodedSequenceItem codedSequenceItem) {
            this.imageLaterality = codedSequenceItem;
        }

        public ProjectionXRayImageLibraryEntry(ContentItemFactory.ImageContentItem imageContentItem, Map<String, HierarchicalSOPInstanceReference> map) {
            Object object;
            CodedSequenceItem codedSequenceItem = null;
            CodedSequenceItem codedSequenceItem2 = null;
            CodedSequenceItem codedSequenceItem3 = null;
            CodedSequenceItem codedSequenceItem4 = null;
            Object object2 = imageContentItem.getNamedChild("SRT", "T-D0005");
            if (object2 != null && object2 instanceof ContentItemFactory.CodeContentItem) {
                codedSequenceItem = ((ContentItemFactory.CodeContentItem)object2).getConceptCode();
            }
            if ((object2 = imageContentItem.getNamedChild("DCM", "111027")) != null && object2 instanceof ContentItemFactory.CodeContentItem) {
                codedSequenceItem2 = ((ContentItemFactory.CodeContentItem)object2).getConceptCode();
            }
            if ((object2 = imageContentItem.getNamedChild("DCM", "111031")) != null && object2 instanceof ContentItemFactory.CodeContentItem) {
                codedSequenceItem3 = ((ContentItemFactory.CodeContentItem)object2).getConceptCode();
                object = imageContentItem.getNamedChild("DCM", "111032");
                if (object != null && object instanceof ContentItemFactory.CodeContentItem) {
                    codedSequenceItem4 = ((ContentItemFactory.CodeContentItem)object).getConceptCode();
                }
            }
            object2 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111044");
            object = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111043");
            String string = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111060");
            String string2 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111061");
            String string3 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111018");
            String string4 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111019");
            String string5 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111026");
            String string6 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "111066");
            String string7 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "112011");
            String string8 = imageContentItem.getSingleStringValueOrNullOfNamedChild("DCM", "112012");
            String string9 = imageContentItem.getReferencedSOPInstanceUID();
            String string10 = imageContentItem.getReferencedSOPClassUID();
            HierarchicalSOPInstanceReference hierarchicalSOPInstanceReference = map.get(string9);
            HierarchicalImageReference hierarchicalImageReference = null;
            hierarchicalImageReference = hierarchicalSOPInstanceReference == null ? new HierarchicalImageReference(null, null, string9, string10) : new HierarchicalImageReference(hierarchicalSOPInstanceReference);
            this.constructProjectionXRayImageLibraryEntry(hierarchicalImageReference, codedSequenceItem, codedSequenceItem2, codedSequenceItem3, codedSequenceItem4, (String)object2, (String)object, string, string2, string3, string4, string5, string6, string7, string8);
        }

        public ProjectionXRayImageLibraryEntry(AttributeList attributeList) throws DicomException {
            Object object;
            String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID);
            String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID);
            String string3 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID);
            String string4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID);
            CodedSequenceItem codedSequenceItem = null;
            CodedSequenceItem codedSequenceItem2 = null;
            CodedSequenceItem codedSequenceItem3 = null;
            CodedSequenceItem codedSequenceItem4 = null;
            Object object2 = ProjectionXRayAnatomy.findAnatomicConcept(attributeList);
            Object object3 = ProjectionXRayAnatomy.findLaterality(attributeList, (DisplayableAnatomicConcept)object2);
            Object object4 = ProjectionXRayAnatomy.findView(attributeList);
            if (object2 != null) {
                codedSequenceItem = ((CodedConcept)object2).getCodedSequenceItem();
            }
            if (object3 != null) {
                codedSequenceItem2 = ((CodedConcept)object3).getCodedSequenceItem();
            }
            if (object4 != null) {
                codedSequenceItem3 = object4.getCodedSequenceItem();
            }
            object2 = null;
            object3 = null;
            object4 = Attribute.getStringValues(attributeList, TagFromName.PatientOrientation);
            if (object4 != null && ((String[])object4).length == 2) {
                object2 = object4[0];
                object3 = object4[1];
            }
            object4 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate);
            String string5 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyTime);
            String string6 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentDate);
            String string7 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.ContentTime);
            String string8 = null;
            String string9 = null;
            Object object5 = Attribute.getStringValues(attributeList, TagFromName.PixelSpacing);
            if (object5 != null && ((String[])object5).length == 2) {
                string8 = object5[0];
                string9 = object5[1];
            } else {
                object = Attribute.getStringValues(attributeList, TagFromName.ImagerPixelSpacing);
                if (object != null && ((String[])object).length == 2) {
                    string8 = object[0];
                    string9 = object[1];
                }
            }
            object5 = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("PositionerPrimaryAngle"));
            object = Attribute.getSingleStringValueOrEmptyString(attributeList, dictionary.getTagFromName("PositionerSecondaryAngle"));
            if (string.length() > 0 && string2.length() > 0 && string3.length() > 0 && string4.length() > 0) {
                HierarchicalImageReference hierarchicalImageReference = new HierarchicalImageReference(string, string2, string3, string4);
                this.constructProjectionXRayImageLibraryEntry(hierarchicalImageReference, codedSequenceItem, codedSequenceItem2, codedSequenceItem3, codedSequenceItem4, (String)object2, (String)object3, (String)object4, string5, string6, string7, string8, string9, (String)object5, (String)object);
            }
        }

        public ProjectionXRayImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference, CodedSequenceItem codedSequenceItem, CodedSequenceItem codedSequenceItem2, CodedSequenceItem codedSequenceItem3, CodedSequenceItem codedSequenceItem4, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            this.constructProjectionXRayImageLibraryEntry(hierarchicalImageReference, codedSequenceItem, codedSequenceItem2, codedSequenceItem3, codedSequenceItem4, string, string2, string3, string4, string5, string6, string7, string8, string9, string10);
        }

        protected void constructProjectionXRayImageLibraryEntry(HierarchicalImageReference hierarchicalImageReference, CodedSequenceItem codedSequenceItem, CodedSequenceItem codedSequenceItem2, CodedSequenceItem codedSequenceItem3, CodedSequenceItem codedSequenceItem4, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
            super.constructImageLibraryEntry(hierarchicalImageReference);
            this.anatomicalStructure = codedSequenceItem;
            this.imageLaterality = codedSequenceItem2;
            this.imageView = codedSequenceItem3;
            this.imageViewModifier = codedSequenceItem4;
            this.patientOrientationRow = string;
            this.patientOrientationColumn = string2;
            this.studyDate = string3;
            this.studyTime = string4;
            this.contentDate = string5;
            this.contentTime = string6;
            this.horizontalPixelSpacingInMM = string7;
            this.verticalPixelSpacingInMM = string8;
            this.positionerPrimaryAngleInDegrees = string9;
            this.positionerSecondaryAngleInDegrees = string10;
        }

        @Override
        public ContentItem getImageContentItem(ContentItemFactory contentItemFactory, ContentItem contentItem) throws DicomException {
            ContentItemFactory contentItemFactory2 = contentItemFactory;
            contentItemFactory2.getClass();
            ContentItemFactory.ImageContentItem imageContentItem = contentItemFactory2.new ContentItemFactory.ImageContentItem(contentItem, "CONTAINS", null, this.hierarchicalImageReference.getSOPClassUID(), this.hierarchicalImageReference.getSOPInstanceUID(), 0, 0, null, null, null, null);
            if (this.anatomicalStructure != null) {
                ContentItemFactory contentItemFactory3 = contentItemFactory;
                contentItemFactory3.getClass();
                contentItemFactory3.new ContentItemFactory.CodeContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("T-D0005", "SRT", "Anatomical structure"), this.anatomicalStructure);
            }
            if (this.imageLaterality != null) {
                ContentItemFactory contentItemFactory4 = contentItemFactory;
                contentItemFactory4.getClass();
                contentItemFactory4.new ContentItemFactory.CodeContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111027", "DCM", "Image Laterality"), this.imageLaterality);
            }
            if (this.imageView != null) {
                ContentItemFactory contentItemFactory5 = contentItemFactory;
                contentItemFactory5.getClass();
                ContentItemFactory.CodeContentItem codeContentItem = contentItemFactory5.new ContentItemFactory.CodeContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111031", "DCM", "Image View"), this.imageView);
                if (this.imageViewModifier != null) {
                    ContentItemFactory contentItemFactory6 = contentItemFactory;
                    contentItemFactory6.getClass();
                    contentItemFactory6.new ContentItemFactory.CodeContentItem(codeContentItem, "HAS CONCEPT MOD", new CodedSequenceItem("111032", "DCM", "Image View Modifier"), this.imageViewModifier);
                }
            }
            if (this.patientOrientationRow != null && this.patientOrientationRow.length() > 0) {
                ContentItemFactory contentItemFactory7 = contentItemFactory;
                contentItemFactory7.getClass();
                contentItemFactory7.new ContentItemFactory.TextContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111044", "DCM", "Patient Orientation Row"), this.patientOrientationRow);
            }
            if (this.patientOrientationColumn != null && this.patientOrientationColumn.length() > 0) {
                ContentItemFactory contentItemFactory8 = contentItemFactory;
                contentItemFactory8.getClass();
                contentItemFactory8.new ContentItemFactory.TextContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111043", "DCM", "Patient Orientation Column"), this.patientOrientationColumn);
            }
            if (this.studyDate != null && this.studyDate.length() > 0) {
                ContentItemFactory contentItemFactory9 = contentItemFactory;
                contentItemFactory9.getClass();
                contentItemFactory9.new ContentItemFactory.DateContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111060", "DCM", "Study Date"), this.studyDate);
            }
            if (this.studyTime != null && this.studyTime.length() > 0) {
                ContentItemFactory contentItemFactory10 = contentItemFactory;
                contentItemFactory10.getClass();
                contentItemFactory10.new ContentItemFactory.TimeContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111061", "DCM", "Study Time"), this.studyTime);
            }
            if (this.contentDate != null && this.contentDate.length() > 0) {
                ContentItemFactory contentItemFactory11 = contentItemFactory;
                contentItemFactory11.getClass();
                contentItemFactory11.new ContentItemFactory.DateContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111018", "DCM", "Content Date"), this.contentDate);
            }
            if (this.contentTime != null && this.contentTime.length() > 0) {
                ContentItemFactory contentItemFactory12 = contentItemFactory;
                contentItemFactory12.getClass();
                contentItemFactory12.new ContentItemFactory.TimeContentItem(imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111019", "DCM", "Content Time"), this.contentTime);
            }
            if (this.horizontalPixelSpacingInMM != null && this.horizontalPixelSpacingInMM.length() > 0) {
                ContentItemFactory contentItemFactory13 = contentItemFactory;
                contentItemFactory13.getClass();
                contentItemFactory13.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111026", "DCM", "Horizontal Pixel Spacing"), this.horizontalPixelSpacingInMM, new CodedSequenceItem("mm", "UCUM", "mm"));
            }
            if (this.verticalPixelSpacingInMM != null && this.verticalPixelSpacingInMM.length() > 0) {
                ContentItemFactory contentItemFactory14 = contentItemFactory;
                contentItemFactory14.getClass();
                contentItemFactory14.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("111066", "DCM", "Vertical Pixel Spacing"), this.verticalPixelSpacingInMM, new CodedSequenceItem("mm", "UCUM", "mm"));
            }
            if (this.positionerPrimaryAngleInDegrees != null && this.positionerPrimaryAngleInDegrees.length() > 0) {
                ContentItemFactory contentItemFactory15 = contentItemFactory;
                contentItemFactory15.getClass();
                contentItemFactory15.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("112011", "DCM", "Positioner Primary Angle"), this.positionerPrimaryAngleInDegrees, new CodedSequenceItem("deg", "UCUM", "deg"));
            }
            if (this.positionerSecondaryAngleInDegrees != null && this.positionerSecondaryAngleInDegrees.length() > 0) {
                ContentItemFactory contentItemFactory16 = contentItemFactory;
                contentItemFactory16.getClass();
                contentItemFactory16.new ContentItemFactory.NumericContentItem((ContentItem)imageContentItem, "HAS ACQ CONTEXT", new CodedSequenceItem("112012", "DCM", "Positioner Secondary Angle"), this.positionerSecondaryAngleInDegrees, new CodedSequenceItem("deg", "UCUM", "deg"));
            }
            return imageContentItem;
        }

        @Override
        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Entry:\n");
            stringBuffer.append(this.hierarchicalImageReference);
            stringBuffer.append("\n");
            stringBuffer.append("Anatomical structure = ");
            stringBuffer.append(this.anatomicalStructure);
            stringBuffer.append("\n");
            stringBuffer.append("Image Laterality = ");
            stringBuffer.append(this.imageLaterality);
            stringBuffer.append("\n");
            stringBuffer.append("Image View = ");
            stringBuffer.append(this.imageView);
            stringBuffer.append("\n");
            stringBuffer.append("Image View Modifier = ");
            stringBuffer.append(this.imageViewModifier);
            stringBuffer.append("\n");
            stringBuffer.append("Patient Orientation Row = ");
            stringBuffer.append(this.patientOrientationRow);
            stringBuffer.append("\n");
            stringBuffer.append("Patient Orientation Column = ");
            stringBuffer.append(this.patientOrientationColumn);
            stringBuffer.append("\n");
            stringBuffer.append("Study Date = ");
            stringBuffer.append(this.studyDate);
            stringBuffer.append("\n");
            stringBuffer.append("Study Time = ");
            stringBuffer.append(this.studyTime);
            stringBuffer.append("\n");
            stringBuffer.append("Content Date = ");
            stringBuffer.append(this.contentDate);
            stringBuffer.append("\n");
            stringBuffer.append("Content Time = ");
            stringBuffer.append(this.contentTime);
            stringBuffer.append("\n");
            stringBuffer.append("Horizontal Pixel Spacing = ");
            stringBuffer.append(this.horizontalPixelSpacingInMM);
            stringBuffer.append(" mm\n");
            stringBuffer.append("Vertical Pixel Spacing = ");
            stringBuffer.append(this.verticalPixelSpacingInMM);
            stringBuffer.append(" mm\n");
            stringBuffer.append("Positioner Primary Angle = ");
            stringBuffer.append(this.positionerPrimaryAngleInDegrees);
            stringBuffer.append(" deg\n");
            stringBuffer.append("Positioner Secondary Angle = ");
            stringBuffer.append(this.positionerSecondaryAngleInDegrees);
            stringBuffer.append(" deg\n");
            return stringBuffer.toString();
        }
    }
}

