/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class SOPClass {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SOPClass.java,v 1.106 2025/02/12 18:15:47 dclunie Exp $";
    public static final String Verification = "1.2.840.10008.1.1";
    public static final String PrivateGEDicomMRImageInfoObject = "1.2.840.113619.4.2";
    public static final String PrivateGEDicomCTImageInfoObject = "1.2.840.113619.4.3";
    public static final String PrivateGEDicomDisplayImageInfoObject = "1.2.840.113619.4.4";
    public static final String PrivateGEPETRawDataStorage = "1.2.840.113619.4.30";
    public static final String PrivateGE3DModelStorage = "1.2.840.113619.4.26";
    public static final String PrivateGEeNTEGRAProtocolOrNMGenieStorage = "1.2.840.113619.4.27";
    public static final String PrivateGECollageStorage = "1.2.528.1.1001.5.1.1.1";
    public static final String PrivateGERTPlanStorage = "1.2.840.113619.4.5.249";
    public static final String PrivateSiemensCSANonImageStorage = "1.3.12.2.1107.5.9.1";
    public static final String PrivateSiemensCTMRVolumeStorage = "1.3.12.2.1107.5.99.3.10";
    public static final String PrivateSiemensAXFrameSetsStorage = "1.3.12.2.1107.5.99.3.11";
    public static final String PrivateAgfaBasicAttributePresentationStateStorage = "1.2.124.113532.3500.7";
    public static final String PrivateMedicalInsight3DSoftcopyPresentationStateStorage = "1.3.6.1.4.1.16978.3.1";
    public static final String PrivateAcusonStructuredReportDetailStorage = "1.2.840.10008.5.1.4.1.1.88.3";
    public static final String PrivateTomTecAnnotationStorage = "1.2.276.0.48.5.1.4.1.1.7";
    public static final String PrivateFujiCRImageStorage = "1.2.392.200036.9125.1.1.2";
    public static final String PrivatePhilipsSpecialisedXAStorage = "1.3.46.670589.2.3.1.1";
    public static final String PrivatePhilipsCXImageStorage = "1.3.46.670589.2.4.1.1";
    public static final String PrivatePhilips3DPresentationStateStorage = "1.3.46.670589.2.5.1.1";
    public static final String PrivatePhilipsVolumeStorage = "1.3.46.670589.5.0.1";
    public static final String PrivatePhilipsVolume2Storage = "1.3.46.670589.5.0.1.1";
    public static final String PrivatePhilips3DObjectStorage = "1.3.46.670589.5.0.2";
    public static final String PrivatePhilips3DObject2Storage = "1.3.46.670589.5.0.2.1";
    public static final String PrivatePhilipsSurfaceStorage = "1.3.46.670589.5.0.3";
    public static final String PrivatePhilipsSurface2Storage = "1.3.46.670589.5.0.3.1";
    public static final String PrivatePhilipsCompositeObjectStorage = "1.3.46.670589.5.0.4";
    public static final String PrivatePhilipsMRCardioProfileStorage = "1.3.46.670589.5.0.7";
    public static final String PrivatePhilipsMRCardioStorage = "1.3.46.670589.5.0.8";
    public static final String PrivatePhilipsMRCardio2Storage = "1.3.46.670589.5.0.8.1";
    public static final String PrivatePhilipsCTSyntheticImageStorage = "1.3.46.670589.5.0.9";
    public static final String PrivatePhilipsMRSyntheticImageStorage = "1.3.46.670589.5.0.10";
    public static final String PrivatePhilipsMRCardioAnalysisStorage = "1.3.46.670589.5.0.11";
    public static final String PrivatePhilipsMRCardioAnalysis2Storage = "1.3.46.670589.5.0.11.1";
    public static final String PrivatePhilipsCXSyntheticImageStorage = "1.3.46.670589.5.0.12";
    public static final String PrivatePhilipsPerfusionStorage = "1.3.46.670589.5.0.13";
    public static final String PrivatePhilipsPerfusionImageStorage = "1.3.46.670589.5.0.14";
    public static final String PrivatePhilipsMRSpectrumStorage = "1.3.46.670589.11.0.0.12.1";
    public static final String PrivatePhilipsMRSeriesDataStorage = "1.3.46.670589.11.0.0.12.2";
    public static final String PrivatePhilipsMRColorImageStorage = "1.3.46.670589.11.0.0.12.3";
    public static final String PrivatePhilipsMRExamcardStorage = "1.3.46.670589.11.0.0.12.4";
    public static final String PrivatePhilipsVRMLStorage = "1.3.46.670589.2.8.1.1 ";
    public static final String PrivatePhilipsVolumeSetStorage = "1.3.46.670589.2.11.1.1";
    public static final String PrivatePhilipsLiveRunStorage = "1.3.46.670589.7.8.1618510092";
    public static final String PrivatePhilipsRunStorage = "1.3.46.670589.7.8.16185100129";
    public static final String PrivatePhilipsReconstructionStorage = "1.3.46.670589.7.8.16185100130";
    public static final String PrivatePhilipsXRayMFStorage = "1.3.46.670589.7.8.1618510091";
    public static final String PrivatePhilipsHPLive3D01Storage = "1.2.840.113543.6.6.1.3.10001";
    public static final String PrivatePhilipsHPLive3D02Storage = "1.2.840.113543.6.6.1.3.10002";
    public static final String PrivatePMODMultiframeImageStorage = "2.16.840.1.114033.5.1.4.1.1.130";
    public static final String PrivateToshibaUSImageStorage = "1.2.392.200036.9116.7.8.1.1.1";
    public static final String PrivateERADPracticeBuilderReportTextStorage = "1.2.826.0.1.3680043.293.1.0.1";
    public static final String PrivateERADPracticeBuilderReportDictationStorage = "1.2.826.0.1.3680043.293.1.0.2";
    public static final String PrivateDcm4cheUpgradedCTImageStorage = "1.2.40.0.13.1.5.1.4.1.1.2.1";
    public static final String PrivateDcm4cheUpgradedMRImageStorage = "1.2.40.0.13.1.5.1.4.1.1.4.1";
    public static final String PrivateDcm4cheUpgradedPETImageStorage = "1.2.40.0.13.1.5.1.4.1.1.128.1";
    public static final String PrivateDcm4cheEncapsulatedDocumentStorage = "1.2.40.0.13.1.5.1.4.1.1.104.1";
    public static final String PrivatePixelMedLegacyConvertedEnhancedCTImageStorage = "1.3.6.1.4.1.5962.301.1";
    public static final String PrivatePixelMedLegacyConvertedEnhancedMRImageStorage = "1.3.6.1.4.1.5962.301.2";
    public static final String PrivatePixelMedLegacyConvertedEnhancedPETImageStorage = "1.3.6.1.4.1.5962.301.3";
    public static final String PrivatePixelMedFloatingPointImageStorage = "1.3.6.1.4.1.5962.301.9";
    public static final String DICOSCTImageStorage = "1.2.840.10008.5.1.4.1.1.501.1";
    public static final String DICOSDigitalXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.501.2.1";
    public static final String DICOSDigitalXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.501.2.2";
    public static final String DICOSThreatDetectionReportStorage = "1.2.840.10008.5.1.4.1.1.501.3";
    public static final String DICOS2DAITStorage = "1.2.840.10008.5.1.4.1.1.501.4";
    public static final String DICOS3DAITStorage = "1.2.840.10008.5.1.4.1.1.501.5";
    public static final String DICOSQuadrupoleResonanceStorage = "1.2.840.10008.5.1.4.1.1.501.6";
    public static final String DICONDEEddyCurrentImageStorage = "1.2.840.10008.5.1.4.1.1.601.1";
    public static final String DICONDEEddyCurrentMultiframeImageStorage = "1.2.840.10008.5.1.4.1.1.601.2";
    public static final String ComputedRadiographyImageStorage = "1.2.840.10008.5.1.4.1.1.1";
    public static final String DigitalXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.1";
    public static final String DigitalXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.1.1";
    public static final String DigitalMammographyXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.2";
    public static final String DigitalMammographyXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.2.1";
    public static final String DigitalIntraoralXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.1.3";
    public static final String DigitalIntraoralXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.1.3.1";
    public static final String CTImageStorage = "1.2.840.10008.5.1.4.1.1.2";
    public static final String EnhancedCTImageStorage = "1.2.840.10008.5.1.4.1.1.2.1";
    public static final String LegacyConvertedEnhancedCTImageStorage = "1.2.840.10008.5.1.4.1.1.2.2";
    public static final String UltrasoundMultiframeImageStorageRetired = "1.2.840.10008.5.1.4.1.1.3";
    public static final String UltrasoundMultiframeImageStorage = "1.2.840.10008.5.1.4.1.1.3.1";
    public static final String MRImageStorage = "1.2.840.10008.5.1.4.1.1.4";
    public static final String EnhancedMRImageStorage = "1.2.840.10008.5.1.4.1.1.4.1";
    public static final String EnhancedMRColorImageStorage = "1.2.840.10008.5.1.4.1.1.4.3";
    public static final String LegacyConvertedEnhancedMRImageStorage = "1.2.840.10008.5.1.4.1.1.4.4";
    public static final String NuclearMedicineImageStorageRetired = "1.2.840.10008.5.1.4.1.1.5";
    public static final String UltrasoundImageStorageRetired = "1.2.840.10008.5.1.4.1.1.6";
    public static final String UltrasoundImageStorage = "1.2.840.10008.5.1.4.1.1.6.1";
    public static final String EnhancedUSVolumeStorage = "1.2.840.10008.5.1.4.1.1.6.2";
    public static final String PhotoacousticImageStorage = "1.2.840.10008.5.1.4.1.1.6.3";
    public static final String SecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7";
    public static final String MultiframeSingleBitSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.1";
    public static final String MultiframeGrayscaleByteSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.2";
    public static final String MultiframeGrayscaleWordSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.3";
    public static final String MultiframeTrueColorSecondaryCaptureImageStorage = "1.2.840.10008.5.1.4.1.1.7.4";
    public static final String XRayAngiographicImageStorage = "1.2.840.10008.5.1.4.1.1.12.1";
    public static final String EnhancedXAImageStorage = "1.2.840.10008.5.1.4.1.1.12.1.1";
    public static final String XRayRadioFlouroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.12.2";
    public static final String EnhancedXRFImageStorage = "1.2.840.10008.5.1.4.1.1.12.2.1";
    public static final String XRayAngiographicBiplaneImageStorage = "1.2.840.10008.5.1.4.1.1.12.3";
    public static final String XRay3DAngiographicImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.1";
    public static final String XRay3DCraniofacialImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.2";
    public static final String BreastTomosynthesisImageStorage = "1.2.840.10008.5.1.4.1.1.13.1.3";
    public static final String BreastProjectionXRayImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.13.1.4";
    public static final String BreastProjectionXRayImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.13.1.5";
    public static final String NuclearMedicineImageStorage = "1.2.840.10008.5.1.4.1.1.20";
    public static final String ParametricMapStorage = "1.2.840.10008.5.1.4.1.1.30";
    public static final String VisibleLightDraftImageStorage = "1.2.840.10008.5.1.4.1.1.77.1";
    public static final String VisibleLightMultiFrameDraftImageStorage = "1.2.840.10008.5.1.4.1.1.77.2";
    public static final String VisibleLightEndoscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.1";
    public static final String VideoEndoscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.1.1";
    public static final String VisibleLightMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.2";
    public static final String VideoMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.2.1";
    public static final String VisibleLightSlideCoordinatesMicroscopicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.3";
    public static final String VisibleLightPhotographicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.4";
    public static final String VideoPhotographicImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.4.1";
    public static final String OphthalmicPhotography8BitImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.1";
    public static final String OphthalmicPhotography16BitImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.2";
    public static final String OphthalmicTomographyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.4";
    public static final String WideFieldOphthalmicPhotographyStereographicProjectionImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.5";
    public static final String WideFieldOphthalmicPhotography3DCoordinatesImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.6";
    public static final String OphthalmicOpticalCoherenceTomographyEnFaceImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.7";
    public static final String OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.8";
    public static final String OphthalmicThicknessMapStorage = "1.2.840.10008.5.1.4.1.1.81.1";
    public static final String CornealTopographyMapStorage = "1.2.840.10008.5.1.4.1.1.82.1";
    public static final String VLWholeSlideMicroscopyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.6";
    public static final String DermoscopicPhotographyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.7";
    public static final String ConfocalMicroscopyImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.8";
    public static final String ConfocalMicroscopyTiledPyramidalImageStorage = "1.2.840.10008.5.1.4.1.1.77.1.9";
    public static final String PETImageStorage = "1.2.840.10008.5.1.4.1.1.128";
    public static final String LegacyConvertedEnhancedPETImageStorage = "1.2.840.10008.5.1.4.1.1.128.1";
    public static final String EnhancedPETImageStorage = "1.2.840.10008.5.1.4.1.1.130";
    public static final String RTImageStorage = "1.2.840.10008.5.1.4.1.1.481.1";
    public static final String SegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.4";
    public static final String LabelMapSegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.7";
    public static final String HeightMapSegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.8";
    public static final String IVOCTImageStorageForPresentation = "1.2.840.10008.5.1.4.1.1.14.1";
    public static final String IVOCTImageStorageForProcessing = "1.2.840.10008.5.1.4.1.1.14.2";
    public static final String MediaStorageDirectoryStorage = "1.2.840.10008.1.3.10";
    public static final String BasicTextSRStorage = "1.2.840.10008.5.1.4.1.1.88.11";
    public static final String EnhancedSRStorage = "1.2.840.10008.5.1.4.1.1.88.22";
    public static final String ComprehensiveSRStorage = "1.2.840.10008.5.1.4.1.1.88.33";
    public static final String Comprehensive3DSRStorage = "1.2.840.10008.5.1.4.1.1.88.34";
    public static final String ExtensibleSRStorage = "1.2.840.10008.5.1.4.1.1.88.35";
    public static final String MammographyCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.50";
    public static final String ChestCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.65";
    public static final String ProcedureLogStorage = "1.2.840.10008.5.1.4.1.1.88.40";
    public static final String XRayRadiationDoseSRStorage = "1.2.840.10008.5.1.4.1.1.88.67";
    public static final String RadiopharmaceuticalRadiationDoseSRStorage = "1.2.840.10008.5.1.4.1.1.88.68";
    public static final String ColonCADSRStorage = "1.2.840.10008.5.1.4.1.1.88.69";
    public static final String ImplantationPlanSRStorage = "1.2.840.10008.5.1.4.1.1.88.70";
    public static final String AcquisitionContextSRStorage = "1.2.840.10008.5.1.4.1.1.88.71";
    public static final String SimplifiedAdultEchoSRStorage = "1.2.840.10008.5.1.4.1.1.88.72";
    public static final String PatientRadiationDoseSRStorage = "1.2.840.10008.5.1.4.1.1.88.73";
    public static final String MacularGridThicknessAndVolumeReportStorage = "1.2.840.10008.5.1.4.1.1.79.1";
    public static final String KeyObjectSelectionDocumentStorage = "1.2.840.10008.5.1.4.1.1.88.59";
    public static final String SpectaclePrescriptionReportStorage = "1.2.840.10008.5.1.4.1.1.78.6";
    public static final String TextSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.1";
    public static final String AudioSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.2";
    public static final String DetailSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.3";
    public static final String ComprehensiveSRStorageTrialRetired = "1.2.840.10008.5.1.4.1.1.88.4";
    public static final String GrayscaleSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.1";
    public static final String ColorSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.2";
    public static final String PseudoColorSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.3";
    public static final String BlendingSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.4";
    public static final String XAXRFGrayscaleSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.5";
    public static final String GrayscalePlanarMPRVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.6";
    public static final String CompositingPlanarMPRVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.7";
    public static final String AdvancedBlendingPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.8";
    public static final String VolumeRenderingVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.9";
    public static final String SegmentedVolumeRenderingVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.10";
    public static final String MultipleVolumeRenderingVolumetricPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.11";
    public static final String VariableModalityLUTSoftcopyPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.11.12";
    public static final String WaveformPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.9.100.1";
    public static final String WaveformAcquisitionPresentationStateStorage = "1.2.840.10008.5.1.4.1.1.9.100.2";
    public static final String TwelveLeadECGStorage = "1.2.840.10008.5.1.4.1.1.9.1.1";
    public static final String GeneralECGStorage = "1.2.840.10008.5.1.4.1.1.9.1.2";
    public static final String HemodynamicWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.2.1";
    public static final String AmbulatoryECGStorage = "1.2.840.10008.5.1.4.1.1.9.1.3";
    public static final String CardiacElectrophysiologyWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.3.1";
    public static final String BasicVoiceStorage = "1.2.840.10008.5.1.4.1.1.9.4.1";
    public static final String GeneralAudioWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.4.2";
    public static final String ArterialPulseWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.5.1";
    public static final String RespiratoryWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.6.1";
    public static final String MultichannelRespiratoryWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.6.2";
    public static final String RoutineScalpElectroencephalogramWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.7.1";
    public static final String ElectromyogramWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.7.2";
    public static final String ElectrooculogramWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.7.3";
    public static final String SleepElectroencephalogramWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.7.4";
    public static final String BodyPositionWaveformStorage = "1.2.840.10008.5.1.4.1.1.9.8.1";
    public static final String StandaloneOverlayStorage = "1.2.840.10008.5.1.4.1.1.8";
    public static final String StandaloneCurveStorage = "1.2.840.10008.5.1.4.1.1.9";
    public static final String StandaloneModalityLUTStorage = "1.2.840.10008.5.1.4.1.1.10";
    public static final String StandaloneVOILUTStorage = "1.2.840.10008.5.1.4.1.1.11";
    public static final String StandalonePETCurveStorage = "1.2.840.10008.5.1.4.1.1.129";
    public static final String RTDoseStorage = "1.2.840.10008.5.1.4.1.1.481.2";
    public static final String RTStructureSetStorage = "1.2.840.10008.5.1.4.1.1.481.3";
    public static final String RTBeamsTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.4";
    public static final String RTPlanStorage = "1.2.840.10008.5.1.4.1.1.481.5";
    public static final String RTBrachyTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.6";
    public static final String RTTreatmentSummaryRecordStorage = "1.2.840.10008.5.1.4.1.1.481.7";
    public static final String RTIonPlanStorage = "1.2.840.10008.5.1.4.1.1.481.8";
    public static final String RTIonBeamsTreatmentRecordStorage = "1.2.840.10008.5.1.4.1.1.481.9";
    public static final String RTPhysicianIntentStorage = "1.2.840.10008.5.1.4.1.1.481.10";
    public static final String RTSegmentAnnotationStorage = "1.2.840.10008.5.1.4.1.1.481.11";
    public static final String RTRadiationSetStorage = "1.2.840.10008.5.1.4.1.1.481.12";
    public static final String CArmPhotonElectronRadiationStorage = "1.2.840.10008.5.1.4.1.1.481.13";
    public static final String TomotherapeuticRadiationStorage = "1.2.840.10008.5.1.4.1.1.481.14";
    public static final String RoboticArmRadiationStorage = "1.2.840.10008.5.1.4.1.1.481.15";
    public static final String RTRadiationRecordSetStorage = "1.2.840.10008.5.1.4.1.1.481.16";
    public static final String RTRadiationSalvageRecordStorage = "1.2.840.10008.5.1.4.1.1.481.17";
    public static final String TomotherapeuticRadiationRecordStorage = "1.2.840.10008.5.1.4.1.1.481.18";
    public static final String CArmPhotonElectronRadiationRecordStorage = "1.2.840.10008.5.1.4.1.1.481.19";
    public static final String RoboticRadiationRecordStorage = "1.2.840.10008.5.1.4.1.1.481.20";
    public static final String RTBeamsDeliveryInstructionStorageTrial = "1.2.840.10008.5.1.4.34.1";
    public static final String RTBeamsDeliveryInstructionStorage = "1.2.840.10008.5.1.4.34.4";
    public static final String MRSpectroscopyStorage = "1.2.840.10008.5.1.4.1.1.4.2";
    public static final String RawDataStorage = "1.2.840.10008.5.1.4.1.1.66";
    public static final String EncapsulatedPDFStorage = "1.2.840.10008.5.1.4.1.1.104.1";
    public static final String EncapsulatedCDAStorage = "1.2.840.10008.5.1.4.1.1.104.2";
    public static final String EncapsulatedSTLStorage = "1.2.840.10008.5.1.4.1.1.104.3";
    public static final String SpatialRegistrationStorage = "1.2.840.10008.5.1.4.1.1.66.1";
    public static final String SpatialFiducialsStorage = "1.2.840.10008.5.1.4.1.1.66.2";
    public static final String DeformableSpatialRegistrationStorage = "1.2.840.10008.5.1.4.1.1.66.3";
    public static final String StereometricRelationshipStorage = "1.2.840.10008.5.1.4.1.1.77.1.5.3";
    public static final String RealWorldValueMappingStorage = "1.2.840.10008.5.1.4.1.1.67";
    public static final String SurfaceSegmentationStorage = "1.2.840.10008.5.1.4.1.1.66.5";
    public static final String TractographyResultsStorage = "1.2.840.10008.5.1.4.1.1.66.6";
    public static final String SurfaceScanMeshStorage = "1.2.840.10008.5.1.4.1.1.68.1";
    public static final String SurfaceScanPointCloudStorage = "1.2.840.10008.5.1.4.1.1.68.2";
    public static final String BasicStructuredDisplayStorage = "1.2.840.10008.5.1.4.1.1.131";
    public static final String LensometryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.1";
    public static final String AutorefractionMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.2";
    public static final String KeratometryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.3";
    public static final String SubjectiveRefractionMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.4";
    public static final String VisualAcuityMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.5";
    public static final String OphthalmicAxialMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.78.7";
    public static final String IntraocularLensCalculationsStorage = "1.2.840.10008.5.1.4.1.1.78.8";
    public static final String OphthalmicVisualFieldStaticPerimetryMeasurementsStorage = "1.2.840.10008.5.1.4.1.1.80.1";
    public static final String ColorPaletteStorage = "1.2.840.10008.5.1.4.39.1";
    public static final String GenericImplantTemplateStorage = "1.2.840.10008.5.1.4.43.1";
    public static final String ImplantAssemblyTemplateStorage = "1.2.840.10008.5.1.4.44.1";
    public static final String ImplantTemplateGroupStorage = "1.2.840.10008.5.1.4.45.1";
    public static final String StudyRootQueryRetrieveInformationModelFind = "1.2.840.10008.5.1.4.1.2.2.1";
    public static final String StudyRootQueryRetrieveInformationModelMove = "1.2.840.10008.5.1.4.1.2.2.2";
    public static final String StudyRootQueryRetrieveInformationModelGet = "1.2.840.10008.5.1.4.1.2.2.3";
    public static final String PatientRootQueryRetrieveInformationModelFind = "1.2.840.10008.5.1.4.1.2.1.1";
    public static final String PatientRootQueryRetrieveInformationModelMove = "1.2.840.10008.5.1.4.1.2.1.2";
    public static final String PatientRootQueryRetrieveInformationModelGet = "1.2.840.10008.5.1.4.1.2.1.3";
    public static final String PatientStudyOnlyQueryRetrieveInformationModelFind = "1.2.840.10008.5.1.4.1.2.3.1";
    public static final String PatientStudyOnlyQueryRetrieveInformationModelMove = "1.2.840.10008.5.1.4.1.2.3.2";
    public static final String PatientStudyOnlyQueryRetrieveInformationModelGet = "1.2.840.10008.5.1.4.1.2.3.3";
    public static final String ColorPaletteInformationModelFind = "1.2.840.10008.39.2";
    public static final String ColorPaletteInformationModelMove = "1.2.840.10008.39.3";
    public static final String ColorPaletteInformationModelGet = "1.2.840.10008.39.4";
    public static final String[] arrayOfQuerySOPClasses = new String[]{"1.2.840.10008.5.1.4.1.2.2.1", "1.2.840.10008.5.1.4.1.2.1.1", "1.2.840.10008.5.1.4.1.2.3.1", "1.2.840.10008.39.2"};
    public static final String[] arrayOfRetrieveWithMoveSOPClasses = new String[]{"1.2.840.10008.5.1.4.1.2.2.2", "1.2.840.10008.5.1.4.1.2.1.2", "1.2.840.10008.5.1.4.1.2.3.2", "1.2.840.10008.39.3"};
    public static final String[] arrayOfRetrieveWithGetSOPClasses = new String[]{"1.2.840.10008.5.1.4.1.2.2.3", "1.2.840.10008.5.1.4.1.2.1.3", "1.2.840.10008.5.1.4.1.2.3.3", "1.2.840.10008.39.4"};
    public static final String[] arrayOfStorageSOPClasses = new String[]{"1.2.840.10008.5.1.4.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.1.1", "1.2.840.10008.5.1.4.1.1.1.2", "1.2.840.10008.5.1.4.1.1.1.2.1", "1.2.840.10008.5.1.4.1.1.1.3", "1.2.840.10008.5.1.4.1.1.1.3.1", "1.2.840.10008.5.1.4.1.1.2", "1.2.840.10008.5.1.4.1.1.2.1", "1.2.840.10008.5.1.4.1.1.3", "1.2.840.10008.5.1.4.1.1.3.1", "1.2.840.10008.5.1.4.1.1.4", "1.2.840.10008.5.1.4.1.1.4.1", "1.2.840.10008.5.1.4.1.1.5", "1.2.840.10008.5.1.4.1.1.6", "1.2.840.10008.5.1.4.1.1.6.1", "1.2.840.10008.5.1.4.1.1.6.2", "1.2.840.10008.5.1.4.1.1.6.3", "1.2.840.10008.5.1.4.1.1.7", "1.2.840.10008.5.1.4.1.1.7.1", "1.2.840.10008.5.1.4.1.1.7.2", "1.2.840.10008.5.1.4.1.1.7.3", "1.2.840.10008.5.1.4.1.1.7.4", "1.2.840.10008.5.1.4.1.1.12.1", "1.2.840.10008.5.1.4.1.1.12.1.1", "1.2.840.10008.5.1.4.1.1.12.2", "1.2.840.10008.5.1.4.1.1.12.2.1", "1.2.840.10008.5.1.4.1.1.12.3", "1.2.840.10008.5.1.4.1.1.13.1.1", "1.2.840.10008.5.1.4.1.1.13.1.2", "1.2.840.10008.5.1.4.1.1.13.1.3", "1.2.840.10008.5.1.4.1.1.13.1.4", "1.2.840.10008.5.1.4.1.1.13.1.5", "1.2.840.10008.5.1.4.1.1.20", "1.2.840.10008.5.1.4.1.1.77.1", "1.2.840.10008.5.1.4.1.1.77.2", "1.2.840.10008.5.1.4.1.1.77.1.1", "1.2.840.10008.5.1.4.1.1.77.1.1.1", "1.2.840.10008.5.1.4.1.1.77.1.2", "1.2.840.10008.5.1.4.1.1.77.1.2.1", "1.2.840.10008.5.1.4.1.1.77.1.3", "1.2.840.10008.5.1.4.1.1.77.1.4", "1.2.840.10008.5.1.4.1.1.77.1.4.1", "1.2.840.10008.5.1.4.1.1.77.1.5.1", "1.2.840.10008.5.1.4.1.1.77.1.5.2", "1.2.840.10008.5.1.4.1.1.77.1.5.4", "1.2.840.10008.5.1.4.1.1.77.1.5.5", "1.2.840.10008.5.1.4.1.1.77.1.5.6", "1.2.840.10008.5.1.4.1.1.77.1.5.7", "1.2.840.10008.5.1.4.1.1.77.1.5.8", "1.2.840.10008.5.1.4.1.1.81.1", "1.2.840.10008.5.1.4.1.1.82.1", "1.2.840.10008.5.1.4.1.1.77.1.6", "1.2.840.10008.5.1.4.1.1.77.1.7", "1.2.840.10008.5.1.4.1.1.77.1.8", "1.2.840.10008.5.1.4.1.1.77.1.9", "1.2.840.10008.5.1.4.1.1.128", "1.2.840.10008.5.1.4.1.1.481.1", "1.2.840.10008.5.1.4.1.1.14.1", "1.2.840.10008.5.1.4.1.1.14.2", "1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.34", "1.2.840.10008.5.1.4.1.1.88.35", "1.2.840.10008.5.1.4.1.1.88.50", "1.2.840.10008.5.1.4.1.1.88.65", "1.2.840.10008.5.1.4.1.1.88.40", "1.2.840.10008.5.1.4.1.1.88.67", "1.2.840.10008.5.1.4.1.1.88.68", "1.2.840.10008.5.1.4.1.1.88.69", "1.2.840.10008.5.1.4.1.1.88.70", "1.2.840.10008.5.1.4.1.1.88.71", "1.2.840.10008.5.1.4.1.1.88.72", "1.2.840.10008.5.1.4.1.1.88.73", "1.2.840.10008.5.1.4.1.1.79.1", "1.2.840.10008.5.1.4.1.1.88.59", "1.2.840.10008.5.1.4.1.1.11.1", "1.2.840.10008.5.1.4.1.1.11.2", "1.2.840.10008.5.1.4.1.1.11.3", "1.2.840.10008.5.1.4.1.1.11.4", "1.2.840.10008.5.1.4.1.1.11.5", "1.2.840.10008.5.1.4.1.1.11.6", "1.2.840.10008.5.1.4.1.1.11.7", "1.2.840.10008.5.1.4.1.1.11.8", "1.2.840.10008.5.1.4.1.1.11.9", "1.2.840.10008.5.1.4.1.1.11.10", "1.2.840.10008.5.1.4.1.1.11.11", "1.2.840.10008.5.1.4.1.1.11.12", "1.2.840.10008.5.1.4.1.1.9.100.1", "1.2.840.10008.5.1.4.1.1.9.100.2", "1.2.840.10008.5.1.4.1.1.9.1.1", "1.2.840.10008.5.1.4.1.1.9.1.2", "1.2.840.10008.5.1.4.1.1.9.1.3", "1.2.840.10008.5.1.4.1.1.9.2.1", "1.2.840.10008.5.1.4.1.1.9.3.1", "1.2.840.10008.5.1.4.1.1.9.5.1", "1.2.840.10008.5.1.4.1.1.9.6.1", "1.2.840.10008.5.1.4.1.1.9.4.1", "1.2.840.10008.5.1.4.1.1.9.4.2", "1.2.840.10008.5.1.4.1.1.8", "1.2.840.10008.5.1.4.1.1.9", "1.2.840.10008.5.1.4.1.1.10", "1.2.840.10008.5.1.4.1.1.11", "1.2.840.10008.5.1.4.1.1.129", "1.2.840.10008.5.1.4.1.1.481.2", "1.2.840.10008.5.1.4.1.1.481.3", "1.2.840.10008.5.1.4.1.1.481.4", "1.2.840.10008.5.1.4.1.1.481.9", "1.2.840.10008.5.1.4.1.1.481.5", "1.2.840.10008.5.1.4.1.1.481.8", "1.2.840.10008.5.1.4.1.1.481.6", "1.2.840.10008.5.1.4.1.1.481.7", "1.2.840.10008.5.1.4.1.1.4.2", "1.2.840.10008.5.1.4.1.1.66", "1.2.840.10008.5.1.4.1.1.66.1", "1.2.840.10008.5.1.4.1.1.66.2", "1.2.840.10008.5.1.4.1.1.66.3", "1.2.840.10008.5.1.4.1.1.77.1.5.3", "1.2.840.10008.5.1.4.1.1.67", "1.2.840.10008.5.1.4.1.1.104.1", "1.2.840.10008.5.1.4.1.1.104.2", "1.2.840.10008.5.1.4.1.1.104.3", "1.2.840.113619.4.30", "1.2.840.113619.4.26", "1.3.12.2.1107.5.9.1", "1.3.12.2.1107.5.99.3.10", "1.3.12.2.1107.5.99.3.11", "1.2.840.10008.5.1.4.1.1.88.3", "1.2.276.0.48.5.1.4.1.1.7", "1.2.392.200036.9125.1.1.2", "1.2.840.10008.5.1.4.1.1.4.3", "1.2.840.10008.5.1.4.1.1.130", "1.2.840.10008.5.1.4.1.1.66.4", "1.2.840.10008.5.1.4.1.1.66.7", "1.2.840.10008.5.1.4.1.1.66.8", "1.2.840.10008.5.1.4.1.1.66.5", "1.2.840.10008.5.1.4.1.1.68.1", "1.2.840.10008.5.1.4.1.1.68.2", "1.2.840.10008.5.1.4.1.1.131", "1.2.840.10008.5.1.4.1.1.78.1", "1.2.840.10008.5.1.4.1.1.78.2", "1.2.840.10008.5.1.4.1.1.78.3", "1.2.840.10008.5.1.4.1.1.78.4", "1.2.840.10008.5.1.4.1.1.78.5", "1.2.840.10008.5.1.4.1.1.78.6", "1.2.840.10008.5.1.4.1.1.78.7", "1.2.840.10008.5.1.4.1.1.78.8", "1.2.840.10008.5.1.4.1.1.80.1", "1.2.840.10008.5.1.4.39.1"};
    private static Set setOfStorageSOPClasses = null;
    private static final Map<String, String[]> plausibleStandardSOPClassUIDsForModality = new HashMap<String, String[]>();

    public static final boolean isVerification(String string) {
        return string != null && string.equals(Verification);
    }

    public static final boolean isPrivateNonImageStorage(String string) {
        return string != null && (string.equals(PrivateGEPETRawDataStorage) || string.equals(PrivateGE3DModelStorage) || string.equals(PrivateGEeNTEGRAProtocolOrNMGenieStorage) || string.equals(PrivateGECollageStorage) || string.equals(PrivateGERTPlanStorage) || string.equals(PrivateSiemensCSANonImageStorage) || string.equals(PrivateSiemensCTMRVolumeStorage) || string.equals(PrivateSiemensAXFrameSetsStorage) || string.equals(PrivateAgfaBasicAttributePresentationStateStorage) || string.equals(PrivateMedicalInsight3DSoftcopyPresentationStateStorage) || string.equals("1.2.840.10008.5.1.4.1.1.88.3") || string.equals(PrivateTomTecAnnotationStorage) || string.equals(PrivatePhilipsVolumeStorage) || string.equals(PrivatePhilipsVolume2Storage) || string.equals(PrivatePhilips3DObjectStorage) || string.equals(PrivatePhilips3DObject2Storage) || string.equals(PrivatePhilipsSurfaceStorage) || string.equals(PrivatePhilipsSurface2Storage) || string.equals(PrivatePhilipsCompositeObjectStorage) || string.equals(PrivatePhilipsMRCardioProfileStorage) || string.equals(PrivatePhilipsMRCardioStorage) || string.equals(PrivatePhilipsMRCardio2Storage) || string.equals(PrivatePhilipsMRCardioAnalysisStorage) || string.equals(PrivatePhilipsMRCardioAnalysis2Storage) || string.equals(PrivatePhilipsMRSpectrumStorage) || string.equals(PrivatePhilipsMRSeriesDataStorage) || string.equals(PrivatePhilipsMRExamcardStorage) || string.equals(PrivatePhilips3DPresentationStateStorage) || string.equals(PrivatePhilipsPerfusionStorage) || string.equals(PrivatePhilipsHPLive3D01Storage) || string.equals(PrivatePhilipsHPLive3D02Storage) || string.equals(PrivateERADPracticeBuilderReportTextStorage) || string.equals(PrivateERADPracticeBuilderReportDictationStorage) || string.equals(PrivateDcm4cheEncapsulatedDocumentStorage));
    }

    public static final boolean isPrivateImageStorage(String string) {
        return string != null && (string.equals(PrivateFujiCRImageStorage) || string.equals(PrivateGEDicomMRImageInfoObject) || string.equals(PrivateGEDicomCTImageInfoObject) || string.equals(PrivateGEDicomDisplayImageInfoObject) || string.equals(PrivatePhilipsCXImageStorage) || string.equals(PrivatePhilipsCTSyntheticImageStorage) || string.equals(PrivatePhilipsMRSyntheticImageStorage) || string.equals(PrivatePhilipsCXSyntheticImageStorage) || string.equals(PrivatePhilipsSpecialisedXAStorage) || string.equals(PrivatePhilipsPerfusionImageStorage) || string.equals(PrivatePhilipsMRColorImageStorage) || string.equals(PrivatePhilipsVRMLStorage) || string.equals(PrivatePhilipsVolumeSetStorage) || string.equals(PrivatePhilipsLiveRunStorage) || string.equals(PrivatePhilipsRunStorage) || string.equals(PrivatePhilipsReconstructionStorage) || string.equals(PrivatePhilipsXRayMFStorage) || string.equals(PrivatePMODMultiframeImageStorage) || string.equals(PrivateToshibaUSImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedCTImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedMRImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedPETImageStorage) || string.equals(PrivatePixelMedFloatingPointImageStorage) || string.equals(PrivateDcm4cheUpgradedCTImageStorage) || string.equals(PrivateDcm4cheUpgradedMRImageStorage) || string.equals(PrivateDcm4cheUpgradedPETImageStorage));
    }

    public static final boolean isDICOSImageStorage(String string) {
        return string != null && (string.equals(DICOSCTImageStorage) || string.equals(DICOSDigitalXRayImageStorageForPresentation) || string.equals(DICOSDigitalXRayImageStorageForProcessing) || string.equals(DICOS2DAITStorage) || string.equals(DICOS3DAITStorage));
    }

    public static final boolean isDICOSNonImageStorage(String string) {
        return string != null && (string.equals(DICOSThreatDetectionReportStorage) || string.equals(DICOSQuadrupoleResonanceStorage));
    }

    public static final boolean isDICONDEImageStorage(String string) {
        return string != null && (string.equals(DICONDEEddyCurrentImageStorage) || string.equals(DICONDEEddyCurrentMultiframeImageStorage));
    }

    public static final boolean isTiledImageStorage(String string) {
        return string != null && string.equals(VLWholeSlideMicroscopyImageStorage);
    }

    public static final boolean isImageStorage(String string) {
        return SOPClass.isStandardImageStorage(string) || SOPClass.isPrivateImageStorage(string) || SOPClass.isDICOSImageStorage(string);
    }

    public static final boolean isStandardImageStorage(String string) {
        return string != null && (string.equals(ComputedRadiographyImageStorage) || string.equals(DigitalXRayImageStorageForPresentation) || string.equals(DigitalXRayImageStorageForProcessing) || string.equals(DigitalMammographyXRayImageStorageForPresentation) || string.equals(DigitalMammographyXRayImageStorageForProcessing) || string.equals(DigitalIntraoralXRayImageStorageForPresentation) || string.equals(DigitalIntraoralXRayImageStorageForProcessing) || string.equals(CTImageStorage) || string.equals(EnhancedCTImageStorage) || string.equals(LegacyConvertedEnhancedCTImageStorage) || string.equals(UltrasoundMultiframeImageStorageRetired) || string.equals(UltrasoundMultiframeImageStorage) || string.equals(MRImageStorage) || string.equals(EnhancedMRImageStorage) || string.equals(EnhancedMRColorImageStorage) || string.equals(LegacyConvertedEnhancedMRImageStorage) || string.equals(NuclearMedicineImageStorageRetired) || string.equals(UltrasoundImageStorageRetired) || string.equals(UltrasoundImageStorage) || string.equals(EnhancedUSVolumeStorage) || string.equals(PhotoacousticImageStorage) || string.equals(SecondaryCaptureImageStorage) || string.equals(MultiframeSingleBitSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleByteSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleWordSecondaryCaptureImageStorage) || string.equals(MultiframeTrueColorSecondaryCaptureImageStorage) || string.equals(XRayAngiographicImageStorage) || string.equals(EnhancedXAImageStorage) || string.equals(XRayRadioFlouroscopicImageStorage) || string.equals(EnhancedXRFImageStorage) || string.equals(XRayAngiographicBiplaneImageStorage) || string.equals(XRay3DAngiographicImageStorage) || string.equals(XRay3DCraniofacialImageStorage) || string.equals(BreastTomosynthesisImageStorage) || string.equals(BreastProjectionXRayImageStorageForPresentation) || string.equals(BreastProjectionXRayImageStorageForProcessing) || string.equals(NuclearMedicineImageStorage) || string.equals(VisibleLightDraftImageStorage) || string.equals(VisibleLightMultiFrameDraftImageStorage) || string.equals(VisibleLightEndoscopicImageStorage) || string.equals(VideoEndoscopicImageStorage) || string.equals(VisibleLightMicroscopicImageStorage) || string.equals(VideoMicroscopicImageStorage) || string.equals(VisibleLightSlideCoordinatesMicroscopicImageStorage) || string.equals(VisibleLightPhotographicImageStorage) || string.equals(VideoPhotographicImageStorage) || string.equals(OphthalmicPhotography8BitImageStorage) || string.equals(OphthalmicPhotography16BitImageStorage) || string.equals(OphthalmicTomographyImageStorage) || string.equals(WideFieldOphthalmicPhotographyStereographicProjectionImageStorage) || string.equals(WideFieldOphthalmicPhotography3DCoordinatesImageStorage) || string.equals(OphthalmicOpticalCoherenceTomographyEnFaceImageStorage) || string.equals(OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage) || string.equals(OphthalmicThicknessMapStorage) || string.equals(CornealTopographyMapStorage) || string.equals(VLWholeSlideMicroscopyImageStorage) || string.equals(DermoscopicPhotographyImageStorage) || string.equals(ConfocalMicroscopyImageStorage) || string.equals(ConfocalMicroscopyTiledPyramidalImageStorage) || string.equals(PETImageStorage) || string.equals(LegacyConvertedEnhancedPETImageStorage) || string.equals(EnhancedPETImageStorage) || string.equals(RTImageStorage) || string.equals(SegmentationStorage) || string.equals(LabelMapSegmentationStorage) || string.equals(HeightMapSegmentationStorage) || string.equals(IVOCTImageStorageForPresentation) || string.equals(IVOCTImageStorageForProcessing) || string.equals(ParametricMapStorage));
    }

    public static final boolean isEnhancedMultiframeImageStorage(String string) {
        return string != null && (string.equals(MultiframeSingleBitSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleByteSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleWordSecondaryCaptureImageStorage) || string.equals(MultiframeTrueColorSecondaryCaptureImageStorage) || string.equals(EnhancedCTImageStorage) || string.equals(LegacyConvertedEnhancedCTImageStorage) || string.equals(UltrasoundMultiframeImageStorageRetired) || string.equals(UltrasoundMultiframeImageStorage) || string.equals(EnhancedMRImageStorage) || string.equals(EnhancedMRColorImageStorage) || string.equals(LegacyConvertedEnhancedMRImageStorage) || string.equals(EnhancedUSVolumeStorage) || string.equals(PhotoacousticImageStorage) || string.equals(EnhancedPETImageStorage) || string.equals(LegacyConvertedEnhancedPETImageStorage) || string.equals(SegmentationStorage) || string.equals(LabelMapSegmentationStorage) || string.equals(HeightMapSegmentationStorage) || string.equals(IVOCTImageStorageForPresentation) || string.equals(IVOCTImageStorageForProcessing) || string.equals(EnhancedXAImageStorage) || string.equals(EnhancedXRFImageStorage) || string.equals(XRay3DAngiographicImageStorage) || string.equals(XRay3DCraniofacialImageStorage) || string.equals(BreastTomosynthesisImageStorage) || string.equals(BreastProjectionXRayImageStorageForPresentation) || string.equals(BreastProjectionXRayImageStorageForProcessing) || string.equals(PrivatePixelMedLegacyConvertedEnhancedCTImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedMRImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedPETImageStorage) || string.equals(PrivatePixelMedFloatingPointImageStorage) || string.equals(OphthalmicTomographyImageStorage) || string.equals(ParametricMapStorage) || string.equals(VLWholeSlideMicroscopyImageStorage) || string.equals(ConfocalMicroscopyImageStorage) || string.equals(ConfocalMicroscopyTiledPyramidalImageStorage));
    }

    public static final boolean isEnhancedMultiframeImageWithPlanePositionOrientationAndMeasuresStorage(String string) {
        return string != null && (string.equals(MultiframeGrayscaleByteSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleWordSecondaryCaptureImageStorage) || string.equals(MultiframeTrueColorSecondaryCaptureImageStorage) || string.equals(EnhancedCTImageStorage) || string.equals(LegacyConvertedEnhancedCTImageStorage) || string.equals(EnhancedMRImageStorage) || string.equals(EnhancedMRColorImageStorage) || string.equals(LegacyConvertedEnhancedMRImageStorage) || string.equals(EnhancedPETImageStorage) || string.equals(LegacyConvertedEnhancedPETImageStorage) || string.equals(SegmentationStorage) || string.equals(LabelMapSegmentationStorage) || string.equals(XRay3DAngiographicImageStorage) || string.equals(XRay3DCraniofacialImageStorage) || string.equals(BreastTomosynthesisImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedCTImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedMRImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedPETImageStorage) || string.equals(PrivatePixelMedFloatingPointImageStorage) || string.equals(OphthalmicTomographyImageStorage) || string.equals(ParametricMapStorage));
    }

    public static final boolean isImageWithFrameOfReferenceStorage(String string) {
        return string != null && (SOPClass.isEnhancedMultiframeImageWithPlanePositionOrientationAndMeasuresStorage(string) || string.equals(CTImageStorage) || string.equals(MRImageStorage) || string.equals(NuclearMedicineImageStorage) || string.equals(UltrasoundImageStorage) || string.equals(UltrasoundMultiframeImageStorage) || string.equals(RTImageStorage) || string.equals(RTDoseStorage) || string.equals(PETImageStorage) || string.equals(DigitalXRayImageStorageForPresentation) || string.equals(DigitalXRayImageStorageForProcessing) || string.equals(DigitalMammographyXRayImageStorageForPresentation) || string.equals(DigitalMammographyXRayImageStorageForProcessing) || string.equals(DigitalIntraoralXRayImageStorageForPresentation) || string.equals(DigitalIntraoralXRayImageStorageForProcessing) || string.equals(VisibleLightSlideCoordinatesMicroscopicImageStorage) || string.equals(VLWholeSlideMicroscopyImageStorage) || string.equals(DermoscopicPhotographyImageStorage) || string.equals(ConfocalMicroscopyImageStorage) || string.equals(ConfocalMicroscopyTiledPyramidalImageStorage) || string.equals(EnhancedXAImageStorage) || string.equals(EnhancedXRFImageStorage) || string.equals(EnhancedUSVolumeStorage) || string.equals(PhotoacousticImageStorage) || string.equals(IVOCTImageStorageForPresentation) || string.equals(IVOCTImageStorageForProcessing) || string.equals(CornealTopographyMapStorage) || string.equals(BreastProjectionXRayImageStorageForPresentation) || string.equals(BreastProjectionXRayImageStorageForProcessing) || string.equals(WideFieldOphthalmicPhotographyStereographicProjectionImageStorage) || string.equals(WideFieldOphthalmicPhotography3DCoordinatesImageStorage) || string.equals(OphthalmicOpticalCoherenceTomographyEnFaceImageStorage) || string.equals(OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage));
    }

    public static final boolean isImageWithSynchronizationStorage(String string) {
        return string != null && (string.equals(NuclearMedicineImageStorage) || string.equals(UltrasoundImageStorage) || string.equals(UltrasoundMultiframeImageStorage) || string.equals(MultiframeGrayscaleByteSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleWordSecondaryCaptureImageStorage) || string.equals(MultiframeTrueColorSecondaryCaptureImageStorage) || string.equals(XRayAngiographicImageStorage) || string.equals(XRayRadioFlouroscopicImageStorage) || string.equals(PETImageStorage) || string.equals(EnhancedMRImageStorage) || string.equals(EnhancedMRColorImageStorage) || string.equals(EnhancedCTImageStorage) || string.equals(OphthalmicPhotography8BitImageStorage) || string.equals(OphthalmicPhotography16BitImageStorage) || string.equals(EnhancedXAImageStorage) || string.equals(EnhancedXRFImageStorage) || string.equals(OphthalmicTomographyImageStorage) || string.equals(BreastTomosynthesisImageStorage) || string.equals(EnhancedPETImageStorage) || string.equals(EnhancedUSVolumeStorage) || string.equals(PhotoacousticImageStorage) || string.equals(IVOCTImageStorageForPresentation) || string.equals(IVOCTImageStorageForProcessing) || string.equals(LegacyConvertedEnhancedCTImageStorage) || string.equals(LegacyConvertedEnhancedMRImageStorage) || string.equals(LegacyConvertedEnhancedPETImageStorage) || string.equals(BreastProjectionXRayImageStorageForPresentation) || string.equals(BreastProjectionXRayImageStorageForProcessing) || string.equals(WideFieldOphthalmicPhotography3DCoordinatesImageStorage) || string.equals(WideFieldOphthalmicPhotographyStereographicProjectionImageStorage) || string.equals(ConfocalMicroscopyImageStorage) || string.equals(ConfocalMicroscopyTiledPyramidalImageStorage));
    }

    public static final boolean isLegacyConvertedEnhancedImageStorage(String string) {
        return string != null && (string.equals(LegacyConvertedEnhancedCTImageStorage) || string.equals(LegacyConvertedEnhancedMRImageStorage) || string.equals(LegacyConvertedEnhancedPETImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedCTImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedMRImageStorage) || string.equals(PrivatePixelMedLegacyConvertedEnhancedPETImageStorage));
    }

    public static final boolean isMultiframeSecondaryCaptureImageStorage(String string) {
        return string != null && (string.equals(MultiframeSingleBitSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleByteSecondaryCaptureImageStorage) || string.equals(MultiframeGrayscaleWordSecondaryCaptureImageStorage) || string.equals(MultiframeTrueColorSecondaryCaptureImageStorage));
    }

    public static final boolean isSecondaryCaptureImageStorage(String string) {
        return string != null && (string.equals(SecondaryCaptureImageStorage) || SOPClass.isMultiframeSecondaryCaptureImageStorage(string));
    }

    public static final boolean isMultiframeImageStorage(String string) {
        return string != null && (string.equals(NuclearMedicineImageStorage) || string.equals(OphthalmicPhotography8BitImageStorage) || string.equals(OphthalmicPhotography16BitImageStorage) || string.equals(UltrasoundMultiframeImageStorageRetired) || string.equals(UltrasoundMultiframeImageStorage) || string.equals(XRayAngiographicImageStorage) || string.equals(XRayRadioFlouroscopicImageStorage) || string.equals(XRayAngiographicBiplaneImageStorage) || SOPClass.isEnhancedMultiframeImageStorage(string) || SOPClass.isMultiframeSecondaryCaptureImageStorage(string));
    }

    public static final boolean isDirectory(String string) {
        return string != null && string.equals(MediaStorageDirectoryStorage);
    }

    public static final boolean isStructuredReport(String string) {
        return string != null && (string.equals(BasicTextSRStorage) || string.equals(EnhancedSRStorage) || string.equals(ComprehensiveSRStorage) || string.equals(Comprehensive3DSRStorage) || string.equals(ExtensibleSRStorage) || string.equals(MammographyCADSRStorage) || string.equals(ChestCADSRStorage) || string.equals(ProcedureLogStorage) || string.equals(XRayRadiationDoseSRStorage) || string.equals(RadiopharmaceuticalRadiationDoseSRStorage) || string.equals(ColonCADSRStorage) || string.equals(ImplantationPlanSRStorage) || string.equals(AcquisitionContextSRStorage) || string.equals(SimplifiedAdultEchoSRStorage) || string.equals(PatientRadiationDoseSRStorage) || string.equals(MacularGridThicknessAndVolumeReportStorage) || string.equals(KeyObjectSelectionDocumentStorage) || string.equals(SpectaclePrescriptionReportStorage));
    }

    public static final boolean isTrialRetiredStructuredReport(String string) {
        return string != null && (string.equals(TextSRStorageTrialRetired) || string.equals(AudioSRStorageTrialRetired) || string.equals("1.2.840.10008.5.1.4.1.1.88.3") || string.equals(ComprehensiveSRStorageTrialRetired));
    }

    public static final boolean isKeyObjectSelectionDocument(String string) {
        return string != null && string.equals(KeyObjectSelectionDocumentStorage);
    }

    public static final boolean isPresentationState(String string) {
        return string != null && (string.equals(GrayscaleSoftcopyPresentationStateStorage) || string.equals(ColorSoftcopyPresentationStateStorage) || string.equals(PseudoColorSoftcopyPresentationStateStorage) || string.equals(BlendingSoftcopyPresentationStateStorage) || string.equals(XAXRFGrayscaleSoftcopyPresentationStateStorage) || string.equals(GrayscalePlanarMPRVolumetricPresentationStateStorage) || string.equals(CompositingPlanarMPRVolumetricPresentationStateStorage) || string.equals(AdvancedBlendingPresentationStateStorage) || string.equals(VolumeRenderingVolumetricPresentationStateStorage) || string.equals(SegmentedVolumeRenderingVolumetricPresentationStateStorage) || string.equals(MultipleVolumeRenderingVolumetricPresentationStateStorage) || string.equals(VariableModalityLUTSoftcopyPresentationStateStorage));
    }

    public static final boolean isWaveformPresentationState(String string) {
        return string != null && (string.equals(WaveformPresentationStateStorage) || string.equals(WaveformAcquisitionPresentationStateStorage));
    }

    public static final boolean isWaveform(String string) {
        return string != null && (string.equals(TwelveLeadECGStorage) || string.equals(GeneralECGStorage) || string.equals(HemodynamicWaveformStorage) || string.equals(AmbulatoryECGStorage) || string.equals(CardiacElectrophysiologyWaveformStorage) || string.equals(BasicVoiceStorage) || string.equals(GeneralAudioWaveformStorage) || string.equals(ArterialPulseWaveformStorage) || string.equals(RespiratoryWaveformStorage) || string.equals(MultichannelRespiratoryWaveformStorage) || string.equals(RoutineScalpElectroencephalogramWaveformStorage) || string.equals(ElectromyogramWaveformStorage) || string.equals(ElectrooculogramWaveformStorage) || string.equals(SleepElectroencephalogramWaveformStorage) || string.equals(BodyPositionWaveformStorage));
    }

    public static final boolean isStandalone(String string) {
        return string != null && (string.equals(StandaloneOverlayStorage) || string.equals(StandaloneCurveStorage) || string.equals(StandaloneModalityLUTStorage) || string.equals(StandaloneVOILUTStorage) || string.equals(StandalonePETCurveStorage));
    }

    public static final boolean isRadiotherapy(String string) {
        return string != null && (string.equals(RTDoseStorage) || string.equals(RTStructureSetStorage) || string.equals(RTBeamsTreatmentRecordStorage) || string.equals(RTPlanStorage) || string.equals(RTBrachyTreatmentRecordStorage) || string.equals(RTTreatmentSummaryRecordStorage) || string.equals(RTIonPlanStorage) || string.equals(RTIonBeamsTreatmentRecordStorage) || string.equals(RTPhysicianIntentStorage) || string.equals(RTSegmentAnnotationStorage) || string.equals(RTRadiationSetStorage) || string.equals(CArmPhotonElectronRadiationStorage) || string.equals(TomotherapeuticRadiationStorage) || string.equals(RoboticArmRadiationStorage) || string.equals(RTRadiationRecordSetStorage) || string.equals(RTRadiationSalvageRecordStorage) || string.equals(TomotherapeuticRadiationRecordStorage) || string.equals(CArmPhotonElectronRadiationRecordStorage) || string.equals(RoboticRadiationRecordStorage) || string.equals(RTBeamsDeliveryInstructionStorageTrial) || string.equals(RTBeamsDeliveryInstructionStorage));
    }

    public static final boolean isSpectroscopy(String string) {
        return string != null && string.equals(MRSpectroscopyStorage);
    }

    public static final boolean isRawData(String string) {
        return string != null && string.equals(RawDataStorage);
    }

    public static final boolean isEncapsulatedDocument(String string) {
        return string != null && (string.equals(EncapsulatedPDFStorage) || string.equals(EncapsulatedCDAStorage) || string.equals(EncapsulatedSTLStorage) || string.equals(PrivateDcm4cheEncapsulatedDocumentStorage));
    }

    public static final boolean isOphthalmicMeasurementStorage(String string) {
        return string != null && (string.equals(LensometryMeasurementsStorage) || string.equals(AutorefractionMeasurementsStorage) || string.equals(KeratometryMeasurementsStorage) || string.equals(SubjectiveRefractionMeasurementsStorage) || string.equals(VisualAcuityMeasurementsStorage) || string.equals(OphthalmicAxialMeasurementsStorage) || string.equals(IntraocularLensCalculationsStorage));
    }

    public static final boolean isMiscellaneousCompositeNonImageStorage(String string) {
        return string != null && (string.equals(SpatialRegistrationStorage) || string.equals(SpatialFiducialsStorage) || string.equals(DeformableSpatialRegistrationStorage) || string.equals(StereometricRelationshipStorage) || string.equals(RealWorldValueMappingStorage) || string.equals(SurfaceSegmentationStorage) || string.equals(TractographyResultsStorage) || string.equals(SurfaceScanMeshStorage) || string.equals(SurfaceScanPointCloudStorage) || string.equals(BasicStructuredDisplayStorage) || string.equals(OphthalmicVisualFieldStaticPerimetryMeasurementsStorage));
    }

    public static final boolean isMiscellaneousNonCompositeStorage(String string) {
        return string != null && (string.equals(ColorPaletteStorage) || string.equals(GenericImplantTemplateStorage) || string.equals(ImplantAssemblyTemplateStorage) || string.equals(ImplantTemplateGroupStorage));
    }

    public static final boolean isNonImageStorage(String string) {
        return SOPClass.isDirectory(string) || SOPClass.isStructuredReport(string) || SOPClass.isTrialRetiredStructuredReport(string) || SOPClass.isPresentationState(string) || SOPClass.isWaveform(string) || SOPClass.isStandalone(string) || SOPClass.isRadiotherapy(string) || SOPClass.isSpectroscopy(string) || SOPClass.isRawData(string) || SOPClass.isEncapsulatedDocument(string) || SOPClass.isOphthalmicMeasurementStorage(string) || SOPClass.isMiscellaneousCompositeNonImageStorage(string) || SOPClass.isMiscellaneousNonCompositeStorage(string) || SOPClass.isPrivateNonImageStorage(string) || SOPClass.isDICOSNonImageStorage(string);
    }

    public static final boolean isStorage(String string) {
        return SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string);
    }

    public static final boolean isCompositeInstanceQuery(String string) {
        return string != null && (string.equals(StudyRootQueryRetrieveInformationModelFind) || string.equals(PatientRootQueryRetrieveInformationModelFind) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelFind));
    }

    public static final boolean isStudyRootCompositeInstanceQuery(String string) {
        return string != null && string.equals(StudyRootQueryRetrieveInformationModelFind);
    }

    public static final boolean isPatientRootCompositeInstanceQuery(String string) {
        return string != null && string.equals(PatientRootQueryRetrieveInformationModelFind);
    }

    public static final boolean isPatientStudyOnlyCompositeInstanceQuery(String string) {
        return string != null && string.equals(PatientStudyOnlyQueryRetrieveInformationModelFind);
    }

    public static final boolean isCompositeInstanceRetrieveWithMove(String string) {
        return string != null && (string.equals(StudyRootQueryRetrieveInformationModelMove) || string.equals(PatientRootQueryRetrieveInformationModelMove) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelMove));
    }

    public static final boolean isStudyRootCompositeInstanceRetrieveWithMove(String string) {
        return string != null && string.equals(StudyRootQueryRetrieveInformationModelMove);
    }

    public static final boolean isPatientRootCompositeInstanceRetrieveWithMove(String string) {
        return string != null && string.equals(PatientRootQueryRetrieveInformationModelMove);
    }

    public static final boolean isPatientStudyOnlyCompositeInstanceRetrieveWithMove(String string) {
        return string != null && string.equals(PatientStudyOnlyQueryRetrieveInformationModelMove);
    }

    public static final boolean isCompositeInstanceRetrieveWithGet(String string) {
        return string != null && (string.equals(StudyRootQueryRetrieveInformationModelGet) || string.equals(PatientRootQueryRetrieveInformationModelGet) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelGet));
    }

    public static final boolean isStudyRootCompositeInstanceRetrieveWithGet(String string) {
        return string != null && string.equals(StudyRootQueryRetrieveInformationModelGet);
    }

    public static final boolean isPatientRootCompositeInstanceRetrieveWithGet(String string) {
        return string != null && string.equals(PatientRootQueryRetrieveInformationModelGet);
    }

    public static final boolean isPatientStudyOnlyCompositeInstanceRetrieveWithGet(String string) {
        return string != null && string.equals(PatientStudyOnlyQueryRetrieveInformationModelGet);
    }

    public static final boolean isCompositeInstanceRetrieve(String string) {
        return string != null && (string.equals(StudyRootQueryRetrieveInformationModelMove) || string.equals(PatientRootQueryRetrieveInformationModelMove) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelMove) || string.equals(StudyRootQueryRetrieveInformationModelGet) || string.equals(PatientRootQueryRetrieveInformationModelGet) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelGet));
    }

    public static final boolean isStudyRootCompositeInstanceRetrieve(String string) {
        return string != null && (string.equals(StudyRootQueryRetrieveInformationModelMove) || string.equals(StudyRootQueryRetrieveInformationModelGet));
    }

    public static final boolean isPatientRootCompositeInstanceRetrieve(String string) {
        return string != null && (string.equals(PatientRootQueryRetrieveInformationModelMove) || string.equals(PatientRootQueryRetrieveInformationModelGet));
    }

    public static final boolean isPatientStudyOnlyCompositeInstanceRetrieve(String string) {
        return string != null && (string.equals(PatientStudyOnlyQueryRetrieveInformationModelMove) || string.equals(PatientStudyOnlyQueryRetrieveInformationModelGet));
    }

    private static final Set initializeUnmodifiableSetIfNecessary(Set set, String[] stringArray) {
        if (set == null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            set = Collections.unmodifiableSet(hashSet);
        }
        return set;
    }

    public static final Set getSetOfStorageSOPClasses() {
        setOfStorageSOPClasses = SOPClass.initializeUnmodifiableSetIfNecessary(setOfStorageSOPClasses, arrayOfStorageSOPClasses);
        return setOfStorageSOPClasses;
    }

    public static String[] getPlausibleStandardSOPClassUIDsForModality(String string) {
        String[] stringArray = null;
        if (string != null) {
            stringArray = plausibleStandardSOPClassUIDsForModality.get(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedCDAStorage, EncapsulatedPDFStorage};
        }
        return stringArray;
    }

    public static String selectModalityForSOPClass(String string) {
        String string2 = "OT";
        if (!(string == null || string.length() <= 0 || SOPClass.isSecondaryCaptureImageStorage(string) || SOPClass.isRawData(string) || SOPClass.isEncapsulatedDocument(string))) {
            for (String string3 : plausibleStandardSOPClassUIDsForModality.keySet()) {
                String[] stringArray;
                for (String string4 : stringArray = plausibleStandardSOPClassUIDsForModality.get(string3)) {
                    if (!string.equals(string4)) continue;
                    return string3;
                }
            }
        }
        return string2;
    }

    static {
        plausibleStandardSOPClassUIDsForModality.put("CT", new String[]{CTImageStorage, EnhancedCTImageStorage, LegacyConvertedEnhancedCTImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("MR", new String[]{MRImageStorage, EnhancedMRImageStorage, EnhancedMRColorImageStorage, MRSpectroscopyStorage, LegacyConvertedEnhancedMRImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("US", new String[]{UltrasoundImageStorage, UltrasoundMultiframeImageStorage, UltrasoundImageStorageRetired, UltrasoundMultiframeImageStorageRetired, EnhancedUSVolumeStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("IVUS", new String[]{UltrasoundImageStorage, UltrasoundMultiframeImageStorage, UltrasoundImageStorageRetired, UltrasoundMultiframeImageStorageRetired, EnhancedUSVolumeStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("NM", new String[]{NuclearMedicineImageStorage, NuclearMedicineImageStorageRetired, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("PT", new String[]{PETImageStorage, EnhancedPETImageStorage, LegacyConvertedEnhancedPETImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("XA", new String[]{XRayAngiographicImageStorage, EnhancedXAImageStorage, XRay3DAngiographicImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("XRF", new String[]{XRayRadioFlouroscopicImageStorage, EnhancedXRFImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("XA", new String[]{XRayAngiographicImageStorage, XRayAngiographicBiplaneImageStorage, EnhancedXAImageStorage, XRay3DAngiographicImageStorage, SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, RawDataStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("CR", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, ComputedRadiographyImageStorage, DigitalXRayImageStorageForProcessing, DigitalXRayImageStorageForPresentation, DigitalIntraoralXRayImageStorageForProcessing, DigitalIntraoralXRayImageStorageForPresentation, DigitalMammographyXRayImageStorageForProcessing, DigitalMammographyXRayImageStorageForPresentation, XRay3DCraniofacialImageStorage});
        plausibleStandardSOPClassUIDsForModality.put("DX", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, ComputedRadiographyImageStorage, DigitalXRayImageStorageForProcessing, DigitalXRayImageStorageForPresentation, DigitalIntraoralXRayImageStorageForProcessing, DigitalIntraoralXRayImageStorageForPresentation, DigitalMammographyXRayImageStorageForProcessing, DigitalMammographyXRayImageStorageForPresentation, XRay3DCraniofacialImageStorage});
        plausibleStandardSOPClassUIDsForModality.put("IO", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, ComputedRadiographyImageStorage, DigitalXRayImageStorageForProcessing, DigitalXRayImageStorageForPresentation, DigitalIntraoralXRayImageStorageForProcessing, DigitalIntraoralXRayImageStorageForPresentation});
        plausibleStandardSOPClassUIDsForModality.put("MG", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, ComputedRadiographyImageStorage, DigitalXRayImageStorageForProcessing, DigitalXRayImageStorageForPresentation, DigitalMammographyXRayImageStorageForProcessing, DigitalMammographyXRayImageStorageForPresentation, BreastTomosynthesisImageStorage, BreastProjectionXRayImageStorageForPresentation, BreastProjectionXRayImageStorageForProcessing});
        plausibleStandardSOPClassUIDsForModality.put("GM", new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, VisibleLightMicroscopicImageStorage, VideoMicroscopicImageStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("SM", new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, VisibleLightSlideCoordinatesMicroscopicImageStorage, VLWholeSlideMicroscopyImageStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("XC", new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, VisibleLightPhotographicImageStorage, VideoPhotographicImageStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("OP", new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, VisibleLightPhotographicImageStorage, OphthalmicPhotography8BitImageStorage, OphthalmicPhotography16BitImageStorage, WideFieldOphthalmicPhotographyStereographicProjectionImageStorage, WideFieldOphthalmicPhotography3DCoordinatesImageStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("OPT", new String[]{SecondaryCaptureImageStorage, MultiframeSingleBitSecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, OphthalmicTomographyImageStorage, OphthalmicOpticalCoherenceTomographyEnFaceImageStorage, OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("OPM", new String[]{OphthalmicThicknessMapStorage});
        plausibleStandardSOPClassUIDsForModality.put("CM", new String[]{CornealTopographyMapStorage});
        plausibleStandardSOPClassUIDsForModality.put("IVOCT", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, IVOCTImageStorageForPresentation, IVOCTImageStorageForProcessing, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("PA", new String[]{SecondaryCaptureImageStorage, MultiframeGrayscaleByteSecondaryCaptureImageStorage, MultiframeGrayscaleWordSecondaryCaptureImageStorage, MultiframeTrueColorSecondaryCaptureImageStorage, PhotoacousticImageStorage});
        plausibleStandardSOPClassUIDsForModality.put("RTIMAGE", new String[]{RTImageStorage});
        plausibleStandardSOPClassUIDsForModality.put("RTDOSE", new String[]{RTDoseStorage});
        plausibleStandardSOPClassUIDsForModality.put("RTSTRUCT", new String[]{RTStructureSetStorage});
        plausibleStandardSOPClassUIDsForModality.put("RTPLAN", new String[]{RTPlanStorage, RTIonPlanStorage});
        plausibleStandardSOPClassUIDsForModality.put("RTRECORD", new String[]{RTTreatmentSummaryRecordStorage, RTIonBeamsTreatmentRecordStorage});
        plausibleStandardSOPClassUIDsForModality.put("SR", new String[]{BasicTextSRStorage, EnhancedSRStorage, ComprehensiveSRStorage, Comprehensive3DSRStorage, ExtensibleSRStorage, MammographyCADSRStorage, ChestCADSRStorage, ProcedureLogStorage, XRayRadiationDoseSRStorage, RadiopharmaceuticalRadiationDoseSRStorage, ColonCADSRStorage, ImplantationPlanSRStorage, AcquisitionContextSRStorage, SimplifiedAdultEchoSRStorage, PatientRadiationDoseSRStorage, MacularGridThicknessAndVolumeReportStorage, KeyObjectSelectionDocumentStorage, SpectaclePrescriptionReportStorage});
        plausibleStandardSOPClassUIDsForModality.put("PR", new String[]{GrayscaleSoftcopyPresentationStateStorage, ColorSoftcopyPresentationStateStorage, PseudoColorSoftcopyPresentationStateStorage, BlendingSoftcopyPresentationStateStorage, XAXRFGrayscaleSoftcopyPresentationStateStorage, GrayscalePlanarMPRVolumetricPresentationStateStorage, CompositingPlanarMPRVolumetricPresentationStateStorage, AdvancedBlendingPresentationStateStorage, VolumeRenderingVolumetricPresentationStateStorage, SegmentedVolumeRenderingVolumetricPresentationStateStorage, MultipleVolumeRenderingVolumetricPresentationStateStorage, VariableModalityLUTSoftcopyPresentationStateStorage, WaveformPresentationStateStorage, WaveformAcquisitionPresentationStateStorage});
        plausibleStandardSOPClassUIDsForModality.put("REG", new String[]{SpatialRegistrationStorage, DeformableSpatialRegistrationStorage});
        plausibleStandardSOPClassUIDsForModality.put("FID", new String[]{SpatialFiducialsStorage});
        plausibleStandardSOPClassUIDsForModality.put("SMR", new String[]{StereometricRelationshipStorage});
        plausibleStandardSOPClassUIDsForModality.put("RWV", new String[]{RealWorldValueMappingStorage});
        plausibleStandardSOPClassUIDsForModality.put("SEG", new String[]{SegmentationStorage, LabelMapSegmentationStorage, HeightMapSegmentationStorage, SurfaceSegmentationStorage});
        plausibleStandardSOPClassUIDsForModality.put("OSS", new String[]{SurfaceScanMeshStorage, SurfaceScanPointCloudStorage});
        plausibleStandardSOPClassUIDsForModality.put("LEN", new String[]{LensometryMeasurementsStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("AR", new String[]{AutorefractionMeasurementsStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("KER", new String[]{KeratometryMeasurementsStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("SRF", new String[]{SubjectiveRefractionMeasurementsStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("VA", new String[]{VisualAcuityMeasurementsStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("AU", new String[]{BasicVoiceStorage, GeneralAudioWaveformStorage});
        plausibleStandardSOPClassUIDsForModality.put("ECG", new String[]{TwelveLeadECGStorage, GeneralECGStorage, AmbulatoryECGStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("HD", new String[]{HemodynamicWaveformStorage, ArterialPulseWaveformStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("EPS", new String[]{CardiacElectrophysiologyWaveformStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("RESP", new String[]{RespiratoryWaveformStorage, EncapsulatedPDFStorage});
        plausibleStandardSOPClassUIDsForModality.put("M3D", new String[]{EncapsulatedSTLStorage});
    }
}

