/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.util.HashMap;

public class SOPClassDescriptions {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SOPClassDescriptions.java,v 1.71 2025/02/12 18:15:47 dclunie Exp $";
    private static SOPClassDescriptions ourself = new SOPClassDescriptions();
    private HashMap abbreviationsByUID;
    private HashMap descriptionsByUID;
    private HashMap keywordsByUID;
    private HashMap uidsByKeyword;

    private SOPClassDescriptions() {
        this.createAbbreviationsByUID();
        this.createDescriptionsByUID();
        this.createKeywordsByUID();
        this.createUIDsByKeyword();
    }

    public static String getAbbreviationFromUID(String string) {
        String string2 = (String)SOPClassDescriptions.ourself.abbreviationsByUID.get(string);
        return string2 == null ? "" : string2;
    }

    public static String getDescriptionFromUID(String string) {
        String string2 = (String)SOPClassDescriptions.ourself.descriptionsByUID.get(string);
        return string2 == null ? "" : string2;
    }

    public static String getKeywordFromUID(String string) {
        String string2 = (String)SOPClassDescriptions.ourself.keywordsByUID.get(string);
        return string2 == null ? "" : string2;
    }

    public static String getUIDFromKeyword(String string) {
        String string2 = (String)SOPClassDescriptions.ourself.uidsByKeyword.get(string);
        return string2 == null ? "" : string2;
    }

    private void createAbbreviationsByUID() {
        this.abbreviationsByUID = new HashMap();
        this.abbreviationsByUID.put("1.2.840.10008.1.1", "VFY");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1", "CR");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.1", "DX(Pres)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.1.1", "DX(Proc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.2", "MG(Pres)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.2.1", "MG(Proc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.3", "IO(Pres)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.1.3.1", "IO(Proc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.2", "CT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.2.1", "CT(MF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.2.2", "CT(MF-L)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.3", "US(MF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.3.1", "US");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.4", "MR");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.4.1", "MR(MF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.4.3", "MR(MFColor)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.4.4", "MR(MF-L)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.5", "NM(Ret)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.6", "US(Ret)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.6.1", "US");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.6.2", "US(Vol)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.6.3", "PA");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.7", "SC");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.7.1", "SC(MF1Bit)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.7.2", "SC(MFGrayByte)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.7.3", "SC(MFGrayWord)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.7.4", "SC(MFColor)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.12.1", "XA");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.12.1.1", "XA(Enh)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.12.2", "XRF");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.12.2.1", "XRF(Enh)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.12.3", "XA(Bi)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.1", "XA(3D)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.2", "DX(3D CF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.3", "MG(Tomo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.4", "MG(Proj Pres)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.5", "MG(Proj Proc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.20", "NM");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1", "VL(Endo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1.1", "VLMF(Endo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2", "VL(Micro)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2.1", "VLMF(Micro)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.3", "VL(Slide)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4", "VL(Photo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4.1", "VLMF(Photo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.1", "OP");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.2", "OP");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.4", "OPT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.7", "OPT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.8", "OPT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.5", "OP");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.6", "OP");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.6", "VL(WS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.7", "DMS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.8", "CFM)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.9", "CFM)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.128", "PET");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.130", "PET(MF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.128.1", "PET(MF-L)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.14.1", "IVOCT(Pres)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.14.2", "IVOCT(Proc)");
        this.abbreviationsByUID.put("1.2.840.10008.1.3.10", "DICOMDIR");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.11", "SR(Text)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.22", "SR(Enh)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.33", "SR(Comp)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.34", "SR(Comp3D)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.35", "SR(Ext)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.50", "CAD(Mammo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.65", "CAD(Chest)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.40", "LOG(Procedure)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.67", "DOSE(XRay)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.68", "DOSE(Nuc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.69", "CAD(Colon)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.70", "Plan(Implant)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.71", "SR(AcqCtx)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.72", "SR(Echo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.73", "DOSE(Pt)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.79.1", "SR(Macula)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.59", "KO");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.1", "SR(Text)(Trial)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.2", "SR(Audio)(Trial)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.3", "SR(Detail)(Trial)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.4", "SR(Comp)(Trial)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.1", "PS(Gray)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.2", "PS(Color)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.3", "PS(Pseudo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.4", "PS(Blend)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.5", "PS(XAXRF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.6", "PS(MPRGray)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.7", "PS(MPRComp)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.8", "PS(Adv.Blend)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.9", "PS(Vol)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.10", "PS(Vol.Seg)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.11", "PS(Vol.Multi)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11.12", "PS(VarMLUT)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.1", "PS(WF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.2", "PS(WFAcq)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.1", "ECG(12)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.2", "ECG(Gen)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.3", "ECG(Amb)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.2.1", "HD");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.3.1", "EPS");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.1", "AU(Voice)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.2", "AU");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.5.1", "ART");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.1", "RESP");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.2", "RESP(M)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.1", "EEG(Scalp)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.2", "EMG");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.3", "EOG");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.4", "EEG(Sleep)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9.8.1", "POS");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.8", "OVERLAY");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.9", "CURVE");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.10", "MODLUT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.11", "VOILUT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.129", "PETCURVE");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.2", "RTDOSE");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.3", "RTSTRUCT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.4", "RTRECORD(Beams)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.9", "RTRECORD(IonBeams)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.5", "RTPLAN");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.8", "RTPLAN(Ion)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.6", "RTRECORD(Brachy)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.7", "RTRECORD(Summary)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.10", "RT(Intent)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.11", "RT(SegAnn)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.12", "RT(RadSet)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.13", "RT(CArmPE)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.14", "RT(Tomo)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.15", "RT(Rob)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.16", "RT(Rec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.17", "RT(SalvRec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.18", "RT(TomoRec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.19", "RT(CArmPERec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.481.20", "RT(RobRec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.34.1", "RT BEAMS DELIVERY");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.34.4", "RT BEAMS DELIVERY");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.4.2", "MR(Spectro)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66", "RAW");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.1", "REG");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.2", "FID");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.3", "REG");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.3", "STR");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.67", "RWV");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.104.1", "ENCAP(PDF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.104.2", "ENCAP(CDA)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.104.3", "ENCAP(STL)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.2.2.1", "FIND(Study)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.2.2.2", "MOVE(Study)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.4", "SEG(Img)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.5", "SEG(Surf)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.6", "TRACT");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.7", "SEG(LabMap)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.66.8", "SEG(Height)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.1", "LEN");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.2", "AR");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.3", "KER");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.4", "SRF");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.5", "VA");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.6", "SR(Spec)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.7", "IOL(AxMx)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.78.8", "IOL(Calc)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.80.1", "OPV");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.81.1", "OPM");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.82.1", "CM");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.39.1", "PAL");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.43.1", "Implant");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.44.1", "Implant(ASSY)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.45.1", "Implant(GROUP)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.131", "DISP");
        this.abbreviationsByUID.put("1.2.840.113619.4.2", "MR(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.3", "MR(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.4", "SC(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.30", "RAWPET(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.26", "3D(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.27", "NM(GE)");
        this.abbreviationsByUID.put("1.2.528.1.1001.5.1.1.1", "COLLAGE(GE)");
        this.abbreviationsByUID.put("1.2.840.113619.4.5.249", "RTPLAN(GE)");
        this.abbreviationsByUID.put("1.3.12.2.1107.5.9.1", "CSA(Siemens)");
        this.abbreviationsByUID.put("1.3.12.2.1107.5.99.3.10", "Vol(Siemens)");
        this.abbreviationsByUID.put("1.3.12.2.1107.5.99.3.11", "Frames(Siemens)");
        this.abbreviationsByUID.put("1.2.124.113532.3500.7", "CHANGE(Agfa)");
        this.abbreviationsByUID.put("1.3.6.1.4.1.16978.3.1", "PS(3D MI)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.88.3", "SR(Acuson)");
        this.abbreviationsByUID.put("1.2.276.0.48.5.1.4.1.1.7", "Ann(TomTec)");
        this.abbreviationsByUID.put("1.2.392.200036.9125.1.1.2", "CR(Fuji)");
        this.abbreviationsByUID.put("1.3.46.670589.2.4.1.1", "CX(Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.1", "OT(Vol Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.1.1", "OT(Vol Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.2", "3D(Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.2.1", "3D(Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.3", "SEG(Surf Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.3.1", "SEG(Surf Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.4", "COMP(Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.7", "MR(Cardio Profile Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.8", "MR(Cardio Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.8.1", "MR(Cardio Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.9", "CT(Synthetic Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.10", "MR(Synthetic Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.11", "MR(Cardio Anal Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.11.1", "MR(Cardio Anal Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.12", "CX(Synthetic Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.11.0.0.12.1", "MR(Spectro Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.11.0.0.12.2", "MR(Series Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.11.0.0.12.3", "MR(Color Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.11.0.0.12.4", "MR(Exam Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.2.3.1.1", "XA(Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.2.5.1.1", "PS(3D Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.13", "OT(Perfusion Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.5.0.14", "OT(Perfusion Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.2.8.1.1 ", "XR(VRML Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.2.11.1.1", "XR(Volume Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.7.8.1618510092", "XR(Live Run Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.7.8.16185100129", "XR(Run Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.7.8.16185100130", "XR(Recon Philips)");
        this.abbreviationsByUID.put("1.3.46.670589.7.8.1618510091", "XR(MF Philips)");
        this.abbreviationsByUID.put("1.2.840.113543.6.6.1.3.10001", "US3D(HP)");
        this.abbreviationsByUID.put("1.2.840.113543.6.6.1.3.10002", "US3D(HP)");
        this.abbreviationsByUID.put("2.16.840.1.114033.5.1.4.1.1.130", "(MF PMOD)");
        this.abbreviationsByUID.put("1.2.392.200036.9116.7.8.1.1.1", "US(Toshiba)");
        this.abbreviationsByUID.put("1.2.826.0.1.3680043.293.1.0.1", "RPT(TXT)");
        this.abbreviationsByUID.put("1.2.826.0.1.3680043.293.1.0.2", "RPT(DICT)");
        this.abbreviationsByUID.put("1.2.40.0.13.1.5.1.4.1.1.2.1", "CT(Dcm4che)");
        this.abbreviationsByUID.put("1.2.40.0.13.1.5.1.4.1.1.4.1", "MR(Dcm4che)");
        this.abbreviationsByUID.put("1.2.40.0.13.1.5.1.4.1.1.128.1", "PET(Dcm4che)");
        this.abbreviationsByUID.put("1.2.40.0.13.1.5.1.4.1.1.104.1", "ENCAP(Dcm4che)");
        this.abbreviationsByUID.put("1.3.6.1.4.1.5962.301.1", "CT(MF-L)");
        this.abbreviationsByUID.put("1.3.6.1.4.1.5962.301.2", "MR(MF-L)");
        this.abbreviationsByUID.put("1.3.6.1.4.1.5962.301.3", "PET(MF-L)");
        this.abbreviationsByUID.put("1.3.6.1.4.1.5962.301.9", "FP(MF)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.1", "CT(DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.2.1", "DX(Pres DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.2.2", "DX(Proc DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.3", "THREAT(DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.4", "AIT2D(DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.5", "AIT3D(DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.501.6", "QR(DICOS)");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.601.1", "EC");
        this.abbreviationsByUID.put("1.2.840.10008.5.1.4.1.1.601.2", "EC(MF)");
    }

    private void createDescriptionsByUID() {
        this.descriptionsByUID = new HashMap();
        this.descriptionsByUID.put("1.2.840.10008.1.1", "Verification");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1", "Computed Radiography Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.1", "Digital X-Ray Image Storage (For Presentation)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.1.1", "Digital X-Ray Image Storage (For Processing)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.2", "Digital Mammography X-Ray Image Storage (For Presentation)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.2.1", "Digital Mammography X-Ray Image Storage (For Processing)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.3", "Digital Intraoral X-Ray Image Storage (For Presentation)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.1.3.1", "Digital Intraoral X-Ray Image Storage (For Processing)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.2", "CT Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.2.1", "Enhanced CT Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.2.2", "Legacy Converted Enhanced CT Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.3", "Ultrasound Multiframe Image Storage (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.3.1", "Ultrasound Multiframe Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.4", "MR Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.4.1", "Enhanced MR Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.4.3", "Enhanced MR Color Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.4.4", "Legacy Converted Enhanced MR Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.5", "Nuclear Medicine Image Storage (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.6", "Ultrasound Image Storage (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.6.1", "Ultrasound Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.6.2", "Enhanced US Volume Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.6.3", "Photoacoustic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.7", "Secondary Capture Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.7.1", "Multiframe Single Bit Secondary Capture Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.7.2", "Multiframe Grayscale Byte Secondary Capture Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.7.3", "Multiframe Grayscale Word Secondary Capture Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.7.4", "Multiframe True Color Secondary Capture Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.12.1", "X-Ray Angiographic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.12.1.1", "Enhanced XA Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.12.2", "X-Ray Radio Flouroscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.12.2.1", "Enhanced XRF Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.12.3", "X-Ray Angiographic Biplane Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.1", "X-Ray 3D Angiographic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.2", "X-Ray 3D Craniofacial Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.3", "Breast Tomosynthesis Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.4", "Breast Projection X-Ray Image Storage - For Presentation Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.5", "Breast Projection X-Ray Image Storage - For Processing Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.20", "Nuclear Medicine Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1", "Visible Light Endoscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1.1", "Video Endoscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2", "Visible Light Microscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2.1", "Video Microscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.3", "Visible Light Slide Coordinates Microscopic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4", "Visible Light Photographic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4.1", "Video Photographic Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.1", "Ophthalmic Photography 8 Bit Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.2", "Ophthalmic Photography 16 Bit Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.4", "Ophthalmic Tomography Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.7", "Ophthalmic Optical Coherence Tomography En Face Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.8", "Ophthalmic Optical Coherence Tomography B-scan Volume Analysis Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.6", "VL Whole Slide Microscopy Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.7", "Dermoscopic Photography Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.8", "Confocal Microscopy Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.9", "Confocal Microscopy Tiled Pyramidal Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.5", "Wide Field Ophthalmic Photography Stereographic Projection Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.6", "Wide Field Ophthalmic Photography 3D Coordinates Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.128", "PET Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.130", "Enhanced PET Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.128.1", "Legacy Converted Enhanced PET Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.1", "RT Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.14.1", "Intravascular OCT Image Storage (For Presentation)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.14.2", "Intravascular OCT Image Storage (For Processing)");
        this.descriptionsByUID.put("1.2.840.10008.1.3.10", "Media Storage Directory Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.11", "Basic Text SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.22", "Enhanced SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.33", "Comprehensive SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.34", "Comprehensive 3D SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.35", "Extensible SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.50", "Mammography CAD SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.65", "Chest CAD SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.40", "Procedure Log Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.67", "X-Ray Radiation Dose SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.68", "Radiopharmaceutical Radiation Dose SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.69", "Colon CAD SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.70", "Implantation Plan SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.71", "Acquisition Context SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.72", "Simplified Adult Echo SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.73", "Patient Radiation Dose SR Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.79.1", "Macular Grid Thickness and Volume Report Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.59", "Key Object Selection Document Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.1", "Text SR Storage - Trial (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.2", "Audio SR Storage - Trial (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.3", "Detail SR Storage - Trial (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.4", "Comprehensive SR Storage - Trial (Retired)");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.1", "Grayscale Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.2", "Color Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.3", "Pseudo-Color Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.4", "Blending Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.5", "XA/XRF Grayscale Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.6", "Grayscale Planar MPR Volumetric Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.7", "Compositing Planar MPR Volumetric Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.8", "Advanced Blending Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.9", "Volume Rendering Volumetric Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.10", "Segmented Volume Rendering Volumetric Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.11", "Multiple Volume Rendering Volumetric Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11.12", "Variable Modality LUT Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.1", "Waveform Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.2", "Waveform Acquisition Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.1", "Twelve Lead ECG Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.2", "General ECG Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.3", "Ambulatory ECG Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.2.1", "Hemodynamic Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.3.1", "Cardiac Electrophysiology Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.1", "Basic Voice Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.2", "General Audio Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.5.1", "Arterial Pulse Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.1", "Respiratory Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.2", "Multi-channel Respiratory Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.1", "Routine Scalp Electroencephalogram Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.2", "Electromyogram Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.3", "Electrooculogram Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.4", "Sleep Electroencephalogram Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9.8.1", "Body Position Waveform Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.8", "Standalone Overlay Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.9", "Standalone Curve Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.10", "Standalone Modality LUT Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.11", "Standalone VOI LUT Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.129", "Standalone PET Curve Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.2", "RT Dose Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.3", "RT Structure Set Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.4", "RT Beams Treatment Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.9", "RT Ion Beams Treatment Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.5", "RT Plan Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.8", "RT Ion Plan Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.6", "RT Brachy Treatment Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.7", "RT Treatment Summary Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.10", "RT Physician Intent Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.11", "RT Segment Annotation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.12", "RT Radiation Set Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.13", "C-Arm Photon-Electron Radiation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.14", "Tomotherapeutic Radiation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.15", "Robotic-Arm Radiation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.16", "RT Radiation Record Set Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.17", "RT Radiation Salvage Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.18", "Tomotherapeutic Radiation Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.19", "C-Arm Photon-Electron Radiation Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.481.20", "Robotic Radiation Record Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.34.1", "RT Beams Delivery Instruction Storage - Trial");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.34.4", "RT Beams Delivery Instruction Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.4.2", "MR Spectroscopy Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66", "Raw Data Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.1", "Spatial Registration Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.2", "Spatial Fiducials Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.3", "Deformable Spatial Registration Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.3", "Stereometric Relationship Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.67", "Real World Value Mapping Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.104.1", "Encapsulated PDF Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.104.2", "Encapsulated CDA Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.104.3", "Encapsulated STL Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.2.1", "Study Root Query Retrieve Information Model Find");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.2.2", "Study Root Query Retrieve Information Model Move");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.4", "Segmentation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.5", "Surface Segmentation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.6", "Tractography Results Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.7", "Label Map Segmentation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.66.8", "Height Map Segmentation Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.68.1", "Surface Scan Mesh Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.68.2", "Surface Scan Point Cloud Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.1", "Lensometry Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.2", "Autorefraction Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.3", "Keratometry Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.4", "Subjective Refraction Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.5", "Visual Acuity Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.6", "Spectacle Prescription Report Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.7", "Ophthalmic Axial Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.78.8", "Intraocular Lens Calculations Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.80.1", "Ophthalmic Visual Field Static Perimetry Measurements Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.81.1", "Ophthalmic Thickness Map Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.82.1", "Corneal Topography Map Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.39.1", "Color Palette Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.43.1", "Generic Implant Template Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.44.1", "Implant Assembly Template Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.45.1", "Implant Template Group Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.131", "Basic Structured Display Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.2", "GE Private Dicom MR Image Info Object Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.3", "GE Private Dicom CT Image Info Object Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.4", "GE Private Dicom Display Image Info Object Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.30", "GE Private PET Raw Data Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.26", "GE Private 3D Model Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.27", "GE Private eNTEGRA Protocol or NM Genie Storage");
        this.descriptionsByUID.put("1.2.528.1.1001.5.1.1.1", "GE Private Collage Storage");
        this.descriptionsByUID.put("1.2.840.113619.4.5.249", "GE Private RT Plan Storage");
        this.descriptionsByUID.put("1.3.12.2.1107.5.9.1", "Siemens Private CSA Non-Image Storage");
        this.descriptionsByUID.put("1.3.12.2.1107.5.99.3.10", "Siemens CT MR Volume Storage");
        this.descriptionsByUID.put("1.3.12.2.1107.5.99.3.11", "Siemens Private AX Frame Sets Storage");
        this.descriptionsByUID.put("1.2.124.113532.3500.7", "Agfa Private Basic Attribute Presentation State Storage");
        this.descriptionsByUID.put("1.3.6.1.4.1.16978.3.1", "Medical Insight Private 3D Softcopy Presentation State Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.88.3", "Acuson Private SR Detail Storage");
        this.descriptionsByUID.put("1.2.276.0.48.5.1.4.1.1.7", "TomTec Private Annotation Storage");
        this.descriptionsByUID.put("1.2.392.200036.9125.1.1.2", "Fuji Private CR Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.2.4.1.1", "Philips Private CX Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.1", "Philips Private Volume Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.1.1", "Philips Private Volume 2 Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.2", "Philips Private 3D Object Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.2.1", "Philips Private 3D Object 2 Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.3", "Philips Private Surface Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.3.1", "Philips Private Surface 2 Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.4", "Philips Private Composite Object Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.7", "Philips Private MR Cardio Profile Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.8", "Philips Private MR Cardio Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.8.1", "Philips Private MR Cardio 2 Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.9", "Philips Private CT Synthetic Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.10", "Philips Private MR Synthetic Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.11", "Philips Private MR Cardio Analysis Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.11.1", "Philips Private MR Cardio Analysis Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.12", "Philips Private CX Synthetic Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.11.0.0.12.1", "Philips Private MR Spectrum Storage");
        this.descriptionsByUID.put("1.3.46.670589.11.0.0.12.2", "Philips Private MR Series Data Storage");
        this.descriptionsByUID.put("1.3.46.670589.11.0.0.12.3", "Philips Private MR Color Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.11.0.0.12.4", "Philips Private MR Examcard Storage");
        this.descriptionsByUID.put("1.3.46.670589.2.3.1.1", "Philips Private Specialised XA Storage");
        this.descriptionsByUID.put("1.3.46.670589.2.5.1.1", "Philips Private 3D Presentation State Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.13", "Philips Private Perfusion Storage");
        this.descriptionsByUID.put("1.3.46.670589.5.0.14", "Philips Private Perfusion Image Storage");
        this.descriptionsByUID.put("1.3.46.670589.2.8.1.1 ", "Philips Private VRML Storage");
        this.descriptionsByUID.put("1.3.46.670589.2.11.1.1", "Philips Private Volume Set Storage");
        this.descriptionsByUID.put("1.3.46.670589.7.8.1618510092", "Philips Private Live Run Storage");
        this.descriptionsByUID.put("1.3.46.670589.7.8.16185100129", "Philips Private Run Storage");
        this.descriptionsByUID.put("1.3.46.670589.7.8.16185100130", "Philips Private Reconstruction Storage");
        this.descriptionsByUID.put("1.3.46.670589.7.8.1618510091", "Philips Private X-Ray Multiframe Storage");
        this.descriptionsByUID.put("1.2.840.113543.6.6.1.3.10001", "Philips HP Private Live3D 01 Storage");
        this.descriptionsByUID.put("1.2.840.113543.6.6.1.3.10002", "Philips HP Private Live3D 02 Storage");
        this.descriptionsByUID.put("2.16.840.1.114033.5.1.4.1.1.130", "PMOD Private Multiframe Image Storage");
        this.descriptionsByUID.put("1.2.392.200036.9116.7.8.1.1.1", "Toshiba Private US Image Storage");
        this.descriptionsByUID.put("1.2.826.0.1.3680043.293.1.0.1", "Private eRAD PracticeBuilder Report Text Storage");
        this.descriptionsByUID.put("1.2.826.0.1.3680043.293.1.0.2", "Private eRAD PracticeBuilder Report Dictation Storage");
        this.descriptionsByUID.put("1.2.40.0.13.1.5.1.4.1.1.2.1", "Private Dcm4che Upgraded CT Image Storage");
        this.descriptionsByUID.put("1.2.40.0.13.1.5.1.4.1.1.4.1", "Private Dcm4che Upgraded MR Image Storage");
        this.descriptionsByUID.put("1.2.40.0.13.1.5.1.4.1.1.128.1", "Private Dcm4che Upgraded PET Image Storage");
        this.descriptionsByUID.put("1.2.40.0.13.1.5.1.4.1.1.104.1", "Private Dcm4che Encapsulated Document Storage");
        this.descriptionsByUID.put("1.3.6.1.4.1.5962.301.1", "Private PixelMed Legacy Converted Enhanced CT Image Storage");
        this.descriptionsByUID.put("1.3.6.1.4.1.5962.301.2", "Private PixelMed Legacy Converted Enhanced MR Image Storage");
        this.descriptionsByUID.put("1.3.6.1.4.1.5962.301.3", "Private PixelMed Legacy Converted Enhanced PET Image Storage");
        this.descriptionsByUID.put("1.3.6.1.4.1.5962.301.9", "Private PixelMed Floating Point Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.1", "DICOS CT Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.2.1", "DICOS Digital X-Ray Image Storage - For Presentation");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.2.2", "DICOS Digital X-Ray Image Storage - For Processing");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.3", "DICOS Threat Detection Report Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.4", "DICOS 2D AIT Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.5", "DICOS 3D AIT Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.501.6", "DICOS Quadrupole Resonance Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.601.1", "DICONDE Eddy Current Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.1.601.2", "DICONDE Eddy Current Multi-frame Image Storage");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.2.1", "Study Root Query/Retrieve Information Model - FIND");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.2.2", "Study Root Query/Retrieve Information Model - MOVE");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.2.3", "Study Root Query/Retrieve Information Model - GET");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.1.1", "Patient Root Query/Retrieve Information Model - FIND");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.1.2", "Patient Root Query/Retrieve Information Model - MOVE");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.1.3", "Patient Root Query/Retrieve Information Model - GET");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.3.1", "Patient/Study Only Query/Retrieve Information Model - FIND");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.3.2", "Patient/Study Only Query/Retrieve Information Model - MOVE");
        this.descriptionsByUID.put("1.2.840.10008.5.1.4.1.2.3.3", "Patient/Study Only Query/Retrieve Information Model - GET");
        this.descriptionsByUID.put("1.2.840.10008.39.2", "Color Palette Query/Retrieve Information Model - FIND");
        this.descriptionsByUID.put("1.2.840.10008.39.3", "Color Palette Query/Retrieve Information Model - MOVE");
        this.descriptionsByUID.put("1.2.840.10008.39.4", "Color Palette Query/Retrieve Information Model - GET");
    }

    private void createKeywordsByUID() {
        this.keywordsByUID = new HashMap();
        this.keywordsByUID.put("1.2.840.10008.1.1", "Verification");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1", "ComputedRadiographyImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.1", "DigitalXRayImageStorageForPresentation");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.1.1", "DigitalXRayImageStorageForProcessing");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.2", "DigitalMammographyXRayImageStorageForPresentation");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.2.1", "DigitalMammographyXRayImageStorageForProcessing");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.3", "DigitalIntraoralXRayImageStorageForPresentation");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.1.3.1", "DigitalIntraoralXRayImageStorageForProcessing");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.2", "CTImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.2.1", "EnhancedCTImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.2.2", "LegacyConvertedEnhancedCTImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.3", "UltrasoundMultiframeImageStorageRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.3.1", "UltrasoundMultiframeImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.4", "MRImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.4.1", "EnhancedMRImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.4.3", "EnhancedMRColorImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.4.4", "LegacyConvertedEnhancedMRImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.5", "NuclearMedicineImageStorageRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.6", "UltrasoundImageStorageRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.6.1", "UltrasoundImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.6.2", "EnhancedUSVolumeStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.6.3", "PhotoacousticImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.7", "SecondaryCaptureImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.7.1", "MultiframeSingleBitSecondaryCaptureImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.7.2", "MultiframeGrayscaleByteSecondaryCaptureImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.7.3", "MultiframeGrayscaleWordSecondaryCaptureImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.7.4", "MultiframeTrueColorSecondaryCaptureImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.12.1", "XRayAngiographicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.12.1.1", "EnhancedXAImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.12.2", "XRayRadioFlouroscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.12.2.1", "EnhancedXRFImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.12.3", "XRayAngiographicBiplaneImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.1", "XRay3DAngiographicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.2", "XRay3DCraniofacialImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.3", "BreastTomosynthesisImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.4", "BreastProjectionXRayImageStorageForPresentationImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.13.1.5", "BreastProjectionXRayImageStorageForProcessingImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.20", "NuclearMedicineImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1", "VisibleLightEndoscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.1.1", "VideoEndoscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2", "VisibleLightMicroscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.2.1", "VideoMicroscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.3", "VisibleLightSlideCoordinatesMicroscopicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4", "VisibleLightPhotographicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.4.1", "VideoPhotographicImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.1", "OphthalmicPhotography8BitImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.2", "OphthalmicPhotography16BitImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.4", "OphthalmicTomographyImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.7", "OphthalmicOpticalCoherenceTomographyEnFaceImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.8", "OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.6", "VLWholeSlideMicroscopyImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.7", "DermoscopicPhotographyImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.8", "ConfocalMicroscopyImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.9", "ConfocalMicroscopyTiledPyramidalImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.5", "WideFieldOphthalmicPhotographyStereographicProjectionImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.6", "WideFieldOphthalmicPhotography3DCoordinatesImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.128", "PETImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.130", "EnhancedPETImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.128.1", "LegacyConvertedEnhancedPETImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.1", "RTImageStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.14.1", "IntravascularOCTImageStorageForPresentation");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.14.2", "IntravascularOCTImageStorageForProcessing");
        this.keywordsByUID.put("1.2.840.10008.1.3.10", "MediaStorageDirectoryStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.11", "BasicTextSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.22", "EnhancedSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.33", "ComprehensiveSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.34", "Comprehensive3DSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.35", "ExtensibleSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.50", "MammographyCADSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.65", "ChestCADSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.40", "ProcedureLogStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.67", "XRayRadiationDoseSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.68", "RadiopharmaceuticalRadiationDoseSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.69", "ColonCADSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.70", "ImplantationPlanSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.71", "AcquisitionContextSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.72", "SimplifiedAdultEchoSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.73", "PatientRadiationDoseSRStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.79.1", "MacularGridThicknessAndVolumeReportStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.59", "KeyObjectSelectionDocumentStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.1", "TextSRStorageTrialRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.2", "AudioSRStorageTrialRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.3", "DetailSRStorageTrialRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.88.4", "ComprehensiveSRStorageTrialRetired");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.1", "GrayscaleSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.2", "ColorSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.3", "PseudoColorSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.4", "BlendingSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.5", "XAXRFGrayscaleSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.6", "GrayscalePlanarMPRVolumetricPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.7", "CompositingPlanarMPRVolumetricPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.8", "AdvancedBlendingPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.9", "VolumeRenderingVolumetricPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.10", "SegmentedVolumeRenderingVolumetricPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.11", "MultipleVolumeRenderingVolumetricPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11.12", "VariableModalityLUTSoftcopyPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.1", "WaveformPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.100.2", "WaveformAcquisitionPresentationStateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.1", "TwelveLeadECGStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.2", "GeneralECGStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.1.3", "AmbulatoryECGStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.2.1", "HemodynamicWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.3.1", "CardiacElectrophysiologyWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.1", "BasicVoiceStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.4.2", "GeneralAudioWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.5.1", "ArterialPulseWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.1", "RespiratoryWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.1", "RespiratoryWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.6.2", "MultichannelRespiratoryWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.1", "RoutineScalpElectroencephalogramWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.2", "ElectromyogramWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.3", "ElectrooculogramWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.7.4", "SleepElectroencephalogramWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9.8.1", "BodyPositionWaveformStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.8", "StandaloneOverlayStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.9", "StandaloneCurveStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.10", "StandaloneModalityLUTStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.11", "StandaloneVOILUTStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.129", "StandalonePETCurveStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.2", "RTDoseStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.3", "RTStructureSetStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.4", "RTBeamsTreatmentRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.9", "RTIonBeamsTreatmentRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.5", "RTPlanStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.8", "RTIonPlanStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.6", "RTBrachyTreatmentRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.7", "RTTreatmentSummaryRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.10", "RTPhysicianIntentStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.11", "RTSegmentAnnotationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.12", "RTRadiationSetStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.13", "CArmPhotonElectronRadiationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.14", "TomotherapeuticRadiationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.15", "RoboticArmRadiationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.16", "RTRadiationRecordSetStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.17", "RTRadiationSalvageRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.18", "TomotherapeuticRadiationRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.19", "CArmPhotonElectronRadiationRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.481.20", "RoboticRadiationRecordStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.34.1", "RTBeamsDeliveryInstructionStorageTrial");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.34.4", "RTBeamsDeliveryInstructionStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.4.2", "MRSpectroscopyStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66", "RawDataStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.1", "SpatialRegistrationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.2", "SpatialFiducialsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.3", "DeformableSpatialRegistrationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.77.1.5.3", "StereometricRelationshipStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.67", "RealWorldValueMappingStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.104.1", "EncapsulatedPDFStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.104.2", "EncapsulatedCDAStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.104.3", "EncapsulatedSTLStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.2.1", "StudyRootQueryRetrieveInformationModelFind");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.2.2", "StudyRootQueryRetrieveInformationModelMove");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.4", "SegmentationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.5", "SurfaceSegmentationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.6", "TractographyResultsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.7", "LabelMapSegmentationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.66.8", "HeightMapSegmentationStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.68.1", "SurfaceScanMeshStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.68.2", "SurfaceScanPointCloudStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.1", "LensometryMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.2", "AutorefractionMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.3", "KeratometryMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.4", "SubjectiveRefractionMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.5", "VisualAcuityMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.6", "SpectaclePrescriptionReportStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.7", "OphthalmicAxialMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.78.8", "IntraocularLensCalculationsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.80.1", "OphthalmicVisualFieldStaticPerimetryMeasurementsStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.81.1", "OphthalmicThicknessMapStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.82.1", "CornealTopographyMapStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.39.1", "ColorPaletteStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.43.1", "GenericImplantTemplateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.44.1", "ImplantAssemblyTemplateStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.45.1", "ImplantTemplateGroupStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.1.131", "BasicStructuredDisplayStorage");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.2.1", "StudyRootQueryRetrieveInformationModelFind");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.2.2", "StudyRootQueryRetrieveInformationModelMove");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.2.3", "StudyRootQueryRetrieveInformationModelGet");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.1.1", "PatientRootQueryRetrieveInformationModelFind");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.1.2", "PatientRootQueryRetrieveInformationModelMove");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.1.3", "PatientRootQueryRetrieveInformationModelGet");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.3.1", "PatientStudyOnlyQueryRetrieveInformationModelFind");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.3.2", "PatientStudyOnlyQueryRetrieveInformationModelMove");
        this.keywordsByUID.put("1.2.840.10008.5.1.4.1.2.3.3", "PatientStudyOnlyQueryRetrieveInformationModelGet");
        this.keywordsByUID.put("1.2.840.10008.39.2", "ColorPaletteQueryRetrieveInformationModelFind");
        this.keywordsByUID.put("1.2.840.10008.39.3", "ColorPaletteQueryRetrieveInformationModelMove");
        this.keywordsByUID.put("1.2.840.10008.39.4", "ColorPaletteQueryRetrieveInformationModelGet");
    }

    private void createUIDsByKeyword() {
        this.uidsByKeyword = new HashMap();
        this.uidsByKeyword.put("Verification", "1.2.840.10008.1.1");
        this.uidsByKeyword.put("ComputedRadiographyImageStorage", "1.2.840.10008.5.1.4.1.1.1");
        this.uidsByKeyword.put("DigitalXRayImageStorageForPresentation", "1.2.840.10008.5.1.4.1.1.1.1");
        this.uidsByKeyword.put("DigitalXRayImageStorageForProcessing", "1.2.840.10008.5.1.4.1.1.1.1.1");
        this.uidsByKeyword.put("DigitalMammographyXRayImageStorageForPresentation", "1.2.840.10008.5.1.4.1.1.1.2");
        this.uidsByKeyword.put("DigitalMammographyXRayImageStorageForProcessing", "1.2.840.10008.5.1.4.1.1.1.2.1");
        this.uidsByKeyword.put("DigitalIntraoralXRayImageStorageForPresentation", "1.2.840.10008.5.1.4.1.1.1.3");
        this.uidsByKeyword.put("DigitalIntraoralXRayImageStorageForProcessing", "1.2.840.10008.5.1.4.1.1.1.3.1");
        this.uidsByKeyword.put("CTImageStorage", "1.2.840.10008.5.1.4.1.1.2");
        this.uidsByKeyword.put("EnhancedCTImageStorage", "1.2.840.10008.5.1.4.1.1.2.1");
        this.uidsByKeyword.put("LegacyConvertedEnhancedCTImageStorage", "1.2.840.10008.5.1.4.1.1.2.2");
        this.uidsByKeyword.put("UltrasoundMultiframeImageStorageRetired", "1.2.840.10008.5.1.4.1.1.3");
        this.uidsByKeyword.put("UltrasoundMultiframeImageStorage", "1.2.840.10008.5.1.4.1.1.3.1");
        this.uidsByKeyword.put("MRImageStorage", "1.2.840.10008.5.1.4.1.1.4");
        this.uidsByKeyword.put("EnhancedMRImageStorage", "1.2.840.10008.5.1.4.1.1.4.1");
        this.uidsByKeyword.put("EnhancedMRColorImageStorage", "1.2.840.10008.5.1.4.1.1.4.3");
        this.uidsByKeyword.put("LegacyConvertedEnhancedMRImageStorage", "1.2.840.10008.5.1.4.1.1.4.4");
        this.uidsByKeyword.put("NuclearMedicineImageStorageRetired", "1.2.840.10008.5.1.4.1.1.5");
        this.uidsByKeyword.put("UltrasoundImageStorageRetired", "1.2.840.10008.5.1.4.1.1.6");
        this.uidsByKeyword.put("UltrasoundImageStorage", "1.2.840.10008.5.1.4.1.1.6.1");
        this.uidsByKeyword.put("EnhancedUSVolumeStorage", "1.2.840.10008.5.1.4.1.1.6.2");
        this.uidsByKeyword.put("PhotoacousticImageStorage", "1.2.840.10008.5.1.4.1.1.6.3");
        this.uidsByKeyword.put("SecondaryCaptureImageStorage", "1.2.840.10008.5.1.4.1.1.7");
        this.uidsByKeyword.put("MultiframeSingleBitSecondaryCaptureImageStorage", "1.2.840.10008.5.1.4.1.1.7.1");
        this.uidsByKeyword.put("MultiframeGrayscaleByteSecondaryCaptureImageStorage", "1.2.840.10008.5.1.4.1.1.7.2");
        this.uidsByKeyword.put("MultiframeGrayscaleWordSecondaryCaptureImageStorage", "1.2.840.10008.5.1.4.1.1.7.3");
        this.uidsByKeyword.put("MultiframeTrueColorSecondaryCaptureImageStorage", "1.2.840.10008.5.1.4.1.1.7.4");
        this.uidsByKeyword.put("XRayAngiographicImageStorage", "1.2.840.10008.5.1.4.1.1.12.1");
        this.uidsByKeyword.put("EnhancedXAImageStorage", "1.2.840.10008.5.1.4.1.1.12.1.1");
        this.uidsByKeyword.put("XRayRadioFlouroscopicImageStorage", "1.2.840.10008.5.1.4.1.1.12.2");
        this.uidsByKeyword.put("EnhancedXRFImageStorage", "1.2.840.10008.5.1.4.1.1.12.2.1");
        this.uidsByKeyword.put("XRayAngiographicBiplaneImageStorage", "1.2.840.10008.5.1.4.1.1.12.3");
        this.uidsByKeyword.put("XRay3DAngiographicImageStorage", "1.2.840.10008.5.1.4.1.1.13.1.1");
        this.uidsByKeyword.put("XRay3DCraniofacialImageStorage", "1.2.840.10008.5.1.4.1.1.13.1.2");
        this.uidsByKeyword.put("BreastTomosynthesisImageStorage", "1.2.840.10008.5.1.4.1.1.13.1.3");
        this.uidsByKeyword.put("BreastProjectionXRayImageStorageForPresentationImageStorage", "1.2.840.10008.5.1.4.1.1.13.1.4");
        this.uidsByKeyword.put("BreastProjectionXRayImageStorageForProcessingImageStorage", "1.2.840.10008.5.1.4.1.1.13.1.5");
        this.uidsByKeyword.put("NuclearMedicineImageStorage", "1.2.840.10008.5.1.4.1.1.20");
        this.uidsByKeyword.put("VisibleLightEndoscopicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.1");
        this.uidsByKeyword.put("VideoEndoscopicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.1.1");
        this.uidsByKeyword.put("VisibleLightMicroscopicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.2");
        this.uidsByKeyword.put("VideoMicroscopicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.2.1");
        this.uidsByKeyword.put("VisibleLightSlideCoordinatesMicroscopicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.3");
        this.uidsByKeyword.put("VisibleLightPhotographicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.4");
        this.uidsByKeyword.put("VideoPhotographicImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.4.1");
        this.uidsByKeyword.put("OphthalmicPhotography8BitImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.1");
        this.uidsByKeyword.put("OphthalmicPhotography16BitImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.2");
        this.uidsByKeyword.put("OphthalmicTomographyImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.4");
        this.uidsByKeyword.put("OphthalmicOpticalCoherenceTomographyEnFaceImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.7");
        this.uidsByKeyword.put("OphthalmicOpticalCoherenceTomographyBscanVolumeAnalysisStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.8");
        this.uidsByKeyword.put("VLWholeSlideMicroscopyImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.6");
        this.uidsByKeyword.put("DermoscopicPhotographyImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.7");
        this.uidsByKeyword.put("ConfocalMicroscopyImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.8");
        this.uidsByKeyword.put("ConfocalMicroscopyTiledPyramidalImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.9");
        this.uidsByKeyword.put("WideFieldOphthalmicPhotographyStereographicProjectionImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.5");
        this.uidsByKeyword.put("WideFieldOphthalmicPhotography3DCoordinatesImageStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.6");
        this.uidsByKeyword.put("PETImageStorage", "1.2.840.10008.5.1.4.1.1.128");
        this.uidsByKeyword.put("EnhancedPETImageStorage", "1.2.840.10008.5.1.4.1.1.130");
        this.uidsByKeyword.put("LegacyConvertedEnhancedPETImageStorage", "1.2.840.10008.5.1.4.1.1.128.1");
        this.uidsByKeyword.put("RTImageStorage", "1.2.840.10008.5.1.4.1.1.481.1");
        this.uidsByKeyword.put("IntravascularOCTImageStorageForPresentation", "1.2.840.10008.5.1.4.1.1.14.1");
        this.uidsByKeyword.put("IntravascularOCTImageStorageForProcessing", "1.2.840.10008.5.1.4.1.1.14.2");
        this.uidsByKeyword.put("MediaStorageDirectoryStorage", "1.2.840.10008.1.3.10");
        this.uidsByKeyword.put("BasicTextSRStorage", "1.2.840.10008.5.1.4.1.1.88.11");
        this.uidsByKeyword.put("EnhancedSRStorage", "1.2.840.10008.5.1.4.1.1.88.22");
        this.uidsByKeyword.put("ComprehensiveSRStorage", "1.2.840.10008.5.1.4.1.1.88.33");
        this.uidsByKeyword.put("Comprehensive3DSRStorage", "1.2.840.10008.5.1.4.1.1.88.34");
        this.uidsByKeyword.put("ExtensibleSRStorage", "1.2.840.10008.5.1.4.1.1.88.35");
        this.uidsByKeyword.put("MammographyCADSRStorage", "1.2.840.10008.5.1.4.1.1.88.50");
        this.uidsByKeyword.put("ChestCADSRStorage", "1.2.840.10008.5.1.4.1.1.88.65");
        this.uidsByKeyword.put("ProcedureLogStorage", "1.2.840.10008.5.1.4.1.1.88.40");
        this.uidsByKeyword.put("XRayRadiationDoseSRStorage", "1.2.840.10008.5.1.4.1.1.88.67");
        this.uidsByKeyword.put("RadiopharmaceuticalRadiationDoseSRStorage", "1.2.840.10008.5.1.4.1.1.88.68");
        this.uidsByKeyword.put("ColonCADSRStorage", "1.2.840.10008.5.1.4.1.1.88.69");
        this.uidsByKeyword.put("ImplantationPlanSRStorage", "1.2.840.10008.5.1.4.1.1.88.70");
        this.uidsByKeyword.put("AcquisitionContextSRStorage", "1.2.840.10008.5.1.4.1.1.88.71");
        this.uidsByKeyword.put("SimplifiedAdultEchoSRStorage", "1.2.840.10008.5.1.4.1.1.88.72");
        this.uidsByKeyword.put("PatientRadiationDoseSRStorage", "1.2.840.10008.5.1.4.1.1.88.73");
        this.uidsByKeyword.put("MacularGridThicknessAndVolumeReportStorage", "1.2.840.10008.5.1.4.1.1.79.1");
        this.uidsByKeyword.put("KeyObjectSelectionDocumentStorage", "1.2.840.10008.5.1.4.1.1.88.59");
        this.uidsByKeyword.put("TextSRStorageTrialRetired", "1.2.840.10008.5.1.4.1.1.88.1");
        this.uidsByKeyword.put("AudioSRStorageTrialRetired", "1.2.840.10008.5.1.4.1.1.88.2");
        this.uidsByKeyword.put("DetailSRStorageTrialRetired", "1.2.840.10008.5.1.4.1.1.88.3");
        this.uidsByKeyword.put("ComprehensiveSRStorageTrialRetired", "1.2.840.10008.5.1.4.1.1.88.4");
        this.uidsByKeyword.put("GrayscaleSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.1");
        this.uidsByKeyword.put("ColorSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.2");
        this.uidsByKeyword.put("PseudoColorSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.3");
        this.uidsByKeyword.put("BlendingSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.4");
        this.uidsByKeyword.put("XAXRFGrayscaleSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.5");
        this.uidsByKeyword.put("GrayscalePlanarMPRVolumetricPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.6");
        this.uidsByKeyword.put("CompositingPlanarMPRVolumetricPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.7");
        this.uidsByKeyword.put("AdvancedBlendingPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.8");
        this.uidsByKeyword.put("VolumeRenderingVolumetricPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.9");
        this.uidsByKeyword.put("SegmentedVolumeRenderingVolumetricPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.10");
        this.uidsByKeyword.put("MultipleVolumeRenderingVolumetricPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.11");
        this.uidsByKeyword.put("VariableModalityLUTSoftcopyPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.11.12");
        this.uidsByKeyword.put("WaveformPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.9.100.1");
        this.uidsByKeyword.put("WaveformAcquisitionPresentationStateStorage", "1.2.840.10008.5.1.4.1.1.9.100.2");
        this.uidsByKeyword.put("TwelveLeadECGStorage", "1.2.840.10008.5.1.4.1.1.9.1.1");
        this.uidsByKeyword.put("GeneralECGStorage", "1.2.840.10008.5.1.4.1.1.9.1.2");
        this.uidsByKeyword.put("AmbulatoryECGStorage", "1.2.840.10008.5.1.4.1.1.9.1.3");
        this.uidsByKeyword.put("HemodynamicWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.2.1");
        this.uidsByKeyword.put("CardiacElectrophysiologyWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.3.1");
        this.uidsByKeyword.put("BasicVoiceStorage", "1.2.840.10008.5.1.4.1.1.9.4.1");
        this.uidsByKeyword.put("GeneralAudioWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.4.2");
        this.uidsByKeyword.put("ArterialPulseWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.5.1");
        this.uidsByKeyword.put("RespiratoryWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.6.1");
        this.uidsByKeyword.put("MultichannelRespiratoryWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.6.2");
        this.uidsByKeyword.put("RoutineScalpElectroencephalogramWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.7.1");
        this.uidsByKeyword.put("ElectromyogramWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.7.2");
        this.uidsByKeyword.put("ElectrooculogramWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.7.3");
        this.uidsByKeyword.put("SleepElectroencephalogramWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.7.4");
        this.uidsByKeyword.put("BodyPositionWaveformStorage", "1.2.840.10008.5.1.4.1.1.9.8.1");
        this.uidsByKeyword.put("StandaloneOverlayStorage", "1.2.840.10008.5.1.4.1.1.8");
        this.uidsByKeyword.put("StandaloneCurveStorage", "1.2.840.10008.5.1.4.1.1.9");
        this.uidsByKeyword.put("StandaloneModalityLUTStorage", "1.2.840.10008.5.1.4.1.1.10");
        this.uidsByKeyword.put("StandaloneVOILUTStorage", "1.2.840.10008.5.1.4.1.1.11");
        this.uidsByKeyword.put("StandalonePETCurveStorage", "1.2.840.10008.5.1.4.1.1.129");
        this.uidsByKeyword.put("RTDoseStorage", "1.2.840.10008.5.1.4.1.1.481.2");
        this.uidsByKeyword.put("RTStructureSetStorage", "1.2.840.10008.5.1.4.1.1.481.3");
        this.uidsByKeyword.put("RTBeamsTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.4");
        this.uidsByKeyword.put("RTIonBeamsTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.9");
        this.uidsByKeyword.put("RTPlanStorage", "1.2.840.10008.5.1.4.1.1.481.5");
        this.uidsByKeyword.put("RTIonPlanStorage", "1.2.840.10008.5.1.4.1.1.481.8");
        this.uidsByKeyword.put("RTBrachyTreatmentRecordStorage", "1.2.840.10008.5.1.4.1.1.481.6");
        this.uidsByKeyword.put("RTTreatmentSummaryRecordStorage", "1.2.840.10008.5.1.4.1.1.481.7");
        this.uidsByKeyword.put("RTPhysicianIntentStorage", "1.2.840.10008.5.1.4.1.1.481.10");
        this.uidsByKeyword.put("RTSegmentAnnotationStorage", "1.2.840.10008.5.1.4.1.1.481.11");
        this.uidsByKeyword.put("RTRadiationSetStorage", "1.2.840.10008.5.1.4.1.1.481.12");
        this.uidsByKeyword.put("CArmPhotonElectronRadiationStorage", "1.2.840.10008.5.1.4.1.1.481.13");
        this.uidsByKeyword.put("TomotherapeuticRadiationStorage", "1.2.840.10008.5.1.4.1.1.481.14");
        this.uidsByKeyword.put("RoboticArmRadiationStorage", "1.2.840.10008.5.1.4.1.1.481.15");
        this.uidsByKeyword.put("RTRadiationRecordSetStorage", "1.2.840.10008.5.1.4.1.1.481.16");
        this.uidsByKeyword.put("RTRadiationSalvageRecordStorage", "1.2.840.10008.5.1.4.1.1.481.17");
        this.uidsByKeyword.put("TomotherapeuticRadiationRecordStorage", "1.2.840.10008.5.1.4.1.1.481.18");
        this.uidsByKeyword.put("CArmPhotonElectronRadiationRecordStorage", "1.2.840.10008.5.1.4.1.1.481.19");
        this.uidsByKeyword.put("RoboticRadiationRecordStorage", "1.2.840.10008.5.1.4.1.1.481.20");
        this.uidsByKeyword.put("RTBeamsDeliveryInstructionStorageTrial", "1.2.840.10008.5.1.4.34.1");
        this.uidsByKeyword.put("RTBeamsDeliveryInstructionStorage", "1.2.840.10008.5.1.4.34.4");
        this.uidsByKeyword.put("MRSpectroscopyStorage", "1.2.840.10008.5.1.4.1.1.4.2");
        this.uidsByKeyword.put("RawDataStorage", "1.2.840.10008.5.1.4.1.1.66");
        this.uidsByKeyword.put("SpatialRegistrationStorage", "1.2.840.10008.5.1.4.1.1.66.1");
        this.uidsByKeyword.put("SpatialFiducialsStorage", "1.2.840.10008.5.1.4.1.1.66.2");
        this.uidsByKeyword.put("DeformableSpatialRegistrationStorage", "1.2.840.10008.5.1.4.1.1.66.3");
        this.uidsByKeyword.put("StereometricRelationshipStorage", "1.2.840.10008.5.1.4.1.1.77.1.5.3");
        this.uidsByKeyword.put("RealWorldValueMappingStorage", "1.2.840.10008.5.1.4.1.1.67");
        this.uidsByKeyword.put("EncapsulatedPDFStorage", "1.2.840.10008.5.1.4.1.1.104.1");
        this.uidsByKeyword.put("EncapsulatedCDAStorage", "1.2.840.10008.5.1.4.1.1.104.2");
        this.uidsByKeyword.put("EncapsulatedSTLStorage", "1.2.840.10008.5.1.4.1.1.104.3");
        this.uidsByKeyword.put("StudyRootQueryRetrieveInformationModelFind", "1.2.840.10008.5.1.4.1.2.2.1");
        this.uidsByKeyword.put("StudyRootQueryRetrieveInformationModelMove", "1.2.840.10008.5.1.4.1.2.2.2");
        this.uidsByKeyword.put("SegmentationStorage", "1.2.840.10008.5.1.4.1.1.66.4");
        this.uidsByKeyword.put("SurfaceSegmentationStorage", "1.2.840.10008.5.1.4.1.1.66.5");
        this.uidsByKeyword.put("TractographyResultsStorage", "1.2.840.10008.5.1.4.1.1.66.6");
        this.uidsByKeyword.put("LabelMapSegmentationStorage", "1.2.840.10008.5.1.4.1.1.66.7");
        this.uidsByKeyword.put("HeightMapSegmentationStorage", "1.2.840.10008.5.1.4.1.1.66.8");
        this.uidsByKeyword.put("SurfaceScanMeshStorage", "1.2.840.10008.5.1.4.1.1.68.1");
        this.uidsByKeyword.put("SurfaceScanPointCloudStorage", "1.2.840.10008.5.1.4.1.1.68.2");
        this.uidsByKeyword.put("LensometryMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.1");
        this.uidsByKeyword.put("AutorefractionMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.2");
        this.uidsByKeyword.put("KeratometryMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.3");
        this.uidsByKeyword.put("SubjectiveRefractionMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.4");
        this.uidsByKeyword.put("VisualAcuityMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.5");
        this.uidsByKeyword.put("SpectaclePrescriptionReportStorage", "1.2.840.10008.5.1.4.1.1.78.6");
        this.uidsByKeyword.put("OphthalmicAxialMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.78.7");
        this.uidsByKeyword.put("IntraocularLensCalculationsStorage", "1.2.840.10008.5.1.4.1.1.78.8");
        this.uidsByKeyword.put("OphthalmicVisualFieldStaticPerimetryMeasurementsStorage", "1.2.840.10008.5.1.4.1.1.80.1");
        this.uidsByKeyword.put("OphthalmicThicknessMapStorage", "1.2.840.10008.5.1.4.1.1.81.1");
        this.uidsByKeyword.put("CornealTopographyMapStorage", "1.2.840.10008.5.1.4.1.1.82.1");
        this.uidsByKeyword.put("ColorPaletteStorage", "1.2.840.10008.5.1.4.39.1");
        this.uidsByKeyword.put("GenericImplantTemplateStorage", "1.2.840.10008.5.1.4.43.1");
        this.uidsByKeyword.put("ImplantAssemblyTemplateStorage", "1.2.840.10008.5.1.4.44.1");
        this.uidsByKeyword.put("ImplantTemplateGroupStorage", "1.2.840.10008.5.1.4.45.1");
        this.uidsByKeyword.put("BasicStructuredDisplayStorage", "1.2.840.10008.5.1.4.1.1.131");
        this.uidsByKeyword.put("StudyRootQueryRetrieveInformationModelFind", "1.2.840.10008.5.1.4.1.2.2.1");
        this.uidsByKeyword.put("StudyRootQueryRetrieveInformationModelMove", "1.2.840.10008.5.1.4.1.2.2.2");
        this.uidsByKeyword.put("StudyRootQueryRetrieveInformationModelGet", "1.2.840.10008.5.1.4.1.2.2.3");
        this.uidsByKeyword.put("PatientRootQueryRetrieveInformationModelFind", "1.2.840.10008.5.1.4.1.2.1.1");
        this.uidsByKeyword.put("PatientRootQueryRetrieveInformationModelMove", "1.2.840.10008.5.1.4.1.2.1.2");
        this.uidsByKeyword.put("PatientRootQueryRetrieveInformationModelGet", "1.2.840.10008.5.1.4.1.2.1.3");
        this.uidsByKeyword.put("PatientStudyOnlyQueryRetrieveInformationModelFind", "1.2.840.10008.5.1.4.1.2.3.1");
        this.uidsByKeyword.put("PatientStudyOnlyQueryRetrieveInformationModelMove", "1.2.840.10008.5.1.4.1.2.3.2");
        this.uidsByKeyword.put("PatientStudyOnlyQueryRetrieveInformationModelGet", "1.2.840.10008.5.1.4.1.2.3.3");
        this.uidsByKeyword.put("ColorPaletteQueryRetrieveInformationModelFind", "1.2.840.10008.39.2");
        this.uidsByKeyword.put("ColorPaletteQueryRetrieveInformationModelMove", "1.2.840.10008.39.3");
        this.uidsByKeyword.put("ColorPaletteQueryRetrieveInformationModelGet", "1.2.840.10008.39.4");
    }

    public static void main(String[] stringArray) {
        try {
            System.err.println(SOPClassDescriptions.getDescriptionFromUID("1.2.840.10008.5.1.4.1.1.4.2"));
            System.err.println(SOPClassDescriptions.getAbbreviationFromUID("1.2.840.10008.5.1.4.1.1.4.2"));
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

