/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.BinaryOutputStream;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.StringAttributeAffectedBySpecificCharacterSet;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.HexDump;
import com.pixelmed.utils.StringUtilities;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public class SpecificCharacterSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/SpecificCharacterSet.java,v 1.44 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SpecificCharacterSet.class);
    private String useEncoding;
    private boolean useISO2022 = false;
    private static boolean useOwnJIS;
    private static boolean useOwnJISCheckPerformed;
    private static HashMap ownJIS0208Mapping;
    private static HashMap ownJIS0212Mapping;

    public String toString() {
        return this.useEncoding;
    }

    public static boolean byteArrayContainsNonASCIIValues(byte[] byArray, int n, int n2) {
        for (int i = n; i < n + n2; ++i) {
            if ((byArray[i] & 0xFF) <= 127) continue;
            return true;
        }
        return false;
    }

    public static boolean byteArrayContainsNonASCIIValues(byte[] byArray) {
        return SpecificCharacterSet.byteArrayContainsNonASCIIValues(byArray, 0, byArray.length);
    }

    private boolean testIfNativeJISWorking() {
        slf4jlogger.trace("testIfNativeJISWorking()");
        boolean bl = false;
        byte[] byArray = new byte[]{59, 51, 69, 68};
        try {
            String string = new String(byArray, "JIS0208");
            byte[] byArray2 = string.getBytes("UTF8");
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("testIfNativeJISWorking():src = {}", HexDump.byteArrayToHexString(byArray));
            }
            if (slf4jlogger.isTraceEnabled()) {
                slf4jlogger.trace("testIfNativeJISWorking():dst = {}", HexDump.byteArrayToHexString(byArray2));
            }
            bl = byArray2.length == 6 && (byArray2[0] & 0xFF) == 229 && (byArray2[1] & 0xFF) == 177 && (byArray2[2] & 0xFF) == 177 && (byArray2[3] & 0xFF) == 231 && (byArray2[4] & 0xFF) == 148 && (byArray2[5] & 0xFF) == 176;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        slf4jlogger.trace("testIfNativeJISWorking(): returns {}", bl);
        return bl;
    }

    private static HashMap initializeOwnMapping(String string) {
        slf4jlogger.trace("initializeOwnMapping(): start {}", string);
        HashMap<Short, Character> hashMap = new HashMap<Short, Character>();
        InputStream inputStream = SpecificCharacterSet.class.getResourceAsStream("/com/pixelmed/dicom/" + string);
        if (inputStream != null) {
            slf4jlogger.trace("Opening {}", string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    slf4jlogger.trace("Read {}", string2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2);
                    if (stringTokenizer.countTokens() != 2) continue;
                    Short s = new Short(Integer.decode(stringTokenizer.nextToken()).shortValue());
                    Character c = new Character((char)Integer.decode(stringTokenizer.nextToken()).shortValue());
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.trace("Decoded 0x" + Integer.toHexString(s.intValue()) + " to 0x" + Integer.toHexString(c.charValue()));
                    }
                    hashMap.put(s, c);
                }
            }
            catch (IOException iOException) {
                slf4jlogger.error("", iOException);
            }
        }
        slf4jlogger.trace("initializeOwnMapping(): done {}", string);
        return hashMap;
    }

    private static void initializeOwnJIS0208Mapping() {
        ownJIS0208Mapping = SpecificCharacterSet.initializeOwnMapping("JIS0208Mapping.dat");
    }

    public static String getSuitableEncodingFromSetOfUnicodeBlocks(Set set) {
        String string = "UTF8";
        if (set == null) {
            string = "ASCII";
        } else {
            int n = set.size();
            slf4jlogger.trace("getSuitableEncodingFromSetOfUnicodeBlocks(): setOfUnicodeBlocks.size()={}", n);
            if (n == 0) {
                string = "ASCII";
            } else if (n > 2) {
                string = "UTF8";
            } else if (n == 1) {
                if (set.contains(Character.UnicodeBlock.BASIC_LATIN)) {
                    string = "ASCII";
                } else if (set.contains(Character.UnicodeBlock.LATIN_1_SUPPLEMENT)) {
                    string = "ISO8859_1";
                } else if (set.contains(Character.UnicodeBlock.CYRILLIC)) {
                    string = "ISO8859_5";
                } else if (set.contains(Character.UnicodeBlock.ARABIC)) {
                    string = "ISO8859_6";
                } else if (set.contains(Character.UnicodeBlock.GREEK)) {
                    string = "ISO8859_7";
                }
            } else if (n == 2 && set.contains(Character.UnicodeBlock.BASIC_LATIN)) {
                if (set.contains(Character.UnicodeBlock.LATIN_1_SUPPLEMENT)) {
                    string = "ISO8859_1";
                } else if (set.contains(Character.UnicodeBlock.CYRILLIC)) {
                    string = "ISO8859_5";
                } else if (set.contains(Character.UnicodeBlock.ARABIC)) {
                    string = "ISO8859_6";
                } else if (set.contains(Character.UnicodeBlock.GREEK)) {
                    string = "ISO8859_7";
                }
            }
        }
        slf4jlogger.trace("getSuitableEncodingFromSetOfUnicodeBlocks(): encoding={}", string);
        return string;
    }

    public static Set getSetOfUnicodeBlocksUsedBy(String string) {
        HashSet<Character.UnicodeBlock> hashSet = new HashSet<Character.UnicodeBlock>();
        if (string != null && string.length() > 0) {
            slf4jlogger.trace("getSetOfUnicodeBlocksUsedBy(): value={}", string);
            int n = string.length();
            char[] cArray = new char[n];
            string.getChars(0, n, cArray, 0);
            for (int i = 0; i < string.length(); ++i) {
                char c = cArray[i];
                Character.UnicodeBlock unicodeBlock = Character.UnicodeBlock.of(c);
                slf4jlogger.trace("getSetOfUnicodeBlocksUsedBy(): - character <{}> block = {}", Character.valueOf(c), unicodeBlock);
                hashSet.add(unicodeBlock);
            }
        }
        return hashSet;
    }

    public static Set getSetOfUnicodeBlocksUsedBy(AttributeList attributeList) {
        HashSet hashSet = new HashSet();
        if (attributeList != null) {
            for (Attribute attribute : attributeList.values()) {
                Object object;
                String[] stringArray;
                if (attribute == null) continue;
                if (attribute instanceof SequenceAttribute) {
                    stringArray = ((SequenceAttribute)attribute).iterator();
                    while (stringArray.hasNext()) {
                        SequenceItem sequenceItem = (SequenceItem)stringArray.next();
                        if (sequenceItem == null || (object = sequenceItem.getAttributeList()) == null) continue;
                        hashSet.addAll(SpecificCharacterSet.getSetOfUnicodeBlocksUsedBy((AttributeList)object));
                    }
                    continue;
                }
                if (!(attribute instanceof StringAttributeAffectedBySpecificCharacterSet)) continue;
                try {
                    stringArray = attribute.getStringValues();
                    if (stringArray == null) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        object = stringArray[i];
                        if (object == null) continue;
                        hashSet.addAll(SpecificCharacterSet.getSetOfUnicodeBlocksUsedBy((String)object));
                    }
                }
                catch (DicomException dicomException) {
                    slf4jlogger.error("", dicomException);
                }
            }
        }
        return hashSet;
    }

    public SpecificCharacterSet(AttributeList attributeList) {
        this(SpecificCharacterSet.getSetOfUnicodeBlocksUsedBy(attributeList));
    }

    public SpecificCharacterSet(Set set) {
        this.useEncoding = SpecificCharacterSet.getSuitableEncodingFromSetOfUnicodeBlocks(set);
        this.useISO2022 = false;
    }

    public SpecificCharacterSet(String[] stringArray) {
        this(stringArray, null);
    }

    public SpecificCharacterSet(String[] stringArray, byte[] byArray) {
        this.useEncoding = null;
        this.useISO2022 = false;
        if (!useOwnJISCheckPerformed) {
            useOwnJIS = !this.testIfNativeJISWorking();
            slf4jlogger.trace("SpecificCharacterSet(): useOwnJIS={}", useOwnJIS);
            useOwnJISCheckPerformed = true;
        }
        if (stringArray != null && stringArray.length >= 1) {
            String string = stringArray[0];
            slf4jlogger.trace("SpecificCharacterSet(): firstValue={}", string);
            if (string == null || string.equals("")) {
                this.useEncoding = "ASCII";
            } else if (string.equals("ISO_IR 100")) {
                this.useEncoding = "ISO8859_1";
            } else if (string.equals("ISO_IR 101")) {
                this.useEncoding = "ISO8859_2";
            } else if (string.equals("ISO_IR 109")) {
                this.useEncoding = "ISO8859_3";
            } else if (string.equals("ISO_IR 110")) {
                this.useEncoding = "ISO8859_4";
            } else if (string.equals("ISO_IR 144")) {
                this.useEncoding = "ISO8859_5";
            } else if (string.equals("ISO_IR 127")) {
                this.useEncoding = "ISO8859_6";
            } else if (string.equals("ISO_IR 126")) {
                this.useEncoding = "ISO8859_7";
            } else if (string.equals("ISO_IR 138")) {
                this.useEncoding = "ISO8859_8";
            } else if (string.equals("ISO_IR 148")) {
                this.useEncoding = "ISO8859_9";
            } else if (string.equals("ISO_IR 166")) {
                this.useEncoding = "TIS620";
            } else if (string.equals("ISO_IR 192")) {
                this.useEncoding = "UTF8";
            } else if (string.equals("ISO_IR 6")) {
                this.useEncoding = "ASCII";
            } else if (string.equals("GB18030")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("GBK")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("GB2312")) {
                this.useEncoding = "GB18030";
            } else if (string.equals("ISO_IR 13")) {
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 6")) {
                this.useISO2022 = true;
                this.useEncoding = "ASCII";
            } else if (string.equals("ISO 2022 IR 100")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_1";
            } else if (string.equals("ISO 2022 IR 101")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_2";
            } else if (string.equals("ISO 2022 IR 109")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_3";
            } else if (string.equals("ISO 2022 IR 110")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_4";
            } else if (string.equals("ISO 2022 IR 144")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_5";
            } else if (string.equals("ISO 2022 IR 127")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_6";
            } else if (string.equals("ISO 2022 IR 126")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_7";
            } else if (string.equals("ISO 2022 IR 138")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_8";
            } else if (string.equals("ISO 2022 IR 148")) {
                this.useISO2022 = true;
                this.useEncoding = "ISO8859_9";
            } else if (string.equals("ISO 2022 IR 13")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 166")) {
                this.useISO2022 = true;
                this.useEncoding = "TIS620";
            } else if (string.equals("ISO 2022 IR 87")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0201";
            } else if (string.equals("ISO 2022 IR 159")) {
                this.useISO2022 = true;
                this.useEncoding = "JIS0212";
            } else if (string.equals("ISO 2022 IR 149")) {
                this.useISO2022 = true;
                this.useEncoding = "Cp949";
            } else {
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("Check for big5 - specific character set as bytes: {}", HexDump.dump(byArray));
                }
                if (byArray != null && byArray.length == 4 && (byArray[0] & 0xFF) == 255 && (byArray[1] & 0xFF) == 190 && (byArray[2] & 0xFF) == 221 && (byArray[3] & 0xFF) == 168) {
                    slf4jlogger.error("encountered non-standard illegal encoding of Big5 Specific Character Set");
                    this.useEncoding = "Big5";
                } else {
                    if (slf4jlogger.isTraceEnabled()) {
                        slf4jlogger.warn("unrecognized first value of Specific Character Set, using ASCII; first value ={} ({})", string, HexDump.dump(byArray));
                    }
                    this.useEncoding = "ASCII";
                }
            }
            for (int i = 1; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || !string2.startsWith("ISO 2022")) continue;
                this.useISO2022 = true;
            }
        } else {
            this.useEncoding = "ASCII";
        }
        slf4jlogger.trace("SpecificCharacterSet(): useEncoding={}", this.useEncoding);
    }

    public String getValueToUseInSpecificCharacterSetAttribute() {
        slf4jlogger.trace("getValueToUseInSpecificCharacterSetAttribute(): useEncoding={}", this.useEncoding);
        String string = "ISO_IR 192";
        if (!this.useISO2022) {
            if (this.useEncoding.equals("ASCII")) {
                string = "";
            } else if (this.useEncoding.equals("ISO8859_1")) {
                string = "ISO_IR 100";
            } else if (this.useEncoding.equals("ISO8859_2")) {
                string = "ISO_IR 101";
            } else if (this.useEncoding.equals("ISO8859_3")) {
                string = "ISO_IR 109";
            } else if (this.useEncoding.equals("ISO8859_4")) {
                string = "ISO_IR 110";
            } else if (this.useEncoding.equals("ISO8859_5")) {
                string = "ISO_IR 144";
            } else if (this.useEncoding.equals("ISO8859_6")) {
                string = "ISO_IR 127";
            } else if (this.useEncoding.equals("ISO8859_7")) {
                string = "ISO_IR 126";
            } else if (this.useEncoding.equals("ISO8859_8")) {
                string = "ISO_IR 138";
            } else if (this.useEncoding.equals("ISO8859_9")) {
                string = "ISO_IR 148";
            } else if (this.useEncoding.equals("TIS620")) {
                string = "ISO_IR 166";
            } else if (this.useEncoding.equals("UTF8")) {
                string = "ISO_IR 192";
            } else if (this.useEncoding.equals("GB18030")) {
                string = "GB18030";
            } else if (this.useEncoding.equals("JIS0201")) {
                string = "ISO_IR 13";
            }
        }
        slf4jlogger.trace("getValueToUseInSpecificCharacterSetAttribute(): return value={}", string);
        return string;
    }

    private String translateByteArrayToString(byte[] byArray, int n, int n2, HashMap hashMap) {
        String string = null;
        if (hashMap != null) {
            StringBuffer stringBuffer = new StringBuffer(n2 / 2);
            int n3 = n;
            while (n3 < n + n2) {
                short s = (short)((short)byArray[n3++] & 0xFF);
                short s2 = (short)((short)byArray[n3++] & 0xFF);
                short s3 = (short)(s << 8 | s2);
                Character c = (Character)hashMap.get(new Short(s3));
                if (slf4jlogger.isTraceEnabled()) {
                    slf4jlogger.trace("translateByteArrayToString(): Mapped from 0x{} to {}", Integer.toHexString(s3), c);
                }
                if (c == null) continue;
                stringBuffer.append(c.charValue());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private String translateByteArrayToString(byte[] byArray, int n, int n2, String string) {
        slf4jlogger.trace("translateByteArrayToString() useEncoding={} offset={} length={}", string, n, n2);
        String string2 = null;
        if (n2 > 0 && useOwnJIS && string.equals("JIS0208")) {
            slf4jlogger.trace("translateByteArrayToString() using own JIS0208");
            if (ownJIS0208Mapping == null) {
                SpecificCharacterSet.initializeOwnJIS0208Mapping();
            }
            string2 = this.translateByteArrayToString(byArray, n, n2, ownJIS0208Mapping);
        } else {
            try {
                string2 = string.equals("ASCII") && SpecificCharacterSet.byteArrayContainsNonASCIIValues(byArray, n, n2) ? new String(byArray, n, n2, "ISO8859_1") : new String(byArray, n, n2, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                slf4jlogger.error("", unsupportedEncodingException);
                string2 = new String(byArray, n, n2);
            }
        }
        return string2;
    }

    public String translateByteArrayToString(byte[] byArray, int n, int n2) {
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("translateByteArrayToString():  byte array is:\n{}", HexDump.dump(byArray));
        }
        slf4jlogger.trace("translateStringToByteArray(): useEncoding is {}", this.useEncoding);
        String string = null;
        if (this.useEncoding == null) {
            string = new String(byArray, 0, n2);
        } else if (this.useISO2022) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            String string2 = this.useEncoding;
            while (n3 < n2) {
                slf4jlogger.trace("translateByteArrayToString() looping startlast={} done={}", n4, n3);
                if (byArray[n3] == 27) {
                    slf4jlogger.trace("translateByteArrayToString() escape character");
                    if (n3 > n4) {
                        stringBuffer.append(this.translateByteArrayToString(byArray, n4, n3 - n4, string2));
                    }
                    if (byArray[n3 + 1] == 40 && byArray[n3 + 2] == 66) {
                        string2 = "ASCII";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 65) {
                        string2 = "ISO8859_1";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 66) {
                        string2 = "ISO8859_2";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 67) {
                        string2 = "ISO8859_3";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 68) {
                        string2 = "ISO8859_4";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 76) {
                        string2 = "ISO8859_5";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 71) {
                        string2 = "ISO8859_6";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 70) {
                        string2 = "ISO8859_7";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 72) {
                        string2 = "ISO8859_8";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 77) {
                        string2 = "ISO8859_9";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 45 && byArray[n3 + 2] == 84) {
                        string2 = "TIS620";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 41 && byArray[n3 + 2] == 73) {
                        string2 = "JIS0201";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 40 && byArray[n3 + 2] == 74) {
                        string2 = "JIS0201";
                        n5 = 1;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 66) {
                        string2 = "JIS0208";
                        n5 = 2;
                        n3 += 3;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 41 && byArray[n3 + 3] == 65) {
                        string2 = "GBK";
                        n5 = 2;
                        n3 += 4;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 40 && byArray[n3 + 3] == 68) {
                        string2 = "JIS0212";
                        n5 = 2;
                        n3 += 4;
                    } else if (byArray[n3 + 1] == 36 && byArray[n3 + 2] == 41 && byArray[n3 + 3] == 67) {
                        string2 = "Cp949";
                        n5 = -1;
                        n3 += 4;
                    } else {
                        n3 += 3;
                    }
                    n4 = n3;
                    continue;
                }
                n3 += n5 == -1 ? ((byArray[n3] & 0x80) == 1 ? 2 : 1) : n5;
            }
            if (n3 > n4) {
                stringBuffer.append(this.translateByteArrayToString(byArray, n4, n3 - n4, string2));
            }
            string = stringBuffer.toString();
        } else {
            string = this.translateByteArrayToString(byArray, 0, n2, this.useEncoding);
        }
        slf4jlogger.trace("translateByteArrayToString(): result string is <{}>", string);
        slf4jlogger.trace("translateByteArrayToString(): result string is:\n{}", StringUtilities.dump(string));
        return string;
    }

    public byte[] translateStringToByteArray(String string) throws UnsupportedEncodingException {
        byte[] byArray;
        slf4jlogger.trace("translateStringToByteArray(): string is <{}>", string);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("translateStringToByteArray(): string is:\n{}", StringUtilities.dump(string));
        }
        slf4jlogger.trace("translateStringToByteArray(): useEncoding is {}", this.useEncoding);
        byte[] byArray2 = byArray = this.useEncoding == null ? string.getBytes() : string.getBytes(this.useEncoding);
        if (slf4jlogger.isTraceEnabled()) {
            slf4jlogger.trace("translateStringToByteArray(): return byte array is:\n{}", HexDump.dump(byArray));
        }
        return byArray;
    }

    private static void createDicomFileWithPatientName(String string, byte[] byArray, String string2) {
        slf4jlogger.trace("createDicomFileWithPatientName(): fileName {}", string);
        try {
            BinaryOutputStream binaryOutputStream = new BinaryOutputStream(new FileOutputStream(string), false);
            Object object = TagFromName.SpecificCharacterSet;
            binaryOutputStream.writeUnsigned16(((AttributeTag)object).getGroup());
            binaryOutputStream.writeUnsigned16(((AttributeTag)object).getElement());
            binaryOutputStream.write(67);
            binaryOutputStream.write(83);
            object = string2.getBytes("ASCII");
            int n = ((Object)object).length;
            boolean bl = false;
            if (n % 2 != 0) {
                ++n;
                bl = true;
            }
            binaryOutputStream.writeUnsigned16(n);
            binaryOutputStream.write((byte[])object);
            if (bl) {
                binaryOutputStream.write(32);
            }
            AttributeTag attributeTag = TagFromName.PatientName;
            binaryOutputStream.writeUnsigned16(attributeTag.getGroup());
            binaryOutputStream.writeUnsigned16(attributeTag.getElement());
            binaryOutputStream.write(80);
            binaryOutputStream.write(78);
            n = byArray.length;
            bl = false;
            if (n % 2 != 0) {
                ++n;
                bl = true;
            }
            binaryOutputStream.writeUnsigned16(n);
            binaryOutputStream.write(byArray);
            if (bl) {
                binaryOutputStream.write(32);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public static void main(String[] stringArray) {
        byte[] byArray;
        Object object;
        byte[] byArray2 = new byte[]{89, 97, 109, 97, 100, 97, 94, 84, 97, 114, 111, 117, 61, 27, 36, 66, 59, 51, 69, 68, 27, 40, 66, 94, 27, 36, 66, 66, 64, 79, 58, 27, 40, 66, 61, 27, 36, 66, 36, 100, 36, 94, 36, 64, 27, 40, 66, 94, 27, 36, 66, 36, 63, 36, 109, 36, 38, 27, 40, 66};
        String string = "\\ISO 2022 IR 87";
        byte[] byArray3 = new byte[]{-44, -49, -64, -34, 94, -64, -37, -77, 61, 27, 36, 66, 59, 51, 69, 68, 27, 40, 74, 94, 27, 36, 66, 66, 64, 79, 58, 27, 40, 74, 61, 27, 36, 66, 36, 100, 36, 94, 36, 64, 27, 40, 74, 94, 27, 36, 66, 36, 63, 36, 109, 36, 38, 27, 40, 74};
        String string2 = "ISO 2022 IR 13\\ISO 2022 IR 87";
        byte[] byArray4 = new byte[]{72, 111, 110, 103, 94, 71, 105, 108, 100, 111, 110, 103, 61, 27, 36, 41, 67, -5, -13, 94, 27, 36, 41, 67, -47, -50, -44, -41, 61, 27, 36, 41, 67, -56, -85, 94, 27, 36, 41, 67, -79, -26, -75, -65};
        String string3 = "\\ISO 2022 IR 149";
        byte[] byArray5 = new byte[]{87, 97, 110, 103, 94, 88, 105, 97, 111, 68, 111, 110, 103, 61, -25, -114, -117, 94, -27, -80, -113, -26, -99, -79, 61};
        String string4 = "ISO_IR 192";
        byte[] byArray6 = new byte[]{87, 97, 110, 103, 94, 88, 105, 97, 111, 68, 111, 110, 103, 61, -51, -11, 94, -48, -95, -74, -85, 61};
        String string5 = "GB18030";
        String string6 = stringArray.length > 0 && stringArray[0] != null ? stringArray[0] + "/" : "";
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "h31example.dcm", byArray2, string);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "h32example.dcm", byArray3, string2);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "i2example.dcm", byArray4, string3);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "x1example.dcm", byArray5, string4);
        SpecificCharacterSet.createDicomFileWithPatientName(string6 + "x2example.dcm", byArray6, string5);
        try {
            object = "\u0394\u03b9\u03bf\u03bd\u03c5\u03c3\u03b9\u03bf\u03c2";
            byArray = ((String)object).getBytes("ISO8859_7");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "greek.dcm", byArray, "ISO_IR 126");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = "Buc^J\u00e9r\u00f4me";
            byArray = ((String)object).getBytes("ISO8859_1");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "french.dcm", byArray, "ISO_IR 100");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = "\u00c4neas^R\u00fcdiger";
            byArray = ((String)object).getBytes("ISO8859_1");
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "german.dcm", byArray, "ISO_IR 100");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-30, -56, -57, -26, -22, 94, -28, -26, -46, -57, -47};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "arabic.dcm", (byte[])object, "ISO_IR 127");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-69, -18, -38, 99, 101, -36, -47, 121, 112, -45};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "russian.dcm", (byte[])object, "ISO_IR 144");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        try {
            object = new byte[]{-7, -8, -27, -17, 94, -29, -31, -27, -8, -28};
            SpecificCharacterSet.createDicomFileWithPatientName(string6 + "hebrew.dcm", (byte[])object, "ISO_IR 138");
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

