/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.ContentItemFactory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SpatialCoordinateAndImageReference;
import com.pixelmed.dicom.TagFromName;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class StructuredReport
implements TreeModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/StructuredReport.java,v 1.31 2025/01/29 10:58:07 dclunie Exp $";
    private ContentItem root;
    private Vector listeners;
    private ContentItemFactory nodeFactory;

    @Override
    public Object getChild(Object object, int n) {
        return ((ContentItem)object).getChildAt(n);
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return ((ContentItem)object).getIndex((ContentItem)object2);
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public int getChildCount(Object object) {
        return ((ContentItem)object).getChildCount();
    }

    @Override
    public boolean isLeaf(Object object) {
        return ((ContentItem)object).getChildCount() == 0;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        if (this.listeners == null) {
            this.listeners.removeElement(treeModelListener);
        }
    }

    private ContentItem processSubTree(ContentItem contentItem, AttributeList attributeList) throws DicomException {
        SequenceAttribute sequenceAttribute;
        ContentItem contentItem2 = this.nodeFactory.getNewContentItem(contentItem, attributeList);
        if (attributeList != null && (sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.ContentSequence)) != null) {
            Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
            while (iterator.hasNext()) {
                SequenceItem sequenceItem = iterator.next();
                this.processSubTree(contentItem2, sequenceItem == null ? null : sequenceItem.getAttributeList());
            }
        }
        return contentItem2;
    }

    public StructuredReport(AttributeList attributeList) throws DicomException {
        this.nodeFactory = new ContentItemFactory();
        this.root = this.processSubTree(null, attributeList);
        this.nodeFactory = null;
    }

    public StructuredReport(ContentItem contentItem) throws DicomException {
        this.root = contentItem;
        this.nodeFactory = null;
    }

    private void walkTreeAddingContentSequenceToChildAttributeLists(AttributeList attributeList, ContentItem contentItem) {
        attributeList.remove(TagFromName.ContentSequence);
        int n = this.getChildCount(contentItem);
        if (n > 0) {
            SequenceAttribute sequenceAttribute = new SequenceAttribute(TagFromName.ContentSequence);
            attributeList.put(sequenceAttribute);
            for (int i = 0; i < n; ++i) {
                ContentItem contentItem2 = (ContentItem)this.getChild(contentItem, i);
                AttributeList attributeList2 = contentItem2.getAttributeList();
                sequenceAttribute.addItem(attributeList2);
                this.walkTreeAddingContentSequenceToChildAttributeLists(attributeList2, contentItem2);
            }
        }
    }

    public AttributeList getAttributeList() {
        AttributeList attributeList = null;
        if (this.root != null) {
            attributeList = this.root.getAttributeList();
            this.walkTreeAddingContentSequenceToChildAttributeLists(attributeList, this.root);
        }
        return attributeList;
    }

    public static String walkTreeBuldingString(ContentItem contentItem, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(contentItem.toString());
        stringBuffer.append("\n");
        int n = contentItem.getChildCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(StructuredReport.walkTreeBuldingString((ContentItem)contentItem.getChildAt(i), string + "." + Integer.toString(i + 1)));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return StructuredReport.walkTreeBuldingString(this.root, "1");
    }

    public static Vector findAllContainedSOPInstances(ContentItem contentItem, ContentItem contentItem2) {
        Object object;
        Object object2;
        Vector<SpatialCoordinateAndImageReference> vector = new Vector<SpatialCoordinateAndImageReference>();
        String string = contentItem2.getReferencedSOPInstanceUID();
        String string2 = contentItem2.getReferencedSOPClassUID();
        if (string == null && (object2 = contentItem2.getReferencedContentItemIdentifierArray()) != null && ((int[])object2).length > 0) {
            object = contentItem;
            if (((int[])object2).length > 1) {
                for (int i = 1; i < ((int[])object2).length; ++i) {
                    Object object3 = object2[i];
                    if (object == null || object3 <= 0 || object3 > ((ContentItem)object).getChildCount()) {
                        object = null;
                        break;
                    }
                    object = (ContentItem)((ContentItem)object).getChildAt((int)(object3 - true));
                }
                if (object != null) {
                    string = ((ContentItem)object).getReferencedSOPInstanceUID();
                    string2 = ((ContentItem)object).getReferencedSOPClassUID();
                }
            }
        }
        if (string != null) {
            object2 = contentItem2.getParentAsContentItem();
            object = null;
            float[] fArray = null;
            String string3 = null;
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            if (object2 != null) {
                object = ((ContentItem)object2).getGraphicType();
                fArray = ((ContentItem)object2).getGraphicData();
                if (object != null) {
                    object2 = ((ContentItem)object2).getParentAsContentItem();
                }
                if (object2 != null) {
                    String string4;
                    Object object4;
                    Object object5;
                    string3 = ((ContentItem)object2).getConceptNameAndValue();
                    Object object6 = ((ContentItem)object2).getNamedChild("DCM", "111056");
                    if (object6 != null && object6 instanceof ContentItemFactory.CodeContentItem) {
                        object5 = ((ContentItemFactory.CodeContentItem)object6).getConceptCode();
                        object4 = ((CodedSequenceItem)object5).getCodingSchemeDesignator();
                        string4 = ((CodedSequenceItem)object5).getCodeValue();
                        if (object4 != null && ((String)object4).equals("DCM") && string4 != null) {
                            n = string4.equals("111150") ? 0 : (string4.equals("111151") ? 1 : (string4.equals("111152") ? 2 : 2));
                        }
                    }
                    if (object2 instanceof ContentItemFactory.CodeContentItem) {
                        object6 = ((ContentItem)object2).getConceptNameCodingSchemeDesignator();
                        object5 = ((ContentItem)object2).getConceptNameCodeValue();
                        if (object6 != null && ((String)object6).equals("DCM") && object5 != null && ((String)object5).equals("111059")) {
                            object4 = ((ContentItemFactory.CodeContentItem)object2).getConceptCode();
                            string4 = ((CodedSequenceItem)object4).getCodingSchemeDesignator();
                            String string5 = ((CodedSequenceItem)object4).getCodeValue();
                            if (string4 != null && string4.equals("SRT") && string5 != null) {
                                if (string5.equals("F-01796")) {
                                    n2 = 3;
                                } else if (string5.equals("F-01775")) {
                                    n2 = 2;
                                } else if (string5.equals("F-01776")) {
                                    n2 = 1;
                                }
                            }
                        }
                    } else if (object2 instanceof ContentItemFactory.NumericContentItem) {
                        if ((object2 = ((ContentItem)object2).getParentAsContentItem()) != null) {
                            object6 = ((ContentItem)object2).getNamedChild("DCM", "121071");
                            if (object6 != null) {
                                string3 = ((ContentItem)object6).getConceptValue() + " " + string3;
                            }
                            if ((object6 = ((ContentItem)object2).getNamedChild("SCT", "363698007")) == null) {
                                object6 = ((ContentItem)object2).getNamedChild("SRT", "G-C0E3");
                            }
                            if (object6 != null) {
                                string3 = ((ContentItem)object6).getConceptValue() + " " + string3;
                            }
                            object6 = ((ContentItem)object2).getConceptNameCodingSchemeDesignator();
                            object5 = ((ContentItem)object2).getConceptNameCodeValue();
                            if (!(object6 == null || object5 == null || ((String)object6).equals("99RPH") && ((String)object5).equals("RP-101002") || ((String)object6).equals("DCM") && ((String)object5).equals("125007"))) {
                                string3 = ((ContentItem)object2).getConceptNameAndValue() + " " + string3;
                            }
                        }
                    } else if (object2 instanceof ContentItemFactory.ContainerContentItem) {
                        object6 = ((ContentItem)object2).getConceptNameCodingSchemeDesignator();
                        object5 = ((ContentItem)object2).getConceptNameCodeValue();
                        if (object6 != null && ((String)object6).equals("DCM") && object5 != null && ((String)object5).equals("111028")) {
                            bl = true;
                        }
                    }
                }
            }
            vector.add(new SpatialCoordinateAndImageReference(string, string2, (String)object, fArray, string3, n, n2, bl));
        }
        int n = contentItem2.getChildCount();
        for (int i = 0; i < n; ++i) {
            ContentItem contentItem3 = (ContentItem)contentItem2.getChildAt(i);
            vector.addAll(StructuredReport.findAllContainedSOPInstances(contentItem, contentItem3));
        }
        return vector;
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            attributeList.read(stringArray[0]);
            StructuredReport structuredReport = new StructuredReport(attributeList);
            System.err.println(structuredReport);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

