/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.util.Iterator;

public class TiledFramesIndex {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TiledFramesIndex.java,v 1.22 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(TiledFramesIndex.class);
    protected int[][] index;
    protected double[][] xOffsetInSlideCoordinateSystem;
    protected double[][] yOffsetInSlideCoordinateSystem;
    protected double[][] zOffsetInSlideCoordinateSystem;
    protected int numberOfColumnsOfTiles;
    protected int numberOfRowsOfTiles;
    protected int numberOfFrames;
    protected double totalPixelMatrixXOffsetInSlideCoordinateSystem;
    protected double totalPixelMatrixYOffsetInSlideCoordinateSystem;
    protected int[] rowForFrame;
    protected int[] columnForFrame;
    protected boolean isSparse;
    protected boolean isSparseHasBeenTested;
    protected boolean isEncodedInStandardRasterOrder;
    protected boolean isEncodedInStandardRasterOrderHasBeenTested;

    public int getNumberOfColumnsOfTiles() {
        return this.numberOfColumnsOfTiles;
    }

    public int getNumberOfRowsOfTiles() {
        return this.numberOfRowsOfTiles;
    }

    public int getFrameNumber(int n, int n2) {
        slf4jlogger.trace("getFrameNumber(): index[{}][{}]", n, n2);
        int n3 = this.index[n][n2];
        slf4jlogger.trace("getFrameNumber(): index[{}][{}] = {}", n, n2, n3);
        return n3;
    }

    protected void computeRowAndColumnForFrame() {
        slf4jlogger.trace("computeRowAndColumnForFrame(): numberOfRowsOfTiles = {}", this.numberOfRowsOfTiles);
        slf4jlogger.trace("computeRowAndColumnForFrame(): numberOfColumnsOfTiles = {}", this.numberOfColumnsOfTiles);
        this.rowForFrame = new int[this.numberOfRowsOfTiles * this.numberOfColumnsOfTiles];
        this.columnForFrame = new int[this.numberOfRowsOfTiles * this.numberOfColumnsOfTiles];
        for (int i = 0; i < this.numberOfRowsOfTiles; ++i) {
            int[] nArray = this.index[i];
            for (int j = 0; j < this.numberOfColumnsOfTiles; ++j) {
                int n = nArray[j] - 1;
                slf4jlogger.trace("computeRowAndColumnForFrame(): row = {}, column = {}, frame = {}", i, j, n);
                if (n >= 0 && n < this.numberOfFrames) {
                    this.rowForFrame[n] = i;
                    this.columnForFrame[n] = j;
                    continue;
                }
                slf4jlogger.warn("computeRowAndColumnForFrame(): frame {} for tile row {} column {} out of range 0 to numberOfFrames-1 ({}) - frame for that tile mist be absent from input", n, i, j, this.numberOfFrames - 1);
            }
        }
    }

    public int getRow(int n) {
        if (this.rowForFrame == null) {
            this.computeRowAndColumnForFrame();
        }
        return this.rowForFrame[n - 1];
    }

    public int getColumn(int n) {
        if (this.columnForFrame == null) {
            this.computeRowAndColumnForFrame();
        }
        return this.columnForFrame[n - 1];
    }

    public TiledFramesIndex(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3) throws DicomException {
        this(attributeList, bl, bl2, bl3, false, 0.1);
    }

    public TiledFramesIndex(AttributeList attributeList, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d) throws DicomException {
        long l = System.currentTimeMillis();
        int n = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        int n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        int n3 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixColumns, 0);
        int n4 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.TotalPixelMatrixRows, 0);
        this.numberOfFrames = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        slf4jlogger.debug("NumberOfFrames = {}", this.numberOfFrames);
        if (this.numberOfFrames == 1) {
            slf4jlogger.debug("Single frame so creating degenerate index with one entry of frame 1");
            this.index = new int[1][];
            this.index[0] = new int[1];
            this.index[0][0] = 1;
        } else {
            block46: {
                Attribute attribute;
                slf4jlogger.debug("rows = {}", n);
                slf4jlogger.debug("columns = {}", n2);
                slf4jlogger.debug("totalPixelMatrixColumns = {}", n3);
                slf4jlogger.debug("totalPixelMatrixRows = {}", n4);
                this.numberOfColumnsOfTiles = n3 / n2;
                if (n3 % n2 != 0) {
                    slf4jlogger.debug("TotalPixelMatrixColumns {} is not an exact multiple of Columns {}", n3, n2);
                    ++this.numberOfColumnsOfTiles;
                }
                slf4jlogger.debug("numberOfColumnsOfTiles = {}", this.numberOfColumnsOfTiles);
                this.numberOfRowsOfTiles = n4 / n;
                if (n4 % n != 0) {
                    slf4jlogger.debug("TotalPixelMatrixRows {} is not an exact multiple of Rows {}", n4, n);
                    ++this.numberOfRowsOfTiles;
                }
                slf4jlogger.debug("numberOfRowsOfTiles = {}", this.numberOfRowsOfTiles);
                if (bl) {
                    this.totalPixelMatrixXOffsetInSlideCoordinateSystem = Double.parseDouble(SequenceAttribute.getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(attributeList, TagFromName.TotalPixelMatrixOriginSequence, TagFromName.XOffsetInSlideCoordinateSystem, "0"));
                    this.totalPixelMatrixYOffsetInSlideCoordinateSystem = Double.parseDouble(SequenceAttribute.getSingleStringValueOfNamedAttributeFromWithinSequenceWithSingleItemOrDefault(attributeList, TagFromName.TotalPixelMatrixOriginSequence, TagFromName.YOffsetInSlideCoordinateSystem, "0"));
                }
                this.index = new int[this.numberOfRowsOfTiles][];
                double[] dArray = null;
                double[] dArray2 = null;
                if (bl && bl4) {
                    SequenceAttribute sequenceAttribute;
                    dArray = Attribute.getDoubleValues(attributeList, TagFromName.ImageOrientationSlide);
                    if (dArray == null || dArray.length != 6) {
                        throw new DicomException("Cannot check physical offsets since ImageOrientationSlide missing or incorrect number of values");
                    }
                    SequenceAttribute sequenceAttribute2 = (SequenceAttribute)attributeList.get(TagFromName.SharedFunctionalGroupsSequence);
                    if (sequenceAttribute2 != null && (sequenceAttribute = (SequenceAttribute)SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute2, TagFromName.PixelMeasuresSequence)) != null && (attribute = SequenceAttribute.getNamedAttributeFromWithinSequenceWithSingleItem(sequenceAttribute, TagFromName.PixelSpacing)) != null) {
                        dArray2 = attribute.getDoubleValues();
                    }
                    if (dArray2 == null || dArray2.length != 2) {
                        throw new DicomException("Cannot check physical offsets since PixelSpacing missing or incorrect number of values");
                    }
                }
                if (!bl3) {
                    try {
                        int n5;
                        if (bl) {
                            this.xOffsetInSlideCoordinateSystem = new double[this.numberOfRowsOfTiles][];
                            this.yOffsetInSlideCoordinateSystem = new double[this.numberOfRowsOfTiles][];
                            this.zOffsetInSlideCoordinateSystem = new double[this.numberOfRowsOfTiles][];
                        }
                        for (n5 = 0; n5 < this.numberOfRowsOfTiles; ++n5) {
                            this.index[n5] = new int[this.numberOfColumnsOfTiles];
                            if (!bl) continue;
                            this.xOffsetInSlideCoordinateSystem[n5] = new double[this.numberOfColumnsOfTiles];
                            this.yOffsetInSlideCoordinateSystem[n5] = new double[this.numberOfColumnsOfTiles];
                            this.zOffsetInSlideCoordinateSystem[n5] = new double[this.numberOfColumnsOfTiles];
                        }
                        n5 = 0;
                        boolean bl5 = false;
                        attribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
                        if (attribute != null) {
                            int n6 = ((SequenceAttribute)attribute).getNumberOfItems();
                            if (n6 != this.numberOfFrames) {
                                if (n6 < this.numberOfFrames) {
                                    throw new DicomException("Number of Items in PerFrameFunctionalGroupsSequence " + n6 + " does not match (is less than) NumberOfFrames " + this.numberOfFrames);
                                }
                                slf4jlogger.warn("Number of Items in PerFrameFunctionalGroupsSequence {} does not match (is greater than) NumberOfFrames {} - ignoring", n6, this.numberOfFrames);
                            }
                            Iterator<SequenceItem> iterator = ((SequenceAttribute)attribute).iterator();
                            int n7 = 1;
                            while (iterator.hasNext()) {
                                int n8;
                                int n9;
                                int n10 = 0;
                                int n11 = 0;
                                AttributeList attributeList2 = iterator.next().getAttributeList();
                                SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList2.get(TagFromName.PlanePositionSlideSequence);
                                if (sequenceAttribute == null || sequenceAttribute.getNumberOfItems() < 1) {
                                    throw new DicomException("Missing or empty PlanePositionSlideSequence for frame " + n7);
                                }
                                AttributeList attributeList3 = sequenceAttribute.getItem(0).getAttributeList();
                                Attribute attribute2 = attributeList3.get(TagFromName.ColumnPositionInTotalImagePixelMatrix);
                                if (attribute2 == null) {
                                    throw new DicomException("Missing ColumnPositionInTotalImagePixelMatrix for frame " + n7);
                                }
                                int[] nArray = attribute2.getIntegerValues();
                                if (nArray.length > 0) {
                                    n9 = nArray[0];
                                    slf4jlogger.trace("Frame {} have vColumnPositionInTotalImagePixelMatrix = {}", n7, n9);
                                    n8 = n9 % n2;
                                    if (n8 == 0) {
                                        if (n5 == 0) {
                                            slf4jlogger.warn("ColumnPositionInTotalImagePixelMatrix is using an origin of zero not one as required");
                                            n5 = 1;
                                        }
                                        n10 = n9 / n2;
                                    } else if (n8 == 1) {
                                        n10 = n9 / n2;
                                    } else {
                                        throw new DicomException("Frame " + n7 + " has ColumnPositionInTotalImagePixelMatrix " + n9 + " that is not a multiple of columns " + n2 + " plus 1");
                                    }
                                    slf4jlogger.trace("Frame {} have vTileColumn = {}", n7, n10);
                                    if (n10 >= this.numberOfColumnsOfTiles) {
                                        throw new DicomException("Frame " + n7 + " has ColumnPositionInTotalImagePixelMatrix " + n9 + " that is beyond TotalPixelMatrixColumns " + n3);
                                    }
                                }
                                if ((attribute2 = attributeList3.get(TagFromName.RowPositionInTotalImagePixelMatrix)) == null) {
                                    throw new DicomException("Missing RowPositionInTotalImagePixelMatrix for frame " + n7);
                                }
                                nArray = attribute2.getIntegerValues();
                                if (nArray.length > 0) {
                                    n9 = nArray[0];
                                    slf4jlogger.trace("Frame {} have vRowPositionInTotalImagePixelMatrix = {}", n7, n9);
                                    n8 = n9 % n;
                                    if (n8 == 0) {
                                        if (!bl5) {
                                            slf4jlogger.warn("RowPositionInTotalImagePixelMatrix is using an origin of zero not one as required");
                                            bl5 = true;
                                        }
                                        n11 = n9 / n;
                                    } else if (n8 == 1) {
                                        n11 = n9 / n;
                                    } else {
                                        throw new DicomException("Frame " + n7 + " has RowPositionInTotalImagePixelMatrix " + n9 + " that is not a multiple of rows " + n + " plus 1");
                                    }
                                    slf4jlogger.trace("Frame {} have vTileRow = {}", n7, n11);
                                    if (n11 >= this.numberOfRowsOfTiles) {
                                        throw new DicomException("Frame " + n7 + " has RowPositionInTotalImagePixelMatrix " + n9 + " that is beyond TotalPixelMatrixRows " + n4);
                                    }
                                }
                                slf4jlogger.trace("Setting index[{}][{}] = {}", n11, n10, n7);
                                this.index[n11][n10] = n7;
                                if (bl) {
                                    this.xOffsetInSlideCoordinateSystem[n11][n10] = Attribute.getSingleDoubleValueOrDefault(attributeList3, TagFromName.XOffsetInSlideCoordinateSystem, 0.0);
                                    this.yOffsetInSlideCoordinateSystem[n11][n10] = Attribute.getSingleDoubleValueOrDefault(attributeList3, TagFromName.YOffsetInSlideCoordinateSystem, 0.0);
                                    this.zOffsetInSlideCoordinateSystem[n11][n10] = Attribute.getSingleDoubleValueOrDefault(attributeList3, TagFromName.ZOffsetInSlideCoordinateSystem, 0.0);
                                    slf4jlogger.trace("Frame {} XOffsetInSlideCoordinateSystem = {}", n7, this.xOffsetInSlideCoordinateSystem[n11][n10]);
                                    slf4jlogger.trace("Frame {} YOffsetInSlideCoordinateSystem = {}", n7, this.yOffsetInSlideCoordinateSystem[n11][n10]);
                                    slf4jlogger.trace("Frame {} ZOffsetInSlideCoordinateSystem = {}", n7, this.zOffsetInSlideCoordinateSystem[n11][n10]);
                                    if (bl4) {
                                        double d2 = this.totalPixelMatrixXOffsetInSlideCoordinateSystem + dArray[0] * dArray2[1] * (double)n2 * (double)n10 + dArray[3] * dArray2[0] * (double)n * (double)n11;
                                        double d3 = Math.abs(this.xOffsetInSlideCoordinateSystem[n11][n10] - d2);
                                        double d4 = d3 / dArray2[0];
                                        slf4jlogger.trace("Frame {} XOffsetInSlideCoordinateSystem expected = {}", n7, d2);
                                        slf4jlogger.trace("Frame {} XOffsetInSlideCoordinateSystem difference = {}", n7, d3);
                                        slf4jlogger.trace("Frame {} XOffsetInSlideCoordinateSystem spacing scaled difference = {}", n7, d4);
                                        if (d4 > d) {
                                            slf4jlogger.warn("Frame {} XOffsetInSlideCoordinateSystem - got {} more than {}% PixelSpacing different from expected {}", n7, this.xOffsetInSlideCoordinateSystem[n11][n10], d * 100.0, d2);
                                        }
                                        d2 = this.totalPixelMatrixYOffsetInSlideCoordinateSystem + dArray[1] * dArray2[1] * (double)n2 * (double)n10 + dArray[4] * dArray2[0] * (double)n * (double)n11;
                                        d3 = Math.abs(this.yOffsetInSlideCoordinateSystem[n11][n10] - d2);
                                        d4 = d3 / dArray2[0];
                                        slf4jlogger.trace("Frame {} YOffsetInSlideCoordinateSystem expected = {}", n7, d2);
                                        slf4jlogger.trace("Frame {} YOffsetInSlideCoordinateSystem difference = {}", n7, d3);
                                        slf4jlogger.trace("Frame {} YOffsetInSlideCoordinateSystem spacing scaled difference = {}", n7, d4);
                                        if (d4 > d) {
                                            slf4jlogger.warn("Frame {} YOffsetInSlideCoordinateSystem - got {} more than {}% PixelSpacing different from expected {}", n7, this.yOffsetInSlideCoordinateSystem[n11][n10], d * 100.0, d2);
                                        }
                                    }
                                }
                                ++n7;
                            }
                            break block46;
                        }
                        String string = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.DimensionOrganizationType);
                        if (string.equals("TILED_FULL")) {
                            slf4jlogger.debug("DimensionOrganizationType is TILED_FULL so missing PerFrameFunctionalGroupsSequence is OK and assuming raster scan order for tiles");
                            bl3 = true;
                            break block46;
                        }
                        throw new DicomException("Missing PerFrameFunctionalGroupsSequence");
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to construct tile index from PerFrameFunctionalGroupsSequence information - assuming raster scan order for tiles: ", exception);
                        bl3 = true;
                    }
                } else {
                    slf4jlogger.debug("Asked to ignore PlanePositionSequence and assume raster scan order for tiles");
                }
            }
            if (bl3) {
                slf4jlogger.debug("Assuming raster scan order for tiles");
                int n12 = 0;
                for (int i = 0; i < this.numberOfRowsOfTiles; ++i) {
                    this.index[i] = new int[this.numberOfColumnsOfTiles];
                    for (int j = 0; j < this.numberOfColumnsOfTiles; ++j) {
                        this.index[i][j] = ++n12;
                    }
                }
                if (n12 != this.numberOfFrames) {
                    slf4jlogger.debug("last frame {} after assuming raster scan order for tiles is != numberOfFrames {}", n12, this.numberOfFrames);
                }
            }
        }
        slf4jlogger.debug("Forward index - done in {} ms", System.currentTimeMillis() - l);
        if (bl2) {
            long l2 = System.currentTimeMillis();
            this.computeRowAndColumnForFrame();
            slf4jlogger.debug("Inverse index - done in {} ms", System.currentTimeMillis() - l2);
        }
    }

    public TiledFramesIndex(AttributeList attributeList) throws DicomException {
        this(attributeList, false, false, false);
    }

    public boolean isSparse() {
        if (!this.isSparseHasBeenTested) {
            this.isSparse = false;
            for (int i = 0; i < this.numberOfRowsOfTiles && !this.isSparse; ++i) {
                int[] nArray = this.index[i];
                for (int j = 0; j < this.numberOfColumnsOfTiles && !this.isSparse; ++j) {
                    if (nArray[j] != 0) continue;
                    this.isSparse = true;
                }
            }
            this.isSparseHasBeenTested = true;
        }
        return this.isSparse;
    }

    public boolean isEncodedInStandardRasterOrder() {
        if (!this.isEncodedInStandardRasterOrderHasBeenTested) {
            int n = 1;
            this.isEncodedInStandardRasterOrder = true;
            for (int i = 0; i < this.numberOfRowsOfTiles && this.isEncodedInStandardRasterOrder; ++i) {
                int[] nArray = this.index[i];
                for (int j = 0; j < this.numberOfColumnsOfTiles && this.isEncodedInStandardRasterOrder; ++j) {
                    if (nArray[j] != n) {
                        this.isEncodedInStandardRasterOrder = false;
                    }
                    ++n;
                }
            }
            this.isEncodedInStandardRasterOrderHasBeenTested = true;
        }
        return this.isEncodedInStandardRasterOrder;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numberOfRowsOfTiles; ++i) {
            int[] nArray = this.index[i];
            for (int j = 0; j < this.numberOfColumnsOfTiles; ++j) {
                stringBuffer.append("tile[" + i + "," + j + "] = frame " + nArray[j]);
                if (this.xOffsetInSlideCoordinateSystem != null) {
                    stringBuffer.append(" (" + this.xOffsetInSlideCoordinateSystem[i][j] + "," + this.yOffsetInSlideCoordinateSystem[i][j] + "," + this.zOffsetInSlideCoordinateSystem[i][j] + ") mm");
                }
                stringBuffer.append("\n");
            }
        }
        if (this.xOffsetInSlideCoordinateSystem != null) {
            stringBuffer.append("totalPixelMatrix OffsetInSlideCoordinateSystem = (" + this.totalPixelMatrixXOffsetInSlideCoordinateSystem + "," + this.totalPixelMatrixYOffsetInSlideCoordinateSystem + ")\n");
        }
        stringBuffer.append("isSparse() = " + this.isSparse() + "\n");
        stringBuffer.append("isEncodedInStandardRasterOrder() = " + this.isEncodedInStandardRasterOrder() + "\n");
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            AttributeList attributeList = new AttributeList();
            long l = System.currentTimeMillis();
            attributeList.setDecompressPixelData(false);
            attributeList.read(stringArray[0]);
            slf4jlogger.info("main(): read - done in " + (System.currentTimeMillis() - l) + " ms");
            long l2 = System.currentTimeMillis();
            TiledFramesIndex tiledFramesIndex = new TiledFramesIndex(attributeList, true, false, false, true, 0.1);
            slf4jlogger.info("main():  index - done in " + (System.currentTimeMillis() - l2) + " ms");
            System.err.print(tiledFramesIndex);
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }
}

