/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;

public class TimeAttribute
extends StringAttribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TimeAttribute.java,v 1.23 2025/01/29 10:58:07 dclunie Exp $";
    protected static final int MAX_LENGTH_SINGLE_VALUE = 14;

    @Override
    public final int getMaximumLengthOfSingleValue() {
        return 14;
    }

    public TimeAttribute(AttributeTag attributeTag) {
        super(attributeTag);
    }

    public TimeAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, l, dicomInputStream);
    }

    public TimeAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag, (long)l, dicomInputStream);
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.TM;
    }

    @Override
    protected final boolean allowRepairOfIncorrectLength() {
        return false;
    }

    @Override
    protected final boolean allowRepairOfInvalidCharacterReplacement() {
        return true;
    }

    @Override
    protected char getInvalidCharacterReplacement() {
        return '\u0000';
    }

    @Override
    public final boolean isCharacterInValueValid(int n) throws DicomException {
        return n < 127 && (Character.isDigit(n) || n == 46 || n == 32);
    }

    @Override
    public boolean areValuesWellFormed() throws DicomException {
        boolean bl = true;
        if (this.originalValues != null && this.originalValues.length > 0) {
            for (int i = 0; i < this.originalValues.length; ++i) {
                String string = this.originalValues[i];
                if (string == null || string.length() <= 0 || string.length() >= 2) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

