/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import java.util.HashMap;
import java.util.Map;

public class TransferSyntaxFromName {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/TransferSyntaxFromName.java,v 1.16 2025/01/29 10:58:07 dclunie Exp $";
    protected static Map<String, String> uidByKeyword = new HashMap<String, String>();
    protected static Map<String, String> keywordByUID;

    private TransferSyntaxFromName() {
    }

    public static String getUID(String string) {
        String string2 = null;
        if (string != null && (string2 = uidByKeyword.get(string)) == null && string.matches("[0-9.][0-9.]*")) {
            string2 = string;
        }
        return string2;
    }

    public static String getKeywordFromUID(String string) {
        String string2 = keywordByUID.get(string);
        return string2 == null ? "" : string2;
    }

    public static void main(String[] stringArray) {
        System.err.println("Default from name: " + TransferSyntaxFromName.getUID("Default").equals("1.2.840.10008.1.2"));
        System.err.println("Default from uid : " + TransferSyntaxFromName.getUID("1.2.840.10008.1.2").equals("1.2.840.10008.1.2"));
        System.err.println("Dummy from name  : " + (TransferSyntaxFromName.getUID("Dummy") == null));
    }

    static {
        uidByKeyword.put("ImplicitVRLittleEndian", "1.2.840.10008.1.2");
        uidByKeyword.put("ExplicitVRLittleEndian", "1.2.840.10008.1.2.1");
        uidByKeyword.put("ExplicitVRBigEndian", "1.2.840.10008.1.2.2");
        uidByKeyword.put("Default", "1.2.840.10008.1.2");
        uidByKeyword.put("DeflatedExplicitVRLittleEndian", "1.2.840.10008.1.2.1.99");
        uidByKeyword.put("JPEGBaseline", "1.2.840.10008.1.2.4.50");
        uidByKeyword.put("JPEGExtended", "1.2.840.10008.1.2.4.51");
        uidByKeyword.put("JPEGLossless", "1.2.840.10008.1.2.4.57");
        uidByKeyword.put("JPEGLosslessSV1", "1.2.840.10008.1.2.4.70");
        uidByKeyword.put("JPEGLS", "1.2.840.10008.1.2.4.80");
        uidByKeyword.put("JPEGNLS", "1.2.840.10008.1.2.4.81");
        uidByKeyword.put("JPEG2000Lossless", "1.2.840.10008.1.2.4.90");
        uidByKeyword.put("JPEG2000", "1.2.840.10008.1.2.4.91");
        uidByKeyword.put("MPEG2MPML", "1.2.840.10008.1.2.4.100");
        uidByKeyword.put("MPEG2MPHL", "1.2.840.10008.1.2.4.101");
        uidByKeyword.put("MPEG4HP41", "1.2.840.10008.1.2.4.102");
        uidByKeyword.put("MPEG4HP41BD", "1.2.840.10008.1.2.4.103");
        uidByKeyword.put("MPEG4HP422D", "1.2.840.10008.1.2.4.104");
        uidByKeyword.put("MPEG4HP423D", "1.2.840.10008.1.2.4.105");
        uidByKeyword.put("MPEG4HP42ST", "1.2.840.10008.1.2.4.106");
        uidByKeyword.put("RLE", "1.2.840.10008.1.2.5");
        uidByKeyword.put("PixelMedBzip2ExplicitVRLittleEndian", "1.3.6.1.4.1.5962.300.1");
        uidByKeyword.put("PixelMedEncapsulatedRawLittleEndian", "1.3.6.1.4.1.5962.300.2");
        uidByKeyword.put("Papyrus3ImplicitVRLittleEndian", "1.2.840.10008.1.20");
        keywordByUID = new HashMap<String, String>();
        keywordByUID.put("1.2.840.10008.1.2", "ImplicitVRLittleEndian");
        keywordByUID.put("1.2.840.10008.1.2.1", "ExplicitVRLittleEndian");
        keywordByUID.put("1.2.840.10008.1.2.2", "ExplicitVRBigEndian");
        keywordByUID.put("1.2.840.10008.1.2", "Default");
        keywordByUID.put("1.2.840.10008.1.2.1.99", "DeflatedExplicitVRLittleEndian");
        keywordByUID.put("1.2.840.10008.1.2.4.50", "JPEGBaseline");
        keywordByUID.put("1.2.840.10008.1.2.4.51", "JPEGExtended");
        keywordByUID.put("1.2.840.10008.1.2.4.57", "JPEGLossless");
        keywordByUID.put("1.2.840.10008.1.2.4.70", "JPEGLosslessSV1");
        keywordByUID.put("1.2.840.10008.1.2.4.80", "JPEGLS");
        keywordByUID.put("1.2.840.10008.1.2.4.81", "JPEGNLS");
        keywordByUID.put("1.2.840.10008.1.2.4.90", "JPEG2000Lossless");
        keywordByUID.put("1.2.840.10008.1.2.4.91", "JPEG2000");
        keywordByUID.put("1.2.840.10008.1.2.4.100", "MPEG2MPML");
        keywordByUID.put("1.2.840.10008.1.2.4.101", "MPEG2MPHL");
        keywordByUID.put("1.2.840.10008.1.2.4.102", "MPEG4HP41");
        keywordByUID.put("1.2.840.10008.1.2.4.103", "MPEG4HP41BD");
        keywordByUID.put("1.2.840.10008.1.2.4.104", "MPEG4HP422D");
        keywordByUID.put("1.2.840.10008.1.2.4.105", "MPEG4HP423D");
        keywordByUID.put("1.2.840.10008.1.2.4.106", "MPEG4HP42ST");
        keywordByUID.put("1.2.840.10008.1.2.5", "RLE");
        keywordByUID.put("1.3.6.1.4.1.5962.300.1", "PixelMedBzip2ExplicitVRLittleEndian");
        keywordByUID.put("1.3.6.1.4.1.5962.300.2", "PixelMedEncapsulatedRawLittleEndian");
        keywordByUID.put("1.2.840.10008.1.20", "Papyrus3ImplicitVRLittleEndian");
    }
}

