/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.ArrayCopyUtilities;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import java.io.IOException;
import java.text.NumberFormat;

public class UnsignedLongAttribute
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/UnsignedLongAttribute.java,v 1.31 2025/01/29 10:58:07 dclunie Exp $";
    short[] cachedShortCopy;
    int[] values;
    long[] cachedLongCopy;
    float[] cachedFloatCopy;
    double[] cachedDoubleCopy;
    static int bytesPerValue = 4;

    private void flushCachedCopies() {
        this.cachedShortCopy = null;
        this.cachedLongCopy = null;
        this.cachedFloatCopy = null;
        this.cachedDoubleCopy = null;
    }

    public UnsignedLongAttribute(AttributeTag attributeTag) {
        super(attributeTag);
        this.flushCachedCopies();
        this.values = null;
    }

    public UnsignedLongAttribute(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    public UnsignedLongAttribute(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream) throws IOException, DicomException {
        this.flushCachedCopies();
        if (l % (long)bytesPerValue != 0L) {
            throw new DicomException("incorrect value length (" + l + " dec) for VR " + this.getVRAsString() + " - caller will need to skip value length bytes to get to next data element");
        }
        int n = (int)(l / (long)bytesPerValue);
        this.values = null;
        for (int i = 0; i < n; ++i) {
            this.addValue((int)dicomInputStream.readUnsigned32());
        }
    }

    @Override
    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        int[] nArray = this.getIntegerValues();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                dicomOutputStream.writeUnsigned32(nArray[i]);
            }
        }
    }

    @Override
    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" [");
        try {
            long[] lArray = this.getLongValues();
            if (lArray != null) {
                for (int i = 0; i < lArray.length; ++i) {
                    if (i > 0) {
                        stringBuffer.append(",");
                    }
                    stringBuffer.append("0x");
                    stringBuffer.append(Long.toHexString(lArray[i]));
                }
            }
        }
        catch (DicomException dicomException) {
            stringBuffer.append("XXXX");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public String[] getStringValues(NumberFormat numberFormat) throws DicomException {
        String[] stringArray = null;
        long[] lArray = this.getLongValues();
        if (lArray != null) {
            stringArray = new String[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                stringArray[i] = numberFormat == null ? Long.toString(lArray[i]) : numberFormat.format(lArray[i]);
            }
        }
        return stringArray;
    }

    @Override
    public short[] getShortValues() throws DicomException {
        if (this.cachedShortCopy == null) {
            this.cachedShortCopy = ArrayCopyUtilities.copyUnsignedIntToShortArray(this.values);
        }
        return this.cachedShortCopy;
    }

    @Override
    public int[] getIntegerValues() throws DicomException {
        return this.values;
    }

    @Override
    public long[] getLongValues() throws DicomException {
        if (this.cachedLongCopy == null) {
            this.cachedLongCopy = ArrayCopyUtilities.copyUnsignedIntToLongArray(this.values);
        }
        return this.cachedLongCopy;
    }

    @Override
    public float[] getFloatValues() throws DicomException {
        if (this.cachedFloatCopy == null) {
            this.cachedFloatCopy = ArrayCopyUtilities.copyUnsignedIntToFloatArray(this.values);
        }
        return this.cachedFloatCopy;
    }

    @Override
    public double[] getDoubleValues() throws DicomException {
        if (this.cachedDoubleCopy == null) {
            this.cachedDoubleCopy = ArrayCopyUtilities.copyUnsignedIntToDoubleArray(this.values);
        }
        return this.cachedDoubleCopy;
    }

    @Override
    public void addValue(short s) throws DicomException {
        this.addValue((int)s);
    }

    @Override
    public void addValue(int n) throws DicomException {
        this.flushCachedCopies();
        this.values = ArrayCopyUtilities.expandArray(this.values);
        this.values[this.valueMultiplicity++] = n;
        this.valueLength += 4L;
    }

    @Override
    public void addValue(long l) throws DicomException {
        this.addValue((int)l);
    }

    @Override
    public void addValue(float f) throws DicomException {
        this.addValue((int)f);
    }

    @Override
    public void addValue(double d) throws DicomException {
        this.addValue((int)d);
    }

    @Override
    public void addValue(String string) throws DicomException {
        int n = 0;
        try {
            n = (int)Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DicomException(numberFormatException.toString());
        }
        this.addValue(n);
    }

    @Override
    public void setValues(int[] nArray) throws DicomException {
        this.values = nArray;
        this.valueMultiplicity = nArray.length;
        this.valueLength = nArray.length * 4;
        this.flushCachedCopies();
    }

    @Override
    public void removeValues() {
        this.flushCachedCopies();
        this.values = null;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    @Override
    public byte[] getVR() {
        return ValueRepresentation.UL;
    }
}

