/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public class ValueRepresentation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ValueRepresentation.java,v 1.27 2025/01/29 10:58:07 dclunie Exp $";
    public static byte[] AE = new byte[]{65, 69};
    public static byte[] AS = new byte[]{65, 83};
    public static byte[] AT = new byte[]{65, 84};
    public static byte[] CS = new byte[]{67, 83};
    public static byte[] DA = new byte[]{68, 65};
    public static byte[] DS = new byte[]{68, 83};
    public static byte[] DT = new byte[]{68, 84};
    public static byte[] FL = new byte[]{70, 76};
    public static byte[] FD = new byte[]{70, 68};
    public static byte[] IS = new byte[]{73, 83};
    public static byte[] LO = new byte[]{76, 79};
    public static byte[] LT = new byte[]{76, 84};
    public static byte[] OB = new byte[]{79, 66};
    public static byte[] OD = new byte[]{79, 68};
    public static byte[] OF = new byte[]{79, 70};
    public static byte[] OL = new byte[]{79, 76};
    public static byte[] OV = new byte[]{79, 86};
    public static byte[] OW = new byte[]{79, 87};
    public static byte[] OX = new byte[]{79, 88};
    public static byte[] PN = new byte[]{80, 78};
    public static byte[] SH = new byte[]{83, 72};
    public static byte[] SL = new byte[]{83, 76};
    public static byte[] SQ = new byte[]{83, 81};
    public static byte[] SS = new byte[]{83, 83};
    public static byte[] ST = new byte[]{83, 84};
    public static byte[] SV = new byte[]{83, 86};
    public static byte[] TM = new byte[]{84, 77};
    public static byte[] UC = new byte[]{85, 67};
    public static byte[] UI = new byte[]{85, 73};
    public static byte[] UL = new byte[]{85, 76};
    public static byte[] UN = new byte[]{85, 78};
    public static byte[] UR = new byte[]{85, 82};
    public static byte[] US = new byte[]{85, 83};
    public static byte[] UT = new byte[]{85, 84};
    public static byte[] UV = new byte[]{85, 86};
    public static byte[] XS = new byte[]{88, 83};
    public static byte[] XO = new byte[]{88, 79};

    public static final boolean isApplicationEntityVR(byte[] byArray) {
        return byArray[0] == 65 && byArray[1] == 69;
    }

    public static final boolean isAgeStringVR(byte[] byArray) {
        return byArray[0] == 65 && byArray[1] == 83;
    }

    public static final boolean isAttributeTagVR(byte[] byArray) {
        return byArray[0] == 65 && byArray[1] == 84;
    }

    public static final boolean isCodeStringVR(byte[] byArray) {
        return byArray[0] == 67 && byArray[1] == 83;
    }

    public static final boolean isDateVR(byte[] byArray) {
        return byArray[0] == 68 && byArray[1] == 65;
    }

    public static final boolean isDateTimeVR(byte[] byArray) {
        return byArray[0] == 68 && byArray[1] == 84;
    }

    public static final boolean isDecimalStringVR(byte[] byArray) {
        return byArray[0] == 68 && byArray[1] == 83;
    }

    public static final boolean isFloatDoubleVR(byte[] byArray) {
        return byArray[0] == 70 && byArray[1] == 68;
    }

    public static final boolean isFloatSingleVR(byte[] byArray) {
        return byArray[0] == 70 && byArray[1] == 76;
    }

    public static final boolean isIntegerStringVR(byte[] byArray) {
        return byArray[0] == 73 && byArray[1] == 83;
    }

    public static final boolean isLongStringVR(byte[] byArray) {
        return byArray[0] == 76 && byArray[1] == 79;
    }

    public static final boolean isLongTextVR(byte[] byArray) {
        return byArray[0] == 76 && byArray[1] == 84;
    }

    public static final boolean isOtherByteVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 66;
    }

    public static final boolean isOtherDoubleVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 68;
    }

    public static final boolean isOtherFloatVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 70;
    }

    public static final boolean isOtherLongVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 76;
    }

    public static final boolean isOtherVeryLongVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 86;
    }

    public static final boolean isOtherWordVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 87;
    }

    public static final boolean isOtherUnspecifiedVR(byte[] byArray) {
        return byArray[0] == 79 && byArray[1] == 88;
    }

    public static final boolean isOtherByteOrWordVR(byte[] byArray) {
        return byArray[0] == 79 && (byArray[1] == 66 || byArray[1] == 87 || byArray[1] == 88);
    }

    public static final boolean isPersonNameVR(byte[] byArray) {
        return byArray[0] == 80 && byArray[1] == 78;
    }

    public static final boolean isShortStringVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 72;
    }

    public static final boolean isSignedLongVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 76;
    }

    public static final boolean isSignedVeryLongVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 86;
    }

    public static final boolean isSequenceVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 81;
    }

    public static final boolean isSignedShortVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 83;
    }

    public static final boolean isShortTextVR(byte[] byArray) {
        return byArray[0] == 83 && byArray[1] == 84;
    }

    public static final boolean isTimeVR(byte[] byArray) {
        return byArray[0] == 84 && byArray[1] == 77;
    }

    public static final boolean isUniqueIdentifierVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 73;
    }

    public static final boolean isUnsignedLongVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 76;
    }

    public static final boolean isUnsignedVeryLongVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 86;
    }

    public static final boolean isUnknownVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 78;
    }

    public static final boolean isUnsignedShortVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 83;
    }

    public static final boolean isUnspecifiedShortVR(byte[] byArray) {
        return byArray[0] == 88 && byArray[1] == 83;
    }

    public static final boolean isUnspecifiedShortOrOtherWordVR(byte[] byArray) {
        return byArray[0] == 88 && byArray[1] == 79;
    }

    public static final boolean isUnlimitedCharactersVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 67;
    }

    public static final boolean isUnlimitedTextVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 84;
    }

    public static final boolean isUniversalResourceVR(byte[] byArray) {
        return byArray[0] == 85 && byArray[1] == 82;
    }

    public static final boolean isShortValueLengthVR(byte[] byArray) {
        return byArray[0] == 65 && (byArray[1] == 69 || byArray[1] == 83 || byArray[1] == 84) || byArray[0] == 67 && byArray[1] == 83 || byArray[0] == 68 && (byArray[1] == 65 || byArray[1] == 83 || byArray[1] == 84) || byArray[0] == 70 && (byArray[1] == 68 || byArray[1] == 76) || byArray[0] == 73 && byArray[1] == 83 || byArray[0] == 76 && (byArray[1] == 79 || byArray[1] == 84) || byArray[0] == 80 && byArray[1] == 78 || byArray[0] == 83 && (byArray[1] == 72 || byArray[1] == 76 || byArray[1] == 83 || byArray[1] == 84) || byArray[0] == 84 && byArray[1] == 77 || byArray[0] == 85 && (byArray[1] == 73 || byArray[1] == 76 || byArray[1] == 83);
    }

    public static final boolean isAffectedBySpecificCharacterSet(byte[] byArray) {
        return ValueRepresentation.isLongStringVR(byArray) || ValueRepresentation.isLongTextVR(byArray) || ValueRepresentation.isPersonNameVR(byArray) || ValueRepresentation.isShortStringVR(byArray) || ValueRepresentation.isShortTextVR(byArray) || ValueRepresentation.isUnlimitedCharactersVR(byArray) || ValueRepresentation.isUnlimitedTextVR(byArray);
    }

    public static final boolean isDecimalNumberInJSON(byte[] byArray) {
        return ValueRepresentation.isDecimalStringVR(byArray) || ValueRepresentation.isFloatSingleVR(byArray) || ValueRepresentation.isFloatDoubleVR(byArray);
    }

    public static final boolean isIntegerNumberInJSON(byte[] byArray) {
        return ValueRepresentation.isIntegerStringVR(byArray) || ValueRepresentation.isSignedLongVR(byArray) || ValueRepresentation.isSignedShortVR(byArray) || ValueRepresentation.isSignedVeryLongVR(byArray) || ValueRepresentation.isUnsignedLongVR(byArray) || ValueRepresentation.isUnsignedShortVR(byArray) || ValueRepresentation.isUnsignedVeryLongVR(byArray);
    }

    public static final boolean isNumberInJSON(byte[] byArray) {
        return ValueRepresentation.isDecimalNumberInJSON(byArray) || ValueRepresentation.isIntegerNumberInJSON(byArray);
    }

    public static final boolean isBase64EncodedInJSON(byte[] byArray) {
        return ValueRepresentation.isOtherByteVR(byArray) || ValueRepresentation.isOtherDoubleVR(byArray) || ValueRepresentation.isOtherFloatVR(byArray) || ValueRepresentation.isOtherLongVR(byArray) || ValueRepresentation.isOtherVeryLongVR(byArray) || ValueRepresentation.isOtherWordVR(byArray) || ValueRepresentation.isUnknownVR(byArray);
    }

    public static final boolean isStringInJSON(byte[] byArray) {
        return !ValueRepresentation.isBase64EncodedInJSON(byArray) && !ValueRepresentation.isNumberInJSON(byArray) && !ValueRepresentation.isSequenceVR(byArray);
    }

    public static final String getAsString(byte[] byArray) {
        return byArray == null ? "" : new String(byArray);
    }

    public static final byte[] getValueRepresentationFromString(String string) {
        byte[] byArray = new byte[]{(byte)string.charAt(0), (byte)string.charAt(1)};
        return byArray;
    }

    public static final int getWordLengthOfValueAffectedByEndianness(byte[] byArray) {
        int n = 1;
        if (ValueRepresentation.isSignedShortVR(byArray) || ValueRepresentation.isUnsignedShortVR(byArray) || ValueRepresentation.isUnspecifiedShortVR(byArray) || ValueRepresentation.isOtherWordVR(byArray) || ValueRepresentation.isUnspecifiedShortOrOtherWordVR(byArray)) {
            n = 2;
        }
        if (ValueRepresentation.isSignedLongVR(byArray) || ValueRepresentation.isUnsignedLongVR(byArray) || ValueRepresentation.isFloatSingleVR(byArray) || ValueRepresentation.isOtherFloatVR(byArray) || ValueRepresentation.isOtherLongVR(byArray)) {
            n = 4;
        }
        if (ValueRepresentation.isSignedVeryLongVR(byArray) || ValueRepresentation.isUnsignedVeryLongVR(byArray) || ValueRepresentation.isFloatDoubleVR(byArray) || ValueRepresentation.isOtherDoubleVR(byArray) || ValueRepresentation.isOtherVeryLongVR(byArray)) {
            n = 8;
        }
        return n;
    }
}

