/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.TagFromName;
import java.util.Locale;

public abstract class Veterinary {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/Veterinary.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";

    public static boolean isPatientAnAnimal(AttributeList attributeList) {
        boolean bl = false;
        CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.PatientSpeciesCodeSequence);
        if (codedSequenceItem == null) {
            String string = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PatientSpeciesDescription);
            bl = string != null && string.trim().length() != 0 && !string.toLowerCase(Locale.US).contains("homo sapien") && !string.toLowerCase(Locale.US).contains("human");
        } else {
            String string = codedSequenceItem.getCodeValue();
            String string2 = codedSequenceItem.getCodingSchemeDesignator();
            String string3 = codedSequenceItem.getCodeMeaning();
            if (string != null && string2 != null) {
                bl = (string2.equals("SRT") || string2.equals("SNM3")) && string.equals("L-85B00") ? false : string3 == null || !string3.toLowerCase(Locale.US).contains("homo sapien") && !string3.toLowerCase(Locale.US).contains("human");
            }
        }
        return bl;
    }
}

