/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.PixelSpacing;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.DemographicAndTechniqueAnnotations;
import com.pixelmed.display.DisplayDeviceArea;
import com.pixelmed.display.DisplayedAreaSelection;
import com.pixelmed.display.MammoDemographicAndTechniqueAnnotations;
import com.pixelmed.display.OrientationAnnotations;
import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SingleImagePanelWithLineDrawing;
import com.pixelmed.display.SourceImage;
import com.pixelmed.event.EventContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ChestImageViewer {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/ChestImageViewer.java,v 1.15 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(ChestImageViewer.class);
    protected JFrame frame;
    protected JPanel multiPanel;
    protected int frameWidth;
    protected int frameHeight;

    private static String[] getPatientOrientation(AttributeList attributeList) {
        String[] stringArray = null;
        Attribute attribute = attributeList.get(TagFromName.PatientOrientation);
        if (attribute != null && attribute.getVM() == 2) {
            try {
                stringArray = attribute.getStringValues();
                if (stringArray != null && stringArray.length != 2) {
                    stringArray = null;
                }
            }
            catch (DicomException dicomException) {
                stringArray = null;
            }
        }
        if (stringArray == null) {
            stringArray = new String[2];
        }
        return stringArray;
    }

    private static String getView(AttributeList attributeList) {
        String string = null;
        CodedSequenceItem codedSequenceItem = CodedSequenceItem.getSingleCodedSequenceItemOrNull(attributeList, TagFromName.ViewCodeSequence);
        if (codedSequenceItem != null) {
            string = MammoDemographicAndTechniqueAnnotations.getViewAbbreviationFromViewCodeSequenceAttributes(codedSequenceItem.getAttributeList());
        }
        return string;
    }

    private static String getImageLateralityViewModifierAndViewModifier(AttributeList attributeList) {
        return MammoDemographicAndTechniqueAnnotations.getAbbreviationFromImageLateralityViewModifierAndViewModifierCodeSequenceAttributes(attributeList);
    }

    private static String getLaterality(AttributeList attributeList) {
        return Attribute.getSingleStringValueOrNull(attributeList, TagFromName.ImageLaterality);
    }

    private static String getDate(AttributeList attributeList) {
        return Attribute.getSingleStringValueOrNull(attributeList, TagFromName.StudyDate);
    }

    protected SingleImagePanel makeNewImagePanel(SourceImage sourceImage, EventContext eventContext) {
        return new OurSingleImagePanel(sourceImage, eventContext);
    }

    public void loadMultiPanelFromSpecifiedFiles(String[] stringArray) throws Exception {
        int n;
        int n2;
        int n3 = stringArray.length;
        SingleImagePanel[] singleImagePanelArray = new SingleImagePanel[n3];
        String[][] stringArrayArray = new String[n3][];
        String[] stringArray2 = new String[n3];
        String[] stringArray3 = new String[n3];
        String[] stringArray4 = new String[n3];
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        PixelSpacing[] pixelSpacingArray = new PixelSpacing[n3];
        String[] stringArray5 = new String[n3];
        String[] stringArray6 = new String[n3];
        HashMap hashMap = new HashMap();
        double d = 0.0;
        double d2 = 0.0;
        StructuredReport[] structuredReportArray = new StructuredReport[n3];
        int n4 = 0;
        boolean bl = false;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                SingleImagePanel singleImagePanel;
                String string = stringArray[n2];
                DicomInputStream dicomInputStream = null;
                InputStream inputStream = classLoader.getResourceAsStream(string);
                dicomInputStream = inputStream != null ? new DicomInputStream(inputStream) : new DicomInputStream(new File(string));
                AttributeList attributeList = new AttributeList();
                attributeList.read(dicomInputStream);
                if (attributeList.isImage()) {
                    int n5 = n4++;
                    slf4jlogger.info("IMAGE [{}] is file {} ({})", n5, n2, stringArray[n2]);
                    stringArrayArray[n5] = ChestImageViewer.getPatientOrientation(attributeList);
                    stringArray2[n5] = ChestImageViewer.getView(attributeList);
                    stringArray3[n5] = ChestImageViewer.getImageLateralityViewModifierAndViewModifier(attributeList);
                    stringArray4[n5] = ChestImageViewer.getLaterality(attributeList);
                    pixelSpacingArray[n5] = new PixelSpacing(attributeList);
                    SourceImage sourceImage = new SourceImage(attributeList);
                    BufferedImage bufferedImage = sourceImage.getBufferedImage();
                    nArray[n5] = sourceImage.getWidth();
                    nArray2[n5] = sourceImage.getHeight();
                    boolean bl2 = false;
                    EventContext eventContext = new EventContext(Integer.toString(n5));
                    singleImagePanel = this.makeNewImagePanel(sourceImage, eventContext);
                    singleImagePanel.setDemographicAndTechniqueAnnotations(new DemographicAndTechniqueAnnotations(attributeList), "SansSerif", 0, 10, Color.pink);
                    singleImagePanel.setOrientationAnnotations(new OrientationAnnotations(stringArray5[n5], stringArray6[n5]), "SansSerif", 0, 20, Color.pink);
                    singleImagePanel.setPixelSpacingInSourceImage(pixelSpacingArray[n5].getSpacing(), pixelSpacingArray[n5].getDescription());
                    if (Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.VOILUTFunction).equals("SIGMOID")) {
                        singleImagePanel.setVOIFunctionToLogistic();
                    }
                } else {
                    throw new DicomException("Unsupported SOP Class in file " + stringArray[n2]);
                }
                singleImagePanelArray[n5] = singleImagePanel;
                continue;
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
        n2 = n4 >= 8 ? 8 : n4;
        int n6 = (n4 - 1) / n2 + 1;
        int n7 = this.frameWidth / n2;
        int n8 = this.frameHeight / n6;
        if (n4 == 1 && n7 > n8) {
            n7 /= 2;
        }
        for (n = 0; n < n4; ++n) {
            DisplayedAreaSelection displayedAreaSelection = null;
            displayedAreaSelection = new DisplayedAreaSelection(nArray[n], nArray2[n], 0, 0, nArray[n], nArray2[n], true, 0.0, 0.0, 0.0, 0, 0, false);
            singleImagePanelArray[n].setDisplayedAreaSelection(displayedAreaSelection);
            singleImagePanelArray[n].setPreTransformImageRelativeCoordinates(null);
        }
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        this.multiPanel.removeAll();
        this.multiPanel.setLayout(new GridLayout(n6, n2));
        this.multiPanel.setBackground(Color.black);
        for (n = 0; n < n6; ++n) {
            for (int i = 0; i < n2; ++i) {
                int n9 = n * n2 + i;
                if (n9 >= n4) continue;
                singleImagePanelArray[n9].setPreferredSize(new Dimension(n7, n8));
                this.multiPanel.add(singleImagePanelArray[n9]);
            }
        }
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
    }

    public static DisplayDeviceArea[] getPresentationAndImageDeviceAreas() {
        DisplayDeviceArea[] displayDeviceAreaArray = null;
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (graphicsDeviceArray.length == 1) {
            DisplayMode displayMode = graphicsDeviceArray[0].getDisplayMode();
            int n = displayMode.getWidth();
            int n2 = displayMode.getHeight();
            float f = 1.25f;
            float f2 = 1.5f;
            float f3 = 0.33f;
            int n3 = (int)((float)n * f3);
            int n4 = (int)((float)n3 / f);
            if (n4 > n2) {
                n4 = n2;
            }
            int n5 = 0;
            int n6 = n2 - n4;
            int n7 = n - n3;
            int n8 = (int)((float)n7 / f2);
            if (n8 > n2) {
                n8 = n2;
            }
            int n9 = n3;
            int n10 = n2 - n8;
            displayDeviceAreaArray = new DisplayDeviceArea[]{new DisplayDeviceArea(graphicsDeviceArray[0], n5, n6, n3, n4), new DisplayDeviceArea(graphicsDeviceArray[0], n9, n10, n7, n8)};
        } else if (graphicsDeviceArray.length == 2) {
            GraphicsDevice graphicsDevice;
            GraphicsDevice graphicsDevice2;
            int n;
            DisplayMode displayMode = graphicsDeviceArray[0].getDisplayMode();
            DisplayMode displayMode2 = graphicsDeviceArray[1].getDisplayMode();
            int n11 = displayMode.getWidth();
            int n12 = displayMode2.getWidth();
            int n13 = displayMode.getHeight();
            if (n11 * n13 > n12 * (n = displayMode2.getHeight())) {
                graphicsDevice2 = graphicsDeviceArray[1];
                graphicsDevice = graphicsDeviceArray[0];
            } else {
                graphicsDevice2 = graphicsDeviceArray[0];
                graphicsDevice = graphicsDeviceArray[1];
            }
            displayDeviceAreaArray = new DisplayDeviceArea[]{new DisplayDeviceArea(graphicsDevice2), new DisplayDeviceArea(graphicsDevice)};
        }
        return displayDeviceAreaArray;
    }

    public ChestImageViewer(String[] stringArray) throws Exception {
        DisplayDeviceArea[] displayDeviceAreaArray = ChestImageViewer.getPresentationAndImageDeviceAreas();
        if (displayDeviceAreaArray == null) {
            System.err.println("Cannot determine device display areas");
        } else {
            System.err.println("Found " + displayDeviceAreaArray.length + " device display areas");
            for (int i = 0; i < displayDeviceAreaArray.length; ++i) {
                System.err.println("[" + i + "] = " + displayDeviceAreaArray[i]);
                displayDeviceAreaArray[i].getFrame().setBackground(Color.black);
                displayDeviceAreaArray[i].getFrame().setVisible(true);
            }
            Container container = new JPanel();
            ((JComponent)container).setBackground(Color.black);
            displayDeviceAreaArray[0].getFrame().getContentPane().add(container);
            displayDeviceAreaArray[0].getFrame().validate();
            this.frame = displayDeviceAreaArray[1].getFrame();
            container = this.frame.getContentPane();
            container.setLayout(new GridLayout(1, 1));
            this.multiPanel = new JPanel();
            this.frameWidth = this.frame.getWidth();
            this.frameHeight = this.frame.getHeight();
            Dimension dimension = new Dimension(this.frameWidth, this.frameHeight);
            this.multiPanel.setPreferredSize(dimension);
            this.multiPanel.setBackground(Color.black);
            container.add(this.multiPanel);
            container.validate();
            this.loadMultiPanelFromSpecifiedFiles(stringArray);
        }
    }

    public void clear() {
        SingleImagePanel.deconstructAllSingleImagePanelsInContainer(this.multiPanel);
        this.multiPanel.removeAll();
        this.frame.getContentPane().validate();
        this.frame.getContentPane().repaint();
    }

    public static void main(String[] stringArray) {
        try {
            new ChestImageViewer(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    class OurSingleImagePanel
    extends SingleImagePanelWithLineDrawing {
        public OurSingleImagePanel(SourceImage sourceImage, EventContext eventContext) {
            super(sourceImage, eventContext);
        }
    }
}

