/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.MessageLogger;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.DefaultCaret;

public class DialogMessageLogger
implements MessageLogger {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DialogMessageLogger.java,v 1.20 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DialogMessageLogger.class);
    protected JDialog outputDialog;
    protected JScrollPane outputScrollPane;
    protected JTextArea outputTextArea;
    protected static long startTimeForLogging = System.currentTimeMillis();
    protected boolean showDateTime = false;
    protected SimpleDateFormat dateFormatter = null;

    public void showDateTime(boolean bl) {
        this.showDateTime = bl;
    }

    public void setDateTimeFormat(String string) {
        try {
            if (string != null && string.length() > 0) {
                this.dateFormatter = new SimpleDateFormat(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            slf4jlogger.error("DialogMessageLogger(): bad date format ");
        }
    }

    public DialogMessageLogger(String string, int n, int n2, boolean bl) {
        this(string, n, n2, bl, true);
    }

    public DialogMessageLogger(String string, int n, int n2, boolean bl, boolean bl2) {
        this(string, n, n2, bl, bl2, false, null);
    }

    public DialogMessageLogger(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, String string2) {
        if (EventQueue.isDispatchThread()) {
            slf4jlogger.trace("DialogMessageLogger(): constructing on EDT - showDateTime = {}", bl3);
            this.createGUI(string, n, n2, bl, bl2, bl3, string2);
        } else {
            slf4jlogger.trace("DialogMessageLogger(): constructing on non-EDT - showDateTime = {}", bl3);
            EventQueue.invokeLater(new CreateGUIRunnable(string, n, n2, bl, bl2, bl3, string2));
        }
    }

    protected void createGUI(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, String string2) {
        slf4jlogger.trace("createGUI() - showDateTime = {}", bl3);
        this.showDateTime(bl3);
        this.setDateTimeFormat(string2);
        Border border = BorderFactory.createEtchedBorder();
        this.outputTextArea = new JTextArea();
        Object object = this.outputTextArea.getCaret();
        if (object != null && object instanceof DefaultCaret) {
            ((DefaultCaret)object).setUpdatePolicy(2);
        }
        this.outputScrollPane = new JScrollPane(this.outputTextArea);
        this.outputScrollPane.setBorder(border);
        this.outputDialog = new JDialog();
        this.outputDialog.setPreferredSize(new Dimension(n, n2));
        this.outputDialog.setTitle(string);
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(1));
        ((JComponent)object).setBorder(border);
        JButton jButton = new JButton("Clear");
        jButton.setToolTipText("Clear log");
        ((Container)object).add(jButton);
        jButton.addActionListener(new ClearActionListener());
        Container container = this.outputDialog.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.outputScrollPane, gridBagConstraints);
        container.add(this.outputScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagLayout.setConstraints((Component)object, gridBagConstraints);
        container.add((Component)object);
        this.outputDialog.pack();
        this.outputDialog.setVisible(bl2);
        if (bl) {
            this.outputDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
            });
        }
    }

    public void setVisible(boolean bl) {
        if (EventQueue.isDispatchThread()) {
            this.outputDialog.setVisible(bl);
        } else {
            EventQueue.invokeLater(new SetVisibleRunnable(bl));
        }
    }

    protected void timestamp() {
        if (this.showDateTime) {
            String string = (this.dateFormatter == null ? Long.valueOf(System.currentTimeMillis() - startTimeForLogging) : this.dateFormatter.format(new Date())) + " ";
            if (EventQueue.isDispatchThread()) {
                this.outputTextArea.append(string);
            } else {
                EventQueue.invokeLater(new SendRunnable(string));
            }
        }
    }

    @Override
    public void send(String string) {
        this.timestamp();
        if (EventQueue.isDispatchThread()) {
            this.outputTextArea.append(string);
        } else {
            EventQueue.invokeLater(new SendRunnable(string));
        }
    }

    @Override
    public void sendLn(String string) {
        this.timestamp();
        if (EventQueue.isDispatchThread()) {
            this.outputTextArea.append(string + "\n");
        } else {
            EventQueue.invokeLater(new SendRunnable(string + "\n"));
        }
    }

    protected class SendRunnable
    implements Runnable {
        String message;

        SendRunnable(String string) {
            this.message = string;
        }

        @Override
        public void run() {
            DialogMessageLogger.this.outputTextArea.append(this.message);
        }
    }

    protected class SetVisibleRunnable
    implements Runnable {
        boolean visible;

        SetVisibleRunnable(boolean bl) {
            this.visible = bl;
        }

        @Override
        public void run() {
            DialogMessageLogger.this.outputDialog.setVisible(this.visible);
        }
    }

    protected class CreateGUIRunnable
    implements Runnable {
        String titleMessage;
        int width;
        int height;
        boolean exitApplicationOnClose;
        boolean visible;
        boolean showDateTime;
        String dateTimeFormat;

        CreateGUIRunnable(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, String string2) {
            this.titleMessage = string;
            this.width = n;
            this.height = n2;
            this.exitApplicationOnClose = bl;
            this.visible = bl2;
            this.showDateTime = bl3;
            this.dateTimeFormat = string2;
        }

        @Override
        public void run() {
            DialogMessageLogger.this.createGUI(this.titleMessage, this.width, this.height, this.exitApplicationOnClose, this.visible, this.showDateTime, this.dateTimeFormat);
        }
    }

    protected class ClearActionListener
    implements ActionListener {
        protected ClearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DialogMessageLogger.this.outputTextArea.setText("");
            DialogMessageLogger.this.outputScrollPane.repaint();
        }
    }
}

