/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeBrowser;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.AgeStringAttribute;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.ClinicalTrialsAttributes;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.CodedSequenceItem;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DateTimeAttribute;
import com.pixelmed.dicom.DicomDirectory;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.MediaImporter;
import com.pixelmed.dicom.MoveDicomFilesIntoHierarchy;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.SOPClass;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.SetOfDicomFiles;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.TransferSyntax;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.display.DialogMessageLogger;
import com.pixelmed.display.DicomImageBlackout;
import com.pixelmed.display.SafeCursorChanger;
import com.pixelmed.display.SafeFileChooser;
import com.pixelmed.display.SafeProgressBarUpdaterThread;
import com.pixelmed.display.event.StatusChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MultipleInstanceTransferStatusHandlerWithFileName;
import com.pixelmed.network.NetworkApplicationConfigurationDialog;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationInformationFederated;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.PresentationAddress;
import com.pixelmed.network.PresentationContext;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.network.StorageSOPClassSCU;
import com.pixelmed.network.TransferSyntaxSelectionPolicy;
import com.pixelmed.network.UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeBrowser;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import com.pixelmed.utils.CapabilitiesAvailable;
import com.pixelmed.utils.CopyStream;
import com.pixelmed.utils.MessageLogger;
import com.pixelmed.utils.StringUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DicomCleaner
extends ApplicationFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/DicomCleaner.java,v 1.102 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(DicomCleaner.class);
    protected static String resourceBundleName = "com.pixelmed.display.DicomCleaner";
    protected static String propertiesFileName = ".com.pixelmed.display.DicomCleaner.properties";
    protected static String propertyName_DicomCurrentlySelectedStorageTargetAE = "Dicom.CurrentlySelectedStorageTargetAE";
    protected static String propertyName_DicomCurrentlySelectedQueryTargetAE = "Dicom.CurrentlySelectedQueryTargetAE";
    protected static String propertyName_AllowUserQuery = "Application.Allow.UserQuery";
    protected static String propertyName_AllowNetworkConfiguration = "Application.Allow.NetworkConfiguration";
    protected static String propertyName_AllowChangeDatesAndTimes = "Application.Allow.ChangeDatesAndTimes";
    protected static String propertyName_AllowRemoveIdentityCheckBox = "Application.Allow.CheckBox.RemoveIdentity";
    protected static String propertyName_AllowRemoveDescriptionsCheckBox = "Application.Allow.CheckBox.RemoveDescriptions";
    protected static String propertyName_AllowRemoveSeriesDescriptionsCheckBox = "Application.Allow.CheckBox.RemoveSeriesDescriptions";
    protected static String propertyName_AllowRemoveProtocolNameCheckBox = "Application.Allow.CheckBox.RemoveProtocolName";
    protected static String propertyName_AllowRemoveCharacteristicsCheckBox = "Application.Allow.CheckBox.RemoveCharacteristics";
    protected static String propertyName_AllowRemoveDeviceIdentityCheckBox = "Application.Allow.CheckBox.RemoveDeviceIdentity";
    protected static String propertyName_AllowRemoveInstitutionIdentityCheckBox = "Application.Allow.CheckBox.RemoveInstitutionIdentity";
    protected static String propertyName_AllowCleanUIDsCheckBox = "Application.Allow.CheckBox.CleanUIDs";
    protected static String propertyName_AllowRemovePrivateCheckBox = "Application.Allow.CheckBox.RemovePrivate";
    protected static String propertyName_AllowAddContributingEquipmentCheckBox = "Application.Allow.CheckBox.AddContributingEquipment";
    protected static String propertyName_AllowRemoveClinicalTrialAttributesCheckBox = "Application.Allow.CheckBox.RemoveClinicalTrialAttributes";
    protected static String propertyName_AllowRemoveAllStructuredContentCheckBox = "Application.Allow.CheckBox.RemoveAllStructuredContent";
    protected static String propertyName_AllowRemoveUnsafeStructuredContentCheckBox = "Application.Allow.CheckBox.RemoveUnsafeStructuredContent";
    protected static String propertyName_AllowZipExportCheckBox = "Application.Allow.CheckBox.ZipExport";
    protected static String propertyName_AllowHierarchicalExportCheckBox = "Application.Allow.CheckBox.HierarchicalExport";
    protected static String propertyName_AllowAcceptAnyTransferSyntaxCheckBox = "Application.Allow.CheckBox.AcceptAnyTransferSyntax";
    protected static String propertyName_AllowAggregateAgesOver89CheckBox = "Application.Allow.CheckBox.AggregateAgesOver89";
    protected static String propertyName_ReplacementTextPatientName = "Application.ReplacementText.PatientName";
    protected static String propertyName_ReplacementTextPatientID = "Application.ReplacementText.PatientID";
    protected static String propertyName_ReplacementTextPatientBirthDate = "Application.ReplacementText.PatientBirthDate";
    protected static String propertyName_ReplacementTextAccessionNumber = "Application.ReplacementText.AccessionNumber";
    protected static String propertyName_ShowDateTime = "Application.DialogLogger.showDateTime";
    protected static String propertyName_DateTimeFormat = "Application.DialogLogger.dateTimeFormat";
    protected static String propertyName_CheckBoxReplacePatientNameIsSelected = "Application.CheckBox.IsSelected.ReplacePatientName";
    protected static String propertyName_CheckBoxReplacePatientIDIsSelected = "Application.CheckBox.IsSelected.ReplacePatientID";
    protected static String propertyName_CheckBoxReplacePatientBirthDateIsSelected = "Application.CheckBox.IsSelected.ReplacePatientBirthDate";
    protected static String propertyName_CheckBoxReplaceAccessionNumberIsSelected = "Application.CheckBox.IsSelected.ReplaceAccessionNumber";
    protected static String propertyName_CheckBoxModifyDatesIsSelected = "Application.CheckBox.IsSelected.ModifyDates";
    protected static String propertyName_ModifyDatesEpoch = "Application.ModifyDatesEpoch";
    protected static String propertyName_CheckBoxRemoveIdentityIsSelected = "Application.CheckBox.IsSelected.RemoveIdentity";
    protected static String propertyName_CheckBoxRemoveDescriptionsIsSelected = "Application.CheckBox.IsSelected.RemoveDescriptions";
    protected static String propertyName_CheckBoxRemoveSeriesDescriptionsIsSelected = "Application.CheckBox.IsSelected.RemoveSeriesDescriptions";
    protected static String propertyName_CheckBoxRemoveProtocolNameIsSelected = "Application.CheckBox.IsSelected.RemoveProtocolName";
    protected static String propertyName_CheckBoxRemoveCharacteristicsIsSelected = "Application.CheckBox.IsSelected.RemoveCharacteristics";
    protected static String propertyName_CheckBoxRemoveDeviceIdentityIsSelected = "Application.CheckBox.IsSelected.RemoveDeviceIdentity";
    protected static String propertyName_CheckBoxRemoveInstitutionIdentityIsSelected = "Application.CheckBox.IsSelected.RemoveInstitutionIdentity";
    protected static String propertyName_CheckBoxCleanUIDsIsSelected = "Application.CheckBox.IsSelected.CleanUIDs";
    protected static String propertyName_CheckBoxRemovePrivateIsSelected = "Application.CheckBox.IsSelected.RemovePrivate";
    protected static String propertyName_CheckBoxAddContributingEquipmentIsSelected = "Application.CheckBox.IsSelected.AddContributingEquipment";
    protected static String propertyName_CheckBoxRemoveClinicalTrialAttributesIsSelected = "Application.CheckBox.IsSelected.RemoveClinicalTrialAttributes";
    protected static String propertyName_CheckBoxRemoveAllStructuredContentIsSelected = "Application.CheckBox.IsSelected.RemoveAllStructuredContentAttributes";
    protected static String propertyName_CheckBoxRemoveUnsafeStructuredContentIsSelected = "Application.CheckBox.IsSelected.RemoveUnsafeStructuredContentAttributes";
    protected static String propertyName_CheckBoxZipExportIsSelected = "Application.CheckBox.IsSelected.ZipExport";
    protected static String propertyName_CheckBoxHierarchicalExportIsSelected = "Application.CheckBox.IsSelected.HierarchicalExport";
    protected static String propertyName_CheckBoxAcceptAnyTransferSyntaxIsSelected = "Application.CheckBox.IsSelected.AcceptAnyTransferSyntax";
    protected static String propertyName_CheckBoxAggregateAgesOver89IsSelected = "Application.CheckBox.IsSelected.AggregateAgesOver89";
    protected static String propertyName_RandomReplacementPatientNamePrefix = "Application.RandomReplacementPatientNamePrefix";
    protected static String propertyName_RandomReplacementPatientIDLength = "Application.RandomReplacementPatientIDLength";
    protected static String propertyName_RandomReplacementAccessionNumberLength = "Application.RandomReplacementAccessionNumberLength";
    protected static boolean default_CheckBoxReplacePatientNameIsSelected = true;
    protected static boolean default_CheckBoxReplacePatientIDIsSelected = true;
    protected static boolean default_CheckBoxReplacePatientBirthDateIsSelected = false;
    protected static boolean default_CheckBoxReplaceAccessionNumberIsSelected = true;
    protected static boolean default_CheckBoxModifyDatesIsSelected = false;
    protected static boolean default_CheckBoxRemoveIdentityIsSelected = true;
    protected static boolean default_CheckBoxRemoveDescriptionsIsSelected = false;
    protected static boolean default_CheckBoxRemoveSeriesDescriptionsIsSelected = false;
    protected static boolean default_CheckBoxRemoveProtocolNameIsSelected = false;
    protected static boolean default_CheckBoxRemoveCharacteristicsIsSelected = false;
    protected static boolean default_CheckBoxRemoveDeviceIdentityIsSelected = false;
    protected static boolean default_CheckBoxRemoveInstitutionIdentityIsSelected = false;
    protected static boolean default_CheckBoxCleanUIDsIsSelected = true;
    protected static boolean default_CheckBoxRemovePrivateIsSelected = true;
    protected static boolean default_CheckBoxAddContributingEquipmentIsSelected = true;
    protected static boolean default_CheckBoxRemoveClinicalTrialAttributesIsSelected = false;
    protected static boolean default_CheckBoxRemoveAllStructuredContentIsSelected = false;
    protected static boolean default_CheckBoxRemoveUnsafeStructuredContentIsSelected = false;
    protected static boolean default_CheckBoxZipExportIsSelected = false;
    protected static boolean default_CheckBoxHierarchicalExportIsSelected = false;
    protected static boolean default_CheckBoxAcceptAnyTransferSyntaxIsSelected = false;
    protected static boolean default_CheckBoxAggregateAgesOver89IsSelected = false;
    protected static boolean default_ShowDateTime = false;
    protected static String default_DateTimeFormat = null;
    protected static int default_RandomReplacementPatientIDLength = 16;
    protected static int default_RandomReplacementAccessionNumberLength = 16;
    protected static String rootNameForDicomInstanceFilesOnInterchangeMedia = "DICOM";
    protected static String filePrefixForDicomInstanceFilesOnInterchangeMedia = "I";
    protected static String fileSuffixForDicomInstanceFilesOnInterchangeMedia = "";
    protected static String nameForDicomDirectoryOnInterchangeMedia = "DICOMDIR";
    protected static String exportedZipFileName = "export.zip";
    protected static int textFieldLengthForQueryPatientName = 16;
    protected static int textFieldLengthForQueryPatientID = 10;
    protected static int textFieldLengthForQueryStudyDate = 8;
    protected static int textFieldLengthForQueryAccessionNumber = 10;
    protected static int textFieldLengthForReplacementPatientName = 16;
    protected static int textFieldLengthForReplacementPatientID = 10;
    protected static int textFieldLengthForReplacementPatientBirthDate = 8;
    protected static int textFieldLengthForReplacementAccessionNumber = 10;
    protected static int textFieldLengthForModifyDates = 8;
    protected ResourceBundle resourceBundle;
    protected DatabaseInformationModel srcDatabase;
    protected DatabaseInformationModel dstDatabase;
    protected JPanel srcDatabasePanel;
    protected JPanel dstDatabasePanel;
    protected JPanel remoteQueryRetrievePanel;
    protected JCheckBox removeIdentityCheckBox;
    protected JCheckBox removeDescriptionsCheckBox;
    protected JCheckBox removeSeriesDescriptionsCheckBox;
    protected JCheckBox removeProtocolNameCheckBox;
    protected JCheckBox removeCharacteristicsCheckBox;
    protected JCheckBox removeDeviceIdentityCheckBox;
    protected JCheckBox removeInstitutionIdentityCheckBox;
    protected JCheckBox cleanUIDsCheckBox;
    protected JCheckBox removePrivateCheckBox;
    protected JCheckBox addContributingEquipmentCheckBox;
    protected JCheckBox removeClinicalTrialAttributesCheckBox;
    protected JCheckBox removeAllStructuredContentCheckBox;
    protected JCheckBox removeUnsafeStructuredContentCheckBox;
    protected JCheckBox zipExportCheckBox;
    protected JCheckBox hierarchicalExportCheckBox;
    protected JCheckBox acceptAnyTransferSyntaxCheckBox;
    protected JCheckBox aggregateAgesOver89CheckBox;
    protected JCheckBox replacePatientNameCheckBox;
    protected JCheckBox replacePatientIDCheckBox;
    protected JCheckBox replacePatientBirthDateCheckBox;
    protected JCheckBox replaceAccessionNumberCheckBox;
    protected JCheckBox modifyDatesCheckBox;
    protected JTextField replacementPatientNameTextField;
    protected JTextField replacementPatientIDTextField;
    protected JTextField replacementPatientBirthDateTextField;
    protected JTextField replacementAccessionNumberTextField;
    protected JTextField modifyDatesTextField;
    protected JTextField queryFilterPatientNameTextField;
    protected JTextField queryFilterPatientIDTextField;
    protected JTextField queryFilterStudyDateTextField;
    protected JTextField queryFilterAccessionNumberTextField;
    protected String randomReplacementPatientNamePrefix;
    protected int randomReplacementPatientIDLength;
    protected int randomReplacementAccessionNumberLength;
    protected SafeProgressBarUpdaterThread progressBarUpdater;
    protected SafeCursorChanger cursorChanger;
    protected MessageLogger logger;
    protected NetworkApplicationProperties networkApplicationProperties;
    protected NetworkApplicationInformation networkApplicationInformation;
    protected QueryInformationModel currentRemoteQueryInformationModel;
    protected QueryTreeRecord currentRemoteQuerySelectionQueryTreeRecord;
    protected AttributeList currentRemoteQuerySelectionUniqueKeys;
    protected Attribute currentRemoteQuerySelectionUniqueKey;
    protected String currentRemoteQuerySelectionRetrieveAE;
    protected String currentRemoteQuerySelectionLevel;
    protected String ourCalledAETitle;
    protected Map<String, Date> earliestDatesIndexedBySourceFilePath = new HashMap<String, Date>();
    protected File savedImagesFolder;
    protected StorageSOPClassSCPDispatcher storageSOPClassSCPDispatcher;
    protected DatabaseTreeRecord[] currentSourceDatabaseSelections;
    protected Vector currentSourceFilePathSelections;
    protected DatabaseTreeRecord[] currentDestinationDatabaseSelections;
    protected Vector currentDestinationFilePathSelections;
    protected String importDirectoryPath;
    protected String exportDirectoryPath;
    Thread activeThread;

    protected void setCurrentRemoteQueryInformationModel(String string) {
        this.currentRemoteQueryInformationModel = null;
        String string2 = "";
        if (string != null && string.length() > 0 && this.networkApplicationProperties != null && this.networkApplicationInformation != null) {
            try {
                String string3 = this.networkApplicationProperties.getCallingAETitle();
                String string4 = this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                PresentationAddress presentationAddress = this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string4);
                if (presentationAddress == null) {
                    throw new Exception("For remote query AE <" + string + ">, presentationAddress cannot be determined");
                }
                String string5 = presentationAddress.getHostname();
                int n = presentationAddress.getPort();
                String string6 = this.networkApplicationInformation.getApplicationEntityMap().getQueryModel(string4);
                if (!NetworkApplicationProperties.isStudyRootQueryModel(string6) && string6 != null) {
                    throw new Exception("For remote query AE <" + string + ">, query model " + string6 + " not supported");
                }
                this.currentRemoteQueryInformationModel = new StudyRootQueryInformationModel(string5, n, string4, string3);
                string2 = ":" + string;
            }
            catch (Exception exception) {
                slf4jlogger.error("Setting remote query target failed ", exception);
            }
        }
    }

    private String showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(String string, String string2, String string3) {
        Set set;
        String string4 = string3;
        if (this.networkApplicationInformation != null && (set = this.networkApplicationInformation.getListOfLocalNamesOfApplicationEntities()) != null) {
            Object[] objectArray = new String[set.size()];
            int n = 0;
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                objectArray[n++] = (String)iterator.next();
            }
            string4 = (String)JOptionPane.showInputDialog(this.getContentPane(), string, string2, 3, null, objectArray, string4);
        }
        return string4;
    }

    protected static void importFileIntoDatabase(DatabaseInformationModel databaseInformationModel, String string, String string2, Map<String, Date> map) throws FileNotFoundException, IOException, DicomException {
        Date date;
        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing: " + string));
        FileInputStream fileInputStream = new FileInputStream(string);
        DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream, TagFromName.PixelData);
        dicomInputStream.close();
        fileInputStream.close();
        databaseInformationModel.insertObject(attributeList, string, string2);
        if (map != null && (date = ClinicalTrialsAttributes.findEarliestDateTime(attributeList)) != null) {
            map.put(string, date);
        }
    }

    protected void activateStorageSCP() throws DicomException, IOException {
        if (this.networkApplicationProperties != null) {
            int n = this.networkApplicationProperties.getListeningPort();
            this.ourCalledAETitle = this.networkApplicationProperties.getCalledAETitle();
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Starting up DICOM association listener on port " + n + " AET " + this.ourCalledAETitle));
            slf4jlogger.info("Starting up DICOM association listener on port {} AET {}", n, this.ourCalledAETitle);
            this.storageSOPClassSCPDispatcher = new StorageSOPClassSCPDispatcher(n, this.ourCalledAETitle, this.networkApplicationProperties.getAcceptorMaximumLengthReceived(), this.networkApplicationProperties.getAcceptorSocketReceiveBufferSize(), this.networkApplicationProperties.getAcceptorSocketSendBufferSize(), this.savedImagesFolder, StoredFilePathStrategy.BYSOPINSTANCEUIDINSINGLEFOLDER, new OurReceivedObjectHandler(), null, this.srcDatabase == null ? null : this.srcDatabase.getQueryResponseGeneratorFactory(), this.srcDatabase == null ? null : this.srcDatabase.getRetrieveResponseGeneratorFactory(), this.networkApplicationInformation, new OurPresentationContextSelectionPolicy(), false);
            new Thread(this.storageSOPClassSCPDispatcher).start();
        }
    }

    protected void activateTemporaryDatabases() throws DicomException {
        this.srcDatabase = new PatientStudySeriesConcatenationInstanceModel("mem:src", null, this.resourceBundle.getString("DatabaseRootTitleForOriginal"));
        this.dstDatabase = new PatientStudySeriesConcatenationInstanceModel("mem:dst", null, this.resourceBundle.getString("DatabaseRootTitleForCleaned"));
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord[] databaseTreeRecordArray, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecordArray != null) {
            for (DatabaseTreeRecord databaseTreeRecord : databaseTreeRecordArray) {
                this.purgeFilesAndDatabaseInformation(databaseTreeRecord, messageLogger, safeProgressBarUpdaterThread, n, n2);
            }
        }
    }

    protected void purgeFilesAndDatabaseInformation(DatabaseTreeRecord databaseTreeRecord, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread, int n, int n2) throws DicomException, IOException {
        if (databaseTreeRecord != null) {
            SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, n, n2);
            InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
            if (informationEntity == null || !informationEntity.equals(InformationEntity.INSTANCE)) {
                Enumeration enumeration = databaseTreeRecord.children();
                if (enumeration != null) {
                    n2 += databaseTreeRecord.getChildCount();
                    while (enumeration.hasMoreElements()) {
                        DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)enumeration.nextElement();
                        if (databaseTreeRecord2 == null) continue;
                        this.purgeFilesAndDatabaseInformation(databaseTreeRecord2, messageLogger, safeProgressBarUpdaterThread, n, n2);
                        ++n;
                    }
                }
                if (informationEntity != null) {
                    messageLogger.sendLn("Purging " + databaseTreeRecord);
                    databaseTreeRecord.removeFromParent();
                }
            } else {
                String string = databaseTreeRecord.getLocalFileNameValue();
                String string2 = databaseTreeRecord.getLocalFileReferenceTypeValue();
                if (string2 != null && string2.equals("C")) {
                    try {
                        messageLogger.sendLn("Deleting file " + string);
                        if (!new File(string).delete()) {
                            messageLogger.sendLn("Failed to delete local copy of file " + string);
                        }
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Failed to delete local copy of file ", exception);
                        messageLogger.sendLn("Failed to delete local copy of file " + string);
                    }
                }
                if (this.earliestDatesIndexedBySourceFilePath != null) {
                    this.earliestDatesIndexedBySourceFilePath.remove(string);
                }
                messageLogger.sendLn("Purging " + databaseTreeRecord);
                databaseTreeRecord.removeFromParent();
            }
        }
    }

    protected boolean copyFromOriginalToCleanedPerformingAction(Vector vector, Date date, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread) throws DicomException, IOException {
        boolean bl = true;
        if (vector != null) {
            Date date2 = null;
            if (this.modifyDatesCheckBox.isSelected()) {
                try {
                    date2 = DateTimeAttribute.getDateFromFormattedString(this.modifyDatesTextField.getText().trim());
                    slf4jlogger.info("DicomCleaner.copyFromOriginalToCleanedPerformingAction(): epochForDateModification {}", date2);
                }
                catch (ParseException parseException) {
                    slf4jlogger.error("Could not get system epoch ", parseException);
                    date2 = new Date(0L);
                }
            }
            SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, 0, vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (string != null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaning " + string));
                    try {
                        Object object;
                        Object object2;
                        Object object3;
                        File file = new File(string);
                        DicomInputStream dicomInputStream = new DicomInputStream(file);
                        AttributeList attributeList = new AttributeList();
                        attributeList.setDecompressPixelData(false);
                        attributeList.read(dicomInputStream);
                        dicomInputStream.close();
                        attributeList.removeGroupLengthAttributes();
                        String string2 = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.TransferSyntaxUID, "1.2.840.10008.1.2.1");
                        if (string2.equals("1.2.840.10008.1.2")) {
                            string2 = "1.2.840.10008.1.2.1";
                        }
                        attributeList.removeMetaInformationHeaderAttributes();
                        if (this.removeClinicalTrialAttributesCheckBox.isSelected()) {
                            ClinicalTrialsAttributes.removeClinicalTrialsAttributes(attributeList);
                        }
                        if (this.removeIdentityCheckBox.isSelected()) {
                            ClinicalTrialsAttributes.removeOrNullIdentifyingAttributes(attributeList, 0, !this.removeDescriptionsCheckBox.isSelected(), !this.removeSeriesDescriptionsCheckBox.isSelected(), !this.removeProtocolNameCheckBox.isSelected(), !this.removeCharacteristicsCheckBox.isSelected(), !this.removeDeviceIdentityCheckBox.isSelected(), !this.removeInstitutionIdentityCheckBox.isSelected(), this.modifyDatesCheckBox.isSelected() ? 2 : 0, date2, date, this.removeAllStructuredContentCheckBox.isSelected() ? 1 : (this.removeUnsafeStructuredContentCheckBox.isSelected() ? 2 : 0), this.aggregateAgesOver89CheckBox.isSelected());
                        }
                        if (this.replacePatientNameCheckBox.isSelected()) {
                            object3 = this.replacementPatientNameTextField.getText().trim();
                            object2 = TagFromName.PatientName;
                            attributeList.remove((AttributeTag)object2);
                            object = new PersonNameAttribute((AttributeTag)object2);
                            ((Attribute)object).addValue((String)object3);
                            attributeList.put((AttributeTag)object2, (Attribute)object);
                        }
                        if (this.replacePatientIDCheckBox.isSelected()) {
                            object3 = this.replacementPatientIDTextField.getText().trim();
                            object2 = TagFromName.PatientID;
                            attributeList.remove((AttributeTag)object2);
                            object = new LongStringAttribute((AttributeTag)object2);
                            ((Attribute)object).addValue((String)object3);
                            attributeList.put((AttributeTag)object2, (Attribute)object);
                        }
                        if (this.replacePatientBirthDateCheckBox.isSelected()) {
                            object3 = this.replacementPatientBirthDateTextField.getText().trim();
                            object2 = TagFromName.PatientBirthDate;
                            attributeList.remove((AttributeTag)object2);
                            object = new DateAttribute((AttributeTag)object2);
                            ((Attribute)object).addValue((String)object3);
                            attributeList.put((AttributeTag)object2, (Attribute)object);
                        }
                        if (this.replaceAccessionNumberCheckBox.isSelected()) {
                            object3 = this.replacementAccessionNumberTextField.getText().trim();
                            object2 = TagFromName.AccessionNumber;
                            attributeList.remove((AttributeTag)object2);
                            object = new ShortStringAttribute((AttributeTag)object2);
                            ((Attribute)object).addValue((String)object3);
                            attributeList.put((AttributeTag)object2, (Attribute)object);
                        }
                        if (this.removePrivateCheckBox.isSelected()) {
                            attributeList.removeUnsafePrivateAttributes();
                            object3 = attributeList.get(TagFromName.DeidentificationMethod);
                            if (object3 != null) {
                                ((Attribute)object3).addValue("Unsafe private removed");
                            }
                            if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                                ((SequenceAttribute)object3).addItem(new CodedSequenceItem("113111", "DCM", "Retain Safe Private Option").getAttributeList());
                            }
                        } else {
                            object3 = attributeList.get(TagFromName.DeidentificationMethod);
                            if (object3 != null) {
                                ((Attribute)object3).addValue("All private retained");
                            }
                            if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                                ((SequenceAttribute)object3).addItem(new CodedSequenceItem("210002", "99PMP", "Retain all private elements").getAttributeList());
                            }
                        }
                        if (this.cleanUIDsCheckBox.isSelected()) {
                            ClinicalTrialsAttributes.remapUIDAttributes(attributeList);
                            object3 = attributeList.get(TagFromName.DeidentificationMethod);
                            if (object3 != null) {
                                ((Attribute)object3).addValue("UIDs remapped");
                            }
                            if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                                object2 = ((SequenceAttribute)object3).iterator();
                                while (object2.hasNext()) {
                                    CodedSequenceItem codedSequenceItem;
                                    object = (SequenceItem)object2.next();
                                    if (object == null || (codedSequenceItem = new CodedSequenceItem(((SequenceItem)object).getAttributeList())) == null) continue;
                                    String string3 = codedSequenceItem.getCodeValue();
                                    String string4 = codedSequenceItem.getCodingSchemeDesignator();
                                    if (string3 == null || !string3.equals("113110") || string4 == null || !string4.equals("DCM")) continue;
                                    object2.remove();
                                }
                            }
                            if ((object3 = (SequenceAttribute)attributeList.get(TagFromName.DeidentificationMethodCodeSequence)) != null) {
                                ((SequenceAttribute)object3).addItem(new CodedSequenceItem("210001", "99PMP", "Remap UIDs").getAttributeList());
                            }
                        }
                        if (this.addContributingEquipmentCheckBox.isSelected()) {
                            ClinicalTrialsAttributes.addContributingEquipmentSequence(attributeList, true, new CodedSequenceItem("109104", "DCM", "De-identifying Equipment"), "PixelMed", null, null, null, this.ourCalledAETitle, "DicomCleaner", null, DicomCleaner.getBuildDate(), "Cleaned");
                        }
                        FileMetaInformation.addFileMetaInformation(attributeList, string2, this.ourCalledAETitle);
                        attributeList.insertSuitableSpecificCharacterSetForAllStringValues();
                        object3 = File.createTempFile("clean", ".dcm");
                        ((File)object3).deleteOnExit();
                        attributeList.write((File)object3, string2, true, true);
                        messageLogger.sendLn("Cleaned " + string + " into " + ((File)object3).getCanonicalPath());
                        this.dstDatabase.insertObject(attributeList, ((File)object3).getCanonicalPath(), "C");
                    }
                    catch (Exception exception) {
                        System.err.println("DicomCleaner.copyFromOriginalToCleanedPerformingAction(): while cleaning " + string);
                        slf4jlogger.error("Cleaning failed for " + string, exception);
                        messageLogger.sendLn("Cleaning failed for " + string + " because " + exception.toString());
                        bl = false;
                    }
                }
                SafeProgressBarUpdaterThread.updateProgressBar(safeProgressBarUpdaterThread, i + 1);
            }
        }
        return bl;
    }

    protected static Date findEarliestDate(Map<String, Date> map, Vector<String> vector) {
        Date date = null;
        if (vector != null) {
            for (String string : vector) {
                Date date2 = map.get(string);
                if (date2 == null || date != null && !date2.before(date)) continue;
                date = date2;
            }
        }
        return date;
    }

    protected String makeNewFullyQualifiedInterchangeMediaInstancePathName(int n) throws IOException {
        return new File(rootNameForDicomInstanceFilesOnInterchangeMedia, filePrefixForDicomInstanceFilesOnInterchangeMedia + Integer.toString(n) + fileSuffixForDicomInstanceFilesOnInterchangeMedia).getPath();
    }

    protected String makeNewFullyQualifiedHierarchicalInstancePathName(String string) throws DicomException, IOException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(string, TagFromName.PixelData);
        String string2 = MoveDicomFilesIntoHierarchy.makeHierarchicalPathFromAttributes(attributeList);
        return new File(rootNameForDicomInstanceFilesOnInterchangeMedia, string2).getPath();
    }

    protected void setCurrentRemoteQuerySelection(AttributeList attributeList, Attribute attribute, AttributeList attributeList2) {
        Object object;
        this.currentRemoteQuerySelectionUniqueKeys = attributeList;
        this.currentRemoteQuerySelectionUniqueKey = attribute;
        this.currentRemoteQuerySelectionRetrieveAE = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.RetrieveAETitle)) != null) {
            this.currentRemoteQuerySelectionRetrieveAE = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionRetrieveAE == null && this.currentRemoteQueryInformationModel != null) {
            this.currentRemoteQuerySelectionRetrieveAE = this.currentRemoteQueryInformationModel.getCalledAETitle();
        }
        this.currentRemoteQuerySelectionLevel = null;
        if (attributeList2 != null && (object = attributeList2.get(TagFromName.QueryRetrieveLevel)) != null) {
            this.currentRemoteQuerySelectionLevel = ((Attribute)object).getSingleStringValueOrNull();
        }
        if (this.currentRemoteQuerySelectionLevel == null) {
            if (attribute != null && (object = attribute.getTag()) != null) {
                if (((AttributeTag)object).equals(TagFromName.PatientID)) {
                    this.currentRemoteQuerySelectionLevel = "PATIENT";
                } else if (((AttributeTag)object).equals(TagFromName.StudyInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "STUDY";
                } else if (((AttributeTag)object).equals(TagFromName.SeriesInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "SERIES";
                } else if (((AttributeTag)object).equals(TagFromName.SOPInstanceUID)) {
                    this.currentRemoteQuerySelectionLevel = "IMAGE";
                }
            }
            slf4jlogger.info("DicomCleaner.setCurrentRemoteQuerySelection(): Guessed missing currentRemoteQuerySelectionLevel to be {}", this.currentRemoteQuerySelectionLevel);
        }
    }

    protected void performRetrieve(AttributeList attributeList, String string, String string2) {
        try {
            AttributeList attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
                AttributeTag attributeTag = TagFromName.QueryRetrieveLevel;
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(attributeTag);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList2.put(attributeTag, codeStringAttribute);
                this.currentRemoteQueryInformationModel.performHierarchicalMoveFrom(attributeList2, string2);
            }
        }
        catch (Exception exception) {
            slf4jlogger.error("Retrieve failed ", exception);
        }
    }

    private void updatePropertiesWithUIState() {
        Properties properties = this.getProperties();
        properties.setProperty(propertyName_CheckBoxReplacePatientNameIsSelected, Boolean.toString(this.replacePatientNameCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxReplacePatientIDIsSelected, Boolean.toString(this.replacePatientIDCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxReplacePatientBirthDateIsSelected, Boolean.toString(this.replacePatientBirthDateCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxReplaceAccessionNumberIsSelected, Boolean.toString(this.replaceAccessionNumberCheckBox.isSelected()));
        properties.setProperty(propertyName_ReplacementTextPatientName, this.replacementPatientNameTextField.getText().trim());
        properties.setProperty(propertyName_ReplacementTextPatientID, this.replacementPatientIDTextField.getText().trim());
        properties.setProperty(propertyName_ReplacementTextPatientBirthDate, this.replacementPatientBirthDateTextField.getText().trim());
        properties.setProperty(propertyName_ReplacementTextAccessionNumber, this.replacementAccessionNumberTextField.getText().trim());
        properties.setProperty(propertyName_CheckBoxModifyDatesIsSelected, Boolean.toString(this.modifyDatesCheckBox.isSelected()));
        properties.setProperty(propertyName_ModifyDatesEpoch, this.modifyDatesTextField.getText().trim());
        properties.setProperty(propertyName_CheckBoxRemoveIdentityIsSelected, Boolean.toString(this.removeIdentityCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveDescriptionsIsSelected, Boolean.toString(this.removeDescriptionsCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveSeriesDescriptionsIsSelected, Boolean.toString(this.removeSeriesDescriptionsCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveProtocolNameIsSelected, Boolean.toString(this.removeProtocolNameCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveCharacteristicsIsSelected, Boolean.toString(this.removeCharacteristicsCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveDeviceIdentityIsSelected, Boolean.toString(this.removeDeviceIdentityCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveInstitutionIdentityIsSelected, Boolean.toString(this.removeInstitutionIdentityCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxCleanUIDsIsSelected, Boolean.toString(this.cleanUIDsCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemovePrivateIsSelected, Boolean.toString(this.removePrivateCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxAddContributingEquipmentIsSelected, Boolean.toString(this.addContributingEquipmentCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveClinicalTrialAttributesIsSelected, Boolean.toString(this.removeClinicalTrialAttributesCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveAllStructuredContentIsSelected, Boolean.toString(this.removeAllStructuredContentCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxRemoveUnsafeStructuredContentIsSelected, Boolean.toString(this.removeUnsafeStructuredContentCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxZipExportIsSelected, Boolean.toString(this.zipExportCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxHierarchicalExportIsSelected, Boolean.toString(this.hierarchicalExportCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxAcceptAnyTransferSyntaxIsSelected, Boolean.toString(this.acceptAnyTransferSyntaxCheckBox.isSelected()));
        properties.setProperty(propertyName_CheckBoxAggregateAgesOver89IsSelected, Boolean.toString(this.aggregateAgesOver89CheckBox.isSelected()));
    }

    public DicomCleaner() throws DicomException, IOException {
        this((String)null);
    }

    public DicomCleaner(String string) throws DicomException, IOException {
        super(null, propertiesFileName);
        Serializable serializable;
        Serializable serializable2;
        JComponent jComponent;
        JComponent jComponent2;
        JComponent jComponent3;
        JComponent jComponent4;
        System.err.println("default Locale=" + Locale.getDefault());
        this.resourceBundle = ResourceBundle.getBundle(resourceBundleName);
        this.setTitle(this.resourceBundle.getString("applicationTitle"));
        Properties properties = this.getProperties();
        System.err.println("properties=" + properties);
        this.activateTemporaryDatabases();
        this.savedImagesFolder = new File(System.getProperty("java.io.tmpdir"));
        try {
            this.networkApplicationProperties = new NetworkApplicationProperties(properties, true);
        }
        catch (Exception exception) {
            slf4jlogger.error("Fetching network application properties failed ", exception);
            this.networkApplicationProperties = null;
        }
        NetworkApplicationInformationFederated networkApplicationInformationFederated = new NetworkApplicationInformationFederated();
        networkApplicationInformationFederated.startupAllKnownSourcesAndRegister(this.networkApplicationProperties);
        this.networkApplicationInformation = networkApplicationInformationFederated;
        this.activateStorageSCP();
        this.logger = new DialogMessageLogger("DicomCleaner Log", 512, 384, false, false, this.getBooleanPropertyOrDefaultAndAddIt(propertyName_ShowDateTime, false), this.getPropertyOrDefaultAndAddIt(propertyName_DateTimeFormat, ""));
        this.cursorChanger = new SafeCursorChanger(this);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    DicomCleaner.this.updatePropertiesWithUIState();
                    DicomCleaner.this.storeProperties("Edited and saved from user interface");
                }
                catch (Exception exception) {
                    slf4jlogger.error("Storing properties during shutdown failed ", exception);
                }
                if (DicomCleaner.this.networkApplicationInformation != null && DicomCleaner.this.networkApplicationInformation instanceof NetworkApplicationInformationFederated) {
                    ((NetworkApplicationInformationFederated)DicomCleaner.this.networkApplicationInformation).removeAllSources();
                }
            }
        });
        boolean bl = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowUserQuery, true);
        boolean bl2 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowNetworkConfiguration, true);
        boolean bl3 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowChangeDatesAndTimes, true);
        boolean bl4 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveIdentityCheckBox, true);
        boolean bl5 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveDescriptionsCheckBox, true);
        boolean bl6 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveSeriesDescriptionsCheckBox, true);
        boolean bl7 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveProtocolNameCheckBox, true);
        boolean bl8 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveCharacteristicsCheckBox, true);
        boolean bl9 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveDeviceIdentityCheckBox, true);
        boolean bl10 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveInstitutionIdentityCheckBox, true);
        boolean bl11 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowCleanUIDsCheckBox, true);
        boolean bl12 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemovePrivateCheckBox, true);
        boolean bl13 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowAddContributingEquipmentCheckBox, true);
        boolean bl14 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveClinicalTrialAttributesCheckBox, true);
        boolean bl15 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveAllStructuredContentCheckBox, true);
        boolean bl16 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowRemoveUnsafeStructuredContentCheckBox, true);
        boolean bl17 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowZipExportCheckBox, true);
        boolean bl18 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowHierarchicalExportCheckBox, true);
        boolean bl19 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowAcceptAnyTransferSyntaxCheckBox, true);
        boolean bl20 = this.getBooleanPropertyOrDefaultAndAddIt(propertyName_AllowAggregateAgesOver89CheckBox, true);
        this.randomReplacementPatientNamePrefix = this.getPropertyOrDefaultAndAddIt(propertyName_RandomReplacementPatientNamePrefix, this.resourceBundle.getString("defaultRandomReplacementPatientNamePrefix"));
        this.randomReplacementPatientIDLength = this.getIntegerPropertyOrDefaultAndAddIt(propertyName_RandomReplacementPatientIDLength, default_RandomReplacementPatientIDLength);
        this.randomReplacementAccessionNumberLength = this.getIntegerPropertyOrDefaultAndAddIt(propertyName_RandomReplacementAccessionNumberLength, default_RandomReplacementAccessionNumberLength);
        this.srcDatabasePanel = new JPanel();
        this.dstDatabasePanel = new JPanel();
        this.remoteQueryRetrievePanel = bl ? new JPanel() : null;
        this.srcDatabasePanel.setLayout(new GridLayout(1, 1));
        this.dstDatabasePanel.setLayout(new GridLayout(1, 1));
        if (bl) {
            this.remoteQueryRetrievePanel.setLayout(new GridLayout(1, 1));
        }
        OurSourceDatabaseTreeBrowser ourSourceDatabaseTreeBrowser = new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
        OurDestinationDatabaseTreeBrowser ourDestinationDatabaseTreeBrowser = new OurDestinationDatabaseTreeBrowser(this.dstDatabase, this.dstDatabasePanel);
        Border border = BorderFactory.createEtchedBorder();
        JSplitPane jSplitPane = null;
        JComponent jComponent5 = new JSplitPane(1, this.srcDatabasePanel, this.dstDatabasePanel);
        ((JSplitPane)jComponent5).setOneTouchExpandable(true);
        ((JSplitPane)jComponent5).setResizeWeight(0.5);
        JComponent jComponent6 = null;
        if (bl) {
            jComponent6 = new JSplitPane(1, this.remoteQueryRetrievePanel, jComponent5);
            ((JSplitPane)jComponent6).setOneTouchExpandable(true);
            ((JSplitPane)jComponent6).setResizeWeight(0.4);
        }
        jSplitPane = jComponent6 == null ? jComponent5 : jComponent6;
        jComponent5 = new JPanel();
        jComponent5.setLayout(new FlowLayout(1));
        jComponent5.setBorder(border);
        if (bl2) {
            jComponent6 = new JButton(this.resourceBundle.getString("configureButtonLabelText"));
            jComponent6.setToolTipText(this.resourceBundle.getString("configureButtonToolTipText"));
            jComponent5.add(jComponent6);
            ((AbstractButton)jComponent6).addActionListener(new ConfigureActionListener());
        }
        jComponent6 = new JButton(this.resourceBundle.getString("logButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("logButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new LogActionListener());
        if (bl) {
            jComponent6 = new JButton(this.resourceBundle.getString("queryButtonLabelText"));
            jComponent6.setToolTipText(this.resourceBundle.getString("queryButtonToolTipText"));
            jComponent5.add(jComponent6);
            ((AbstractButton)jComponent6).addActionListener(new QueryActionListener());
        }
        if (bl) {
            jComponent6 = new JButton(this.resourceBundle.getString("retrieveButtonLabelText"));
            jComponent6.setToolTipText(this.resourceBundle.getString("retrieveButtonToolTipText"));
            jComponent5.add(jComponent6);
            ((AbstractButton)jComponent6).addActionListener(new RetrieveActionListener());
        }
        jComponent6 = new JButton(this.resourceBundle.getString("importButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("importButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new ImportActionListener());
        jComponent6 = new JButton(this.resourceBundle.getString("cleanButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("cleanButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new CleanActionListener());
        jComponent6 = new JButton(this.resourceBundle.getString("blackoutButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("blackoutButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new BlackoutActionListener());
        jComponent6 = new JButton(this.resourceBundle.getString("exportButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("exportButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new ExportActionListener());
        jComponent6 = new JButton(this.resourceBundle.getString("sendButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("sendButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new SendActionListener());
        jComponent6 = new JButton(this.resourceBundle.getString("purgeButtonLabelText"));
        jComponent6.setToolTipText(this.resourceBundle.getString("purgeButtonToolTipText"));
        jComponent5.add(jComponent6);
        ((AbstractButton)jComponent6).addActionListener(new PurgeActionListener());
        jComponent6 = null;
        if (bl) {
            jComponent6 = new JPanel();
            jComponent6.setLayout(new FlowLayout(0));
            jComponent6.setBorder(border);
            jComponent4 = new JLabel(this.resourceBundle.getString("queryIntroductionLabelText") + " -");
            jComponent6.add(jComponent4);
            jComponent3 = new JLabel(this.resourceBundle.getString("queryPatientNameLabelText") + ":");
            jComponent3.setToolTipText(this.resourceBundle.getString("queryPatientNameToolTipText"));
            jComponent6.add(jComponent3);
            this.queryFilterPatientNameTextField = new JTextField("", textFieldLengthForQueryPatientName);
            jComponent6.add(this.queryFilterPatientNameTextField);
            jComponent2 = new JLabel(this.resourceBundle.getString("queryPatientIDLabelText") + ":");
            jComponent2.setToolTipText(this.resourceBundle.getString("queryPatientIDToolTipText"));
            jComponent6.add(jComponent2);
            this.queryFilterPatientIDTextField = new JTextField("", textFieldLengthForQueryPatientID);
            jComponent6.add(this.queryFilterPatientIDTextField);
            jComponent = new JLabel(this.resourceBundle.getString("queryStudyDateLabelText") + ":");
            jComponent.setToolTipText(this.resourceBundle.getString("queryStudyDateToolTipText"));
            jComponent6.add(jComponent);
            this.queryFilterStudyDateTextField = new JTextField("", textFieldLengthForQueryStudyDate);
            jComponent6.add(this.queryFilterStudyDateTextField);
            serializable2 = new JLabel(this.resourceBundle.getString("queryAccessionNumberLabelText") + ":");
            ((JComponent)serializable2).setToolTipText(this.resourceBundle.getString("queryAccessionNumberToolTipText"));
            jComponent6.add((Component)serializable2);
            this.queryFilterAccessionNumberTextField = new JTextField("", textFieldLengthForQueryAccessionNumber);
            jComponent6.add(this.queryFilterAccessionNumberTextField);
        }
        jComponent4 = new JPanel();
        jComponent4.setLayout(new FlowLayout(0));
        jComponent4.setBorder(border);
        jComponent3 = new JLabel(this.resourceBundle.getString("replacementIntroductionLabelText") + " -");
        jComponent4.add(jComponent3);
        this.replacePatientNameCheckBox = new JCheckBox(this.resourceBundle.getString("replacementPatientNameLabelText") + ":");
        this.replacePatientNameCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxReplacePatientNameIsSelected, default_CheckBoxReplacePatientNameIsSelected));
        this.replacePatientNameCheckBox.setToolTipText(this.resourceBundle.getString("replacementPatientNameToolTipText"));
        jComponent4.add(this.replacePatientNameCheckBox);
        this.replacementPatientNameTextField = new JTextField(this.getPropertyOrDefaultAndAddIt(propertyName_ReplacementTextPatientName, this.resourceBundle.getString("defaultReplacementPatientName")), textFieldLengthForReplacementPatientName);
        jComponent4.add(this.replacementPatientNameTextField);
        this.replacePatientIDCheckBox = new JCheckBox(this.resourceBundle.getString("replacementPatientIDLabelText") + ":");
        this.replacePatientIDCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxReplacePatientIDIsSelected, default_CheckBoxReplacePatientIDIsSelected));
        this.replacePatientIDCheckBox.setToolTipText(this.resourceBundle.getString("replacementPatientIDToolTipText"));
        jComponent4.add(this.replacePatientIDCheckBox);
        this.replacementPatientIDTextField = new JTextField(this.getPropertyOrDefaultAndAddIt(propertyName_ReplacementTextPatientID, this.resourceBundle.getString("defaultReplacementPatientID")), textFieldLengthForReplacementPatientID);
        jComponent4.add(this.replacementPatientIDTextField);
        this.replacePatientBirthDateCheckBox = new JCheckBox(this.resourceBundle.getString("replacementPatientBirthDateLabelText") + ":");
        this.replacePatientBirthDateCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxReplacePatientBirthDateIsSelected, default_CheckBoxReplacePatientBirthDateIsSelected));
        this.replacePatientBirthDateCheckBox.setToolTipText(this.resourceBundle.getString("replacementPatientBirthDateToolTipText"));
        jComponent4.add(this.replacePatientBirthDateCheckBox);
        this.replacementPatientBirthDateTextField = new JTextField(this.getPropertyOrDefaultAndAddIt(propertyName_ReplacementTextPatientBirthDate, this.resourceBundle.getString("defaultReplacementPatientBirthDate")), textFieldLengthForReplacementPatientBirthDate);
        jComponent4.add(this.replacementPatientBirthDateTextField);
        this.replaceAccessionNumberCheckBox = new JCheckBox(this.resourceBundle.getString("replacementAccessionNumberLabelText") + ":");
        this.replaceAccessionNumberCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxReplaceAccessionNumberIsSelected, default_CheckBoxReplaceAccessionNumberIsSelected));
        this.replaceAccessionNumberCheckBox.setToolTipText(this.resourceBundle.getString("replacementAccessionNumberToolTipText"));
        jComponent4.add(this.replaceAccessionNumberCheckBox);
        this.replacementAccessionNumberTextField = new JTextField(this.getPropertyOrDefaultAndAddIt(propertyName_ReplacementTextAccessionNumber, this.resourceBundle.getString("defaultReplacementAccessionNumber")), textFieldLengthForReplacementAccessionNumber);
        jComponent4.add(this.replacementAccessionNumberTextField);
        jComponent2 = new JButton(this.resourceBundle.getString("randomReplacementButtonLabelText"));
        jComponent2.setToolTipText(this.resourceBundle.getString("randomReplacementButtonToolTipText"));
        jComponent4.add(jComponent2);
        ((AbstractButton)jComponent2).addActionListener(new RandomReplacementActionListener());
        jComponent = new JButton(this.resourceBundle.getString("defaultReplacementButtonLabelText"));
        jComponent.setToolTipText(this.resourceBundle.getString("defaultReplacementButtonToolTipText"));
        jComponent4.add(jComponent);
        ((AbstractButton)jComponent).addActionListener(new DefaultReplacementActionListener());
        this.modifyDatesCheckBox = new JCheckBox(this.resourceBundle.getString("modifyDatesLabelText") + ":");
        this.modifyDatesCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxModifyDatesIsSelected, default_CheckBoxModifyDatesIsSelected));
        this.modifyDatesCheckBox.setToolTipText(this.resourceBundle.getString("modifyDatesToolTipText"));
        this.modifyDatesTextField = new JTextField(this.getPropertyOrDefaultAndAddIt(propertyName_ModifyDatesEpoch, this.resourceBundle.getString("defaultModifyDatesEpoch")), textFieldLengthForModifyDates);
        jComponent3 = null;
        if (bl3) {
            jComponent3 = new JPanel();
            jComponent3.setLayout(new FlowLayout(0));
            jComponent3.setBorder(border);
            jComponent2 = new JLabel(this.resourceBundle.getString("modifyDatesIntroductionLabelText") + " -");
            jComponent3.add(jComponent2);
            jComponent3.add(this.modifyDatesCheckBox);
            jComponent3.add(this.modifyDatesTextField);
            jComponent = new JButton(this.resourceBundle.getString("earliestYearButtonLabelText"));
            jComponent.setToolTipText(this.resourceBundle.getString("earliestYearButtonToolTipText"));
            jComponent3.add(jComponent);
            ((AbstractButton)jComponent).addActionListener(new EarliestYearActionListener());
            serializable2 = new JButton(this.resourceBundle.getString("randomYearButtonLabelText"));
            ((JComponent)serializable2).setToolTipText(this.resourceBundle.getString("randomYearButtonToolTipText"));
            jComponent3.add((Component)serializable2);
            ((AbstractButton)serializable2).addActionListener(new RandomYearActionListener());
            serializable = new JButton(this.resourceBundle.getString("defaultYearButtonLabelText"));
            ((JComponent)serializable).setToolTipText(this.resourceBundle.getString("defaultYearButtonToolTipText"));
            jComponent3.add((Component)serializable);
            ((AbstractButton)serializable).addActionListener(new DefaultYearActionListener());
        }
        jComponent2 = new JPanel();
        jComponent2.setLayout(new GridLayout(0, 4));
        jComponent2.setBorder(border);
        this.removeIdentityCheckBox = new JCheckBox(this.resourceBundle.getString("removeIdentityLabelText"));
        this.removeIdentityCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveIdentityIsSelected, default_CheckBoxRemoveIdentityIsSelected));
        if (bl4) {
            jComponent2.add(this.removeIdentityCheckBox);
        }
        this.removeDescriptionsCheckBox = new JCheckBox(this.resourceBundle.getString("removeDescriptionsLabelText"));
        this.removeDescriptionsCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveDescriptionsIsSelected, default_CheckBoxRemoveDescriptionsIsSelected));
        if (bl5) {
            jComponent2.add(this.removeDescriptionsCheckBox);
        }
        this.removeSeriesDescriptionsCheckBox = new JCheckBox(this.resourceBundle.getString("removeSeriesDescriptionsLabelText"));
        this.removeSeriesDescriptionsCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveSeriesDescriptionsIsSelected, default_CheckBoxRemoveSeriesDescriptionsIsSelected));
        if (bl6) {
            jComponent2.add(this.removeSeriesDescriptionsCheckBox);
        }
        this.removeProtocolNameCheckBox = new JCheckBox(this.resourceBundle.getString("removeProtocolNameLabelText"));
        this.removeProtocolNameCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveProtocolNameIsSelected, default_CheckBoxRemoveProtocolNameIsSelected));
        if (bl7) {
            jComponent2.add(this.removeProtocolNameCheckBox);
        }
        this.removeCharacteristicsCheckBox = new JCheckBox(this.resourceBundle.getString("removeCharacteristicsLabelText"));
        this.removeCharacteristicsCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveCharacteristicsIsSelected, default_CheckBoxRemoveCharacteristicsIsSelected));
        if (bl8) {
            jComponent2.add(this.removeCharacteristicsCheckBox);
        }
        this.cleanUIDsCheckBox = new JCheckBox(this.resourceBundle.getString("cleanUIDsLabelText"));
        this.cleanUIDsCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxCleanUIDsIsSelected, default_CheckBoxCleanUIDsIsSelected));
        if (bl11) {
            jComponent2.add(this.cleanUIDsCheckBox);
        }
        this.removePrivateCheckBox = new JCheckBox(this.resourceBundle.getString("removePrivateLabelText"));
        this.removePrivateCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemovePrivateIsSelected, default_CheckBoxRemovePrivateIsSelected));
        if (bl12) {
            jComponent2.add(this.removePrivateCheckBox);
        }
        this.removeDeviceIdentityCheckBox = new JCheckBox(this.resourceBundle.getString("removeDeviceIdentityLabelText"));
        this.removeDeviceIdentityCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveDeviceIdentityIsSelected, default_CheckBoxRemoveDeviceIdentityIsSelected));
        if (bl9) {
            jComponent2.add(this.removeDeviceIdentityCheckBox);
        }
        this.removeInstitutionIdentityCheckBox = new JCheckBox(this.resourceBundle.getString("removeInstitutionIdentityLabelText"));
        this.removeInstitutionIdentityCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveInstitutionIdentityIsSelected, default_CheckBoxRemoveInstitutionIdentityIsSelected));
        if (bl10) {
            jComponent2.add(this.removeInstitutionIdentityCheckBox);
        }
        this.removeClinicalTrialAttributesCheckBox = new JCheckBox(this.resourceBundle.getString("removeClinicalTrialAttributesLabelText"));
        this.removeClinicalTrialAttributesCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveClinicalTrialAttributesIsSelected, default_CheckBoxRemoveClinicalTrialAttributesIsSelected));
        if (bl14) {
            jComponent2.add(this.removeClinicalTrialAttributesCheckBox);
        }
        this.removeAllStructuredContentCheckBox = new JCheckBox(this.resourceBundle.getString("removeAllStructuredContentLabelText"));
        this.removeAllStructuredContentCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveAllStructuredContentIsSelected, default_CheckBoxRemoveAllStructuredContentIsSelected));
        if (bl15) {
            jComponent2.add(this.removeAllStructuredContentCheckBox);
        }
        this.removeUnsafeStructuredContentCheckBox = new JCheckBox(this.resourceBundle.getString("removeUnsafeStructuredContentLabelText"));
        this.removeUnsafeStructuredContentCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxRemoveUnsafeStructuredContentIsSelected, default_CheckBoxRemoveUnsafeStructuredContentIsSelected));
        if (bl16) {
            jComponent2.add(this.removeUnsafeStructuredContentCheckBox);
        }
        this.addContributingEquipmentCheckBox = new JCheckBox(this.resourceBundle.getString("addContributingEquipmentLabelText"));
        this.addContributingEquipmentCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxAddContributingEquipmentIsSelected, default_CheckBoxAddContributingEquipmentIsSelected));
        if (bl13) {
            jComponent2.add(this.addContributingEquipmentCheckBox);
        }
        this.zipExportCheckBox = new JCheckBox(this.resourceBundle.getString("zipExportLabelText"));
        this.zipExportCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxZipExportIsSelected, default_CheckBoxZipExportIsSelected));
        if (bl17) {
            jComponent2.add(this.zipExportCheckBox);
        }
        this.hierarchicalExportCheckBox = new JCheckBox(this.resourceBundle.getString("hierarchicalExportLabelText"));
        this.hierarchicalExportCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxHierarchicalExportIsSelected, default_CheckBoxHierarchicalExportIsSelected));
        this.hierarchicalExportCheckBox.setToolTipText(this.resourceBundle.getString("hierarchicalExportToolTipText"));
        if (bl18) {
            jComponent2.add(this.hierarchicalExportCheckBox);
        }
        this.acceptAnyTransferSyntaxCheckBox = new JCheckBox(this.resourceBundle.getString("acceptAnyTransferSyntaxLabelText"));
        this.acceptAnyTransferSyntaxCheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxAcceptAnyTransferSyntaxIsSelected, default_CheckBoxAcceptAnyTransferSyntaxIsSelected));
        this.acceptAnyTransferSyntaxCheckBox.setToolTipText(this.resourceBundle.getString("acceptAnyTransferSyntaxToolTipText"));
        if (bl19) {
            jComponent2.add(this.acceptAnyTransferSyntaxCheckBox);
        }
        this.aggregateAgesOver89CheckBox = new JCheckBox(this.resourceBundle.getString("aggregateAgesOver89CheckBoxLabelText"));
        this.aggregateAgesOver89CheckBox.setSelected(this.getBooleanPropertyOrDefaultAndAddIt(propertyName_CheckBoxAggregateAgesOver89IsSelected, default_CheckBoxAggregateAgesOver89IsSelected));
        this.aggregateAgesOver89CheckBox.setToolTipText(this.resourceBundle.getString("aggregateAgesOver89CheckBoxToolTipText"));
        if (bl20) {
            jComponent2.add(this.aggregateAgesOver89CheckBox);
        }
        jComponent = new JPanel();
        serializable2 = new GridBagLayout();
        jComponent.setLayout((LayoutManager)((Object)serializable2));
        serializable = this.getStatusBar();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        ((GridBagLayout)serializable2).setConstraints((Component)serializable, gridBagConstraints);
        jComponent.add((Component)serializable);
        serializable = new JProgressBar();
        ((JProgressBar)serializable).setStringPainted(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridwidth = 0;
        ((GridBagLayout)serializable2).setConstraints((Component)serializable, gridBagConstraints);
        jComponent.add((Component)serializable);
        this.progressBarUpdater = new SafeProgressBarUpdaterThread((JProgressBar)serializable);
        serializable2 = new JPanel();
        serializable = new GridBagLayout();
        ((Container)serializable2).setLayout((LayoutManager)((Object)serializable));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        ((GridBagLayout)serializable).setConstraints(jSplitPane, gridBagConstraints);
        ((Container)serializable2).add(jSplitPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent5, gridBagConstraints);
        ((Container)serializable2).add(jComponent5);
        if (jComponent6 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)serializable).setConstraints(jComponent6, gridBagConstraints);
            ((Container)serializable2).add(jComponent6);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent4, gridBagConstraints);
        ((Container)serializable2).add(jComponent4);
        if (jComponent3 != null) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            ((GridBagLayout)serializable).setConstraints(jComponent3, gridBagConstraints);
            ((Container)serializable2).add(jComponent3);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent2, gridBagConstraints);
        ((Container)serializable2).add(jComponent2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        ((GridBagLayout)serializable).setConstraints(jComponent, gridBagConstraints);
        ((Container)serializable2).add(jComponent);
        serializable = this.getContentPane();
        ((Container)serializable).add((Component)serializable2);
        this.pack();
        this.setVisible(true);
        if (string != null && string.length() > 0) {
            new Thread(new ImportWorker(string, this.srcDatabase, this.srcDatabasePanel)).start();
        }
    }

    public static void main(String[] stringArray) {
        try {
            String string = null;
            if (stringArray.length > 0) {
                string = stringArray[0];
            }
            new DicomCleaner(string);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    protected class DefaultReplacementActionListener
    implements ActionListener {
        protected DefaultReplacementActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomCleaner.this.replacementPatientIDTextField.setText(DicomCleaner.this.resourceBundle.getString("defaultReplacementPatientID"));
            DicomCleaner.this.replacementPatientBirthDateTextField.setText(DicomCleaner.this.resourceBundle.getString("defaultReplacementPatientBirthDate"));
            DicomCleaner.this.replacementPatientNameTextField.setText(DicomCleaner.this.resourceBundle.getString("defaultReplacementPatientName"));
            DicomCleaner.this.replacementAccessionNumberTextField.setText(DicomCleaner.this.resourceBundle.getString("defaultReplacementAccessionNumber"));
        }
    }

    protected class RandomReplacementActionListener
    implements ActionListener {
        protected RandomReplacementActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            long l = (long)(Math.random() * Math.pow(10.0, DicomCleaner.this.randomReplacementPatientIDLength));
            String string = StringUtilities.zeroPadPositiveInteger(Long.toString(l), DicomCleaner.this.randomReplacementPatientIDLength);
            DicomCleaner.this.replacementPatientIDTextField.setText(string);
            DicomCleaner.this.replacementPatientNameTextField.setText(DicomCleaner.this.randomReplacementPatientNamePrefix + string);
            int n = (int)(Math.random() * 40.0 + 1970.0);
            String string2 = Integer.toString(n) + "0101";
            DicomCleaner.this.replacementPatientBirthDateTextField.setText(string2);
            long l2 = (long)(Math.random() * Math.pow(10.0, DicomCleaner.this.randomReplacementAccessionNumberLength));
            DicomCleaner.this.replacementAccessionNumberTextField.setText(StringUtilities.zeroPadPositiveInteger(Long.toString(l2), DicomCleaner.this.randomReplacementAccessionNumberLength));
        }
    }

    protected class DefaultYearActionListener
    implements ActionListener {
        protected DefaultYearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomCleaner.this.modifyDatesTextField.setText(DicomCleaner.this.resourceBundle.getString("defaultModifyDatesEpoch"));
        }
    }

    protected class RandomYearActionListener
    implements ActionListener {
        protected RandomYearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = (int)(Math.random() * 100.0 + 1970.0);
            DicomCleaner.this.modifyDatesTextField.setText(Integer.toString(n) + "0101");
        }
    }

    protected class EarliestYearActionListener
    implements ActionListener {
        protected EarliestYearActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.earliestDatesIndexedBySourceFilePath != null && DicomCleaner.this.currentSourceFilePathSelections != null) {
                    Date date = DicomCleaner.findEarliestDate(DicomCleaner.this.earliestDatesIndexedBySourceFilePath, DicomCleaner.this.currentSourceFilePathSelections);
                    String string = DateTimeAttribute.getFormattedString(date, TimeZone.getTimeZone("GMT")).substring(0, 4);
                    DicomCleaner.this.modifyDatesTextField.setText(string + "0101");
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("Earliest year failed ", exception);
            }
        }
    }

    protected class CancelActionListener
    implements ActionListener {
        protected CancelActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.activeThread != null) {
                    DicomCleaner.this.activeThread.interrupt();
                }
            }
            catch (Exception exception) {
                slf4jlogger.error("Cancel failed ", exception);
            }
        }
    }

    protected class ConfigureActionListener
    implements ActionListener {
        protected ConfigureActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.storageSOPClassSCPDispatcher != null) {
                    DicomCleaner.this.storageSOPClassSCPDispatcher.shutdown();
                }
                new NetworkApplicationConfigurationDialog(DicomCleaner.this.getContentPane(), DicomCleaner.this.networkApplicationInformation, DicomCleaner.this.networkApplicationProperties);
                DicomCleaner.this.networkApplicationProperties.getProperties(DicomCleaner.this.getProperties());
                DicomCleaner.this.updatePropertiesWithUIState();
                DicomCleaner.this.storeProperties("Edited and saved from user interface");
                DicomCleaner.this.activateStorageSCP();
            }
            catch (Exception exception) {
                slf4jlogger.error("Configure failed ", exception);
            }
        }
    }

    protected class LogActionListener
    implements ActionListener {
        protected LogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DicomCleaner.this.logger instanceof DialogMessageLogger) {
                ((DialogMessageLogger)DicomCleaner.this.logger).setVisible(true);
            }
        }
    }

    protected class RetrieveActionListener
    implements ActionListener {
        protected RetrieveActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomCleaner.this.activeThread = new Thread(new RetrieveWorker());
            DicomCleaner.this.activeThread.start();
        }
    }

    protected class RetrieveWorker
    implements Runnable {
        RetrieveWorker() {
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            String string = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
            if (DicomCleaner.this.currentRemoteQuerySelectionLevel == null) {
                QueryTreeRecord queryTreeRecord = DicomCleaner.this.currentRemoteQuerySelectionQueryTreeRecord;
                if (queryTreeRecord != null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving everything from " + string));
                    DicomCleaner.this.logger.sendLn("Retrieving everything from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                    Enumeration enumeration = queryTreeRecord.children();
                    if (enumeration != null) {
                        int n = queryTreeRecord.getChildCount();
                        SafeProgressBarUpdaterThread.startProgressBar(DicomCleaner.this.progressBarUpdater, n);
                        int n2 = 0;
                        while (enumeration.hasMoreElements()) {
                            QueryTreeRecord queryTreeRecord2 = (QueryTreeRecord)enumeration.nextElement();
                            if (queryTreeRecord2 == null) continue;
                            DicomCleaner.this.setCurrentRemoteQuerySelection(queryTreeRecord2.getUniqueKeys(), queryTreeRecord2.getUniqueKey(), queryTreeRecord2.getAllAttributesReturnedInIdentifier());
                            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                            DicomCleaner.this.logger.sendLn("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                            DicomCleaner.this.performRetrieve(DicomCleaner.this.currentRemoteQuerySelectionUniqueKeys, DicomCleaner.this.currentRemoteQuerySelectionLevel, DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
                            SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, ++n2);
                        }
                        SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
                    }
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
                    DicomCleaner.this.setCurrentRemoteQuerySelection(null, null, null);
                }
            } else {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Retrieving " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string));
                DicomCleaner.this.logger.sendLn("Request retrieval of " + DicomCleaner.this.currentRemoteQuerySelectionLevel + " " + DicomCleaner.this.currentRemoteQuerySelectionUniqueKey.getSingleStringValueOrEmptyString() + " from " + string + " (" + DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE + ")");
                SafeProgressBarUpdaterThread.startProgressBar(DicomCleaner.this.progressBarUpdater, 1);
                DicomCleaner.this.performRetrieve(DicomCleaner.this.currentRemoteQuerySelectionUniqueKeys, DicomCleaner.this.currentRemoteQuerySelectionLevel, DicomCleaner.this.currentRemoteQuerySelectionRetrieveAE);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending retrieval request"));
                SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            }
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class QueryActionListener
    implements ActionListener {
        protected QueryActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Properties properties = DicomCleaner.this.getProperties();
            String string = properties.getProperty(propertyName_DicomCurrentlySelectedQueryTargetAE);
            string = DicomCleaner.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(DicomCleaner.this.resourceBundle.getString("querySelectMessage"), DicomCleaner.this.resourceBundle.getString("querySelectDialogTitle") + " ...", string);
            DicomCleaner.this.remoteQueryRetrievePanel.removeAll();
            if (string != null) {
                DicomCleaner.this.setCurrentRemoteQueryInformationModel(string);
                if (DicomCleaner.this.currentRemoteQueryInformationModel == null) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cannot query " + string));
                } else {
                    try {
                        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
                        AttributeList attributeList = new AttributeList();
                        AttributeTag attributeTag = TagFromName.PatientName;
                        StringAttribute stringAttribute = new PersonNameAttribute(attributeTag, specificCharacterSet);
                        String string2 = DicomCleaner.this.queryFilterPatientNameTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientID;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        string2 = DicomCleaner.this.queryFilterPatientIDTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.AccessionNumber;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        string2 = DicomCleaner.this.queryFilterAccessionNumberTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientBirthDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientSex;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyID;
                        stringAttribute = new ShortStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ModalitiesInStudy;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        string2 = DicomCleaner.this.queryFilterStudyDateTextField.getText().trim();
                        if (string2 != null && string2.length() > 0) {
                            ((Attribute)stringAttribute).addValue(string2);
                        }
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.PatientAge;
                        stringAttribute = new AgeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDescription;
                        stringAttribute = new LongStringAttribute(attributeTag, specificCharacterSet);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.Modality;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.InstanceNumber;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentDate;
                        stringAttribute = new DateAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ContentTime;
                        stringAttribute = new TimeAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.ImageType;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.NumberOfFrames;
                        stringAttribute = new IntegerStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.StudyInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SeriesInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPInstanceUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SOPClassUID;
                        stringAttribute = new UniqueIdentifierAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        attributeTag = TagFromName.SpecificCharacterSet;
                        stringAttribute = new CodeStringAttribute(attributeTag);
                        attributeList.put(attributeTag, stringAttribute);
                        ((Attribute)stringAttribute).addValue("ISO_IR 100");
                        DicomCleaner.this.activeThread = new Thread(new QueryWorker(attributeList));
                        DicomCleaner.this.activeThread.start();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("Query to {} failed", string, exception);
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string + " failed"));
                    }
                }
            }
            DicomCleaner.this.remoteQueryRetrievePanel.validate();
        }
    }

    protected class QueryWorker
    implements Runnable {
        AttributeList filter;

        QueryWorker(AttributeList attributeList) {
            this.filter = attributeList;
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            String string = DicomCleaner.this.currentRemoteQueryInformationModel.getCalledAETitle();
            String string2 = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Performing query on " + string2));
            DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") starting");
            try {
                QueryTreeModel queryTreeModel = DicomCleaner.this.currentRemoteQueryInformationModel.performHierarchicalQuery(this.filter);
                new OurQueryTreeBrowser(DicomCleaner.this.currentRemoteQueryInformationModel, queryTreeModel, DicomCleaner.this.remoteQueryRetrievePanel);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying " + string2));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Query to " + string2 + " failed " + exception));
                DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") failed due to" + exception);
                slf4jlogger.error("", exception);
            }
            DicomCleaner.this.logger.sendLn("Query to " + string2 + " (" + string + ") complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done querying  " + string2));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurQueryTreeBrowser
    extends QueryTreeBrowser {
        OurQueryTreeBrowser(QueryInformationModel queryInformationModel, QueryTreeModel queryTreeModel, Container container) throws DicomException {
            super(queryInformationModel, queryTreeModel, container);
        }

        @Override
        protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedLevel() {
            return new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                    if (treePath != null && (object = treePath.getLastPathComponent()) instanceof QueryTreeRecord) {
                        QueryTreeRecord queryTreeRecord = (QueryTreeRecord)object;
                        DicomCleaner.this.setCurrentRemoteQuerySelection(queryTreeRecord.getUniqueKeys(), queryTreeRecord.getUniqueKey(), queryTreeRecord.getAllAttributesReturnedInIdentifier());
                        DicomCleaner.this.currentRemoteQuerySelectionQueryTreeRecord = queryTreeRecord;
                    }
                }
            };
        }
    }

    protected class BlackoutActionListener
    implements ActionListener {
        protected BlackoutActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Blackout starting");
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                try {
                    int n = DicomCleaner.this.currentDestinationFilePathSelections.size();
                    String[] stringArray = new String[n];
                    for (int i = 0; i < n; ++i) {
                        stringArray[i] = (String)DicomCleaner.this.currentDestinationFilePathSelections.get(i);
                    }
                    new OurDicomImageBlackout(stringArray, 4, DicomCleaner.this.ourCalledAETitle);
                }
                catch (Exception exception) {
                    slf4jlogger.error("Dicom Image Blackout failed ", exception);
                }
            }
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurDicomImageBlackout
    extends DicomImageBlackout {
        OurDicomImageBlackout(String[] stringArray, int n, String string) {
            super(stringArray, null, n);
            this.statusNotificationHandler = new ApplicationStatusChangeEventNotificationHandler();
            this.ourAETitle = string;
        }

        public class ApplicationStatusChangeEventNotificationHandler
        extends DicomImageBlackout.StatusNotificationHandler {
            public ApplicationStatusChangeEventNotificationHandler() {
                super(OurDicomImageBlackout.this);
            }

            @Override
            public void notify(int n, String string, Throwable throwable) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Blackout " + string));
                DicomCleaner.this.logger.sendLn("Blackout " + string);
                System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): status = " + n);
                System.err.println("DicomImageBlackout.DefaultStatusNotificationHandler.notify(): message = " + string);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
    }

    protected class SendActionListener
    implements ActionListener {
        protected SendActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                Properties properties = DicomCleaner.this.getProperties();
                String string = properties.getProperty(propertyName_DicomCurrentlySelectedStorageTargetAE);
                string = DicomCleaner.this.showInputDialogToSelectNetworkTargetByLocalApplicationEntityName(DicomCleaner.this.resourceBundle.getString("sendSelectMessage"), DicomCleaner.this.resourceBundle.getString("sendSelectDialogTitle") + " ...", string);
                if (string != null && DicomCleaner.this.networkApplicationProperties != null) {
                    try {
                        String string2 = DicomCleaner.this.networkApplicationProperties.getCallingAETitle();
                        String string3 = DicomCleaner.this.networkApplicationInformation.getApplicationEntityTitleFromLocalName(string);
                        PresentationAddress presentationAddress = DicomCleaner.this.networkApplicationInformation.getApplicationEntityMap().getPresentationAddress(string3);
                        String string4 = presentationAddress.getHostname();
                        int n = presentationAddress.getPort();
                        int n2 = DicomCleaner.this.networkApplicationProperties.getInitiatorMaximumLengthReceived();
                        int n3 = DicomCleaner.this.networkApplicationProperties.getInitiatorSocketReceiveBufferSize();
                        int n4 = DicomCleaner.this.networkApplicationProperties.getInitiatorSocketSendBufferSize();
                        SetOfDicomFiles setOfDicomFiles = new SetOfDicomFiles(DicomCleaner.this.currentDestinationFilePathSelections);
                        new Thread(new SendWorker(string4, n, string3, string2, n2, n3, n4, setOfDicomFiles)).start();
                    }
                    catch (Exception exception) {
                        slf4jlogger.error("", exception);
                    }
                }
            }
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending."));
        }
    }

    protected class SendWorker
    implements Runnable {
        String hostname;
        int port;
        String calledAETitle;
        String callingAETitle;
        SetOfDicomFiles setOfDicomFiles;
        int ourMaximumLengthReceived;
        int socketReceiveBufferSize;
        int socketSendBufferSize;

        SendWorker(String string, int n, String string2, String string3, int n2, int n3, int n4, SetOfDicomFiles setOfDicomFiles) {
            this.hostname = string;
            this.port = n;
            this.calledAETitle = string2;
            this.callingAETitle = string3;
            this.ourMaximumLengthReceived = n2;
            this.socketReceiveBufferSize = n3;
            this.socketSendBufferSize = n4;
            this.setOfDicomFiles = setOfDicomFiles;
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Send starting");
            try {
                int n = this.setOfDicomFiles.size();
                SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, 0, n);
                new StorageSOPClassSCU(this.hostname, this.port, this.calledAETitle, this.callingAETitle, this.ourMaximumLengthReceived, this.socketReceiveBufferSize, this.socketSendBufferSize, this.setOfDicomFiles, 0, new OurMultipleInstanceTransferStatusHandler(n, DicomCleaner.this.logger, DicomCleaner.this.progressBarUpdater));
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Send failed: " + exception));
                DicomCleaner.this.logger.sendLn("Send failed");
                slf4jlogger.error("Send failed ", exception);
            }
            SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            DicomCleaner.this.logger.sendLn("Send complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done sending to " + this.calledAETitle));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurMultipleInstanceTransferStatusHandler
    extends MultipleInstanceTransferStatusHandlerWithFileName {
        int nFiles;
        MessageLogger logger;
        SafeProgressBarUpdaterThread progressBarUpdater;

        OurMultipleInstanceTransferStatusHandler(int n, MessageLogger messageLogger, SafeProgressBarUpdaterThread safeProgressBarUpdaterThread) {
            this.nFiles = n;
            this.logger = messageLogger;
            this.progressBarUpdater = safeProgressBarUpdaterThread;
        }

        @Override
        public void updateStatus(int n, int n2, int n3, int n4, String string, String string2, boolean bl) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Remaining " + n + ", completed " + n2 + ", failed " + n3 + ", warning " + n4));
            SafeProgressBarUpdaterThread.updateProgressBar(this.progressBarUpdater, this.nFiles - n);
            if (this.logger != null) {
                this.logger.sendLn((bl ? "Sent " : "Failed to send ") + string2);
            }
        }
    }

    protected class ExportActionListener
    implements ActionListener {
        protected ExportActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (DicomCleaner.this.currentDestinationFilePathSelections != null && DicomCleaner.this.currentDestinationFilePathSelections.size() > 0) {
                SafeFileChooser safeFileChooser = new SafeFileChooser(DicomCleaner.this.exportDirectoryPath);
                safeFileChooser.setFileSelectionMode(1);
                if (safeFileChooser.showOpenDialog(DicomCleaner.this.getContentPane()) == 0) {
                    try {
                        DicomCleaner.this.exportDirectoryPath = safeFileChooser.getSelectedFile().getCanonicalPath();
                        File file = new File(DicomCleaner.this.exportDirectoryPath);
                        new Thread(new ExportWorker(DicomCleaner.this.currentDestinationFilePathSelections, file)).start();
                    }
                    catch (Exception exception) {
                        ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Export failed: " + exception));
                        slf4jlogger.error("Export failed ", exception);
                    }
                }
            }
        }
    }

    protected class ExportWorker
    implements Runnable {
        Vector destinationFilePathSelections;
        File exportDirectory;

        ExportWorker(Vector vector, File file) {
            this.destinationFilePathSelections = vector;
            this.exportDirectory = file;
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Export started");
            try {
                Object object;
                Object object2;
                Object object3;
                int n = this.destinationFilePathSelections.size();
                SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, 0, n + 1);
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    object3 = (String)this.destinationFilePathSelections.get(i);
                    object2 = DicomCleaner.this.hierarchicalExportCheckBox.isSelected() ? DicomCleaner.this.makeNewFullyQualifiedHierarchicalInstancePathName((String)object3) : DicomCleaner.this.makeNewFullyQualifiedInterchangeMediaInstancePathName(i);
                    object = new File(this.exportDirectory, (String)object2);
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Exporting " + (String)object2));
                    DicomCleaner.this.logger.sendLn("Exporting " + (String)object3 + " to " + ((File)object).getCanonicalPath());
                    ((File)object).getParentFile().mkdirs();
                    CopyStream.copy(new File((String)object3), (File)object);
                    stringArray[i] = object2;
                    SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, i + 1);
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Exporting DICOMDIR"));
                DicomCleaner.this.logger.sendLn("Exporting DICOMDIR");
                DicomDirectory dicomDirectory = new DicomDirectory(this.exportDirectory, stringArray);
                dicomDirectory.write(new File(this.exportDirectory, nameForDicomDirectoryOnInterchangeMedia).getCanonicalPath());
                SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, n + 1);
                if (DicomCleaner.this.zipExportCheckBox.isSelected()) {
                    Object object4;
                    Object object5;
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Zipping exported files"));
                    DicomCleaner.this.logger.sendLn("Zipping exported files");
                    object3 = new File(this.exportDirectory, exportedZipFileName);
                    ((File)object3).delete();
                    object2 = new FileOutputStream((File)object3);
                    object = new ZipOutputStream((OutputStream)object2);
                    ((ZipOutputStream)object).setMethod(8);
                    ((ZipOutputStream)object).setLevel(9);
                    SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, 0, n + 1);
                    for (int i = 0; i < n; ++i) {
                        object5 = stringArray[i];
                        object4 = new File(this.exportDirectory, (String)object5);
                        ZipEntry zipEntry = new ZipEntry((String)object5);
                        ((ZipOutputStream)object).putNextEntry(zipEntry);
                        FileInputStream fileInputStream = new FileInputStream((File)object4);
                        CopyStream.copy(fileInputStream, (OutputStream)object);
                        ((ZipOutputStream)object).closeEntry();
                        fileInputStream.close();
                        ((File)object4).delete();
                        SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, i + 1);
                    }
                    File file = new File(this.exportDirectory, nameForDicomDirectoryOnInterchangeMedia);
                    object5 = new ZipEntry(nameForDicomDirectoryOnInterchangeMedia);
                    ((ZipEntry)object5).setMethod(8);
                    ((ZipOutputStream)object).putNextEntry((ZipEntry)object5);
                    object4 = new FileInputStream(file);
                    CopyStream.copy((InputStream)object4, (OutputStream)object);
                    ((ZipOutputStream)object).closeEntry();
                    ((FileInputStream)object4).close();
                    file.delete();
                    SafeProgressBarUpdaterThread.updateProgressBar(DicomCleaner.this.progressBarUpdater, n + 1);
                    ((ZipOutputStream)object).close();
                    ((FileOutputStream)object2).close();
                    new File(this.exportDirectory, rootNameForDicomInstanceFilesOnInterchangeMedia).delete();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Export failed: " + exception));
                slf4jlogger.error("Export failed ", exception);
            }
            SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            DicomCleaner.this.logger.sendLn("Export complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done exporting to " + this.exportDirectory));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class ImportActionListener
    implements ActionListener {
        protected ImportActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (DicomCleaner.this.logger instanceof DialogMessageLogger) {
                    ((DialogMessageLogger)DicomCleaner.this.logger).setVisible(true);
                }
                if (DicomCleaner.this.importDirectoryPath == null || DicomCleaner.this.importDirectoryPath.length() == 0) {
                    DicomCleaner.this.importDirectoryPath = "/";
                }
                SafeFileChooser safeFileChooser = new SafeFileChooser(DicomCleaner.this.importDirectoryPath);
                safeFileChooser.setFileSelectionMode(2);
                if (safeFileChooser.showOpenDialog(DicomCleaner.this.getContentPane()) == 0) {
                    DicomCleaner.this.importDirectoryPath = safeFileChooser.getCurrentDirectory().getAbsolutePath();
                    String string = safeFileChooser.getSelectedFile().getAbsolutePath();
                    new Thread(new ImportWorker(string, DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel)).start();
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                slf4jlogger.error("Importing failed ", exception);
            }
        }
    }

    protected class ImportWorker
    implements Runnable {
        MediaImporter importer;
        DatabaseInformationModel srcDatabase;
        JPanel srcDatabasePanel;
        String pathName;

        ImportWorker(String string, DatabaseInformationModel databaseInformationModel, JPanel jPanel) {
            this.importer = new OurMediaImporter(DicomCleaner.this.logger, DicomCleaner.this.progressBarUpdater.getProgressBar(), DicomCleaner.this.acceptAnyTransferSyntaxCheckBox.isSelected());
            this.srcDatabase = databaseInformationModel;
            this.srcDatabasePanel = jPanel;
            this.pathName = string;
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Import starting");
            SafeProgressBarUpdaterThread.startProgressBar(DicomCleaner.this.progressBarUpdater);
            try {
                this.importer.importDicomFiles(this.pathName);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Importing failed: " + exception));
                slf4jlogger.error("Importing failed ", exception);
            }
            this.srcDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(this.srcDatabase, this.srcDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                slf4jlogger.error("Refresh source database browser failed ", exception);
            }
            this.srcDatabasePanel.validate();
            SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done importing"));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurMediaImporter
    extends MediaImporter {
        boolean acceptAnyTransferSyntax;
        protected boolean canUseBzip;

        public OurMediaImporter(MessageLogger messageLogger, JProgressBar jProgressBar, boolean bl) {
            super(messageLogger, jProgressBar);
            this.canUseBzip = CapabilitiesAvailable.haveBzip2Support();
            this.acceptAnyTransferSyntax = bl;
        }

        @Override
        protected void doSomethingWithDicomFileOnMedia(String string) {
            try {
                this.logger.sendLn("Importing DICOM file: " + string);
                DicomCleaner.importFileIntoDatabase(DicomCleaner.this.srcDatabase, string, "R", DicomCleaner.this.earliestDatesIndexedBySourceFilePath);
            }
            catch (Exception exception) {
                slf4jlogger.error("Importing DICOM file {} failed", string, exception);
            }
        }

        @Override
        protected boolean isOKToImport(String string, String string2) {
            slf4jlogger.debug("isOKToImport(): transferSyntaxUID {}", string2);
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("isOKToImport(): {}", string2 != null && string2.length() > 0 ? new TransferSyntax(string2).dump() : "");
            }
            slf4jlogger.debug("isOKToImport(): sopClassUID {}", string);
            slf4jlogger.debug("isOKToImport(): isImageStorage {}", SOPClass.isImageStorage(string));
            return string != null && (SOPClass.isImageStorage(string) || SOPClass.isNonImageStorage(string) && !SOPClass.isDirectory(string)) && (string2 == null || this.acceptAnyTransferSyntax && new TransferSyntax(string2).isRecognized() || string2.equals("1.2.840.10008.1.2") || string2.equals("1.2.840.10008.1.2.1") || string2.equals("1.2.840.10008.1.2.2") || string2.equals("1.2.840.10008.1.2.1.99") || string2.equals("1.3.6.1.4.1.5962.300.1") && this.canUseBzip || string2.equals("1.2.840.10008.1.2.5") || string2.equals("1.2.840.10008.1.2.4.50") || CapabilitiesAvailable.haveJPEGLosslessCodec() && (string2.equals("1.2.840.10008.1.2.4.57") || string2.equals("1.2.840.10008.1.2.4.70")) || CapabilitiesAvailable.haveJPEG2000Part1Codec() && (string2.equals("1.2.840.10008.1.2.4.91") || string2.equals("1.2.840.10008.1.2.4.90")) || CapabilitiesAvailable.haveJPEGLSCodec() && (string2.equals("1.2.840.10008.1.2.4.80") || string2.equals("1.2.840.10008.1.2.4.81")));
        }
    }

    protected class CleanActionListener
    implements ActionListener {
        protected CleanActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DicomCleaner.this.activeThread = new Thread(new CleanWorker(DicomCleaner.this.currentSourceFilePathSelections, DicomCleaner.this.dstDatabase, DicomCleaner.this.dstDatabasePanel, DicomCleaner.this.earliestDatesIndexedBySourceFilePath));
                DicomCleaner.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaning failed: " + exception));
                slf4jlogger.error("Cleaning failed ", exception);
            }
        }
    }

    protected class CleanWorker
    implements Runnable {
        Vector sourceFilePathSelections;
        DatabaseInformationModel dstDatabase;
        JPanel dstDatabasePanel;
        Map<String, Date> earliestDatesIndexedBySourceFilePath;

        CleanWorker(Vector vector, DatabaseInformationModel databaseInformationModel, JPanel jPanel, Map<String, Date> map) {
            this.sourceFilePathSelections = vector;
            this.dstDatabase = databaseInformationModel;
            this.dstDatabasePanel = jPanel;
            this.earliestDatesIndexedBySourceFilePath = map;
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Cleaning started");
            SafeProgressBarUpdaterThread.startProgressBar(DicomCleaner.this.progressBarUpdater);
            long l = System.currentTimeMillis();
            Date date = DicomCleaner.findEarliestDate(this.earliestDatesIndexedBySourceFilePath, this.sourceFilePathSelections);
            try {
                if (!DicomCleaner.this.copyFromOriginalToCleanedPerformingAction(this.sourceFilePathSelections, date, DicomCleaner.this.logger, DicomCleaner.this.progressBarUpdater)) {
                    ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaning (partially) failed: "));
                }
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Cleaning failed: " + exception));
                slf4jlogger.error("Cleaning failed ", exception);
            }
            slf4jlogger.info("CleanWorker.run(): cleaning time = {}", System.currentTimeMillis() - l);
            this.dstDatabasePanel.removeAll();
            try {
                new OurDestinationDatabaseTreeBrowser(this.dstDatabase, this.dstDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh destination database browser failed: " + exception));
                slf4jlogger.error("Refresh destination database browser failed ", exception);
            }
            this.dstDatabasePanel.validate();
            SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            DicomCleaner.this.logger.sendLn("Cleaning complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done cleaning"));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class PurgeActionListener
    implements ActionListener {
        protected PurgeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                DicomCleaner.this.activeThread = new Thread(new PurgeWorker());
                DicomCleaner.this.activeThread.start();
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                slf4jlogger.error("Purging failed ", exception);
            }
        }
    }

    protected class PurgeWorker
    implements Runnable {
        protected PurgeWorker() {
        }

        @Override
        public void run() {
            DicomCleaner.this.cursorChanger.setWaitCursor();
            DicomCleaner.this.logger.sendLn("Purging started");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging started"));
            SafeProgressBarUpdaterThread.startProgressBar(DicomCleaner.this.progressBarUpdater);
            try {
                DicomCleaner.this.purgeFilesAndDatabaseInformation(DicomCleaner.this.currentSourceDatabaseSelections, DicomCleaner.this.logger, DicomCleaner.this.progressBarUpdater, 0, 1);
                DicomCleaner.this.purgeFilesAndDatabaseInformation(DicomCleaner.this.currentDestinationDatabaseSelections, DicomCleaner.this.logger, DicomCleaner.this.progressBarUpdater, 0, 1);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Purging failed: " + exception));
                slf4jlogger.error("Purging failed ", exception);
            }
            DicomCleaner.this.srcDatabasePanel.removeAll();
            DicomCleaner.this.dstDatabasePanel.removeAll();
            try {
                new OurSourceDatabaseTreeBrowser(DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel);
                new OurDestinationDatabaseTreeBrowser(DicomCleaner.this.dstDatabase, DicomCleaner.this.dstDatabasePanel);
            }
            catch (Exception exception) {
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Refresh source database browser failed: " + exception));
                slf4jlogger.error("Refresh source database browser failed ", exception);
            }
            DicomCleaner.this.srcDatabasePanel.validate();
            SafeProgressBarUpdaterThread.endProgressBar(DicomCleaner.this.progressBarUpdater);
            DicomCleaner.this.logger.sendLn("Purging complete");
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Done purging"));
            DicomCleaner.this.cursorChanger.restoreCursor();
        }
    }

    protected class OurDestinationDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurDestinationDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        @Override
        protected boolean doSomethingWithSelections(DatabaseTreeRecord[] databaseTreeRecordArray) {
            DicomCleaner.this.currentDestinationDatabaseSelections = databaseTreeRecordArray;
            return false;
        }

        @Override
        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomCleaner.this.currentDestinationFilePathSelections = vector;
        }
    }

    protected class OurSourceDatabaseTreeBrowser
    extends DatabaseTreeBrowser {
        public OurSourceDatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, Container container) throws DicomException {
            super(databaseInformationModel, container);
        }

        @Override
        protected boolean doSomethingWithSelections(DatabaseTreeRecord[] databaseTreeRecordArray) {
            DicomCleaner.this.currentSourceDatabaseSelections = databaseTreeRecordArray;
            return false;
        }

        @Override
        protected void doSomethingWithSelectedFiles(Vector vector) {
            DicomCleaner.this.currentSourceFilePathSelections = vector;
        }
    }

    class OurTransferSyntaxSelectionPolicy
    extends TransferSyntaxSelectionPolicy {
        OurTransferSyntaxSelectionPolicy() {
        }

        @Override
        public LinkedList applyTransferSyntaxSelectionPolicy(LinkedList linkedList, int n) {
            boolean bl = CapabilitiesAvailable.haveBzip2Support();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                PresentationContext presentationContext = (PresentationContext)listIterator.next();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                boolean bl8 = false;
                boolean bl9 = false;
                boolean bl10 = false;
                boolean bl11 = false;
                boolean bl12 = false;
                boolean bl13 = false;
                String string = null;
                List list = presentationContext.getTransferSyntaxUIDs();
                ListIterator listIterator2 = list.listIterator();
                while (listIterator2.hasNext()) {
                    String string2 = (String)listIterator2.next();
                    if (string2 == null) continue;
                    if (string2.equals("1.2.840.10008.1.2")) {
                        bl3 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.1")) {
                        bl2 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.2")) {
                        bl4 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.1.99")) {
                        bl5 = true;
                        continue;
                    }
                    if (string2.equals("1.3.6.1.4.1.5962.300.1")) {
                        bl6 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.50")) {
                        bl7 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.57")) {
                        bl8 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.70")) {
                        bl9 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.91")) {
                        bl10 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.90")) {
                        bl11 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.80")) {
                        bl12 = true;
                        continue;
                    }
                    if (string2.equals("1.2.840.10008.1.2.4.81")) {
                        bl13 = true;
                        continue;
                    }
                    if (!new TransferSyntax(string2).isRecognized()) continue;
                    string = string2;
                }
                presentationContext.newTransferSyntaxUIDs();
                if (bl6 && bl) {
                    presentationContext.addTransferSyntaxUID("1.3.6.1.4.1.5962.300.1");
                    continue;
                }
                if (bl5) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1.99");
                    continue;
                }
                if (bl2) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.1");
                    continue;
                }
                if (bl4) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.2");
                    continue;
                }
                if (bl3) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2");
                    continue;
                }
                if (bl7) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.50");
                    continue;
                }
                if (bl8 && CapabilitiesAvailable.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.57");
                    continue;
                }
                if (bl9 && CapabilitiesAvailable.haveJPEGLosslessCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.70");
                    continue;
                }
                if (bl10 && CapabilitiesAvailable.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.91");
                    continue;
                }
                if (bl11 && CapabilitiesAvailable.haveJPEG2000Part1Codec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.90");
                    continue;
                }
                if (bl12 && CapabilitiesAvailable.haveJPEGLSCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.80");
                    continue;
                }
                if (bl13 && CapabilitiesAvailable.haveJPEGLSCodec()) {
                    presentationContext.addTransferSyntaxUID("1.2.840.10008.1.2.4.81");
                    continue;
                }
                if (DicomCleaner.this.acceptAnyTransferSyntaxCheckBox.isSelected() && string != null) {
                    presentationContext.addTransferSyntaxUID(string);
                    continue;
                }
                presentationContext.setResultReason((byte)4);
            }
            return linkedList;
        }
    }

    class OurPresentationContextSelectionPolicy
    extends UnencapsulatedExplicitStoreFindMoveGetPresentationContextSelectionPolicy {
        OurPresentationContextSelectionPolicy() {
            this.transferSyntaxSelectionPolicy = new OurTransferSyntaxSelectionPolicy();
        }
    }

    protected class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        protected OurReceivedObjectHandler() {
        }

        @Override
        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                String string4 = DicomCleaner.this.networkApplicationInformation.getLocalNameFromApplicationEntityTitle(string3);
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new StatusChangeEvent("Received " + string + " from " + string3 + " in " + string2));
                DicomCleaner.this.logger.sendLn("Received " + string + " from " + string4 + " (" + string3 + ")");
                try {
                    DicomCleaner.importFileIntoDatabase(DicomCleaner.this.srcDatabase, string, "C", DicomCleaner.this.earliestDatesIndexedBySourceFilePath);
                    DicomCleaner.this.srcDatabasePanel.removeAll();
                    new OurSourceDatabaseTreeBrowser(DicomCleaner.this.srcDatabase, DicomCleaner.this.srcDatabasePanel);
                    DicomCleaner.this.srcDatabasePanel.validate();
                    new File(string).deleteOnExit();
                }
                catch (Exception exception) {
                    slf4jlogger.error("Unable to insert {} received from {} in {} into database", string, string3, string2, exception);
                }
            }
        }
    }
}

