/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.TextAnnotation;
import com.pixelmed.display.WindowCenterAndWidth;
import com.pixelmed.event.EventContext;
import com.pixelmed.geometry.GeometryOfVolume;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SingleImagePanelWithLineDrawing
extends SingleImagePanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanelWithLineDrawing.java,v 1.16 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(WindowCenterAndWidth.class);
    protected Point2D startPoint;
    static final int crossSize = 5;

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, geometryOfVolume);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage, EventContext eventContext) {
        super(sourceImage, eventContext);
    }

    public SingleImagePanelWithLineDrawing(SourceImage sourceImage) {
        super(sourceImage);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            this.setSelectedDrawingShapes(null);
            this.repaint();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.checkForHitOnPersistentShapes(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dragInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.startInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.endInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    protected void startInteractiveDrawing(int n, int n2) {
        this.startPoint = this.getImageCoordinateFromWindowCoordinate(n, n2);
    }

    protected void dragInteractiveDrawing(int n, int n2) {
        double d = this.startPoint.getX();
        double d2 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        if (d != d3 || d2 != d4) {
            this.interactiveDrawingShapes = new Vector();
            this.interactiveDrawingShapes.add(new Line2D.Float(this.startPoint, point2D));
            this.repaint();
        }
    }

    protected void endInteractiveDrawing(int n, int n2) {
        double d = this.startPoint.getX();
        double d2 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        if (d != d3 || d2 != d4) {
            double d5 = d3 - d;
            double d6 = d4 - d2;
            double d7 = Math.sqrt(d5 * d5 + d6 * d6);
            DecimalFormat decimalFormat = new DecimalFormat("###.#");
            String string = decimalFormat.format(d7) + " pixels";
            if (this.pixelSpacingInSourceImage > 0.0) {
                slf4jlogger.debug("endInteractiveDrawing(): pixelSpacingInSourceImage >0, ={}", this.pixelSpacingInSourceImage);
                string = decimalFormat.format(d7 * this.pixelSpacingInSourceImage) + " mm" + (this.typeOfPixelSpacing == null ? " " : " (" + this.typeOfPixelSpacing + ")");
            } else if (this.imageGeometry != null && this.imageGeometry.hasFrameInformation()) {
                slf4jlogger.info("endInteractiveDrawing(): imageGeometry != null and hasFrameInformation()");
                int n3 = this.currentSrcImageSortOrder == null ? this.currentSrcImageIndex : this.currentSrcImageSortOrder[this.currentSrcImageIndex];
                double[] dArray = new double[3];
                double[] dArray2 = new double[3];
                this.imageGeometry.lookupImageCoordinate(dArray, d, d2, n3);
                this.imageGeometry.lookupImageCoordinate(dArray2, d3, d4, n3);
                double d8 = dArray2[0] - dArray[0];
                double d9 = dArray2[1] - dArray[1];
                double d10 = dArray2[2] - dArray[2];
                double d11 = Math.sqrt(d8 * d8 + d9 * d9 + d10 * d10);
                string = decimalFormat.format(d11) + " mm (3D NSQ)";
            } else {
                slf4jlogger.debug("endInteractiveDrawing(): no information - use pixels");
                string = decimalFormat.format(d7) + " pixels";
            }
            slf4jlogger.debug("endInteractiveDrawing(): Length={} pixels, {}", d7, string);
            this.interactiveDrawingShapes = null;
            if (this.persistentDrawingShapes == null) {
                this.persistentDrawingShapes = new Vector();
            }
            this.persistentDrawingShapes.add(new Line2D.Float(this.startPoint, point2D));
            if (this.persistentDrawingText == null) {
                this.persistentDrawingText = new Vector();
            }
            this.persistentDrawingText.add(new TextAnnotation(string, d3, d4));
            this.repaint();
        }
    }

    protected void checkForHitOnPersistentShapes(int n, int n2) {
        Shape shape;
        Iterator iterator;
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        int n3 = (int)point2D.getX();
        int n4 = (int)point2D.getY();
        boolean bl = false;
        Vector<Shape> vector = new Vector<Shape>();
        if (this.selectedDrawingShapes != null) {
            iterator = this.selectedDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(n3, n4)) continue;
                vector.add(shape);
                if (this.persistentDrawingShapes == null) {
                    this.persistentDrawingShapes = new Vector();
                }
                this.persistentDrawingShapes.add(shape);
                this.selectedDrawingShapes.remove(shape);
                iterator = this.selectedDrawingShapes.iterator();
                bl = true;
            }
        }
        if (this.persistentDrawingShapes != null) {
            iterator = this.persistentDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(n3, n4)) continue;
                if (this.selectedDrawingShapes == null) {
                    this.selectedDrawingShapes = new Vector();
                }
                this.selectedDrawingShapes.add(shape);
                this.persistentDrawingShapes.remove(shape);
                iterator = this.persistentDrawingShapes.iterator();
                bl = true;
            }
        }
        if (bl) {
            this.repaint();
        }
    }
}

