/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.SingleImagePanel;
import com.pixelmed.display.SourceImage;
import com.pixelmed.display.event.RegionSelectionChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.geometry.GeometryOfVolume;
import java.awt.Shape;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.SwingUtilities;

class SingleImagePanelWithRegionDrawing
extends SingleImagePanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SingleImagePanelWithRegionDrawing.java,v 1.14 2025/01/29 10:58:07 dclunie Exp $";
    private double regionSelectionCenterX;
    private double regionSelectionCenterY;
    private double regionSelectionTLHCX;
    private double regionSelectionTLHCY;
    private double regionSelectionBRHCX;
    private double regionSelectionBRHCY;
    protected Point2D startPoint;
    static final int crossSize = 5;

    public SingleImagePanelWithRegionDrawing(SourceImage sourceImage, EventContext eventContext, int[] nArray, Vector vector, Vector vector2, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, nArray, vector, vector2, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDrawing(SourceImage sourceImage, EventContext eventContext, GeometryOfVolume geometryOfVolume) {
        super(sourceImage, eventContext, geometryOfVolume);
    }

    public SingleImagePanelWithRegionDrawing(SourceImage sourceImage, EventContext eventContext) {
        super(sourceImage, eventContext);
    }

    public SingleImagePanelWithRegionDrawing(SourceImage sourceImage) {
        super(sourceImage);
    }

    private void setRegionSelection(double d, double d2, double d3, double d4, double d5, double d6) {
        this.regionSelectionCenterX = d;
        this.regionSelectionCenterY = d2;
        if (d3 < d5) {
            this.regionSelectionTLHCX = d3;
            this.regionSelectionBRHCX = d5;
        } else {
            this.regionSelectionTLHCX = d5;
            this.regionSelectionBRHCX = d3;
        }
        if (d4 < d6) {
            this.regionSelectionTLHCY = d4;
            this.regionSelectionBRHCY = d6;
        } else {
            this.regionSelectionTLHCY = d6;
            this.regionSelectionBRHCY = d4;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
            this.setSelectedDrawingShapes(null);
            this.repaint();
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.checkForHitOnPersistentShapes(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.dragInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mouseDragged(mouseEvent);
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        super.mouseMoved(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.startInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
        } else {
            super.mousePressed(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.endInteractiveDrawing(mouseEvent.getX(), mouseEvent.getY());
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new RegionSelectionChangeEvent(this.typeOfPanelEventContext, this.regionSelectionCenterX, this.regionSelectionCenterY, this.regionSelectionTLHCX, this.regionSelectionTLHCY, this.regionSelectionBRHCX, this.regionSelectionBRHCY));
        } else {
            super.mouseReleased(mouseEvent);
        }
    }

    protected Shape makeNewDrawingShape(double d, double d2, double d3, double d4) {
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    protected void startInteractiveDrawing(int n, int n2) {
        this.startPoint = this.getImageCoordinateFromWindowCoordinate(n, n2);
    }

    protected void dragInteractiveDrawing(int n, int n2) {
        double d = this.startPoint.getX();
        double d2 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        if (d != d3 || d2 != d4) {
            this.interactiveDrawingShapes = new Vector();
            this.interactiveDrawingShapes.add(new Line2D.Double(this.startPoint, point2D));
            double d5 = d;
            double d6 = d3 - d;
            if (d6 < 0.0) {
                d6 = -d6;
                d5 = d3;
            }
            double d7 = d2;
            double d8 = d4 - d2;
            if (d8 < 0.0) {
                d8 = -d8;
                d7 = d4;
            }
            this.interactiveDrawingShapes.add(this.makeNewDrawingShape(d5, d7, d6, d8));
            this.repaint();
        }
    }

    protected void endInteractiveDrawing(int n, int n2) {
        double d = this.startPoint.getX();
        double d2 = this.startPoint.getY();
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        if (d != d3 || d2 != d4) {
            double d5 = d;
            double d6 = d3 - d;
            if (d6 < 0.0) {
                d6 = -d6;
                d5 = d3;
            }
            double d7 = d2;
            double d8 = d4 - d2;
            if (d8 < 0.0) {
                d8 = -d8;
                d7 = d4;
            }
            this.setRegionSelection((d5 + d6) / 2.0, (d7 + d8) / 2.0, d5, d7, d5 + d6, d7 + d8);
            this.interactiveDrawingShapes = null;
            if (this.persistentDrawingShapes == null) {
                this.persistentDrawingShapes = new Vector();
            }
            this.persistentDrawingShapes.add(this.makeNewDrawingShape(d5, d7, d6, d8));
            this.repaint();
        }
    }

    protected void checkForHitOnPersistentShapes(int n, int n2) {
        Shape shape;
        Iterator iterator;
        Point2D point2D = this.getImageCoordinateFromWindowCoordinate(n, n2);
        double d = point2D.getX();
        double d2 = point2D.getY();
        boolean bl = false;
        Vector<Shape> vector = new Vector<Shape>();
        if (this.selectedDrawingShapes != null) {
            iterator = this.selectedDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(d, d2)) continue;
                vector.add(shape);
                if (this.persistentDrawingShapes == null) {
                    this.persistentDrawingShapes = new Vector();
                }
                this.persistentDrawingShapes.add(shape);
                this.selectedDrawingShapes.remove(shape);
                iterator = this.selectedDrawingShapes.iterator();
                bl = true;
            }
        }
        if (this.persistentDrawingShapes != null) {
            iterator = this.persistentDrawingShapes.iterator();
            while (iterator.hasNext()) {
                shape = (Shape)iterator.next();
                if (vector.contains(shape)) continue;
                vector.add(shape);
                if (!shape.contains(d, d2)) continue;
                if (this.selectedDrawingShapes == null) {
                    this.selectedDrawingShapes = new Vector();
                }
                this.selectedDrawingShapes.add(shape);
                this.persistentDrawingShapes.remove(shape);
                iterator = this.persistentDrawingShapes.iterator();
                bl = true;
            }
        }
        if (bl) {
            this.repaint();
        }
    }
}

