/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.ApplyShutterChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SourceImageShutterSelectorPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImageShutterSelectorPanel.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceImageShutterSelectorPanel.class);
    private EventContext eventContext;
    private ButtonGroup applyShutterButtons;
    private JRadioButton offButton;
    private JRadioButton onButton;
    private static final String onCommand = "ON";
    private static final String offCommand = "OFF";

    public void sendEventCorrespondingToCurrentButtonState() {
        String string = this.applyShutterButtons.getSelection().getActionCommand();
        boolean bl = string != null && string.equals(onCommand);
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new ApplyShutterChangeEvent(this.eventContext, bl));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public SourceImageShutterSelectorPanel(EventContext eventContext) {
        this.eventContext = eventContext;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Apply shutters:"));
        this.applyShutterButtons = new ButtonGroup();
        ApplyShutterActionListener applyShutterActionListener = new ApplyShutterActionListener();
        this.offButton = new JRadioButton("off", false);
        this.offButton.setActionCommand(offCommand);
        this.offButton.setToolTipText("Do not apply shutters");
        this.offButton.addActionListener(applyShutterActionListener);
        this.applyShutterButtons.add(this.offButton);
        jPanel.add(this.offButton);
        this.onButton = new JRadioButton("on", true);
        this.onButton.setActionCommand(onCommand);
        this.onButton.setToolTipText("Apply shutters");
        this.onButton.addActionListener(applyShutterActionListener);
        this.applyShutterButtons.add(this.onButton);
        jPanel.add(this.onButton);
    }

    private class ApplyShutterActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceImageShutterSelectorPanel.this.sendEventCorrespondingToCurrentButtonState();
        }
    }
}

