/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.display.event.WindowLinearCalculationChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.EventContext;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SourceImageWindowLinearCalculationSelectorPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceImageWindowLinearCalculationSelectorPanel.java,v 1.12 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceImageWindowLinearCalculationSelectorPanel.class);
    private EventContext eventContext;
    private ButtonGroup windowLinearCalculationButtons;
    private JRadioButton dicomButton;
    private JRadioButton exactButton;

    public void sendEventCorrespondingToCurrentButtonState() {
        String string = this.windowLinearCalculationButtons.getSelection().getActionCommand();
        try {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new WindowLinearCalculationChangeEvent(this.eventContext, string));
        }
        catch (Exception exception) {
            slf4jlogger.error("", exception);
        }
    }

    public SourceImageWindowLinearCalculationSelectorPanel(EventContext eventContext) {
        this.eventContext = eventContext;
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Window calculation:"));
        this.windowLinearCalculationButtons = new ButtonGroup();
        WindowLinearCalculationChangeActionListener windowLinearCalculationChangeActionListener = new WindowLinearCalculationChangeActionListener();
        this.dicomButton = new JRadioButton("DICOM", true);
        this.dicomButton.setActionCommand("DICOM");
        this.dicomButton.setToolTipText("Use DICOM offset calculation (-0.5 center, -1.0 width)");
        this.dicomButton.addActionListener(windowLinearCalculationChangeActionListener);
        this.windowLinearCalculationButtons.add(this.dicomButton);
        jPanel.add(this.dicomButton);
        this.exactButton = new JRadioButton("exact", false);
        this.exactButton.setActionCommand("EXACT");
        this.exactButton.setToolTipText("Use exact calculation without any offset");
        this.exactButton.addActionListener(windowLinearCalculationChangeActionListener);
        this.windowLinearCalculationButtons.add(this.exactButton);
        jPanel.add(this.exactButton);
    }

    private class WindowLinearCalculationChangeActionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SourceImageWindowLinearCalculationSelectorPanel.this.sendEventCorrespondingToCurrentButtonState();
        }
    }
}

