/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.AttributeTagAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.display.event.FrameSelectionChangeEvent;
import com.pixelmed.display.event.FrameSortOrderChangeEvent;
import com.pixelmed.event.ApplicationEventDispatcher;
import com.pixelmed.event.Event;
import com.pixelmed.event.EventContext;
import com.pixelmed.event.SelfRegisteringListener;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

abstract class SourceInstanceSortOrderPanel
extends JPanel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceInstanceSortOrderPanel.java,v 1.29 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceInstanceSortOrderPanel.class);
    protected EventContext typeOfPanelEventContext;
    protected int nSrcInstances;
    protected int currentSrcInstanceIndex;
    protected int[] currentSrcInstanceSortOrder;
    protected AttributeList currentSrcInstanceAttributeList;
    protected ButtonGroup sortOrderButtons;
    protected JRadioButton byFrameOrderButton;
    protected JRadioButton byDimensionOrderButton;
    protected JPanel dimensionIndexPanel;
    protected JPanel cineSliderControlsPanel;
    protected JSlider cineSlider;
    protected int currentSliderMinimum;
    protected int currentSliderMaximum;
    protected ChangeListener cineSliderChangeListener;
    protected boolean active;
    protected static final String implicitActionCommand = "IMP";
    protected static final String dimensionActionCommand = "DIM";
    protected OurFrameSelectionChangeListener ourFrameSelectionChangeListener;
    protected OurFrameSortOrderChangeListener ourFrameSortOrderChangeListener;

    protected Vector buildListOfDimensionsFromAttributeList(AttributeList attributeList) {
        Vector<String> vector = new Vector<String>();
        try {
            SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.DimensionIndexSequence);
            if (sequenceAttribute != null) {
                Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
                while (iterator.hasNext()) {
                    AttributeTagAttribute attributeTagAttribute;
                    SequenceItem sequenceItem = iterator.next();
                    AttributeList attributeList2 = sequenceItem.getAttributeList();
                    if (attributeList2 == null) continue;
                    String string = Attribute.getSingleStringValueOrNull(attributeList2, TagFromName.DimensionDescriptionLabel);
                    if ((string == null || string.length() == 0) && (attributeTagAttribute = (AttributeTagAttribute)attributeList2.get(TagFromName.DimensionIndexPointer)) != null && attributeTagAttribute.getVM() > 0) {
                        AttributeTag attributeTag = attributeTagAttribute.getAttributeTagValues()[0];
                        if (attributeTag == null) {
                            string = "NOT SPECIFIED";
                        } else {
                            string = attributeList2.getDictionary().getNameFromTag(attributeTag);
                            if (string == null || string.length() == 0) {
                                string = attributeTag.toString();
                            }
                        }
                    }
                    assert (string != null);
                    vector.add(string);
                }
            }
        }
        catch (DicomException dicomException) {
            slf4jlogger.error("", dicomException);
        }
        return vector;
    }

    protected void replaceListOfDimensions(Vector vector) {
        this.dimensionIndexPanel.removeAll();
        if (vector != null && vector.size() > 0) {
            this.dimensionIndexPanel.add(new JLabel("Dimensions in image:"));
            this.dimensionIndexPanel.add(new JList(vector));
        }
    }

    protected void updateCineSlider(int n, int n2, int n3) {
        slf4jlogger.debug("updateCineSlider(): min = {}", n);
        slf4jlogger.debug("updateCineSlider(): max = {}", n2);
        slf4jlogger.debug("updateCineSlider(): value = {}", n3);
        slf4jlogger.debug("updateCineSlider(): currentSliderMinimum = {}", this.currentSliderMinimum);
        slf4jlogger.debug("updateCineSlider(): currentSliderMaximum = {}", this.currentSliderMaximum);
        if (n != this.currentSliderMinimum || n2 != this.currentSliderMaximum) {
            slf4jlogger.debug("updateCineSlider(): removing and rebuilding slider (if needed)");
            this.cineSliderControlsPanel.removeAll();
            if (n2 > n) {
                this.cineSlider = new JSlider(n, n2, n3);
                this.cineSlider.setLabelTable(this.cineSlider.createStandardLabels(n2 - 1, n));
                this.cineSlider.setPaintLabels(true);
                this.cineSliderControlsPanel.add(new JLabel("Frame index:"));
                this.cineSliderControlsPanel.add(this.cineSlider);
                this.cineSlider.addChangeListener(this.cineSliderChangeListener);
            } else {
                slf4jlogger.debug("updateCineSlider(): slider not needed");
                this.cineSlider = null;
            }
            this.currentSliderMinimum = n;
            this.currentSliderMaximum = n2;
        }
        if (this.cineSlider != null && this.cineSlider.getValue() != n3) {
            this.cineSlider.setValue(n3);
        }
    }

    protected SourceInstanceSortOrderPanel() {
    }

    public SourceInstanceSortOrderPanel(EventContext eventContext) {
        this.active = false;
        this.typeOfPanelEventContext = eventContext;
        this.ourFrameSelectionChangeListener = new OurFrameSelectionChangeListener(eventContext);
        this.ourFrameSortOrderChangeListener = new OurFrameSortOrderChangeListener(eventContext);
        this.nSrcInstances = 0;
        this.currentSrcInstanceSortOrder = null;
        this.currentSrcInstanceIndex = 0;
        this.currentSrcInstanceAttributeList = null;
        this.currentSliderMinimum = 0;
        this.currentSliderMaximum = 0;
        this.setLayout(new BoxLayout(this, 1));
        this.cineSliderControlsPanel = new JPanel();
        this.add(this.cineSliderControlsPanel);
        this.cineSliderChangeListener = new CineSliderChangeListener();
        JPanel jPanel = new JPanel();
        this.add(jPanel);
        jPanel.setLayout(new FlowLayout(1));
        jPanel.add(new JLabel("Sort frames by:"));
        this.sortOrderButtons = new ButtonGroup();
        SortActionListener sortActionListener = new SortActionListener();
        this.byFrameOrderButton = new JRadioButton("implicit", false);
        this.byFrameOrderButton.setActionCommand(implicitActionCommand);
        this.byFrameOrderButton.setToolTipText("Sort frames by implicit order in which frames are stored");
        this.byFrameOrderButton.addActionListener(sortActionListener);
        this.sortOrderButtons.add(this.byFrameOrderButton);
        jPanel.add(this.byFrameOrderButton);
        this.byDimensionOrderButton = new JRadioButton("dimension", false);
        this.byDimensionOrderButton.setActionCommand(dimensionActionCommand);
        this.byDimensionOrderButton.setToolTipText("Sort frames by dimension order");
        this.byDimensionOrderButton.addActionListener(sortActionListener);
        this.sortOrderButtons.add(this.byDimensionOrderButton);
        jPanel.add(this.byDimensionOrderButton);
        this.dimensionIndexPanel = new JPanel();
        this.add(this.dimensionIndexPanel);
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    protected class SortActionListener
    implements ActionListener {
        protected SortActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = SourceInstanceSortOrderPanel.this.sortOrderButtons.getSelection().getActionCommand();
            try {
                int[] nArray = null;
                if (string.equals(SourceInstanceSortOrderPanel.dimensionActionCommand) && SourceInstanceSortOrderPanel.this.currentSrcInstanceAttributeList != null) {
                    nArray = new MapOfIndexValuesToFrameNumber(SourceInstanceSortOrderPanel.this.currentSrcInstanceAttributeList).getFrameNumberArray();
                }
                ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSortOrderChangeEvent(SourceInstanceSortOrderPanel.this.typeOfPanelEventContext, nArray, 0));
            }
            catch (Exception exception) {
                slf4jlogger.error("", exception);
            }
        }
    }

    protected class CineSliderChangeListener
    implements ChangeListener {
        protected CineSliderChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ApplicationEventDispatcher.getApplicationEventDispatcher().processEvent(new FrameSelectionChangeEvent(SourceInstanceSortOrderPanel.this.typeOfPanelEventContext, SourceInstanceSortOrderPanel.this.cineSlider.getValue() - 1));
        }
    }

    class OurFrameSortOrderChangeListener
    extends SelfRegisteringListener {
        public OurFrameSortOrderChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSortOrderChangeEvent", eventContext);
        }

        @Override
        public void changed(Event event) {
            FrameSortOrderChangeEvent frameSortOrderChangeEvent = (FrameSortOrderChangeEvent)event;
            SourceInstanceSortOrderPanel.this.currentSrcInstanceSortOrder = frameSortOrderChangeEvent.getSortOrder();
            SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex = frameSortOrderChangeEvent.getIndex();
            SourceInstanceSortOrderPanel.this.updateCineSlider(1, SourceInstanceSortOrderPanel.this.nSrcInstances, SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex + 1);
        }
    }

    protected class OurFrameSelectionChangeListener
    extends SelfRegisteringListener {
        public OurFrameSelectionChangeListener(EventContext eventContext) {
            super("com.pixelmed.display.event.FrameSelectionChangeEvent", eventContext);
            slf4jlogger.debug("SourceInstanceSortOrderPanel.OurFrameSelectionChangeListener():");
        }

        @Override
        public void changed(Event event) {
            FrameSelectionChangeEvent frameSelectionChangeEvent = (FrameSelectionChangeEvent)event;
            if (slf4jlogger.isDebugEnabled()) {
                slf4jlogger.debug("SourceInstanceSortOrderPanel.OurFrameSelectionChangeListener.changed(): event={}" + frameSelectionChangeEvent.toString());
            }
            SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex = frameSelectionChangeEvent.getIndex();
            slf4jlogger.debug("SourceInstanceSortOrderPanel.OurFrameSelectionChangeListener.changed(): currentSrcInstanceIndex = {}", SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex);
            if (SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex != -1) {
                SourceInstanceSortOrderPanel.this.updateCineSlider(1, SourceInstanceSortOrderPanel.this.nSrcInstances, SourceInstanceSortOrderPanel.this.currentSrcInstanceIndex + 1);
            }
        }
    }

    protected class MapOfIndexValuesToFrameNumber {
        int nFrames = 0;
        MapOfIndexValuesToFrameNumberEntry[] map = null;

        MapOfIndexValuesToFrameNumber(AttributeList attributeList) {
            try {
                SequenceAttribute sequenceAttribute = (SequenceAttribute)attributeList.get(TagFromName.PerFrameFunctionalGroupsSequence);
                if (sequenceAttribute != null) {
                    this.nFrames = sequenceAttribute.getNumberOfItems();
                    int n = 0;
                    Iterator<SequenceItem> iterator = sequenceAttribute.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute;
                        SequenceItem sequenceItem;
                        AttributeList attributeList2;
                        SequenceAttribute sequenceAttribute2;
                        int[] nArray = null;
                        SequenceItem sequenceItem2 = iterator.next();
                        AttributeList attributeList3 = sequenceItem2.getAttributeList();
                        if (attributeList3 != null && (sequenceAttribute2 = (SequenceAttribute)attributeList3.get(TagFromName.FrameContentSequence)) != null && sequenceAttribute2.getNumberOfItems() >= 1 && (attributeList2 = (sequenceItem = sequenceAttribute2.getItem(0)).getAttributeList()) != null && (attribute = attributeList2.get(TagFromName.DimensionIndexValues)) != null) {
                            nArray = attribute.getIntegerValues();
                        }
                        if (nArray != null && nArray.length > 0) {
                            if (this.map == null) {
                                this.map = new MapOfIndexValuesToFrameNumberEntry[this.nFrames];
                            }
                            this.map[n] = new MapOfIndexValuesToFrameNumberEntry(nArray, n);
                        }
                        ++n;
                    }
                }
            }
            catch (DicomException dicomException) {
                slf4jlogger.error("", dicomException);
                this.map = null;
            }
            if (this.map != null) {
                Arrays.sort(this.map);
            }
        }

        int[] getFrameNumberArray() {
            int[] nArray = null;
            if (this.map != null) {
                nArray = new int[this.nFrames];
                for (int i = 0; i < this.nFrames; ++i) {
                    nArray[i] = this.map[i].getFrameNumber();
                }
            }
            return nArray;
        }

        void dump(String string) {
            if (this.map != null) {
                for (int i = 0; i < this.nFrames; ++i) {
                    System.err.println(string + " [" + i + "]" + this.map[i]);
                }
            }
        }
    }

    protected class MapOfIndexValuesToFrameNumberEntry
    implements Comparable {
        int[] values;
        int frameNumber;

        public int compareTo(Object object) {
            for (int i = 0; i < this.values.length; ++i) {
                int n = this.values[i] - ((MapOfIndexValuesToFrameNumberEntry)object).values[i];
                if (n == 0) continue;
                return n;
            }
            return 0;
        }

        public boolean equals(Object object) {
            return this.compareTo(object) == 0;
        }

        MapOfIndexValuesToFrameNumberEntry(int[] nArray, int n) {
            this.values = nArray;
            this.frameNumber = n;
        }

        final int getFrameNumber() {
            return this.frameNumber;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("{");
            stringBuffer.append(Integer.toString(this.frameNumber));
            stringBuffer.append("}");
            for (int i = 0; i < this.values.length; ++i) {
                stringBuffer.append(",");
                stringBuffer.append(Integer.toString(this.values[i]));
            }
            return stringBuffer.toString();
        }
    }
}

