/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.display;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.slf4j.Logger;
import com.pixelmed.slf4j.LoggerFactory;
import java.io.IOException;

public class SourceSpectra {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/display/SourceSpectra.java,v 1.19 2025/01/29 10:58:07 dclunie Exp $";
    private static final Logger slf4jlogger = LoggerFactory.getLogger(SourceSpectra.class);
    private float[][] spectra;
    private int rows;
    private int columns;
    private int dataPointRows;
    private int dataPointColumns;
    private int nframes;
    private String dataRepresentation;
    private int nComponents;
    private int whichComponent;
    private int valuesPerFrame;
    private float minimum;
    private float maximum;
    private String title;

    private static String buildInstanceTitleFromAttributeList(AttributeList attributeList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyID));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDate));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesNumber));
        stringBuffer.append("[");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality));
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesDescription));
        stringBuffer.append("]");
        stringBuffer.append(":");
        stringBuffer.append(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.InstanceNumber));
        stringBuffer.append(":");
        return stringBuffer.toString();
    }

    public SourceSpectra(DicomInputStream dicomInputStream) throws IOException, DicomException {
        AttributeList attributeList = new AttributeList();
        attributeList.read(dicomInputStream);
        if (attributeList.get(TagFromName.SpectroscopyData) != null) {
            this.constructSourceSpectra(attributeList);
        }
    }

    public SourceSpectra(AttributeList attributeList) throws DicomException {
        if (attributeList.get(TagFromName.SpectroscopyData) != null) {
            this.constructSourceSpectra(attributeList);
        }
    }

    private void constructSourceSpectra(AttributeList attributeList) throws DicomException {
        this.title = SourceSpectra.buildInstanceTitleFromAttributeList(attributeList);
        this.nframes = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.NumberOfFrames, 1);
        if (this.nframes == 0) {
            slf4jlogger.warn("constructSourceSpectra(): setting invalid NumberOfFrames value of 0 to 1 instead");
            this.nframes = 1;
        }
        this.columns = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0);
        this.rows = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0);
        this.dataPointRows = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.DataPointRows, 1);
        if (this.dataPointRows == 0) {
            slf4jlogger.warn("constructSourceSpectra(): setting invalid DataPointRows value of 0 to 1 instead");
            this.dataPointRows = 1;
        }
        this.dataPointColumns = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.DataPointColumns, 0);
        this.dataRepresentation = Attribute.getSingleStringValueOrDefault(attributeList, TagFromName.DataRepresentation, "REAL");
        this.nComponents = this.dataRepresentation.equals("COMPLEX") ? 2 : 1;
        this.whichComponent = this.nComponents > 1 && this.dataRepresentation.equals("IMAGINARY") ? 1 : 0;
        this.valuesPerFrame = this.columns * this.rows * this.dataPointRows * this.dataPointColumns;
        Attribute attribute = attributeList.get(TagFromName.SpectroscopyData);
        if (attribute == null) {
            throw new DicomException("Spectroscopy data missing");
        }
        long l = (long)this.nframes * (long)this.columns * (long)this.rows * (long)this.dataPointRows * (long)this.dataPointColumns * (long)this.nComponents * 4L;
        long l2 = attribute.getVL();
        if (l != l2) {
            throw new DicomException("Spectroscopy data wrong length: expected " + l + " but got " + l2 + " dec bytes");
        }
        float[] fArray = attribute.getFloatValues();
        this.minimum = Float.MAX_VALUE;
        this.maximum = Float.MIN_VALUE;
        this.spectra = new float[this.nframes][];
        for (int i = 0; i < this.nframes; ++i) {
            this.spectra[i] = new float[this.valuesPerFrame];
            int n = i * this.valuesPerFrame * this.nComponents + this.whichComponent;
            for (int j = 0; j < this.valuesPerFrame; ++j) {
                float f = fArray[n];
                n += this.nComponents;
                this.spectra[i][j] = f;
                if (f < this.minimum) {
                    this.minimum = f;
                }
                if (!(f > this.maximum)) continue;
                this.maximum = f;
            }
        }
    }

    public float[][] getSpectra() {
        return this.spectra;
    }

    public String getTitle() {
        return this.title;
    }

    public int getNumberOfFrames() {
        return this.nframes;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getDataPointRows() {
        return this.dataPointRows;
    }

    public int getDataPointColumns() {
        return this.dataPointColumns;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }
}

