/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.displaywave;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.displaywave.DicomSourceECG;
import com.pixelmed.displaywave.RawSourceECG;
import com.pixelmed.displaywave.SCPSourceECG;
import com.pixelmed.displaywave.SourceECG;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.Locale;
import javax.swing.JComponent;

public class ECGPanel
extends JComponent {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/displaywave/ECGPanel.java,v 1.25 2025/01/29 10:58:08 dclunie Exp $";
    private short[][] samples;
    private int numberOfChannels;
    private int nSamplesPerChannel;
    private int nSamplesPerRow;
    private int nTilesPerColumn;
    private int nTilesPerRow;
    private float samplingIntervalInMilliSeconds;
    private float[] amplitudeScalingFactorInMilliVolts;
    private String[] channelNames;
    private float widthOfPixelInMilliSeconds;
    private float heightOfPixelInMilliVolts;
    private float timeOffsetInMilliSeconds;
    private int[] displaySequence;
    private int width;
    private int height;
    private BufferedImage imageOfRenderedPlot;

    public ECGPanel(short[][] sArray, int n, int n2, String[] stringArray, int n3, int n4, float f, float[] fArray, float f2, float f3, float f4, int[] nArray, int n5, int n6) {
        this.samples = sArray;
        this.numberOfChannels = n;
        this.nSamplesPerChannel = n2;
        this.channelNames = stringArray;
        this.nTilesPerColumn = n3;
        this.nTilesPerRow = n4;
        this.nSamplesPerRow = sArray.length / n3;
        this.samplingIntervalInMilliSeconds = f;
        this.amplitudeScalingFactorInMilliVolts = fArray;
        this.widthOfPixelInMilliSeconds = 1.0f / f2;
        this.heightOfPixelInMilliVolts = 1.0f / f3;
        this.timeOffsetInMilliSeconds = f4;
        this.displaySequence = nArray;
        this.width = n5;
        this.height = n6;
    }

    private void renderPlotToGraphics2D(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        int n;
        Color color = Color.white;
        Color color2 = Color.blue;
        Color color3 = Color.black;
        Color color4 = Color.red;
        Color color5 = Color.black;
        float f = 1.5f;
        float f2 = 2.0f;
        float f3 = 1.0f;
        float f4 = 2.0f;
        Font font = new Font("SansSerif", 1, 14);
        int n2 = 10;
        int n3 = 20;
        graphics2D.setBackground(color);
        graphics2D.setColor(color);
        if (bl) {
            graphics2D.fill(new Rectangle2D.Float(0.0f, 0.0f, rectangle.width, rectangle.height));
        }
        float f5 = (float)this.width / (float)this.nTilesPerRow;
        float f6 = (float)this.height / (float)this.nTilesPerColumn;
        float f7 = this.widthOfPixelInMilliSeconds * f5;
        float f8 = this.heightOfPixelInMilliVolts * f6;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color4);
        float f9 = 0.0f;
        for (n = 0; n < this.nTilesPerColumn; ++n) {
            float f10 = 0.0f;
            for (int i = 0; i < this.nTilesPerRow; ++i) {
                float f11;
                float f12;
                graphics2D.setStroke(new BasicStroke(f3));
                for (f12 = 0.0f; f12 < f7; f12 += 200.0f) {
                    f11 = f10 + f12 / this.widthOfPixelInMilliSeconds;
                    graphics2D.draw(new Line2D.Float(f11, f9, f11, f9 + f6));
                }
                graphics2D.setStroke(new BasicStroke(f3));
                f12 = -f8 / 2.0f;
                while (f12 <= f8 / 2.0f) {
                    f11 = f9 + f6 / 2.0f + f12 / f8 * f6;
                    graphics2D.draw(new Line2D.Float(f10, f11, f10 + f5, f11));
                    f12 = (float)((double)f12 + 0.5);
                }
                f10 += f5;
            }
            f9 += f6;
        }
        graphics2D.setColor(color3);
        graphics2D.setStroke(new BasicStroke(f2));
        f9 = 0.0f;
        n = 0;
        for (int i = 0; i < this.nTilesPerColumn; ++i) {
            float f13 = 0.0f;
            for (int j = 0; j < this.nTilesPerRow; ++j) {
                String string;
                if (i == 0) {
                    graphics2D.draw(new Line2D.Float(f13, f9, f13 + f5, f9));
                }
                if (j == 0) {
                    graphics2D.draw(new Line2D.Float(f13, f9, f13, f9 + f6));
                }
                graphics2D.draw(new Line2D.Float(f13, f9 + f6, f13 + f5, f9 + f6));
                graphics2D.draw(new Line2D.Float(f13 + f5, f9, f13 + f5, f9 + f6));
                if (this.channelNames != null && n < this.displaySequence.length && this.displaySequence[n] < this.channelNames.length && (string = this.channelNames[this.displaySequence[n]]) != null) {
                    graphics2D.setColor(color5);
                    graphics2D.setFont(font);
                    graphics2D.drawString(string, f13 + (float)n2, f9 + (float)n3);
                }
                f13 += f5;
                ++n;
            }
            f9 += f6;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color2);
        graphics2D.setStroke(new BasicStroke(f));
        float f14 = f6 / 2.0f;
        float f15 = this.samplingIntervalInMilliSeconds / this.widthOfPixelInMilliSeconds;
        int n4 = (int)(this.timeOffsetInMilliSeconds / this.samplingIntervalInMilliSeconds);
        int n5 = (int)(f7 / this.samplingIntervalInMilliSeconds);
        int n6 = this.nSamplesPerChannel - n4;
        if (n6 <= 0) {
            return;
        }
        if (n6 > n5) {
            n6 = n5 - 1;
        }
        f9 = 0.0f;
        n = 0;
        GeneralPath generalPath = new GeneralPath();
        for (int i = 0; i < this.nTilesPerColumn && n < this.numberOfChannels; ++i) {
            float f16 = 0.0f;
            for (int j = 0; j < this.nTilesPerRow && n < this.numberOfChannels; ++n, ++j) {
                float f17 = f9 + f14;
                short[] sArray = this.samples[this.displaySequence[n]];
                int n7 = n4;
                float f18 = this.amplitudeScalingFactorInMilliVolts[this.displaySequence[n]] / this.heightOfPixelInMilliVolts;
                float f19 = f16;
                float f20 = f17 - (float)sArray[n7] * f18;
                generalPath.reset();
                generalPath.moveTo(f19, f20);
                ++n7;
                for (int k = 1; k < n6; ++k) {
                    float f21 = f19 + f15;
                    float f22 = f17 - (float)sArray[n7] * f18;
                    ++n7;
                    if ((int)f19 != (int)f21 || (int)f20 != (int)f22) {
                        generalPath.lineTo(f21, f22);
                    }
                    f19 = f21;
                    f20 = f22;
                }
                graphics2D.draw(generalPath);
                f16 += f5;
            }
            f9 += f6;
        }
    }

    private BufferedImage createAppropriateBufferedImageToDrawInto(Rectangle rectangle) {
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
        return new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(rectangle.width, rectangle.height), colorModel.isAlphaPremultiplied(), null);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = new Rectangle(this.width, this.height);
        if (this.imageOfRenderedPlot == null) {
            this.imageOfRenderedPlot = this.createAppropriateBufferedImageToDrawInto(rectangle);
            this.renderPlotToGraphics2D((Graphics2D)this.imageOfRenderedPlot.getGraphics(), rectangle, true);
        }
        graphics.drawImage(this.imageOfRenderedPlot, 0, 0, this);
    }

    public static void main(String[] stringArray) {
        try {
            float f;
            SourceECG sourceECG = null;
            BinaryInputStream binaryInputStream = new BinaryInputStream(new BufferedInputStream(new FileInputStream(stringArray[1])), false);
            int n = 0;
            int n2 = 0;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (stringArray.length == 9 && stringArray[0].toUpperCase(Locale.US).equals("RAW")) {
                int n3 = Integer.parseInt(stringArray[2]);
                int n4 = Integer.parseInt(stringArray[3]);
                n = Integer.parseInt(stringArray[4]);
                n2 = Integer.parseInt(stringArray[5]);
                f = Float.parseFloat(stringArray[6]);
                float f5 = Float.parseFloat(stringArray[7]);
                f4 = Float.parseFloat(stringArray[8]);
                sourceECG = new RawSourceECG(binaryInputStream, n3, n4, f, f5, true);
            } else if (stringArray.length == 5) {
                n = Integer.parseInt(stringArray[2]);
                n2 = Integer.parseInt(stringArray[3]);
                f4 = Float.parseFloat(stringArray[4]);
                if (stringArray[0].toUpperCase(Locale.US).equals("SCPECG")) {
                    sourceECG = new SCPSourceECG(binaryInputStream, true);
                } else if (stringArray[0].toUpperCase(Locale.US).equals("DICOM")) {
                    sourceECG = new DicomSourceECG(binaryInputStream);
                }
            }
            float f6 = 0.35277778f;
            float f7 = 25.0f / (1000.0f * f6);
            f = 10.0f / f6;
            ECGPanel eCGPanel = new ECGPanel(sourceECG.getSamples(), sourceECG.getNumberOfChannels(), sourceECG.getNumberOfSamplesPerChannel(), sourceECG.getChannelNames(), n, n2, sourceECG.getSamplingIntervalInMilliSeconds(), sourceECG.getAmplitudeScalingFactorInMilliVolts(), f7, f, f4, sourceECG.getDisplaySequence(), 800, 400);
            eCGPanel.setPreferredSize(new Dimension(800, 400));
            String string = sourceECG.getTitle();
            ApplicationFrame applicationFrame = new ApplicationFrame(string == null ? "ECG Panel" : string);
            applicationFrame.getContentPane().add(eCGPanel);
            applicationFrame.pack();
            applicationFrame.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

